/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.Config;
import com.l2jserver.gameserver.handler.IVoicedCommandHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class VoicedCommandHandler {
    private static Logger _log = Logger.getLogger(ItemHandler.class.getName());
    private Map<String, IVoicedCommandHandler> _datatable = new FastMap();

    public static VoicedCommandHandler getInstance() {
        return SingletonHolder._instance;
    }

    private VoicedCommandHandler() {
    }

    public void registerVoicedCommandHandler(IVoicedCommandHandler handler) {
        String[] ids = handler.getVoicedCommandList();
        for (int i = 0; i < ids.length; ++i) {
            if (Config.DEBUG) {
                _log.fine("Adding handler for command " + ids[i]);
            }
            this._datatable.put(ids[i], handler);
        }
    }

    public IVoicedCommandHandler getVoicedCommandHandler(String voicedCommand) {
        String command = voicedCommand;
        if (voicedCommand.indexOf(" ") != -1) {
            command = voicedCommand.substring(0, voicedCommand.indexOf(" "));
        }
        if (Config.DEBUG) {
            _log.fine("getting handler for command: " + command + " -> " + (this._datatable.get(command) != null));
        }
        return this._datatable.get(command);
    }

    public int size() {
        return this._datatable.size();
    }

    private static class SingletonHolder {
        protected static final VoicedCommandHandler _instance = new VoicedCommandHandler();

        private SingletonHolder() {
        }
    }
}

