/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.instancemanager.AirShipManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipControllerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.AirShipKnownList;
import com.l2jserver.gameserver.network.serverpackets.ExAirShipInfo;
import com.l2jserver.gameserver.network.serverpackets.ExGetOffAirShip;
import com.l2jserver.gameserver.network.serverpackets.ExGetOnAirShip;
import com.l2jserver.gameserver.network.serverpackets.ExMoveToLocationAirShip;
import com.l2jserver.gameserver.network.serverpackets.ExStopMoveAirShip;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class L2AirShipInstance
extends L2Character {
    public float boatSpeed;
    protected final FastList<L2PcInstance> _passengers = new FastList();
    protected static final Logger _airShiplog = Logger.getLogger(L2AirShipInstance.class.getName());
    protected L2AirShipTrajet _t1;
    protected L2AirShipTrajet _t2;
    protected L2AirShipTrajet _t3;
    protected L2AirShipTrajet _t4;
    protected int _cycle = 0;
    protected int _runstate = 0;
    protected ExMoveToLocationAirShip _easi = null;
    private Map<Integer, L2PcInstance> _inAirShip;
    private int lastx = -1;
    private int lasty = -1;
    private boolean _isInDock = true;

    public L2AirShipInstance(int objectId, L2CharTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2AirShipInstance);
        this.setAI(new L2CharacterAI(new AIAccessor()));
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new AirShipKnownList(this));
    }

    public void moveAirShipToLocation(int x, int y, int z, float speed) {
        int curX = this.getX();
        int curY = this.getY();
        int dx = x - curX;
        int dy = y - curY;
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (Config.DEBUG) {
            _airShiplog.fine("distance to target:" + distance);
        }
        double sin = (double)dy / distance;
        double cos = (double)dx / distance;
        L2Character.MoveData m = new L2Character.MoveData();
        int ticksToMove = (int)(10.0 * distance / (double)speed);
        int heading = (int)(Math.atan2(-sin, -cos) * 10430.378350470453);
        this.getPosition().setHeading(heading += 32768);
        if (Config.DEBUG) {
            _airShiplog.fine("dist:" + distance + "speed:" + speed + " ttt:" + ticksToMove + " heading:" + heading);
        }
        m._xDestination = x;
        m._yDestination = y;
        m._zDestination = z;
        m._heading = 0;
        m.onGeodataPathIndex = -1;
        m._moveStartTime = GameTimeController.getGameTicks();
        if (Config.DEBUG) {
            _airShiplog.fine("time to target:" + ticksToMove);
        }
        this._move = m;
        GameTimeController.getInstance().registerMovingObject(this);
    }

    public void evtArrived() {
        if (this._runstate != 0) {
            AirShiprun asr = new AirShiprun(this._runstate, this);
            ThreadPoolManager.getInstance().executeTask(asr);
        }
    }

    public void airShipControllerShout(int npcId, boolean isArraived) {
        String message = "";
        switch (npcId) {
            case 32607: {
                message = isArraived ? "\u5b9a\u671f\u4fbf\u98db\u884c\u8239\u304c\u5230\u7740\u3057\u307e\u3057\u305f\u30021\u5206\u5f8c\u30a2\u30c7\u30f3\u306b\u5411\u304b\u3063\u3066\u51fa\u767a\u3057\u307e\u3059\u3002" : "\u30a2\u30c7\u30f3\u306b\u5411\u304b\u3046\u5b9a\u671f\u4fbf\u98db\u884c\u8239\u304c\u51fa\u767a\u3057\u307e\u3057\u305f\u3002";
                break;
            }
            case 32609: {
                message = isArraived ? "\u5b9a\u671f\u4fbf\u98db\u884c\u8239\u304c\u5230\u7740\u3057\u307e\u3057\u305f\u30021\u5206\u5f8c\u30b0\u30ec\u30b7\u30a2\u306b\u5411\u304b\u3063\u3066\u51fa\u767a\u3057\u307e\u3059\u3002" : "\u30b0\u30ec\u30b7\u30a2\u306b\u5411\u304b\u3046\u5b9a\u671f\u4fbf\u98db\u884c\u8239\u304c\u51fa\u767a\u3057\u307e\u3057\u305f\u3002";
                break;
            }
            default: {
                _log.warning("Invalid AirShipController npcId: " + npcId);
                return;
            }
        }
        for (L2AirShipControllerInstance asci : AirShipManager.getInstance().getATCs()) {
            if (asci == null || asci.getNpcId() != npcId) continue;
            asci.setIsBoardAllowed(isArraived);
            asci.broadcastMessage(message);
        }
    }

    public ExMoveToLocationAirShip getAirShipInfo() {
        return this._easi;
    }

    public void beginCycle() {
        AirShipCaptain asc = new AirShipCaptain(this);
        ThreadPoolManager.getInstance().scheduleGeneral(asc, 60000L);
    }

    public void updatePeopleInTheAirShip(int x, int y, int z) {
        if (this._inAirShip != null) {
            if (this.lastx == -1 || this.lasty == -1) {
                this.lastx = x;
                this.lasty = y;
            } else if ((x - this.lastx) * (x - this.lastx) + (y - this.lasty) * (y - this.lasty) > 2250000) {
                this.lastx = x;
                this.lasty = y;
            }
            for (int i = 0; i < this._inAirShip.size(); ++i) {
                L2PcInstance player = this._inAirShip.get(i);
                if (player == null || !player.isInAirShip() || player.getAirShip() != this) continue;
                player.getPosition().setXYZ(x, y, z);
                player.revalidateZone(false);
            }
        }
    }

    public void begin() {
        ++this._cycle;
        if (this._cycle == 1 || this._cycle == 5) {
            this._cycle = 1;
            this.setIsInDock(false);
            this.airShipControllerShout(32609, false);
            AirShiprun asr = new AirShiprun(0, this);
            ThreadPoolManager.getInstance().executeTask(asr);
        } else if (this._cycle == 3) {
            this.setIsInDock(false);
            this.airShipControllerShout(32607, false);
            AirShiprun asr = new AirShiprun(0, this);
            ThreadPoolManager.getInstance().executeTask(asr);
        }
    }

    public void spawn() {
        Collection<L2PcInstance> knownPlayers = this.getKnownList().getKnownPlayers().values();
        this._cycle = 0;
        this.beginCycle();
        if (knownPlayers == null || knownPlayers.isEmpty()) {
            return;
        }
        ExAirShipInfo easi = new ExAirShipInfo(this);
        for (L2PcInstance player : knownPlayers) {
            player.sendPacket(easi);
        }
    }

    public void setTrajet1(int idWaypoint1) {
        this._t1 = new L2AirShipTrajet(idWaypoint1);
    }

    public void setTrajet2(int idWaypoint2) {
        this._t2 = new L2AirShipTrajet(idWaypoint2);
    }

    public void setTrajet3(int idWaypoint3) {
        this._t3 = new L2AirShipTrajet(idWaypoint3);
    }

    public void setTrajet4(int idWaypoint4) {
        this._t4 = new L2AirShipTrajet(idWaypoint4);
    }

    public void setIsInDock(boolean val) {
        this._isInDock = val;
    }

    public boolean isInDock() {
        return this._isInDock;
    }

    public void onPlayerBoarding(L2PcInstance player) {
        if (!this.isInDock() || this._passengers.contains((Object)player)) {
            return;
        }
        this._passengers.add((Object)player);
        player.setAirShip(this);
        player.broadcastPacket(new ExGetOnAirShip(player, this));
    }

    public void oustPlayer(L2PcInstance player) {
        int z;
        int y;
        int x;
        if (this._cycle == 1 || this._cycle == 4) {
            x = -149379;
            y = 255246;
            z = -80;
        } else {
            x = -186563;
            y = 243590;
            z = 2608;
        }
        this._passengers.remove((Object)player);
        player.broadcastPacket(new ExGetOffAirShip(player, this, x, y, z));
        player.setAirShip(null);
    }

    public void teleportAirShip(int x, int y, int z, int heading) {
        this.teleToLocation(x, y, z, heading, false);
        for (L2PcInstance player : this._passengers) {
            if (player == null) continue;
            player.sendPacket(new ExStopMoveAirShip(this));
            player.teleToLocation(x, y, z, heading, false);
            player.sendPacket(new ExAirShipInfo(this));
        }
    }

    @Override
    public void updateAbnormalEffect() {
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    @Override
    public void setAI(L2CharacterAI newAI) {
        if (this._ai == null) {
            this._ai = newAI;
        }
    }

    public int getSpeed1() {
        return 300;
    }

    public int getSpeed2() {
        return 4000;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (this != activeChar.getAirShip()) {
            activeChar.sendPacket(new ExAirShipInfo(this));
        }
    }

    public class AIAccessor
    extends L2Character.AIAccessor {
        @Override
        public void detachAI() {
        }
    }

    class AirShiprun
    implements Runnable {
        private int _state;
        private L2AirShipInstance _airShip;

        public AirShiprun(int i, L2AirShipInstance instance) {
            this._state = i;
            this._airShip = instance;
        }

        @Override
        public void run() {
            this._airShip._easi = null;
            if (this._airShip._cycle == 1) {
                int time = this._airShip._t1.state(this._state, this._airShip);
                if (time == 0) {
                    this._airShip._cycle = 2;
                    L2AirShipInstance.this.teleportAirShip(-167874, 256731, -509, 41035);
                    AirShiprun asr = new AirShiprun(0, this._airShip);
                    ThreadPoolManager.getInstance().scheduleGeneral(asr, 5000L);
                } else {
                    ++this._state;
                }
            } else if (this._airShip._cycle == 2) {
                int time = this._airShip._t2.state(this._state, this._airShip);
                if (time == 0) {
                    L2AirShipInstance.this.setIsInDock(true);
                    for (L2PcInstance player : L2AirShipInstance.this._passengers) {
                        if (player == null) continue;
                        L2AirShipInstance.this.oustPlayer(player);
                    }
                    L2AirShipInstance.this.airShipControllerShout(32607, true);
                    AirShipCaptain asc = new AirShipCaptain(this._airShip);
                    ThreadPoolManager.getInstance().scheduleGeneral(asc, 60000L);
                } else {
                    ++this._state;
                }
            } else if (this._airShip._cycle == 3) {
                int time = this._airShip._t3.state(this._state, this._airShip);
                if (time == 0) {
                    this._airShip._cycle = 4;
                    L2AirShipInstance.this.teleportAirShip(-157261, 255664, 221, 64781);
                    AirShiprun asr = new AirShiprun(0, this._airShip);
                    ThreadPoolManager.getInstance().scheduleGeneral(asr, 5000L);
                } else {
                    ++this._state;
                }
            } else if (this._airShip._cycle == 4) {
                int time = this._airShip._t4.state(this._state, this._airShip);
                if (time == 0) {
                    L2AirShipInstance.this.setIsInDock(true);
                    for (L2PcInstance player : L2AirShipInstance.this._passengers) {
                        if (player == null) continue;
                        L2AirShipInstance.this.oustPlayer(player);
                    }
                    L2AirShipInstance.this.airShipControllerShout(32609, true);
                    AirShipCaptain asc = new AirShipCaptain(this._airShip);
                    ThreadPoolManager.getInstance().scheduleGeneral(asc, 60000L);
                } else {
                    ++this._state;
                }
            }
            this._airShip._runstate = this._state;
        }
    }

    class AirShipCaptain
    implements Runnable {
        private L2AirShipInstance _airShip;

        public AirShipCaptain(L2AirShipInstance instance) {
            this._airShip = instance;
        }

        @Override
        public void run() {
            this._airShip.begin();
        }
    }

    private class L2AirShipTrajet {
        private Map<Integer, L2AirShipPoint> _path;
        public int idWaypoint;
        public int max;

        public L2AirShipTrajet(int pIdWaypoint) {
            this.idWaypoint = pIdWaypoint;
            this.loadBoatPath();
        }

        public void parseLine(String line) {
            this._path = new FastMap();
            StringTokenizer st = new StringTokenizer(line, ";");
            Integer.parseInt(st.nextToken());
            this.max = Integer.parseInt(st.nextToken());
            for (int i = 0; i < this.max; ++i) {
                L2AirShipPoint bp = new L2AirShipPoint();
                bp.x = Integer.parseInt(st.nextToken());
                bp.y = Integer.parseInt(st.nextToken());
                bp.z = Integer.parseInt(st.nextToken());
                bp.time = Integer.parseInt(st.nextToken());
                this._path.put(i, bp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadBoatPath() {
            BufferedReader lnr = null;
            try {
                File doorData = new File(Config.DATAPACK_ROOT, "data/airshippath.csv");
                lnr = new LineNumberReader(new BufferedReader(new FileReader(doorData)));
                String line = null;
                while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                    if (line.trim().length() == 0 || !line.startsWith(this.idWaypoint + ";")) continue;
                    this.parseLine(line);
                    return;
                }
                _airShiplog.warning("No path for airShip!!!");
            }
            catch (FileNotFoundException e) {
                _airShiplog.warning("airship.csv is missing in data folder");
            }
            catch (Exception e) {
                _airShiplog.warning("error while creating airship table " + e);
            }
            finally {
                try {
                    lnr.close();
                }
                catch (Exception e1) {}
            }
        }

        public int state(int state, L2AirShipInstance _boat) {
            if (state < this.max) {
                L2AirShipPoint bp = this._path.get(state);
                _boat._easi = new ExMoveToLocationAirShip(L2AirShipInstance.this, bp.x, bp.y, bp.z);
                L2AirShipInstance.this.boatSpeed = bp.speed1;
                _boat.moveAirShipToLocation(bp.x, bp.y, bp.z, bp.speed1);
                Collection<L2PcInstance> knownPlayers = _boat.getKnownList().getKnownPlayers().values();
                if (bp.time == 0) {
                    bp.time = 1;
                }
                if (knownPlayers == null || knownPlayers.isEmpty()) {
                    return bp.time;
                }
                for (L2PcInstance player : knownPlayers) {
                    player.sendPacket(_boat._easi);
                }
                return bp.time;
            }
            return 0;
        }

        protected class L2AirShipPoint {
            public int speed1 = 350;
            public int x;
            public int y;
            public int z;
            public int time;

            protected L2AirShipPoint() {
            }
        }
    }
}

