/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.List;
import javolution.util.FastList;

public class L2ControlTowerInstance
extends L2Npc {
    private List<L2Spawn> _guards;

    public L2ControlTowerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2ControlTowerInstance);
        this.setIsInvul(false);
    }

    @Override
    public boolean isAttackable() {
        return this.getCastle() != null && this.getCastle().getCastleId() > 0 && this.getCastle().getSiege().getIsInProgress();
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return attacker != null && attacker instanceof L2PcInstance && this.getCastle() != null && this.getCastle().getCastleId() > 0 && this.getCastle().getSiege().getIsInProgress() && this.getCastle().getSiege().checkIsAttacker(((L2PcInstance)attacker).getClan());
    }

    @Override
    public void onForcedAttack(L2PcInstance player) {
        this.onAction(player);
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        if (this != player.getTarget()) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            StatusUpdate su = new StatusUpdate(this.getObjectId());
            su.addAttribute(9, (int)this.getStatus().getCurrentHp());
            su.addAttribute(10, this.getMaxHp());
            player.sendPacket(su);
            player.sendPacket(new ValidateLocation(this));
        } else if (interact && this.isAutoAttackable(player) && Math.abs(player.getZ() - this.getZ()) < 100 && GeoData.getInstance().canSeeTarget((L2Object)player, this)) {
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (this.getCastle().getSiege().getIsInProgress()) {
            this.getCastle().getSiege().killedCT(this);
            if (this._guards != null && !this._guards.isEmpty()) {
                for (L2Spawn spawn : this._guards) {
                    if (spawn == null) continue;
                    try {
                        spawn.stopRespawn();
                    }
                    catch (Exception e) {}
                }
                this._guards.clear();
            }
        }
        return super.doDie(killer);
    }

    public void registerGuard(L2Spawn guard) {
        this.getGuards().add(guard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<L2Spawn> getGuards() {
        if (this._guards == null) {
            L2ControlTowerInstance l2ControlTowerInstance = this;
            synchronized (l2ControlTowerInstance) {
                if (this._guards == null) {
                    this._guards = new FastList();
                }
            }
        }
        return this._guards;
    }
}

