/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.GuardKnownList;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.util.logging.Logger;

public final class L2GuardInstance
extends L2Attackable {
    private static Logger _log = Logger.getLogger(L2GuardInstance.class.getName());
    private static final int RETURN_INTERVAL = 60000;

    public L2GuardInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2GuardInstance);
        ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new ReturnTask(), 60000L, 60000 + Rnd.nextInt(60000));
    }

    @Override
    public final GuardKnownList getKnownList() {
        return (GuardKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new GuardKnownList(this));
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return attacker instanceof L2MonsterInstance;
    }

    @Override
    public void returnHome() {
        if (!this.isInsideRadius(this.getSpawn().getLocx(), this.getSpawn().getLocy(), 150, false)) {
            this.clearAggroList();
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(this.getSpawn().getLocx(), this.getSpawn().getLocy(), this.getSpawn().getLocz(), 0));
        }
    }

    @Override
    public void onSpawn() {
        this.setIsNoRndWalk(true);
        super.onSpawn();
        L2WorldRegion region = L2World.getInstance().getRegion(this.getX(), this.getY());
        if (region != null && !region.isActive().booleanValue()) {
            ((L2AttackableAI)this.getAI()).stopAITask();
        }
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/guard/", npcId, val);
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        if (this.getObjectId() != player.getTargetId()) {
            if (Config.DEBUG) {
                _log.fine(player.getObjectId() + ": Targetted guard " + this.getObjectId());
            }
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), 0);
            player.sendPacket(my);
            player.sendPacket(new ValidateLocation(this));
        } else if (interact) {
            if (this.containsTarget(player)) {
                if (Config.DEBUG) {
                    _log.fine(player.getObjectId() + ": Attacked guard " + this.getObjectId());
                }
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
            } else if (!this.canInteract(player)) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
            } else {
                Quest[] qlst;
                SocialAction sa = new SocialAction(this.getObjectId(), Rnd.nextInt(8));
                this.broadcastPacket(sa);
                Quest[] qlsa = this.getTemplate().getEventQuests(Quest.QuestEventType.QUEST_START);
                if (qlsa != null && qlsa.length > 0) {
                    player.setLastQuestNpcObject(this.getObjectId());
                }
                if ((qlst = this.getTemplate().getEventQuests(Quest.QuestEventType.ON_FIRST_TALK)) != null && qlst.length == 1) {
                    qlst[0].notifyFirstTalk(this, player);
                } else {
                    this.showChatWindow(player, 0);
                }
            }
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public class ReturnTask
    implements Runnable {
        @Override
        public void run() {
            if (L2GuardInstance.this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                L2GuardInstance.this.returnHome();
            }
        }
    }
}

