/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FortCommanderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.AttackableKnownList;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;

public class DefenderKnownList
extends AttackableKnownList {
    public DefenderKnownList(L2DefenderInstance activeChar) {
        super(activeChar);
    }

    @Override
    public boolean addKnownObject(L2Object object) {
        if (!super.addKnownObject(object)) {
            return false;
        }
        Castle castle = this.getActiveChar().getCastle();
        Fort fortress = this.getActiveChar().getFort();
        if (fortress != null && fortress.getZone().isActive() || castle != null && castle.getZone().isActive()) {
            int activeSiegeId;
            L2PcInstance player = null;
            if (object instanceof L2PcInstance) {
                player = (L2PcInstance)object;
            } else if (object instanceof L2Summon) {
                player = ((L2Summon)object).getOwner();
            }
            int n = fortress != null ? fortress.getFortId() : (activeSiegeId = castle != null ? castle.getCastleId() : 0);
            if (player != null && (player.getSiegeState() == 2 && !player.isRegisteredOnThisSiegeField(activeSiegeId) || player.getSiegeState() == 1 && !TerritoryWarManager.getInstance().isAllyField(player, activeSiegeId) || player.getSiegeState() == 0) && this.getActiveChar().getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                this.getActiveChar().getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
            }
        }
        return true;
    }

    @Override
    public final L2DefenderInstance getActiveChar() {
        if (super.getActiveChar() instanceof L2FortCommanderInstance) {
            return (L2FortCommanderInstance)super.getActiveChar();
        }
        return (L2DefenderInstance)super.getActiveChar();
    }
}

