/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2SpawnZone;

public class L2TownZone
extends L2SpawnZone {
    private String _townName;
    private int _townId;
    private int _redirectTownId = 9;
    private int _taxById = 0;
    private boolean _isPeaceZone = true;

    public L2TownZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("name")) {
            this._townName = value;
        } else if (name.equals("townId")) {
            this._townId = Integer.parseInt(value);
        } else if (name.equals("redirectTownId")) {
            this._redirectTownId = Integer.parseInt(value);
        } else if (name.equals("taxById")) {
            this._taxById = Integer.parseInt(value);
        } else if (name.equals("isPeaceZone")) {
            this._isPeaceZone = Boolean.parseBoolean(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (character instanceof L2PcInstance && ((L2PcInstance)character).getSiegeState() != 0 && Config.ZONE_TOWN == 1) {
            return;
        }
        if (this._isPeaceZone && Config.ZONE_TOWN != 2) {
            character.setInsideZone((byte)1, true);
        }
        character.setInsideZone((byte)15, true);
    }

    @Override
    protected void onExit(L2Character character) {
        if (this._isPeaceZone) {
            character.setInsideZone((byte)1, false);
        }
        character.setInsideZone((byte)15, false);
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    @Deprecated
    public String getName() {
        return this._townName;
    }

    public int getTownId() {
        return this._townId;
    }

    @Deprecated
    public int getRedirectTownId() {
        return this._redirectTownId;
    }

    public final int getTaxById() {
        return this._taxById;
    }

    public final boolean isPeaceZone() {
        return this._isPeaceZone;
    }
}

