/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills;

import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.skills.funcs.Func;
import javolution.util.FastList;

public final class Calculator {
    private static final Func[] _emptyFuncs = new Func[0];
    private Func[] _functions;

    public Calculator() {
        this._functions = _emptyFuncs;
    }

    public Calculator(Calculator c) {
        this._functions = c._functions;
    }

    public static boolean equalsCals(Calculator c1, Calculator c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        Func[] funcs1 = c1._functions;
        Func[] funcs2 = c2._functions;
        if (funcs1 == funcs2) {
            return true;
        }
        if (funcs1.length != funcs2.length) {
            return false;
        }
        if (funcs1.length == 0) {
            return true;
        }
        for (int i = 0; i < funcs1.length; ++i) {
            if (funcs1[i] == funcs2[i]) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this._functions.length;
    }

    public synchronized void addFunc(Func f) {
        int i;
        Func[] funcs = this._functions;
        Func[] tmp = new Func[funcs.length + 1];
        int order = f.order;
        for (i = 0; i < funcs.length && order >= funcs[i].order; ++i) {
            tmp[i] = funcs[i];
        }
        tmp[i] = f;
        while (i < funcs.length) {
            tmp[i + 1] = funcs[i];
            ++i;
        }
        this._functions = tmp;
    }

    public synchronized void removeFunc(Func f) {
        int i;
        Func[] funcs = this._functions;
        Func[] tmp = new Func[funcs.length - 1];
        for (i = 0; i < funcs.length && f != funcs[i]; ++i) {
            tmp[i] = funcs[i];
        }
        if (i == funcs.length) {
            return;
        }
        ++i;
        while (i < funcs.length) {
            tmp[i - 1] = funcs[i];
            ++i;
        }
        this._functions = tmp.length == 0 ? _emptyFuncs : tmp;
    }

    public synchronized FastList<Stats> removeOwner(Object owner) {
        FastList modifiedStats = new FastList();
        for (Func func : this._functions) {
            if (func.funcOwner != owner) continue;
            modifiedStats.add((Object)func.stat);
            this.removeFunc(func);
        }
        return modifiedStats;
    }

    public void calc(Env env) {
        for (Func func : this._functions) {
            func.calc(env);
        }
    }
}

