/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.l2skills;

import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import java.util.logging.Level;

public class L2SkillTeleport
extends L2Skill {
    private final String _recallType;
    private final Location _loc;

    public L2SkillTeleport(StatsSet set) {
        super(set);
        this._recallType = set.getString("recallType", "");
        String coords = set.getString("teleCoords", null);
        if (coords != null) {
            String[] valuesSplit = coords.split(",");
            this._loc = new Location(Integer.parseInt(valuesSplit[0]), Integer.parseInt(valuesSplit[1]), Integer.parseInt(valuesSplit[2]));
        } else {
            this._loc = null;
        }
    }

    @Override
    public void useSkill(L2Character activeChar, L2Object[] targets) {
        if (activeChar instanceof L2PcInstance) {
            if (!TvTEvent.onEscapeUse(((L2PcInstance)activeChar).getObjectId())) {
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (activeChar.isAfraid()) {
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (((L2PcInstance)activeChar).isCombatFlagEquipped()) {
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (((L2PcInstance)activeChar).isInOlympiadMode()) {
                activeChar.sendPacket(new SystemMessage(SystemMessageId.THIS_ITEM_IS_NOT_AVAILABLE_FOR_THE_OLYMPIAD_EVENT));
                return;
            }
            if (GrandBossManager.getInstance().getZone(activeChar) != null && !activeChar.isGM()) {
                activeChar.sendMessage("\u73fe\u5728\u306e\u4f4d\u7f6e\u3067\u306f\u30c6\u30ec\u30dd\u30fc\u30c8\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                return;
            }
        }
        try {
            for (L2Character target : (L2Character[])targets) {
                if (target instanceof L2PcInstance) {
                    L2PcInstance targetChar = (L2PcInstance)target;
                    if (targetChar.isFestivalParticipant()) {
                        targetChar.sendMessage("\u796d\u5178\u306b\u53c2\u52a0\u4e2d\u306f\u6751\u306b\u5e30\u9084\u3067\u304d\u307e\u305b\u3093\u3002");
                        continue;
                    }
                    if (targetChar.isInJail()) {
                        targetChar.sendMessage("GM\u76f8\u8ac7\u6240\u304b\u3089\u306f\u6751\u306b\u5e30\u9084\u3067\u304d\u307e\u305b\u3093\u3002");
                        continue;
                    }
                    if (targetChar.isInDuel()) {
                        targetChar.sendMessage("\u6c7a\u95d8\u4e2d\u306f\u6751\u306b\u5e30\u9084\u3067\u304d\u307e\u305b\u3093\u3002");
                        continue;
                    }
                    if (targetChar != activeChar && (!TvTEvent.onEscapeUse(targetChar.getObjectId()) || targetChar.isInOlympiadMode() || GrandBossManager.getInstance().getZone(targetChar) != null || targetChar.isCombatFlagEquipped())) continue;
                }
                Location loc = null;
                if (this.getSkillType() == L2SkillType.TELEPORT) {
                    if (!(this._loc == null || target instanceof L2PcInstance && (target.isFlying() || ((L2PcInstance)target).isFlyingMounted()))) {
                        loc = this._loc;
                    }
                } else {
                    loc = this._recallType.equalsIgnoreCase("Castle") ? MapRegionTable.getInstance().getTeleToLocation(target, MapRegionTable.TeleportWhereType.Castle) : (this._recallType.equalsIgnoreCase("ClanHall") ? MapRegionTable.getInstance().getTeleToLocation(target, MapRegionTable.TeleportWhereType.ClanHall) : (this._recallType.equalsIgnoreCase("Fortress") ? MapRegionTable.getInstance().getTeleToLocation(target, MapRegionTable.TeleportWhereType.Fortress) : MapRegionTable.getInstance().getTeleToLocation(target, MapRegionTable.TeleportWhereType.Town)));
                }
                if (loc == null) continue;
                target.setInstanceId(0);
                if (target instanceof L2PcInstance) {
                    ((L2PcInstance)target).setIsIn7sDungeon(false);
                }
                target.teleToLocation(loc, true);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
    }
}

