/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.Server;
import com.l2jserver.loginserver.GameServerListener;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.L2LoginClient;
import com.l2jserver.loginserver.L2LoginPacketHandler;
import com.l2jserver.loginserver.LoginController;
import com.l2jserver.loginserver.SelectorHelper;
import com.l2jserver.status.Status;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.mmocore.network.IAcceptFilter;
import org.mmocore.network.IClientFactory;
import org.mmocore.network.IMMOExecutor;
import org.mmocore.network.IPacketHandler;
import org.mmocore.network.SelectorConfig;
import org.mmocore.network.SelectorThread;

public class L2LoginServer {
    public static final int PROTOCOL_REV = 259;
    private static L2LoginServer _instance;
    private Logger _log;
    private GameServerListener _gameServerListener;
    private SelectorThread<L2LoginClient> _selectorThread;
    private Status _statusServer;

    public static void main(String[] args) {
        _instance = new L2LoginServer();
    }

    public static L2LoginServer getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2LoginServer() {
        InetAddress bindAddress;
        block41: {
            this._log = Logger.getLogger(L2LoginServer.class.getName());
            Server.serverMode = 2;
            String LOG_FOLDER = "log";
            String LOG_NAME = "./log.cfg";
            File logFolder = new File(Config.DATAPACK_ROOT, "log");
            logFolder.mkdir();
            InputStream is = null;
            try {
                is = new FileInputStream(new File("./log.cfg"));
                LogManager.getLogManager().readConfiguration(is);
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Config.load();
            try {
                L2DatabaseFactory.getInstance();
            }
            catch (SQLException e) {
                this._log.log(Level.SEVERE, "FATAL: Failed initializing database. Reason: " + e.getMessage(), e);
                if (Config.DEVELOPER) {
                    e.printStackTrace();
                }
                System.exit(1);
            }
            try {
                LoginController.load();
            }
            catch (GeneralSecurityException e) {
                this._log.log(Level.SEVERE, "FATAL: Failed initializing LoginController. Reason: " + e.getMessage(), e);
                if (Config.DEVELOPER) {
                    e.printStackTrace();
                }
                System.exit(1);
            }
            try {
                GameServerTable.load();
            }
            catch (GeneralSecurityException e) {
                this._log.log(Level.SEVERE, "FATAL: Failed to load GameServerTable. Reason: " + e.getMessage(), e);
                if (Config.DEVELOPER) {
                    e.printStackTrace();
                }
                System.exit(1);
            }
            catch (SQLException e) {
                this._log.log(Level.SEVERE, "FATAL: Failed to load GameServerTable. Reason: " + e.getMessage(), e);
                if (Config.DEVELOPER) {
                    e.printStackTrace();
                }
                System.exit(1);
            }
            this.loadBanFile();
            bindAddress = null;
            if (!Config.LOGIN_BIND_ADDRESS.equals("*")) {
                try {
                    bindAddress = InetAddress.getByName(Config.LOGIN_BIND_ADDRESS);
                }
                catch (UnknownHostException e) {
                    this._log.warning("WARNING: The LoginServer bind address is invalid, using all avaliable IPs. Reason: " + e.getMessage());
                    if (!Config.DEVELOPER) break block41;
                    e.printStackTrace();
                }
            }
        }
        SelectorConfig sc = new SelectorConfig();
        sc.MAX_READ_PER_PASS = Config.MMO_MAX_READ_PER_PASS;
        sc.MAX_SEND_PER_PASS = Config.MMO_MAX_SEND_PER_PASS;
        sc.SLEEP_TIME = Config.MMO_SELECTOR_SLEEP_TIME;
        sc.HELPER_BUFFER_COUNT = Config.MMO_HELPER_BUFFER_COUNT;
        L2LoginPacketHandler lph = new L2LoginPacketHandler();
        SelectorHelper sh = new SelectorHelper();
        try {
            this._selectorThread = new SelectorThread(sc, (IMMOExecutor)sh, (IPacketHandler)lph, (IClientFactory)sh, (IAcceptFilter)sh);
        }
        catch (IOException e) {
            this._log.log(Level.SEVERE, "FATAL: Failed to open Selector. Reason: " + e.getMessage(), e);
            if (Config.DEVELOPER) {
                e.printStackTrace();
            }
            System.exit(1);
        }
        try {
            this._gameServerListener = new GameServerListener();
            this._gameServerListener.start();
            this._log.info("Listening for GameServers on " + Config.GAME_SERVER_LOGIN_HOST + ":" + Config.GAME_SERVER_LOGIN_PORT);
        }
        catch (IOException e) {
            this._log.log(Level.SEVERE, "FATAL: Failed to start the Game Server Listener. Reason: " + e.getMessage(), e);
            if (Config.DEVELOPER) {
                e.printStackTrace();
            }
            System.exit(1);
        }
        if (Config.IS_TELNET_ENABLED) {
            try {
                this._statusServer = new Status(Server.serverMode);
                this._statusServer.start();
            }
            catch (IOException e) {
                this._log.warning("Failed to start the Telnet Server. Reason: " + e.getMessage());
                if (Config.DEVELOPER) {
                    e.printStackTrace();
                }
            }
        } else {
            this._log.info("Telnet server is currently disabled.");
        }
        try {
            this._selectorThread.openServerSocket(bindAddress, Config.PORT_LOGIN);
        }
        catch (IOException e) {
            this._log.log(Level.SEVERE, "FATAL: Failed to open server socket. Reason: " + e.getMessage(), e);
            if (Config.DEVELOPER) {
                e.printStackTrace();
            }
            System.exit(1);
        }
        this._selectorThread.start();
        this._log.info("Login Server ready on " + (bindAddress == null ? "*" : bindAddress.getHostAddress()) + ":" + Config.PORT_LOGIN);
    }

    public Status getStatusServer() {
        return this._statusServer;
    }

    public GameServerListener getGameServerListener() {
        return this._gameServerListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBanFile() {
        File bannedFile = new File("./banned_ip.cfg");
        if (bannedFile.exists() && bannedFile.isFile()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(bannedFile);
            }
            catch (FileNotFoundException e) {
                this._log.warning("Failed to load banned IPs file (" + bannedFile.getName() + ") for reading. Reason: " + e.getMessage());
                if (Config.DEVELOPER) {
                    e.printStackTrace();
                }
                return;
            }
            BufferedReader reader = null;
            try {
                String line;
                reader = new LineNumberReader(new InputStreamReader(fis));
                while ((line = ((LineNumberReader)reader).readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                    String[] parts = line.split("#", 2);
                    line = parts[0];
                    parts = line.split(" ");
                    String address = parts[0];
                    long duration = 0L;
                    if (parts.length > 1) {
                        try {
                            duration = Long.parseLong(parts[1]);
                        }
                        catch (NumberFormatException e) {
                            this._log.warning("Skipped: Incorrect ban duration (" + parts[1] + ") on (" + bannedFile.getName() + "). Line: " + ((LineNumberReader)reader).getLineNumber());
                            continue;
                        }
                    }
                    try {
                        LoginController.getInstance().addBanForAddress(address, duration);
                    }
                    catch (UnknownHostException e) {
                        this._log.warning("Skipped: Invalid address (" + parts[0] + ") on (" + bannedFile.getName() + "). Line: " + ((LineNumberReader)reader).getLineNumber());
                    }
                }
            }
            catch (IOException e) {
                this._log.warning("Error while reading the bans file (" + bannedFile.getName() + "). Details: " + e.getMessage());
                if (Config.DEVELOPER) {
                    e.printStackTrace();
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception e) {}
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
            this._log.config("Loaded " + LoginController.getInstance().getBannedIps().size() + " IP Bans.");
        } else {
            this._log.config("IP Bans file (" + bannedFile.getName() + ") is missing or is a directory, skipped.");
        }
    }

    public void shutdown(boolean restart) {
        Runtime.getRuntime().exit(restart ? 2 : 0);
    }
}

