/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import javolution.context.ArrayFactory;
import javolution.context.ConcurrentContext;
import javolution.context.LocalContext;
import javolution.context.ObjectFactory;
import javolution.context.StackContext;
import javolution.lang.MathLib;
import javolution.testing.TestCase;
import javolution.testing.TestContext;
import javolution.testing.TestSuite;
import javolution.util.FastTable;
import javolution.util.Index;

public final class ContextTestSuite
extends TestSuite {
    public ContextTestSuite() {
        int defaultConcurrency = ConcurrentContext.getConcurrency();
        this.addTest(new Concurrency(10000, 0));
        this.addTest(new Concurrency(10000, defaultConcurrency));
        this.addTest(new SmallObjectAllocation(false));
        this.addTest(new SmallObjectAllocation(true));
        this.addTest(new ArrayRecycling(4096, false));
        this.addTest(new ArrayRecycling(4096, true));
    }

    private static final class XYZ {
        static ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new XYZ();
            }
        };
        long x;
        long y;
        long z;

        private XYZ() {
        }

        public XYZ(long x, long y, long z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public static XYZ valueOf(long x, long y, long z) {
            XYZ c = (XYZ)FACTORY.object();
            c.x = x;
            c.y = y;
            c.z = z;
            return c;
        }

        public XYZ plusStack(XYZ that) {
            return XYZ.valueOf(this.x + that.x, this.y + that.y, this.z + that.z);
        }

        public XYZ plusHeap(XYZ that) {
            return new XYZ(this.x + that.x, this.y + that.y, this.z + that.z);
        }
    }

    class ArrayRecycling
    extends TestCase {
        int _size;
        boolean _recycle;
        char[] _array;

        public ArrayRecycling(int size, boolean recycle) {
            this._size = size;
            this._recycle = recycle;
        }

        public String getName() {
            return "HeapContext, char[" + this._size + "] " + (this._recycle ? "recycled" : "allocated");
        }

        public void execute() {
            if (this._recycle) {
                this._array = ArrayFactory.CHARS_FACTORY.array(this._size);
                ArrayFactory.CHARS_FACTORY.recycle(this._array);
            } else {
                this._array = new char[this._size];
            }
        }

        public void validate() {
            TestContext.assertTrue(this._array.length >= this._size);
        }
    }

    class SmallObjectAllocation
    extends TestCase {
        final int N = 1000;
        boolean _useStack;
        XYZ c0;
        XYZ c1;

        public SmallObjectAllocation(boolean useStack) {
            this._useStack = useStack;
        }

        public String getName() {
            return (!this._useStack ? "HeapContext (default)" : "StackContext") + ", small object creation";
        }

        public void setUp() {
            this.c0 = new XYZ(0L, 0L, 0L);
            this.c1 = new XYZ(-1L, 1L, 0L);
            StackContext.enter();
        }

        public void execute() {
            if (this._useStack) {
                for (int i = 0; i < 1000; ++i) {
                    XYZ cn = this.c1.plusStack(this.c0);
                    this.c0 = this.c1;
                    this.c1 = cn;
                }
            } else {
                for (int i = 0; i < 1000; ++i) {
                    XYZ cn = this.c1.plusHeap(this.c0);
                    this.c0 = this.c1;
                    this.c1 = cn;
                }
            }
        }

        public int count() {
            return 1000;
        }

        public void tearDown() {
            StackContext.exit();
        }

        public void validate() {
            TestContext.assertTrue(this.c0.x == -this.c0.y);
        }
    }

    class Concurrency
    extends TestCase {
        final int _size;
        final int _concurrency;
        FastTable _table;

        public Concurrency(int size, int concurrency) {
            this._size = size;
            this._concurrency = concurrency;
        }

        public String getName() {
            return "ConcurrentContext (" + this._concurrency + ") Quick-Sort (" + this._size + " elements)";
        }

        public void setUp() {
            this._table = new FastTable(this._size);
            for (int i = 0; i < this._size; ++i) {
                this._table.add(Index.valueOf(MathLib.random(0, this._size)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            LocalContext.enter();
            try {
                ConcurrentContext.setConcurrency(this._concurrency);
                this.quickSort(this._table);
            }
            finally {
                LocalContext.exit();
            }
        }

        public void validate() {
            int i2;
            int i1;
            TestContext.assertEquals(this._size, this._table.size());
            for (int i = 0; i < this._size - 1 && TestContext.assertTrue((i1 = ((Index)this._table.get(i)).intValue()) <= (i2 = ((Index)this._table.get(i + 1)).intValue())); ++i) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void quickSort(final FastTable table) {
            final int size = table.size();
            if (size < 100) {
                table.sort();
            } else {
                final FastTable t1 = FastTable.newInstance();
                final FastTable t2 = FastTable.newInstance();
                ConcurrentContext.enter();
                try {
                    ConcurrentContext.execute(new Runnable(){

                        public void run() {
                            t1.addAll(table.subList(0, size / 2));
                            Concurrency.this.quickSort(t1);
                        }
                    });
                    ConcurrentContext.execute(new Runnable(){

                        public void run() {
                            t2.addAll(table.subList(size / 2, size));
                            Concurrency.this.quickSort(t2);
                        }
                    });
                }
                finally {
                    ConcurrentContext.exit();
                }
                int i1 = 0;
                int i2 = 0;
                for (int i = 0; i < size; ++i) {
                    if (i1 >= t1.size()) {
                        table.set(i, t2.get(i2++));
                        continue;
                    }
                    if (i2 >= t2.size()) {
                        table.set(i, t1.get(i1++));
                        continue;
                    }
                    Index o1 = (Index)t1.get(i1);
                    Index o2 = (Index)t2.get(i2);
                    if (o1.intValue() < o2.intValue()) {
                        table.set(i, o1);
                        ++i1;
                        continue;
                    }
                    table.set(i, o2);
                    ++i2;
                }
                FastTable.recycle(t1);
                FastTable.recycle(t2);
            }
        }
    }
}

