/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import javolution.lang.MathLib;
import javolution.testing.TestCase;
import javolution.testing.TestContext;
import javolution.testing.TestSuite;
import javolution.text.TextBuilder;
import javolution.text.TypeFormat;

public final class TypeFormatTestSuite
extends TestSuite {
    static final int N = 1000;

    public TypeFormatTestSuite() {
        this.addTest(new ParseBoolean());
        this.addTest(new BooleanParse());
        this.addTest(new ParseInt());
        this.addTest(new IntegerParseInt());
        this.addTest(new ParseLong());
        this.addTest(new LongParseLong());
        this.addTest(new ParseLongHexa());
        this.addTest(new LongParseLongHexa());
        this.addTest(new ParseDouble());
        this.addTest(new DoubleParseDouble());
        this.addTest(new FormatBoolean());
        this.addTest(new StringBufferAppendBoolean());
        this.addTest(new FormatInt());
        this.addTest(new StringBufferAppendInt());
        this.addTest(new FormatLong());
        this.addTest(new StringBufferAppendLong());
        this.addTest(new FormatLongHexa());
        this.addTest(new StringBufferAppendLongHexa());
        this.addTest(new FormatDouble());
        this.addTest(new StringBufferAppendDouble());
    }

    class StringBufferAppendDouble
    extends TestCase {
        double[] _expected = new double[1000];
        double[] _actual = new double[1000];
        StringBuffer[] _appendables = new StringBuffer[1000];

        StringBufferAppendDouble() {
        }

        public String getName() {
            return "StringBuffer.append(double)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.pow(Math.PI, MathLib.random(-300, 300));
                this._appendables[i] = new StringBuffer();
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._appendables[i].append(this._expected[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseDouble(this._appendables[i].toString());
            }
            TestContext.assertArrayEquals(this._expected, this._actual, 0.0);
            TestContext.assertEquals("-Infinity", new StringBuffer().append(Double.NEGATIVE_INFINITY).toString());
            TestContext.assertEquals("0.0", new StringBuffer().append(0.0).toString());
            TestContext.assertEquals("Infinity", new StringBuffer().append(Double.POSITIVE_INFINITY).toString());
            TestContext.assertEquals("NaN", new StringBuffer().append(Double.NaN).toString());
        }
    }

    class FormatDouble
    extends TestCase {
        double[] _expected = new double[1000];
        double[] _actual = new double[1000];
        TextBuilder[] _appendables = new TextBuilder[1000];

        FormatDouble() {
        }

        public String getName() {
            return "TypeFormat.format(double, Appendable)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.pow(Math.PI, MathLib.random(-300, 300));
                this._appendables[i] = TextBuilder.newInstance();
            }
        }

        public void execute() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                TypeFormat.format(this._expected[i], (Appendable)this._appendables[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseDouble(this._appendables[i]);
            }
            TestContext.assertArrayEquals(this._expected, this._actual, 0.0);
            TestContext.assertEquals("-Infinity", TypeFormat.format(Double.NEGATIVE_INFINITY, (Appendable)TextBuilder.newInstance()).toString());
            TestContext.assertEquals("0.0", TypeFormat.format(0.0, (Appendable)TextBuilder.newInstance()).toString());
            TestContext.assertEquals("Infinity", TypeFormat.format(Double.POSITIVE_INFINITY, (Appendable)TextBuilder.newInstance()).toString());
            TestContext.assertEquals("NaN", TypeFormat.format(Double.NaN, (Appendable)TextBuilder.newInstance()).toString());
        }
    }

    class StringBufferAppendLongHexa
    extends StringBufferAppendLong {
        StringBufferAppendLongHexa() {
        }

        public String getName() {
            return "StringBuffer.append(Long.toString(long, 16))";
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._appendables[i].append(Long.toString(this._expected[i], 16));
            }
        }

        public void validate() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseLong(this._appendables[i].toString(), 16);
            }
            TestContext.assertArrayEquals(this._expected, this._actual);
            TestContext.assertEquals("-8000000000000000", new StringBuffer().append(Long.toString(Long.MIN_VALUE, 16)).toString());
            TestContext.assertEquals("0", new StringBuffer().append(Long.toString(0L, 16)).toString());
            TestContext.assertEquals("7fffffffffffffff", new StringBuffer().append(Long.toString(Long.MAX_VALUE, 16)).toString());
        }
    }

    class FormatLongHexa
    extends FormatLong {
        FormatLongHexa() {
        }

        public String getName() {
            return "TypeFormat.format(long, 16, Appendable)";
        }

        public void execute() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                TypeFormat.format(this._expected[i], 16, (Appendable)this._appendables[i]);
            }
        }

        public void validate() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseLong(this._appendables[i], 16);
            }
            TestContext.assertArrayEquals(this._expected, this._actual);
            TestContext.assertEquals("-8000000000000000", TypeFormat.format(Long.MIN_VALUE, 16, (Appendable)TextBuilder.newInstance()).toString());
            TestContext.assertEquals("0", TypeFormat.format(0L, 16, (Appendable)TextBuilder.newInstance()).toString());
            TestContext.assertEquals("7fffffffffffffff", TypeFormat.format(Long.MAX_VALUE, 16, (Appendable)TextBuilder.newInstance()).toString());
        }
    }

    class StringBufferAppendLong
    extends TestCase {
        long[] _expected = new long[1000];
        long[] _actual = new long[1000];
        StringBuffer[] _appendables = new StringBuffer[1000];

        StringBufferAppendLong() {
        }

        public String getName() {
            return "StringBuffer.append(long)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(Long.MIN_VALUE, Long.MAX_VALUE);
                this._appendables[i] = new StringBuffer();
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._appendables[i].append(this._expected[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseLong(this._appendables[i].toString());
            }
            TestContext.assertArrayEquals(this._expected, this._actual);
            TestContext.assertEquals("-9223372036854775808", new StringBuffer().append(Long.MIN_VALUE).toString());
            TestContext.assertEquals("0", new StringBuffer().append(0L).toString());
            TestContext.assertEquals("9223372036854775807", new StringBuffer().append(Long.MAX_VALUE).toString());
        }
    }

    class FormatLong
    extends TestCase {
        long[] _expected = new long[1000];
        long[] _actual = new long[1000];
        TextBuilder[] _appendables = new TextBuilder[1000];

        FormatLong() {
        }

        public String getName() {
            return "TypeFormat.format(long, Appendable)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(Long.MIN_VALUE, Long.MAX_VALUE);
                this._appendables[i] = TextBuilder.newInstance();
            }
        }

        public void execute() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                TypeFormat.format(this._expected[i], (Appendable)this._appendables[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseLong(this._appendables[i]);
            }
            TestContext.assertArrayEquals(this._expected, this._actual);
            TestContext.assertEquals("-9223372036854775808", TypeFormat.format(Long.MIN_VALUE, (Appendable)TextBuilder.newInstance()).toString());
            TestContext.assertEquals("0", TypeFormat.format(0L, (Appendable)TextBuilder.newInstance()).toString());
            TestContext.assertEquals("9223372036854775807", TypeFormat.format(Long.MAX_VALUE, (Appendable)TextBuilder.newInstance()).toString());
        }
    }

    class StringBufferAppendInt
    extends TestCase {
        int[] _expected = new int[1000];
        int[] _actual = new int[1000];
        StringBuffer[] _appendables = new StringBuffer[1000];

        StringBufferAppendInt() {
        }

        public String getName() {
            return "StringBuffer.append(int)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(Integer.MIN_VALUE, Integer.MAX_VALUE);
                this._appendables[i] = new StringBuffer();
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._appendables[i].append(this._expected[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseInt(this._appendables[i].toString());
            }
            TestContext.assertArrayEquals(this._expected, this._actual);
            TestContext.assertEquals("-2147483648", new StringBuffer().append(Integer.MIN_VALUE).toString());
            TestContext.assertEquals("0", new StringBuffer().append(0).toString());
            TestContext.assertEquals("2147483647", new StringBuffer().append(Integer.MAX_VALUE).toString());
        }
    }

    class FormatInt
    extends TestCase {
        int[] _expected = new int[1000];
        int[] _actual = new int[1000];
        TextBuilder[] _appendables = new TextBuilder[1000];

        FormatInt() {
        }

        public String getName() {
            return "TypeFormat.format(int, Appendable)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(Integer.MIN_VALUE, Integer.MAX_VALUE);
                this._appendables[i] = TextBuilder.newInstance();
            }
        }

        public void execute() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                TypeFormat.format(this._expected[i], (Appendable)this._appendables[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseInt(this._appendables[i]);
            }
            TestContext.assertArrayEquals(this._expected, this._actual);
            TestContext.assertEquals("-2147483648", TypeFormat.format(Integer.MIN_VALUE, (Appendable)TextBuilder.newInstance()).toString());
            TestContext.assertEquals("0", TypeFormat.format(0, (Appendable)TextBuilder.newInstance()).toString());
            TestContext.assertEquals("2147483647", TypeFormat.format(Integer.MAX_VALUE, (Appendable)TextBuilder.newInstance()).toString());
        }
    }

    class StringBufferAppendBoolean
    extends TestCase {
        boolean[] _expected = new boolean[1000];
        boolean[] _actual = new boolean[1000];
        StringBuffer[] _appendables = new StringBuffer[1000];

        StringBufferAppendBoolean() {
        }

        public String getName() {
            return "StringBuffer.append(boolean)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(0, 1) != 0;
                this._appendables[i] = new StringBuffer();
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._appendables[i].append(this._expected[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseBoolean(this._appendables[i] + "");
            }
            TestContext.assertArrayEquals(this._expected, this._actual);
        }
    }

    class FormatBoolean
    extends TestCase {
        boolean[] _expected = new boolean[1000];
        boolean[] _actual = new boolean[1000];
        TextBuilder[] _appendables = new TextBuilder[1000];

        FormatBoolean() {
        }

        public String getName() {
            return "TypeFormat.format(boolean, Appendable)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(0, 1) != 0;
                this._appendables[i] = TextBuilder.newInstance();
            }
        }

        public void execute() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                TypeFormat.format(this._expected[i], (Appendable)this._appendables[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseBoolean(this._appendables[i]);
            }
            TestContext.assertArrayEquals(this._expected, this._actual);
        }
    }

    class DoubleParseDouble
    extends TestCase {
        double[] _expected = new double[1000];
        double[] _actual = new double[1000];
        String[] _strings = new String[1000];

        DoubleParseDouble() {
        }

        public String getName() {
            return "Double.parseDouble(String)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = Double.longBitsToDouble(MathLib.random(Long.MIN_VALUE, Long.MAX_VALUE));
                this._strings[i] = String.valueOf(this._expected[i]);
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = Double.parseDouble(this._strings[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() {
            TestContext.assertArrayEquals(this._expected, this._actual, 0.0);
            TestContext.assertEquals(0.0, Double.parseDouble("0"), 0.0);
            TestContext.assertEquals(Double.NaN, Double.parseDouble("NaN"), 0.0);
            TestContext.assertEquals(Double.NEGATIVE_INFINITY, Double.parseDouble("-Infinity"), 0.0);
            TestContext.assertEquals(Double.POSITIVE_INFINITY, Double.parseDouble("Infinity"), 0.0);
            TestContext.assertEquals(Double.NEGATIVE_INFINITY, TypeFormat.parseDouble("-1E500"), 0.0);
            TestContext.assertEquals(Double.POSITIVE_INFINITY, TypeFormat.parseDouble("1E500"), 0.0);
            TestContext.assertEquals(0.0, TypeFormat.parseDouble("1E-500"), 0.0);
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    Double.parseDouble("123E4?");
                }
            });
        }
    }

    class ParseDouble
    extends TestCase {
        double[] _expected = new double[1000];
        double[] _actual = new double[1000];
        String[] _strings = new String[1000];

        ParseDouble() {
        }

        public String getName() {
            return "TypeFormat.parseDouble(CharSequence)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = Double.longBitsToDouble(MathLib.random(Long.MIN_VALUE, Long.MAX_VALUE));
                this._strings[i] = String.valueOf(this._expected[i]);
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseDouble(this._strings[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() {
            TestContext.assertArrayEquals(this._expected, this._actual, 0.0);
            TestContext.assertEquals(0.0, TypeFormat.parseDouble("0"), 0.0);
            TestContext.assertEquals(Double.NaN, TypeFormat.parseDouble("NaN"), 0.0);
            TestContext.assertEquals(Double.NEGATIVE_INFINITY, TypeFormat.parseDouble("-Infinity"), 0.0);
            TestContext.assertEquals(Double.POSITIVE_INFINITY, TypeFormat.parseDouble("Infinity"), 0.0);
            TestContext.assertEquals(Double.NEGATIVE_INFINITY, TypeFormat.parseDouble("-1E500"), 0.0);
            TestContext.assertEquals(Double.POSITIVE_INFINITY, TypeFormat.parseDouble("1E500"), 0.0);
            TestContext.assertEquals(0.0, TypeFormat.parseDouble("1E-500"), 0.0);
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    TypeFormat.parseDouble("123E4?");
                }
            });
        }
    }

    class LongParseLongHexa
    extends LongParseLong {
        LongParseLongHexa() {
        }

        public String getName() {
            return "Long.parseLong(String, 16)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(Long.MIN_VALUE, Long.MAX_VALUE);
                this._strings[i] = Long.toString(this._expected[i], 16);
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = Long.parseLong(this._strings[i], 16);
            }
        }

        public void validate() {
            TestContext.assertArrayEquals(this._expected, this._actual);
            TestContext.assertEquals(Long.MIN_VALUE, Long.parseLong("-8000000000000000", 16));
            TestContext.assertEquals(0L, Long.parseLong("0", 16));
            TestContext.assertEquals(Long.MAX_VALUE, Long.parseLong("7fffffffffffffff", 16));
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    Long.parseLong("8000000000000000", 16);
                }
            });
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    Long.parseLong("1234x");
                }
            });
        }
    }

    class ParseLongHexa
    extends ParseLong {
        ParseLongHexa() {
        }

        public String getName() {
            return "TypeFormat.parseLong(CharSequence, 16)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(Long.MIN_VALUE, Long.MAX_VALUE);
                this._strings[i] = Long.toString(this._expected[i], 16);
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseLong(this._strings[i], 16);
            }
        }

        public void validate() {
            TestContext.assertArrayEquals(this._expected, this._actual);
            TestContext.assertEquals(Long.MIN_VALUE, TypeFormat.parseLong("-8000000000000000", 16));
            TestContext.assertEquals(0L, TypeFormat.parseLong("0", 16));
            TestContext.assertEquals(Long.MAX_VALUE, TypeFormat.parseLong("7fffffffffffffff", 16));
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    TypeFormat.parseLong("8000000000000000", 16);
                }
            });
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    TypeFormat.parseLong("1234x");
                }
            });
        }
    }

    class LongParseLong
    extends TestCase {
        long[] _expected = new long[1000];
        long[] _actual = new long[1000];
        String[] _strings = new String[1000];

        LongParseLong() {
        }

        public String getName() {
            return "Long.parseLong(String)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(Long.MIN_VALUE, Long.MAX_VALUE);
                this._strings[i] = String.valueOf(this._expected[i]);
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = Long.parseLong(this._strings[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() {
            TestContext.assertArrayEquals(this._expected, this._actual);
            TestContext.assertEquals(Long.MIN_VALUE, TypeFormat.parseLong("-9223372036854775808"));
            TestContext.assertEquals(0L, TypeFormat.parseLong("0"));
            TestContext.assertEquals(Long.MAX_VALUE, TypeFormat.parseLong("9223372036854775807"));
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    Long.parseLong("9223372036854775808");
                }
            });
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    Long.parseLong("123E4");
                }
            });
        }
    }

    class ParseLong
    extends TestCase {
        long[] _expected = new long[1000];
        long[] _actual = new long[1000];
        String[] _strings = new String[1000];

        ParseLong() {
        }

        public String getName() {
            return "TypeFormat.parseLong(CharSequence)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(Long.MIN_VALUE, Long.MAX_VALUE);
                this._strings[i] = String.valueOf(this._expected[i]);
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseLong(this._strings[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() {
            TestContext.assertArrayEquals(this._expected, this._actual);
            TestContext.assertEquals(Long.MIN_VALUE, TypeFormat.parseLong("-9223372036854775808"));
            TestContext.assertEquals(0L, TypeFormat.parseLong("0"));
            TestContext.assertEquals(Long.MAX_VALUE, TypeFormat.parseLong("9223372036854775807"));
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    TypeFormat.parseLong("9223372036854775808");
                }
            });
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    TypeFormat.parseLong("123E4");
                }
            });
        }
    }

    class IntegerParseInt
    extends TestCase {
        int[] _expected = new int[1000];
        int[] _actual = new int[1000];
        String[] _strings = new String[1000];

        IntegerParseInt() {
        }

        public String getName() {
            return "Integer.parseInt(String)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(Integer.MIN_VALUE, Integer.MAX_VALUE);
                this._strings[i] = String.valueOf(this._expected[i]);
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = Integer.parseInt(this._strings[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() {
            TestContext.assertArrayEquals(this._expected, this._actual);
            TestContext.assertEquals(Integer.MIN_VALUE, Integer.parseInt("-2147483648"));
            TestContext.assertEquals(0, Integer.parseInt("0"));
            TestContext.assertEquals(Integer.MAX_VALUE, Integer.parseInt("2147483647"));
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    Integer.parseInt("2147483648");
                }
            });
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    Integer.parseInt("123E4");
                }
            });
        }
    }

    class ParseInt
    extends TestCase {
        int[] _expected = new int[1000];
        int[] _actual = new int[1000];
        String[] _strings = new String[1000];

        ParseInt() {
        }

        public String getName() {
            return "TypeFormat.parseInt(CharSequence)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(Integer.MIN_VALUE, Integer.MAX_VALUE);
                this._strings[i] = String.valueOf(this._expected[i]);
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseInt(this._strings[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() {
            TestContext.assertArrayEquals(this._expected, this._actual);
            TestContext.assertEquals(Integer.MIN_VALUE, TypeFormat.parseInt("-2147483648"));
            TestContext.assertEquals(0, TypeFormat.parseInt("0"));
            TestContext.assertEquals(Integer.MAX_VALUE, TypeFormat.parseInt("2147483647"));
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    TypeFormat.parseInt("2147483648");
                }
            });
            TestContext.assertException(NumberFormatException.class, new Runnable(){

                public void run() {
                    TypeFormat.parseInt("123E4");
                }
            });
        }
    }

    class BooleanParse
    extends TestCase {
        boolean[] _expected = new boolean[1000];
        boolean[] _actual = new boolean[1000];
        String[] _strings = new String[1000];

        BooleanParse() {
        }

        public String getName() {
            return "Boolean.parse(String)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(0, 1) != 0;
                this._strings[i] = this._expected[i] ? new String("true") : new String("false");
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = this.parseBoolean(this._strings[i]);
            }
        }

        private boolean parseBoolean(String str) {
            return Boolean.parseBoolean(str);
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() {
            TestContext.assertArrayEquals(this._expected, this._actual);
        }
    }

    class ParseBoolean
    extends TestCase {
        boolean[] _expected = new boolean[1000];
        boolean[] _actual = new boolean[1000];
        String[] _strings = new String[1000];

        ParseBoolean() {
        }

        public String getName() {
            return "TypeFormat.parseBoolean(CharSequence)";
        }

        public void setUp() {
            for (int i = 0; i < this._expected.length; ++i) {
                this._expected[i] = MathLib.random(0, 1) != 0;
                this._strings[i] = this._expected[i] ? new String("true") : new String("false");
            }
        }

        public void execute() {
            for (int i = 0; i < 1000; ++i) {
                this._actual[i] = TypeFormat.parseBoolean(this._strings[i]);
            }
        }

        public int count() {
            return this._expected.length;
        }

        public void validate() {
            TestContext.assertArrayEquals(this._expected, this._actual);
            TestContext.assertException(IllegalArgumentException.class, new Runnable(){

                public void run() {
                    TypeFormat.parseBoolean("TRUE?");
                }
            });
        }
    }
}

