/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.ObjectStreamException;
import javolution.Javolution;
import javolution.lang.Immutable;
import javolution.text.CharArray;
import javolution.text.TextBuilder;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;

public final class QName
implements XMLSerializable,
Immutable,
CharSequence {
    static final XMLFormat XML = new XMLFormat(QName.class){

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            CharArray namespaceURI = xml.getAttribute("namespaceURI");
            CharArray localName = xml.getAttribute("localName");
            return QName.valueOf(namespaceURI, localName);
        }

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            QName qName = (QName)obj;
            xml.setAttribute("namespaceURI", qName._namespaceURI);
            xml.setAttribute("localName", qName._localName);
        }
    };
    private final transient CharArray _localName;
    private final transient CharArray _namespaceURI;
    private final String _toString;
    private static final FastMap FULL_NAME_TO_QNAME = new FastMap().setKeyComparator(FastComparator.LEXICAL).setShared(true);

    private QName(String namespaceURI, String localName, String toString) {
        this._namespaceURI = namespaceURI == null ? null : new CharArray(namespaceURI);
        this._localName = new CharArray(localName);
        this._toString = toString;
    }

    public static QName valueOf(CharSequence name) {
        QName qName = (QName)FULL_NAME_TO_QNAME.get(name);
        return qName != null ? qName : QName.createNoNamespace(((Object)name).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QName createNoNamespace(String name) {
        String localName = name;
        String namespaceURI = null;
        if (name.length() > 0 && name.charAt(0) == '{') {
            int index = name.lastIndexOf(125);
            localName = name.substring(index + 1);
            namespaceURI = name.substring(1, index);
        }
        QName qName = new QName(namespaceURI, localName, name);
        FastMap fastMap = FULL_NAME_TO_QNAME;
        synchronized (fastMap) {
            QName tmp = FULL_NAME_TO_QNAME.putIfAbsent(name, qName);
            return tmp == null ? qName : tmp;
        }
    }

    public static QName valueOf(String name) {
        QName qName = (QName)FULL_NAME_TO_QNAME.get(name);
        return qName != null ? qName : QName.createNoNamespace(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QName valueOf(CharSequence namespaceURI, CharSequence localName) {
        if (namespaceURI == null) {
            return QName.valueOf(localName);
        }
        TextBuilder tmp = TextBuilder.newInstance();
        try {
            tmp.append('{');
            tmp.append(namespaceURI);
            tmp.append('}');
            tmp.append(localName);
            QName qName = QName.valueOf(tmp);
            return qName;
        }
        finally {
            TextBuilder.recycle(tmp);
        }
    }

    public CharSequence getLocalName() {
        return this._localName;
    }

    public CharSequence getNamespaceURI() {
        return this._namespaceURI;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        return this._toString;
    }

    public int hashCode() {
        return this._toString.hashCode();
    }

    public char charAt(int index) {
        return this._toString.charAt(index);
    }

    public int length() {
        return this._toString.length();
    }

    public CharSequence subSequence(int start, int end) {
        return Javolution.j2meToCharSeq(this._toString.substring(start, end));
    }

    private Object readResolve() throws ObjectStreamException {
        return QName.valueOf(this._toString);
    }
}

