/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import java.util.logging.Logger;

public class CastleUpdater
implements Runnable {
    protected static final Logger _log = Logger.getLogger(CastleUpdater.class.getName());
    private L2Clan _clan;
    private int _runCount = 0;

    public CastleUpdater(L2Clan clan, int runCount) {
        this._clan = clan;
        this._runCount = runCount;
    }

    @Override
    public void run() {
        try {
            ItemContainer warehouse = this._clan.getWarehouse();
            if (warehouse != null && this._clan.getHasCastle() > 0) {
                Castle castle = CastleManager.getInstance().getCastleById(this._clan.getHasCastle());
                if (!Config.ALT_MANOR_SAVE_ALL_ACTIONS && this._runCount % Config.ALT_MANOR_SAVE_PERIOD_RATE == 0) {
                    castle.saveSeedData();
                    castle.saveCropData();
                    if (Config.DEBUG) {
                        _log.info("Manor System: all data for " + castle.getName() + " saved");
                    }
                }
                CastleUpdater cu = new CastleUpdater(this._clan, ++this._runCount);
                ThreadPoolManager.getInstance().scheduleGeneral(cu, 3600000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

