/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.instancemanager.DayNightSpawnManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class GameTimeController {
    protected static final Logger _log = Logger.getLogger(GameTimeController.class.getName());
    public static final int TICKS_PER_SECOND = 10;
    public static final int MILLIS_IN_TICK = 100;
    protected static int _gameTicks;
    protected static long _gameStartTime;
    protected static boolean _isNight;
    protected static boolean _interruptRequest;
    private static final FastMap<Integer, L2Character> _movingObjects;
    private static final FastList<L2Character> _toDelete;
    protected static TimerThread _timer;

    public static GameTimeController getInstance() {
        return SingletonHolder._instance;
    }

    private GameTimeController() {
        _log.info("Initializing Game Time Controller");
        _gameStartTime = System.currentTimeMillis() - 3600000L;
        _gameTicks = 36000;
        _timer = new TimerThread();
        _timer.start();
        ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new BroadcastSunState(), 0L, 600000L);
    }

    public boolean isNowNight() {
        return _isNight;
    }

    public int getGameTime() {
        return _gameTicks / 100;
    }

    public static int getGameTicks() {
        return _gameTicks;
    }

    public void registerMovingObject(L2Character cha) {
        if (cha == null) {
            return;
        }
        _movingObjects.putIfAbsent((Object)cha.getObjectId(), (Object)cha);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveObjects() {
        for (L2Character ch : _movingObjects.values()) {
            if (!ch.updatePosition(_gameTicks)) continue;
            _toDelete.add((Object)ch);
        }
        if (_toDelete.isEmpty()) {
            return;
        }
        FastMap<Integer, L2Character> fastMap = _movingObjects;
        synchronized (fastMap) {
            for (L2Character ch : _toDelete) {
                _movingObjects.remove((Object)ch.getObjectId());
                ThreadPoolManager.getInstance().executeTask(new MovingObjectArrived(ch));
            }
        }
        _toDelete.clear();
    }

    public void stopTimer() {
        _interruptRequest = true;
        _timer.interrupt();
    }

    static {
        _isNight = false;
        _interruptRequest = false;
        _movingObjects = new FastMap().setShared(true);
        _toDelete = new FastList(20);
    }

    private static class SingletonHolder {
        protected static final GameTimeController _instance = new GameTimeController();

        private SingletonHolder() {
        }
    }

    class BroadcastSunState
    implements Runnable {
        int h;
        boolean tempIsNight;

        BroadcastSunState() {
        }

        @Override
        public void run() {
            this.h = GameTimeController.this.getGameTime() / 60 % 24;
            boolean bl = this.tempIsNight = this.h < 6;
            if (this.tempIsNight != _isNight) {
                _isNight = this.tempIsNight;
                DayNightSpawnManager.getInstance().notifyChangeMode();
            }
        }
    }

    class MovingObjectArrived
    implements Runnable {
        private final L2Character _ended;

        MovingObjectArrived(L2Character ended) {
            this._ended = ended;
        }

        @Override
        public void run() {
            try {
                if (this._ended.hasAI()) {
                    if (Config.MOVE_BASED_KNOWNLIST) {
                        this._ended.getKnownList().findObjects();
                    }
                    this._ended.getAI().notifyEvent(CtrlEvent.EVT_ARRIVED);
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
    }

    class TimerThread
    extends Thread {
        public TimerThread() {
            super("GameTimeController");
            this.setDaemon(true);
            this.setPriority(10);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int sleepTime;
                        long runtime;
                        int oldTicks;
                        if ((oldTicks = _gameTicks) != (_gameTicks = (int)((runtime = System.currentTimeMillis() - _gameStartTime) / 100L))) {
                            GameTimeController.this.moveObjects();
                        }
                        if ((sleepTime = 101 - (int)(runtime = System.currentTimeMillis() - _gameStartTime - runtime) % 100) <= 0) continue;
                        Thread.sleep(sleepTime);
                    }
                }
                catch (InterruptedException ie) {
                    if (_interruptRequest) {
                        return;
                    }
                    ie.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

