/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Item;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.skills.SkillsEngine;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.item.L2Armor;
import com.l2jserver.gameserver.templates.item.L2ArmorType;
import com.l2jserver.gameserver.templates.item.L2EtcItem;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.gameserver.util.GMAudit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class ItemTable {
    private static Logger _log = Logger.getLogger(ItemTable.class.getName());
    private static Logger _logItems = Logger.getLogger("item");
    private static final Map<String, Integer> _materials = new FastMap();
    private static final Map<String, Integer> _crystalTypes = new FastMap();
    private static final Map<String, L2WeaponType> _weaponTypes = new FastMap();
    private static final Map<String, L2ArmorType> _armorTypes = new FastMap();
    private static final Map<String, Integer> _slots = new FastMap();
    private L2Item[] _allTemplates;
    private Map<Integer, L2EtcItem> _etcItems = new FastMap();
    private Map<Integer, L2Armor> _armors = new FastMap();
    private Map<Integer, L2Weapon> _weapons = new FastMap();
    private boolean _initialized = true;
    private static final String[] SQL_ITEM_SELECTS;
    private static final String[] SQL_CUSTOM_ITEM_SELECTS;

    public static ItemTable getInstance() {
        return SingletonHolder._instance;
    }

    @Deprecated
    public Item newItem() {
        return new Item();
    }

    private ItemTable() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Iterator<L2Item> i$;
        Item newItem;
        ResultSet rset;
        PreparedStatement statement;
        FastMap itemData = new FastMap();
        FastMap weaponData = new FastMap();
        FastMap armorData = new FastMap();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            for (String selectQuery : SQL_ITEM_SELECTS) {
                statement = con.prepareStatement(selectQuery);
                rset = statement.executeQuery();
                while (rset.next()) {
                    if (selectQuery.endsWith("etcitem")) {
                        newItem = this.readItem(rset);
                        itemData.put(newItem.id, newItem);
                        continue;
                    }
                    if (selectQuery.endsWith("armor")) {
                        newItem = this.readArmor(rset);
                        armorData.put(newItem.id, newItem);
                        continue;
                    }
                    if (!selectQuery.endsWith("weapon")) continue;
                    newItem = this.readWeapon(rset);
                    weaponData.put(newItem.id, newItem);
                }
                rset.close();
                statement.close();
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "data error on item: ", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        if (Config.CUSTOM_ITEM_TABLES) {
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                for (String selectQuery : SQL_CUSTOM_ITEM_SELECTS) {
                    statement = con.prepareStatement(selectQuery);
                    rset = statement.executeQuery();
                    while (rset.next()) {
                        if (selectQuery.endsWith("etcitem")) {
                            newItem = this.readItem(rset);
                            if (itemData.containsKey(newItem.id)) {
                                itemData.remove(newItem.id);
                            }
                            itemData.put(newItem.id, newItem);
                            continue;
                        }
                        if (selectQuery.endsWith("armor")) {
                            newItem = this.readArmor(rset);
                            if (armorData.containsKey(newItem.id)) {
                                armorData.remove(newItem.id);
                            }
                            armorData.put(newItem.id, newItem);
                            continue;
                        }
                        if (!selectQuery.endsWith("weapon")) continue;
                        newItem = this.readWeapon(rset);
                        if (weaponData.containsKey(newItem.id)) {
                            weaponData.remove(newItem.id);
                        }
                        weaponData.put(newItem.id, newItem);
                    }
                    rset.close();
                    statement.close();
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "data error on custom_item: ", e);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
        this._armors.clear();
        for (L2Armor armor : SkillsEngine.getInstance().loadArmors((Map<Integer, Item>)armorData)) {
            this._armors.put(armor.getItemId(), armor);
        }
        _log.config("ItemTable: Loaded " + this._armors.size() + " Armors.");
        this._etcItems.clear();
        for (L2EtcItem item : SkillsEngine.getInstance().loadItems((Map<Integer, Item>)itemData)) {
            this._etcItems.put(item.getItemId(), item);
        }
        _log.config("ItemTable: Loaded " + this._etcItems.size() + " Items.");
        this._weapons.clear();
        for (L2Weapon weapon : SkillsEngine.getInstance().loadWeapons((Map<Integer, Item>)weaponData)) {
            this._weapons.put(weapon.getItemId(), weapon);
        }
        _log.config("ItemTable: Loaded " + this._weapons.size() + " Weapons.");
        weaponData.keySet().removeAll(this._weapons.keySet());
        if (!weaponData.isEmpty()) {
            i$ = weaponData.keySet().iterator();
            while (i$.hasNext()) {
                int id = (Integer)((Object)i$.next());
                _log.info("Weapon id: " + id + " missing XML info!");
            }
        }
        armorData.keySet().removeAll(this._armors.keySet());
        if (!armorData.isEmpty()) {
            i$ = armorData.keySet().iterator();
            while (i$.hasNext()) {
                int id = (Integer)((Object)i$.next());
                _log.info("Armor id: " + id + " missing XML info!");
            }
        }
        this.buildFastLookupTable();
    }

    private Item readWeapon(ResultSet rset) throws SQLException {
        Item item = new Item();
        item.set = new StatsSet();
        item.type = _weaponTypes.get(rset.getString("weaponType"));
        item.id = rset.getInt("item_id");
        item.name = rset.getString("name");
        item.set.set("item_id", item.id);
        item.set.set("name", item.name);
        if (item.type == L2WeaponType.NONE) {
            item.set.set("type1", 1);
            item.set.set("type2", 1);
        } else {
            item.set.set("type1", 0);
            item.set.set("type2", 0);
        }
        item.set.set("bodypart", _slots.get(rset.getString("bodypart")));
        item.set.set("material", _materials.get(rset.getString("material")));
        item.set.set("crystal_type", _crystalTypes.get(rset.getString("crystal_type")));
        item.set.set("crystallizable", Boolean.valueOf(rset.getString("crystallizable")));
        item.set.set("weight", rset.getInt("weight"));
        item.set.set("soulshots", rset.getInt("soulshots"));
        item.set.set("spiritshots", rset.getInt("spiritshots"));
        item.set.set("p_dam", rset.getInt("p_dam"));
        item.set.set("rnd_dam", rset.getInt("rnd_dam"));
        item.set.set("critical", rset.getInt("critical"));
        item.set.set("hit_modify", rset.getDouble("hit_modify"));
        item.set.set("avoid_modify", rset.getInt("avoid_modify"));
        item.set.set("shield_def", rset.getInt("shield_def"));
        item.set.set("shield_def_rate", rset.getInt("shield_def_rate"));
        item.set.set("atk_speed", rset.getInt("atk_speed"));
        item.set.set("mp_consume", rset.getInt("mp_consume"));
        item.set.set("m_dam", rset.getInt("m_dam"));
        item.set.set("duration", rset.getInt("duration"));
        item.set.set("time", rset.getInt("time"));
        item.set.set("price", rset.getInt("price"));
        item.set.set("crystal_count", rset.getInt("crystal_count"));
        item.set.set("sellable", Boolean.valueOf(rset.getString("sellable")));
        item.set.set("dropable", Boolean.valueOf(rset.getString("dropable")));
        item.set.set("destroyable", Boolean.valueOf(rset.getString("destroyable")));
        item.set.set("tradeable", Boolean.valueOf(rset.getString("tradeable")));
        item.set.set("depositable", Boolean.valueOf(rset.getString("depositable")));
        item.set.set("skill", rset.getString("skill"));
        item.set.set("enchant4_skill_id", rset.getInt("enchant4_skill_id"));
        item.set.set("enchant4_skill_lvl", rset.getInt("enchant4_skill_lvl"));
        item.set.set("onCast_skill_id", rset.getInt("onCast_skill_id"));
        item.set.set("onCast_skill_lvl", rset.getInt("onCast_skill_lvl"));
        item.set.set("onCast_skill_chance", rset.getInt("onCast_skill_chance"));
        item.set.set("onCrit_skill_id", rset.getInt("onCrit_skill_id"));
        item.set.set("onCrit_skill_lvl", rset.getInt("onCrit_skill_lvl"));
        item.set.set("onCrit_skill_chance", rset.getInt("onCrit_skill_chance"));
        item.set.set("change_weaponId", rset.getInt("change_weaponId"));
        if (item.type == L2WeaponType.PET) {
            item.set.set("type1", 0);
            if (item.set.getInteger("bodypart") == -100) {
                item.set.set("type2", 6);
            } else if (item.set.getInteger("bodypart") == -104) {
                item.set.set("type2", 10);
            } else if (item.set.getInteger("bodypart") == -101) {
                item.set.set("type2", 7);
            } else if (item.set.getInteger("bodypart") == -103) {
                item.set.set("type2", 9);
            } else {
                item.set.set("type2", 8);
            }
            item.set.set("bodypart", 128);
        }
        return item;
    }

    private Item readArmor(ResultSet rset) throws SQLException {
        Item item = new Item();
        item.set = new StatsSet();
        item.type = _armorTypes.get(rset.getString("armor_type"));
        item.id = rset.getInt("item_id");
        item.name = rset.getString("name");
        item.set.set("item_id", item.id);
        item.set.set("name", item.name);
        int bodypart = _slots.get(rset.getString("bodypart"));
        item.set.set("bodypart", bodypart);
        item.set.set("crystallizable", Boolean.valueOf(rset.getString("crystallizable")));
        item.set.set("crystal_count", rset.getInt("crystal_count"));
        item.set.set("sellable", Boolean.valueOf(rset.getString("sellable")));
        item.set.set("dropable", Boolean.valueOf(rset.getString("dropable")));
        item.set.set("destroyable", Boolean.valueOf(rset.getString("destroyable")));
        item.set.set("tradeable", Boolean.valueOf(rset.getString("tradeable")));
        item.set.set("depositable", Boolean.valueOf(rset.getString("depositable")));
        item.set.set("enchant4_skill", rset.getString("enchant4_skill"));
        item.set.set("skill", rset.getString("skill"));
        if (bodypart == 8 || bodypart == 65536 || bodypart == 262144 || bodypart == 524288 || (bodypart & 4) != 0 || (bodypart & 0x20) != 0 || (bodypart & 0x100000) != 0 || (bodypart & 0x200000) != 0 || (bodypart & 0x2000) != 0) {
            item.set.set("type1", 0);
            item.set.set("type2", 2);
        } else {
            item.set.set("type1", 1);
            item.set.set("type2", 1);
        }
        item.set.set("weight", rset.getInt("weight"));
        item.set.set("material", _materials.get(rset.getString("material")));
        item.set.set("crystal_type", _crystalTypes.get(rset.getString("crystal_type")));
        item.set.set("avoid_modify", rset.getInt("avoid_modify"));
        item.set.set("duration", rset.getInt("duration"));
        item.set.set("time", rset.getInt("time"));
        item.set.set("p_def", rset.getInt("p_def"));
        item.set.set("m_def", rset.getInt("m_def"));
        item.set.set("mp_bonus", rset.getInt("mp_bonus"));
        item.set.set("price", rset.getInt("price"));
        if (item.type == L2ArmorType.PET) {
            if (bodypart == 8) {
                item.set.set("type1", 0);
                item.set.set("type2", 2);
                item.set.set("bodypart", 8);
            } else {
                item.set.set("type1", 1);
                switch (item.set.getInteger("bodypart")) {
                    case -100: {
                        item.set.set("type2", 6);
                        break;
                    }
                    case -104: {
                        item.set.set("type2", 10);
                        break;
                    }
                    case -101: {
                        item.set.set("type2", 7);
                        break;
                    }
                    case -103: {
                        item.set.set("type2", 9);
                        break;
                    }
                    default: {
                        item.set.set("type2", 8);
                    }
                }
                item.set.set("bodypart", 1024);
            }
        }
        return item;
    }

    private Item readItem(ResultSet rset) throws SQLException {
        Item item = new Item();
        item.set = new StatsSet();
        item.id = rset.getInt("item_id");
        item.set.set("item_id", item.id);
        item.set.set("crystallizable", Boolean.valueOf(rset.getString("crystallizable")));
        item.set.set("type1", 4);
        item.set.set("type2", 5);
        item.set.set("bodypart", 0);
        item.set.set("crystal_count", rset.getInt("crystal_count"));
        item.set.set("sellable", Boolean.valueOf(rset.getString("sellable")));
        item.set.set("dropable", Boolean.valueOf(rset.getString("dropable")));
        item.set.set("destroyable", Boolean.valueOf(rset.getString("destroyable")));
        item.set.set("tradeable", Boolean.valueOf(rset.getString("tradeable")));
        item.set.set("depositable", Boolean.valueOf(rset.getString("depositable")));
        item.set.set("handler", rset.getString("handler"));
        item.set.set("skill", rset.getString("skill"));
        String itemType = rset.getString("item_type");
        if (itemType.equals("none")) {
            item.type = L2EtcItemType.OTHER;
        } else if (itemType.equals("castle_guard")) {
            item.type = L2EtcItemType.SCROLL;
        } else if (itemType.equals("material")) {
            item.type = L2EtcItemType.MATERIAL;
        } else if (itemType.equals("pet_collar")) {
            item.type = L2EtcItemType.PET_COLLAR;
        } else if (itemType.equals("potion")) {
            item.type = L2EtcItemType.POTION;
        } else if (itemType.equals("recipe")) {
            item.type = L2EtcItemType.RECEIPE;
        } else if (itemType.equals("scroll")) {
            item.type = L2EtcItemType.SCROLL;
        } else if (itemType.equals("seed")) {
            item.type = L2EtcItemType.SEED;
        } else if (itemType.equals("shot")) {
            item.type = L2EtcItemType.SHOT;
        } else if (itemType.equals("spellbook")) {
            item.type = L2EtcItemType.SPELLBOOK;
        } else if (itemType.equals("herb")) {
            item.type = L2EtcItemType.HERB;
        } else if (itemType.equals("arrow")) {
            item.type = L2EtcItemType.ARROW;
            item.set.set("bodypart", 256);
        } else if (itemType.equals("bolt")) {
            item.type = L2EtcItemType.BOLT;
            item.set.set("bodypart", 256);
        } else if (itemType.equals("quest")) {
            item.type = L2EtcItemType.QUEST;
            item.set.set("type2", 3);
        } else if (itemType.equals("lure")) {
            item.type = L2EtcItemType.OTHER;
            item.set.set("bodypart", 256);
        } else {
            _log.fine("unknown etcitem type:" + itemType);
            item.type = L2EtcItemType.OTHER;
        }
        String consume = rset.getString("consume_type");
        if (consume.equals("asset")) {
            item.type = L2EtcItemType.MONEY;
            item.set.set("stackable", true);
            item.set.set("type2", 4);
        } else if (consume.equals("stackable")) {
            item.set.set("stackable", true);
        } else {
            item.set.set("stackable", false);
        }
        int material = _materials.get(rset.getString("material"));
        item.set.set("material", material);
        int crystal = _crystalTypes.get(rset.getString("crystal_type"));
        item.set.set("crystal_type", crystal);
        int weight = rset.getInt("weight");
        item.set.set("weight", weight);
        item.name = rset.getString("name");
        item.set.set("name", item.name);
        item.set.set("duration", rset.getInt("duration"));
        item.set.set("time", rset.getInt("time"));
        item.set.set("price", rset.getInt("price"));
        return item;
    }

    @Deprecated
    public boolean isInitialized() {
        return this._initialized;
    }

    private void buildFastLookupTable() {
        int highestId = 0;
        for (L2Armor l2Armor : this._armors.values()) {
            if (l2Armor.getItemId() <= highestId) continue;
            highestId = l2Armor.getItemId();
        }
        for (L2Weapon l2Weapon : this._weapons.values()) {
            if (l2Weapon.getItemId() <= highestId) continue;
            highestId = l2Weapon.getItemId();
        }
        for (L2EtcItem l2EtcItem : this._etcItems.values()) {
            if (l2EtcItem.getItemId() <= highestId) continue;
            highestId = l2EtcItem.getItemId();
        }
        _log.info("Highest item id used:" + highestId);
        this._allTemplates = new L2Item[highestId + 1];
        for (L2Armor l2Armor : this._armors.values()) {
            assert (this._allTemplates[l2Armor.getItemId()] == null);
            this._allTemplates[l2Armor.getItemId()] = l2Armor;
        }
        for (L2Weapon l2Weapon : this._weapons.values()) {
            assert (this._allTemplates[l2Weapon.getItemId()] == null);
            this._allTemplates[l2Weapon.getItemId()] = l2Weapon;
        }
        for (L2EtcItem l2EtcItem : this._etcItems.values()) {
            assert (this._allTemplates[l2EtcItem.getItemId()] == null);
            this._allTemplates[l2EtcItem.getItemId()] = l2EtcItem;
        }
    }

    public L2Item getTemplate(int id) {
        if (id >= this._allTemplates.length) {
            return null;
        }
        return this._allTemplates[id];
    }

    public L2ItemInstance createItem(String process, int itemId, long count, L2PcInstance actor, L2Object reference) {
        L2ItemInstance item = new L2ItemInstance(IdFactory.getInstance().getNextId(), itemId);
        if (process.equalsIgnoreCase("loot")) {
            ScheduledFuture<?> itemLootShedule;
            if (reference instanceof L2Attackable && ((L2Attackable)reference).isRaid()) {
                L2Attackable raid = (L2Attackable)reference;
                if (raid.getFirstCommandChannelAttacked() != null && !Config.AUTO_LOOT_RAIDS) {
                    item.setOwnerId(raid.getFirstCommandChannelAttacked().getChannelLeader().getObjectId());
                    itemLootShedule = ThreadPoolManager.getInstance().scheduleGeneral(new resetOwner(item), Config.LOOT_RAIDS_PRIVILEGE_INTERVAL);
                    item.setItemLootShedule(itemLootShedule);
                }
            } else if (!Config.AUTO_LOOT) {
                item.setOwnerId(actor.getObjectId());
                itemLootShedule = ThreadPoolManager.getInstance().scheduleGeneral(new resetOwner(item), 15000L);
                item.setItemLootShedule(itemLootShedule);
            }
        }
        if (Config.DEBUG) {
            _log.fine("ItemTable: Item created  oid:" + item.getObjectId() + " itemid:" + itemId);
        }
        L2World.getInstance().storeObject(item);
        if (item.isStackable() && count > 1L) {
            item.setCount(count);
        }
        if (Config.LOG_ITEMS && !process.equals("Reset")) {
            LogRecord record = new LogRecord(Level.INFO, "CREATE:" + process);
            record.setLoggerName("item");
            record.setParameters(new Object[]{item, actor, reference});
            _logItems.log(record);
        }
        if (actor != null && actor.isGM()) {
            String targetName;
            String referenceName = "no-reference";
            if (reference != null) {
                referenceName = reference.getName() != null ? reference.getName() : "no-name";
            }
            String string = targetName = actor.getTarget() != null ? actor.getTarget().getName() : "no-target";
            if (Config.GMAUDIT) {
                GMAudit.auditGMAction(actor.getName(), process + "(id: " + itemId + " count: " + count + " name: " + item.getItemName() + " objId: " + item.getObjectId() + ")", targetName, "L2Object referencing this action is: " + referenceName);
            }
        }
        return item;
    }

    public L2ItemInstance createItem(String process, int itemId, int count, L2PcInstance actor) {
        return this.createItem(process, itemId, count, actor, null);
    }

    public L2ItemInstance createDummyItem(int itemId) {
        L2Item item = this.getTemplate(itemId);
        if (item == null) {
            return null;
        }
        L2ItemInstance temp = new L2ItemInstance(0, item);
        try {
            temp = new L2ItemInstance(0, itemId);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (temp.getItem() == null) {
            _log.warning("ItemTable: Item Template missing for Id: " + itemId);
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyItem(String process, L2ItemInstance item, L2PcInstance actor, L2Object reference) {
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            item.setCount(0L);
            item.setOwnerId(0);
            item.setLocation(L2ItemInstance.ItemLocation.VOID);
            item.setLastChange(3);
            L2World.getInstance().removeObject(item);
            IdFactory.getInstance().releaseId(item.getObjectId());
            if (Config.LOG_ITEMS) {
                LogRecord record = new LogRecord(Level.INFO, "DELETE:" + process);
                record.setLoggerName("item");
                record.setParameters(new Object[]{item, actor, reference});
                _logItems.log(record);
            }
            if (actor != null && actor.isGM()) {
                String targetName;
                String referenceName = "no-reference";
                if (reference != null) {
                    referenceName = reference.getName() != null ? reference.getName() : "no-name";
                }
                String string = targetName = actor.getTarget() != null ? actor.getTarget().getName() : "no-target";
                if (Config.GMAUDIT) {
                    GMAudit.auditGMAction(actor.getName(), process + "(id: " + item.getItemId() + " count: " + item.getCount() + " itemObjId: " + item.getObjectId() + ")", targetName, "L2Object referencing this action is: " + referenceName);
                }
            }
            if (PetDataTable.isPetItem(item.getItemId())) {
                Connection con = null;
                try {
                    con = L2DatabaseFactory.getInstance().getConnection();
                    PreparedStatement statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id=?");
                    statement.setInt(1, item.getObjectId());
                    statement.execute();
                    statement.close();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "could not delete pet objectid:", e);
                }
                finally {
                    try {
                        con.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public void reload() {
        this.load();
    }

    public Collection<Integer> getAllEtcId() {
        return this._etcItems.keySet();
    }

    public Collection<Integer> getAllArmorsId() {
        return this._armors.keySet();
    }

    public Collection<Integer> getAllWeaponsId() {
        return this._weapons.keySet();
    }

    static {
        _materials.put("paper", 8);
        _materials.put("wood", 9);
        _materials.put("liquid", 18);
        _materials.put("cloth", 10);
        _materials.put("leather", 11);
        _materials.put("horn", 13);
        _materials.put("bone", 12);
        _materials.put("bronze", 3);
        _materials.put("fine_steel", 1);
        _materials.put("cotton", 1);
        _materials.put("mithril", 6);
        _materials.put("silver", 4);
        _materials.put("gold", 5);
        _materials.put("adamantaite", 15);
        _materials.put("steel", 0);
        _materials.put("oriharukon", 7);
        _materials.put("blood_steel", 2);
        _materials.put("crystal", 17);
        _materials.put("damascus", 14);
        _materials.put("chrysolite", 16);
        _materials.put("scale_of_dragon", 19);
        _materials.put("dyestuff", 20);
        _materials.put("cobweb", 21);
        _materials.put("seed", 21);
        _crystalTypes.put("s84", 7);
        _crystalTypes.put("s80", 6);
        _crystalTypes.put("s", 5);
        _crystalTypes.put("a", 4);
        _crystalTypes.put("b", 3);
        _crystalTypes.put("c", 2);
        _crystalTypes.put("d", 1);
        _crystalTypes.put("none", 0);
        _weaponTypes.put("blunt", L2WeaponType.BLUNT);
        _weaponTypes.put("bow", L2WeaponType.BOW);
        _weaponTypes.put("dagger", L2WeaponType.DAGGER);
        _weaponTypes.put("dual", L2WeaponType.DUAL);
        _weaponTypes.put("dualfist", L2WeaponType.DUALFIST);
        _weaponTypes.put("etc", L2WeaponType.ETC);
        _weaponTypes.put("fist", L2WeaponType.FIST);
        _weaponTypes.put("none", L2WeaponType.NONE);
        _weaponTypes.put("pole", L2WeaponType.POLE);
        _weaponTypes.put("sword", L2WeaponType.SWORD);
        _weaponTypes.put("bigsword", L2WeaponType.BIGSWORD);
        _weaponTypes.put("pet", L2WeaponType.PET);
        _weaponTypes.put("rod", L2WeaponType.ROD);
        _weaponTypes.put("bigblunt", L2WeaponType.BIGBLUNT);
        _weaponTypes.put("crossbow", L2WeaponType.CROSSBOW);
        _weaponTypes.put("rapier", L2WeaponType.RAPIER);
        _weaponTypes.put("ancient", L2WeaponType.ANCIENT_SWORD);
        _weaponTypes.put("dualdagger", L2WeaponType.DUAL_DAGGER);
        _armorTypes.put("none", L2ArmorType.NONE);
        _armorTypes.put("light", L2ArmorType.LIGHT);
        _armorTypes.put("heavy", L2ArmorType.HEAVY);
        _armorTypes.put("magic", L2ArmorType.MAGIC);
        _armorTypes.put("pet", L2ArmorType.PET);
        _armorTypes.put("sigil", L2ArmorType.SIGIL);
        _slots.put("shirt", 1);
        _slots.put("lbracelet", 0x200000);
        _slots.put("rbracelet", 0x100000);
        _slots.put("talisman", 0x400000);
        _slots.put("chest", 1024);
        _slots.put("fullarmor", 32768);
        _slots.put("head", 64);
        _slots.put("hair", 262144);
        _slots.put("face", 65536);
        _slots.put("hairall", 524288);
        _slots.put("underwear", 1);
        _slots.put("back", 8192);
        _slots.put("neck", 8);
        _slots.put("legs", 2048);
        _slots.put("feet", 4096);
        _slots.put("gloves", 512);
        _slots.put("chest,legs", 3072);
        _slots.put("belt", 0x10000000);
        _slots.put("rhand", 128);
        _slots.put("lhand", 256);
        _slots.put("lrhand", 16384);
        _slots.put("rear,lear", 6);
        _slots.put("rfinger,lfinger", 48);
        _slots.put("wolf", -100);
        _slots.put("greatwolf", -104);
        _slots.put("hatchling", -101);
        _slots.put("strider", -102);
        _slots.put("babypet", -103);
        _slots.put("none", 0);
        SQL_ITEM_SELECTS = new String[]{"SELECT item_id, name, crystallizable, item_type, weight, consume_type, material, crystal_type, duration, time, price, crystal_count, sellable, dropable, destroyable, tradeable, depositable, handler, skill FROM etcitem", "SELECT item_id, name, bodypart, crystallizable, armor_type, weight, material, crystal_type, avoid_modify, duration, time, p_def, m_def, mp_bonus, price, crystal_count, sellable, dropable, destroyable, tradeable, depositable, enchant4_skill, skill FROM armor", "SELECT item_id, name, bodypart, crystallizable, weight, soulshots, spiritshots, material, crystal_type, p_dam, rnd_dam, weaponType, critical, hit_modify, avoid_modify, shield_def, shield_def_rate, atk_speed, mp_consume, m_dam, duration, time, price, crystal_count, sellable, dropable, destroyable, tradeable, depositable, skill,enchant4_skill_id,enchant4_skill_lvl, onCast_skill_id, onCast_skill_lvl, onCast_skill_chance, onCrit_skill_id, onCrit_skill_lvl, onCrit_skill_chance, change_weaponId FROM weapon"};
        SQL_CUSTOM_ITEM_SELECTS = new String[]{"SELECT item_id, name, crystallizable, item_type, weight, consume_type, material, crystal_type, duration, time, price, crystal_count, sellable, dropable, destroyable, tradeable, depositable, handler, skill FROM custom_etcitem", "SELECT item_id, name, bodypart, crystallizable, armor_type, weight, material, crystal_type, avoid_modify, duration, time, p_def, m_def, mp_bonus, price, crystal_count, sellable, dropable, destroyable, tradeable, depositable, enchant4_skill, skill FROM custom_armor", "SELECT item_id, name, bodypart, crystallizable, weight, soulshots, spiritshots, material, crystal_type, p_dam, rnd_dam, weaponType, critical, hit_modify, avoid_modify, shield_def, shield_def_rate, atk_speed, mp_consume, m_dam, duration, time, price, crystal_count, sellable, dropable, destroyable, tradeable, depositable, skill,enchant4_skill_id,enchant4_skill_lvl, onCast_skill_id, onCast_skill_lvl, onCast_skill_chance, onCrit_skill_id, onCrit_skill_lvl, onCrit_skill_chance, change_weaponId FROM custom_weapon"};
    }

    private static class SingletonHolder {
        protected static final ItemTable _instance = new ItemTable();

        private SingletonHolder() {
        }
    }

    protected class resetOwner
    implements Runnable {
        L2ItemInstance _item;

        public resetOwner(L2ItemInstance item) {
            this._item = item;
        }

        @Override
        public void run() {
            this._item.setOwnerId(0);
            this._item.setItemLootShedule(null);
        }
    }
}

