/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NpcBufferTable {
    protected static Logger _log = Logger.getLogger(NpcBufferTable.class.getName());
    private TIntObjectHashMap<NpcBufferSkills> _buffers = new TIntObjectHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NpcBufferTable() {
        Connection con = null;
        int skillCount = 0;
        try {
            int buffGroup;
            int skillFeeAmount;
            int skillFeeId;
            int skillLevel;
            int skillId;
            int npcId;
            NpcBufferSkills skills;
            int lastNpcId;
            ResultSet rset;
            PreparedStatement statement;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement("SELECT `npc_id`,`skill_id`,`skill_level`,`skill_fee_id`,`skill_fee_amount`,`buff_group` FROM `npc_buffer` ORDER BY `npc_id` ASC");
                rset = statement.executeQuery();
                lastNpcId = 0;
                skills = null;
                while (rset.next()) {
                    npcId = rset.getInt("npc_id");
                    skillId = rset.getInt("skill_id");
                    skillLevel = rset.getInt("skill_level");
                    skillFeeId = rset.getInt("skill_fee_id");
                    skillFeeAmount = rset.getInt("skill_fee_amount");
                    buffGroup = rset.getInt("buff_group");
                    if (npcId != lastNpcId) {
                        if (lastNpcId != 0) {
                            this._buffers.put(lastNpcId, skills);
                        }
                        skills = new NpcBufferSkills(npcId);
                        skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                    } else {
                        skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                    }
                    lastNpcId = npcId;
                    ++skillCount;
                }
                if (lastNpcId != 0) {
                    this._buffers.put(lastNpcId, skills);
                }
                rset.close();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "NpcBufferTable: Error reading npc_buffer table: " + e.getMessage(), e);
            }
            if (Config.CUSTOM_NPCBUFFER_TABLES) {
                try {
                    statement = con.prepareStatement("SELECT `npc_id`,`skill_id`,`skill_level`,`skill_fee_id`,`skill_fee_amount`,`buff_group` FROM `custom_npc_buffer` ORDER BY `npc_id` ASC");
                    rset = statement.executeQuery();
                    lastNpcId = 0;
                    skills = null;
                    while (rset.next()) {
                        npcId = rset.getInt("npc_id");
                        skillId = rset.getInt("skill_id");
                        skillLevel = rset.getInt("skill_level");
                        skillFeeId = rset.getInt("skill_fee_id");
                        skillFeeAmount = rset.getInt("skill_fee_amount");
                        buffGroup = rset.getInt("buff_group");
                        if (npcId != lastNpcId) {
                            if (lastNpcId != 0) {
                                this._buffers.put(lastNpcId, (Object)skills);
                            }
                            skills = new NpcBufferSkills(npcId);
                            skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                        } else {
                            skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                        }
                        lastNpcId = npcId;
                        ++skillCount;
                    }
                    if (lastNpcId != 0) {
                        this._buffers.put(lastNpcId, skills);
                    }
                    rset.close();
                    statement.close();
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, "NpcBufferTable: Error reading custom_npc_buffer table: " + e.getMessage(), e);
                }
            }
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        _log.info("NpcBufferSkillIdsTable: Loaded " + this._buffers.size() + " buffers and " + skillCount + " skills.");
    }

    public static NpcBufferTable getInstance() {
        return SingletonHolder._instance;
    }

    public int[] getSkillInfo(int npcId, int buffGroup) {
        NpcBufferSkills skills = (NpcBufferSkills)this._buffers.get(npcId);
        if (skills == null) {
            return null;
        }
        return skills.getSkillGroupInfo(buffGroup);
    }

    private static class SingletonHolder {
        protected static final NpcBufferTable _instance = new NpcBufferTable();

        private SingletonHolder() {
        }
    }

    private class NpcBufferSkills {
        private int _npcId = 0;
        private TIntIntHashMap _skillId = new TIntIntHashMap();
        private TIntIntHashMap _skillLevels = new TIntIntHashMap();
        private TIntIntHashMap _skillFeeIds = new TIntIntHashMap();
        private TIntIntHashMap _skillFeeAmounts = new TIntIntHashMap();

        public NpcBufferSkills(int npcId) {
            this._npcId = npcId;
        }

        public void addSkill(int skillId, int skillLevel, int skillFeeId, int skillFeeAmount, int buffGroup) {
            this._skillId.put(buffGroup, skillId);
            this._skillLevels.put(buffGroup, skillLevel);
            this._skillFeeIds.put(buffGroup, skillFeeId);
            this._skillFeeAmounts.put(buffGroup, skillFeeAmount);
        }

        public int[] getSkillGroupInfo(int buffGroup) {
            Integer skillId = this._skillId.get(buffGroup);
            Integer skillLevel = this._skillLevels.get(buffGroup);
            Integer skillFeeId = this._skillFeeIds.get(buffGroup);
            Integer skillFeeAmount = this._skillFeeAmounts.get(buffGroup);
            if (skillId == null || skillLevel == null || skillFeeId == null || skillFeeAmount == null) {
                return null;
            }
            return new int[]{skillId, skillLevel, skillFeeId, skillFeeAmount};
        }

        public int getNpcId() {
            return this._npcId;
        }
    }
}

