/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.StaticObjects;
import com.l2jserver.gameserver.model.entity.ActionKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class UITable {
    private static Logger _log = Logger.getLogger(StaticObjects.class.getName());
    private Map<Integer, List<ActionKey>> _storedKeys = new FastMap();
    private Map<Integer, List<Integer>> _storedCategories = new FastMap();

    public static UITable getInstance() {
        return SingletonHolder._instance;
    }

    private UITable() {
        this.parseCatData();
        this.parseKeyData();
        _log.config("UITable: Loaded " + this._storedCategories.size() + " Categories.");
        _log.config("UITable: Loaded " + this._storedKeys.size() + " Keys.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCatData() {
        BufferedReader lnr = null;
        try {
            File uiData = new File(Config.DATAPACK_ROOT, "data/uicats_en.csv");
            lnr = new LineNumberReader(new BufferedReader(new FileReader(uiData)));
            String line = null;
            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line, ";");
                int cat = Integer.parseInt(st.nextToken());
                int cmd = Integer.parseInt(st.nextToken());
                this.insertCategory(cat, cmd);
            }
        }
        catch (FileNotFoundException e) {
            _log.warning("uicats_en.csv is missing in data folder");
        }
        catch (Exception e) {
            _log.warning("error while creating UI Default Categories table " + e);
        }
        finally {
            try {
                lnr.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseKeyData() {
        BufferedReader lnr = null;
        try {
            File uiData = new File(Config.DATAPACK_ROOT, "data/uikeys_en.csv");
            lnr = new LineNumberReader(new BufferedReader(new FileReader(uiData)));
            String line = null;
            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line, ";");
                int cat = Integer.parseInt(st.nextToken());
                int cmd = Integer.parseInt(st.nextToken());
                int key = Integer.parseInt(st.nextToken());
                int tk1 = Integer.parseInt(st.nextToken());
                int tk2 = Integer.parseInt(st.nextToken());
                int shw = Integer.parseInt(st.nextToken());
                this.insertKey(cat, cmd, key, tk1, tk2, shw);
            }
        }
        catch (FileNotFoundException e) {
            _log.warning("uikeys_en.csv is missing in data folder");
        }
        catch (Exception e) {
            _log.warning("error while creating UI Default Keys table " + e);
        }
        finally {
            try {
                lnr.close();
            }
            catch (Exception e) {}
        }
    }

    private void insertCategory(int cat, int cmd) {
        if (this._storedCategories.containsKey(cat)) {
            this._storedCategories.get(cat).add(cmd);
        } else {
            FastList tmp = new FastList();
            tmp.add(cmd);
            this._storedCategories.put(cat, (List<Integer>)tmp);
        }
    }

    private void insertKey(int cat, int cmdId, int key, int tgKey1, int tgKey2, int show) {
        ActionKey tmk = new ActionKey(cat, cmdId, key, tgKey1, tgKey2, show);
        if (this._storedKeys.containsKey(cat)) {
            this._storedKeys.get(cat).add(tmk);
        } else {
            FastList tmp = new FastList();
            tmp.add(tmk);
            this._storedKeys.put(cat, (List<ActionKey>)tmp);
        }
    }

    public Map<Integer, List<Integer>> getCategories() {
        return this._storedCategories;
    }

    public Map<Integer, List<ActionKey>> getKeys() {
        return this._storedKeys;
    }

    private static class SingletonHolder {
        protected static final UITable _instance = new UITable();

        private SingletonHolder() {
        }
    }
}

