/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.Config;
import com.l2jserver.gameserver.handler.IBypassHandler;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class BypassHandler {
    private static Logger _log = Logger.getLogger(BypassHandler.class.getName());
    private Map<String, IBypassHandler> _datatable = new FastMap();

    public static BypassHandler getInstance() {
        return SingletonHolder._instance;
    }

    private BypassHandler() {
    }

    public void registerBypassHandler(IBypassHandler handler) {
        String[] ids;
        for (String element : ids = handler.getBypassList()) {
            if (Config.DEBUG) {
                _log.log(Level.FINE, "Adding handler for command " + element);
            }
            this._datatable.put(element.toLowerCase(), handler);
        }
    }

    public IBypassHandler getBypassHandler(String BypassCommand) {
        String command = BypassCommand;
        if (BypassCommand.indexOf(" ") != -1) {
            command = BypassCommand.substring(0, BypassCommand.indexOf(" "));
        }
        if (Config.DEBUG) {
            _log.log(Level.FINE, "getting handler for command: " + command + " -> " + (this._datatable.get(command) != null));
        }
        return this._datatable.get(command.toLowerCase());
    }

    public int size() {
        return this._datatable.size();
    }

    private static class SingletonHolder {
        protected static final BypassHandler _instance = new BypassHandler();

        private SingletonHolder() {
        }
    }
}

