/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.CursedWeapon;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FeedableBeastInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FestivalMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FortCommanderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RiftInvaderInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Broadcast;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CursedWeaponsManager {
    private static final Logger _log = Logger.getLogger(CursedWeaponsManager.class.getName());
    private Map<Integer, CursedWeapon> _cursedWeapons;

    public static final CursedWeaponsManager getInstance() {
        return SingletonHolder._instance;
    }

    private CursedWeaponsManager() {
        this.init();
    }

    private void init() {
        _log.info("Initializing CursedWeaponsManager");
        this._cursedWeapons = new FastMap();
        if (!Config.ALLOW_CURSED_WEAPONS) {
            return;
        }
        this.load();
        this.restore();
        this.controlPlayers();
        _log.info("Loaded : " + this._cursedWeapons.size() + " cursed weapon(s).");
    }

    public final void reload() {
        this.init();
    }

    private final void load() {
        if (Config.DEBUG) {
            _log.info("  Parsing ... ");
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            File file = new File(Config.DATAPACK_ROOT + "/data/cursedWeapons.xml");
            if (!file.exists()) {
                if (Config.DEBUG) {
                    _log.info("NO FILE");
                }
                return;
            }
            Document doc = factory.newDocumentBuilder().parse(file);
            for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"item".equalsIgnoreCase(d.getNodeName())) continue;
                    NamedNodeMap attrs = d.getAttributes();
                    int id = Integer.parseInt(attrs.getNamedItem("id").getNodeValue());
                    int skillId = Integer.parseInt(attrs.getNamedItem("skillId").getNodeValue());
                    String name = attrs.getNamedItem("name").getNodeValue();
                    CursedWeapon cw = new CursedWeapon(id, skillId, name);
                    for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                        int val;
                        if ("dropRate".equalsIgnoreCase(cd.getNodeName())) {
                            attrs = cd.getAttributes();
                            val = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                            cw.setDropRate(val);
                            continue;
                        }
                        if ("duration".equalsIgnoreCase(cd.getNodeName())) {
                            attrs = cd.getAttributes();
                            val = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                            cw.setDuration(val);
                            continue;
                        }
                        if ("durationLost".equalsIgnoreCase(cd.getNodeName())) {
                            attrs = cd.getAttributes();
                            val = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                            cw.setDurationLost(val);
                            continue;
                        }
                        if ("disapearChance".equalsIgnoreCase(cd.getNodeName())) {
                            attrs = cd.getAttributes();
                            val = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                            cw.setDisapearChance(val);
                            continue;
                        }
                        if (!"stageKills".equalsIgnoreCase(cd.getNodeName())) continue;
                        attrs = cd.getAttributes();
                        val = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                        cw.setStageKills(val);
                    }
                    this._cursedWeapons.put(id, cw);
                }
            }
            if (Config.DEBUG) {
                _log.info("OK");
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error parsing cursed weapons file.", e);
            if (Config.DEBUG) {
                _log.warning("ERROR");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void restore() {
        if (Config.DEBUG) {
            _log.info("  Restoring ... ");
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT itemId, charId, playerKarma, playerPkKills, nbKills, endTime FROM cursed_weapons");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int itemId = rset.getInt("itemId");
                int playerId = rset.getInt("charId");
                int playerKarma = rset.getInt("playerKarma");
                int playerPkKills = rset.getInt("playerPkKills");
                int nbKills = rset.getInt("nbKills");
                long endTime = rset.getLong("endTime");
                CursedWeapon cw = this._cursedWeapons.get(itemId);
                cw.setPlayerId(playerId);
                cw.setPlayerKarma(playerKarma);
                cw.setPlayerPkKills(playerPkKills);
                cw.setNbKills(nbKills);
                cw.setEndTime(endTime);
                cw.reActivate();
            }
            rset.close();
            statement.close();
            if (Config.DEBUG) {
                _log.info("OK");
            }
        }
        catch (Exception e) {
            _log.warning("Could not restore CursedWeapons data: " + e);
            if (Config.DEBUG) {
                _log.warning("ERROR");
            }
            return;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void controlPlayers() {
        if (Config.DEBUG) {
            _log.info("  Checking players ... ");
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = null;
            ResultSet rset = null;
            for (CursedWeapon cw : this._cursedWeapons.values()) {
                if (cw.isActivated()) continue;
                int itemId = cw.getItemId();
                try {
                    statement = con.prepareStatement("SELECT owner_id FROM items WHERE item_id=?");
                    statement.setInt(1, itemId);
                    rset = statement.executeQuery();
                    if (rset.next()) {
                        int playerId = rset.getInt("owner_id");
                        _log.info("PROBLEM : Player " + playerId + " owns the cursed weapon " + itemId + " but he shouldn't.");
                        statement = con.prepareStatement("DELETE FROM items WHERE owner_id=? AND item_id=?");
                        statement.setInt(1, playerId);
                        statement.setInt(2, itemId);
                        if (statement.executeUpdate() != 1) {
                            _log.warning("Error while deleting cursed weapon " + itemId + " from userId " + playerId);
                        }
                        statement.close();
                        statement = con.prepareStatement("UPDATE characters SET karma=?, pkkills=? WHERE charId=?");
                        statement.setInt(1, cw.getPlayerKarma());
                        statement.setInt(2, cw.getPlayerPkKills());
                        statement.setInt(3, playerId);
                        if (statement.executeUpdate() != 1) {
                            _log.warning("Error while updating karma & pkkills for userId " + cw.getPlayerId());
                        }
                        CursedWeaponsManager.removeFromDb(itemId);
                    }
                    rset.close();
                    statement.close();
                }
                catch (SQLException sqlE) {}
            }
        }
        catch (Exception e) {
            if (Config.DEBUG) {
                _log.warning("Could not check CursedWeapons data: " + e);
            }
            return;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        if (Config.DEBUG) {
            _log.info("DONE");
        }
    }

    public synchronized void checkDrop(L2Attackable attackable, L2PcInstance player) {
        if (attackable instanceof L2DefenderInstance || attackable instanceof L2RiftInvaderInstance || attackable instanceof L2FestivalMonsterInstance || attackable instanceof L2GuardInstance || attackable instanceof L2GrandBossInstance || attackable instanceof L2FeedableBeastInstance || attackable instanceof L2FortCommanderInstance) {
            return;
        }
        for (CursedWeapon cw : this._cursedWeapons.values()) {
            if (!cw.isActive() && cw.checkDrop(attackable, player)) break;
        }
    }

    public void activate(L2PcInstance player, L2ItemInstance item) {
        CursedWeapon cw = this._cursedWeapons.get(item.getItemId());
        if (player.isCursedWeaponEquipped()) {
            CursedWeapon cw2 = this._cursedWeapons.get(player.getCursedWeaponEquippedId());
            cw2.setNbKills(cw2.getStageKills() - 1);
            cw2.increaseKills();
            cw.setPlayer(player);
            cw.endOfLife();
        } else {
            cw.activate(player, item);
        }
    }

    public void drop(int itemId, L2Character killer) {
        CursedWeapon cw = this._cursedWeapons.get(itemId);
        cw.dropIt(killer);
    }

    public void increaseKills(int itemId) {
        CursedWeapon cw = this._cursedWeapons.get(itemId);
        cw.increaseKills();
    }

    public int getLevel(int itemId) {
        CursedWeapon cw = this._cursedWeapons.get(itemId);
        return cw.getLevel();
    }

    public static void announce(SystemMessage sm) {
        Broadcast.toAllOnlinePlayers(sm);
    }

    public void checkPlayer(L2PcInstance player) {
        if (player == null) {
            return;
        }
        for (CursedWeapon cw : this._cursedWeapons.values()) {
            if (!cw.isActivated() || player.getObjectId() != cw.getPlayerId()) continue;
            cw.setPlayer(player);
            cw.setItem(player.getInventory().getItemByItemId(cw.getItemId()));
            cw.giveSkill();
            player.setCursedWeaponEquippedId(cw.getItemId());
            SystemMessage sm = new SystemMessage(SystemMessageId.S2_MINUTE_OF_USAGE_TIME_ARE_LEFT_FOR_S1);
            sm.addString(cw.getName());
            sm.addNumber((int)((cw.getEndTime() - System.currentTimeMillis()) / 60000L));
            player.sendPacket(sm);
        }
    }

    public int checkOwnsWeaponId(int ownerId) {
        for (CursedWeapon cw : this._cursedWeapons.values()) {
            if (!cw.isActivated() || ownerId != cw.getPlayerId()) continue;
            return cw.getItemId();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromDb(int itemId) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM cursed_weapons WHERE itemId = ?");
            statement.setInt(1, itemId);
            statement.executeUpdate();
            statement.close();
            con.close();
        }
        catch (SQLException e) {
            _log.severe("CursedWeaponsManager: Failed to remove data: " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public void saveData() {
        for (CursedWeapon cw : this._cursedWeapons.values()) {
            cw.saveData();
        }
    }

    public boolean isCursed(int itemId) {
        return this._cursedWeapons.containsKey(itemId);
    }

    public Collection<CursedWeapon> getCursedWeapons() {
        return this._cursedWeapons.values();
    }

    public Set<Integer> getCursedWeaponsIds() {
        return this._cursedWeapons.keySet();
    }

    public CursedWeapon getCursedWeapon(int itemId) {
        return this._cursedWeapons.get(itemId);
    }

    public void givePassive(int itemId) {
        try {
            this._cursedWeapons.get(itemId).giveSkill();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class SingletonHolder {
        protected static final CursedWeaponsManager _instance = new CursedWeaponsManager();

        private SingletonHolder() {
        }
    }
}

