/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager.grandbosses;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.grandbosses.BossLair;
import com.l2jserver.gameserver.instancemanager.lastimperialtomb.LastImperialTombManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.SpawnListener;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.BossEntity;
import com.l2jserver.gameserver.model.entity.GrandBossState;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.Earthquake;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;
import com.l2jserver.gameserver.network.serverpackets.FlyToLocation;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillCanceld;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.skills.AbnormalEffect;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import javolution.util.FastList;

public final class FrintezzaManager
extends BossLair
implements SpawnListener {
    @Deprecated
    static final boolean TEST = false;
    @Deprecated
    static final boolean DEBUG = false;
    L2GrandBossInstance frintezza;
    L2GrandBossInstance weakScarlet;
    L2GrandBossInstance strongScarlet;
    L2MonsterInstance portrait1;
    L2MonsterInstance portrait2;
    L2MonsterInstance portrait3;
    L2MonsterInstance portrait4;
    L2MonsterInstance ghost1;
    L2MonsterInstance ghost2;
    L2MonsterInstance ghost3;
    L2MonsterInstance ghost4;
    L2Npc teleCube;
    Music music;
    int _intervalOfBoss;
    int _intervalOfGhosts;
    int _intervalOfRetarget;
    int _intervalOfFrintezzaSongs;
    int _callForHelpInterval;
    private int _appTimeOfBoss;
    int _activityTimeOfBoss;
    int _scarletType;
    ScheduledFuture<?> _monsterSpawnTask = null;
    ScheduledFuture<?> _activityTimeEndTask = null;
    ScheduledFuture<?> _intervalEndTask = null;
    private Func _DecreaseRegHp = null;
    private int _debuffPeriod = 0;
    L2BossZone _zone;
    L2BossZone _hall;
    static final int _bossId = 29045;
    static final int CENTER_X = 174232;
    static final int CENTER_Y = -88020;
    static final int CENTER_Z = -5116;
    static final int CAMERA_X = 174232;
    static final int CAMERA_Y = -87890;
    static final int CAMERA_Z = -5116;
    static final int CAMERA_R = 1650;
    static final int FRINTEZZA_X = 174240;
    static final int FRINTEZZA_Y = -89805;
    static final int FRINTEZZA_Z = -5022;
    static final int SCARLET_X = 174232;
    static final int SCARLET_Y = -88020;
    static final int SCARLET_Z = -5116;
    static final String[] MUSIC_TITLE = new String[]{null, "\u5b64\u72ec\u306e\u30ed\u30f3\u30c9", "\u72c2\u559c\u306e\u30d5\u30fc\u30ac", "\u75be\u8d70\u306e\u30c8\u30c3\u30ab\u30fc\u30bf", "\u618e\u60aa\u306e\u30ec\u30af\u30a4\u30a8\u30e0", "\u9b45\u60d1\u306e\u30de\u30ba\u30eb\u30ab"};
    static final int SKILL_TIME_5006_1 = 34000;
    static final int SKILL_TIME_5007_1 = 32000;
    static final int SKILL_TIME_5007_2 = 32000;
    static final int SKILL_TIME_5007_3 = 32000;
    static final int SKILL_TIME_5007_4 = 31000;
    static final int SKILL_TIME_5007_5 = 35000;
    static final int SKILL_TIME_5008 = 30000;
    static final int HIT_TIME_5008 = 10000;
    static final int EFFECT_PERIOD_5008 = 15000;

    public static FrintezzaManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private FrintezzaManager() {
        this._state = new GrandBossState(29045);
    }

    @Override
    public void init() {
        this._callForHelpInterval = 2000;
        this._intervalOfRetarget = 10000;
        this._intervalOfFrintezzaSongs = 30000;
        this._intervalOfGhosts = 60;
        this._intervalOfBoss = Config.LIT_FIXINTERVALOFFRINTEZZA;
        this._appTimeOfBoss = Config.LIT_APPTIMEOFFRINTEZZA;
        this._activityTimeOfBoss = Config.LIT_ACTIVITYTIMEOFFRINTEZZA;
        this._zone = LastImperialTombManager.getInstance().getZone();
        if (this._zone == null) {
            _log.warning("FrintezzaManager: Failed to load zone 'Last Imperial Tomb'");
        }
        if ((this._hall = GrandBossManager.getInstance().getZoneByBossId(29045)) == null || this._hall == this._zone) {
            _log.warning("FrintezzaManager: Failed to load zone. bossId=29045");
            throw new AssertionError();
        }
        this._hall.registerEntity(this);
        _log.info("FrintezzaManager : State of Frintezza is " + this._state.getStateName() + ".");
        if (this._state.getState() != 0) {
            this.setIntervalEndTask();
        }
        _log.info("FrintezzaManager : Next spawn date of Frintezza is " + this._state.respawnTimeFormat() + ".");
        _log.info("FrintezzaManager : Init FrintezzaManager.");
    }

    L2Spawn createNewSpawn(int templateId, int x, int y, int z, int heading, int respawnDelay) {
        L2Spawn tempSpawn = null;
        try {
            L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(templateId);
            tempSpawn = new L2Spawn(template1);
            tempSpawn.setLocx(x);
            tempSpawn.setLocy(y);
            tempSpawn.setLocz(z);
            tempSpawn.setHeading(heading);
            tempSpawn.setAmount(1);
            tempSpawn.setRespawnDelay(respawnDelay);
            if (respawnDelay == 0) {
                tempSpawn.stopRespawn();
            } else {
                tempSpawn.startRespawn();
            }
        }
        catch (Exception e) {
            _log.warning(e.getMessage());
        }
        return tempSpawn;
    }

    private void setScarletSpawnTask() {
        if (LastImperialTombManager.getInstance().getPlayersInside().size() >= 1 && this._state.getState() == 0 && this._monsterSpawnTask == null && this.teleCube == null) {
            if (this._appTimeOfBoss < 180000) {
                this._appTimeOfBoss = 180000;
            }
            this._monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScarletWeakSpawn(), this._appTimeOfBoss - 180000);
            this._zone.broadcastPacket(new CreatureSay(0, 1, "\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5 \u30c6\u30ec\u30dd\u30fc\u30bf\u30fc", this._appTimeOfBoss / 60000 + "\u5206\u5f8c\u306b\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5\u69d8\u304c\u767b\u5834\u3057\u307e\u3059\u3002"));
        }
    }

    void showSocialActionMovie(L2Npc target, int dist, int yaw, int pitch, int time, int duration, int socialAction) {
        this.showSocialActionMovie(target, dist, yaw, pitch, time, duration, socialAction, true);
    }

    void showSocialActionMovie(L2Npc target, int dist, int yaw, int pitch, int time, int duration, int socialAction, boolean closestBoss) {
        block10: {
            duration = 60000;
            if (target == null) {
                return;
            }
            if (target.getX() != target.getSpawn().getLocx() || target.getY() != target.getSpawn().getLocy()) {
                if (this.horizontalDistance(174232, -87890, target.getX(), target.getY()) >= 1650) {
                    yaw = this.calcCameraYaw(174232, -87890, target.getX(), target.getY());
                } else {
                    do {
                        int y;
                        double a = Math.toRadians((540 - yaw) % 360);
                        double d = (double)(256 + dist) * Math.cos(Math.toRadians(pitch));
                        int x = target.getX() + (int)Math.round(d * Math.cos(a));
                        int r = this.horizontalDistance(174232, -87890, x, y = target.getY() + (int)Math.round(d * Math.sin(a)));
                        if (r < 1650) break block10;
                    } while ((pitch += 10) <= 89);
                    pitch = 89;
                }
            }
        }
        for (L2Character ch : this._hall.getCharactersInside().values()) {
            int pitch2;
            int yaw2;
            L2PcInstance pc;
            if (!(ch instanceof L2PcInstance) || (pc = (L2PcInstance)ch).isOnline() != 1) continue;
            L2Object tt = null;
            if (!this.isIdle(pc)) {
                this.setIdle(pc);
                pc.setTarget(null);
            }
            if (pc.getPlanDistanceSq(target) <= 6502500.0) {
                pc.enterMovieMode();
                pc.specialCamera(target, dist, yaw, pitch, time, duration);
                continue;
            }
            if (closestBoss && (tt = this.chooseClosest(pc, 6502500L, this.frintezza, this.weakScarlet, this.strongScarlet)) != null) {
                pc.enterMovieMode();
                yaw2 = this.calcCameraYaw(174232, -87890, tt.getX(), tt.getY());
                pitch2 = this.calcCameraPitch(174232, -87890, -5116, tt.getX(), tt.getY(), tt.getZ());
                pc.specialCamera(tt, 0, yaw2, pitch2, 0, duration);
                continue;
            }
            pc.enterMovieMode();
            yaw2 = this.calcCameraYaw(pc.getX(), pc.getY(), target.getX(), target.getY());
            pitch2 = this.calcCameraPitch(pc.getX(), pc.getY(), pc.getZ(), target.getX(), target.getY(), target.getZ());
            pc.specialCamera(pc, 0, yaw2, pitch2, 0, duration);
        }
        if (socialAction > 0 && socialAction < 5) {
            this._hall.broadcastPacket(new SocialAction(target.getObjectId(), socialAction));
        }
    }

    L2Object chooseClosest(L2PcInstance pc, long max, L2Object ... targets) {
        if (targets == null) {
            return null;
        }
        L2Object result = null;
        for (L2Object ch : targets) {
            long ll;
            if (ch == null || (ll = (long)this.horizontalDistance(pc.getX(), pc.getY(), ch.getX(), ch.getY())) >= max) continue;
            max = ll;
            result = ch;
        }
        return result;
    }

    void teleportToStart() {
        this.teleportToStart(174240, -89805, -5022);
    }

    void teleportToStart(int tx, int ty, int tz) {
        for (L2PcInstance pc : this.getPlayersInside()) {
            if (!this._hall.isInsideZone(pc)) {
                double r = Rnd.get(500, 1000);
                double a = Math.PI * 2 * Rnd.nextDouble();
                int x = 174232 + (int)(r * Math.cos(a));
                int y = -88020 + (int)(r * Math.sin(a));
                int z = -5116;
                this._zone.setZoneDisable();
                pc.teleToLocation(x, y, z);
            }
            pc.enterMovieMode();
            int yaw2 = this.calcCameraYaw(pc.getX(), pc.getY(), tx, ty);
            int pitch2 = this.calcCameraPitch(pc.getX(), pc.getY(), pc.getZ(), tx, ty, tz);
            pc.specialCamera(pc, 0, yaw2, pitch2, 0, 60000);
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                FrintezzaManager.this._zone.setZoneEnable();
            }
        }, 30000L);
    }

    void decreaseEffectOfHpReg(L2Character target) {
        L2Skill skill = SkillTable.getInstance().getInfo(5008, 4);
        if (target.getFirstEffect(skill) != null) {
            return;
        }
        this.frintezza.callSkill(skill, target);
        if (target instanceof L2PcInstance) {
            target.getActingPlayer().sendPacket(new SystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT).addSkillName(skill));
        }
        target.addStatFunc(this.getDecreaseRegHpFunc());
        ThreadPoolManager.getInstance().scheduleGeneral(new exitDecreaseRegHp(target, this.getDecreaseRegHpFunc()), this.getDebuffPeriod(skill, target));
    }

    private int getDebuffPeriod(L2Skill skill, L2Character target) {
        return 15000;
    }

    protected Func getDecreaseRegHpFunc() {
        if (this._DecreaseRegHp == null) {
            L2Skill skill = SkillTable.getInstance().getInfo(406, 3);
            for (L2Effect effect : skill.getEffects(this.frintezza, this.frintezza)) {
                if (effect == null) continue;
                Func[] func = effect.getStatFuncs();
                if (func.length > 5) {
                    this._DecreaseRegHp = func[5];
                }
                effect.exit();
            }
        }
        return this._DecreaseRegHp;
    }

    protected boolean isDecreaseRegHp(L2Character target, Func func) {
        L2Skill skill = SkillTable.getInstance().getInfo(5008, 4);
        return target.getFirstEffect(skill) != null;
    }

    void startStunDanceEffect(L2Character _effected) {
        if (!(_effected instanceof L2PcInstance)) {
            return;
        }
        L2Skill _skill = SkillTable.getInstance().getInfo(5008, 5);
        if (_effected.getFirstEffect(_skill) != null) {
            return;
        }
        L2PcInstance effected = (L2PcInstance)_effected;
        if (effected.isInvul() || effected.getAppearance().getInvisible()) {
            return;
        }
        this.setIdle(_effected);
        _effected.disableAllSkills();
        _effected.setTarget(null);
        _effected.startAbnormalEffect(AbnormalEffect.DANCE_STUNNED);
        _effected.callSkill(_skill, _effected);
        if (_effected instanceof L2PcInstance) {
            _effected.getActingPlayer().sendPacket(new SystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT).addSkillName(_skill));
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new exitStunDanceEffect(_effected), this.getDebuffPeriod(_skill, _effected));
    }

    protected boolean isStunDanceEffect(L2Character target) {
        return (target.getAbnormalEffects() & AbnormalEffect.DANCE_STUNNED.getMask()) != 0;
    }

    void startAttackListeners() {
        ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(this.ghost1, 1), Rnd.get(2000));
        ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(this.ghost2, 1), Rnd.get(2000));
        ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(this.ghost3, 1), Rnd.get(2000));
        ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(this.ghost4, 1), Rnd.get(2000));
        ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(this.portrait1, 50), Rnd.get(2000));
        ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(this.portrait2, 50), Rnd.get(2000));
        ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(this.portrait3, 50), Rnd.get(2000));
        ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(this.portrait4, 50), Rnd.get(2000));
        ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(this.frintezza, 200), Rnd.get(2000));
        ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(this.weakScarlet, 100), Rnd.get(2000));
    }

    void portraitDeadCheck(L2MonsterInstance mob) {
        if (mob == null) {
            return;
        }
        L2MonsterInstance ghost = null;
        if (mob == this.portrait1) {
            this.portrait1 = null;
            ghost = this.ghost1;
            this.ghost1 = null;
        } else if (mob == this.portrait2) {
            this.portrait2 = null;
            ghost = this.ghost2;
            this.ghost2 = null;
        } else if (mob == this.portrait3) {
            this.portrait3 = null;
            ghost = this.ghost3;
            this.ghost3 = null;
        } else if (mob == this.portrait4) {
            this.portrait4 = null;
            ghost = this.ghost4;
            this.ghost4 = null;
        } else {
            throw new AssertionError((Object)"mob is not portrait");
        }
        try {
            mob.deleteMe();
            mob = null;
        }
        catch (RuntimeException e) {
            _log.warning(e.getMessage());
        }
        if (ghost != null) {
            try {
                ghost.getSpawn().stopRespawn();
                ghost.deleteMe();
                ghost = null;
            }
            catch (RuntimeException e) {
                _log.warning(e.getMessage());
            }
        }
    }

    void callMinionsToAssist(L2Character attacker, int hate) {
        if (attacker == null) {
            return;
        }
        if (this.ghost1 != null && !this.ghost1.isDead()) {
            this.ghost1.addDamageHate(attacker, 0, hate);
        }
        if (this.ghost2 != null && !this.ghost2.isDead()) {
            this.ghost2.addDamageHate(attacker, 0, hate);
        }
        if (this.ghost3 != null && !this.ghost3.isDead()) {
            this.ghost3.addDamageHate(attacker, 0, hate);
        }
        if (this.ghost4 != null && !this.ghost4.isDead()) {
            this.ghost4.addDamageHate(attacker, 0, hate);
        }
        if (this.weakScarlet != null && !this.weakScarlet.isDead()) {
            this.weakScarlet.addDamageHate(attacker, 0, hate);
        }
        if (this.strongScarlet != null && !this.strongScarlet.isDead()) {
            this.strongScarlet.addDamageHate(attacker, 0, hate);
        }
    }

    @Override
    public void npcSpawned(L2Npc npc) {
        if (npc == null) {
            return;
        }
        int npcId = npc.getNpcId();
        if (npcId == 29050 || npcId == 29051) {
            final L2MonsterInstance ghost = (L2MonsterInstance)npc;
            L2Skill skill = SkillTable.getInstance().getInfo(1086, 1);
            ThreadPoolManager.getInstance().scheduleGeneral(new doSkill(ghost, skill, this._intervalOfFrintezzaSongs, 1000), 4000L);
            ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                @Override
                public void run() {
                    if (ghost.isDead() || !ghost.isVisible()) {
                        return;
                    }
                    L2PcInstance target = FrintezzaManager.this.getRandomPlayer();
                    ghost.setTarget(target);
                    if (target == null) {
                        return;
                    }
                    L2CharPosition pos = new L2CharPosition(target.getX(), target.getY(), target.getZ(), 0);
                    ghost.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, pos);
                }
            }, 10000 + Rnd.get(5000));
        }
    }

    void weakScarletHpListener() {
        if (this.weakScarlet == null || this.weakScarlet.isDead()) {
            return;
        }
        double curHp = this.weakScarlet.getStatus().getCurrentHp();
        double maxHp = this.weakScarlet.getMaxHp();
        if (this._scarletType == 1) {
            if (curHp < maxHp * 0.6666666666666666) {
                this._scarletType = 2;
                new SecondMorph().run();
            }
        } else if (this._scarletType == 2 && curHp < maxHp * 0.3333333333333333) {
            this._scarletType = 3;
            new ThirdMorph().run();
        }
    }

    void setTargeted(L2Character target, boolean[] targeted) {
        int count = 0;
        StatusUpdate su = new StatusUpdate(target.getObjectId());
        su.addAttribute(9, (int)target.getStatus().getCurrentHp());
        su.addAttribute(10, target.getMaxHp());
        for (L2PcInstance pc : this.getPlayersInside()) {
            if (pc != null && targeted[count]) {
                pc.setTarget(target);
                pc.sendPacket(su);
            }
            ++count;
        }
    }

    boolean[] getTargeted(L2Object target) {
        List<L2PcInstance> lst = this.getPlayersInside();
        boolean[] targeted = new boolean[lst.size()];
        int count = 0;
        for (L2PcInstance pc : lst) {
            targeted[count++] = pc != null && pc.getTarget() == target;
        }
        return targeted;
    }

    void setIdle(L2Character target) {
        target.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        target.abortAttack();
        target.abortCast();
        target.setIsImmobilized(true);
    }

    void setActive(L2Character target) {
        target.setIsImmobilized(false);
        target.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
    }

    boolean isIdle(L2Character target) {
        return target.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE;
    }

    void onEnterMorph(L2GrandBossInstance ... boss) {
        if (this.ghost1 != null) {
            this.setIdle(this.ghost1);
            this.ghost1.startParalyze();
        }
        if (this.ghost2 != null) {
            this.setIdle(this.ghost2);
            this.ghost2.startParalyze();
        }
        if (this.ghost3 != null) {
            this.setIdle(this.ghost3);
            this.ghost3.startParalyze();
        }
        if (this.ghost4 != null) {
            this.setIdle(this.ghost4);
            this.ghost4.startParalyze();
        }
        for (L2GrandBossInstance b : boss) {
            this.setIdle(b);
            b.setIsInSocialAction(true);
        }
    }

    void onLeaveMorph() {
        new SetMobilisedBoss(this.frintezza).run();
        if (this.ghost1 != null) {
            ThreadPoolManager.getInstance().scheduleGeneral(new SetMobilisedGhost(this.ghost1), 6000L);
        }
        if (this.ghost2 != null) {
            ThreadPoolManager.getInstance().scheduleGeneral(new SetMobilisedGhost(this.ghost2), 9000L);
        }
        if (this.ghost3 != null) {
            ThreadPoolManager.getInstance().scheduleGeneral(new SetMobilisedGhost(this.ghost3), 12000L);
        }
        if (this.ghost4 != null) {
            ThreadPoolManager.getInstance().scheduleGeneral(new SetMobilisedGhost(this.ghost4), 15000L);
        }
    }

    @Override
    public void setUnspawn() {
        try {
            L2Spawn.removeSpawnListener(FrintezzaManager.getInstance());
            this.portraitDeadCheck(this.portrait1);
            this.portraitDeadCheck(this.portrait2);
            this.portraitDeadCheck(this.portrait3);
            this.portraitDeadCheck(this.portrait4);
            if (this.frintezza != null) {
                this.frintezza.deleteMe();
                this.frintezza = null;
            }
            if (this.strongScarlet != null) {
                this.strongScarlet.deleteMe();
                this.strongScarlet = null;
            }
            if (this.weakScarlet != null) {
                this.weakScarlet.deleteMe();
                this.weakScarlet = null;
            }
            this.music = null;
            if (this._monsterSpawnTask != null) {
                this._monsterSpawnTask.cancel(true);
                this._monsterSpawnTask = null;
            }
            if (this._intervalEndTask != null) {
                this._intervalEndTask.cancel(true);
                this._intervalEndTask = null;
            }
            if (this._activityTimeEndTask != null) {
                this._activityTimeEndTask.cancel(true);
                this._activityTimeEndTask = null;
            }
            this.setIntervalEndTask();
            _log.info("FrintezzaManager : Next spawn date of Frintezza is " + this._state.respawnTimeFormat() + ".");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setIntervalEndTask() {
        switch (this._state.getState()) {
            case 0: {
                break;
            }
            case 1: {
                this._state.setState(0);
                break;
            }
            case 2: {
                this._state.setRespawnDate(Config.LIT_FIXINTERVALOFFRINTEZZA + Rnd.get(Config.LIT_RANDOMINTERVALOFFRINTEZZA));
                this._state.setState(3);
                this._state.update();
            }
            case 3: {
                this._intervalEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new IntervalEnd(), this._state.getInterval());
                _log.info("FrintezzaManager : Interval START.");
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void onKillFrintezza(final L2PcInstance player) {
        if (this.frintezza == null) {
            return;
        }
        if (this.strongScarlet != null) {
            ThreadPoolManager.getInstance().executeTask(new Runnable(){

                @Override
                public void run() {
                    FrintezzaManager.this.strongScarlet.doDie(player);
                }
            });
        } else if (this.weakScarlet != null) {
            ThreadPoolManager.getInstance().executeTask(new Runnable(){

                @Override
                public void run() {
                    FrintezzaManager.this.weakScarlet.doDie(player);
                }
            });
        }
    }

    public void onKillScarlet(L2PcInstance player) {
        this._scarletType = 0;
        new ScarletStrongKilled(player).run();
    }

    public void onSoulBreakingArrow(L2Npc npc, L2PcInstance player) {
        if (npc != this.frintezza) {
            throw new AssertionError();
        }
        if (this.music != null) {
            this.music.pause(60000L);
        }
    }

    void updateKnownList(L2Npc npc) {
        this._hall.updateKnownList(npc);
    }

    int calcCameraYaw(L2Character ch) {
        return Util.calcCameraAngle(ch);
    }

    int calcCameraYaw(L2Character ch, int alpha) {
        return (alpha + 360 + Util.calcCameraAngle(ch)) % 360;
    }

    int calcCameraYaw(int x0, int y0, int x1, int y1) {
        return (360 - (int)Math.round(Math.toDegrees(Math.atan2(y1 - y0, x1 - x0)))) % 360;
    }

    int calcCameraPitch(int x0, int y0, int z0, int x1, int y1, int z1) {
        return (int)Math.round(Math.toDegrees(Math.atan2(z0 - z1, this.horizontalDistance(x0, y0, x1, y1))));
    }

    int horizontalDistance(int x0, int y0, int x1, int y1) {
        long rx = x1 - x0;
        long ry = y1 - y0;
        return (int)Math.round(Math.sqrt(rx * rx + ry * ry));
    }

    void flickPlayers(L2Object o, double range) {
        this.flickPlayers(o.getX(), o.getY(), range);
    }

    void flickPlayers(int mx, int my, double range) {
        for (L2Character cha : this._hall.getCharactersInside().values()) {
            double aa;
            if (!(cha instanceof L2PcInstance)) continue;
            L2PcInstance pc = (L2PcInstance)cha;
            double dx = pc.getX() - mx;
            double dy = pc.getY() - my;
            if (dx == 0.0 && dy == 0.0) {
                dx = dy = range / 2.0;
            }
            if (!((aa = range / Math.sqrt(dx * dx + dy * dy)) > 1.0)) continue;
            int x = mx + (int)(dx * aa);
            int y = my + (int)(dy * aa);
            int z = pc.getZ();
            if (this.horizontalDistance(174232, -87890, x, y) >= 1650) {
                x = mx - (int)(dx * aa);
                y = my - (int)(dy * aa);
            }
            pc.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
            pc.abortAttack();
            pc.abortCast();
            pc.broadcastPacket(new FlyToLocation(pc, x, y, z, FlyToLocation.FlyType.THROW_UP));
            pc.setXYZ(x, y, z);
            pc.setHeading(Util.calculateHeadingFrom(x, y, mx, my));
            pc.broadcastPacket(new ValidateLocation(pc));
            pc.sendPacket(new SystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT).addSkillName(5004, 1));
        }
    }

    public void decayItemsOnGround() {
        this.decayItemsOnGround(122, 42);
    }

    private void decayItemsOnGround(int x, int y) {
        for (L2Object o : L2World.getInstance().getAllWorldRegions()[x][y].getVisibleObjects().values()) {
            L2ItemInstance item;
            if (!(o instanceof L2ItemInstance) || !this._hall.isInsideZone(item = (L2ItemInstance)o)) continue;
            item.decayMe();
        }
    }

    @Override
    public void onEnter(L2PcInstance player) {
        if (!this._zone.isPlayerAllowed(player)) {
            if (!player.isGM()) {
                player.setPunishLevel(L2PcInstance.PunishLevel.JAIL, 1440);
            }
            return;
        }
        LastImperialTombManager.getInstance().setReachToHall();
        this.setScarletSpawnTask();
    }

    @Override
    public List<L2PcInstance> getPlayersInside() {
        return LastImperialTombManager.getInstance().getPlayersInside();
    }

    @Override
    public boolean checkIfInZone(L2Character cha) {
        return this._hall.isInsideZone(cha);
    }

    @Override
    @Deprecated
    public L2BossZone getZone() {
        throw new AssertionError();
    }

    @Deprecated
    String getMonsterName(L2Npc mob) {
        return null;
    }

    private class ScarletStrongKilled
    implements Runnable {
        private int _taskId = 1;
        private final L2PcInstance _player;
        private L2GrandBossInstance _frintezza;
        private L2GrandBossInstance _strongScarlet;
        private L2GrandBossInstance _weakScarlet;
        private L2GrandBossInstance _activeScarlet;
        private long _timeLimit;

        public ScarletStrongKilled(L2PcInstance player) {
            this._player = player;
            this._frintezza = FrintezzaManager.this.frintezza;
            FrintezzaManager.this.frintezza = null;
            this._activeScarlet = FrintezzaManager.this.strongScarlet != null ? FrintezzaManager.this.strongScarlet : FrintezzaManager.this.weakScarlet;
            this._weakScarlet = FrintezzaManager.this.weakScarlet;
            FrintezzaManager.this.weakScarlet = null;
            this._strongScarlet = FrintezzaManager.this.strongScarlet;
            FrintezzaManager.this.strongScarlet = null;
        }

        private void next(int taskId, long delay) {
            this._taskId = taskId;
            ThreadPoolManager.getInstance().scheduleGeneral(this, delay);
        }

        @Override
        public void run() {
            try {
                switch (this._taskId) {
                    case 1: {
                        if (FrintezzaManager.this._activityTimeEndTask != null) {
                            FrintezzaManager.this._activityTimeEndTask.cancel(false);
                        }
                        FrintezzaManager.this._activityTimeEndTask = null;
                        FrintezzaManager.this._hall.broadcastPacket(new MagicSkillCanceld(this._frintezza.getObjectId()));
                        if (FrintezzaManager.this.ghost4 != null) {
                            FrintezzaManager.this.ghost4.getSpawn().stopRespawn();
                            FrintezzaManager.this.ghost4.deleteMe();
                            FrintezzaManager.this.ghost4 = null;
                        }
                        if (FrintezzaManager.this.ghost3 != null) {
                            FrintezzaManager.this.ghost3.getSpawn().stopRespawn();
                            FrintezzaManager.this.ghost3.deleteMe();
                            FrintezzaManager.this.ghost3 = null;
                        }
                        if (FrintezzaManager.this.ghost2 != null) {
                            FrintezzaManager.this.ghost2.getSpawn().stopRespawn();
                            FrintezzaManager.this.ghost2.deleteMe();
                            FrintezzaManager.this.ghost2 = null;
                        }
                        if (FrintezzaManager.this.ghost1 != null) {
                            FrintezzaManager.this.ghost1.getSpawn().stopRespawn();
                            FrintezzaManager.this.ghost1.deleteMe();
                            FrintezzaManager.this.ghost1 = null;
                        }
                        if (FrintezzaManager.this.portrait4 != null) {
                            FrintezzaManager.this.portrait4.deleteMe();
                            FrintezzaManager.this.portrait4 = null;
                        }
                        if (FrintezzaManager.this.portrait3 != null) {
                            FrintezzaManager.this.portrait3.deleteMe();
                            FrintezzaManager.this.portrait3 = null;
                        }
                        if (FrintezzaManager.this.portrait2 != null) {
                            FrintezzaManager.this.portrait2.deleteMe();
                            FrintezzaManager.this.portrait2 = null;
                        }
                        if (FrintezzaManager.this.portrait1 != null) {
                            FrintezzaManager.this.portrait1.deleteMe();
                            FrintezzaManager.this.portrait1 = null;
                        }
                        FrintezzaManager.this._state.setState(2);
                        FrintezzaManager.this._state.update();
                        FrintezzaManager.this.updateKnownList(this._activeScarlet);
                        FrintezzaManager.this.showSocialActionMovie(this._activeScarlet, 300, FrintezzaManager.this.calcCameraYaw(this._activeScarlet, 180), 5, 0, 7000, 0);
                        this.next(2, 500L);
                        break;
                    }
                    case 2: {
                        FrintezzaManager.this.showSocialActionMovie(this._activeScarlet, 150, FrintezzaManager.this.calcCameraYaw(this._activeScarlet), 85, 4000, 20000, 0);
                        this.next(3, 7000L);
                        break;
                    }
                    case 3: {
                        FrintezzaManager.this.updateKnownList(this._frintezza);
                        FrintezzaManager.this.showSocialActionMovie(this._frintezza, 150, 120, 5, 0, 7000, 0);
                        this.next(4, 500L);
                        break;
                    }
                    case 4: {
                        this._frintezza.doDie(this._player);
                        FrintezzaManager.this._hall.broadcastPacket(new PlaySound(1, "BS01_D", 1, this._frintezza.getObjectId(), 174232, -88020, -5116));
                        FrintezzaManager.this.showSocialActionMovie(this._frintezza, 150, 90, 5, 3000, 15000, 0);
                        this.next(5, 7000L);
                        break;
                    }
                    case 5: {
                        FrintezzaManager.this.teleCube = FrintezzaManager.this.createNewSpawn(29061, 174232, -88020, -5116, 0, 0).doSpawn();
                        FrintezzaManager.this.showSocialActionMovie(this._frintezza, 1200, 90, 25, 8000, 10000, 0);
                        this.next(90, 8000L);
                        break;
                    }
                    case 90: {
                        if (this._weakScarlet != null) {
                            this._weakScarlet.deleteMe();
                            this._weakScarlet = null;
                        }
                        if (this._strongScarlet != null) {
                            this._strongScarlet.deleteMe();
                            this._strongScarlet = null;
                        }
                        for (L2PcInstance pc : FrintezzaManager.this.getPlayersInside()) {
                            pc.specialCamera(pc, 0, FrintezzaManager.this.calcCameraYaw(pc, 180), 0, 0, 100);
                            pc.leaveMovieMode();
                            pc.enableAllSkills();
                        }
                        Broadcast.announceToOnlinePlayers("\u6700\u5f8c\u306e\u7687\u5e1d\u306e\u5893\u306e\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5\u304c\u6b7b\u4ea1\u3057\u307e\u3057\u305f\u3002");
                        this.next(91, 20000L);
                        break;
                    }
                    case 91: {
                        if (this._frintezza != null) {
                            this._frintezza.deleteMe();
                            this._frintezza = null;
                        }
                        FrintezzaManager.this.setUnspawn();
                        FrintezzaManager.this._hall.broadcastPacket(new CreatureSay(0, 3, "\u30d5\u30ea\u30f3\u30c6\u30c3\u30b5 \u30c6\u30ec\u30dd\u30fc\u30bf\u30fc", "\u8a0e\u4f10\u304a\u3081\u3067\u3068\u3046\u3054\u3056\u3044\u307e\u3059\u3002\u3053\u3053\u306f\u5371\u967a\u3067\u3059\u300215\u5206\u4ee5\u5185\u306b\u8131\u51fa\u3057\u3066\u304f\u3060\u3055\u3044\u3002"));
                        this._timeLimit = System.currentTimeMillis() + 900000L;
                        this.next(99, 60000L);
                        break;
                    }
                    case 99: {
                        List<L2PcInstance> players;
                        if (System.currentTimeMillis() < this._timeLimit && (players = FrintezzaManager.this.getPlayersInside()).size() > 0) {
                            for (L2PcInstance pc : players) {
                                if (pc.isDead()) continue;
                                double progress = (double)(this._timeLimit - System.currentTimeMillis()) / 900000.0;
                                double hp = 1.0 + (double)pc.getMaxHp() * progress;
                                double mp = 1.0 + (double)pc.getMaxMp() * progress;
                                if (!(hp < pc.getCurrentHp()) && !(mp < pc.getCurrentMp())) continue;
                                pc.setCurrentHpMp(hp, mp);
                            }
                            this.next(99, Rnd.get(1000, 10000));
                            break;
                        }
                        if (FrintezzaManager.this.teleCube != null) {
                            FrintezzaManager.this.teleCube.deleteMe();
                            FrintezzaManager.this.teleCube = null;
                        }
                        FrintezzaManager.this.decayItemsOnGround();
                        LastImperialTombManager.getInstance().cleanUpTomb();
                        break;
                    }
                    default: {
                        FrintezzaManager.this.TRACE("FrintezzaManager:2385: 'case " + this._taskId + ":' invalid");
                        throw new AssertionError((Object)("'case " + this._taskId + ":' invalid"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class IntervalEnd
    implements Runnable {
        IntervalEnd() {
        }

        @Override
        public void run() {
            FrintezzaManager.this._state.setState(0);
            FrintezzaManager.this._state.update();
            BossEntity._log.info("FrintezzaManager : Interval END.");
        }
    }

    class ActivityTimeEnd
    implements Runnable {
        ActivityTimeEnd() {
        }

        @Override
        public void run() {
            if (FrintezzaManager.this._monsterSpawnTask == null) {
                return;
            }
            FrintezzaManager.this.setUnspawn();
            FrintezzaManager.this.decayItemsOnGround();
            LastImperialTombManager.getInstance().cleanUpTomb();
        }
    }

    private class ReTarget
    implements Runnable {
        private final L2Npc _mob;

        public ReTarget(L2Npc mob) {
            this._mob = mob;
        }

        @Override
        public void run() {
            if (FrintezzaManager.this.getPlayersInside().isEmpty()) {
                if (FrintezzaManager.this._activityTimeEndTask != null) {
                    FrintezzaManager.this._activityTimeEndTask.cancel(false);
                }
                FrintezzaManager.this._activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(), 10000L);
                return;
            }
            if (this._mob.isDead() || !this._mob.isVisible()) {
                return;
            }
            this._mob.setTarget(FrintezzaManager.this.getRandomPlayer());
            if (this._mob.getTarget() == null) {
                ThreadPoolManager.getInstance().scheduleGeneral(this, 1000L);
            } else {
                ThreadPoolManager.getInstance().scheduleGeneral(this, FrintezzaManager.this._intervalOfRetarget + Rnd.get(FrintezzaManager.this._intervalOfRetarget));
            }
        }
    }

    private class doSkill
    implements Runnable {
        private final L2Character _caster;
        private final L2Skill _skill;
        private final int _interval;
        private final int _range;

        public doSkill(L2Character caster, L2Skill skill, int interval, int range) {
            this._caster = caster;
            this._skill = skill;
            this._interval = interval;
            this._range = range;
        }

        @Override
        public void run() {
            if (this._caster == null || this._caster.isDead() || !this._caster.isVisible()) {
                return;
            }
            if (this._caster.isImmobilized()) {
                ThreadPoolManager.getInstance().scheduleGeneral(this, this._interval);
                return;
            }
            try {
                L2Object tempTarget = this._caster.getTarget();
                if (tempTarget instanceof L2PcInstance && FrintezzaManager.this.checkIfInZone((L2PcInstance)tempTarget)) {
                    int x = tempTarget.getX() + Rnd.get(this._range) - this._range / 2;
                    int y = tempTarget.getY() + Rnd.get(this._range) - this._range / 2;
                    int z = tempTarget.getZ();
                    if (!this._caster.isInsideRadius(x, y, this._range, false)) {
                        boolean[] targeted = FrintezzaManager.this.getTargeted(this._caster);
                        this._caster.broadcastPacket(new MagicSkillUse(this._caster, (L2Character)tempTarget, this._skill.getId(), this._skill.getLevel(), 0, 0), 10000);
                        this._caster.broadcastPacket(new FlyToLocation(this._caster, x, y, z, FlyToLocation.FlyType.CHARGE));
                        this._caster.getPosition().setXYZ(x, y, z);
                        this._caster.broadcastPacket(new ValidateLocation(this._caster));
                        this._caster.setTarget(tempTarget);
                        FrintezzaManager.this.setTargeted(this._caster, targeted);
                    }
                }
            }
            catch (RuntimeException e) {
                BossEntity._log.warning(e.getMessage());
            }
            ThreadPoolManager.getInstance().scheduleGeneral(this, this._interval + Rnd.get(500));
        }
    }

    class SecondMorph
    implements Runnable {
        int _taskId = 0;
        final double _currentHp;

        SecondMorph() {
            this._currentHp = FrintezzaManager.this.weakScarlet.getStatus().getCurrentHp();
        }

        private void next(int taskId, long delay) {
            this._taskId = taskId;
            ThreadPoolManager.getInstance().scheduleGeneral(this, delay);
        }

        @Override
        public void run() {
            if (FrintezzaManager.this.weakScarlet == null) {
                return;
            }
            try {
                switch (this._taskId) {
                    case 0: {
                        FrintezzaManager.this.setIdle(FrintezzaManager.this.frintezza);
                        FrintezzaManager.this.frintezza.setIsInSocialAction(true);
                        FrintezzaManager.this.weakScarlet.disableCoreAI(true);
                        FrintezzaManager.this.setIdle(FrintezzaManager.this.weakScarlet);
                        FrintezzaManager.this.weakScarlet.setIsInSocialAction(true);
                        this.next(1, 500L);
                        break;
                    }
                    case 1: {
                        FrintezzaManager.this._hall.broadcastPacket(new MagicSkillUse(FrintezzaManager.this.weakScarlet, FrintezzaManager.this.weakScarlet, 5018, 1, 0, 0));
                        this.next(2, 2000L);
                        break;
                    }
                    case 2: {
                        FrintezzaManager.this.weakScarlet.setRHandId(7903);
                        FrintezzaManager.this._hall.broadcastPacket(new AbstractNpcInfo.NpcInfo(FrintezzaManager.this.weakScarlet, null));
                        this.next(3, 2000L);
                        break;
                    }
                    case 3: {
                        this.next(99, 4000L);
                        break;
                    }
                    case 99: {
                        L2Skill skill = SkillTable.getInstance().getInfo(1068, 3);
                        FrintezzaManager.this.weakScarlet.callSkill(skill, FrintezzaManager.this.weakScarlet);
                        skill = null;
                        FrintezzaManager.this.weakScarlet.getStatus().setCurrentHp(this._currentHp * 1.15);
                        FrintezzaManager.this.weakScarlet.setIsInSocialAction(false);
                        FrintezzaManager.this.setActive(FrintezzaManager.this.weakScarlet);
                        FrintezzaManager.this.weakScarlet.disableCoreAI(false);
                        FrintezzaManager.this.frintezza.setIsInSocialAction(false);
                        FrintezzaManager.this.setActive(FrintezzaManager.this.frintezza);
                        skill = SkillTable.getInstance().getInfo(1086, 1);
                        ThreadPoolManager.getInstance().scheduleGeneral(new doSkill(FrintezzaManager.this.weakScarlet, skill, FrintezzaManager.this._intervalOfRetarget, 200), FrintezzaManager.this._intervalOfRetarget);
                        skill = null;
                        break;
                    }
                    default: {
                        FrintezzaManager.this.TRACE("FrintezzaManager:1953: 'case " + this._taskId + ":' invalid");
                        throw new AssertionError((Object)("'case " + this._taskId + ":' invalid"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class SetMobilisedGhost
    implements Runnable {
        private final L2Npc _npc;

        public SetMobilisedGhost(L2MonsterInstance ghost) {
            this._npc = ghost;
            ghost.stopParalyze(null);
            FrintezzaManager.this.setActive(ghost);
            ghost.startImmobileUntilAttacked();
        }

        @Override
        public void run() {
            this._npc.stopImmobileUntilAttacked(null);
        }
    }

    private class SetMobilisedBoss
    implements Runnable {
        private final L2GrandBossInstance _npc;

        public SetMobilisedBoss(L2GrandBossInstance boss) {
            this._npc = boss;
            boss.setIsInSocialAction(false);
            FrintezzaManager.this.setActive(boss);
            boss.startImmobileUntilAttacked();
        }

        @Override
        public void run() {
            this._npc.stopImmobileUntilAttacked(null);
        }
    }

    class ThirdMorph
    implements Runnable {
        int _taskId = 0;
        L2GrandBossInstance _weakScarlet;

        ThirdMorph() {
            this._weakScarlet = FrintezzaManager.this.weakScarlet;
            FrintezzaManager.this.weakScarlet = null;
        }

        private void next(int taskId, long delay) {
            this._taskId = taskId;
            ThreadPoolManager.getInstance().scheduleGeneral(this, delay);
        }

        @Override
        public void run() {
            try {
                switch (this._taskId) {
                    case 0: {
                        FrintezzaManager.this.onEnterMorph(FrintezzaManager.this.frintezza, this._weakScarlet);
                        FrintezzaManager.this._hall.broadcastPacket(new MagicSkillCanceld(FrintezzaManager.this.frintezza.getObjectId()));
                        FrintezzaManager.this.updateKnownList(FrintezzaManager.this.frintezza);
                        FrintezzaManager.this.showSocialActionMovie(FrintezzaManager.this.frintezza, 250, 60, 15, 0, 10000, 0);
                        this.next(2, 100L);
                        break;
                    }
                    case 2: {
                        FrintezzaManager.this._hall.broadcastPacket(new SocialAction(FrintezzaManager.this.frintezza.getObjectId(), 4));
                        this.next(3, 4900L);
                        break;
                    }
                    case 3: {
                        FrintezzaManager.this._hall.broadcastPacket(new MagicSkillUse(FrintezzaManager.this.frintezza, FrintezzaManager.this.frintezza, 5006, 1, 34000, 0));
                        FrintezzaManager.this.showSocialActionMovie(FrintezzaManager.this.frintezza, 500, 60, 15, 4000, 10000, 0);
                        this.next(4, 3000L);
                        break;
                    }
                    case 4: {
                        FrintezzaManager.this.showSocialActionMovie(FrintezzaManager.this.frintezza, 2500, 90, 12, 4000, 10000, 0);
                        this.next(5, 3000L);
                        break;
                    }
                    case 5: {
                        FrintezzaManager.this.updateKnownList(this._weakScarlet);
                        FrintezzaManager.this.showSocialActionMovie(this._weakScarlet, 400, FrintezzaManager.this.calcCameraYaw(this._weakScarlet), 5, 0, 30000, 0);
                        this.next(6, 100L);
                        break;
                    }
                    case 6: {
                        FrintezzaManager.this._hall.broadcastPacket(new SocialAction(this._weakScarlet.getObjectId(), 2));
                        this.next(601, 3500L);
                        break;
                    }
                    case 601: {
                        FrintezzaManager.this.flickPlayers(this._weakScarlet, 300.0);
                        this.next(7, 3000L);
                        break;
                    }
                    case 7: {
                        FrintezzaManager.this.strongScarlet = (L2GrandBossInstance)FrintezzaManager.this.createNewSpawn(29047, this._weakScarlet.getX(), this._weakScarlet.getY(), this._weakScarlet.getZ(), this._weakScarlet.getHeading(), 0).doSpawn();
                        double newHp = this._weakScarlet.getStatus().getCurrentHp() / (double)this._weakScarlet.getMaxHp() * FrintezzaManager.this.strongScarlet.getStatus().getCurrentHp();
                        FrintezzaManager.this.strongScarlet.getStatus().setCurrentHp(newHp);
                        FrintezzaManager.this.setIdle(FrintezzaManager.this.strongScarlet);
                        FrintezzaManager.this.strongScarlet.setIsInSocialAction(true);
                        FrintezzaManager.this.strongScarlet.setTarget(this._weakScarlet.getTarget());
                        boolean[] targeted = FrintezzaManager.this.getTargeted(this._weakScarlet);
                        FrintezzaManager.this.setTargeted(FrintezzaManager.this.strongScarlet, targeted);
                        this._weakScarlet.startAbnormalEffect(AbnormalEffect.STEALTH.getMask() | AbnormalEffect.HOLD_2.getMask());
                        this.next(8, 3000L);
                        break;
                    }
                    case 8: {
                        FrintezzaManager.this.updateKnownList(FrintezzaManager.this.strongScarlet);
                        FrintezzaManager.this.showSocialActionMovie(FrintezzaManager.this.strongScarlet, 300, FrintezzaManager.this.calcCameraYaw(FrintezzaManager.this.strongScarlet), 12, 2000, 3000, 0);
                        this.next(9, 2000L);
                        break;
                    }
                    case 9: {
                        this._weakScarlet.deleteMe();
                        this._weakScarlet = null;
                        FrintezzaManager.this.showSocialActionMovie(FrintezzaManager.this.strongScarlet, 200, FrintezzaManager.this.calcCameraYaw(FrintezzaManager.this.strongScarlet), 20, 8000, 10000, 2);
                        this.next(10, 4000L);
                        break;
                    }
                    case 10: {
                        for (L2PcInstance pc : FrintezzaManager.this.getPlayersInside()) {
                            L2GrandBossInstance target = FrintezzaManager.this.strongScarlet;
                            int yaw = FrintezzaManager.this.calcCameraYaw(pc.getX(), pc.getY(), target.getX(), target.getY());
                            pc.specialCamera(pc, 0, yaw, 10, 0, 100);
                            pc.leaveMovieMode();
                            pc.enableAllSkills();
                        }
                        this.next(99, 5000L);
                        break;
                    }
                    case 99: {
                        ThreadPoolManager.getInstance().scheduleGeneral(new attackerListener(FrintezzaManager.this.strongScarlet, 150), Rnd.get(4000) + 1000);
                        ThreadPoolManager.getInstance().scheduleGeneral(new ReTarget(FrintezzaManager.this.strongScarlet), FrintezzaManager.this._intervalOfRetarget);
                        ThreadPoolManager.getInstance().scheduleGeneral(new SetMobilisedBoss(FrintezzaManager.this.strongScarlet), 4000L);
                        FrintezzaManager.this.strongScarlet.setRunning();
                        L2Skill skill = SkillTable.getInstance().getInfo(1086, 1);
                        ThreadPoolManager.getInstance().scheduleGeneral(new doSkill(FrintezzaManager.this.strongScarlet, skill, FrintezzaManager.this._intervalOfRetarget, 300), 4016L);
                        FrintezzaManager.this.onLeaveMorph();
                        break;
                    }
                    default: {
                        FrintezzaManager.this.TRACE("FrintezzaManager:1740: 'case " + this._taskId + ":' invalid");
                        throw new AssertionError((Object)("'case " + this._taskId + ":' invalid"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class attackerListener
    implements Runnable {
        private final L2MonsterInstance _mob;
        private final int _aggroDamage;

        public attackerListener(L2MonsterInstance controller, int hate) {
            this._mob = controller;
            this._aggroDamage = hate;
        }

        @Override
        public void run() {
            L2Character mostHated;
            if (this._mob == null) {
                return;
            }
            if (this._mob.isDead() || !this._mob.isVisible()) {
                if (this._mob.getSpawn().isRespawnable()) {
                    ThreadPoolManager.getInstance().scheduleGeneral(this, FrintezzaManager.this._callForHelpInterval + this._mob.getSpawn().getRespawnDelay());
                    return;
                }
                FrintezzaManager.this.portraitDeadCheck(this._mob);
                return;
            }
            if (this._mob == FrintezzaManager.this.weakScarlet) {
                FrintezzaManager.this.weakScarletHpListener();
            }
            ThreadPoolManager.getInstance().scheduleGeneral(this, FrintezzaManager.this._callForHelpInterval + Rnd.get(500));
            if (FrintezzaManager.this.isIdle(this._mob)) {
                return;
            }
            L2Object target = this._mob.getTarget();
            if (target != null && target instanceof L2Character && !((L2Character)target).isDead()) {
                FrintezzaManager.this.callMinionsToAssist((L2Character)target, this._aggroDamage + this._aggroDamage * (this._mob.getMaxHp() - (int)this._mob.getCurrentHp()) / this._mob.getMaxHp());
            }
            if ((mostHated = this._mob.getMostHated()) != null) {
                this._mob.setTarget(mostHated);
            }
        }
    }

    private class exitStunDanceEffect
    implements Runnable {
        private final L2Character _effected;

        public exitStunDanceEffect(L2Character target) {
            this._effected = target;
        }

        @Override
        public void run() {
            if (this._effected == null) {
                return;
            }
            FrintezzaManager.this.setActive(this._effected);
            this._effected.enableAllSkills();
            this._effected.stopAbnormalEffect(AbnormalEffect.DANCE_STUNNED);
        }
    }

    private class exitDecreaseRegHp
    implements Runnable {
        private final Func _func;
        private final L2Character _char;

        public exitDecreaseRegHp(L2Character character, Func func) {
            this._func = func;
            this._char = character;
        }

        @Override
        public void run() {
            if (this._func != null && this._char != null) {
                this._char.removeStatFunc(this._func);
            }
        }
    }

    private class SongEffectLaunched
    implements Runnable {
        private final L2Object[] _targets;
        private final int _song;
        private long _endTime;
        private int _currentHp;

        public SongEffectLaunched(L2Object[] targets, int song, int currentHp, long endTime) {
            this._targets = targets;
            this._song = song;
            this._currentHp = currentHp;
            this._endTime = endTime;
        }

        @Override
        public void run() {
            if (FrintezzaManager.this.frintezza == null) {
                return;
            }
            if (System.currentTimeMillis() > this._endTime) {
                return;
            }
            ThreadPoolManager.getInstance().scheduleGeneral(this, FrintezzaManager.this._intervalOfFrintezzaSongs / 10);
            int previousHp = this._currentHp;
            this._currentHp = (int)FrintezzaManager.this.frintezza.getStatus().getCurrentHp();
            if (this._currentHp < previousHp) {
                L2Object frintezzaTarget = FrintezzaManager.this.frintezza.getTarget();
                if (frintezzaTarget != null && frintezzaTarget instanceof L2Character) {
                    FrintezzaManager.this.callMinionsToAssist((L2Character)frintezzaTarget, 200);
                }
                return;
            }
            for (L2Object target : this._targets) {
                L2Character cha;
                if (target == null || !(target instanceof L2Character) || (cha = (L2Character)target).isDead() || cha.isInvul()) continue;
                cha.broadcastPacket(new MagicSkillUse(FrintezzaManager.this.frintezza, cha, 5008, this._song, 0, 0), 10000);
                this.calculateSongEffects(cha);
            }
        }

        private void calculateSongEffects(L2Character target) {
            if (target == null) {
                return;
            }
            try {
                switch (this._song) {
                    case 1: {
                        L2Skill skill = SkillTable.getInstance().getInfo(1217, 33);
                        FrintezzaManager.this.frintezza.callSkill(skill, target);
                        break;
                    }
                    case 2: {
                        L2Skill skill = SkillTable.getInstance().getInfo(1204, 2);
                        FrintezzaManager.this.frintezza.callSkill(skill, target);
                        break;
                    }
                    case 3: {
                        L2Skill skill = SkillTable.getInstance().getInfo(1086, 2);
                        FrintezzaManager.this.frintezza.callSkill(skill, target);
                        break;
                    }
                    case 4: {
                        if (Rnd.get(100) >= 80) break;
                        FrintezzaManager.this.decreaseEffectOfHpReg(target);
                        break;
                    }
                    case 5: {
                        if (Rnd.get(100) >= 80) break;
                        FrintezzaManager.this.startStunDanceEffect(target);
                    }
                }
            }
            catch (RuntimeException e) {
                BossEntity._log.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        protected void cancel() {
            this._endTime = 0L;
            FrintezzaManager.this.frintezza.broadcastPacket(new MagicSkillCanceld(FrintezzaManager.this.frintezza.getObjectId()));
        }
    }

    class Music
    implements Runnable {
        private int _song = 0;
        private long _pauseTime = 0L;
        private SongEffectLaunched _songEffectLaunched;

        Music() {
        }

        @Override
        public void run() {
            if (FrintezzaManager.this.frintezza == null) {
                return;
            }
            if (this._pauseTime > 0L) {
                long time = this._pauseTime;
                this.pause(0L);
                ThreadPoolManager.getInstance().scheduleGeneral(this, time);
                return;
            }
            if (FrintezzaManager.this.frintezza.isInSocialAction()) {
                this._song = 0;
                ThreadPoolManager.getInstance().scheduleGeneral(this, FrintezzaManager.this._intervalOfFrintezzaSongs);
                return;
            }
            int song = this.getSong();
            double mpConsume = (song - 1) * 10;
            if (FrintezzaManager.this.frintezza.getStatus().getCurrentMp() < mpConsume) {
                this._song = 0;
                ThreadPoolManager.getInstance().scheduleGeneral(this, FrintezzaManager.this._intervalOfFrintezzaSongs);
                return;
            }
            FrintezzaManager.this.frintezza.getStatus().reduceMp(mpConsume);
            FrintezzaManager.this._hall.broadcastPacket(new MagicSkillUse(FrintezzaManager.this.frintezza, FrintezzaManager.this.frintezza, 5007, song, FrintezzaManager.this._intervalOfFrintezzaSongs, 0));
            int currentHp = (int)FrintezzaManager.this.frintezza.getStatus().getCurrentHp();
            long effectEndTime = System.currentTimeMillis() + (long)FrintezzaManager.this._intervalOfFrintezzaSongs;
            this._songEffectLaunched = new SongEffectLaunched(this.getSongTargets(song), song, currentHp, effectEndTime);
            ThreadPoolManager.getInstance().scheduleGeneral(this._songEffectLaunched, 10000L);
            ThreadPoolManager.getInstance().scheduleGeneral(this, FrintezzaManager.this._intervalOfFrintezzaSongs + Rnd.get(10000));
            if (song != this._song) {
                this._song = song;
                FrintezzaManager.this._hall.broadcastPacket(new ExShowScreenMessage(MUSIC_TITLE[song], 10000));
            }
        }

        private L2Object[] getSongTargets(int songId) {
            FastList targets = new FastList();
            if (songId < 4) {
                if (FrintezzaManager.this.weakScarlet != null && !FrintezzaManager.this.weakScarlet.isDead()) {
                    targets.add(FrintezzaManager.this.weakScarlet);
                }
                if (FrintezzaManager.this.strongScarlet != null && !FrintezzaManager.this.strongScarlet.isDead()) {
                    targets.add(FrintezzaManager.this.strongScarlet);
                }
                if (FrintezzaManager.this.portrait1 != null && !FrintezzaManager.this.portrait1.isDead()) {
                    targets.add(FrintezzaManager.this.portrait1);
                }
                if (FrintezzaManager.this.portrait2 != null && !FrintezzaManager.this.portrait2.isDead()) {
                    targets.add(FrintezzaManager.this.portrait2);
                }
                if (FrintezzaManager.this.portrait3 != null && !FrintezzaManager.this.portrait3.isDead()) {
                    targets.add(FrintezzaManager.this.portrait3);
                }
                if (FrintezzaManager.this.portrait4 != null && !FrintezzaManager.this.portrait4.isDead()) {
                    targets.add(FrintezzaManager.this.portrait4);
                }
                if (FrintezzaManager.this.ghost1 != null && !FrintezzaManager.this.ghost1.isDead()) {
                    targets.add(FrintezzaManager.this.ghost1);
                }
                if (FrintezzaManager.this.ghost2 != null && !FrintezzaManager.this.ghost2.isDead()) {
                    targets.add(FrintezzaManager.this.ghost2);
                }
                if (FrintezzaManager.this.ghost3 != null && !FrintezzaManager.this.ghost3.isDead()) {
                    targets.add(FrintezzaManager.this.ghost3);
                }
                if (FrintezzaManager.this.ghost4 != null && !FrintezzaManager.this.ghost4.isDead()) {
                    targets.add(FrintezzaManager.this.ghost4);
                }
                targets.add(FrintezzaManager.this.frintezza);
            } else {
                for (L2PcInstance pc : FrintezzaManager.this.getPlayersInside()) {
                    if (pc.isDead()) continue;
                    targets.add(pc);
                }
            }
            return targets.toArray(new L2Object[targets.size()]);
        }

        private int getSong() {
            int n;
            if (this.minionsNeedHeal()) {
                return 1;
            }
            int n2 = FrintezzaManager.this._scarletType == 3 ? 5 : (n = FrintezzaManager.this._scarletType == 2 ? 7 : 11);
            if (this._song == 5) {
                n *= 2;
            }
            if (Rnd.get(n) == 0) {
                return 5;
            }
            return Rnd.get(2, 4);
        }

        private boolean minionsNeedHeal() {
            boolean returnValue = false;
            if (FrintezzaManager.this.weakScarlet != null && !FrintezzaManager.this.weakScarlet.isAlikeDead() && FrintezzaManager.this.weakScarlet.getStatus().getCurrentHp() < (double)(FrintezzaManager.this.weakScarlet.getMaxHp() * 2 / 3)) {
                returnValue = true;
            } else if (FrintezzaManager.this.strongScarlet != null && !FrintezzaManager.this.strongScarlet.isAlikeDead() && FrintezzaManager.this.strongScarlet.getStatus().getCurrentHp() < (double)(FrintezzaManager.this.strongScarlet.getMaxHp() * 2 / 3)) {
                returnValue = true;
            } else if (FrintezzaManager.this.portrait1 != null && !FrintezzaManager.this.portrait1.isAlikeDead() && FrintezzaManager.this.portrait1.getStatus().getCurrentHp() < (double)(FrintezzaManager.this.portrait1.getMaxHp() / 3) || FrintezzaManager.this.portrait2 != null && !FrintezzaManager.this.portrait2.isAlikeDead() && FrintezzaManager.this.portrait2.getStatus().getCurrentHp() < (double)(FrintezzaManager.this.portrait2.getMaxHp() / 3) || FrintezzaManager.this.portrait3 != null && !FrintezzaManager.this.portrait3.isAlikeDead() && FrintezzaManager.this.portrait3.getStatus().getCurrentHp() < (double)(FrintezzaManager.this.portrait3.getMaxHp() / 3) || FrintezzaManager.this.portrait4 != null && !FrintezzaManager.this.portrait4.isAlikeDead() && FrintezzaManager.this.portrait4.getStatus().getCurrentHp() < (double)(FrintezzaManager.this.portrait4.getMaxHp() / 3)) {
                returnValue = true;
            }
            if (returnValue && Rnd.get(100) > 40) {
                return false;
            }
            return returnValue;
        }

        public void pause(long time) {
            this._pauseTime = time;
            this._song = 0;
            if (this._songEffectLaunched != null) {
                this._songEffectLaunched.cancel();
                long delay = 0L;
                for (L2Character ch : FrintezzaManager.this._hall.getCharactersInside().values()) {
                    if (!(ch instanceof L2PcInstance)) continue;
                    L2PcInstance pc = (L2PcInstance)ch;
                    Func func = FrintezzaManager.this.getDecreaseRegHpFunc();
                    if (FrintezzaManager.this.isDecreaseRegHp(pc, func)) {
                        ThreadPoolManager.getInstance().scheduleGeneral(new exitDecreaseRegHp(pc, func), delay += 333L);
                    }
                    if (!FrintezzaManager.this.isStunDanceEffect(pc)) continue;
                    ThreadPoolManager.getInstance().scheduleGeneral(new exitStunDanceEffect(pc), delay += 333L);
                }
            }
        }
    }

    class ScarletWeakSpawn
    implements Runnable {
        private int _taskId = 0;
        private L2MonsterInstance _frintezzaDummy;
        private L2MonsterInstance _overheadDummy;
        private L2MonsterInstance _portraitDummy1;
        private L2MonsterInstance _portraitDummy3;
        private L2MonsterInstance _scarletDummy;

        ScarletWeakSpawn() {
        }

        private void next(int taskId, long delay) {
            this._taskId = taskId;
            ThreadPoolManager.getInstance().scheduleGeneral(this, delay);
        }

        @Override
        public void run() {
            try {
                switch (this._taskId) {
                    case -180: 
                    case 0: {
                        FrintezzaManager.this._scarletType = 1;
                        this.next(-120, 60000L);
                        FrintezzaManager.this._zone.broadcastPacket(new ExShowScreenMessage("\uff13\u5206\u524d", 10000));
                        break;
                    }
                    case -120: {
                        this.next(-60, 60000L);
                        FrintezzaManager.this._zone.broadcastPacket(new ExShowScreenMessage("\uff12\u5206\u524d", 10000));
                        break;
                    }
                    case -60: {
                        this.next(-12, 48000L);
                        FrintezzaManager.this._zone.broadcastPacket(new ExShowScreenMessage("\uff11\u5206\u524d", 10000));
                        break;
                    }
                    case -12: {
                        this.next(1, 12000L);
                        FrintezzaManager.this._zone.broadcastPacket(new Earthquake(174232, -88020, -5116, 45, 15));
                        break;
                    }
                    case 1: {
                        FrintezzaManager.this.frintezza = (L2GrandBossInstance)FrintezzaManager.this.createNewSpawn(29045, 174240, -89805, -5022, 16048, 0).doSpawn();
                        FrintezzaManager.this.frintezza.setIsInSocialAction(true);
                        FrintezzaManager.this.frintezza.setIsOverloaded(true);
                        FrintezzaManager.this.portrait1 = (L2MonsterInstance)FrintezzaManager.this.createNewSpawn(29048, 175833, -87165, -4972, 35048, 0).doSpawn();
                        FrintezzaManager.this.portrait2 = (L2MonsterInstance)FrintezzaManager.this.createNewSpawn(29049, 175876, -88713, -4972, 28205, 0).doSpawn();
                        FrintezzaManager.this.portrait3 = (L2MonsterInstance)FrintezzaManager.this.createNewSpawn(29048, 172608, -88702, -4972, 64817, 0).doSpawn();
                        FrintezzaManager.this.portrait4 = (L2MonsterInstance)FrintezzaManager.this.createNewSpawn(29049, 172634, -87165, -4972, 57730, 0).doSpawn();
                        FrintezzaManager.this.portrait1.setIsImmobilized(true);
                        FrintezzaManager.this.portrait2.setIsImmobilized(true);
                        FrintezzaManager.this.portrait3.setIsImmobilized(true);
                        FrintezzaManager.this.portrait4.setIsImmobilized(true);
                        this._frintezzaDummy = (L2MonsterInstance)FrintezzaManager.this.createNewSpawn(29052, 174240, -89805, -5022, 16384, 0).doSpawn();
                        this._frintezzaDummy.setIsImmobilized(true);
                        this._frintezzaDummy.setIsInvul(true);
                        this._frintezzaDummy.setCollisionHeight(FrintezzaManager.this.frintezza.getCollisionHeight());
                        FrintezzaManager.this._hall.broadcastPacket(new AbstractNpcInfo.NpcInfo(this._frintezzaDummy, null));
                        this._overheadDummy = (L2MonsterInstance)FrintezzaManager.this.createNewSpawn(29052, 174232, -88020, -5116, 16048, 0).doSpawn();
                        this._overheadDummy.setIsImmobilized(true);
                        this._overheadDummy.setIsInvul(true);
                        this._overheadDummy.setCollisionHeight(600.0);
                        FrintezzaManager.this._hall.broadcastPacket(new AbstractNpcInfo.NpcInfo(this._overheadDummy, null));
                        this._portraitDummy1 = (L2MonsterInstance)FrintezzaManager.this.createNewSpawn(29052, 172450, -87890, -5089, 16048, 0).doSpawn();
                        this._portraitDummy1.setIsImmobilized(true);
                        this._portraitDummy1.setIsInvul(true);
                        this._portraitDummy3 = (L2MonsterInstance)FrintezzaManager.this.createNewSpawn(29052, 176012, -87890, -5089, 16048, 0).doSpawn();
                        this._portraitDummy3.setIsImmobilized(true);
                        this._portraitDummy3.setIsInvul(true);
                        this._scarletDummy = (L2MonsterInstance)FrintezzaManager.this.createNewSpawn(29053, 174232, -88020, -5116, 16384, 0).doSpawn();
                        this._scarletDummy.setIsImmobilized(true);
                        this._scarletDummy.setIsInvul(true);
                        LastImperialTombManager.getInstance().cleanUpMobs();
                        DoorTable.getInstance().getDoor(25150046).closeMe();
                        FrintezzaManager.this.teleportToStart(174232, -88020, -2500);
                        FrintezzaManager.this.updateKnownList(FrintezzaManager.this.frintezza);
                        FrintezzaManager.this.updateKnownList(this._frintezzaDummy);
                        FrintezzaManager.this.updateKnownList(this._scarletDummy);
                        FrintezzaManager.this.updateKnownList(this._overheadDummy);
                        FrintezzaManager.this.updateKnownList(this._portraitDummy1);
                        FrintezzaManager.this.updateKnownList(this._portraitDummy3);
                        this.next(2, 1000L);
                        FrintezzaManager.this._state.setRespawnDate(FrintezzaManager.this._intervalOfBoss);
                        FrintezzaManager.this._state.setState(1);
                        FrintezzaManager.this._state.update();
                        BossEntity._log.info("FrintezzaManager : Spawn Frintezza.");
                        break;
                    }
                    case 2: {
                        FrintezzaManager.this.showSocialActionMovie(this._overheadDummy, 0, 75, -89, 0, 10000, 0, false);
                        this.next(3, 100L);
                        break;
                    }
                    case 3: {
                        FrintezzaManager.this.showSocialActionMovie(this._overheadDummy, 300, 90, -10, 7000, 10000, 0);
                        this.next(4, 6500L);
                        break;
                    }
                    case 4: {
                        FrintezzaManager.this.showSocialActionMovie(this._frintezzaDummy, 1800, 90, 8, 7000, 10000, 0);
                        this.next(5, 2500L);
                        break;
                    }
                    case 5: {
                        FrintezzaManager.this.showSocialActionMovie(this._frintezzaDummy, 140, 90, 10, 7000, 10000, 0);
                        this.next(6, 2500L);
                        break;
                    }
                    case 6: {
                        FrintezzaManager.this.showSocialActionMovie(FrintezzaManager.this.frintezza, 40, 75, -10, 0, 10000, 0);
                        this.next(7, 100L);
                        break;
                    }
                    case 7: {
                        FrintezzaManager.this._hall.broadcastPacket(new SocialAction(FrintezzaManager.this.frintezza.getObjectId(), 2));
                        this.next(8, 7400L);
                        break;
                    }
                    case 8: {
                        for (L2PcInstance pc : FrintezzaManager.this.getPlayersInside()) {
                            if (pc.getX() < 174232) {
                                pc.specialCamera(this._portraitDummy1, 1000, 118, 0, 0, 10000);
                                continue;
                            }
                            pc.specialCamera(this._portraitDummy3, 1000, 62, 0, 0, 10000);
                        }
                        this._frintezzaDummy.deleteMe();
                        this._frintezzaDummy = null;
                        FrintezzaManager.this.ghost2 = (L2MonsterInstance)FrintezzaManager.this.createNewSpawn(29051, 175876, -88713, -4972, 28205, FrintezzaManager.this._intervalOfGhosts).doSpawn();
                        FrintezzaManager.this.ghost3 = (L2MonsterInstance)FrintezzaManager.this.createNewSpawn(29051, 172608, -88702, -4972, 64817, FrintezzaManager.this._intervalOfGhosts).doSpawn();
                        FrintezzaManager.this.ghost2.setIsImmobilized(true);
                        FrintezzaManager.this.ghost3.setIsImmobilized(true);
                        this.next(9, 1800L);
                        break;
                    }
                    case 9: {
                        FrintezzaManager.this.ghost1 = (L2MonsterInstance)FrintezzaManager.this.createNewSpawn(29050, 175833, -87165, -4972, 35048, FrintezzaManager.this._intervalOfGhosts).doSpawn();
                        FrintezzaManager.this.ghost4 = (L2MonsterInstance)FrintezzaManager.this.createNewSpawn(29050, 172634, -87165, -4972, 57730, FrintezzaManager.this._intervalOfGhosts).doSpawn();
                        FrintezzaManager.this.ghost1.setIsImmobilized(true);
                        FrintezzaManager.this.ghost4.setIsImmobilized(true);
                        this.next(9001, 700L);
                        break;
                    }
                    case 9001: {
                        FrintezzaManager.this._hall.broadcastPacket(new SocialAction(FrintezzaManager.this.ghost2.getObjectId(), 1));
                        FrintezzaManager.this._hall.broadcastPacket(new SocialAction(FrintezzaManager.this.ghost3.getObjectId(), 1));
                        this.next(9002, 700L);
                        break;
                    }
                    case 9002: {
                        FrintezzaManager.this._hall.broadcastPacket(new SocialAction(FrintezzaManager.this.ghost1.getObjectId(), 1));
                        FrintezzaManager.this._hall.broadcastPacket(new SocialAction(FrintezzaManager.this.ghost4.getObjectId(), 1));
                        this.next(10, 2300L);
                        break;
                    }
                    case 10: {
                        FrintezzaManager.this.showSocialActionMovie(FrintezzaManager.this.frintezza, 240, 90, 0, 0, 10000, 0);
                        this.next(11, 10L);
                        break;
                    }
                    case 11: {
                        FrintezzaManager.this.showSocialActionMovie(FrintezzaManager.this.frintezza, 240, 90, 25, 5500, 10000, 3);
                        this.next(12, 5000L);
                        FrintezzaManager.this.weakScarlet = (L2GrandBossInstance)FrintezzaManager.this.createNewSpawn(29046, 174232, -88020, -5116, 16384, 0).doSpawn(true);
                        break;
                    }
                    case 12: {
                        FrintezzaManager.this.showSocialActionMovie(FrintezzaManager.this.frintezza, 100, 195, 35, 0, 10000, 0);
                        this.next(13, 200L);
                        break;
                    }
                    case 13: {
                        FrintezzaManager.this.showSocialActionMovie(FrintezzaManager.this.frintezza, 100, 195, 35, 0, 10000, 0);
                        this.next(14, 1000L);
                        break;
                    }
                    case 14: {
                        FrintezzaManager.this._hall.broadcastPacket(new MagicSkillUse(FrintezzaManager.this.frintezza, FrintezzaManager.this.frintezza, 5006, 1, 34000, 0));
                        FrintezzaManager.this.showSocialActionMovie(FrintezzaManager.this.frintezza, 120, 180, 45, 1500, 10000, 0);
                        this.next(16, 1500L);
                        FrintezzaManager.this.weakScarlet.deleteMe();
                        break;
                    }
                    case 16: {
                        FrintezzaManager.this.showSocialActionMovie(FrintezzaManager.this.frintezza, 520, 135, 45, 8000, 10000, 0);
                        this.next(17, 7500L);
                        break;
                    }
                    case 17: {
                        FrintezzaManager.this.showSocialActionMovie(FrintezzaManager.this.frintezza, 1500, 110, 25, 10000, 15000, 0);
                        this.next(18, 9500L);
                        break;
                    }
                    case 18: {
                        L2Skill skill = SkillTable.getInstance().getInfo(5004, 1);
                        FrintezzaManager.this._hall.broadcastPacket(new MagicSkillUse(this._scarletDummy, this._scarletDummy, skill.getDisplayId(), skill.getLevel(), skill.getHitTime(), skill.getReuseDelay()));
                        skill = null;
                        FrintezzaManager.this.showSocialActionMovie(this._overheadDummy, 930, 160, -20, 1, 10000, 0);
                        this.next(19, 4000L);
                        break;
                    }
                    case 19: {
                        FrintezzaManager.this.weakScarlet = (L2GrandBossInstance)FrintezzaManager.this.createNewSpawn(29046, 174232, -88020, -5116, 16384, 0).doSpawn(true);
                        FrintezzaManager.this.weakScarlet.setIsImmobilized(true);
                        FrintezzaManager.this.weakScarlet.setIsInSocialAction(true);
                        this.next(1901, 2000L);
                        break;
                    }
                    case 1901: {
                        FrintezzaManager.this.showSocialActionMovie(this._scarletDummy, 800, 160, 5, 500, 10000, 0);
                        this.next(1902, 1200L);
                        break;
                    }
                    case 1902: {
                        FrintezzaManager.this.flickPlayers(FrintezzaManager.this.weakScarlet, 300.0);
                        this.next(20, 6000L);
                        break;
                    }
                    case 20: {
                        for (L2PcInstance pc : FrintezzaManager.this.getPlayersInside()) {
                            L2GrandBossInstance target = FrintezzaManager.this.weakScarlet;
                            int yaw = FrintezzaManager.this.calcCameraYaw(pc.getX(), pc.getY(), target.getX(), target.getY());
                            pc.specialCamera(target, 800, yaw, 10, 300, 4000);
                        }
                        this.next(21, 3000L);
                        break;
                    }
                    case 21: {
                        for (L2PcInstance pc : FrintezzaManager.this.getPlayersInside()) {
                            L2GrandBossInstance target = FrintezzaManager.this.weakScarlet;
                            int yaw = FrintezzaManager.this.calcCameraYaw(pc.getX(), pc.getY(), target.getX(), target.getY());
                            pc.specialCamera(pc, 0, yaw, 10, 0, 100);
                            pc.leaveMovieMode();
                            pc.enableAllSkills();
                        }
                        this.next(99, 500L);
                        break;
                    }
                    case 99: {
                        FrintezzaManager.this.ghost1.setIsImmobilized(false);
                        FrintezzaManager.this.ghost2.setIsImmobilized(false);
                        FrintezzaManager.this.ghost3.setIsImmobilized(false);
                        FrintezzaManager.this.ghost4.setIsImmobilized(false);
                        FrintezzaManager.this.npcSpawned(FrintezzaManager.this.ghost1);
                        FrintezzaManager.this.npcSpawned(FrintezzaManager.this.ghost2);
                        FrintezzaManager.this.npcSpawned(FrintezzaManager.this.ghost3);
                        FrintezzaManager.this.npcSpawned(FrintezzaManager.this.ghost4);
                        L2Spawn.addSpawnListener(FrintezzaManager.getInstance());
                        FrintezzaManager.this.weakScarlet.setShowSummonAnimation(false);
                        FrintezzaManager.this.weakScarlet.abortCast();
                        FrintezzaManager.this.frintezza.abortCast();
                        new SetMobilisedBoss(FrintezzaManager.this.weakScarlet).run();
                        new SetMobilisedBoss(FrintezzaManager.this.frintezza).run();
                        ThreadPoolManager.getInstance().scheduleGeneral(new ReTarget(FrintezzaManager.this.frintezza), FrintezzaManager.this._intervalOfRetarget);
                        ThreadPoolManager.getInstance().scheduleGeneral(new ReTarget(FrintezzaManager.this.weakScarlet), FrintezzaManager.this._intervalOfRetarget + 16);
                        FrintezzaManager.this.weakScarlet.setRunning();
                        FrintezzaManager.this.music = new Music();
                        ThreadPoolManager.getInstance().scheduleGeneral(FrintezzaManager.this.music, Rnd.get(FrintezzaManager.this._intervalOfFrintezzaSongs));
                        FrintezzaManager.this.startAttackListeners();
                        FrintezzaManager.this._activityTimeEndTask = ThreadPoolManager.getInstance().scheduleGeneral(new ActivityTimeEnd(), FrintezzaManager.this._activityTimeOfBoss);
                        if (this._frintezzaDummy != null) {
                            this._frintezzaDummy.deleteMe();
                            this._frintezzaDummy = null;
                        }
                        if (this._overheadDummy != null) {
                            this._overheadDummy.deleteMe();
                            this._overheadDummy = null;
                        }
                        if (this._portraitDummy1 != null) {
                            this._portraitDummy1.deleteMe();
                            this._portraitDummy1 = null;
                        }
                        if (this._portraitDummy3 != null) {
                            this._portraitDummy3.deleteMe();
                            this._portraitDummy3 = null;
                        }
                        if (this._scarletDummy != null) {
                            this._scarletDummy.deleteMe();
                            this._scarletDummy = null;
                        }
                        break;
                    }
                    default: {
                        FrintezzaManager.this.TRACE("FrintezzaManager:722: 'case " + this._taskId + ":' invalid");
                        throw new AssertionError((Object)("'case " + this._taskId + ":' invalid"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static final class SingletonHolder {
        protected static final FrintezzaManager INSTANCE = new FrintezzaManager();

        private SingletonHolder() {
        }
    }
}

