/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SignsPriestInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2DawnPriestInstance
extends L2SignsPriestInstance {
    public L2DawnPriestInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2DawnPriestInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("Chat")) {
            this.showChatWindow(player);
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        String filename;
        player.sendPacket(ActionFailed.STATIC_PACKET);
        int sealGnosisOwner = SevenSigns.getInstance().getSealOwner(2);
        int playerCabal = SevenSigns.getInstance().getPlayerCabal(player);
        boolean isSealValidationPeriod = SevenSigns.getInstance().isSealValidationPeriod();
        boolean isCompResultsPeriod = SevenSigns.getInstance().isCompResultsPeriod();
        int recruitPeriod = SevenSigns.getInstance().getCurrentPeriod();
        int compWinner = SevenSigns.getInstance().getCabalHighestScore();
        switch (playerCabal) {
            case 2: {
                if (isCompResultsPeriod) {
                    filename = "dawn_priest_5.htm";
                    break;
                }
                if (recruitPeriod == 0) {
                    filename = "dawn_priest_6.htm";
                    break;
                }
                if (isSealValidationPeriod) {
                    if (compWinner == 2) {
                        if (compWinner != sealGnosisOwner) {
                            filename = "dawn_priest_2c.htm";
                            break;
                        }
                        filename = "dawn_priest_2a.htm";
                        break;
                    }
                    if (compWinner == 0) {
                        filename = "dawn_priest_2d.htm";
                        break;
                    }
                    filename = "dawn_priest_2b.htm";
                    break;
                }
                filename = "dawn_priest_1b.htm";
                break;
            }
            case 1: {
                if (isSealValidationPeriod) {
                    filename = "dawn_priest_3a.htm";
                    break;
                }
                filename = "dawn_priest_3b.htm";
                break;
            }
            default: {
                if (isCompResultsPeriod) {
                    filename = "dawn_priest_5.htm";
                    break;
                }
                if (recruitPeriod == 0) {
                    filename = "dawn_priest_6.htm";
                    break;
                }
                if (isSealValidationPeriod) {
                    if (compWinner == 2) {
                        filename = "dawn_priest_4.htm";
                        break;
                    }
                    if (compWinner == 0) {
                        filename = "dawn_priest_2d.htm";
                        break;
                    }
                    filename = "dawn_priest_2b.htm";
                    break;
                }
                filename = "dawn_priest_1a.htm";
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), "data/html/seven_signs/" + filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
    }
}

