/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.StringUtil;
import java.util.Calendar;
import java.util.List;

public final class L2FestivalGuideInstance
extends L2Npc {
    protected int _festivalType;
    protected int _festivalOracle;
    protected int _blueStonesNeeded;
    protected int _greenStonesNeeded;
    protected int _redStonesNeeded;

    public L2FestivalGuideInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2FestivalGiudeInstance);
        switch (this.getNpcId()) {
            case 31127: 
            case 31132: {
                this._festivalType = 0;
                this._festivalOracle = 2;
                this._blueStonesNeeded = 900;
                this._greenStonesNeeded = 540;
                this._redStonesNeeded = 270;
                break;
            }
            case 31128: 
            case 31133: {
                this._festivalType = 1;
                this._festivalOracle = 2;
                this._blueStonesNeeded = 1500;
                this._greenStonesNeeded = 900;
                this._redStonesNeeded = 450;
                break;
            }
            case 31129: 
            case 31134: {
                this._festivalType = 2;
                this._festivalOracle = 2;
                this._blueStonesNeeded = 3000;
                this._greenStonesNeeded = 1800;
                this._redStonesNeeded = 900;
                break;
            }
            case 31130: 
            case 31135: {
                this._festivalType = 3;
                this._festivalOracle = 2;
                this._blueStonesNeeded = 4500;
                this._greenStonesNeeded = 2700;
                this._redStonesNeeded = 1350;
                break;
            }
            case 31131: 
            case 31136: {
                this._festivalType = 4;
                this._festivalOracle = 2;
                this._blueStonesNeeded = 6000;
                this._greenStonesNeeded = 3600;
                this._redStonesNeeded = 1800;
                break;
            }
            case 31137: 
            case 31142: {
                this._festivalType = 0;
                this._festivalOracle = 1;
                this._blueStonesNeeded = 900;
                this._greenStonesNeeded = 540;
                this._redStonesNeeded = 270;
                break;
            }
            case 31138: 
            case 31143: {
                this._festivalType = 1;
                this._festivalOracle = 1;
                this._blueStonesNeeded = 1500;
                this._greenStonesNeeded = 900;
                this._redStonesNeeded = 450;
                break;
            }
            case 31139: 
            case 31144: {
                this._festivalType = 2;
                this._festivalOracle = 1;
                this._blueStonesNeeded = 3000;
                this._greenStonesNeeded = 1800;
                this._redStonesNeeded = 900;
                break;
            }
            case 31140: 
            case 31145: {
                this._festivalType = 3;
                this._festivalOracle = 1;
                this._blueStonesNeeded = 4500;
                this._greenStonesNeeded = 2700;
                this._redStonesNeeded = 1350;
                break;
            }
            case 31141: 
            case 31146: {
                this._festivalType = 4;
                this._festivalOracle = 1;
                this._blueStonesNeeded = 6000;
                this._greenStonesNeeded = 3600;
                this._redStonesNeeded = 1800;
            }
        }
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("FestivalDesc")) {
            int val = Integer.parseInt(command.substring(13));
            this.showChatWindow(player, val, null, true);
        } else if (command.startsWith("Festival")) {
            L2Party playerParty = player.getParty();
            int val = Integer.parseInt(command.substring(9, 10));
            switch (val) {
                case 1: {
                    if (SevenSigns.getInstance().isSealValidationPeriod()) {
                        this.showChatWindow(player, 2, "a", false);
                        return;
                    }
                    if (SevenSignsFestival.getInstance().isFestivalInitialized()) {
                        player.sendMessage("You cannot sign up while a festival is in progress.");
                        return;
                    }
                    if (playerParty == null) {
                        this.showChatWindow(player, 2, "b", false);
                        return;
                    }
                    if (!playerParty.isLeader(player)) {
                        this.showChatWindow(player, 2, "c", false);
                        return;
                    }
                    if (playerParty.getMemberCount() < Config.ALT_FESTIVAL_MIN_PLAYER) {
                        this.showChatWindow(player, 2, "b", false);
                        return;
                    }
                    if (playerParty.getLevel() > SevenSignsFestival.getMaxLevelForFestival(this._festivalType)) {
                        this.showChatWindow(player, 2, "d", false);
                        return;
                    }
                    if (player.isFestivalParticipant()) {
                        SevenSignsFestival.getInstance().setParticipants(this._festivalOracle, this._festivalType, playerParty);
                        this.showChatWindow(player, 2, "f", false);
                        return;
                    }
                    this.showChatWindow(player, 1, null, false);
                    break;
                }
                case 2: {
                    int stoneType = Integer.parseInt(command.substring(11));
                    int stonesNeeded = 0;
                    switch (stoneType) {
                        case 6360: {
                            stonesNeeded = this._blueStonesNeeded;
                            break;
                        }
                        case 6361: {
                            stonesNeeded = this._greenStonesNeeded;
                            break;
                        }
                        case 6362: {
                            stonesNeeded = this._redStonesNeeded;
                        }
                    }
                    if (!player.destroyItemByItemId("SevenSigns", stoneType, stonesNeeded, this, true)) {
                        return;
                    }
                    SevenSignsFestival.getInstance().setParticipants(this._festivalOracle, this._festivalType, playerParty);
                    SevenSignsFestival.getInstance().addAccumulatedBonus(this._festivalType, stoneType, stonesNeeded);
                    this.showChatWindow(player, 2, "e", false);
                    break;
                }
                case 3: {
                    if (SevenSigns.getInstance().isSealValidationPeriod()) {
                        this.showChatWindow(player, 3, "a", false);
                        return;
                    }
                    if (SevenSignsFestival.getInstance().isFestivalInProgress()) {
                        player.sendMessage("You cannot register a score while a festival is in progress.");
                        return;
                    }
                    if (playerParty == null) {
                        this.showChatWindow(player, 3, "b", false);
                        return;
                    }
                    List<L2PcInstance> prevParticipants = SevenSignsFestival.getInstance().getPreviousParticipants(this._festivalOracle, this._festivalType);
                    if (prevParticipants == null) {
                        return;
                    }
                    if (!prevParticipants.contains(player)) {
                        this.showChatWindow(player, 3, "b", false);
                        return;
                    }
                    if (player.getObjectId() != prevParticipants.get(0).getObjectId()) {
                        this.showChatWindow(player, 3, "b", false);
                        return;
                    }
                    L2ItemInstance bloodOfferings = player.getInventory().getItemByItemId(5901);
                    long offeringCount = 0L;
                    if (bloodOfferings == null) {
                        player.sendMessage("You do not have any blood offerings to contribute.");
                        return;
                    }
                    offeringCount = bloodOfferings.getCount();
                    long offeringScore = offeringCount * 5L;
                    boolean isHighestScore = SevenSignsFestival.getInstance().setFinalScore(player, this._festivalOracle, this._festivalType, offeringScore);
                    player.destroyItem("SevenSigns", bloodOfferings, this, false);
                    SystemMessage sm = new SystemMessage(SystemMessageId.CONTRIB_SCORE_INCREASED);
                    sm.addItemNumber(offeringScore);
                    player.sendPacket(sm);
                    if (isHighestScore) {
                        this.showChatWindow(player, 3, "c", false);
                        break;
                    }
                    this.showChatWindow(player, 3, "d", false);
                    break;
                }
                case 4: {
                    StringBuilder strBuffer = StringUtil.startAppend(500, "<html><body>Festival Guide:<br>These are the top scores of the week, for the ");
                    StatsSet dawnData = SevenSignsFestival.getInstance().getHighestScoreData(2, this._festivalType);
                    StatsSet duskData = SevenSignsFestival.getInstance().getHighestScoreData(1, this._festivalType);
                    StatsSet overallData = SevenSignsFestival.getInstance().getOverallHighestScoreData(this._festivalType);
                    int dawnScore = dawnData.getInteger("score");
                    int duskScore = duskData.getInteger("score");
                    int overallScore = 0;
                    if (overallData != null) {
                        overallScore = overallData.getInteger("score");
                    }
                    StringUtil.append(strBuffer, SevenSignsFestival.getFestivalName(this._festivalType), " festival.<br>");
                    if (dawnScore > 0) {
                        StringUtil.append(strBuffer, "Dawn: ", this.calculateDate(dawnData.getString("date")), ". Score ", String.valueOf(dawnScore), "<br>", dawnData.getString("members"), "<br>");
                    } else {
                        strBuffer.append("Dawn: No record exists. Score 0<br>");
                    }
                    if (duskScore > 0) {
                        StringUtil.append(strBuffer, "Dusk: ", this.calculateDate(duskData.getString("date")), ". Score ", String.valueOf(duskScore), "<br>", duskData.getString("members"), "<br>");
                    } else {
                        strBuffer.append("Dusk: No record exists. Score 0<br>");
                    }
                    if (overallScore > 0) {
                        String cabalStr = "Children of Dusk";
                        if (overallData.getString("cabal").equals("dawn")) {
                            cabalStr = "Children of Dawn";
                        }
                        StringUtil.append(strBuffer, "Consecutive top scores: ", this.calculateDate(overallData.getString("date")), ". Score ", String.valueOf(overallScore), "<br>Affilated side: ", cabalStr, "<br>", overallData.getString("members"), "<br>");
                    } else {
                        strBuffer.append("Consecutive top scores: No record exists. Score 0<br>");
                    }
                    StringUtil.append(strBuffer, "<a action=\"bypass -h npc_", String.valueOf(this.getObjectId()), "_Chat 0\">Go back.</a></body></html>");
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setHtml(strBuffer.toString());
                    player.sendPacket(html);
                    break;
                }
                case 8: {
                    if (playerParty == null) {
                        return;
                    }
                    if (!SevenSignsFestival.getInstance().isFestivalInProgress()) {
                        return;
                    }
                    if (!playerParty.isLeader(player)) {
                        this.showChatWindow(player, 8, "a", false);
                        break;
                    }
                    if (SevenSignsFestival.getInstance().increaseChallenge(this._festivalOracle, this._festivalType)) {
                        this.showChatWindow(player, 8, "b", false);
                        break;
                    }
                    this.showChatWindow(player, 8, "c", false);
                    break;
                }
                case 9: {
                    if (playerParty == null) {
                        return;
                    }
                    boolean isLeader = playerParty.isLeader(player);
                    if (isLeader) {
                        SevenSignsFestival.getInstance().updateParticipants(player, null);
                        playerParty.removePartyMember(player);
                        break;
                    }
                    if (playerParty.getMemberCount() > Config.ALT_FESTIVAL_MIN_PLAYER) {
                        playerParty.removePartyMember(player);
                        break;
                    }
                    player.sendMessage("Only the party leader can leave a festival when a party has minimum number of members.");
                    break;
                }
                case 0: {
                    if (!SevenSigns.getInstance().isSealValidationPeriod()) {
                        player.sendMessage("Bonuses cannot be paid during the competition period.");
                        return;
                    }
                    if (SevenSignsFestival.getInstance().distribAccumulatedBonus(player) > 0) {
                        this.showChatWindow(player, 0, "a", false);
                        break;
                    }
                    this.showChatWindow(player, 0, "b", false);
                    break;
                }
                default: {
                    this.showChatWindow(player, val, null, false);
                    break;
                }
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    private void showChatWindow(L2PcInstance player, int val, String suffix, boolean isDescription) {
        String filename = "data/html/seven_signs/festival/";
        filename = filename + (isDescription ? "desc_" : "festival_");
        filename = filename + (suffix != null ? val + suffix + ".htm" : val + ".htm");
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%festivalType%", SevenSignsFestival.getFestivalName(this._festivalType));
        html.replace((CharSequence)"%cycleMins%", SevenSignsFestival.getInstance().getMinsToNextCycle());
        if (!isDescription && "2b".equals(val + suffix)) {
            html.replace((CharSequence)"%minFestivalPartyMembers%", Config.ALT_FESTIVAL_MIN_PLAYER);
        }
        if (val == 5) {
            html.replace((CharSequence)"%statsTable%", this.getStatsTable());
        }
        if (val == 6) {
            html.replace((CharSequence)"%bonusTable%", this.getBonusTable());
        }
        if (val == 1) {
            html.replace((CharSequence)"%blueStoneNeeded%", this._blueStonesNeeded);
            html.replace((CharSequence)"%greenStoneNeeded%", this._greenStonesNeeded);
            html.replace((CharSequence)"%redStoneNeeded%", this._redStonesNeeded);
        }
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    private final String getStatsTable() {
        StringBuilder tableHtml = new StringBuilder(1000);
        for (int i = 0; i < 5; ++i) {
            int dawnScore = SevenSignsFestival.getInstance().getHighestScore(2, i);
            int duskScore = SevenSignsFestival.getInstance().getHighestScore(1, i);
            String festivalName = SevenSignsFestival.getFestivalName(i);
            String winningCabal = "Children of Dusk";
            if (dawnScore > duskScore) {
                winningCabal = "Children of Dawn";
            } else if (dawnScore == duskScore) {
                winningCabal = "None";
            }
            StringUtil.append(tableHtml, "<tr><td width=\"100\" align=\"center\">", festivalName, "</td><td align=\"center\" width=\"35\">", String.valueOf(duskScore), "</td><td align=\"center\" width=\"35\">", String.valueOf(dawnScore), "</td><td align=\"center\" width=\"130\">", winningCabal, "</td></tr>");
        }
        return tableHtml.toString();
    }

    private final String getBonusTable() {
        StringBuilder tableHtml = new StringBuilder(500);
        for (int i = 0; i < 5; ++i) {
            int accumScore = SevenSignsFestival.getInstance().getAccumulatedBonus(i);
            String festivalName = SevenSignsFestival.getFestivalName(i);
            StringUtil.append(tableHtml, "<tr><td align=\"center\" width=\"150\">", festivalName, "</td><td align=\"center\" width=\"150\">", String.valueOf(accumScore), "</td></tr>");
        }
        return tableHtml.toString();
    }

    private final String calculateDate(String milliFromEpoch) {
        long numMillis = Long.valueOf(milliFromEpoch);
        Calendar calCalc = Calendar.getInstance();
        calCalc.setTimeInMillis(numMillis);
        return calCalc.get(1) + "/" + calCalc.get(2) + "/" + calCalc.get(5);
    }
}

