/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeSummonInstance;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.zone.L2SpawnZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import javolution.util.FastList;

public class L2FortZone
extends L2SpawnZone {
    private int _fortId;
    private Fort _fort = null;
    private boolean _isActiveSiege = false;
    private static final int DISMOUNT_DELAY = 5;

    public L2FortZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("fortId")) {
            this._fortId = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        character.setInsideZone((byte)13, true);
        if (this.getFort() != null && this._isActiveSiege) {
            character.setInsideZone((byte)0, true);
            character.setInsideZone((byte)2, true);
            character.setInsideZone((byte)12, true);
            if (character instanceof L2PcInstance) {
                ((L2PcInstance)character).sendPacket(new SystemMessage(SystemMessageId.ENTERED_COMBAT_ZONE));
                if (((L2PcInstance)character).isRegisteredOnThisSiegeField(this.getFort().getFortId())) {
                    ((L2PcInstance)character).startFameTask(Config.FORTRESS_ZONE_FAME_TASK_FREQUENCY * 1000, Config.FORTRESS_ZONE_FAME_AQUIRE_POINTS);
                    ((L2PcInstance)character).setIsInSiege(true);
                }
                if (!Config.ALLOW_WYVERN_DURING_SIEGE && ((L2PcInstance)character).getMountType() == 2) {
                    character.sendPacket(new SystemMessage(SystemMessageId.AREA_CANNOT_BE_ENTERED_WHILE_MOUNTED_WYVERN));
                    ((L2PcInstance)character).enteredNoLanding(5);
                }
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        character.setInsideZone((byte)13, false);
        character.setInsideZone((byte)0, false);
        character.setInsideZone((byte)2, false);
        character.setInsideZone((byte)12, false);
        if (this.getFort() != null && this._isActiveSiege && character instanceof L2PcInstance) {
            ((L2PcInstance)character).sendPacket(new SystemMessage(SystemMessageId.LEFT_COMBAT_ZONE));
            if (((L2PcInstance)character).getMountType() == 2) {
                ((L2PcInstance)character).exitedNoLanding();
            }
            if (((L2PcInstance)character).getPvpFlag() == 0) {
                ((L2PcInstance)character).startPvPFlag();
            }
        }
        if (character instanceof L2SiegeSummonInstance) {
            ((L2SiegeSummonInstance)character).unSummon(((L2SiegeSummonInstance)character).getOwner());
        }
        if (character instanceof L2PcInstance) {
            L2PcInstance activeChar = (L2PcInstance)character;
            activeChar.stopFameTask();
            activeChar.setIsInSiege(false);
            if (activeChar.getInventory().getItemByItemId(9819) != null) {
                Fort fort = FortManager.getInstance().getFort(activeChar);
                if (fort != null) {
                    FortSiegeManager.getInstance().dropCombatFlag(activeChar);
                } else {
                    int slot = activeChar.getInventory().getSlotFromItem(activeChar.getInventory().getItemByItemId(9819));
                    activeChar.getInventory().unEquipItemInBodySlotAndRecord(slot);
                    activeChar.destroyItem("CombatFlag", activeChar.getInventory().getItemByItemId(9819), null, true);
                }
            }
        }
    }

    @Override
    public void onDieInside(L2Character character) {
        if (this.getFort() != null && this._isActiveSiege && character instanceof L2PcInstance && ((L2PcInstance)character).isRegisteredOnThisSiegeField(this.getFort().getFortId())) {
            L2Skill skill;
            int lvl = 1;
            L2Effect e = character.getFirstEffect(5660);
            if (e != null) {
                lvl = Math.min(lvl + e.getLevel(), 5);
            }
            if ((skill = SkillTable.getInstance().getInfo(5660, lvl)) != null) {
                skill.getEffects(character, character);
            }
        }
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    public void updateZoneStatusForCharactersInside() {
        if (this.getFort() != null && this._isActiveSiege) {
            for (L2Character character : this._characterList.values()) {
                try {
                    this.onEnter(character);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (L2Character character : this._characterList.values()) {
                try {
                    character.setInsideZone((byte)0, false);
                    character.setInsideZone((byte)2, false);
                    character.setInsideZone((byte)12, false);
                    if (character instanceof L2PcInstance) {
                        ((L2PcInstance)character).sendPacket(new SystemMessage(SystemMessageId.LEFT_COMBAT_ZONE));
                        ((L2PcInstance)character).stopFameTask();
                        if (((L2PcInstance)character).getMountType() == 2) {
                            ((L2PcInstance)character).exitedNoLanding();
                        }
                    }
                    if (!(character instanceof L2SiegeSummonInstance)) continue;
                    ((L2SiegeSummonInstance)character).unSummon(((L2SiegeSummonInstance)character).getOwner());
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void banishForeigners(L2Clan owningClan) {
        for (L2Character temp : this._characterList.values()) {
            if (!(temp instanceof L2PcInstance) || ((L2PcInstance)temp).getClan() == owningClan) continue;
            ((L2PcInstance)temp).teleToLocation(MapRegionTable.TeleportWhereType.Town);
        }
    }

    public void announceToPlayers(String message) {
        for (L2Character temp : this._characterList.values()) {
            if (!(temp instanceof L2PcInstance)) continue;
            ((L2PcInstance)temp).sendMessage(message);
        }
    }

    public FastList<L2PcInstance> getAllPlayers() {
        FastList players = new FastList();
        for (L2Character temp : this._characterList.values()) {
            if (!(temp instanceof L2PcInstance)) continue;
            players.add((Object)((L2PcInstance)temp));
        }
        return players;
    }

    public int getFortId() {
        return this._fortId;
    }

    private final Fort getFort() {
        if (this._fort == null) {
            this._fort = FortManager.getInstance().getFortById(this._fortId);
        }
        return this._fort;
    }

    public boolean isActive() {
        return this._isActiveSiege;
    }

    public void setIsActive(boolean val) {
        this._isActiveSiege = val;
    }
}

