/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.communitybbs.CommunityBoard;
import com.l2jserver.gameserver.datatables.AdminCommandAccessRights;
import com.l2jserver.gameserver.handler.AdminCommandHandler;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.handler.IVoicedCommandHandler;
import com.l2jserver.gameserver.handler.VoicedCommandHandler;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantSummonInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.L2Event;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.RequestShowCommunityBoard;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.GMAudit;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RequestBypassToServer
extends L2GameClientPacket {
    private static final String _C__21_REQUESTBYPASSTOSERVER = "[C] 21 RequestBypassToServer";
    private static Logger _log = Logger.getLogger(RequestBypassToServer.class.getName());
    private String _command;

    @Override
    protected void readImpl() {
        this._command = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!activeChar.getFloodProtectors().getServerBypass().tryPerformAction(this._command)) {
            return;
        }
        try {
            if (this._command.startsWith("admin_")) {
                String command = this._command.split(" ")[0];
                IAdminCommandHandler ach = AdminCommandHandler.getInstance().getAdminCommandHandler(command);
                if (ach == null) {
                    if (activeChar.isGM()) {
                        activeChar.sendMessage("The command " + command.substring(6) + " does not exist!");
                    }
                    _log.warning("No handler registered for admin command '" + command + "'");
                    return;
                }
                if (!AdminCommandAccessRights.getInstance().hasAccess(command, activeChar.getAccessLevel())) {
                    activeChar.sendMessage("You don't have the access right to use this command!");
                    _log.warning("Character " + activeChar.getName() + " tryed to use admin command " + command + ", but have no access to it!");
                    return;
                }
                if (Config.GMAUDIT) {
                    GMAudit.auditGMAction(activeChar.getName() + " [" + activeChar.getObjectId() + "]", this._command, activeChar.getTarget() != null ? activeChar.getTarget().getName() : "no-target");
                }
                ach.useAdminCommand(this._command, activeChar);
            } else if (this._command.equals("come_here") && activeChar.isGM()) {
                this.comeHere(activeChar);
            } else if (this._command.startsWith("player_help ")) {
                this.playerHelp(activeChar, this._command.substring(12));
            } else if (this._command.startsWith("npc_")) {
                if (!activeChar.validateBypass(this._command)) {
                    return;
                }
                int endOfId = this._command.indexOf(95, 5);
                String id = endOfId > 0 ? this._command.substring(4, endOfId) : this._command.substring(4);
                try {
                    L2Object object = L2World.getInstance().findObject(Integer.parseInt(id));
                    if (this._command.substring(endOfId + 1).startsWith("event_participate")) {
                        L2Event.inscribePlayer(activeChar);
                    } else if (object instanceof L2Npc && endOfId > 0 && activeChar.isInsideRadius(object, 150, false, false)) {
                        ((L2Npc)object).onBypassFeedback(activeChar, this._command.substring(endOfId + 1));
                    }
                    activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                }
                catch (NumberFormatException nfe) {}
            } else if (this._command.startsWith("summon_")) {
                if (!activeChar.validateBypass(this._command)) {
                    return;
                }
                int endOfId = this._command.indexOf(95, 8);
                String id = endOfId > 0 ? this._command.substring(7, endOfId) : this._command.substring(7);
                try {
                    L2Object object = L2World.getInstance().findObject(Integer.parseInt(id));
                    if (object instanceof L2MerchantSummonInstance && endOfId > 0 && activeChar.isInsideRadius(object, 150, false, false)) {
                        ((L2MerchantSummonInstance)object).onBypassFeedback(activeChar, this._command.substring(endOfId + 1));
                    }
                    activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                }
                catch (NumberFormatException nfe) {}
            } else if (this._command.startsWith("manor_menu_select?")) {
                L2Object object = activeChar.getTarget();
                if (object instanceof L2Npc) {
                    ((L2Npc)object).onBypassFeedback(activeChar, this._command);
                }
            } else if (this._command.startsWith("bbs_")) {
                if (Config.ENABLE_COMMUNITY_BOARD) {
                    if (!CommunityServerThread.getInstance().sendPacket(new RequestShowCommunityBoard(activeChar.getObjectId(), this._command))) {
                        activeChar.sendPacket(new SystemMessage(SystemMessageId.CB_OFFLINE));
                    }
                } else {
                    CommunityBoard.getInstance().handleCommands((L2GameClient)this.getClient(), this._command);
                }
            } else if (this._command.startsWith("_bbsloc")) {
                CommunityBoard.getInstance().handleCommands((L2GameClient)this.getClient(), this._command);
            } else if (this._command.startsWith("_bbs")) {
                if (Config.ENABLE_COMMUNITY_BOARD) {
                    if (!CommunityServerThread.getInstance().sendPacket(new RequestShowCommunityBoard(activeChar.getObjectId(), this._command))) {
                        activeChar.sendPacket(new SystemMessage(SystemMessageId.CB_OFFLINE));
                    }
                } else {
                    CommunityBoard.getInstance().handleCommands((L2GameClient)this.getClient(), this._command);
                }
            } else if (this._command.startsWith("_maillist") || this._command.startsWith("_friendlist")) {
                CommunityBoard.getInstance().handleCommands((L2GameClient)this.getClient(), this._command);
            } else if (this._command.startsWith("_mail")) {
                if (!CommunityServerThread.getInstance().sendPacket(new RequestShowCommunityBoard(activeChar.getObjectId(), "_bbsmail"))) {
                    activeChar.sendPacket(new SystemMessage(SystemMessageId.CB_OFFLINE));
                }
            } else if (this._command.startsWith("_friend")) {
                if (!CommunityServerThread.getInstance().sendPacket(new RequestShowCommunityBoard(activeChar.getObjectId(), "_bbsfriend"))) {
                    activeChar.sendPacket(new SystemMessage(SystemMessageId.CB_OFFLINE));
                }
            } else if (this._command.startsWith("Quest ")) {
                if (!activeChar.validateBypass(this._command)) {
                    return;
                }
                L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
                if (player == null) {
                    return;
                }
                String p = this._command.substring(6).trim();
                int idx = p.indexOf(32);
                if (idx < 0) {
                    player.processQuestEvent(p, "");
                } else {
                    player.processQuestEvent(p.substring(0, idx), p.substring(idx).trim());
                }
            } else if (this._command.startsWith("OlympiadArenaChange")) {
                Olympiad.bypassChangeArena(this._command, activeChar);
            } else if (this._command.startsWith("voice ") && this._command.length() > 7 && this._command.charAt(6) == '.') {
                IVoicedCommandHandler vch;
                String vparams;
                String vc;
                int endOfCommand = this._command.indexOf(" ", 7);
                if (endOfCommand > 0) {
                    vc = this._command.substring(7, endOfCommand).trim();
                    vparams = this._command.substring(endOfCommand).trim();
                } else {
                    vc = this._command.substring(7).trim();
                    vparams = null;
                }
                if (vc.length() > 0 && (vch = VoicedCommandHandler.getInstance().getVoicedCommandHandler(vc)) != null) {
                    vch.useVoicedCommand(vc, activeChar, vparams);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClient() + " sent bad RequestBypassToServer: '" + this._command + "'", e);
        }
    }

    private void comeHere(L2PcInstance activeChar) {
        L2Object obj = activeChar.getTarget();
        if (obj == null) {
            return;
        }
        if (obj instanceof L2Npc) {
            L2Npc temp = (L2Npc)obj;
            temp.setTarget(activeChar);
            temp.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(activeChar.getX(), activeChar.getY(), activeChar.getZ(), 0));
        }
    }

    private void playerHelp(L2PcInstance activeChar, String path) {
        if (path.indexOf("..") != -1) {
            return;
        }
        StringTokenizer st = new StringTokenizer(path);
        String[] cmd = st.nextToken().split("#");
        if (cmd.length > 1) {
            int itemId = 0;
            itemId = Integer.parseInt(cmd[1]);
            String filename = "data/html/help/" + cmd[0];
            NpcHtmlMessage html = new NpcHtmlMessage(1, itemId);
            html.setFile(activeChar.getHtmlPrefix(), filename);
            html.disableValidation();
            activeChar.sendPacket(html);
        } else {
            String filename = "data/html/help/" + path;
            NpcHtmlMessage html = new NpcHtmlMessage(1);
            html.setFile(activeChar.getHtmlPrefix(), filename);
            html.disableValidation();
            activeChar.sendPacket(html);
        }
    }

    @Override
    public String getType() {
        return _C__21_REQUESTBYPASSTOSERVER;
    }
}

