/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.clientpackets.RequestGetItemFromPet;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Logger;

public final class RequestGiveItemToPet
extends L2GameClientPacket {
    private static final String REQUESTCIVEITEMTOPET__C__8B = "[C] 8B RequestGiveItemToPet";
    private static Logger _log = Logger.getLogger(RequestGetItemFromPet.class.getName());
    private int _objectId;
    private long _amount;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._amount = this.readQ();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null || !(player.getPet() instanceof L2PetInstance)) {
            return;
        }
        if (!player.getFloodProtectors().getTransaction().tryPerformAction("giveitemtopet")) {
            player.sendMessage("You give items to pet too fast.");
            return;
        }
        if (player.getActiveEnchantItem() != null) {
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_TRADE && player.getKarma() > 0) {
            return;
        }
        if (player.getPrivateStoreType() != 0) {
            player.sendPacket(new SystemMessage(SystemMessageId.PRIVATE_STORE_UNDER_WAY));
            return;
        }
        L2ItemInstance item = player.getInventory().getItemByObjectId(this._objectId);
        if (item == null) {
            return;
        }
        if (item.isHeroItem()) {
            player.sendMessage("Duo To Hero Weapons Protection u Canot Use Pet's Inventory");
            return;
        }
        if (item.isAugmented()) {
            return;
        }
        if (!(item.isDropable() && item.isDestroyable() && item.isTradeable())) {
            this.sendPacket(new SystemMessage(SystemMessageId.ITEM_NOT_FOR_PETS));
            return;
        }
        L2PetInstance pet = (L2PetInstance)player.getPet();
        if (pet.isDead()) {
            this.sendPacket(new SystemMessage(SystemMessageId.CANNOT_GIVE_ITEMS_TO_DEAD_PET));
            return;
        }
        if (this._amount < 0L) {
            return;
        }
        if (!pet.getInventory().validateCapacity(item)) {
            pet.getOwner().sendPacket(new SystemMessage(SystemMessageId.YOUR_PET_CANNOT_CARRY_ANY_MORE_ITEMS));
            return;
        }
        if (!pet.getInventory().validateWeight(item, this._amount)) {
            pet.getOwner().sendPacket(new SystemMessage(SystemMessageId.UNABLE_TO_PLACE_ITEM_YOUR_PET_IS_TOO_ENCUMBERED));
            return;
        }
        if (player.transferItem("Transfer", this._objectId, this._amount, pet.getInventory(), pet) == null) {
            _log.warning("Invalid item transfer request: " + pet.getName() + "(pet) --> " + player.getName());
        }
    }

    @Override
    public String getType() {
        return REQUESTCIVEITEMTOPET__C__8B;
    }
}

