/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;

public final class RequestPetGetItem
extends L2GameClientPacket {
    private static final String _C__8f_REQUESTPETGETITEM = "[C] 8F RequestPetGetItem";
    private int _objectId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2World world = L2World.getInstance();
        L2ItemInstance item = (L2ItemInstance)world.findObject(this._objectId);
        if (item == null || ((L2GameClient)this.getClient()).getActiveChar() == null) {
            return;
        }
        int castleId = MercTicketManager.getInstance().getTicketCastleId(item.getItemId());
        if (castleId > 0) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (((L2GameClient)this.getClient()).getActiveChar().getPet() instanceof L2SummonInstance) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2PetInstance pet = (L2PetInstance)((L2GameClient)this.getClient()).getActiveChar().getPet();
        if (pet == null || pet.isDead() || pet.isOutOfControl()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (FortSiegeManager.getInstance().isCombat(item.getItemId())) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        pet.getAI().setIntention(CtrlIntention.AI_INTENTION_PICK_UP, item);
    }

    @Override
    public String getType() {
        return _C__8f_REQUESTPETGETITEM;
    }
}

