/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.L2FriendSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class RequestSendFriendMsg
extends L2GameClientPacket {
    private static final String _C__CC_REQUESTSENDMSG = "[C] CC RequestSendMsg";
    private static Logger _logChat = Logger.getLogger("chat");
    private String _message;
    private String _reciever;

    @Override
    protected void readImpl() {
        this._message = this.readS();
        this._reciever = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2PcInstance targetPlayer = L2World.getInstance().getPlayer(this._reciever);
        if (targetPlayer == null) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.TARGET_IS_NOT_FOUND_IN_THE_GAME));
            return;
        }
        if (Config.LOG_CHAT) {
            LogRecord record = new LogRecord(Level.INFO, this._message);
            record.setLoggerName("chat");
            record.setParameters(new Object[]{"PRIV_MSG", "[" + activeChar.getName() + " to " + this._reciever + "]"});
            _logChat.log(record);
        }
        L2FriendSay frm = new L2FriendSay(activeChar.getName(), this._reciever, this._message);
        targetPlayer.sendPacket(frm);
    }

    @Override
    public String getType() {
        return _C__CC_REQUESTSENDMSG;
    }
}

