/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Logger;

public class RequestUnEquipItem
extends L2GameClientPacket {
    private static final String _C__11_REQUESTUNEQUIPITEM = "[C] 11 RequestUnequipItem";
    private static Logger _log = Logger.getLogger(RequestUnEquipItem.class.getName());
    private int _slot;

    @Override
    protected void readImpl() {
        this._slot = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar;
        if (Config.DEBUG) {
            _log.fine("request unequip slot " + this._slot);
        }
        if ((activeChar = ((L2GameClient)this.getClient()).getActiveChar()) == null) {
            return;
        }
        L2ItemInstance item = activeChar.getInventory().getPaperdollItemByL2ItemId(this._slot);
        if (item != null && item.isWear()) {
            return;
        }
        if (this._slot == 16384 && (activeChar.isCursedWeaponEquipped() || activeChar.isCombatFlagEquipped())) {
            return;
        }
        if (activeChar.isStunned() || activeChar.isSleeping() || activeChar.isParalyzed() || activeChar.isAlikeDead()) {
            activeChar.sendMessage("Your status does not allow you to do that.");
            return;
        }
        if (activeChar.isCastingNow() || activeChar.isCastingSimultaneouslyNow()) {
            return;
        }
        L2ItemInstance[] unequiped = activeChar.getInventory().unEquipItemInBodySlotAndRecord(this._slot);
        InventoryUpdate iu = new InventoryUpdate();
        for (L2ItemInstance itm : unequiped) {
            activeChar.checkSSMatch(null, itm);
            iu.addModifiedItem(itm);
        }
        activeChar.sendPacket(iu);
        activeChar.broadcastUserInfo();
        if (unequiped.length > 0) {
            SystemMessage sm = null;
            if (unequiped[0].getEnchantLevel() > 0) {
                sm = new SystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                sm.addNumber(unequiped[0].getEnchantLevel());
                sm.addItemName(unequiped[0]);
            } else {
                sm = new SystemMessage(SystemMessageId.S1_DISARMED);
                sm.addItemName(unequiped[0]);
            }
            activeChar.sendPacket(sm);
            sm = null;
        }
    }

    @Override
    public String getType() {
        return _C__11_REQUESTUNEQUIPITEM;
    }
}

