/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.item.L2Item;
import java.util.ArrayList;

public final class SystemMessage
extends L2GameServerPacket {
    private static final int TYPE_ZONE_NAME = 7;
    private static final int TYPE_ITEM_NUMBER = 6;
    private static final int TYPE_FORTRESS = 5;
    private static final int TYPE_SKILL_NAME = 4;
    private static final int TYPE_ITEM_NAME = 3;
    private static final int TYPE_NPC_NAME = 2;
    private static final int TYPE_NUMBER = 1;
    private static final int TYPE_TEXT = 0;
    private static final String _S__7A_SYSTEMMESSAGE = "[S] 62 SystemMessage";
    private int _messageId;
    private final ArrayList<SysMsgData> _info = new ArrayList();
    private int _skillLvL = 1;

    public SystemMessage(SystemMessageId messageId) {
        this._messageId = messageId.getId();
    }

    public SystemMessage(int messageId) {
        this._messageId = messageId;
    }

    public static SystemMessage sendString(String msg) {
        SystemMessage sm = new SystemMessage(SystemMessageId.S1);
        sm.addString(msg);
        return sm;
    }

    public SystemMessage addString(String text) {
        this._info.add(new SysMsgData(0, text));
        return this;
    }

    public SystemMessage addFortId(int number) {
        this._info.add(new SysMsgData(5, number));
        return this;
    }

    public SystemMessage addNumber(int number) {
        this._info.add(new SysMsgData(1, number));
        return this;
    }

    public SystemMessage addItemNumber(long number) {
        this._info.add(new SysMsgData(6, number));
        return this;
    }

    public SystemMessage addCharName(L2Character cha) {
        if (cha instanceof L2Npc) {
            if (((L2Npc)cha).getTemplate().serverSideName) {
                return this.addString(((L2Npc)cha).getTemplate().name);
            }
            return this.addNpcName((L2Npc)cha);
        }
        if (cha instanceof L2PcInstance) {
            return this.addPcName((L2PcInstance)cha);
        }
        if (cha instanceof L2Summon) {
            if (((L2Summon)cha).getTemplate().serverSideName) {
                return this.addString(((L2Summon)cha).getTemplate().name);
            }
            return this.addNpcName((L2Summon)cha);
        }
        return this.addString(cha.getName());
    }

    public SystemMessage addPcName(L2PcInstance pc) {
        return this.addString(pc.getAppearance().getVisibleName());
    }

    public SystemMessage addNpcName(L2Npc npc) {
        return this.addNpcName(npc.getTemplate());
    }

    public SystemMessage addNpcName(L2Summon npc) {
        return this.addNpcName(npc.getNpcId());
    }

    public SystemMessage addNpcName(L2NpcTemplate tpl) {
        if (tpl.isCustom()) {
            return this.addString(tpl.name);
        }
        return this.addNpcName(tpl.npcId);
    }

    public SystemMessage addNpcName(int id) {
        this._info.add(new SysMsgData(2, 1000000 + id));
        return this;
    }

    public SystemMessage addItemName(L2ItemInstance item) {
        return this.addItemName(item.getItem().getItemId());
    }

    public SystemMessage addItemName(L2Item item) {
        return this.addItemName(item.getItemId());
    }

    public SystemMessage addItemName(int id) {
        this._info.add(new SysMsgData(3, id));
        return this;
    }

    public SystemMessage addZoneName(int x, int y, int z) {
        int[] coord = new int[]{x, y, z};
        this._info.add(new SysMsgData(7, coord));
        return this;
    }

    public SystemMessage addSkillName(L2Effect effect) {
        return this.addSkillName(effect.getSkill());
    }

    public SystemMessage addSkillName(L2Skill skill) {
        if (skill.getId() != skill.getDisplayId()) {
            return this.addString(skill.getName());
        }
        return this.addSkillName(skill.getId(), skill.getLevel());
    }

    public SystemMessage addSkillName(int id) {
        return this.addSkillName(id, 1);
    }

    public SystemMessage addSkillName(int id, int lvl) {
        this._info.add(new SysMsgData(4, id));
        this._skillLvL = lvl;
        return this;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(98);
        this.writeD(this._messageId);
        this.writeD(this._info.size());
        for (SysMsgData data : this._info) {
            int t = data.type;
            this.writeD(t);
            switch (t) {
                case 0: {
                    this.writeS((String)data.value);
                    break;
                }
                case 6: {
                    this.writeQ((Long)data.value);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    this.writeD((Integer)data.value);
                    break;
                }
                case 4: {
                    this.writeD((Integer)data.value);
                    this.writeD(this._skillLvL);
                    break;
                }
                case 7: {
                    int[] coords = (int[])data.value;
                    this.writeD(coords[0]);
                    this.writeD(coords[1]);
                    this.writeD(coords[2]);
                }
            }
        }
    }

    @Override
    public String getType() {
        return _S__7A_SYSTEMMESSAGE;
    }

    public int getMessageID() {
        return this._messageId;
    }

    protected class SysMsgData {
        protected final int type;
        protected final Object value;

        protected SysMsgData(int t, Object val) {
            this.type = t;
            this.value = val;
        }
    }
}

