/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.pathfinding;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.pathfinding.AbstractNodeLoc;
import com.l2jserver.gameserver.pathfinding.Node;
import com.l2jserver.gameserver.pathfinding.cellnodes.CellPathFinding;
import com.l2jserver.gameserver.pathfinding.geonodes.GeoPathFinding;
import com.l2jserver.gameserver.pathfinding.utils.BinaryNodeHeap;
import com.l2jserver.gameserver.pathfinding.utils.CellNodeMap;
import com.l2jserver.gameserver.pathfinding.utils.FastNodeList;
import java.util.LinkedList;
import java.util.List;
import javolution.util.FastList;

public abstract class PathFinding {
    public static PathFinding getInstance() {
        if (!Config.GEODATA_CELLFINDING) {
            return GeoPathFinding.getInstance();
        }
        return CellPathFinding.getInstance();
    }

    public abstract boolean pathNodesExist(short var1);

    public abstract List<AbstractNodeLoc> findPath(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract Node[] readNeighbors(Node var1, int var2);

    public List<AbstractNodeLoc> search(Node start, Node end) {
        LinkedList<Node> visited = new LinkedList<Node>();
        LinkedList<Node> to_visit = new LinkedList<Node>();
        to_visit.add(start);
        int i = 0;
        while (i < 800) {
            Node node;
            try {
                node = (Node)to_visit.removeFirst();
            }
            catch (Exception e) {
                return null;
            }
            if (node.equals(end)) {
                return this.constructPath(node);
            }
            ++i;
            visited.add(node);
            node.attachNeighbors();
            Node[] neighbors = node.getNeighbors();
            if (neighbors == null) continue;
            for (Node n : neighbors) {
                if (visited.contains(n) || to_visit.contains(n)) continue;
                n.setParent(node);
                to_visit.add(n);
            }
        }
        return null;
    }

    public List<AbstractNodeLoc> searchByClosest(Node start, Node end) {
        CellNodeMap known = new CellNodeMap();
        LinkedList<Node> to_visit = new LinkedList<Node>();
        to_visit.add(start);
        known.add(start);
        int targetx = end.getLoc().getNodeX();
        int targety = end.getLoc().getNodeY();
        short targetz = end.getLoc().getZ();
        int i = 0;
        while (i < 3500) {
            Node node;
            try {
                node = (Node)to_visit.removeFirst();
            }
            catch (Exception e) {
                return null;
            }
            ++i;
            node.attachNeighbors();
            if (node.equals(end)) {
                return this.constructPath(node);
            }
            Node[] neighbors = node.getNeighbors();
            if (neighbors == null) continue;
            for (Node n : neighbors) {
                if (known.contains(n)) continue;
                boolean added = false;
                n.setParent(node);
                int dx = targetx - n.getLoc().getNodeX();
                int dy = targety - n.getLoc().getNodeY();
                int dz = targetz - n.getLoc().getZ();
                n.setCost(dx * dx + dy * dy + dz / 2 * dz);
                for (int index = 0; index < to_visit.size(); ++index) {
                    if (((Node)to_visit.get(index)).getCost() <= n.getCost()) continue;
                    to_visit.add(index, n);
                    added = true;
                    break;
                }
                if (!added) {
                    to_visit.addLast(n);
                }
                known.add(n);
            }
        }
        return null;
    }

    public List<AbstractNodeLoc> searchByClosest2(Node start, Node end) {
        FastNodeList visited = new FastNodeList(550);
        LinkedList<Node> to_visit = new LinkedList<Node>();
        to_visit.add(start);
        int targetx = end.getLoc().getNodeX();
        int targety = end.getLoc().getNodeY();
        int i = 0;
        while (i < 550) {
            Node node;
            try {
                node = (Node)to_visit.removeFirst();
            }
            catch (Exception e) {
                return null;
            }
            if (node.equals(end)) {
                return this.constructPath2(node);
            }
            ++i;
            visited.add(node);
            node.attachNeighbors();
            Node[] neighbors = node.getNeighbors();
            if (neighbors == null) continue;
            for (Node n : neighbors) {
                if (visited.containsRev(n) || to_visit.contains(n)) continue;
                boolean added = false;
                n.setParent(node);
                int dx = targetx - n.getLoc().getNodeX();
                int dy = targety - n.getLoc().getNodeY();
                n.setCost(dx * dx + dy * dy);
                for (int index = 0; index < to_visit.size(); ++index) {
                    if (((Node)to_visit.get(index)).getCost() <= n.getCost()) continue;
                    to_visit.add(index, n);
                    added = true;
                    break;
                }
                if (added) continue;
                to_visit.addLast(n);
            }
        }
        return null;
    }

    public List<AbstractNodeLoc> searchAStar(Node start, Node end) {
        int start_x = start.getLoc().getX();
        int start_y = start.getLoc().getY();
        int end_x = end.getLoc().getX();
        int end_y = end.getLoc().getY();
        FastNodeList visited = new FastNodeList(800);
        BinaryNodeHeap to_visit = new BinaryNodeHeap(800);
        to_visit.add(start);
        int i = 0;
        while (i < 800) {
            Node node;
            try {
                node = to_visit.removeFirst();
            }
            catch (Exception e) {
                return null;
            }
            if (node.equals(end)) {
                return this.constructPath(node);
            }
            visited.add(node);
            node.attachNeighbors();
            for (Node n : node.getNeighbors()) {
                if (visited.contains(n) || to_visit.contains(n)) continue;
                ++i;
                n.setParent(node);
                n.setCost(Math.abs(start_x - n.getLoc().getNodeX()) + Math.abs(start_y - n.getLoc().getNodeY()) + Math.abs(end_x - n.getLoc().getNodeX()) + Math.abs(end_y - n.getLoc().getNodeY()));
                to_visit.add(n);
            }
        }
        return null;
    }

    public List<AbstractNodeLoc> constructPath(Node node) {
        LinkedList<AbstractNodeLoc> path = new LinkedList<AbstractNodeLoc>();
        int previousdirectionx = -1000;
        int previousdirectiony = -1000;
        while (node.getParent() != null) {
            int directiony;
            int directionx;
            if (node.getParent().getParent() != null && Math.abs(node.getLoc().getNodeX() - node.getParent().getParent().getLoc().getNodeX()) == 1 && Math.abs(node.getLoc().getNodeY() - node.getParent().getParent().getLoc().getNodeY()) == 1) {
                directionx = node.getLoc().getNodeX() - node.getParent().getParent().getLoc().getNodeX();
                directiony = node.getLoc().getNodeY() - node.getParent().getParent().getLoc().getNodeY();
            } else {
                directionx = node.getLoc().getNodeX() - node.getParent().getLoc().getNodeX();
                directiony = node.getLoc().getNodeY() - node.getParent().getLoc().getNodeY();
            }
            if (directionx != previousdirectionx || directiony != previousdirectiony) {
                previousdirectionx = directionx;
                previousdirectiony = directiony;
                path.addFirst(node.getLoc());
            }
            node = node.getParent();
        }
        if (path.size() > 4) {
            int index;
            FastList valueList = new FastList();
            for (index = 0; index < path.size() - 3; index += 3) {
                if (!GeoData.getInstance().canMoveFromToTarget(path.get(index).getX(), path.get(index).getY(), path.get(index).getZ(), path.get(index + 3).getX(), path.get(index + 3).getY(), path.get(index + 3).getZ(), 0)) continue;
                valueList.add(index + 1);
                valueList.add(index + 2);
            }
            for (index = valueList.size() - 1; index >= 0; --index) {
                path.remove((Integer)valueList.get(index));
            }
        }
        return path;
    }

    public List<AbstractNodeLoc> constructPath2(Node node) {
        LinkedList<AbstractNodeLoc> path = new LinkedList<AbstractNodeLoc>();
        int previousdirectionx = -1000;
        int previousdirectiony = -1000;
        while (node.getParent() != null) {
            int directionx = node.getLoc().getNodeX() - node.getParent().getLoc().getNodeX();
            int directiony = node.getLoc().getNodeY() - node.getParent().getLoc().getNodeY();
            if (directionx != previousdirectionx || directiony != previousdirectiony) {
                previousdirectionx = directionx;
                previousdirectiony = directiony;
                path.addFirst(node.getLoc());
            }
            node = node.getParent();
        }
        return path;
    }

    public short getNodePos(int geo_pos) {
        return (short)(geo_pos >> 3);
    }

    public short getNodeBlock(int node_pos) {
        return (short)(node_pos % 256);
    }

    public byte getRegionX(int node_pos) {
        return (byte)((node_pos >> 8) + Config.WORLD_X_MIN);
    }

    public byte getRegionY(int node_pos) {
        return (byte)((node_pos >> 8) + Config.WORLD_Y_MIN);
    }

    public short getRegionOffset(byte rx, byte ry) {
        return (short)((rx << 5) + ry);
    }

    public int calculateWorldX(short node_x) {
        return L2World.MAP_MIN_X + node_x * 128 + 48;
    }

    public int calculateWorldY(short node_y) {
        return L2World.MAP_MIN_Y + node_y * 128 + 48;
    }
}

