DROP TABLE IF EXISTS `etcitem`;
CREATE TABLE IF NOT EXISTS `etcitem` (
  `item_id` decimal(11,0) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `additionalname` varchar(100) NOT NULL default '',
  `crystallizable` varchar(5) NOT NULL default 'false',
  `item_type` varchar(14) NOT NULL default 'none',
  `weight` decimal(4,0) NOT NULL default '0',
  `consume_type` varchar(9) NOT NULL default 'normal',
  `material` varchar(11) NOT NULL default 'wood',
  `crystal_type` varchar(4) NOT NULL default 'none',
  `duration` int(3) NOT NULL default '-1', -- duration in minutes for shadow items
  `time` int(4) NOT NULL default '-1',     -- duration in minutes for time limited items
  `price` decimal(11,0) NOT NULL default '0',
  `crystal_count` int(4) NOT NULL default '0',
  `sellable` varchar(5) NOT NULL default 'false',
  `dropable` varchar(5) NOT NULL default 'false',
  `destroyable` varchar(5) NOT NULL default 'false',
  `tradeable` varchar(5) NOT NULL default 'false',
  `depositable` varchar(5) NOT NULL default 'false',
  `handler` varchar(70) NOT NULL DEFAULT 'none',
  `skill` varchar(70) NOT NULL DEFAULT '0-0;',
  PRIMARY KEY (`item_id`)
) DEFAULT CHARSET=utf8;

INSERT INTO `etcitem` VALUES
(17,'Wooden Arrow','','false','arrow',6,'stackable','wood','none',-1,-1,1,0,'true','true','true','true','true','none','0-0;'),
(53,'(Not In Use)','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(54,'(Not In Use)','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(55,'Shiny Agathion 7 Day Pack (Event)','','false','none',100,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','true','ExtractableItems','0-0;'),
(56,'Sobbing Agathion 7 Day Pack (Event)','','false','none',100,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','true','ExtractableItems','0-0;'),
(57,'Adena','','false','none',0,'asset','gold','none',-1,-1,1,0,'false','true','true','true','true','none','0-0;'),
(65,'Red Potion','','false','potion',80,'stackable','liquid','none',-1,-1,40,0,'true','true','true','true','true','ItemSkills','2001-1;'),
(136,'(Not In Use)','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(137,'(Not In Use)','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(138,'(Not In Use)','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(139,'Sudden Agathion 7 Day Pack','','false','none',100,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','true','ExtractableItems','0-0;'),
(140,'Shiny Agathion 7 Day Pack','','false','none',100,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','true','ExtractableItems','0-0;'),
(141,'Sobbing Agathion 7 Day Pack','','false','none',100,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','true','ExtractableItems','0-0;'),
(163,'(Not In Use)','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(170,'Sudden Agathion 7 Day Pack (Event)','','false','none',100,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','true','ExtractableItems','0-0;'),
(686,'Chair','','false','none',100,'normal','wood','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(687,'Darin\'s Letter','','false','quest',0,'normal','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(688,'Roxxy\'s Kerchief','','false','quest',0,'normal','cloth','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(689,'Poetry Book','','false','quest',0,'normal','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(690,'Lyrics Book','','false','quest',0,'normal','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(691,'Romance Novel','','false','quest',0,'normal','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(692,'Arujien\'s Letter','','false','quest',0,'normal','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(693,'Greenis\'s Letter','','false','quest',0,'normal','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(694,'Ingredient List','','false','quest',0,'normal','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(695,'Omen Beast\'s Blood','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(696,'Mana Seeker\'s Husk','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(697,'Gargoyle\'s Horn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(698,'Gilbert\'s List','','false','quest',0,'normal','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(699,'Orc\'s Nose','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(700,'Hobgoblin Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(701,'Fungus Juice','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(702,'Wolf Pelt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(703,'Poison Sac','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(704,'Fever Medicine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(705,'Orc\'s Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(706,'Basilisk\'s Claw','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(707,'Spore Sac','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(708,'Sylph Headband','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(709,'Leather Shirt','','false','none',400,'normal','leather','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(710,'Hard Leather Shirt','','false','none',400,'normal','leather','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(711,'Piece Bone Breastplate','','false','none',800,'normal','bone','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(712,'Half Plate Armor','','false','none',1200,'normal','steel','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(713,'Leather Pants','','false','none',250,'normal','leather','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(714,'Hard Leather Pants','','false','none',300,'normal','leather','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(715,'Piece Bone Gaiters','','false','none',500,'normal','bone','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(716,'Plate Gaiters','','false','none',800,'normal','steel','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(717,'Leather Gloves','','false','none',100,'normal','leather','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(718,'Hard Leather Gloves','','false','none',150,'normal','leather','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(719,'Crafted Leather Gloves','','false','none',150,'normal','leather','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(720,'Reinforced Gloves','','false','none',200,'normal','steel','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(721,'Leather Boots','','false','none',150,'normal','leather','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(722,'Hard Leather Boots','','false','none',150,'normal','leather','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(723,'Crafted Leather Boots','','false','none',200,'normal','leather','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(724,'Reinforced Boots','','false','none',250,'normal','steel','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(725,'Healing Drug','','false','potion',180,'stackable','liquid','none',-1,-1,50,0,'true','true','true','true','true','ItemSkills','2002-1;'),
(726,'Mana Drug','','false','potion',180,'stackable','liquid','none',-1,-1,80,0,'true','true','true','true','true','ItemSkills','10000-1;'),
(727,'Healing Potion','','false','potion',180,'stackable','liquid','none',-1,-1,80,0,'true','true','true','true','true','ItemSkills','2032-1;'),
(728,'Mana Potion','','false','potion',180,'stackable','liquid','none',-1,-1,2000,0,'true','true','true','true','true','ItemSkills','10001-1;'),
(729,'Scroll: Enchant Weapon (A)','','false','scroll',120,'stackable','paper','none',-1,-1,1800000,0,'true','true','true','true','true','EnchantScrolls','2006-1;'),
(730,'Scroll: Enchant Armor (A)','','false','scroll',120,'stackable','paper','none',-1,-1,240000,0,'true','true','true','true','true','EnchantScrolls','2007-1;'),
(731,'Crystal Scroll: Enchant Weapon (A)','','false','scroll',120,'stackable','paper','none',-1,-1,240000,0,'true','true','true','true','true','EnchantScrolls','0-0;'),
(732,'Crystal Scroll: Enchant Armor (A)','','false','scroll',120,'stackable','paper','none',-1,-1,240000,0,'true','true','true','true','true','EnchantScrolls','0-0;'),
(733,'Endeavor Potion','','false','potion',180,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','ItemSkills','2010-1;'),
(734,'Haste Potion','','false','potion',20,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','ItemSkills','2011-1;'),
(735,'Potion of Alacrity','','false','potion',20,'stackable','liquid','none',-1,-1,2400,0,'true','true','true','true','true','ItemSkills','2012-1;'),
(736,'Scroll of Escape','','false','scroll',120,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','ItemSkills','2013-1;'),
(737,'Scroll of Resurrection','','false','scroll',120,'stackable','paper','none',-1,-1,2000,0,'true','true','true','true','true','ScrollOfResurrection','2014-1;'),
(739,'Broken Sword Handle','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(740,'Broken Blade Bottom','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(741,'Broken Blade Top','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(742,'Altran\'s Note','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(745,'Cobendell Medicine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(746,'Alberius\'s List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(750,'Kinship Crystal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(751,'Cracked Kinship Crystal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(752,'Orc Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(753,'Silverleaf Brooch','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(755,'Colleen\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(756,'Mandragora Root','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(757,'Mandragora Essence','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(758,'Colleen\'s Receipt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(759,'Etched Rune Sword','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(760,'Macabre Sword','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(761,'Thanatos Sword','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(762,'Gray Bone Chip','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(763,'Esther\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(764,'Arbon\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(765,'Conspirator List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(766,'Sabrin\'s Signet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(767,'Sealed Scroll','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(768,'Oyen\'s Key','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(769,'Ricardo\'s Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(770,'Shield of Honor','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(771,'Saythus\'s Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(772,'Trayer\'s Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(773,'Falimar\'s Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(774,'Fallen Sword of Honor','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(775,'Sword of Honor','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(776,'Nameless Sword','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(777,'Sword of Black Ice','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(778,'Arodin\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(779,'Sabrin\'s Ring','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(780,'Arbon\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(781,'Madclaw\'s Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(782,'Alex\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(783,'Alex\'s Receipt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(784,'Glass Dagger','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(785,'Broken Glass Dagger','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(786,'Shadowguard Dagger','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(787,'Coroli\'s Key','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(788,'Midnight Onyx Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(789,'Song: Moonlight Whisper','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(790,'Bloodsteel Kris','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(791,'Karlun\'s Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(792,'Karlun\'s Rib Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(793,'Karlun\'s Thigh Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(794,'Saint\'s Ash Urn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(795,'Mace of Athebaldt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(796,'Roien\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(797,'Manuel\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(798,'Varan\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(799,'Groot\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(800,'Tome of Nassen','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(801,'Cursed Tome of Nassen','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(802,'Bloodthirsty Dagger','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(803,'Bloody Dagger','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(804,'Staff of Shane','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(805,'Pinter\'s Bill','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(806,'Drake\'s Claw','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(807,'Flawless Drake\'s Claw','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(808,'Pushkin\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(809,'Bone Fragment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(810,'Altran\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(811,'Oil Paper','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(812,'Adamantium Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(813,'Heart Stone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(814,'Pushkin\'s Receipt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(815,'Leather Strap','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(816,'Widow Maker','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(817,'Mithril Bottle','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(818,'Grace Unicorn\'s Horn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(819,'Drake\'s Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(820,'Zahak Fluids','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(821,'Bone Knife','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(822,'Drake Knife','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(823,'Dull Dagger','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(824,'Siriel\'s Note','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(825,'Raien\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(826,'Silver Spores','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(827,'Star Dust','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(828,'Song of Awakening','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(829,'Spirit Dagger','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(830,'Medallion of Kwyllinas','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(831,'Echo Crystal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(832,'Green Echo Crystal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(833,'Red Echo Crystal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(834,'Aquamarine Echo Crystal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(835,'Blue Echo Crystal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(836,'Book of Kwyllinas','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(837,'Fairy Dust','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(838,'Vellior\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(839,'Icarus\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(840,'Drevanul Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(841,'Icarus\'s Order Form','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(842,'Basilisk Ink','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(843,'Book of Aklantoth','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(844,'Book of Aklantoth P1 ~ P10','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(937,'Directions to Ruins','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(938,'Deck','','false','none',0,'normal','silver','none',-1,-1,0,0,'false','true','true','false','true','none','0-0;'),
(939,'Gara\'s Quest Item #11','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(940,'Gara\'s Quest Item #12','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(941,'Gara\'s Proof of Bravery','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(942,'Gara\'s Proof of Justice','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(943,'Gara\'s Proof of Despair','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(944,'Deathknight Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(947,'Scroll: Enchant Weapon (B)','','false','scroll',120,'stackable','paper','none',-1,-1,500000,0,'true','true','true','true','true','EnchantScrolls','2015-1;'),
(948,'Scroll: Enchant Armor (B)','','false','scroll',120,'stackable','paper','none',-1,-1,80000,0,'true','true','true','true','true','EnchantScrolls','2016-1;'),
(949,'Crystal Scroll: Enchant Weapon (B)','','false','scroll',120,'stackable','paper','none',-1,-1,80000,0,'true','true','true','true','true','EnchantScrolls','0-0;'),
(950,'Crystal Scroll: Enchant Armor (B)','','false','scroll',120,'stackable','paper','none',-1,-1,80000,0,'true','true','true','true','true','EnchantScrolls','0-0;'),
(951,'Scroll: Enchant Weapon (C)','','false','scroll',120,'stackable','paper','none',-1,-1,110000,0,'true','true','true','true','true','EnchantScrolls','2017-1;'),
(952,'Scroll: Enchant Armor (C)','','false','scroll',120,'stackable','paper','none',-1,-1,15000,0,'true','true','true','true','true','EnchantScrolls','2018-1;'),
(953,'Crystal Scroll: Enchant Weapon (C)','','false','scroll',120,'stackable','paper','none',-1,-1,15000,0,'true','true','true','true','true','EnchantScrolls','0-0;'),
(954,'Crystal Scroll: Enchant Armor (C)','','false','scroll',120,'stackable','paper','none',-1,-1,15000,0,'true','true','true','true','true','EnchantScrolls','0-0;'),
(955,'Scroll: Enchant Weapon (D)','','false','scroll',120,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','EnchantScrolls','2019-1;'),
(956,'Scroll: Enchant Armor (D)','','false','scroll',120,'stackable','paper','none',-1,-1,6000,0,'true','true','true','true','true','EnchantScrolls','2020-1;'),
(957,'Crystal Scroll: Enchant Weapon (D)','','false','scroll',120,'stackable','paper','none',-1,-1,6000,0,'true','true','true','true','true','EnchantScrolls','0-0;'),
(958,'Crystal Scroll: Enchant Armor (D)','','false','scroll',120,'stackable','paper','none',-1,-1,6000,0,'true','true','true','true','true','EnchantScrolls','0-0;'),
(959,'Scroll: Enchant Weapon (S)','','false','scroll',120,'stackable','paper','none',-1,-1,5000000,0,'true','true','true','true','true','EnchantScrolls','2021-1;'),
(960,'Scroll: Enchant Armor (S)','','false','scroll',120,'stackable','paper','none',-1,-1,500000,0,'true','true','true','true','true','EnchantScrolls','2022-1;'),
(961,'Crystal Scroll: Enchant Weapon (S)','','false','scroll',120,'stackable','paper','none',-1,-1,500000,0,'true','true','true','true','true','EnchantScrolls','0-0;'),
(962,'Crystal Scroll: Enchant Armor (S)','','false','scroll',120,'stackable','paper','none',-1,-1,500000,0,'true','true','true','true','true','EnchantScrolls','0-0;'),
(963,'Orcish Arrowhead','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(964,'Alberius\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(965,'Evergreen Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(966,'Dryad\'s Tears','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(967,'Cobendell Medicine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(968,'Karrod\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(969,'Cecktinon\'s First Voucher','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(970,'Cecktinon\'s Second Voucher','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(971,'Soul Catcher','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(972,'Preserving Oil','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(973,'Zombie Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(974,'Steelbender Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(976,'1st Mark of Sentinel','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(977,'2nd Mark of Sentinel','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(978,'Skullcrusher Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(979,'Bloodspear Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(980,'0','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(982,'Esrandell\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(983,'Kendell\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(984,'1st Onyx Talisman','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(985,'2nd Onyx Talisman','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(986,'Ancient Scroll','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(987,'Ancient Clay Tablet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(988,'Kartia\'s Translation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1001,'Book of Aklantoth - Part 4','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1002,'Book of Aklantoth - Part 5','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1003,'Book of Aklantoth - Part 6','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1004,'Book of Aklantoth - Part 7','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1005,'Book of Aklantoth - Part 8','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1006,'Book of Aklantoth - Part 9','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1007,'Book of Aklantoth - Part 10','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1008,'Harrys\'s 1st Receipt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1009,'Harrys\'s 2nd Receipt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1010,'Golem Shard','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1011,'Tool Box','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1012,'Delivery List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1013,'Heavy Wood Box','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1014,'Cloth Bundle','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1015,'Clay Pot','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1016,'Jackson\'s Receipt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1017,'Silvia\'s Receipt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1018,'Rant\'s Receipt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1019,'official Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1020,'Flame Shard','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1021,'Ice Shard','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1022,'Lilith\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1023,'Theon\'s Diary','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1024,'Adamantite Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1025,'Clay Tablet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1026,'Silvery Spidersilk','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1027,'Unoren\'s Receipt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1028,'Creamees\'s Ticket','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1029,'Nightshade Leaf','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1030,'Cracked Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1031,'Perfect Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1032,'Fox Fur','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1033,'Fox Fur Yarn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1034,'Maiden Doll','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1035,'Plague Dust','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1036,'Andellia\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1037,'Fruit of the Mother Tree','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1038,'Rumiel\'s 1st Poem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1039,'Rumiel\'s 2nd Poem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1040,'Rumiel\'s 3rd Poem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1041,'Rumiel\'s 4th Poem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1042,'Wererat\'s Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1043,'Varool Foulclaw\'s Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1044,'Kirunak Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1045,'Zombie\'s Skin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1046,'Nightmare Crystal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1047,'Spellbook: Light','','false','spellbook',120,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1048,'Spellbook: Might','','false','spellbook',120,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1049,'Spellbook: Ice Bolt','','false','spellbook',120,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1050,'Spellbook: Battle Heal','','false','spellbook',120,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1051,'Spellbook: Vampiric Touch','','false','spellbook',120,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1052,'Spellbook: Flame Strike','','false','spellbook',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1053,'Spellbook: Cure Poison','','false','spellbook',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1054,'Spellbook: Group Heal','','false','spellbook',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1055,'Spellbook: Curse: Poison','','false','spellbook',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1056,'Spellbook: Curse: Weakness','','false','spellbook',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1057,'Spellbook: Summon Meal','','false','spellbook',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1058,'Spellbook: Shield','','false','spellbook',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1059,'Spellbook: Know Enemy','','false','spellbook',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1060,'Lesser Healing Potion','','false','potion',5,'stackable','liquid','none',-1,-1,90,0,'true','true','true','true','true','ItemSkills','2031-1;'),
(1061,'Healing Potion','','false','potion',5,'stackable','liquid','none',-1,-1,330,0,'true','true','true','true','true','ItemSkills','2032-1;'),
(1062,'Haste Potion','','false','potion',180,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(1063,'Tutorial Parchment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1064,'Tutorial Parchment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1065,'Tutorial Parchment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1066,'Tutorial Parchment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1067,'Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1068,'Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1069,'Leaf of the Mother Tree','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1070,'Blood of Mitraell','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1071,'Hyacinth Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1072,'Hyacinth Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1073,'Beginner\'s Potion','','false','potion',5,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2031-1;'),
(1074,'Boat Ticket: Talking Island to Gludin','','false','none',20,'stackable','paper','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(1075,'Boat Ticket: Gludin to Talking Island','','false','none',20,'stackable','paper','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(1076,'Carlon\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1077,'Venom Sac','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1078,'Wind Shard','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1079,'Darin\'s Receipt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1080,'Baulro\'s Potion','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1081,'Omen Beast\'s Eye','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1082,'Taint Stone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1083,'Succubus Blood','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1084,'Gludio Lord\'s Mark','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1085,'Orc\'s Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1086,'Werewolf\'s Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1087,'Giant Spider Leg','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1088,'Undrias\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1089,'Ceremonial Dagger','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1090,'Dreviant Wine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1091,'Garmiel\'s Scripture','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1092,'Arujien\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1093,'Arujien\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1094,'Arujien\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1095,'Spellbook: Attack Aura','','false','spellbook',120,'stackable','paper','none',-1,-1,75,0,'true','true','true','true','true','none','0-0;'),
(1096,'Spellbook: Elemental Heal','','false','spellbook',120,'stackable','paper','none',-1,-1,550,0,'true','true','true','true','true','none','0-0;'),
(1097,'Spellbook: Drain Health','','false','spellbook',120,'stackable','paper','none',-1,-1,550,0,'true','true','true','true','true','none','0-0;'),
(1098,'Spellbook: Wind Walk','','false','spellbook',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1099,'Spellbook: Wind Shackle','','false','spellbook',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1106,'Norman\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1107,'Bone Fragment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1108,'Arbon\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1109,'Roien\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1110,'Bone Fragment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1111,'Adamantite Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1112,'Leaf of the Mother Tree','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1113,'Blood of Mitraell','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1114,'Orc Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1115,'Orc\'s Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1116,'Orc Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1117,'Orc\'s Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1118,'Spore Sac','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1130,'Cobendell\'s Medicine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1131,'Cobendell\'s Medicine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1132,'Cobendell\'s Medicine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1133,'Cobendell\'s Medicine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1134,'Cobendell\'s Medicine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1135,'Spiritbound Wand','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1136,'Spiritbound Wand','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1137,'Spiritbound Wand','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1138,'Auron\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1139,'Warrior Guild Mark','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1140,'Rusted Bronze Sword','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1141,'Rusted Bronze Sword','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(1143,'Simplon\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1144,'Venomous Spider Leg','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1145,'Medallion of Warrior','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1150,'Spellbook: Wind Strike','','false','spellbook',120,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','none','0-0;'),
(1151,'Spellbook: Self Heal','','false','spellbook',120,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','none','0-0;'),
(1152,'Spellbook: Heal','','false','spellbook',120,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1153,'Jenna\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1154,'Sentry Blade','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1155,'Sentry Blade','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1156,'Sentry Blade','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1157,'Old Bronze Sword','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1158,'Bone Fragment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1159,'Elf Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1160,'Dark Bezoar','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1161,'Sword of Ritual','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1162,'Coin of Lords','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1163,'Coin of Lords','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1164,'Coin of Lords','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1165,'Coin of Lords','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1166,'Coin of Lords','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1167,'Coin of Lords','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1168,'Gludio Guard\'s 1st Badge','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1169,'Bugbear Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1170,'Einhasad\'s 1st Temple Badge','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1171,'Einhasad\'s Crucifix','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1172,'Gludio Guard\'s 2nd Badge','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1173,'Venomous Spider Leg','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1174,'Einhasad\'s 2nd Temple Badge','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1175,'Lizardman\'s Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1176,'Gludio Guard\'s 3rd Badge','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1177,'Giant Spider\'s Husk','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1178,'Einhasad\'s 3rd Temple Badge','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1179,'Skull of Silent Horror','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1180,'Bezique\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1183,'Spartoi\'s Bones','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1184,'Horseshoe of Light','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1185,'Most Wanted List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1186,'Stolen Jewelry','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1187,'Stolen Tomes','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1188,'Stolen Ring','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1189,'Stolen Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1190,'Bezique\'s Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1191,'1st Letter of Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1192,'2nd Letter of Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1193,'Lionel\'s Book','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1194,'Book of Vivyan','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1195,'Book of Simplon','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1196,'Book of Praga','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1197,'Certificate of Gallint','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1198,'Pendant of Mother','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1199,'Necklace of Mother','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1200,'Lionel\'s Covenant','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1201,'Mark of Faith','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1202,'Sorius\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1203,'Kluto Box','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1204,'Elven Knight Brooch','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1205,'Topaz Piece','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1206,'Emerald Piece','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1207,'Reisa\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1208,'Prias\'s 1st Torn Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1209,'Prias\'s 2nd Torn Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1210,'Prias\'s 3rd Torn Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1211,'Prias\'s 4th Torn Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1212,'Moretti\'s Herb','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1214,'Moretti\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1215,'Prias\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1216,'Honorary Guard','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1217,'Reisa\'s Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1218,'Rosella\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1219,'Red Down','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1220,'Magical Powers Ruby','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1221,'Pure Aquamarine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1222,'Appetizing Apple','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1223,'Gold Leaves','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1224,'Immortal Love','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1225,'Amethyst','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1226,'Nobility Amethyst','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1227,'Rosella\'s Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1228,'Peridot','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1229,'Fertility Peridot','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1230,'Eternity Diamond','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1231,'Crystal Medallion','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1232,'Swindler\'s Money','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1233,'Allana\'s Diary','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1234,'Lizard Captain Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1235,'Leaf of Oracle','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1236,'Half of Diary','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1237,'Palus Talisman','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1238,'Lycanthrope Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1239,'Virgil\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1240,'Morte Talisman','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1241,'Predator\'s Carapace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1242,'Arachnid Tracker Silk','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1243,'Coffin of Eternal Rest','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1244,'Gaze of Abyss','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1245,'Shilen\'s Call','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1246,'Arkenia\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1247,'Leikan\'s Note','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1248,'Moonstone Beast\'s Molar','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1249,'Leikan\'s Knife','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1250,'Shilen\'s Tears','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1251,'Arkenia\'s Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1252,'Iron Heart','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1253,'Seed of Anger','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1254,'Seed of Despair','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1255,'Seed of Horror','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1256,'Seed of Lunacy','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1257,'Family\'s Remains','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1258,'Varika\'s Liquor','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1259,'Knee Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1260,'Heart of Lunacy','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1261,'Dark Jewel','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1262,'Sidra\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1263,'Blank Sheet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1264,'Bloody Rune','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1265,'Garmiel Book','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1266,'Prayer of Adonius','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1267,'Penitent\'s Mark','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1268,'Ashen Bones','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1269,'Andariel Book','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1270,'Orb of Abyss','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1271,'Mark of Esquire','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1272,'Charm of Grain','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1273,'Sap of the Mother Tree','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1274,'Lucky Potpourri','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1275,'Tamil\'s Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1276,'Kluto\'s Memo','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1277,'Lucky Key','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1278,'Candle','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1279,'Hub Scent','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1280,'Map of Luster','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1281,'Key of Flame','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1282,'Flame Earring','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1283,'Broken Bronze Mirror','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1284,'Wind Feather','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1285,'Wind Bangle','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1286,'Rama\'s Diary','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1287,'Sparkle Pebble','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1288,'Water Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1289,'Rust Gold Coin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1290,'Red Soil','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1291,'Earth Ring','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1292,'Bead of Season','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1293,'Rusted Key','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1294,'Spellbook: Defense Aura','','false','spellbook',120,'stackable','paper','none',-1,-1,75,0,'true','true','true','true','true','none','0-0;'),
(1334,'Predator\'s Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(1335,'Goblin Club','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(1336,'Glass Shard','','false','none',80,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(1337,'Emerald','','false','none',80,'stackable','liquid','none',-1,-1,20000,0,'true','true','true','true','true','none','0-0;'),
(1338,'Blue Onyx','','false','none',80,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(1339,'Onyx','','false','none',80,'stackable','liquid','none',-1,-1,600,0,'true','true','true','true','true','none','0-0;'),
(1340,'Silvery Leaf','','false','none',3,'stackable','liquid','none',-1,-1,20,0,'true','true','true','true','true','none','0-0;'),
(1341,'Bone Arrow','','false','arrow',5,'stackable','bone','d',-1,-1,2,0,'true','true','true','true','true','none','0-0;'),
(1342,'Iron Arrow','','false','arrow',4,'stackable','fine_steel','c',-1,-1,5,0,'true','true','true','true','true','none','0-0;'),
(1343,'Silver Arrow','','false','arrow',4,'stackable','silver','b',-1,-1,7,0,'true','true','true','true','true','none','0-0;'),
(1344,'Mithril Arrow','','false','arrow',3,'stackable','mithril','a',-1,-1,8,0,'true','true','true','true','true','none','0-0;'),
(1345,'Shining Arrow','','false','arrow',3,'stackable','adamantaite','s',-1,-1,10,0,'true','true','true','true','true','none','0-0;'),
(1346,'Golem\'s Stoneheart','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1347,'Monster Eye Carcass','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1348,'Basilisk\'s Gizzard','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1349,'Anatomy Diagram','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1350,'Zombie Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1351,'Zombie Heart','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1352,'Zombie Liver','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1353,'Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1354,'Rib Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1355,'Spine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1356,'Arm Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1357,'Thigh Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1358,'Complete Skeleton','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1359,'Red Cross Badge','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1360,'Blue Cross Badge','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1361,'Black Cross Badge','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1362,'Spider\'s Carapace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1363,'Spider Silk','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1364,'Spider Venom Sac','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1365,'Broken Stoneheart','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1366,'Monster Eye\'s Lens','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1367,'Wolf Claw','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1368,'Imp Shackles','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1369,'Black Lion Mark','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1370,'Spellbook: Aqua Swirl','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1371,'Spellbook: Twister','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1372,'Spellbook: Blaze','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1373,'Magic Gem','','false','none',80,'stackable','liquid','none',-1,-1,600,0,'true','true','true','true','true','none','0-0;'),
(1374,'Greater Haste Potion','','false','potion',20,'stackable','liquid','none',-1,-1,3600,0,'true','true','true','true','true','ItemSkills','2034-1;'),
(1375,'Greater Swift Attack Potion','','false','potion',20,'stackable','liquid','none',-1,-1,7200,0,'true','true','true','true','true','ItemSkills','2035-1;'),
(1377,'Spellbook: Poison Recovery','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1378,'Spellbook: Divine Heal','','false','spellbook',120,'stackable','paper','none',-1,-1,1550,0,'true','true','true','true','true','none','0-0;'),
(1379,'Spellbook: Cure Bleeding','','false','spellbook',120,'stackable','paper','none',-1,-1,1150,0,'true','true','true','true','true','none','0-0;'),
(1380,'Spellbook: Entangle','','false','spellbook',120,'stackable','paper','none',-1,-1,2600,0,'true','true','true','true','true','none','0-0;'),
(1381,'Spellbook: Freezing Strike','','false','spellbook',120,'stackable','paper','none',-1,-1,2600,0,'true','true','true','true','true','none','0-0;'),
(1382,'Spellbook: Power Break','','false','spellbook',120,'stackable','paper','none',-1,-1,2600,0,'true','true','true','true','true','none','0-0;'),
(1383,'Spellbook: Poison','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1384,'Spellbook: Sprint','','false','spellbook',120,'stackable','paper','none',-1,-1,2600,0,'true','true','true','true','true','none','0-0;'),
(1385,'Spellbook: Recharge','','false','spellbook',120,'stackable','paper','none',-1,-1,1800,0,'true','true','true','true','true','none','0-0;'),
(1386,'Spellbook: Disrupt Undead','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1387,'Spellbook: Resist Poison','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(1388,'Spellbook: Mental Shield','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1389,'Spellbook: Holy Weapon','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1390,'Spellbook: Regeneration','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(1391,'Spellbook: Empower','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1392,'Spellbook: Berserker Spirit','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(1393,'Spellbook: Quickness','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1394,'Spellbook: Sleep','','false','spellbook',120,'stackable','paper','none',-1,-1,1800,0,'true','true','true','true','true','none','0-0;'),
(1395,'Spellbook: Surrender to Water','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1396,'Spellbook: Surrender to Wind','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1397,'Spellbook: Peace','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(1398,'Spellbook: Focus','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1399,'Spellbook: Concentration','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1400,'Spellbook: Surrender To Fire','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1401,'Spellbook: Acumen','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1402,'Spellbook: Agility','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1403,'Spellbook: Summon Kat the Cat','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1404,'Spellbook: Servitor Recharge','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1405,'Spellbook: Servitor Heal','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1406,'Spellbook: Servitor Wind Walk','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(1407,'Spellbook: Servitor Magic Boost','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(1408,'Spellbook: Mighty Servitor','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(1409,'Spellbook: Slow','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(1410,'Spellbook: Poisonous Cloud','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1411,'Spellbook: Aura Burn','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1412,'Spellbook: Resist Aqua','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(1413,'Spellbook: Resist Wind','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(1414,'Spellbook: Resist Fire','','false','spellbook',120,'stackable','paper','none',-1,-1,1800,0,'true','true','true','true','true','none','0-0;'),
(1415,'Spellbook: Dryad Root','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1416,'Spellbook: Curse of Chaos','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(1417,'Spellbook: Surrender To Earth','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1418,'Spellbook: Surrender To Poison','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1419,'Blood Mark','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(1420,'Ingredient List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1421,'Sonia\'s Botany Book','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1422,'Red Mandragora Root','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1423,'White Mandragora Root','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1424,'Red Mandragora Sap','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1425,'White Mandragora Sap','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1426,'Jacob\'s Insect Book','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1427,'Nectar','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1428,'Royal Jelly','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1429,'Honey','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1430,'Golden Honey','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1431,'Pano\'s Contract','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1432,'Hobgoblin Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1433,'Dionian Potato','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1434,'Glyvka\'s Botany Book','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1435,'Green Marsh Moss','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1436,'Brown Marsh Moss','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1437,'Green Moss Bundle','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1438,'Brown Moss Bundle','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1439,'Rollant\'s Creature Book','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1440,'Body of Monster Eye','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1441,'Meat of Monster Eye','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1442,'Jonas\'s 1st Steak Dish','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1443,'Jonas\'s 2nd Steak Dish','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1444,'Jonas\'s 3rd Steak Dish','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1445,'Jonas\'s 4th Steak Dish','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1446,'Jonas\'s 5th Steak Dish','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1447,'Mirien\'s Review','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1448,'Mirien\'s Review','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1449,'Mirien\'s Review','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1450,'Mirien\'s Review','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1451,'Mirien\'s Review','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1452,'Harpy Feather','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1453,'Medusa Venom','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1454,'Wyrm\'s Tooth','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1455,'Jonas\'s Salad Recipe','','false','quest',0,'stackable','paper','none',-1,-1,9000,0,'false','false','true','false','false','none','0-0;'),
(1456,'Jonas\'s Sauce Recipe','','false','quest',0,'stackable','paper','none',-1,-1,11250,0,'false','false','true','false','false','none','0-0;'),
(1457,'Jonas\'s Steak Recipe','','false','quest',0,'stackable','paper','none',-1,-1,13500,0,'false','false','true','false','false','none','0-0;'),
(1458,'Crystal: D-Grade','','false','none',0,'stackable','paper','d',-1,-1,650,0,'true','true','true','true','true','none','0-0;'),
(1459,'Crystal: C-Grade','','false','none',0,'stackable','paper','c',-1,-1,3000,0,'true','true','true','true','true','none','0-0;'),
(1460,'Crystal: B-Grade','','false','none',0,'stackable','paper','b',-1,-1,9000,0,'true','true','true','true','true','none','0-0;'),
(1461,'Crystal: A-Grade','','false','none',0,'stackable','paper','a',-1,-1,15000,0,'true','true','true','true','true','none','0-0;'),
(1462,'Crystal: S Grade','','false','none',0,'stackable','paper','s',-1,-1,25000,0,'true','true','true','true','true','none','0-0;'),
(1463,'Soulshot: D-grade','','false','shot',3,'stackable','paper','d',-1,-1,10,0,'true','true','true','true','true','SoulShots','2150-1;'),
(1464,'Soulshot: C-grade','','false','shot',3,'stackable','paper','c',-1,-1,15,0,'true','true','true','true','true','SoulShots','2151-1;'),
(1465,'Soulshot: B-grade','','false','shot',2,'stackable','paper','b',-1,-1,50,0,'true','true','true','true','true','SoulShots','2152-1;'),
(1466,'Soulshot: A-grade','','false','shot',2,'stackable','paper','a',-1,-1,80,0,'true','true','true','true','true','SoulShots','2153-1;'),
(1467,'Soulshot: S-grade','','false','shot',2,'stackable','paper','s',-1,-1,100,0,'true','true','true','true','true','SoulShots','2154-1;'),
(1468,'Gludin Panacen','','false','quest',0,'stackable','paper','s',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(1469,'Gludin Vermouth','','false','quest',0,'stackable','paper','s',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(1470,'Artemeter','','false','quest',0,'stackable','paper','s',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(1473,'Kasha Wolf Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1474,'Grave Robber\'s Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1475,'Black Soulstone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;');

INSERT INTO `etcitem` VALUES
(1476,'Red Soulstone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1477,'Maraku Werewolf Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1478,'Darkwing Bat Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1479,'Varangka\'s Parasite','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1480,'Kasha Parasite','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1481,'Kasha Crystal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1482,'Black Wolf Pelt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1483,'Goblin Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1484,'Goblin Pendant','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1485,'Goblin Lord Pendant','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1486,'Suspicious Memo','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1487,'Suspicious Contract','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1488,'Chrysolite Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1489,'Torn Map Fragment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1490,'Hidden Ore Map','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1491,'Bat Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1492,'Floating Stone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1493,'Tarantula Spider Silk','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1494,'Tarantula Spinnerette','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1495,'Giant Spider Skin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1496,'Voucher of Flame','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1497,'Necklace of Flame','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1498,'License of Miner','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1499,'Laferon\'s Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1500,'Totem of Hestui','','false','none',10,'stackable','liquid','none',-1,-1,11000,0,'true','true','true','true','true','none','0-0;'),
(1501,'Maraku Werewolf Totem','','false','none',10,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','none','0-0;'),
(1502,'Grandma\'s Pearl','','false','none',10,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(1503,'Grandma\'s Mirror','','false','none',10,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1504,'Grandma\'s Necklace','','false','none',10,'stackable','liquid','none',-1,-1,300,0,'true','true','true','true','true','none','0-0;'),
(1505,'Grandma\'s Hairpin','','false','none',10,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1512,'Spellbook: Confusion','','false','spellbook',120,'stackable','paper','none',-1,-1,1150,0,'true','true','true','true','true','none','0-0;'),
(1513,'Spellbook: Charm','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1514,'Spellbook: Resurrection','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1515,'Spellbook: Kiss of Eva','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1516,'Spellbook: Corpse Life Drain','','false','spellbook',120,'stackable','paper','none',-1,-1,1800,0,'true','true','true','true','true','none','0-0;'),
(1517,'Spellbook: Body To Mind','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1518,'Amulet: Flame Chant','','false','spellbook',120,'stackable','paper','none',-1,-1,1800,0,'true','true','true','true','true','none','0-0;'),
(1519,'Amulet: Pa\'agrio\'s Gift','','false','spellbook',120,'stackable','paper','none',-1,-1,1800,0,'true','true','true','true','true','none','0-0;'),
(1520,'Amulet: Pa\'agrio\'s Blessing','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(1521,'Amulet: Chant of Fire','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1522,'Amulet: Chant of Battle','','false','spellbook',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1523,'Amulet: Chant of Shielding','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1524,'Amulet: Soul Shield','','false','spellbook',120,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1525,'Amulet: Life Drain','','false','spellbook',120,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1526,'Amulet: Fear','','false','spellbook',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1527,'Amulet: Venom','','false','spellbook',120,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1528,'Amulet: Seal of Chaos','','false','spellbook',120,'stackable','paper','none',-1,-1,1800,0,'true','true','true','true','true','none','0-0;'),
(1529,'Amulet: Dreaming Spirit','','false','spellbook',120,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1530,'Amulet: Seal of Slow','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(1531,'Amulet: Chill Flame','','false','spellbook',120,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1532,'Amulet: Blaze Quake','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1533,'Amulet: Aura Sink','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1534,'Amulet: Madness','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1535,'Amulet: Frost Flame','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1536,'Amulet: Seal of Binding','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1537,'Amulet: Seal of Poison','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1538,'Blessed Scroll of Escape','','false','scroll',120,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','ItemSkills','2036-1;'),
(1539,'Greater Healing Potion','','false','potion',5,'stackable','liquid','none',-1,-1,1080,0,'true','true','true','true','true','ItemSkills','2037-1;'),
(1540,'Quick Healing Potion','','false','potion',180,'stackable','liquid','none',-1,-1,10000,0,'true','true','true','true','true','ItemSkills','2038-1;'),
(1541,'Honey Khandar','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1542,'Bear Fur Cloak','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1543,'Bloody Axe','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1544,'Ancestor Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1545,'Spider Dust','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1546,'Deep Sea Orb','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1547,'Bolter\'s List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1548,'Mining Boots','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1549,'Miner\'s Pick','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1550,'Boomboom Powder','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1551,'Redstone Beer','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1552,'Bolter\'s Smelly Socks','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1553,'Hatos\'s 1st Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1554,'Hatos\'s 2nd Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1555,'Hatos\'s 3rd Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1556,'Letter to Dark Elf','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1557,'Letter to Human','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1558,'Letter to Elf','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1559,'Gouph\'s Contract','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1560,'Reep\'s Contract','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1561,'Elven Wine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1562,'Brunon\'s Dice','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1563,'Brunon\'s Contract','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1564,'Aquamarine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1565,'Chrysoberyl','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1566,'Gem Box','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1567,'Coal Piece','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1568,'Brunon\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1569,'Berry Tart','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1570,'Bat Diagram','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1571,'Star Diamond','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1572,'Starstone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1573,'Starstone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1574,'Mirien\'s Review','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1575,'Mirien\'s Review','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1576,'Mirien\'s Review','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1577,'Mirien\'s Review','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1578,'Green Blood','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1579,'Goblin Dwelling Map','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1580,'Kuruka Ratman Tooth','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1581,'Betrayer\'s Report','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1582,'Betrayer\'s Report','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1583,'Betrayer\'s Report','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1584,'Betrayer\'s Report','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1585,'Betrayer\'s Report','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1586,'Betrayer\'s Report','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1587,'Betrayer\'s Report','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1588,'Betrayer\'s Report','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1589,'Betrayer\'s Report','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1590,'Betrayer\'s Report','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1591,'Head of Betrayer','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1592,'Mark of Raider','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1593,'Pomegranate','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1594,'1st Leather Pouch','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1595,'2nd Leather Pouch','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1596,'3rd Leather Pouch','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1597,'1st Leather Pouch (Full)','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1598,'2nd Leather Pouch (Full)','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1599,'3rd Leather Pouch (Full)','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1600,'Kasha Bear Claw','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1601,'Kasha Blade Spider Talon','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1602,'Scarlet Salamander Scale','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1603,'Fiery Spirit Scroll','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1604,'Rosheek\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1605,'Gantaki\'s Letter of Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1606,'Fig','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1607,'4th Leather Pouch','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1608,'4th Leather Pouch (Full)','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1609,'Vuku Orc Tusk','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1610,'Ratman Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1611,'Langk Lizardman Tooth','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1612,'Felim Lizardman Tooth','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1613,'Iron Will Scroll','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1614,'Toruku\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1615,'Khavatari Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1616,'Fire Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1617,'Kasha Bear Pelt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1618,'Kasha Blade Spider Husk','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1619,'1st Fiery Egg','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1620,'Hestui Mask','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1621,'2nd Fiery Egg','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1622,'Totem Spirit Claw','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1623,'Tataru\'s Letter of Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1624,'Flame Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1625,'Grizzly Blood','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1626,'Blood Cauldron','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1627,'Spirit Net','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1628,'Bound Durka Spirit','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1629,'Durka Parasite','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1630,'Totem Spirit Blood','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1631,'Mask of Medium','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1632,'Silvera\'s Ring','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1633,'1st Pass Certificate','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1634,'2nd Pass Certificate','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1635,'Final Pass Certificate','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1636,'Boogle Ratman Tooth','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1637,'Boogle Ratman Leader\'s Tooth','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1638,'Kluto\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1639,'Footprint of Thief','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1640,'Stolen Secret Box','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1641,'Secret Box','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1642,'Ring of Raven','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1643,'Pippi\'s Letter of Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1644,'Raut\'s Teleport Scroll','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1645,'Succubus Undies','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1646,'Mion\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1647,'Bronk\'s Ingot','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1648,'Shari\'s Axe','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1649,'Zimenf\'s Potion','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1650,'Bronk\'s Pay','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1651,'Shari\'s Pay','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1652,'Zimenf\'s Pay','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1653,'Bear Picture','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1654,'Tarantula Picture','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1655,'Honey Jar','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1656,'Bead','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1657,'Bead Parcel','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1658,'Gatekeeper Charm','','false','none',10,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(1659,'Gatekeeper Token','','false','none',10,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(1661,'Thief Key','','false','none',10,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(1662,'Wood','','false','none',2,'stackable','liquid','none',-1,-1,20,0,'true','true','true','true','true','none','0-0;'),
(1663,'(Not used) Trunk','','false','none',2,'stackable','liquid','none',-1,-1,20,0,'true','true','true','true','true','none','0-0;'),
(1664,'Steel Powder','','false','none',2,'stackable','liquid','none',-1,-1,80,0,'true','true','true','true','true','none','0-0;'),
(1665,'World Map','','false','none',0,'normal','liquid','none',-1,-1,500,0,'true','true','true','true','true','Maps','0-0;'),
(1666,'Recipe: Wooden Arrow','','false','recipe',30,'stackable','liquid','none',-1,-1,600,0,'true','true','true','true','true','Recipes','0-0;'),
(1667,'Spellbook: Summon Shadow','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1668,'Spellbook: Summon Mew the Cat','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1669,'Spellbook: Summon Boxer the Unicorn','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1670,'Spellbook: Summon Mirage the Unicorn','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1671,'Spellbook: Summon Silhouette','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1672,'__','','false','none',40,'normal','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1673,'__','','false','none',40,'normal','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1674,'Twig of Treant','','false','material',2,'stackable','liquid','none',-1,-1,80,0,'true','true','true','true','true','none','0-0;'),
(1675,'Beast Blood','','false','material',2,'stackable','liquid','none',-1,-1,40,0,'true','true','true','true','true','none','0-0;'),
(1676,'Beast Bone','','false','material',2,'stackable','liquid','none',-1,-1,20,0,'true','true','true','true','true','none','0-0;'),
(1677,'Hot Oil','','false','material',2,'stackable','liquid','none',-1,-1,40,0,'true','true','true','true','true','none','0-0;'),
(1678,'(Not used) Thread','','false','material',2,'stackable','liquid','none',-1,-1,10,0,'true','true','true','true','true','none','0-0;'),
(1679,'Bronze','','false','material',2,'stackable','liquid','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(1680,'Fur','','false','material',2,'stackable','liquid','none',-1,-1,40,0,'true','true','true','true','true','none','0-0;'),
(1681,'Elf Stone','','false','material',2,'stackable','liquid','none',-1,-1,1500,0,'true','true','true','true','true','none','0-0;'),
(1682,'Tear of Holy Spirit','','false','material',2,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(1683,'Mithril','','false','material',2,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(1684,'Durable Stem','','false','material',2,'stackable','liquid','none',-1,-1,220,0,'true','true','true','true','true','none','0-0;'),
(1685,'Wooden Frame','','false','material',2,'stackable','liquid','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(1686,'Bark of Treant','','false','material',2,'stackable','liquid','none',-1,-1,480,0,'true','true','true','true','true','none','0-0;'),
(1687,'(Not used) Coarse Bone Powder','','false','material',2,'stackable','liquid','none',-1,-1,80,0,'true','true','true','true','true','none','0-0;'),
(1688,'Refined Steel','','false','material',2,'stackable','liquid','none',-1,-1,480,0,'true','true','true','true','true','none','0-0;'),
(1689,'(Not used) Leather','','false','material',2,'stackable','liquid','none',-1,-1,300,0,'true','true','true','true','true','none','0-0;'),
(1690,'Bowstring','','false','material',2,'stackable','liquid','none',-1,-1,300,0,'true','true','true','true','true','none','0-0;'),
(1691,'Steel Frame','','false','material',2,'stackable','liquid','none',-1,-1,4400,0,'true','true','true','true','true','none','0-0;'),
(1692,'(Not used) Cord','','false','material',2,'stackable','liquid','none',-1,-1,45,0,'true','true','true','true','true','none','0-0;'),
(1693,'Refined Bronze','','false','material',2,'stackable','liquid','none',-1,-1,890,0,'true','true','true','true','true','none','0-0;'),
(1694,'Treant Potion','','false','material',2,'stackable','liquid','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1695,'Spell Paper','','false','material',2,'stackable','liquid','none',-1,-1,580,0,'true','true','true','true','true','none','0-0;'),
(1696,'Flaming Oil','','false','material',2,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1697,'Magic Powder','','false','material',2,'stackable','liquid','none',-1,-1,3080,0,'true','true','true','true','true','none','0-0;'),
(1698,'Refined Mithril','','false','material',2,'stackable','liquid','none',-1,-1,2100,0,'true','true','true','true','true','none','0-0;'),
(1699,'Fortified Steel','','false','material',2,'stackable','liquid','none',-1,-1,1860,0,'true','true','true','true','true','none','0-0;'),
(1700,'(Not used) Oriharukon','','false','material',2,'stackable','liquid','none',-1,-1,6300,0,'true','true','true','true','true','none','0-0;'),
(1701,'Spell Solution','','false','material',2,'stackable','liquid','none',-1,-1,8160,0,'true','true','true','true','true','none','0-0;'),
(1702,'Metal Frame','','false','material',2,'stackable','liquid','none',-1,-1,12500,0,'true','true','true','true','true','none','0-0;'),
(1703,'Steel of the Highest Grade','','false','material',2,'stackable','liquid','none',-1,-1,3720,0,'true','true','true','true','true','none','0-0;'),
(1704,'Stone of Anguish','','false','material',60,'stackable','liquid','none',-1,-1,157,0,'true','true','true','true','true','none','0-0;'),
(1705,'Sprig of Wisdom','','false','material',60,'stackable','liquid','none',-1,-1,258,0,'true','true','true','true','true','none','0-0;'),
(1706,'Blue Diamond Fragment','','false','material',60,'stackable','liquid','none',-1,-1,471,0,'true','true','true','true','true','none','0-0;'),
(1707,'Saint\'s Molar','','false','material',60,'stackable','liquid','none',-1,-1,568,0,'true','true','true','true','true','none','0-0;'),
(1708,'Smoky Quartz','','false','material',60,'stackable','liquid','none',-1,-1,1136,0,'true','true','true','true','true','none','0-0;'),
(1709,'Blood of Manticore','','false','material',60,'stackable','liquid','none',-1,-1,568,0,'true','true','true','true','true','none','0-0;'),
(1710,'Tiger\'s Eye Crystal','','false','material',60,'stackable','liquid','none',-1,-1,3215,0,'true','true','true','true','true','none','0-0;'),
(1711,'Claw of Leopard','','false','material',60,'stackable','liquid','none',-1,-1,402,0,'true','true','true','true','true','none','0-0;'),
(1712,'Leather Shoes Material','','false','material',60,'stackable','liquid','none',-1,-1,87,0,'true','true','true','true','true','none','0-0;'),
(1713,'Leather Tunic Material','','false','material',60,'stackable','liquid','none',-1,-1,261,0,'true','true','true','true','true','none','0-0;'),
(1714,'Leather Stockings Material','','false','material',60,'stackable','liquid','none',-1,-1,129,0,'true','true','true','true','true','none','0-0;'),
(1715,'Leather Helmet Material','','false','material',60,'stackable','liquid','none',-1,-1,240,0,'true','true','true','true','true','none','0-0;'),
(1716,'Leather Gloves Texture','','false','material',60,'stackable','liquid','none',-1,-1,226,0,'true','true','true','true','true','none','0-0;'),
(1717,'Leather Gloves Lining','','false','material',60,'stackable','liquid','none',-1,-1,113,0,'true','true','true','true','true','none','0-0;'),
(1718,'Black Bone Fragment','','false','material',60,'stackable','liquid','none',-1,-1,693,0,'true','true','true','true','true','none','0-0;'),
(1719,'Hard Leather Shirt Material','','false','material',60,'stackable','liquid','none',-1,-1,963,0,'true','true','true','true','true','none','0-0;'),
(1720,'Blue-Black Bone Fragment','','false','material',60,'stackable','liquid','none',-1,-1,1493,0,'true','true','true','true','true','none','0-0;'),
(1721,'Hard Leather Gaiter Material','','false','material',60,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1722,'Boots Material','','false','material',60,'stackable','liquid','none',-1,-1,271,0,'true','true','true','true','true','none','0-0;'),
(1723,'Leather Boots Material','','false','material',60,'stackable','liquid','none',-1,-1,364,0,'true','true','true','true','true','none','0-0;'),
(1724,'Skull Fragment','','false','material',60,'stackable','liquid','none',-1,-1,512,0,'true','true','true','true','true','none','0-0;'),
(1725,'Dark Stockings Material','','false','material',60,'stackable','liquid','none',-1,-1,632,0,'true','true','true','true','true','none','0-0;'),
(1726,'Crafted Leather Gloves Lining','','false','material',60,'stackable','liquid','none',-1,-1,523,0,'true','true','true','true','true','none','0-0;'),
(1727,'Crafted Leather Gloves Texture','','false','material',60,'stackable','liquid','none',-1,-1,261,0,'true','true','true','true','true','none','0-0;'),
(1728,'Steel Scale','','false','material',60,'stackable','liquid','none',-1,-1,1790,0,'true','true','true','true','true','none','0-0;'),
(1729,'Pure White Cloth','','false','material',60,'stackable','liquid','none',-1,-1,833,0,'true','true','true','true','true','none','0-0;'),
(1730,'Purifying Potion','','false','material',60,'stackable','liquid','none',-1,-1,3330,0,'true','true','true','true','true','none','0-0;'),
(1731,'Steel Scale Gaiters','','false','material',60,'stackable','liquid','none',-1,-1,1148,0,'true','true','true','true','true','none','0-0;'),
(1732,'Leather Fittings','','false','material',60,'stackable','liquid','none',-1,-1,1520,0,'true','true','true','true','true','none','0-0;'),
(1733,'Large Sheet Iron','','false','material',60,'stackable','liquid','none',-1,-1,1900,0,'true','true','true','true','true','none','0-0;'),
(1734,'Small Leather Fittings','','false','material',60,'stackable','liquid','none',-1,-1,952,0,'true','true','true','true','true','none','0-0;'),
(1735,'Small Sheet Iron','','false','material',60,'stackable','liquid','none',-1,-1,1190,0,'true','true','true','true','true','none','0-0;'),
(1736,'Iron Boots Binding','','false','material',60,'stackable','liquid','none',-1,-1,635,0,'true','true','true','true','true','none','0-0;'),
(1737,'Iron Boots Frame','','false','material',60,'stackable','liquid','none',-1,-1,508,0,'true','true','true','true','true','none','0-0;'),
(1738,'Wide Blade','','false','material',60,'stackable','liquid','none',-1,-1,625,0,'true','true','true','true','true','none','0-0;'),
(1739,'Broadsword Mold','','false','material',60,'stackable','liquid','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(1740,'Crafted Willow Branch','','false','material',60,'stackable','liquid','none',-1,-1,833,0,'true','true','true','true','true','none','0-0;'),
(1741,'Stave','','false','material',60,'stackable','liquid','none',-1,-1,900,0,'true','true','true','true','true','none','0-0;'),
(1742,'Red Cedar Branch','','false','material',60,'stackable','liquid','none',-1,-1,1797,0,'true','true','true','true','true','none','0-0;'),
(1743,'Dirk Blade','','false','material',60,'stackable','liquid','none',-1,-1,1082,0,'true','true','true','true','true','none','0-0;'),
(1744,'Dirk Mold','','false','material',60,'stackable','liquid','none',-1,-1,5410,0,'true','true','true','true','true','none','0-0;'),
(1745,'Brandish Blade','','false','material',60,'stackable','liquid','none',-1,-1,1880,0,'true','true','true','true','true','none','0-0;'),
(1746,'Short Spear Blade','','false','material',60,'stackable','liquid','none',-1,-1,3000,0,'true','true','true','true','true','none','0-0;'),
(1747,'Shining Blade','','false','material',60,'stackable','liquid','none',-1,-1,1700,0,'true','true','true','true','true','none','0-0;'),
(1748,'Sword of Reflection Mold','','false','material',60,'stackable','liquid','none',-1,-1,13600,0,'true','true','true','true','true','none','0-0;'),
(1749,'Branch of the Mother Tree','','false','material',60,'stackable','liquid','none',-1,-1,4533,0,'true','true','true','true','true','none','0-0;'),
(1750,'Dark Forest Leaf','','false','material',60,'stackable','liquid','none',-1,-1,2267,0,'true','true','true','true','true','none','0-0;'),
(1751,'Lump of Iron','','false','material',60,'stackable','liquid','none',-1,-1,5278,0,'true','true','true','true','true','none','0-0;'),
(1752,'Piece of Sword Breaker','','false','material',60,'stackable','liquid','none',-1,-1,3050,0,'true','true','true','true','true','none','0-0;'),
(1753,'Sword Breaker Mold','','false','material',60,'stackable','liquid','none',-1,-1,24400,0,'true','true','true','true','true','none','0-0;'),
(1754,'Steel Bow Mold','','false','material',60,'stackable','liquid','none',-1,-1,4067,0,'true','true','true','true','true','none','0-0;'),
(1755,'Metal Stave','','false','material',60,'stackable','liquid','none',-1,-1,8133,0,'true','true','true','true','true','none','0-0;'),
(1756,'Spirit of the Saber Smith','','false','material',60,'stackable','liquid','none',-1,-1,4544,0,'true','true','true','true','true','none','0-0;'),
(1757,'Saber Blade','','false','material',60,'stackable','liquid','none',-1,-1,5453,0,'true','true','true','true','true','none','0-0;'),
(1758,'Saber Mold','','false','material',60,'stackable','liquid','none',-1,-1,13633,0,'true','true','true','true','true','none','0-0;'),
(1759,'Blood of Assassin','','false','material',60,'stackable','liquid','none',-1,-1,4544,0,'true','true','true','true','true','none','0-0;'),
(1760,'Assassin Blade','','false','material',60,'stackable','liquid','none',-1,-1,5453,0,'true','true','true','true','true','none','0-0;'),
(1761,'Assassin Mold','','false','material',60,'stackable','liquid','none',-1,-1,27267,0,'true','true','true','true','true','none','0-0;'),
(1762,'Piece of Trident','','false','material',60,'stackable','liquid','none',-1,-1,6850,0,'true','true','true','true','true','none','0-0;'),
(1763,'Ruby Fragment','','false','material',60,'stackable','liquid','none',-1,-1,5113,0,'true','true','true','true','true','none','0-0;'),
(1764,'Deep Sea Water','','false','material',60,'stackable','liquid','none',-1,-1,10225,0,'true','true','true','true','true','none','0-0;'),
(1765,'Spinebone Fragment','','false','material',60,'stackable','liquid','none',-1,-1,6440,0,'true','true','true','true','true','none','0-0;'),
(1766,'Spinebone Pattern','','false','material',60,'stackable','liquid','none',-1,-1,12880,0,'true','true','true','true','true','none','0-0;'),
(1767,'Piece of Mace of Judgment','','false','material',60,'stackable','liquid','none',-1,-1,7156,0,'true','true','true','true','true','none','0-0;'),
(1768,'Pattern of Judgment','','false','material',60,'stackable','liquid','none',-1,-1,10733,0,'true','true','true','true','true','none','0-0;'),
(1769,'Piece of Conjuror\'s Staff','','false','material',60,'stackable','liquid','none',-1,-1,6440,0,'true','true','true','true','true','none','0-0;'),
(1770,'Magic Flute','','false','material',60,'stackable','liquid','none',-1,-1,12880,0,'true','true','true','true','true','none','0-0;'),
(1771,'Elven Stave','','false','material',60,'stackable','liquid','none',-1,-1,21467,0,'true','true','true','true','true','none','0-0;'),
(1772,'Leaf of the Mother Tree','','false','material',60,'stackable','liquid','none',-1,-1,5367,0,'true','true','true','true','true','none','0-0;'),
(1773,'Piece of Dwarven Trident','','false','material',60,'stackable','liquid','none',-1,-1,8613,0,'true','true','true','true','true','none','0-0;'),
(1774,'Piece of Two-Handed Sword','','false','material',60,'stackable','liquid','none',-1,-1,5688,0,'true','true','true','true','true','none','0-0;'),
(1775,'Two-Handed Sword Mold','','false','material',60,'stackable','liquid','none',-1,-1,96700,0,'true','true','true','true','true','none','0-0;'),
(1776,'Piece of Spiked Club','','false','material',60,'stackable','liquid','none',-1,-1,32233,0,'true','true','true','true','true','none','0-0;'),
(1777,'Steel Piece of Club','','false','material',60,'stackable','liquid','none',-1,-1,6447,0,'true','true','true','true','true','none','0-0;'),
(1778,'Shilen Bone','','false','material',60,'stackable','liquid','none',-1,-1,6447,0,'true','true','true','true','true','none','0-0;'),
(1779,'Shilen Mane','','false','material',60,'stackable','liquid','none',-1,-1,64467,0,'true','true','true','true','true','none','0-0;'),
(1780,'Purity Bronze','','false','material',60,'stackable','liquid','none',-1,-1,9210,0,'true','true','true','true','true','none','0-0;'),
(1781,'Gastraphetes Stave','','false','material',60,'stackable','liquid','none',-1,-1,32233,0,'true','true','true','true','true','none','0-0;'),
(1782,'Gastraphetes Addendum','','false','material',60,'stackable','liquid','none',-1,-1,6447,0,'true','true','true','true','true','none','0-0;'),
(1783,'Blood of Fiend','','false','material',60,'stackable','liquid','none',-1,-1,10744,0,'true','true','true','true','true','none','0-0;'),
(1784,'Cursed Leather','','false','material',60,'stackable','liquid','none',-1,-1,10744,0,'true','true','true','true','true','none','0-0;'),
(1785,'Soul Ore','','false','material',10,'stackable','liquid','none',-1,-1,250,0,'true','true','true','true','true','none','0-0;'),
(1786,'Recipe: Broad Sword','','false','recipe',30,'stackable','liquid','none',-1,-1,250,0,'true','true','true','true','true','Recipes','0-0;'),
(1787,'Recipe: Willow Staff','','false','recipe',30,'stackable','liquid','none',-1,-1,250,0,'true','true','true','true','true','Recipes','0-0;'),
(1788,'Recipe: Bow','','false','recipe',30,'stackable','liquid','none',-1,-1,250,0,'true','true','true','true','true','Recipes','0-0;'),
(1789,'Recipe: Cedar Staff','','false','recipe',30,'stackable','liquid','none',-1,-1,1082,0,'true','true','true','true','true','Recipes','0-0;'),
(1790,'Recipe: Dirk','','false','recipe',30,'stackable','liquid','none',-1,-1,1082,0,'true','true','true','true','true','Recipes','0-0;'),
(1791,'Recipe: Brandish','','false','recipe',30,'stackable','liquid','none',-1,-1,1082,0,'true','true','true','true','true','Recipes','0-0;'),
(1792,'Recipe: Short Spear','','false','recipe',30,'stackable','liquid','none',-1,-1,2720,0,'true','true','true','true','true','Recipes','0-0;'),
(1793,'Recipe: Sword of Reflection','','false','recipe',30,'stackable','liquid','none',-1,-1,2720,0,'true','true','true','true','true','Recipes','0-0;'),
(1794,'Recipe: Forest Bow','','false','recipe',30,'stackable','liquid','none',-1,-1,2720,0,'true','true','true','true','true','Recipes','0-0;'),
(1795,'Recipe:Leather Shoes','','false','recipe',30,'stackable','liquid','none',-1,-1,53,0,'true','true','true','true','true','Recipes','0-0;'),
(1796,'Recipe: Leather Tunic','','false','recipe',30,'stackable','liquid','none',-1,-1,159,0,'true','true','true','true','true','Recipes','0-0;'),
(1797,'Recipe: Leather Stockings','','false','recipe',30,'stackable','liquid','none',-1,-1,99,0,'true','true','true','true','true','Recipes','0-0;'),
(1798,'Recipe: Leather Helmet','','false','recipe',30,'stackable','liquid','none',-1,-1,204,0,'true','true','true','true','true','Recipes','0-0;'),
(1799,'Recipe: Leather Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,135,0,'true','true','true','true','true','Recipes','0-0;'),
(1800,'Recipe: Piece Bone Breastplate','','false','recipe',30,'stackable','liquid','none',-1,-1,636,0,'true','true','true','true','true','Recipes','0-0;'),
(1801,'Recipe: Piece Bone Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,397,0,'true','true','true','true','true','Recipes','0-0;'),
(1802,'Recipe: Necklace of Anguish','','false','recipe',30,'stackable','liquid','none',-1,-1,93,0,'true','true','true','true','true','Recipes','0-0;'),
(1803,'Recipe: Necklace of Wisdom','','false','recipe',30,'stackable','liquid','none',-1,-1,238,0,'true','true','true','true','true','Recipes','0-0;'),
(1804,'Recipe: Soulshot: D-Grade','','false','recipe',30,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','Recipes','0-0;'),
(1805,'Recipe: Soulshot: C-Grade','','false','recipe',30,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','Recipes','0-0;'),
(1806,'Recipe: Soulshot: B-Grade','','false','recipe',30,'stackable','liquid','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(1807,'Recipe: Soulshot: A-Grade','','false','recipe',30,'stackable','liquid','none',-1,-1,150000,0,'true','true','true','true','true','Recipes','0-0;'),
(1808,'Recipe: Soulshot: S Grade','','false','recipe',30,'stackable','liquid','none',-1,-1,450000,0,'true','true','true','true','true','Recipes','0-0;'),
(1809,'Recipe: Durable Stem','','false','recipe',30,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1810,'Recipe: Wooden Frame','','false','recipe',30,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1811,'Recipe: Bark of Treant','','false','recipe',30,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1812,'Recipe: Coarse Bone Powder','','false','recipe',30,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1813,'Recipe: Refined Steel','','false','recipe',30,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1814,'Recipe: Leather','','false','recipe',30,'stackable','liquid','none',-1,-1,380,0,'true','true','true','true','true','Recipes','0-0;'),
(1815,'Recipe: Bowstring','','false','recipe',30,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1816,'Recipe: Steel Frame','','false','recipe',30,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1817,'Recipe: Cord','','false','recipe',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','Recipes','0-0;'),
(1818,'Recipe: Refined Bronze','','false','recipe',30,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1819,'Recipe: Treant Potion','','false','recipe',30,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1820,'Recipe: Spell Paper','','false','recipe',30,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1821,'Recipe: Flaming Oil','','false','recipe',30,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1822,'Recipe: Magic Powder','','false','recipe',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(1823,'Recipe: Refined Mythril','','false','recipe',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(1824,'Recipe: Fortified Steel','','false','recipe',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(1825,'Recipe: Oriharukon','','false','recipe',30,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','Recipes','0-0;'),
(1826,'Recipe: Spell Solution','','false','recipe',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(1827,'Recipe: Metal Frame','','false','recipe',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(1828,'Recipe: Steel of Highest Grade','','false','recipe',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(1829,'Scroll of Escape: Clan Hall','','false','scroll',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','ItemSkills','2040-1;'),
(1830,'Scroll of Escape: Castle','','false','scroll',120,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','ItemSkills','2041-1;'),
(1831,'Antidote','','false','potion',20,'stackable','liquid','none',-1,-1,75,0,'true','true','true','true','true','ItemSkills','2042-1;'),
(1832,'Greater Antidote','','false','potion',20,'stackable','liquid','none',-1,-1,180,0,'true','true','true','true','true','ItemSkills','2043-1;'),
(1833,'Bandage','','false','potion',20,'stackable','liquid','none',-1,-1,75,0,'true','true','true','true','true','ItemSkills','2044-1;'),
(1834,'Emergency Dressing','','false','potion',20,'stackable','liquid','none',-1,-1,180,0,'true','true','true','true','true','ItemSkills','2045-1;'),
(1835,'Soulshot: No Grade','','false','shot',4,'stackable','paper','none',-1,-1,6,0,'true','true','true','true','true','SoulShots','0-0;'),
(1836,'Kendell\'s 1st Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1837,'Kendell\'s 2nd Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1838,'Kendell\'s 3rd Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1839,'Kendell\'s 4th Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1840,'Kendell\'s 5th Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1841,'Kendell\'s 6th Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1842,'Kendell\'s 7th Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1843,'Kendell\'s 8th Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1844,'Kaboo Chief\'s 1st Torque','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1845,'Kaboo Chief\'s 2nd Torque','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1846,'Turek Dog Tag','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1847,'Turek Medallion','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1848,'Clay Urn Fragment','','false','none',10,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(1849,'Brass Trinket Piece','','false','none',10,'stackable','liquid','none',-1,-1,240,0,'true','true','true','true','true','none','0-0;'),
(1850,'Bronze Mirror Piece','','false','none',10,'stackable','liquid','none',-1,-1,240,0,'true','true','true','true','true','none','0-0;'),
(1851,'Jade Necklace Bead','','false','none',10,'stackable','liquid','none',-1,-1,280,0,'true','true','true','true','true','none','0-0;'),
(1852,'Ancient Clay Urn','','false','none',10,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','none','0-0;'),
(1853,'Ancient Brass Tiara','','false','none',10,'stackable','liquid','none',-1,-1,1400,0,'true','true','true','true','true','none','0-0;'),
(1854,'Ancient Bronze Mirror','','false','none',10,'stackable','liquid','none',-1,-1,1400,0,'true','true','true','true','true','none','0-0;'),
(1855,'Ancient Jade Necklace','','false','none',10,'stackable','liquid','none',-1,-1,1700,0,'true','true','true','true','true','none','0-0;'),
(1856,'Amulet: Chant of Life','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(1857,'Keltir Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1858,'Keltir Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1859,'Keltir Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1860,'Keltir Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1861,'Keltir Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1862,'Keltir Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(1863,'Map: Elmore','','false','none',0,'normal','liquid','none',-1,-1,500,0,'true','true','true','true','true','Maps','0-0;'),
(1864,'Stem','','false','material',2,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1865,'Varnish','','false','material',2,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(1866,'Suede','','false','material',2,'stackable','liquid','none',-1,-1,300,0,'true','true','true','true','true','none','0-0;'),
(1867,'Animal Skin','','false','material',2,'stackable','liquid','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(1868,'Thread','','false','material',2,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(1869,'Iron Ore','','false','material',2,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(1870,'Coal','','false','material',2,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(1871,'Charcoal','','false','material',2,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(1872,'Animal Bone','','false','material',2,'stackable','liquid','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(1873,'Silver Nugget','','false','material',2,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1874,'Oriharukon Ore','','false','material',2,'stackable','liquid','none',-1,-1,3000,0,'true','true','true','true','true','none','0-0;'),
(1875,'Stone of Purity','','false','material',2,'stackable','liquid','none',-1,-1,3000,0,'true','true','true','true','true','none','0-0;'),
(1876,'Mithril Ore','','false','material',2,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(1877,'Adamantite Nugget','','false','material',2,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(1878,'Braided Hemp','','false','material',2,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(1879,'Cokes','','false','material',2,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','none','0-0;'),
(1880,'Steel','','false','material',2,'stackable','liquid','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(1881,'Coarse Bone Powder','','false','material',2,'stackable','liquid','none',-1,-1,1500,0,'true','true','true','true','true','none','0-0;'),
(1882,'Leather','','false','material',2,'stackable','liquid','none',-1,-1,900,0,'true','true','true','true','true','none','0-0;'),
(1883,'Steel Mold','','false','material',2,'stackable','liquid','none',-1,-1,4500,0,'true','true','true','true','true','none','0-0;'),
(1884,'Cord','','false','material',2,'stackable','liquid','none',-1,-1,325,0,'true','true','true','true','true','none','0-0;'),
(1885,'High Grade Suede','','false','material',2,'stackable','liquid','none',-1,-1,2400,0,'true','true','true','true','true','none','0-0;'),
(1886,'Silver Mold','','false','material',2,'stackable','liquid','none',-1,-1,13500,0,'true','true','true','true','true','none','0-0;'),
(1887,'Varnish of Purity','','false','material',2,'stackable','liquid','none',-1,-1,8100,0,'true','true','true','true','true','none','0-0;'),
(1888,'Synthetic Cokes','','false','material',2,'stackable','liquid','none',-1,-1,6600,0,'true','true','true','true','true','none','0-0;'),
(1889,'Compound Braid','','false','material',2,'stackable','liquid','none',-1,-1,3000,0,'true','true','true','true','true','none','0-0;'),
(1890,'Mithril Alloy','','false','material',2,'stackable','liquid','none',-1,-1,13100,0,'true','true','true','true','true','none','0-0;'),
(1891,'Artisan\'s Frame','','false','material',2,'stackable','liquid','none',-1,-1,95000,0,'true','true','true','true','true','none','0-0;'),
(1892,'Blacksmith\'s Frame','','false','material',2,'stackable','liquid','none',-1,-1,64000,0,'true','true','true','true','true','none','0-0;'),
(1893,'Oriharukon','','false','material',2,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','none','0-0;'),
(1894,'Crafted Leather','','false','material',2,'stackable','liquid','none',-1,-1,5700,0,'true','true','true','true','true','none','0-0;'),
(1895,'Metallic Fiber','','false','material',2,'stackable','liquid','none',-1,-1,700,0,'true','true','true','true','true','none','0-0;'),
(1896,'Necklace of Anguish Chain','','false','material',60,'stackable','liquid','none',-1,-1,472,0,'true','true','true','true','true','none','0-0;'),
(1897,'Necklace of Wisdom Chain','','false','material',60,'stackable','liquid','none',-1,-1,840,0,'true','true','true','true','true','none','0-0;'),
(1898,'Blue Diamond Necklace Gem','','false','material',60,'stackable','liquid','none',-1,-1,1947,0,'true','true','true','true','true','none','0-0;'),
(1899,'Necklace of Devotion Chain','','false','material',60,'stackable','liquid','none',-1,-1,1280,0,'true','true','true','true','true','none','0-0;'),
(1900,'Enchanted Necklace Chain','','false','material',60,'stackable','liquid','none',-1,-1,1828,0,'true','true','true','true','true','none','0-0;'),
(1901,'Tiger\'s Eye Earring Stone','','false','material',60,'stackable','liquid','none',-1,-1,1448,0,'true','true','true','true','true','none','0-0;'),
(1902,'Elven Earring Beads','','false','material',60,'stackable','liquid','none',-1,-1,1974,0,'true','true','true','true','true','none','0-0;'),
(1903,'Elven Ring Piece','','false','material',60,'stackable','liquid','none',-1,-1,1199,0,'true','true','true','true','true','none','0-0;'),
(1904,'Elven Necklace Beads','','false','material',60,'stackable','liquid','none',-1,-1,2143,0,'true','true','true','true','true','none','0-0;'),
(1905,'Omen Beast\'s Eye Earring Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,2056,0,'true','true','true','true','true','none','0-0;'),
(1906,'Mithril Ring Wire','','false','material',60,'stackable','liquid','none',-1,-1,1455,0,'true','true','true','true','true','none','0-0;'),
(1907,'Necklace of Darkness Gem','','false','material',60,'stackable','liquid','none',-1,-1,2875,0,'true','true','true','true','true','none','0-0;'),
(1908,'Moonstone Earring Wire','','false','material',60,'stackable','liquid','none',-1,-1,2112,0,'true','true','true','true','true','none','0-0;'),
(1909,'Aquastone Ring Wire','','false','material',60,'stackable','liquid','none',-1,-1,1481,0,'true','true','true','true','true','none','0-0;'),
(1910,'Aquastone Necklace Chain','','false','material',60,'stackable','liquid','none',-1,-1,2656,0,'true','true','true','true','true','none','0-0;'),
(1911,'Earring of Protection Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,2689,0,'true','true','true','true','true','none','0-0;'),
(1912,'Ring of Protection Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,1856,0,'true','true','true','true','true','none','0-0;'),
(1913,'Necklace of Protection Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,3289,0,'true','true','true','true','true','none','0-0;'),
(1914,'Earring of Binding Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,3560,0,'true','true','true','true','true','none','0-0;'),
(1915,'Ring of Ages Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,2270,0,'true','true','true','true','true','none','0-0;'),
(1916,'Necklace of Mermaid Teardrop','','false','material',60,'stackable','liquid','none',-1,-1,4700,0,'true','true','true','true','true','none','0-0;'),
(1917,'Sage\'s Necklace Chain','','false','material',60,'stackable','liquid','none',-1,-1,5845,0,'true','true','true','true','true','none','0-0;'),
(1918,'Nassen\'s Earring Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,4618,0,'true','true','true','true','true','none','0-0;'),
(1919,'Ring of Sage Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,3482,0,'true','true','true','true','true','none','0-0;'),
(1920,'Necklace of Binding Chain','','false','material',60,'stackable','liquid','none',-1,-1,5845,0,'true','true','true','true','true','none','0-0;'),
(1921,'Leather Shoes Texture','','false','material',60,'stackable','liquid','none',-1,-1,310,0,'true','true','true','true','true','none','0-0;'),
(1922,'Leather Tunic Pattern','','false','material',60,'stackable','liquid','none',-1,-1,784,0,'true','true','true','true','true','none','0-0;'),
(1923,'Leather Stocking Pattern','','false','material',60,'stackable','liquid','none',-1,-1,488,0,'true','true','true','true','true','none','0-0;'),
(1924,'Leather Helmet Design','','false','material',60,'stackable','liquid','none',-1,-1,620,0,'true','true','true','true','true','none','0-0;'),
(1925,'Leather Gloves Lining','','false','material',60,'stackable','liquid','none',-1,-1,305,0,'true','true','true','true','true','none','0-0;'),
(1926,'Piece Bone Breastplate Fragment','','false','material',60,'stackable','liquid','none',-1,-1,1980,0,'true','true','true','true','true','none','0-0;'),
(1927,'Hard Leather Shirt Pattern','','false','material',60,'stackable','liquid','none',-1,-1,2507,0,'true','true','true','true','true','none','0-0;'),
(1928,'Piece Bone Gaiters Fragment','','false','material',60,'stackable','liquid','none',-1,-1,1373,0,'true','true','true','true','true','none','0-0;'),
(1929,'Hard Leather Gaiters Material','','false','material',60,'stackable','liquid','none',-1,-1,1550,0,'true','true','true','true','true','none','0-0;'),
(1930,'Boot Lining','','false','material',60,'stackable','liquid','none',-1,-1,780,0,'true','true','true','true','true','none','0-0;'),
(1931,'Leather Boot Lining','','false','material',60,'stackable','liquid','none',-1,-1,1530,0,'true','true','true','true','true','none','0-0;'),
(1932,'Bone Helmet Design','','false','material',60,'stackable','liquid','none',-1,-1,1260,0,'true','true','true','true','true','none','0-0;'),
(1933,'Dark Stocking Fabric','','false','material',60,'stackable','liquid','none',-1,-1,1700,0,'true','true','true','true','true','none','0-0;'),
(1934,'Crafted Leather Gloves Lining','','false','material',60,'stackable','liquid','none',-1,-1,1530,0,'true','true','true','true','true','none','0-0;'),
(1935,'Scale Mail Fragment','','false','material',60,'stackable','liquid','none',-1,-1,3580,0,'true','true','true','true','true','none','0-0;'),
(1936,'White Tunic Pattern','','false','material',60,'stackable','liquid','none',-1,-1,2444,0,'true','true','true','true','true','none','0-0;'),
(1937,'Scale Gaiters Fragment','','false','material',60,'stackable','liquid','none',-1,-1,2328,0,'true','true','true','true','true','none','0-0;'),
(1938,'Mithril Banded Mail Material','','false','material',60,'stackable','liquid','none',-1,-1,2975,0,'true','true','true','true','true','none','0-0;'),
(1939,'Mithril Banded Gaiters Material','','false','material',60,'stackable','liquid','none',-1,-1,2277,0,'true','true','true','true','true','none','0-0;'),
(1940,'Iron Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,1340,0,'true','true','true','true','true','none','0-0;'),
(1941,'Brigandine Temper','','false','material',60,'stackable','liquid','none',-1,-1,5029,0,'true','true','true','true','true','none','0-0;'),
(1942,'Manticore Skin Shirt Texture','','false','material',60,'stackable','liquid','none',-1,-1,3921,0,'true','true','true','true','true','none','0-0;'),
(1943,'Manticore Skin Gaiters Pattern','','false','material',60,'stackable','liquid','none',-1,-1,2518,0,'true','true','true','true','true','none','0-0;'),
(1944,'Mithril Tunic Fabric','','false','material',60,'stackable','liquid','none',-1,-1,3921,0,'true','true','true','true','true','none','0-0;'),
(1945,'Mithril Stocking Design','','false','material',60,'stackable','liquid','none',-1,-1,2518,0,'true','true','true','true','true','none','0-0;'),
(1946,'Rip Gauntlets Pattern','','false','material',60,'stackable','liquid','none',-1,-1,1480,0,'true','true','true','true','true','none','0-0;'),
(1947,'Kite Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,1389,0,'true','true','true','true','true','none','0-0;'),
(1948,'Boots of Power Pattern','','false','material',60,'stackable','liquid','none',-1,-1,1480,0,'true','true','true','true','true','none','0-0;'),
(1949,'Mithril Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,1792,0,'true','true','true','true','true','none','0-0;'),
(1950,'Half Plate Temper','','false','material',60,'stackable','liquid','none',-1,-1,6162,0,'true','true','true','true','true','none','0-0;'),
(1951,'Plate Gaiters Part','','false','material',60,'stackable','liquid','none',-1,-1,3962,0,'true','true','true','true','true','none','0-0;'),
(1952,'Salamander Skin Mail Texture','','false','material',60,'stackable','liquid','none',-1,-1,6244,0,'true','true','true','true','true','none','0-0;'),
(1953,'Sage\'s Rag Lining','','false','material',60,'stackable','liquid','none',-1,-1,6244,0,'true','true','true','true','true','none','0-0;'),
(1954,'Karmian Stocking Design','','false','material',60,'stackable','liquid','none',-1,-1,3762,0,'true','true','true','true','true','none','0-0;'),
(1955,'Chain Helmet Design','','false','material',60,'stackable','liquid','none',-1,-1,2481,0,'true','true','true','true','true','none','0-0;'),
(1956,'Square Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,1762,0,'true','true','true','true','true','none','0-0;'),
(1957,'Assault Boots Part','','false','material',60,'stackable','liquid','none',-1,-1,1792,0,'true','true','true','true','true','none','0-0;'),
(1958,'Mithril Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,1120,0,'true','true','true','true','true','none','0-0;'),
(1959,'Chain Mail Shirt Material','','false','material',60,'stackable','liquid','none',-1,-1,7425,0,'true','true','true','true','true','none','0-0;'),
(1960,'Chain Gaiters Part','','false','material',60,'stackable','liquid','none',-1,-1,3650,0,'true','true','true','true','true','none','0-0;'),
(1961,'Mithril Shirt Fabric','','false','material',60,'stackable','liquid','none',-1,-1,6250,0,'true','true','true','true','true','none','0-0;'),
(1962,'Karmian Tunic Pattern','','false','material',60,'stackable','liquid','none',-1,-1,6250,0,'true','true','true','true','true','none','0-0;'),
(1963,'Ogre Power Gauntlets Part','','false','material',60,'stackable','liquid','none',-1,-1,1792,0,'true','true','true','true','true','none','0-0;'),
(1964,'Eldarake Temper','','false','material',60,'stackable','liquid','none',-1,-1,2475,0,'true','true','true','true','true','none','0-0;'),
(1965,'Metal Plate Helmet Material','','false','material',60,'stackable','liquid','none',-1,-1,2967,0,'true','true','true','true','true','none','0-0;'),
(1966,'Plated Leather Fragment','','false','material',60,'stackable','liquid','none',-1,-1,5478,0,'true','true','true','true','true','none','0-0;'),
(1967,'Plated Leather Gaiters Material','','false','material',60,'stackable','liquid','none',-1,-1,3667,0,'true','true','true','true','true','none','0-0;'),
(1968,'Dwarven Chain Mail Shirt Material','','false','material',60,'stackable','liquid','none',-1,-1,8300,0,'true','true','true','true','true','none','0-0;'),
(1969,'Dwarven Chain Gaiters Material','','false','material',60,'stackable','liquid','none',-1,-1,5233,0,'true','true','true','true','true','none','0-0;'),
(1970,'Robe of Seal Fabric','','false','material',60,'stackable','liquid','none',-1,-1,8956,0,'true','true','true','true','true','none','0-0;'),
(1971,'Great Helmet Material','','false','material',60,'stackable','liquid','none',-1,-1,3267,0,'true','true','true','true','true','none','0-0;'),
(1972,'Knight\'s Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,2500,0,'true','true','true','true','true','none','0-0;'),
(1973,'Pa\'agrian Hand Design','','false','material',60,'stackable','liquid','none',-1,-1,2378,0,'true','true','true','true','true','none','0-0;'),
(1974,'Crimson Boot Fabric','','false','material',60,'stackable','liquid','none',-1,-1,2378,0,'true','true','true','true','true','none','0-0;'),
(1975,'Rind Leather Armor Design','','false','material',60,'stackable','liquid','none',-1,-1,6089,0,'true','true','true','true','true','none','0-0;'),
(1976,'Rind Leather Gaiters Material','','false','material',60,'stackable','liquid','none',-1,-1,3289,0,'true','true','true','true','true','none','0-0;'),
(1977,'Composite Armor Temper','','false','material',60,'stackable','liquid','none',-1,-1,13520,0,'true','true','true','true','true','none','0-0;'),
(1978,'Tower Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,3120,0,'true','true','true','true','true','none','0-0;'),
(1979,'Demon\'s Tunic Fabric','','false','material',60,'stackable','liquid','none',-1,-1,8240,0,'true','true','true','true','true','none','0-0;'),
(1980,'Demon\'s Stocking Pattern','','false','material',60,'stackable','liquid','none',-1,-1,4700,0,'true','true','true','true','true','none','0-0;'),
(1981,'Mithril Gauntlets Design','','false','material',60,'stackable','liquid','none',-1,-1,3400,0,'true','true','true','true','true','none','0-0;'),
(1982,'Forgotten Boots Pattern','','false','material',60,'stackable','liquid','none',-1,-1,3400,0,'true','true','true','true','true','none','0-0;'),
(1983,'Shining Circlet Pattern','','false','material',60,'stackable','liquid','none',-1,-1,4560,0,'true','true','true','true','true','none','0-0;'),
(1984,'Theca Leather Armor Pattern','','false','material',60,'stackable','liquid','none',-1,-1,9330,0,'true','true','true','true','true','none','0-0;'),
(1985,'Theca Leather Gaiters Pattern','','false','material',60,'stackable','liquid','none',-1,-1,5800,0,'true','true','true','true','true','none','0-0;'),
(1986,'Full Plate Armor Temper','','false','material',60,'stackable','liquid','none',-1,-1,18927,0,'true','true','true','true','true','none','0-0;'),
(1987,'Drake Leather Armor Texture','','false','material',60,'stackable','liquid','none',-1,-1,13109,0,'true','true','true','true','true','none','0-0;'),
(1988,'Divine Tunic Fabric','','false','material',60,'stackable','liquid','none',-1,-1,10409,0,'true','true','true','true','true','none','0-0;'),
(1989,'Divine Stocking Pattern','','false','material',60,'stackable','liquid','none',-1,-1,6636,0,'true','true','true','true','true','none','0-0;'),
(1990,'Mithril Helmet Design','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(1991,'Cap of Mana Pattern','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(1992,'Paradia Hood Material','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(1993,'Hood of Solar Eclipse Texture','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(1994,'Hood of Summoning Texture','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(1995,'Elemental Hood Material','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(1996,'Hood of Grace Texture','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(1997,'Phoenix Hood Material','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(1998,'Hood of Aid Material','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(1999,'Flame Helm Design','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(2000,'Tallum Helm Design','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(2001,'Helm of Avadon Design','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(2002,'Helmet of Pledge Pattern','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(2003,'Gauntlets of Ghost Pattern','','false','material',60,'stackable','liquid','none',-1,-1,3673,0,'true','true','true','true','true','none','0-0;'),
(2004,'Adamantite Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,3673,0,'true','true','true','true','true','none','0-0;'),
(2005,'Broadsword Blade','','false','material',60,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','none','0-0;'),
(2006,'Willow Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','none','0-0;'),
(2007,'Bow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','none','0-0;'),
(2008,'Cedar Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,5140,0,'true','true','true','true','true','none','0-0;'),
(2009,'Dirk Blade','','false','material',60,'stackable','liquid','none',-1,-1,5640,0,'true','true','true','true','true','none','0-0;'),
(2010,'Brandish Blade','','false','material',60,'stackable','liquid','none',-1,-1,5140,0,'true','true','true','true','true','none','0-0;'),
(2011,'Short Spear Edge','','false','material',60,'stackable','liquid','none',-1,-1,8767,0,'true','true','true','true','true','none','0-0;'),
(2012,'Sword of Reflection Blade','','false','material',60,'stackable','liquid','none',-1,-1,9600,0,'true','true','true','true','true','none','0-0;'),
(2013,'Forest Bow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,9267,0,'true','true','true','true','true','none','0-0;'),
(2014,'Iron Hammer Head','','false','material',60,'stackable','liquid','none',-1,-1,17400,0,'true','true','true','true','true','none','0-0;'),
(2015,'Sword Breaker Edge','','false','material',60,'stackable','liquid','none',-1,-1,16400,0,'true','true','true','true','true','none','0-0;'),
(2016,'Composite Bow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,17067,0,'true','true','true','true','true','none','0-0;'),
(2017,'Saber Blade','','false','material',60,'stackable','liquid','none',-1,-1,15050,0,'true','true','true','true','true','none','0-0;'),
(2018,'Assassin Knife Edge','','false','material',60,'stackable','liquid','none',-1,-1,15050,0,'true','true','true','true','true','none','0-0;'),
(2019,'Trident Edge','','false','material',60,'stackable','liquid','none',-1,-1,9300,0,'true','true','true','true','true','none','0-0;'),
(2020,'Temptation of Abyss Piece','','false','material',60,'stackable','liquid','none',-1,-1,11425,0,'true','true','true','true','true','none','0-0;'),
(2021,'Spinebone Sword Blade','','false','material',60,'stackable','liquid','none',-1,-1,15840,0,'true','true','true','true','true','none','0-0;'),
(2022,'Mace of Judgment Head','','false','material',60,'stackable','liquid','none',-1,-1,12840,0,'true','true','true','true','true','none','0-0;'),
(2023,'Conjuror\'s Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,16140,0,'true','true','true','true','true','none','0-0;'),
(2024,'Elven Bow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,14040,0,'true','true','true','true','true','none','0-0;'),
(2025,'Dwarven Trident Edge','','false','material',60,'stackable','liquid','none',-1,-1,14440,0,'true','true','true','true','true','none','0-0;'),
(2026,'Two-Handed Sword Edge','','false','material',60,'stackable','liquid','none',-1,-1,16617,0,'true','true','true','true','true','none','0-0;'),
(2027,'Spiked Club Head','','false','material',60,'stackable','liquid','none',-1,-1,15267,0,'true','true','true','true','true','none','0-0;'),
(2028,'Shilen Knife Edge','','false','material',60,'stackable','liquid','none',-1,-1,16833,0,'true','true','true','true','true','none','0-0;'),
(2029,'Gastraphetes Shaft','','false','material',60,'stackable','liquid','none',-1,-1,16767,0,'true','true','true','true','true','none','0-0;'),
(2030,'Tome of Blood Page','','false','material',60,'stackable','liquid','none',-1,-1,17100,0,'true','true','true','true','true','none','0-0;'),
(2031,'Morning Star Head','','false','material',60,'stackable','liquid','none',-1,-1,19757,0,'true','true','true','true','true','none','0-0;'),
(2032,'Goat Head Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,21643,0,'true','true','true','true','true','none','0-0;'),
(2033,'Winged Spear Blade','','false','material',60,'stackable','liquid','none',-1,-1,17929,0,'true','true','true','true','true','none','0-0;'),
(2034,'Sword of Revolution Blade','','false','material',60,'stackable','liquid','none',-1,-1,18929,0,'true','true','true','true','true','none','0-0;'),
(2035,'Tarbar Head','','false','material',60,'stackable','liquid','none',-1,-1,19757,0,'true','true','true','true','true','none','0-0;'),
(2036,'Skull Breaker Head','','false','material',60,'stackable','liquid','none',-1,-1,19757,0,'true','true','true','true','true','none','0-0;'),
(2037,'Heavy Bone Club Head','','false','material',60,'stackable','liquid','none',-1,-1,19757,0,'true','true','true','true','true','none','0-0;'),
(2038,'Maingauche Edge','','false','material',60,'stackable','liquid','none',-1,-1,18929,0,'true','true','true','true','true','none','0-0;'),
(2039,'Bich\'Hwa Edge','','false','material',60,'stackable','liquid','none',-1,-1,19757,0,'true','true','true','true','true','none','0-0;'),
(2040,'Strengthened Long Bow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,17286,0,'true','true','true','true','true','none','0-0;'),
(2041,'War Pick Head','','false','material',60,'stackable','liquid','none',-1,-1,17929,0,'true','true','true','true','true','none','0-0;'),
(2042,'Crucifix of Blood Piece','','false','material',60,'stackable','liquid','none',-1,-1,21643,0,'true','true','true','true','true','none','0-0;'),
(2043,'Eye of Infinity Stone','','false','material',60,'stackable','liquid','none',-1,-1,21643,0,'true','true','true','true','true','none','0-0;'),
(2044,'Cursed Maingauche Edge','','false','material',60,'stackable','liquid','none',-1,-1,18929,0,'true','true','true','true','true','none','0-0;'),
(2045,'Blue Crystal Skull Part','','false','material',60,'stackable','liquid','none',-1,-1,21786,0,'true','true','true','true','true','none','0-0;'),
(2046,'Demon Fangs Part','','false','material',60,'stackable','liquid','none',-1,-1,21786,0,'true','true','true','true','true','none','0-0;'),
(2047,'Claymore Blade','','false','material',60,'stackable','liquid','none',-1,-1,22750,0,'true','true','true','true','true','none','0-0;'),
(2048,'Bonebreaker Head','','false','material',60,'stackable','liquid','none',-1,-1,24188,0,'true','true','true','true','true','none','0-0;'),
(2049,'Atuba Hammer Head','','false','material',60,'stackable','liquid','none',-1,-1,24188,0,'true','true','true','true','true','none','0-0;'),
(2050,'Ghost Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,22812,0,'true','true','true','true','true','none','0-0;'),
(2051,'Staff of Life Shaft','','false','material',60,'stackable','liquid','none',-1,-1,22812,0,'true','true','true','true','true','none','0-0;'),
(2052,'Mithril Dagger Blade','','false','material',60,'stackable','liquid','none',-1,-1,23062,0,'true','true','true','true','true','none','0-0;'),
(2053,'Scallop Jamadhr Edge','','false','material',60,'stackable','liquid','none',-1,-1,24188,0,'true','true','true','true','true','none','0-0;'),
(2054,'Light Crossbow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,23500,0,'true','true','true','true','true','none','0-0;'),
(2055,'Glaive Edge','','false','material',60,'stackable','liquid','none',-1,-1,24188,0,'true','true','true','true','true','none','0-0;'),
(2056,'Vajra Wand Frame','','false','material',60,'stackable','liquid','none',-1,-1,22812,0,'true','true','true','true','true','none','0-0;'),
(2057,'Ancient Reagent Remnant','','false','material',60,'stackable','liquid','none',-1,-1,22812,0,'true','true','true','true','true','none','0-0;'),
(2058,'Atuba Mace Head','','false','material',60,'stackable','liquid','none',-1,-1,24188,0,'true','true','true','true','true','none','0-0;'),
(2059,'Flamberge Blade','','false','material',60,'stackable','liquid','none',-1,-1,24125,0,'true','true','true','true','true','none','0-0;'),
(2060,'Stormbringer Blade','','false','material',60,'stackable','liquid','none',-1,-1,24425,0,'true','true','true','true','true','none','0-0;'),
(2061,'Big Hammer Head','','false','material',60,'stackable','liquid','none',-1,-1,26800,0,'true','true','true','true','true','none','0-0;'),
(2062,'Scythe Edge','','false','material',60,'stackable','liquid','none',-1,-1,22750,0,'true','true','true','true','true','none','0-0;'),
(2063,'Battle Axe Head','','false','material',60,'stackable','liquid','none',-1,-1,26800,0,'true','true','true','true','true','none','0-0;'),
(2064,'Silver Axe Head','','false','material',60,'stackable','liquid','none',-1,-1,26800,0,'true','true','true','true','true','none','0-0;'),
(2065,'Skull Graver Head','','false','material',60,'stackable','liquid','none',-1,-1,26800,0,'true','true','true','true','true','none','0-0;'),
(2066,'Heavy Doom Hammer Head','','false','material',60,'stackable','liquid','none',-1,-1,22750,0,'true','true','true','true','true','none','0-0;'),
(2067,'Crystal Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(2068,'Stick of Faith Shaft','','false','material',60,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(2069,'Heavy Doom Axe Blade','','false','material',60,'stackable','liquid','none',-1,-1,22750,0,'true','true','true','true','true','none','0-0;'),
(2070,'Cursed Dagger Blade','','false','material',60,'stackable','liquid','none',-1,-1,24425,0,'true','true','true','true','true','none','0-0;'),
(2071,'Wolverine Needle Edge','','false','material',60,'stackable','liquid','none',-1,-1,24425,0,'true','true','true','true','true','none','0-0;'),
(2072,'Dark Elven Dagger Edge','','false','material',60,'stackable','liquid','none',-1,-1,24425,0,'true','true','true','true','true','none','0-0;'),
(2073,'Chakram Edge','','false','material',60,'stackable','liquid','none',-1,-1,26800,0,'true','true','true','true','true','none','0-0;'),
(2074,'Crystallized Ice Bow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,26538,0,'true','true','true','true','true','none','0-0;'),
(2075,'Orcish Glaive Blade','','false','material',60,'stackable','liquid','none',-1,-1,22750,0,'true','true','true','true','true','none','0-0;'),
(2076,'Body Slasher Blade','','false','material',60,'stackable','liquid','none',-1,-1,22750,0,'true','true','true','true','true','none','0-0;'),
(2077,'Shamshir Blade','','false','material',60,'stackable','liquid','none',-1,-1,29556,0,'true','true','true','true','true','none','0-0;'),
(2078,'Katana Blade','','false','material',60,'stackable','liquid','none',-1,-1,29556,0,'true','true','true','true','true','none','0-0;'),
(2079,'Bec De Corbin Blade','','false','material',60,'stackable','liquid','none',-1,-1,31667,0,'true','true','true','true','true','none','0-0;'),
(2080,'Spirit Sword Blade','','false','material',60,'stackable','liquid','none',-1,-1,29556,0,'true','true','true','true','true','none','0-0;'),
(2081,'Raid Sword Blade','','false','material',60,'stackable','liquid','none',-1,-1,29556,0,'true','true','true','true','true','none','0-0;'),
(2082,'Cursed Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,30911,0,'true','true','true','true','true','none','0-0;'),
(2083,'Stiletto Edge','','false','material',60,'stackable','liquid','none',-1,-1,29556,0,'true','true','true','true','true','none','0-0;'),
(2084,'Soulfire Dirk Blade','','false','material',60,'stackable','liquid','none',-1,-1,29556,0,'true','true','true','true','true','none','0-0;'),
(2085,'Crossbow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,26189,0,'true','true','true','true','true','none','0-0;'),
(2086,'Elven Bow of Nobility Shaft','','false','material',60,'stackable','liquid','none',-1,-1,26189,0,'true','true','true','true','true','none','0-0;'),
(2087,'Tears of Fairy Drop','','false','material',60,'stackable','liquid','none',-1,-1,30911,0,'true','true','true','true','true','none','0-0;'),
(2088,'Horn of Glory Fragment','','false','material',60,'stackable','liquid','none',-1,-1,30911,0,'true','true','true','true','true','none','0-0;'),
(2089,'Caliburs Edge','','false','material',60,'stackable','liquid','none',-1,-1,37450,0,'true','true','true','true','true','none','0-0;'),
(2090,'Delusional Blade','','false','material',60,'stackable','liquid','none',-1,-1,37450,0,'true','true','true','true','true','none','0-0;'),
(2091,'Tsurugi Blade','','false','material',60,'stackable','liquid','none',-1,-1,37450,0,'true','true','true','true','true','none','0-0;'),
(2092,'Homunkulus\'s Sword Blade','','false','material',60,'stackable','liquid','none',-1,-1,37450,0,'true','true','true','true','true','none','0-0;'),
(2093,'Poleaxe Blade','','false','material',60,'stackable','liquid','none',-1,-1,34200,0,'true','true','true','true','true','none','0-0;'),
(2094,'Sword of Limit Blade','','false','material',60,'stackable','liquid','none',-1,-1,37450,0,'true','true','true','true','true','none','0-0;'),
(2095,'Sword of Nightmare Blade','','false','material',60,'stackable','liquid','none',-1,-1,37450,0,'true','true','true','true','true','none','0-0;'),
(2096,'Sword of Whispering Death Blade','','false','material',60,'stackable','liquid','none',-1,-1,37450,0,'true','true','true','true','true','none','0-0;'),
(2097,'War Axe Blade','','false','material',60,'stackable','liquid','none',-1,-1,37000,0,'true','true','true','true','true','none','0-0;'),
(2098,'Nirvana Axe Blade','','false','material',60,'stackable','liquid','none',-1,-1,37000,0,'true','true','true','true','true','none','0-0;'),
(2099,'Stick of Eternity Shaft','','false','material',60,'stackable','liquid','none',-1,-1,35900,0,'true','true','true','true','true','none','0-0;'),
(2100,'Paradia Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,35900,0,'true','true','true','true','true','none','0-0;'),
(2101,'Inferno Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,35900,0,'true','true','true','true','true','none','0-0;'),
(2102,'Pa\'agrian Hammer Head','','false','material',60,'stackable','liquid','none',-1,-1,34200,0,'true','true','true','true','true','none','0-0;'),
(2103,'Sage\'s Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,35900,0,'true','true','true','true','true','none','0-0;'),
(2104,'Club of Nature Head','','false','material',60,'stackable','liquid','none',-1,-1,35900,0,'true','true','true','true','true','none','0-0;'),
(2105,'Mace of the Underworld Head','','false','material',60,'stackable','liquid','none',-1,-1,37000,0,'true','true','true','true','true','none','0-0;'),
(2106,'Grace Dagger Edge','','false','material',60,'stackable','liquid','none',-1,-1,37450,0,'true','true','true','true','true','none','0-0;'),
(2107,'Dark Screamer Edge','','false','material',60,'stackable','liquid','none',-1,-1,37450,0,'true','true','true','true','true','none','0-0;'),
(2108,'Fisted Blade Piece','','false','material',60,'stackable','liquid','none',-1,-1,37000,0,'true','true','true','true','true','none','0-0;'),
(2109,'Akat Longbow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,41130,0,'true','true','true','true','true','none','0-0;'),
(2110,'Heathen\'s Book Page','','false','material',60,'stackable','liquid','none',-1,-1,35900,0,'true','true','true','true','true','none','0-0;'),
(2111,'Hex Doll Fragment','','false','material',60,'stackable','liquid','none',-1,-1,35900,0,'true','true','true','true','true','none','0-0;'),
(2112,'Pa\'agrian Axe Blade','','false','material',60,'stackable','liquid','none',-1,-1,39900,0,'true','true','true','true','true','none','0-0;'),
(2113,'Scorpion Blade','','false','material',60,'stackable','liquid','none',-1,-1,39900,0,'true','true','true','true','true','none','0-0;'),
(2114,'Widowmaker Head','','false','material',60,'stackable','liquid','none',-1,-1,39900,0,'true','true','true','true','true','none','0-0;'),
(2115,'Samurai Longsword Blade','','false','material',60,'stackable','liquid','none',-1,-1,46636,0,'true','true','true','true','true','none','0-0;'),
(2116,'Deadman\'s Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,43818,0,'true','true','true','true','true','none','0-0;'),
(2117,'Ghoul\'s Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,43818,0,'true','true','true','true','true','none','0-0;'),
(2118,'Demon\'s Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,43818,0,'true','true','true','true','true','none','0-0;'),
(2119,'Crystal Dagger Blade','','false','material',60,'stackable','liquid','none',-1,-1,43136,0,'true','true','true','true','true','none','0-0;'),
(2120,'Great Pata Blade','','false','material',60,'stackable','liquid','none',-1,-1,45964,0,'true','true','true','true','true','none','0-0;'),
(2121,'Eminence Bow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,47218,0,'true','true','true','true','true','none','0-0;'),
(2122,'Orcish Poleaxe Blade','','false','material',60,'stackable','liquid','none',-1,-1,43818,0,'true','true','true','true','true','none','0-0;'),
(2123,'Candle of Wisdom Model','','false','material',60,'stackable','liquid','none',-1,-1,43818,0,'true','true','true','true','true','none','0-0;'),
(2124,'Blessed Branch Splinter','','false','material',60,'stackable','liquid','none',-1,-1,43818,0,'true','true','true','true','true','none','0-0;'),
(2125,'Phoenix Feather Piece','','false','material',60,'stackable','liquid','none',-1,-1,43818,0,'true','true','true','true','true','none','0-0;'),
(2126,'Cerberus Eye Fragment','','false','material',60,'stackable','liquid','none',-1,-1,43818,0,'true','true','true','true','true','none','0-0;'),
(2127,'Scroll of Destruction Page','','false','material',60,'stackable','liquid','none',-1,-1,43818,0,'true','true','true','true','true','none','0-0;'),
(2128,'Claws of Black Dragon Piece','','false','material',60,'stackable','liquid','none',-1,-1,43818,0,'true','true','true','true','true','none','0-0;'),
(2129,'Three Eyed Crow\'s Feather Piece','','false','material',60,'stackable','liquid','none',-1,-1,43818,0,'true','true','true','true','true','none','0-0;'),
(2130,'Gemstone D','','false','material',2,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(2131,'Gemstone C','','false','material',2,'stackable','liquid','none',-1,-1,3000,0,'true','true','true','true','true','none','0-0;'),
(2132,'Gemstone B','','false','material',2,'stackable','liquid','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(2133,'Gemstone A','','false','material',2,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(2134,'Gemstone S','','false','material',2,'stackable','liquid','none',-1,-1,100000,0,'true','true','true','true','true','none','0-0;'),
(2135,'Recipe: Braided Hemp','','false','recipe',30,'stackable','liquid','none',-1,-1,680,0,'true','true','true','true','true','Recipes','0-0;'),
(2136,'Recipe: Cokes','','false','recipe',30,'stackable','liquid','none',-1,-1,680,0,'true','true','true','true','true','Recipes','0-0;'),
(2137,'Recipe: Steel','','false','recipe',30,'stackable','liquid','none',-1,-1,680,0,'true','true','true','true','true','Recipes','0-0;'),
(2138,'Recipe: Coarse Bone Powder (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,680,0,'true','true','true','true','true','Recipes','0-0;'),
(2139,'Recipe: Steel Mold','','false','recipe',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','Recipes','0-0;'),
(2140,'Recipe: High Grade Suede','','false','recipe',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','Recipes','0-0;'),
(2141,'Recipe: Silver Mold','','false','recipe',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','Recipes','0-0;'),
(2142,'Recipe: Varnish of Purity','','false','recipe',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','Recipes','0-0;'),
(2143,'Recipe: Synthetic Cokes','','false','recipe',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','Recipes','0-0;'),
(2144,'Recipe: Compound Braid','','false','recipe',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','Recipes','0-0;'),
(2145,'Recipe: Mithril Alloy','','false','recipe',30,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','Recipes','0-0;'),
(2146,'Recipe: Artisan\'s frame','','false','recipe',30,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','Recipes','0-0;'),
(2147,'Recipe: Blacksmith\'s frame','','false','recipe',30,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','Recipes','0-0;'),
(2148,'Recipe: Crafted Leather','','false','recipe',30,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','Recipes','0-0;'),
(2149,'Recipe: Metallic Fiber','','false','recipe',30,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','Recipes','0-0;'),
(2150,'Recipe: Blue Diamond Necklace','','false','recipe',30,'stackable','liquid','none',-1,-1,426,0,'true','true','true','true','true','Recipes','0-0;'),
(2151,'Recipe: Necklace of Devotion','','false','recipe',30,'stackable','liquid','none',-1,-1,718,0,'true','true','true','true','true','Recipes','0-0;'),
(2152,'Recipe: Enchanted Necklace','','false','recipe',30,'stackable','liquid','none',-1,-1,1136,0,'true','true','true','true','true','Recipes','0-0;'),
(2153,'Recipe: Tiger\'s Eye Earring','','false','recipe',30,'stackable','liquid','none',-1,-1,1286,0,'true','true','true','true','true','Recipes','0-0;'),
(2154,'Recipe: Elven Earring','','false','recipe',30,'stackable','liquid','none',-1,-1,1868,0,'true','true','true','true','true','Recipes','0-0;'),
(2155,'Recipe: Elven Ring','','false','recipe',30,'stackable','liquid','none',-1,-1,1246,0,'true','true','true','true','true','Recipes','0-0;'),
(2156,'Recipe: Elven Necklace','','false','recipe',30,'stackable','liquid','none',-1,-1,2500,0,'true','true','true','true','true','Recipes','0-0;'),
(2157,'Recipe: Omen Beast\'s Eye Earring','','false','recipe',30,'stackable','liquid','none',-1,-1,2420,0,'true','true','true','true','true','Recipes','0-0;'),
(2158,'Recipe: Mithril Ring','','false','recipe',30,'stackable','liquid','none',-1,-1,1616,0,'true','true','true','true','true','Recipes','0-0;'),
(2159,'Recipe: Necklace of Darkness','','false','recipe',30,'stackable','liquid','none',-1,-1,3240,0,'true','true','true','true','true','Recipes','0-0;'),
(2160,'Recipe: Moonstone Earring','','false','recipe',30,'stackable','liquid','none',-1,-1,3100,0,'true','true','true','true','true','Recipes','0-0;'),
(2161,'Recipe: Aquastone Ring','','false','recipe',30,'stackable','liquid','none',-1,-1,2060,0,'true','true','true','true','true','Recipes','0-0;'),
(2162,'Recipe: Aquastone Necklace','','false','recipe',30,'stackable','liquid','none',-1,-1,4140,0,'true','true','true','true','true','Recipes','0-0;'),
(2163,'Recipe: Earring of Protection','','false','recipe',30,'stackable','liquid','none',-1,-1,3920,0,'true','true','true','true','true','Recipes','0-0;'),
(2164,'Recipe: Ring of Protection','','false','recipe',30,'stackable','liquid','none',-1,-1,2600,0,'true','true','true','true','true','Recipes','0-0;'),
(2165,'Recipe: Necklace of Protection','','false','recipe',30,'stackable','liquid','none',-1,-1,5220,0,'true','true','true','true','true','Recipes','0-0;'),
(2166,'Recipe: Earrings of Binding (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,5900,0,'true','true','true','true','true','Recipes','0-0;'),
(2167,'Recipe: Ring of Ages','','false','recipe',30,'stackable','liquid','none',-1,-1,3920,0,'true','true','true','true','true','Recipes','0-0;'),
(2168,'Recipe: Necklace of Mermaid','','false','recipe',30,'stackable','liquid','none',-1,-1,7860,0,'true','true','true','true','true','Recipes','0-0;'),
(2169,'Recipe: Necklace of Binding','','false','recipe',30,'stackable','liquid','none',-1,-1,11300,0,'true','true','true','true','true','Recipes','0-0;'),
(2170,'Recipe: Nassen\'s Earring','','false','recipe',30,'stackable','liquid','none',-1,-1,8480,0,'true','true','true','true','true','Recipes','0-0;'),
(2171,'Recipe: Sage\'s Ring','','false','recipe',30,'stackable','liquid','none',-1,-1,5640,0,'true','true','true','true','true','Recipes','0-0;'),
(2172,'Recipe: Sage\'s Necklace','','false','recipe',30,'stackable','liquid','none',-1,-1,11300,0,'true','true','true','true','true','Recipes','0-0;'),
(2173,'Recipe: Hard Leather Shirt','','false','recipe',30,'stackable','liquid','none',-1,-1,738,0,'true','true','true','true','true','Recipes','0-0;'),
(2174,'Recipe: Hard Leather Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,460,0,'true','true','true','true','true','Recipes','0-0;'),
(2175,'Recipe: Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,246,0,'true','true','true','true','true','Recipes','0-0;'),
(2176,'Recipe: Leather Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,418,0,'true','true','true','true','true','Recipes','0-0;'),
(2177,'Recipe: Bone Helmet','','false','recipe',30,'stackable','liquid','none',-1,-1,626,0,'true','true','true','true','true','Recipes','0-0;'),
(2178,'Recipe: Dark Stockings','','false','recipe',30,'stackable','liquid','none',-1,-1,1250,0,'true','true','true','true','true','Recipes','0-0;'),
(2179,'Recipe: Crafted Leather Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,418,0,'true','true','true','true','true','Recipes','0-0;'),
(2180,'Recipe: Scale Mail','','false','recipe',30,'stackable','liquid','none',-1,-1,2660,0,'true','true','true','true','true','Recipes','0-0;'),
(2181,'Recipe: White Tunic','','false','recipe',30,'stackable','liquid','none',-1,-1,1998,0,'true','true','true','true','true','Recipes','0-0;'),
(2182,'Recipe: Scale Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,1666,0,'true','true','true','true','true','Recipes','0-0;'),
(2183,'Recipe: Mithril Banded Mail','','false','recipe',30,'stackable','liquid','none',-1,-1,3040,0,'true','true','true','true','true','Recipes','0-0;'),
(2184,'Recipe: Mithril Banded Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,1904,0,'true','true','true','true','true','Recipes','0-0;'),
(2185,'Recipe: Iron Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,1016,0,'true','true','true','true','true','Recipes','0-0;'),
(2186,'Recipe: Brigandine Tunic','','false','recipe',30,'stackable','liquid','none',-1,-1,5980,0,'true','true','true','true','true','Recipes','0-0;'),
(2187,'Recipe: Manticore Skin Shirt','','false','recipe',30,'stackable','liquid','none',-1,-1,4480,0,'true','true','true','true','true','Recipes','0-0;'),
(2188,'Recipe: Manticore Skin Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','Recipes','0-0;'),
(2189,'Recipe: Mithril Tunic','','false','recipe',30,'stackable','liquid','none',-1,-1,4480,0,'true','true','true','true','true','Recipes','0-0;'),
(2190,'Recipe: Mithril Stockings','','false','recipe',30,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','Recipes','0-0;'),
(2191,'Recipe: RIP Gauntlets','','false','recipe',30,'stackable','liquid','none',-1,-1,1494,0,'true','true','true','true','true','Recipes','0-0;'),
(2192,'Recipe: Kite Shield','','false','recipe',30,'stackable','liquid','none',-1,-1,1568,0,'true','true','true','true','true','Recipes','0-0;'),
(2193,'Recipe: Boots of Power','','false','recipe',30,'stackable','liquid','none',-1,-1,1494,0,'true','true','true','true','true','Recipes','0-0;'),
(2194,'Recipe: Mithril Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,1956,0,'true','true','true','true','true','Recipes','0-0;'),
(2195,'Recipe: Half Plate Armor','','false','recipe',30,'stackable','liquid','none',-1,-1,7820,0,'true','true','true','true','true','Recipes','0-0;'),
(2196,'Recipe: Plate Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,4880,0,'true','true','true','true','true','Recipes','0-0;'),
(2197,'Recipe: Salamander Skin Mail','','false','recipe',30,'stackable','liquid','none',-1,-1,9540,0,'true','true','true','true','true','Recipes','0-0;'),
(2198,'Recipe: Sage\'s Rag','','false','recipe',30,'stackable','liquid','none',-1,-1,9540,0,'true','true','true','true','true','Recipes','0-0;'),
(2199,'Recipe: Karmian Stockings','','false','recipe',30,'stackable','liquid','none',-1,-1,4740,0,'true','true','true','true','true','Recipes','0-0;'),
(2200,'Recipe: Chain Helmet','','false','recipe',30,'stackable','liquid','none',-1,-1,2940,0,'true','true','true','true','true','Recipes','0-0;'),
(2201,'Recipe: Square Shield','','false','recipe',30,'stackable','liquid','none',-1,-1,2060,0,'true','true','true','true','true','Recipes','0-0;'),
(2202,'Recipe: Assault Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,1956,0,'true','true','true','true','true','Recipes','0-0;'),
(2203,'Recipe: Mithril Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,918,0,'true','true','true','true','true','Recipes','0-0;'),
(2204,'Recipe: Chain Mail Shirt','','false','recipe',30,'stackable','liquid','none',-1,-1,10100,0,'true','true','true','true','true','Recipes','0-0;'),
(2205,'Recipe: Chain Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,6320,0,'true','true','true','true','true','Recipes','0-0;'),
(2206,'Recipe: Mithril Shirt','','false','recipe',30,'stackable','liquid','none',-1,-1,7580,0,'true','true','true','true','true','Recipes','0-0;'),
(2207,'Recipe: Karmian Tunic','','false','recipe',30,'stackable','liquid','none',-1,-1,7580,0,'true','true','true','true','true','Recipes','0-0;'),
(2208,'Recipe: Ogre Power Gauntlets','','false','recipe',30,'stackable','liquid','none',-1,-1,1956,0,'true','true','true','true','true','Recipes','0-0;'),
(2209,'Recipe: Eldarake','','false','recipe',30,'stackable','liquid','none',-1,-1,2660,0,'true','true','true','true','true','Recipes','0-0;'),
(2210,'Recipe: Steel Plate Helmet','','false','recipe',30,'stackable','liquid','none',-1,-1,4120,0,'true','true','true','true','true','Recipes','0-0;'),
(2211,'Recipe: Plated Leather Armor','','false','recipe',30,'stackable','liquid','none',-1,-1,8920,0,'true','true','true','true','true','Recipes','0-0;'),
(2212,'Recipe: Plated Leather Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,5580,0,'true','true','true','true','true','Recipes','0-0;'),
(2213,'Recipe: Dwarven Chain Mail Shirt','','false','recipe',30,'stackable','liquid','none',-1,-1,12880,0,'true','true','true','true','true','Recipes','0-0;'),
(2214,'Recipe: Dwarven Chain Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,8060,0,'true','true','true','true','true','Recipes','0-0;'),
(2215,'Recipe: Robe of Seal','','false','recipe',30,'stackable','liquid','none',-1,-1,15700,0,'true','true','true','true','true','Recipes','0-0;'),
(2216,'Recipe: Great Helmet','','false','recipe',30,'stackable','liquid','none',-1,-1,4840,0,'true','true','true','true','true','Recipes','0-0;'),
(2217,'Recipe: Knight\'s Shield','','false','recipe',30,'stackable','liquid','none',-1,-1,3380,0,'true','true','true','true','true','Recipes','0-0;'),
(2218,'Recipe: Pa\'agrian Hand','','false','recipe',30,'stackable','liquid','none',-1,-1,3220,0,'true','true','true','true','true','Recipes','0-0;'),
(2219,'Recipe: Crimson Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,3220,0,'true','true','true','true','true','Recipes','0-0;'),
(2220,'Recipe: Rind Leather Armor','','false','recipe',30,'stackable','liquid','none',-1,-1,9660,0,'true','true','true','true','true','Recipes','0-0;'),
(2221,'Recipe: Rind Leather Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,6040,0,'true','true','true','true','true','Recipes','0-0;'),
(2222,'Recipe: Composite Armor','','false','recipe',30,'stackable','liquid','none',-1,-1,32000,0,'true','true','true','true','true','Recipes','0-0;'),
(2223,'Recipe: Tower Shield','','false','recipe',30,'stackable','liquid','none',-1,-1,5160,0,'true','true','true','true','true','Recipes','0-0;'),
(2224,'Recipe: Demon\'s Tunic','','false','recipe',30,'stackable','liquid','none',-1,-1,14720,0,'true','true','true','true','true','Recipes','0-0;'),
(2225,'Recipe: Demon\'s Stockings','','false','recipe',30,'stackable','liquid','none',-1,-1,9200,0,'true','true','true','true','true','Recipes','0-0;'),
(2226,'Recipe: Mithril Gauntlets','','false','recipe',30,'stackable','liquid','none',-1,-1,4900,0,'true','true','true','true','true','Recipes','0-0;'),
(2227,'Recipe: Forgotten Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,4900,0,'true','true','true','true','true','Recipes','0-0;'),
(2228,'Recipe: Shining Circlet','','false','recipe',30,'stackable','liquid','none',-1,-1,7360,0,'true','true','true','true','true','Recipes','0-0;'),
(2229,'Recipe: Theca Leather Armor','','false','recipe',30,'stackable','liquid','none',-1,-1,16500,0,'true','true','true','true','true','Recipes','0-0;'),
(2230,'Recipe: Theca Leather Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,10320,0,'true','true','true','true','true','Recipes','0-0;'),
(2231,'Recipe: Full Plate Armor','','false','recipe',30,'stackable','liquid','none',-1,-1,46400,0,'true','true','true','true','true','Recipes','0-0;'),
(2232,'Recipe: Drake Leather Armor','','false','recipe',30,'stackable','liquid','none',-1,-1,34800,0,'true','true','true','true','true','Recipes','0-0;'),
(2233,'Recipe: Divine Tunic','','false','recipe',30,'stackable','liquid','none',-1,-1,21400,0,'true','true','true','true','true','Recipes','0-0;'),
(2234,'Recipe: Divine Stockings','','false','recipe',30,'stackable','liquid','none',-1,-1,13420,0,'true','true','true','true','true','Recipes','0-0;'),
(2235,'Recipe: Mithril Helmet','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','Recipes','0-0;'),
(2236,'Recipe: Cap of Mana','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','Recipes','0-0;'),
(2237,'Recipe: Paradia Hood','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','Recipes','0-0;'),
(2238,'Recipe: Hood of Solar Eclipse','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','Recipes','0-0;'),
(2239,'Recipe: Hood of Summoning','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','Recipes','0-0;'),
(2240,'Recipe: Elemental Hood','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','Recipes','0-0;'),
(2241,'Recipe: Hood of Grace','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','Recipes','0-0;'),
(2242,'Recipe: Phoenix Hood','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','Recipes','0-0;'),
(2243,'Recipe: Hood of Aid','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','Recipes','0-0;'),
(2244,'Recipe: Flame Helm','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','Recipes','0-0;'),
(2245,'Recipe: Tallum Helm','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','none','0-0;'),
(2246,'Recipe: Helm of Avadon','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','Recipes','0-0;'),
(2247,'Recipe: Helmet of Pledge','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','Recipes','0-0;'),
(2248,'Recipe: Gauntlets of Ghost','','false','recipe',30,'stackable','liquid','none',-1,-1,7160,0,'true','true','true','true','true','Recipes','0-0;'),
(2249,'Recipe: Adamantite Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,7160,0,'true','true','true','true','true','Recipes','0-0;'),
(2250,'Recipe: Bone Arrow','','false','recipe',30,'stackable','liquid','none',-1,-1,800,0,'true','true','true','true','true','Recipes','0-0;'),
(2251,'Recipe: Steel Arrow','','false','recipe',30,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','Recipes','0-0;'),
(2252,'Recipe: Iron Hammer','','false','recipe',30,'stackable','liquid','none',-1,-1,4880,0,'true','true','true','true','true','Recipes','0-0;'),
(2253,'Recipe: Sword Breaker','','false','recipe',30,'stackable','liquid','none',-1,-1,4880,0,'true','true','true','true','true','Recipes','0-0;'),
(2254,'Recipe: Composite Bow','','false','recipe',30,'stackable','liquid','none',-1,-1,4880,0,'true','true','true','true','true','Recipes','0-0;'),
(2255,'Recipe: Saber','','false','recipe',30,'stackable','liquid','none',-1,-1,8180,0,'true','true','true','true','true','Recipes','0-0;'),
(2256,'Recipe: Assassin Knife','','false','recipe',30,'stackable','liquid','none',-1,-1,8180,0,'true','true','true','true','true','Recipes','0-0;'),
(2257,'Recipe: Trident','','false','recipe',30,'stackable','liquid','none',-1,-1,8180,0,'true','true','true','true','true','Recipes','0-0;'),
(2258,'Recipe: Temptation of Abyss','','false','recipe',30,'stackable','liquid','none',-1,-1,8180,0,'true','true','true','true','true','Recipes','0-0;'),
(2259,'Recipe: Spinebone Sword','','false','recipe',30,'stackable','liquid','none',-1,-1,12880,0,'true','true','true','true','true','Recipes','0-0;'),
(2260,'Recipe: Mace of Judgment','','false','recipe',30,'stackable','liquid','none',-1,-1,12880,0,'true','true','true','true','true','Recipes','0-0;'),
(2261,'Recipe: Conjuror\'s Staff','','false','recipe',30,'stackable','liquid','none',-1,-1,12880,0,'true','true','true','true','true','Recipes','0-0;'),
(2262,'Recipe: Elven Bow','','false','recipe',30,'stackable','liquid','none',-1,-1,12880,0,'true','true','true','true','true','Recipes','0-0;'),
(2263,'Recipe: Dwarven Trident','','false','recipe',30,'stackable','liquid','none',-1,-1,12880,0,'true','true','true','true','true','Recipes','0-0;'),
(2264,'Recipe: Two-handed Sword','','false','recipe',30,'stackable','liquid','none',-1,-1,19340,0,'true','true','true','true','true','Recipes','0-0;'),
(2265,'Recipe: Spiked Club','','false','recipe',30,'stackable','liquid','none',-1,-1,19340,0,'true','true','true','true','true','Recipes','0-0;'),
(2266,'Recipe: Shilen Knife','','false','recipe',30,'stackable','liquid','none',-1,-1,19340,0,'true','true','true','true','true','Recipes','0-0;'),
(2267,'Recipe: Gastraphetes','','false','recipe',30,'stackable','liquid','none',-1,-1,19340,0,'true','true','true','true','true','Recipes','0-0;'),
(2268,'Recipe: Tome of Blood','','false','recipe',30,'stackable','liquid','none',-1,-1,19340,0,'true','true','true','true','true','Recipes','0-0;'),
(2269,'Recipe: Morning Star','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2270,'Recipe: Goat Head Staff','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2271,'Recipe: Winged Spear','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2272,'Recipe: Sword of Revolution','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2273,'Recipe: Tarbar','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2274,'Recipe: Skull Breaker','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2275,'Recipe: Heavy Bone Club','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2276,'Recipe: Maingauche','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2277,'Recipe: Bich\'hwa','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2278,'Recipe: Strengthened Long Bow','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2279,'Recipe: War Pick','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2280,'Recipe: Crucifix of Blood','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2281,'Recipe: Eye of Infinity','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2282,'Recipe: Cursed Maingauche','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(2283,'Recipe: Blue Crystal Skull','','false','recipe',30,'stackable','liquid','none',-1,-1,30400,0,'true','true','true','true','true','Recipes','0-0;'),
(2284,'Recipe: Demon Fangs','','false','recipe',30,'stackable','liquid','none',-1,-1,30400,0,'true','true','true','true','true','Recipes','0-0;'),
(2285,'Recipe: Claymore','','false','recipe',30,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','Recipes','0-0;'),
(2286,'Recipe: Bonebreaker','','false','recipe',30,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','Recipes','0-0;'),
(2287,'Recipe: Atuba Hammer','','false','recipe',30,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','Recipes','0-0;'),
(2288,'Recipe: Ghost Staff','','false','recipe',30,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','Recipes','0-0;'),
(2289,'Recipe: Staff of Life','','false','recipe',30,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','Recipes','0-0;'),
(2290,'Recipe: Mithril Dagger','','false','recipe',30,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','Recipes','0-0;'),
(2291,'Recipe: Scallop Jamadhr','','false','recipe',30,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','Recipes','0-0;'),
(2292,'Recipe: Light Crossbow','','false','recipe',30,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','Recipes','0-0;'),
(2293,'Recipe: Glaive','','false','recipe',30,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','Recipes','0-0;'),
(2294,'Recipe: Vajra Wands','','false','recipe',30,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','Recipes','0-0;'),
(2295,'Recipe: Ancient Reagent','','false','recipe',30,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','Recipes','0-0;'),
(2296,'Recipe: Atuba Mace','','false','recipe',30,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','Recipes','0-0;'),
(2297,'Recipe: Flamberge','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2298,'Recipe: Stormbringer','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2299,'Recipe: Big Hammer','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2300,'Recipe: Scythe','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2301,'Recipe: Battle Axe','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2302,'Recipe: Silver Axe','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2303,'Recipe: Skull Graver','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2304,'Recipe: Heavy Doom Hammer','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2305,'Recipe: Crystal Staff','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2306,'Recipe: Stick of Faith','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2307,'Recipe: Heavy Doom Axe','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2308,'Recipe: Cursed Dagger','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2309,'Recipe: Wolverine Needle','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2310,'Recipe: Dark Elven Dagger','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2311,'Recipe: Chakram','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2312,'Recipe: Crystallized Ice Bow','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2313,'Recipe: Orcish Glaive','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2314,'Recipe: Body Slasher','','false','recipe',30,'stackable','liquid','none',-1,-1,45800,0,'true','true','true','true','true','Recipes','0-0;'),
(2315,'Recipe: Shamshir','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(2316,'Recipe: Katana','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(2317,'Recipe: Bec de Corbin','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(2318,'Recipe: Spirit Sword','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(2319,'Recipe: Raid Sword','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(2320,'Recipe: Cursed Staff','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(2321,'Recipe: Stiletto','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(2322,'Recipe: Soulfire Dirk','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(2323,'Recipe: Elemental Bow','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(2324,'Recipe: Elven Bow of Nobility','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(2325,'Recipe: Tears of Fairy','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(2326,'Recipe: Horn of Glory','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(2327,'Recipe: Caliburs','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2328,'Recipe: Sword of Delusion','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2329,'Recipe: Tsurugi','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2330,'Recipe: Homunkulus\'s Sword','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2331,'Recipe: Poleaxe','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2332,'Recipe: Sword of Limit','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2333,'Recipe: Sword of Nightmare','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2334,'Recipe: Sword of Whispering Death','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2335,'Recipe: War Axe','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2336,'Recipe: Nirvana Axe','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2337,'Recipe: Stick of Eternity','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2338,'Recipe: Paradia Staff','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2339,'Recipe: Inferno Staff','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2340,'Recipe: Pa\'agrian Hammer','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2341,'Recipe: Sage\'s Staff','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2342,'Recipe: Club of Nature','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2343,'Recipe: Mace of the Underworld','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2344,'Recipe: Grace Dagger','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2345,'Recipe: Dark Screamer','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2346,'Recipe: Fisted Blade','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2347,'Recipe: Akat Long Bow','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2348,'Recipe: Heathen\'s Book','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2349,'Recipe: Hex Doll','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(2350,'Recipe: Pa\'agrian Axe','','false','recipe',30,'stackable','liquid','none',-1,-1,95600,0,'true','true','true','true','true','Recipes','0-0;'),
(2351,'Recipe: Scorpion','','false','recipe',30,'stackable','liquid','none',-1,-1,95600,0,'true','true','true','true','true','Recipes','0-0;'),
(2352,'Recipe: Widow Maker','','false','recipe',30,'stackable','liquid','none',-1,-1,95600,0,'true','true','true','true','true','Recipes','0-0;'),
(2353,'Recipe: Samurai Longsword','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2354,'Recipe: Deadman\'s Staff','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2355,'Recipe: Ghoul\'s Staff','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2356,'Recipe: Demon\'s Staff','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2357,'Recipe: Crystal Dagger','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2358,'Recipe: Great Pata','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2359,'Recipe: Eminence Bow','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2360,'Recipe: Orcish Poleaxe','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2361,'Recipe: Candle of Wisdom','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2362,'Recipe: Blessed Branch','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2363,'Recipe: Phoenix Feather','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2364,'Recipe: Cerberus Eye','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2365,'Recipe: Scroll of Destruction','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2366,'Recipe: Claws of Black Dragon','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2367,'Recipe: Three Eyed Crow\'s Feather','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(2375,'Wolf Collar','','false','pet_collar',10,'normal','leather','none',-1,-1,0,0,'true','true','true','true','true','SummonItems','0-0;'),
(2508,'Cursed Bone','','false','material',3,'stackable','liquid','none',-1,-1,300,0,'true','true','true','true','true','none','0-0;'),
(2509,'Spiritshot: No Grade','','false','shot',5,'stackable','paper','none',-1,-1,15,0,'true','true','true','true','true','SpiritShot','2061-1;'),
(2510,'Spiritshot: D-grade','','false','shot',5,'stackable','paper','d',-1,-1,18,0,'true','true','true','true','true','SpiritShot','2155-1;'),
(2511,'Spiritshot: C-grade','','false','shot',3,'stackable','paper','c',-1,-1,35,0,'true','true','true','true','true','SpiritShot','2156-1;'),
(2512,'Spiritshot: B-grade','','false','shot',3,'stackable','paper','b',-1,-1,100,0,'true','true','true','true','true','SpiritShot','2157-1;'),
(2513,'Spiritshot: A-grade','','false','shot',2,'stackable','paper','a',-1,-1,120,0,'true','true','true','true','true','SpiritShot','2158-1;'),
(2514,'Spiritshot: S-grade','','false','shot',2,'stackable','paper','s',-1,-1,150,0,'true','true','true','true','true','SpiritShot','2159-1;'),
(2515,'Food For Wolves','','false','none',10,'stackable','liquid','none',-1,-1,108,0,'true','true','true','true','true','PetFood','2048-1;'),
(2627,'Mark of Challenger','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2628,'Letter of Kash','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2629,'Watcher\'s 1st Eye','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2630,'Watcher\'s 2nd Eye','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2631,'Scroll of Shyslassys','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2632,'Broken Key','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2633,'Mark of Duty','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2634,'Letter of Dustin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2635,'Knights Tear','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2636,'Mirror of Orpic','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2637,'Tear of Confession','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2638,'Report Piece','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2639,'Report Piece','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2640,'Tear of Loyalty','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2641,'Militas Article','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2642,'Saints Ashes Urn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2643,'Athebaldt\'s Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2644,'Athebaldt\'s Ribs','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2645,'Athebaldt\'s Shin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2646,'Letter of Windawood','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2647,'Dufners Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2648,'Terry\'s 1st Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2649,'Terry\'s 2nd Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2650,'Terry\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2651,'Viktor\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2652,'Hawkeye\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2653,'Mysterious Spirit Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2654,'Ol Mahum Spirit Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2655,'Turek Spirit Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2656,'Ant Spirit Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2657,'Turak Bugbear Spirit Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2658,'Terry\'s Box','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2659,'Viktor\'s Request','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2660,'Medusa Scales','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2661,'Shilen\'s Spirit Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2662,'Analysis Request','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2663,'Marina\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2664,'Experiment Tools','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2665,'Analysis Result','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2666,'Terry\'s 3rd Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2667,'List of Host','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2668,'Abyss Spirit Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2669,'Abyss Spirit Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2670,'Abyss Spirit Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2671,'Abyss Spirit Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2672,'Terry\'s Report','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2673,'Mark of Seeker','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2674,'Mark of Scholar','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2675,'Mirien\'s 1st Sigil','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2676,'Mirien\'s 2nd Sigil','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2677,'Mirien\'s 3rd Sigil','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2678,'Mirien\'s Instruction','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2679,'Maria\'s 1st Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2680,'Maria\'s 2nd Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2681,'Lucas\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2682,'Lucilla\'s Handbag','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2683,'Creta\'s 1st Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2684,'Creta\'s Painting1','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2685,'Creta\'s Painting2','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2686,'Creta\'s Painting3','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2687,'Brown Scroll Scrap','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2688,'Crystal of Purity','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2689,'High Priest\'s Sigil','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2690,'Grand Magister\'s Sigil','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2691,'Crono\'s Sigil','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2692,'Sylvain\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2693,'Symbol of Sylvain','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2694,'Jurek\'s List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2695,'Monster Eye Destroyer Skin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2696,'Shaman\'s Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2697,'Shackle\'s Scalp','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2698,'Symbol of Jurek','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;');

INSERT INTO `etcitem` VALUES
(2699,'Cronos Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2700,'Dieter\'s Key','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2701,'Creta\'s 2nd Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2702,'Dieter\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2703,'Dieter\'s Diary','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2704,'Raut\'s Letter Envelope','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2705,'Triff\'s Ring','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2706,'Scripture Chapter 1','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2707,'Scripture Chapter 2','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2708,'Scripture Chapter 3','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2709,'Scripture Chapter 4','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2710,'Valkon\'s Request','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2711,'Poitan\'s Notes','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2712,'Scriptures of Knowledge','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2713,'Strong Liquor','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2714,'Crystal of Purity','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2715,'Casian\'s List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2716,'Ghoul\'s Skin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2717,'Medusa\'s Blood','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2718,'Fettered Soul\'s Ichor','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2719,'Enchanted Gargoyle\'s Nail','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2720,'Symbol of Cronos','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2721,'Mark of Pilgrim','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2722,'Book of Sage','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2723,'Voucher of Trial','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2724,'Spirit of Flame','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2725,'Essence of Flame','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2726,'Book of Gerald','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2727,'Gray Badge','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2728,'Picture of Nahir','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2729,'Hair of Nahir','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2730,'Statue of Einhasad','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2731,'Book of Darkness','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2732,'Debris of Willow','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2733,'Tag of Rumor','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2734,'Mark of Trust','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2735,'Letter to Elf','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2736,'Letter to Darkelf','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2737,'Letter to Dwarf','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2738,'Letter to Orc','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2739,'Letter to Seresin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2740,'Scroll of Dark Elf Trust','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2741,'Scroll of Elf Trust','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2742,'Scroll of Dwarf Trust','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2743,'Scroll of Orc Trust','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2744,'Recommendation of Hollint','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2745,'Order of Asterios','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2746,'Breath of Winds','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2747,'Seed of Verdure','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2748,'Letter from Thifiell','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2749,'Blood of Guardian Basilisk','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2750,'Giant Aphid','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2751,'Stakatos Fluids','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2752,'Basilisk Plasma','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2753,'Honey Dew','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2754,'Stakato Ichor','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2755,'Order of Clayton','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2756,'Parasite of Lota','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2757,'Letter to Manakia','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2758,'Letter of Manakia','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2759,'Letter to Nikola','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2760,'Order of Nikola','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2761,'Heartstone of Porta','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2762,'Mark of Duelist','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2763,'Order Gludio','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2764,'Order Dion','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2765,'Order Giran','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2766,'Order Oren','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2767,'Order Aden','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2768,'Puncher\'s Shard','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2769,'Noble Ant\'s Feeler','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2770,'Drone\'s Chitin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2771,'Dead Seeker Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2772,'Overlord Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2773,'Fettered Soul\'s Chain','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2774,'Chief\'s Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2775,'Enchanted Eye Meat','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2776,'Tamrin Orc\'s Ring','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2777,'Tamrin Orc\'s Arrow','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2778,'Final Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2779,'Excuro\'s Skin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2780,'Krator\'s Shard','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2781,'Grandi\'s Skin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2782,'Timak Orc\'s Belt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2783,'Lakin\'s Mace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2784,'Luther\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2785,'Alex\'s Warrant','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2786,'Leirynn\'s 1st Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2787,'Delu Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2788,'Leirynn\'s 2nd Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2789,'Chief Kalki\'s Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2790,'Leirynn\'s Report','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2791,'Strange Map','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2792,'Lambert\'s Map','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2793,'Alex\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2794,'Alex\'s Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2795,'Wine Catalog','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2796,'Tyra\'s Contract','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2797,'Red Spore Dust','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2798,'Malrukian Wine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2799,'Old Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2800,'Jax\'s Diary','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2801,'1st Torn Map Piece','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2802,'2nd Torn Map Piece','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2803,'Solt\'s Map','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2804,'Makel\'s Map','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2805,'Combined Map','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2806,'Rusted Key','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2807,'Gold Bar','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2808,'Alex\'s Recommend','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2809,'Mark of Searcher','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2810,'Report of Perrin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2811,'Kristina\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2812,'Picture of Windy','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2813,'Golden Statue','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2814,'Windy\'s Pebbles','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2815,'Order of Sorius','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2816,'1st Secret Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2817,'2nd Secret Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2818,'3rd Secret Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2819,'4th Secret Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2820,'Mark of Healer','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2821,'Mark of Reformer','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2822,'Book of Reform','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2823,'Letter of Introduction','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2824,'Sla\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2825,'Greetings','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2826,'Ol Mahum\'s Money','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2827,'Katari\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2828,'Nyakuri\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2829,'Undead List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2830,'Ramus\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2831,'Ripped Diary','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2832,'Huge Nail','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2833,'Letter of Betrayer','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2834,'Bone Fragment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2835,'Bone Fragment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2836,'Bone Fragment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2837,'Bone Fragment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2838,'Bone Fragment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2839,'Bone Fragment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2840,'Mark of Magus','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2841,'Rukal\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2842,'Parina\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2843,'Lilac Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2844,'1st Golden Seed','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2845,'2nd Golden Seed','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2846,'3rd Golden Seed','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2847,'Score of Elements','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2848,'Dazzling Drop','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2849,'Flame Crystal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2850,'Harpy\'s Feather','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2851,'Wyrm\'s Wingbone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2852,'Windsus Mane','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2853,'Enchanted Monster Eye Shell','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2854,'Enchanted Stone Golem Powder','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2855,'Enchanted Iron Golem Scrap','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2856,'Tone of Water','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2857,'Tone of Fire','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2858,'Tone of Wind','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2859,'Tone of Earth','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2860,'Salamander Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2861,'Sylph Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2862,'Undine Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2863,'Serpent Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2864,'Recommendation of Balanki','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2865,'Recommendation of Filaur','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2866,'Recommendation of Arin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2867,'Mark of Maestro','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2868,'Letter of Solder Detachment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2869,'Paint of Kamuru','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2870,'Necklace of Kamuru','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2871,'Paint of Teleport Device','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2872,'Teleport Device','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','false','false','false','none','0-0;'),
(2873,'Architecture of Cruma','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2874,'Report of Cruma','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2875,'Ingredients of Antidote','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2876,'Stinger Wasp Needle','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2877,'Marsh Spider\'s Web','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2878,'Blood of Leech','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2879,'Mark of Warspirit','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2880,'Vendetta Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2881,'Tamlin Orc Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2882,'Warspirit Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2883,'Orim\'s Contract','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2884,'Porta\'s Eye','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2885,'Excuro\'s Scale','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2886,'Mordeos Talon','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2887,'Braki\'s Remains','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2888,'Pekiron\'s Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2889,'Tonar\'s Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2890,'Tonar\'s Rib Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2891,'Tonar\'s Spine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2892,'Tonar\'s Arm Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2893,'Tonar\'s Thigh Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2894,'Tonar\'s Remains','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2895,'Manakia\'s Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2896,'Hermodt\'s Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2897,'Hermodt\'s Rib Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2898,'Hermodt\'s Spine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2899,'Hermodt\'s Arm Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2900,'Hermodt\'s Thigh Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2901,'Hermodt\'s Remains','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2902,'Racoy\'s Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2903,'Vivyan\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2904,'Insect Diagram Book','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2905,'Kiruna\'s Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2906,'Kiruna\'s Rib Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2907,'Kiruna\'s Spine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2908,'Kiruna\'s Arm Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2909,'Kiruna\'s Thigh Bone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2910,'Kiruna\'s Remains','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2911,'Braki\'s Remains','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2912,'Tonar\'s Remains','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2913,'Hermodt\'s Remains','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2914,'Kiruna\'s Remains','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2916,'Broken Teleport Device','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(2917,'Ring of Binding Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,3482,0,'true','true','true','true','true','none','0-0;'),
(2918,'Mithril Scale Gaiters Material','','false','material',60,'stackable','liquid','none',-1,-1,3371,0,'true','true','true','true','true','none','0-0;'),
(2919,'Brigandine Gaiters Material','','false','material',60,'stackable','liquid','none',-1,-1,3371,0,'true','true','true','true','true','none','0-0;'),
(2920,'Elven Mithril Tunic Pattern','','false','material',60,'stackable','liquid','none',-1,-1,3921,0,'true','true','true','true','true','none','0-0;'),
(2921,'Elven Mithril Stockings Pattern','','false','material',60,'stackable','liquid','none',-1,-1,2518,0,'true','true','true','true','true','none','0-0;'),
(2922,'Brigandine Helmet Design','','false','material',60,'stackable','liquid','none',-1,-1,5193,0,'true','true','true','true','true','none','0-0;'),
(2923,'Manticore Skin Boot Lining','','false','material',60,'stackable','liquid','none',-1,-1,1480,0,'true','true','true','true','true','none','0-0;'),
(2924,'Brigandine Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,1480,0,'true','true','true','true','true','none','0-0;'),
(2925,'Elven Mithril Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,1480,0,'true','true','true','true','true','none','0-0;'),
(2926,'Manticore Skin Gloves Lining','','false','material',60,'stackable','liquid','none',-1,-1,1480,0,'true','true','true','true','true','none','0-0;'),
(2927,'Brigandine Gauntlets Pattern','','false','material',60,'stackable','liquid','none',-1,-1,1480,0,'true','true','true','true','true','none','0-0;'),
(2928,'Mithril Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,1480,0,'true','true','true','true','true','none','0-0;'),
(2929,'Brigandine Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,1389,0,'true','true','true','true','true','none','0-0;'),
(2930,'Plate Helmet Design','','false','material',60,'stackable','liquid','none',-1,-1,2481,0,'true','true','true','true','true','none','0-0;'),
(2931,'Salamander Skin Boot Lining','','false','material',60,'stackable','liquid','none',-1,-1,1792,0,'true','true','true','true','true','none','0-0;'),
(2932,'Plate Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,1792,0,'true','true','true','true','true','none','0-0;'),
(2933,'Sage\'s Worn Gloves Lining','','false','material',60,'stackable','liquid','none',-1,-1,1792,0,'true','true','true','true','true','none','0-0;'),
(2934,'Plate Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,1762,0,'true','true','true','true','true','none','0-0;'),
(2935,'Tempered Mithril Gaiters Fragment','','false','material',60,'stackable','liquid','none',-1,-1,3763,0,'true','true','true','true','true','none','0-0;'),
(2936,'Chain Hood Pattern','','false','material',60,'stackable','liquid','none',-1,-1,2725,0,'true','true','true','true','true','none','0-0;'),
(2937,'Chain Boots Part','','false','material',60,'stackable','liquid','none',-1,-1,2225,0,'true','true','true','true','true','none','0-0;'),
(2938,'Karmian Boots Fabric','','false','material',60,'stackable','liquid','none',-1,-1,2225,0,'true','true','true','true','true','none','0-0;'),
(2939,'Plate Leather Boot Lining','','false','material',60,'stackable','liquid','none',-1,-1,2225,0,'true','true','true','true','true','none','0-0;'),
(2940,'Dwarven Chain Boots Part','','false','material',60,'stackable','liquid','none',-1,-1,2225,0,'true','true','true','true','true','none','0-0;'),
(2941,'Boots of Seal Pattern','','false','material',60,'stackable','liquid','none',-1,-1,2225,0,'true','true','true','true','true','none','0-0;'),
(2942,'Reinforced Mithril Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,2225,0,'true','true','true','true','true','none','0-0;'),
(2943,'Chain Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,2225,0,'true','true','true','true','true','none','0-0;'),
(2944,'Karmian Gloves Fabric','','false','material',60,'stackable','liquid','none',-1,-1,2225,0,'true','true','true','true','true','none','0-0;'),
(2945,'Chain Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,2475,0,'true','true','true','true','true','none','0-0;'),
(2946,'Plate Leather Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,3578,0,'true','true','true','true','true','none','0-0;'),
(2947,'Dwarven Chain Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','none','0-0;'),
(2948,'Rind Leather Boot Lining','','false','material',60,'stackable','liquid','none',-1,-1,2378,0,'true','true','true','true','true','none','0-0;'),
(2949,'Dwarven Chain Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,2378,0,'true','true','true','true','true','none','0-0;'),
(2950,'Gloves of Seal Pattern','','false','material',60,'stackable','liquid','none',-1,-1,2378,0,'true','true','true','true','true','none','0-0;'),
(2951,'Rind Leather Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,2378,0,'true','true','true','true','true','none','0-0;'),
(2952,'Demon\'s Boots Fabric','','false','material',60,'stackable','liquid','none',-1,-1,3400,0,'true','true','true','true','true','none','0-0;'),
(2953,'Demon\'s Gloves Fabric','','false','material',60,'stackable','liquid','none',-1,-1,3400,0,'true','true','true','true','true','none','0-0;'),
(2954,'Theca Leather Boots Texture','','false','material',60,'stackable','liquid','none',-1,-1,3160,0,'true','true','true','true','true','none','0-0;'),
(2955,'Theca Leather Gloves Texture','','false','material',60,'stackable','liquid','none',-1,-1,3160,0,'true','true','true','true','true','none','0-0;'),
(2956,'Composite Boots Part','','false','material',60,'stackable','liquid','none',-1,-1,3400,0,'true','true','true','true','true','none','0-0;'),
(2957,'Composite Helmet Design','','false','material',60,'stackable','liquid','none',-1,-1,4560,0,'true','true','true','true','true','none','0-0;'),
(2958,'Divine Boots Fabric','','false','material',60,'stackable','liquid','none',-1,-1,3673,0,'true','true','true','true','true','none','0-0;'),
(2959,'Full Plate Helmet Design','','false','material',60,'stackable','liquid','none',-1,-1,5782,0,'true','true','true','true','true','none','0-0;'),
(2960,'Drake Leather Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,3673,0,'true','true','true','true','true','none','0-0;'),
(2961,'Full Plate Boots Part','','false','material',60,'stackable','liquid','none',-1,-1,3673,0,'true','true','true','true','true','none','0-0;'),
(2962,'Drake Leather Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,3673,0,'true','true','true','true','true','none','0-0;'),
(2963,'Full Plate Gauntlets Part','','false','material',60,'stackable','liquid','none',-1,-1,3673,0,'true','true','true','true','true','none','0-0;'),
(2964,'Divine Gloves Pattern','','false','material',60,'stackable','liquid','none',-1,-1,3673,0,'true','true','true','true','true','none','0-0;'),
(2965,'Blessed Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,3673,0,'true','true','true','true','true','none','0-0;'),
(2966,'Full Plate Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,3655,0,'true','true','true','true','true','none','0-0;'),
(2967,'Elven Long Sword Blade','','false','material',60,'stackable','liquid','none',-1,-1,23062,0,'true','true','true','true','true','none','0-0;'),
(2968,'Dwarven Warhammer Head','','false','material',60,'stackable','liquid','none',-1,-1,30067,0,'true','true','true','true','true','none','0-0;'),
(2969,'Yaksa Mace Head','','false','material',60,'stackable','liquid','none',-1,-1,38364,0,'true','true','true','true','true','none','0-0;'),
(2970,'Recipe: Ring of Binding','','false','recipe',30,'stackable','liquid','none',-1,-1,5640,0,'true','true','true','true','true','Recipes','0-0;'),
(2971,'Recipe: Mithril Scale Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,3740,0,'true','true','true','true','true','Recipes','0-0;'),
(2972,'Recipe: Brigandine Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,3740,0,'true','true','true','true','true','Recipes','0-0;'),
(2973,'Recipe: Elven Mithril Tunic','','false','recipe',30,'stackable','liquid','none',-1,-1,4480,0,'true','true','true','true','true','Recipes','0-0;'),
(2974,'Recipe: Elven Mithril Stockings','','false','recipe',30,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','Recipes','0-0;'),
(2975,'Recipe: Brigandine Helmet','','false','recipe',30,'stackable','liquid','none',-1,-1,2240,0,'true','true','true','true','true','Recipes','0-0;'),
(2976,'Recipe: Manticore Skin Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,1494,0,'true','true','true','true','true','Recipes','0-0;'),
(2977,'Recipe: Brigandine Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,1494,0,'true','true','true','true','true','Recipes','0-0;'),
(2978,'Recipe: Elven Mithril Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,1494,0,'true','true','true','true','true','Recipes','0-0;'),
(2979,'Recipe: Manticore Skin Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,1494,0,'true','true','true','true','true','Recipes','0-0;'),
(2980,'Recipe: Brigandine Gauntlets','','false','recipe',30,'stackable','liquid','none',-1,-1,1494,0,'true','true','true','true','true','Recipes','0-0;'),
(2981,'Recipe: Mithril Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,1494,0,'true','true','true','true','true','Recipes','0-0;'),
(2982,'Recipe: Brigandine Shield','','false','recipe',30,'stackable','liquid','none',-1,-1,1568,0,'true','true','true','true','true','Recipes','0-0;'),
(2983,'Recipe: Plate Helmet','','false','recipe',30,'stackable','liquid','none',-1,-1,2940,0,'true','true','true','true','true','Recipes','0-0;'),
(2984,'Recipe: Salamander Skin Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,1956,0,'true','true','true','true','true','Recipes','0-0;'),
(2985,'Recipe: Plate Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,1956,0,'true','true','true','true','true','Recipes','0-0;'),
(2986,'Recipe: Sage\'s Worn Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,1956,0,'true','true','true','true','true','Recipes','0-0;'),
(2987,'Recipe: Plate Shield','','false','recipe',30,'stackable','liquid','none',-1,-1,2060,0,'true','true','true','true','true','Recipes','0-0;'),
(2988,'Recipe: Tempered Mithril Gaiters','','false','recipe',30,'stackable','liquid','none',-1,-1,4740,0,'true','true','true','true','true','Recipes','0-0;'),
(2989,'Recipe: Chain Hood','','false','recipe',30,'stackable','liquid','none',-1,-1,3780,0,'true','true','true','true','true','Recipes','0-0;'),
(2990,'Recipe: Chain Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,2520,0,'true','true','true','true','true','Recipes','0-0;'),
(2991,'Recipe: Karmian Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,2520,0,'true','true','true','true','true','Recipes','0-0;'),
(2992,'Recipe: Plated Leather Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,2520,0,'true','true','true','true','true','Recipes','0-0;'),
(2993,'Recipe: Dwarven Chain Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,2520,0,'true','true','true','true','true','Recipes','0-0;'),
(2994,'Recipe: Boots of Seal','','false','recipe',30,'stackable','liquid','none',-1,-1,2520,0,'true','true','true','true','true','Recipes','0-0;'),
(2995,'Recipe: Reinforced Mithril Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,2520,0,'true','true','true','true','true','Recipes','0-0;'),
(2996,'Recipe: Chain Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,2520,0,'true','true','true','true','true','Recipes','0-0;'),
(2997,'Recipe: Karmian Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,2520,0,'true','true','true','true','true','Recipes','0-0;'),
(2998,'Recipe: Chain Shield','','false','recipe',30,'stackable','liquid','none',-1,-1,2660,0,'true','true','true','true','true','Recipes','0-0;'),
(2999,'Recipe: Plated Leather Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,2980,0,'true','true','true','true','true','Recipes','0-0;'),
(3000,'Recipe: Dwarven Chain Shield','','false','recipe',30,'stackable','liquid','none',-1,-1,3120,0,'true','true','true','true','true','Recipes','0-0;'),
(3001,'Recipe: Rind Leather Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,3220,0,'true','true','true','true','true','Recipes','0-0;'),
(3002,'Recipe: Dwarven Chain Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,3220,0,'true','true','true','true','true','Recipes','0-0;'),
(3003,'Recipe: Gloves of Seal','','false','recipe',30,'stackable','liquid','none',-1,-1,3220,0,'true','true','true','true','true','Recipes','0-0;'),
(3004,'Recipe: Rind Leather Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,3220,0,'true','true','true','true','true','Recipes','0-0;'),
(3005,'Recipe: Demon\'s Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,4900,0,'true','true','true','true','true','Recipes','0-0;'),
(3006,'Recipe: Demon\'s Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,4900,0,'true','true','true','true','true','Recipes','0-0;'),
(3007,'Recipe: Theca Leather Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,5500,0,'true','true','true','true','true','Recipes','0-0;'),
(3008,'Recipe: Theca Leather Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,5500,0,'true','true','true','true','true','Recipes','0-0;'),
(3009,'Recipe: Composite Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,4900,0,'true','true','true','true','true','Recipes','0-0;'),
(3010,'Recipe: Composite Helmet','','false','recipe',30,'stackable','liquid','none',-1,-1,7360,0,'true','true','true','true','true','Recipes','0-0;'),
(3011,'Recipe: Divine Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,7160,0,'true','true','true','true','true','Recipes','0-0;'),
(3012,'Recipe: Full Plate Helmet','','false','recipe',30,'stackable','liquid','none',-1,-1,10720,0,'true','true','true','true','true','Recipes','0-0;'),
(3013,'Recipe: Drake Leather Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,7160,0,'true','true','true','true','true','Recipes','0-0;'),
(3014,'Recipe: Full Plate Boots','','false','recipe',30,'stackable','liquid','none',-1,-1,7160,0,'true','true','true','true','true','Recipes','0-0;'),
(3015,'Recipe: Drake Leather Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,7160,0,'true','true','true','true','true','Recipes','0-0;'),
(3016,'Recipe: Full Plate Gauntlets','','false','recipe',30,'stackable','liquid','none',-1,-1,7160,0,'true','true','true','true','true','Recipes','0-0;'),
(3017,'Recipe: Divine Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,7160,0,'true','true','true','true','true','Recipes','0-0;'),
(3018,'Recipe: Blessed Gloves','','false','recipe',30,'stackable','liquid','none',-1,-1,7160,0,'true','true','true','true','true','Recipes','0-0;'),
(3019,'Recipe: Full Plate Shield','','false','recipe',30,'stackable','liquid','none',-1,-1,7500,0,'true','true','true','true','true','Recipes','0-0;'),
(3020,'Recipe: Elven Long Sword','','false','recipe',30,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','Recipes','0-0;'),
(3021,'Recipe: Dwarven War Hammer','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(3022,'Recipe: Yaksa Mace','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(3023,'Recipe: Titan Key','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'false','false','false','false','false','Recipes','0-0;'),
(3024,'Recipe: Journeyman Ring','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'false','false','false','false','false','Recipes','0-0;'),
(3025,'Recipe: Amber Bead','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'false','false','false','false','false','Recipes','0-0;'),
(3030,'Key of Titan','','false','none',10,'stackable','bronze','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3031,'Spirit Ore','','false','material',5,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(3032,'Recipe: Spiritshot D','','false','recipe',30,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','Recipes','0-0;'),
(3033,'Recipe: Spiritshot C','','false','recipe',30,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','Recipes','0-0;'),
(3034,'Recipe: Spiritshot B','','false','recipe',30,'stackable','liquid','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(3035,'Recipe: Spiritshot A','','false','recipe',30,'stackable','liquid','none',-1,-1,150000,0,'true','true','true','true','true','Recipes','0-0;'),
(3036,'Recipe: Spiritshot S','','false','recipe',30,'stackable','liquid','none',-1,-1,450000,0,'true','true','true','true','true','Recipes','0-0;'),
(3037,'Kakan\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3038,'Blueprint: Summon Mechanic Golem','','false','spellbook',120,'stackable','paper','none',-1,-1,1550,0,'true','true','true','true','true','Recipes','0-0;'),
(3039,'Spellbook: Summon Storm Cubic','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3040,'Spellbook: Summon Vampiric Cubic','','false','spellbook',120,'stackable','paper','none',-1,-1,3700,0,'true','true','true','true','true','none','0-0;'),
(3041,'Spellbook: Summon Phantom Cubic','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3042,'Spellbook: Life Scavenge','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3043,'Spellbook: Holy Strike','','false','spellbook',120,'stackable','paper','none',-1,-1,4250,0,'true','true','true','true','true','none','0-0;'),
(3044,'Spellbook: Horror','','false','spellbook',120,'stackable','paper','none',-1,-1,4250,0,'true','true','true','true','true','none','0-0;'),
(3045,'Spellbook: Summon Life Cubic','','false','spellbook',120,'stackable','paper','none',-1,-1,3700,0,'true','true','true','true','true','none','0-0;'),
(3046,'Spellbook: Sacrifice','','false','spellbook',120,'stackable','paper','none',-1,-1,5400,0,'true','true','true','true','true','none','0-0;'),
(3047,'Spellbook: Iron Will','','false','spellbook',120,'stackable','paper','none',-1,-1,3700,0,'true','true','true','true','true','none','0-0;'),
(3048,'Spellbook: Reflect Damage','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3049,'Spellbook: Corpse Plague','','false','spellbook',120,'stackable','paper','none',-1,-1,4250,0,'true','true','true','true','true','none','0-0;'),
(3050,'Spellbook: Hex','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3051,'Spellbook: Spirit Barrier','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3052,'Spellbook: Hamstring','','false','spellbook',120,'stackable','paper','none',-1,-1,3700,0,'true','true','true','true','true','none','0-0;'),
(3053,'Spellbook: Holy Blessing','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3054,'Spellbook: Summon Viper Cubic','','false','spellbook',120,'stackable','paper','none',-1,-1,4800,0,'true','true','true','true','true','none','0-0;'),
(3055,'Spellbook: Lightning Strike','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(3056,'Spellbook: Summon Dark Panther','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3057,'Spellbook: Summon Reanimated Man','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3058,'Spellbook: Summon Corrupted Man','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3059,'Spellbook: Corpse Burst','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(3060,'Spellbook: Forget','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3061,'Spellbook: Curse Discord','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3062,'Spellbook: Curse Fear','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3063,'Spellbook: Anchor','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3064,'Spellbook: Silence','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3065,'Spellbook: Death Spike','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3066,'Spellbook: Curse Death Link','','false','spellbook',120,'stackable','paper','none',-1,-1,5400,0,'true','true','true','true','true','none','0-0;'),
(3067,'Spellbook: Vampiric Claw','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3068,'Spellbook: Vitalize','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(3069,'Spellbook: Repose','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3070,'Spellbook: Hold Undead','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(3071,'Spellbook: Requiem','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3072,'Spellbook: Purify','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3073,'Spellbook: Might of Heaven','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3074,'Spellbook: Surrender to Wind','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3075,'Spellbook: Blazing Circle','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3076,'Spellbook: Prominence','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3077,'Spellbook: Blazing Skin','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3078,'Spellbook: Decay','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(3079,'Spellbook: Cancel','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(3080,'Spellbook: Sleeping Cloud','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3081,'Spellbook: Aura Flare','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3082,'Spellbook: Surrender to Water','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3083,'Spellbook: Frost Wall','','false','spellbook',120,'stackable','paper','none',-1,-1,5400,0,'true','true','true','true','true','none','0-0;'),
(3084,'Spellbook: Freezing Shackle','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3085,'Spellbook: Hydro Blast','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3086,'Spellbook: Frost Bolt','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3087,'Spellbook: Ice Dagger','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3088,'Spellbook: Freezing Skin','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3089,'Spellbook: Tempest','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(3090,'Spellbook: Hurricane','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3091,'Spellbook: Servitor Magic Shield','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3092,'Spellbook: Servitor Physical Shield','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3093,'Spellbook: Servitor Haste','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3094,'Spellbook: Invigor','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3095,'Spellbook: Magic Barrier','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3096,'Spellbook: Blessed Body','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3097,'Spellbook: Blessed Soul','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3098,'Spellbook: Return','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3099,'Spellbook: Haste','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3100,'Spellbook: Guidance','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3101,'Spellbook: Death Whisper','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3102,'Spellbook: Bless Shield','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3103,'Amulet: Pa\'agrio\'s Wisdom','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3104,'Amulet: Pa\'agrio\'s Glory','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3105,'Amulet: Seal of Winter','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3106,'Amulet: Seal of Flame','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(3107,'Amulet: Seal of Gloom','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3108,'Amulet: Seal of Mirage','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3109,'Amulet: Seal of Silence','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(3110,'Amulet: Seal of Scourge','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3111,'Amulet: Seal of Suspension','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(3112,'Amulet: Pa\'agrio\'s Vision','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3113,'Amulet: Pa\'agrio\'s Protection','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3114,'Amulet: Steal Essence','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3115,'Amulet: Freezing Flame','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3116,'Amulet: Chant of Fury','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(3117,'Amulet: Chant of Evasion','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3118,'Amulet: Chant of Rage','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3119,'Mark of Guildsman','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3120,'Valkon\'s Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3121,'Mandragora Berry','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3122,'Altran\'s Instructions','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3123,'Altran\'s 1st Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3124,'Altran\'s 2nd Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3125,'Norman\'s Instructions','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3126,'Norman\'s Receipt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3127,'Duning\'s Instructions','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3128,'Duning\'s Key','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3129,'Norman\'s List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3130,'Gray Bone Powder','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3131,'Granite Whetstone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3132,'Red Pigment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3133,'Braided Yarn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3134,'Journeyman Gem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3135,'Pinter\'s Instructions','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3136,'Amber Bead','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3137,'Amber Lump','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3138,'Journeyman Deco Beads','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3139,'Journeyman Ring','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3140,'Mark of Life','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3141,'Cardien\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3142,'Camomile Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3143,'Hierarch\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3144,'Moonflower Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3145,'Grail Diagram','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3146,'Thalia\'s 1st Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3147,'Thalia\'s 2nd Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3148,'Thalia\'s Instructions','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3149,'Pushkin\'s List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3150,'Pure Mithril Cup','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3151,'Arkenia\'s Contract','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3152,'Arkenia\'s Instructions','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3153,'Adonius\'s list','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3154,'Andariel Scripture Copy','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3155,'Stardust','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3156,'Isael\'s Instructions','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3157,'Isael\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3158,'Grail of Purity','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3159,'Tears of Unicorn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3160,'Water of Life','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3161,'Pure Mithril Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3162,'Ant Soldier Acid','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3163,'Wyrm\'s Talon','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3164,'Spider Ichor','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3165,'Harpy\'s Down','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3166,'Talin\'s Spear Blade','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3167,'Talin\'s Spear Shaft','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3168,'Talin\'s Ruby','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3169,'Talin\'s Aquamarine','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3170,'Talin\'s Amethyst','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3171,'Talin\'s Peridot','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3172,'Mark of Fate','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3173,'Kaira\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3174,'Metheus\'s Funeral Jar','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3175,'Kasandra\'s Remains','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3176,'Herbalism Textbook','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3177,'Ixia\'s List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3178,'Medusa\'s Ichor','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3179,'Marsh Spider Fluids','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3180,'Dead Seeker Dung','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3181,'Tyrant\'s Blood','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3182,'Nightshade Root','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3183,'Belladonna','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3184,'Alder\'s Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3185,'Alders Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3186,'Alder\'s Receipt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3187,'Revelations Manuscript','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3188,'Kaira\'s Instructions','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3189,'Kaira\'s Recommendation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3190,'Palus Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3191,'Thifiell\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3192,'Arkenia\'s Note','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3193,'Pixy Garnet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3194,'Grandis\'s Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3195,'Karul Bugbear Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3196,'Breka Overlord Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3197,'Leto Overlord Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3198,'Red Fairy Dust','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3199,'Blight Treant Seed','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3200,'Black Willow Leaf','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3201,'Blight Treant Sap','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3202,'Arkenia\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3203,'Mark of Glory','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3204,'Vokian\'s Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3205,'Manashen Shard','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3206,'Tyrant Talon','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3207,'Guardian Basilisk Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3208,'Vokian\'s Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3209,'Necklace of Authority','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3210,'Chianta\'s 1st Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3211,'Scepter of Breka','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3212,'Scepter of Enku','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3213,'Scepter of Vuku','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3214,'Scepter of Turek','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3215,'Scepter of Tunath','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3216,'Chianta\'s 2nd Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3217,'Chianta\'s 3rd Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3218,'Tamlin Orc Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3219,'Timak Orc Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3220,'Scepter Box','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3221,'Pashika\'s Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3222,'Vultus\' Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3223,'Glove of Voltar','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3224,'Enku Overlord Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3225,'Glove of Kepra','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3226,'Makum Bugbear Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3227,'Glove of Burai','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3228,'Manakia\'s 1st Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3229,'Manakia\'s 2nd Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3230,'Kasman\'s 1st Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3231,'Kasman\'s 2nd Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3232,'Kasman\'s 3rd Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3233,'Driko\'s Contract','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3234,'Stakato Drone Husk','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3235,'Tanapi\'s Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3236,'Scepter of Tantos','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3237,'Ritual Box','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3238,'Mark of Prosperity','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3239,'1st Ring of Testimony','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3240,'2nd Ring of Testimony','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3241,'Old Account Book','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3242,'Blessed Seed','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3243,'Emily\'s Recipe','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3244,'Lilith\'s Elven Wafer','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3245,'Maphr Tablet Fragment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3246,'Collection License','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3247,'Lockirin\'s 1st Notice','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3248,'Lockirin\'s 2nd Notice','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3249,'Lockirin\'s 3rd Notice','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3250,'Lockirin\'s 4th Notice','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3251,'Lockirin\'s 5th Notice','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3252,'Contribution of Shari','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3253,'Contribution of Mion','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3254,'Contribution of Maryse','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3255,'Maryse\'s Request','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3256,'Contribution of Toma','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3257,'Receipt of Bolter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3258,'1st Receipt of Contribution','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3259,'2nd Receipt of Contribution','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3260,'3rd Receipt of Contribution','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3261,'4th Receipt of Contribution','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3262,'5th Receipt of Contribution','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3263,'Procuration of Torocco','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3264,'Bright\'s List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3265,'Mandragora Petal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3266,'Crimson Moss','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3267,'Mandragora Bouquet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3268,'Parman\'s Instructions','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3269,'Parman\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3270,'Clay Dough','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3271,'Pattern of Keyhole','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3272,'Nikolas\' List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3273,'Stakato Shell','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3274,'Toad Lord Sac','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3275,'Spider Thorn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3276,'Mark of Champion','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3277,'Ascalon\'s 1st Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3278,'Mason\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3279,'Iron Rose Ring','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3280,'Ascalon\'s 2nd Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3281,'White Rose Insignia','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3282,'Groot\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3283,'Ascalon\'s 3rd Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3284,'Mouen\'s 1st Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3285,'Mouen\'s 2nd Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3286,'Mouen\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3287,'Harpy\'s Egg','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3288,'Medusa\'s Venom','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3289,'Windsus Bile','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3290,'Bloody Axe Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3291,'Road Ratman Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3292,'Leto Lizardman Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3293,'Mark of Sagittarius','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3294,'Bernard\'s Introduction','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3295,'Hamil\'s 1st Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3296,'Hamil\'s 2nd Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3297,'Hamil\'s 3rd Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3298,'Hunter\'s 1st Rune','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3299,'Hunter\'s 2nd Rune','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3300,'Talisman of Kadesh','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3301,'Talisman of Snake','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3302,'Mithril Clip','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3303,'Stakato Chitin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3304,'Reinforced Bowstring','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3305,'Manashen\'s Horn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3306,'Blood of Lizardman','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3307,'Mark of Witchcraft','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3308,'Orim\'s Diagram','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3309,'Alexandria\'s Book','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3310,'Iker\'s List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3311,'Dire Wyrm Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3312,'Leto Lizardman Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3313,'Enchanted Golem Heartstone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3314,'Lara\'s Memo','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3315,'Nestle\'s Memo','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3316,'Leopold\'s Journal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3317,'Aklantoth 1st Gem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3318,'Aklantoth 2nd Gem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3319,'Aklantoth 3rd Gem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3320,'Aklantoth 4th Gem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3321,'Aklantoth 5th Gem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3322,'Aklantoth 6th Gem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3323,'1st Brimstone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3324,'Orim\'s Instructions','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3325,'Orim\'s 1st Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3326,'Orim\'s 2nd Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3327,'Sir Vasper\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3328,'Vadin\'s Crucifix','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3329,'Tamlin Orc Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3330,'Vadin\'s Sanctions','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3331,'Iker\'s Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3332,'Soultrap Crystal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3333,'Purgatory Key','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3334,'Zeruel Bind Crystal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3335,'2nd Brimstone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3336,'Mark of Summoner','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3337,'Leto Lizardman Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3338,'Sac of Redspores','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3339,'Karul Bugbear Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3340,'Shards of Manashen','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3341,'Breka Orc Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3342,'Crimson Bloodstone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3343,'Talons of Tyrant','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3344,'Wings of Droneant','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3345,'Tusk of Windsus','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3346,'Fangs of Wyrm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3347,'Lara\'s 1st List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3348,'Lara\'s 2nd List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3349,'Lara\'s 3rd List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3350,'Lara\'s 4th List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3351,'Lara\'s 5th List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3352,'Galatea\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3353,'Beginner\'s Arcana','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3354,'Almors\'s Arcana','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3355,'Camoniell\'s Arcana','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3356,'Belthus\'s Arcana','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3357,'Basillia\'s Arcana','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3358,'Celestiel\'s Arcana','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3359,'Brynthea\'s Arcana','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3360,'1st Crystal of Starting','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3361,'1st Crystal of Inprogress','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3362,'1st Crystal of Foul','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3363,'1st Crystal of Defeat','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3364,'1st Crystal of Victory','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3365,'2nd Crystal of Starting','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3366,'2nd Crystal of Inprogress','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3367,'2nd Crystal of Foul','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3368,'2nd Crystal of Defeat','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3369,'2nd Crystal of Victory','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3370,'3rd Crystal of Starting','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3371,'3rd Crystal of Inprogress','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3372,'3rd Crystal of Foul','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3373,'3rd Crystal of Defeat','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3374,'3rd Crystal of Victory','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3375,'4th Crystal of Starting','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3376,'4th Crystal of Inprogress','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3377,'4th Crystal of Foul','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3378,'4th Crystal of Defeat','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3379,'4th Crystal of Victory','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3380,'5th Crystal of Starting','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3381,'5th Crystal of Inprogress','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3382,'5th Crystal of Foul','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3383,'5th Crystal of Defeat','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3384,'5th Crystal of Victory','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3385,'6th Crystal of Starting','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3386,'6th Crystal of Inprogress','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3387,'6th Crystal of Foul','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3388,'6th Crystal of Defeat','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3389,'6th Crystal of Victory','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3390,'Mark of Lord','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3391,'Ordeal Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3392,'Varkee\'s Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3393,'Tantus\'s Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3394,'Hatos\'s Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3395,'Takuna\'s Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3396,'Chianta\'s Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3397,'Manakia\'s Orders','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3398,'Breka Orc Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3399,'Manakia\'s Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3400,'Huge Orc Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3401,'Sumari\'s Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3402,'Urutu Blade','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3403,'Timak Orc Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3404,'Sword Into Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3405,'Neruga Axe Blade','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3406,'Axe of Ceremony','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3407,'Marsh Spider Feeler','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3408,'Marsh Spider Feet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3409,'Handiwork Spider Brooch','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3410,'Cornea of Enchanted Monster Eye','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3411,'Monster Eye Woodcarving','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3412,'Bear Fang Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3413,'Martankus\'s Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3414,'Ragna Orc Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3415,'Ragna Chief Notice','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3416,'Immortal Flame','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3417,'Animal Lover\'s List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3418,'Animal Slayer\'s 1st List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3419,'Animal Slayer\'s 2nd List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3420,'Animal Slayer\'s 3rd List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3421,'Animal Slayer\'s 4th List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3422,'Animal Slayer\'s 5th List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3423,'Bloody Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3424,'Bloody Claw','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3425,'Bloody Nail','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3426,'Bloody Kasha Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3427,'Bloody Tarantula Nail','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3428,'Crystal Brooch','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3429,'Spellbook: Greater Heal','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3430,'Spellbook: Greater Battle Heal','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3431,'Spellbook: Greater Group Heal','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3432,'Spellbook: Remedy','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(3433,'Elf Figure','','false','none',0,'normal','steel','none',-1,-1,0,0,'false','true','false','false','false','none','0-0;'),
(3434,'Coke','','false','none',0,'normal','steel','none',-1,-1,0,0,'false','true','false','false','false','none','0-0;'),
(3435,'Nvidia','','false','none',0,'normal','steel','none',-1,-1,0,0,'false','true','false','false','false','none','0-0;'),
(3436,'Mouse','','false','none',0,'normal','steel','none',-1,-1,0,0,'false','true','false','false','false','none','0-0;'),
(3437,'Trade Book of Merchant','','false','none',120,'normal','paper','none',-1,-1,20000,0,'true','true','true','true','true','none','0-0;'),
(3438,'Trade Book of Great Merchant','','false','none',120,'normal','paper','none',-1,-1,20000,0,'true','true','true','true','true','none','0-0;'),
(3440,'Cargo Box','','false','none',20,'stackable','steel','none',-1,-1,10,0,'true','true','true','true','true','none','0-0;'),
(3441,'Cargo Box','','false','none',20,'stackable','steel','none',-1,-1,10,0,'true','true','true','true','true','none','0-0;'),
(3442,'Cargo Box','','false','none',20,'stackable','steel','none',-1,-1,10,0,'true','true','true','true','true','none','0-0;'),
(3443,'Cargo Box','','false','none',20,'stackable','steel','none',-1,-1,10,0,'true','true','true','true','true','none','0-0;'),
(3444,'Gludio Apples','','false','none',20,'stackable','steel','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(3445,'Dion Corn Meal','','false','none',20,'stackable','steel','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(3446,'Dire Wolf Pelts','','false','none',20,'stackable','steel','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(3447,'Moonstone','','false','none',20,'stackable','steel','none',-1,-1,1500,0,'true','true','true','true','true','none','0-0;'),
(3448,'Gludio Wheat Flour','','false','none',20,'stackable','steel','none',-1,-1,1500,0,'true','true','true','true','true','none','0-0;'),
(3449,'Spidersilk Rope','','false','none',20,'stackable','steel','none',-1,-1,1500,0,'true','true','true','true','true','none','0-0;'),
(3450,'Alexandrite','','false','none',20,'stackable','steel','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(3451,'Silver Tea Service','','false','none',20,'stackable','steel','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(3452,'Mechanic Golem Spare Parts','','false','none',20,'stackable','steel','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(3453,'Fire Emerald','','false','none',20,'stackable','steel','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(3454,'Avellan Silk Frock','','false','none',20,'stackable','steel','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(3455,'Feriotic Porcelain Urn','','false','none',20,'stackable','steel','none',-1,-1,20000,0,'true','true','true','true','true','none','0-0;'),
(3456,'Imperial Diamond','','false','none',20,'stackable','steel','none',-1,-1,20000,0,'true','true','true','true','true','none','0-0;'),
(3457,'Statue of Shilen - Head','','false','none',20,'stackable','steel','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(3458,'Statue of Shilen - Torso','','false','none',20,'stackable','steel','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(3459,'Statue of Shilen - Arm','','false','none',20,'stackable','steel','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(3460,'Statue of Shilen - Leg','','false','none',20,'stackable','steel','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(3461,'Complete Statue of Shilen','','false','none',20,'stackable','steel','none',-1,-1,20000,0,'true','true','true','true','true','none','0-0;'),
(3462,'Fragment of Ancient Tablet - 1st Piece','','false','none',20,'stackable','steel','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(3463,'Fragment of Ancient Tablet - 2nd Piece','','false','none',20,'stackable','steel','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(3464,'Fragment of Ancient Tablet - 3rd Piece','','false','none',20,'stackable','steel','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(3465,'Fragment of Ancient Tablet - 4th Piece','','false','none',20,'stackable','steel','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(3466,'Complete Ancient Tablet','','false','none',20,'stackable','steel','none',-1,-1,20000,0,'true','true','true','true','true','none','0-0;'),
(3467,'Wish Potion','','false','none',60,'normal','paper','none',-1,-1,10,0,'true','true','true','true','true','none','0-0;'),
(3468,'Ancient Crown','','false','none',0,'normal','paper','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(3469,'Certificate of Royalty','','false','none',0,'normal','paper','none',-1,-1,10,0,'true','true','true','true','true','none','0-0;'),
(3470,'Gold Bar','','false','none',0,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(3472,'Blood Medusa','','false','none',0,'stackable','steel','none',-1,-1,50,0,'true','true','true','true','true','none','0-0;'),
(3473,'Blood Werewolf','','false','none',0,'stackable','steel','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(3474,'Blood Basilisk','','false','none',0,'stackable','steel','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(3475,'Blood Drevanul','','false','none',0,'stackable','steel','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(3476,'Blood Succubus','','false','none',0,'stackable','steel','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(3477,'Blood Dragon','','false','none',0,'stackable','steel','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(3478,'Beleth\'s Blood Dragon','','false','none',0,'stackable','steel','none',-1,-1,300,0,'true','true','true','true','true','none','0-0;'),
(3479,'Manak\'s Blood Werewolf','','false','none',0,'stackable','steel','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(3480,'Nia\'s Blood Medusa','','false','none',0,'stackable','steel','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(3481,'Gold Dragon','','false','none',0,'stackable','steel','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(3482,'Gold Wyvern','','false','none',0,'stackable','steel','none',-1,-1,50,0,'true','true','true','true','true','none','0-0;'),
(3483,'Gold Knight','','false','none',0,'stackable','steel','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(3484,'Gold Giant','','false','none',0,'stackable','steel','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(3485,'Gold Drake','','false','none',0,'stackable','steel','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(3486,'Gold Wyrm','','false','none',0,'stackable','steel','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(3487,'Beleth\'s Gold Dragon','','false','none',0,'stackable','steel','none',-1,-1,300,0,'true','true','true','true','true','none','0-0;'),
(3488,'Manak\'s Gold Giant','','false','none',0,'stackable','steel','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(3489,'Nia\'s Gold Wyvern','','false','none',0,'stackable','steel','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(3490,'Silver Unicorn','','false','none',0,'stackable','steel','none',-1,-1,50,0,'true','true','true','true','true','none','0-0;'),
(3491,'Silver Fairy','','false','none',0,'stackable','steel','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(3492,'Silver Dryad','','false','none',0,'stackable','steel','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(3493,'Silver Dragon','','false','none',0,'stackable','steel','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(3494,'Silver Golem','','false','none',0,'stackable','steel','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(3495,'Silver Undine','','false','none',0,'stackable','steel','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(3496,'Beleth\'s Silver Dragon','','false','none',0,'stackable','steel','none',-1,-1,300,0,'true','true','true','true','true','none','0-0;'),
(3497,'Manak\'s Silver Dryad','','false','none',0,'stackable','steel','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(3498,'Nia\'s Silver Fairy','','false','none',0,'stackable','steel','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(3499,'Fairy Dust','','false','quest',0,'normal','steel','none',-1,-1,10000,0,'true','false','true','true','false','none','0-0;'),
(3500,'Dragonflute of Wind','','false','pet_collar',20,'normal','steel','none',-1,-1,1000,0,'true','true','true','true','true','SummonItems','0-0;'),
(3501,'Dragonflute of Star','','false','pet_collar',20,'normal','steel','none',-1,-1,1000,0,'true','true','true','true','true','SummonItems','0-0;'),
(3502,'Dragonflute of Twilight','','false','pet_collar',20,'normal','steel','none',-1,-1,1000,0,'true','true','true','true','true','SummonItems','0-0;'),
(3503,'Deliverymen Decertificate','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3504,'Kirunas Horn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3505,'Mithril Mold','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3506,'Bloody Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3507,'Supplies to Alex','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3508,'Supplies to Endrigo','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3509,'Alex\'s Coins','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3510,'Wardens Appreciation','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3511,'Blackbox to Orim','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3512,'Deluxe Windsus Ham','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3513,'Heart of Silenos','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3514,'Request Giran','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3515,'Request Gludin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3516,'Request Hunters','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3517,'Delivery Score Red','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3518,'Delivery Score Blue','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3519,'Deliverymen Advanced Certificate Super','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3520,'1st Confirmation Document','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3521,'2nd Confirmation Document','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3522,'Delivery Goods 01','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3523,'Delivery Goods 02','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3524,'Delivery Goods 03','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3525,'Delivery Goods 04','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3526,'Delivery Goods 05','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3527,'Delivery Goods 06','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3528,'Delivery Goods 07','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3529,'Delivery Goods 08','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3530,'Delivery Goods 09','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3531,'Delivery Goods 10','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3532,'Delivery Goods 11','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3533,'Delivery Goods 12','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3534,'Delivery Goods 13','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3535,'Delivery Goods 14','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3536,'Delivery Goods 15','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3537,'Delivery Goods 16','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3538,'Delivery Goods 17','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3539,'Delivery Goods 18','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3540,'Delivery Goods 19','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3541,'Delivery Goods 20','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3542,'Delivery Goods 21','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3543,'Delivery Goods 22','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3544,'Delivery Goods 23','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3545,'Delivery Goods 24','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3546,'Delivery Goods 25','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3547,'Delivery Goods 26','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3548,'Delivery Goods 27','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3549,'Delivery Goods 28','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3550,'Delivery Goods 29','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3551,'Delivery Goods 30','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3552,'Delivery Goods 31','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3553,'Delivery Goods 32','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3554,'Delivery Goods 33','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3555,'Delivery Goods 34','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3556,'Delivery Goods 35','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3557,'Delivery Goods 36','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3558,'Delivery Goods 37','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3559,'Delivery Goods 38','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3560,'Delivery Goods 39','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3561,'Delivery Goods 40','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3562,'Delivery Goods 41','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3563,'Delivery Goods 42','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3564,'Delivery Goods 43','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3565,'Delivery Goods 44','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3566,'Delivery Goods 45','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3567,'Delivery Goods 46','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3568,'Delivery Goods 47','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3569,'Delivery Goods 48','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3570,'Delivery Goods 49','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3571,'Delivery Goods 50','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3572,'Delivery Goods 51','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3573,'Delivery Goods 52','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3574,'Delivery Goods 53','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3575,'Delivery Goods 54','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3576,'Delivery Goods 55','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3577,'Delivery Goods 56','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3578,'Delivery Goods 57','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3579,'Delivery Goods 58','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3580,'Delivery Goods 59','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3581,'Delivery Goods 60','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3582,'Delivery Goods 61','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3583,'Delivery Goods 62','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3584,'Delivery Goods 63','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3585,'Delivery Goods 64','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3586,'Delivery Goods 65','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3587,'Delivery Goods 66','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3588,'Delivery Goods 67','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3589,'Confirmation Document 01','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3590,'Confirmation Document 02','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3591,'Confirmation Document 03','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3592,'Confirmation Document 04','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3593,'Confirmation Document 05','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3594,'Confirmation Document 06','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3595,'Confirmation Document 07','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3596,'Confirmation Document 08','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3597,'Confirmation Document 09','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3598,'Confirmation Document 10','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3599,'Confirmation Document 11','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3600,'Confirmation Document 12','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3601,'Confirmation Document 13','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3602,'Confirmation Document 14','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3603,'Confirmation Document 15','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3604,'Confirmation Document 16','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3605,'Confirmation Document 17','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3606,'Confirmation Document 18','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3607,'Confirmation Document 19','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3608,'Confirmation Document 20','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3609,'Confirmation Document 21','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3610,'Confirmation Document 22','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3611,'Confirmation Document 23','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3612,'Confirmation Document 24','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3613,'Confirmation Document 25','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3614,'Confirmation Document 26','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3615,'Confirmation Document 27','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3616,'Confirmation Document 28','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3617,'Confirmation Document 29','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3618,'Confirmation Document 30','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3619,'Confirmation Document 31','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3620,'Confirmation Document 32','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3621,'Confirmation Document 33','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3622,'Confirmation Document 34','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3623,'Confirmation Document 35','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3624,'Confirmation Document 36','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3625,'Confirmation Document 37','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3626,'Confirmation Document 38','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3627,'Confirmation Document 39','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3628,'Confirmation Document 40','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3629,'Confirmation Document 41','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3630,'Confirmation Document 42','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3631,'Confirmation Document 43','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3632,'Confirmation Document 44','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3633,'Confirmation Document 45','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3634,'Confirmation Document 46','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3635,'Confirmation Document 47','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3636,'Confirmation Document 48','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3637,'Confirmation Document 49','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3638,'Confirmation Document 50','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3639,'Confirmation Document 51','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3640,'Confirmation Document 52','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3641,'Confirmation Document 53','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3642,'Confirmation Document 54','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3643,'Confirmation Document 55','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3644,'Confirmation Document 56','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3645,'Confirmation Document 57','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3646,'Confirmation Document 58','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3647,'Confirmation Document 59','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3648,'Confirmation Document 60','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3649,'Confirmation Document 61','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3650,'Confirmation Document 62','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3651,'Confirmation Document 63','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3652,'Confirmation Document 64','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3653,'Confirmation Document 65','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3654,'Confirmation Document 66','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3655,'Confirmation Document 67','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3656,'Eye of Seer','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3657,'Pincher Claw','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3658,'Ol Mahum Uniform','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3659,'Enku Orc Champion\'s Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3660,'Bloody Bee Stinger','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3661,'Ignition of Ghost Fire','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3662,'Ethereal Blood','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3663,'Returned Delivery Goods 10','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3664,'Returned Delivery Goods 15','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3665,'Returned Delivery Goods 30','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3666,'Returned Delivery Goods 33','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3667,'Returned Delivery Goods 37','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3668,'Returned Delivery Goods 45','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3669,'Returned Delivery Goods 55','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3670,'Returned Delivery Goods 60','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3671,'Sophya\'s 1st Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3672,'Sophya\'s 2nd Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3673,'Sophya\'s 3rd Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3674,'Sophya\'s 4th Order','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3675,'Lion\'s Claw','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3676,'Lion\'s Eye','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3677,'Guild Coin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3678,'Alchemy Text','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3679,'Secret Book of Potion','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3680,'1st Potion Recipe','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3681,'2nd Potion Recipe','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3682,'Matild\'s Orb','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3683,'Forbidden Love Scroll','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3684,'Amber Scale','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3685,'Wind Soulstone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3686,'Glass Eye','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3687,'Horror Ectoplasm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3688,'Silenos Horn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3689,'Ant Soldier Aphid','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3690,'Tyrant\'s Chitin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3691,'Bugbear Blood','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3692,'1st Circle Hunter License','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3693,'2nd Circle Hunter License','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3694,'Laurel Leaf Pin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3695,'1st Test Instructions','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3696,'2nd Test Instructions','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3697,'Cybellin\'s Request','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3698,'Blood Crystal: Purity 1','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3699,'Blood Crystal: Purity 2','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3700,'Blood Crystal: Purity 3','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3701,'Blood Crystal: Purity 4','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3702,'Blood Crystal: Purity 5','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3703,'Blood Crystal: Purity 6','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3704,'Blood Crystal: Purity 7','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3705,'Blood Crystal: Purity 8','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3706,'Blood Crystal: Purity 9','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3707,'Blood Crystal: Purity 10','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3708,'Blood Crystal: Broken','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3709,'Guardian Basilisk Scale','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3710,'Karut Weed','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3711,'Haka\'s Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3712,'Jakas\' Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3713,'Marka\'s Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3714,'Windsus Aleph Skin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3715,'Indigo Spirit Ore','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3716,'Sporesea Seed','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3717,'Timak Orc Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3718,'Trisalim Silk','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3719,'Ambrosius Fruit','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3720,'Balefire Crystal','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3721,'Imperial Arrowhead','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3722,'Athu\'s Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3723,'Lanka\'s Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3724,'Triska\'s Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3725,'Motura\'s Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3726,'Kalath\'s Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3727,'1st Circle Request: 1C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3728,'1st Circle Request: 2C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3729,'1st Circle Request: 3C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3730,'1st Circle Request: 4C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3731,'1st Circle Request: 5C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3732,'1st Circle Request: 6C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3733,'1st Circle Request: 7C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3734,'1st Circle Request: 8C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3735,'1st Circle Request: 9C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3736,'1st Circle Request: 10C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3737,'1st Circle Request: 11C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3738,'1st Circle Request: 12C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3739,'1st Circle Request: 1B','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3740,'1st Circle Request: 2B','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3741,'1st Circle Request: 3B','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3742,'1st Circle Request: 4B','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;');

INSERT INTO `etcitem` VALUES
(3743,'1st Circle Request: 5B','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3744,'1st Circle Request: 6B','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3745,'1st Circle Request: 1A','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3746,'1st Circle Request: 2A','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3747,'1st Circle Request: 3A','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3748,'2nd Circle Request: 1C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3749,'2nd Circle Request 2C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3750,'2nd Circle Request 3C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3751,'2nd Circle Request: 4C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3752,'2nd Circle Request: 5C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3753,'2nd Circle Request: 6C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3754,'2nd Circle Request: 7C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3755,'2nd Circle Request: 8C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3756,'2nd Circle Request: 9C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3757,'2nd Circle Request: 10C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3758,'2nd Circle Request: 11C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3759,'2nd Circle Request: 12C','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3760,'2nd Circle Request: 1B','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3761,'2nd Circle Request: 2B','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3762,'2nd Circle Request: 3B','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3763,'2nd Circle Request: 4B','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3764,'2nd Circle Request: 5B','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3765,'2nd Circle Request: 6B','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3766,'2nd Circle Request: 1A','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3767,'2nd Circle Request: 2A','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3768,'2nd Circle Request: 3A','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3769,'Charm of Kadesh','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3770,'Timak Jade Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3771,'Enchanted Golem Shard','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3772,'Giant Monster Eye Meat','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3773,'Dire Wyrm Egg','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3774,'Grd Basilisk Talon','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3775,'Revenant\'s Chains','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3776,'Windsus Tusk','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3777,'Grandis Skull','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3778,'Taik Obsidian Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3779,'Karul Bugbear Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3780,'Tamlin Ivory Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3781,'Fang of Narak','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3782,'Enchanted Gargoyle Horn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3783,'Coiled Serpent Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3784,'Totem of Kadesh','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3785,'Kaiki\'s Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3786,'Kronbe Venom Sac','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3787,'Eva\'s Charm','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3788,'Titan\'s Tablet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3789,'Book of Shunaiman','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3790,'Rotting Tree Spores','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3791,'Trisalim Venom Sac','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3792,'Taik Orc Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3793,'Harit Barbed Necklace','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3794,'Coin of Old Empire','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3795,'Skin of Farcran','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3796,'Tempest Shard','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3797,'Tsunami Shard','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3798,'Satyr Mane','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3799,'Hamadryad Shard','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3800,'Vanor Silenos Mane','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3801,'Talk Bugbear Totem','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3802,'Okun\'s Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3803,'Kakran\'s Head','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3804,'Narcissus\'s Soulstone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3805,'Deprive Eye','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3806,'Unicorn\'s Horn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3807,'Kerunos\'s Gold Mane','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3808,'Skull of Executed','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3809,'Bust of Travis','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3810,'Sword of Cadmus','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3811,'Coin Diagram','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3812,'Kaldis Gold Dragon','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3813,'Coin Collector Membership 1','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3814,'Coin Collector Membership 2','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3815,'Coin Collector Membership 3','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3816,'Fairy Stone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3817,'Deluxe Fairy Stone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3818,'Fairy Stone List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3819,'Deluxe Fairy Stone List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3820,'Toad Lord Back Skin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3821,'Juice of Monkshood','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3822,'Scale of Drake Exarion','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3823,'Egg of Drake Exarion','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3824,'Scale of Drake Zwov','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3825,'Egg of Drake Zwov','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3826,'Scale of Drake Kalibran','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3827,'Egg of Drake Kalibran','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3828,'Scale of Wyvern Suzet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3829,'Egg of Wyvern Suzet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3830,'Scale of Wyvern Shamhai','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3831,'Egg of Wyvern Shamhai','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3832,'Herb of Harit','','false','none',0,'normal','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(3833,'Herb of Vanor','','false','none',0,'normal','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(3834,'Herb of Oel Mahum','','false','none',0,'normal','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(3835,'Blood of Eva','','false','none',0,'normal','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(3836,'Athrea\'s Coin','','false','none',0,'normal','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(3837,'Symbol of Loyalty','','false','none',0,'normal','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(3838,'Recipe: Titan\'s Powerstone','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','false','true','true','false','Recipes','0-0;'),
(3839,'Mist Drake Egg','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(3840,'Blitz Wyrm Egg','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(3841,'Drake Egg','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(3842,'Thunder Wyrm Egg','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(3843,'Brooch of the Magpie','','false','none',0,'normal','steel','none',-1,-1,1000,0,'true','false','true','true','false','none','0-0;'),
(3844,'Nebulite Crystals','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(3845,'Broken Titan\'s Powerstone','','false','none',0,'stackable','steel','none',-1,-1,500,0,'true','false','true','true','false','none','0-0;'),
(3846,'Titan\'s Powerstone','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(3847,'Imperial Key','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','false','true','true','false','none','0-0;'),
(3848,'Undead Ash','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3849,'Bloody Axe Insignia','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3850,'Delu Lizardman Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3851,'Stakato Talon','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3852,'Feather of Gabrielle','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3853,'Marsh Stalker Horn','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3854,'Marsh Drake Talons','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3855,'Kranrot Skin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3856,'Hamrut Leg','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3857,'Remains of Sacrified','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3858,'Totem of Land Dragon','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3859,'1st Fragment of Abyss Jewel','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3860,'2nd Fragment of Abyss Jewel','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3861,'3rd Fragment of Abyss Jewel','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3862,'Mara Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3863,'Musfel Fang','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3864,'Mark of Watchman','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3865,'Portal Stone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3866,'Gustav\'s 1st Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3867,'Gustav\'s 2nd Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3868,'Gustav\'s 3rd Letter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3869,'Scepter of Judgment','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3870,'Seal of Aspiration','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','false','false','false','none','0-0;'),
(3871,'Black Anvil Coin','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3872,'Antidote Recipe List','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3873,'Voucher of Faith','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3874,'Alliance Manifesto','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','false','false','false','none','0-0;'),
(3875,'L2Day - A','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3876,'L2Day - C','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3877,'L2Day - E','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3878,'L2Day - F','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3879,'L2Day - G','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3880,'L2Day - H','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3881,'L2Day - I','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3882,'L2Day - L','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3883,'L2Day - N','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3884,'L2Day - O','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3885,'L2Day - R','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3886,'L2Day - S','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3887,'L2Day - T','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3888,'L2Day - II','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(3889,'Potion of Recovery','','false','potion',180,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2060-1;'),
(3890,'Herald of Slayer','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(3926,'L2Day - Scroll of Guidance','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2050-1;'),
(3927,'L2Day - Scroll of Death Whisper','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2051-1;'),
(3928,'L2Day - Scroll of Focus','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2052-1;'),
(3929,'L2Day - Scroll of Greater Acumen','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2053-1;'),
(3930,'L2Day - Scroll of Haste','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2054-1;'),
(3931,'L2Day - Scroll of Agility','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2055-1;'),
(3932,'L2Day - Scroll of Mystic Empower','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2056-1;'),
(3933,'L2Day - Scroll of Might','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2057-1;'),
(3934,'L2Day - Scroll of Windwalk','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2058-1;'),
(3935,'L2Day - Scroll of Shield','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2059-1;'),
(3936,'Blessed Scroll of Resurrection','','false','scroll',120,'stackable','paper','none',-1,-1,400000,0,'true','true','true','true','true','ScrollOfResurrection','2049-1;'),
(3940,'Blueprint: Summon Siege Golem','','false','spellbook',120,'stackable','paper','none',-1,-1,4800,0,'true','true','true','true','true','none','0-0;'),
(3941,'Spellbook: Mass Resurrection','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(3942,'Spellbook: Party Return','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(3943,'Amulet: Pa\'agrio\'s Heart','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(3944,'Spellbook: Decrease Weight','','false','spellbook',120,'stackable','paper','none',-1,-1,2450,0,'true','true','true','true','true','none','0-0;'),
(3945,'Boat Ticket: Talking Island to Giran','','false','none',20,'stackable','paper','none',-1,-1,8000,0,'true','true','true','true','true','none','0-0;'),
(3946,'Boat Ticket: Giran to Talking Island','','false','none',20,'stackable','paper','none',-1,-1,8000,0,'true','true','true','true','true','none','0-0;'),
(3947,'Blessed Spiritshot: No Grade','','false','shot',5,'stackable','paper','none',-1,-1,35,0,'true','true','true','true','true','BlessedSpiritShot','2061-1;'),
(3948,'Blessed Spiritshot: D-Grade','','false','shot',5,'stackable','paper','d',-1,-1,45,0,'true','true','true','true','true','BlessedSpiritShot','2160-1;'),
(3949,'Blessed Spiritshot: C-Grade','','false','shot',3,'stackable','paper','c',-1,-1,90,0,'true','true','true','true','true','BlessedSpiritShot','2161-1;'),
(3950,'Blessed Spiritshot: B-Grade','','false','shot',3,'stackable','paper','b',-1,-1,245,0,'true','true','true','true','true','BlessedSpiritShot','2162-1;'),
(3951,'Blessed Spiritshot: A-Grade','','false','shot',2,'stackable','paper','a',-1,-1,290,0,'true','true','true','true','true','BlessedSpiritShot','2163-1;'),
(3952,'Blessed Spiritshot: S Grade','','false','shot',2,'stackable','paper','s',-1,-1,350,0,'true','true','true','true','true','BlessedSpiritShot','2164-1;'),
(3953,'Recipe: Blessed Spiritshot D','','false','recipe',30,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','Recipes','0-0;'),
(3954,'Recipe: Blessed Spiritshot C','','false','recipe',30,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','Recipes','0-0;'),
(3955,'Recipe: Blessed Spiritshot B','','false','recipe',30,'stackable','liquid','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(3956,'Recipe: Blessed Spiritshot A','','false','recipe',30,'stackable','liquid','none',-1,-1,150000,0,'true','true','true','true','true','Recipes','0-0;'),
(3957,'Recipe: Blessed Spiritshot S','','false','recipe',30,'stackable','liquid','none',-1,-1,450000,0,'true','true','true','true','true','Recipes','0-0;'),
(3958,'L2Day - Blessed Escape Effect','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2036-2;'),
(3959,'L2Day - Blessed Resurrection Effect','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ScrollOfResurrection','2062-1;'),
(3960,'Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,30000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3961,'Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,40000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3962,'Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3963,'Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3964,'Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3965,'Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,30000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3966,'Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,40000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3967,'Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3968,'Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3969,'Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3970,'Mercenary Posting Ticket (Teleporter1)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3971,'Mercenary Posting Ticket (Teleporter2)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3972,'Mercenary Posting Ticket (Teleporter3)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3973,'Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,30000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3974,'Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,40000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3975,'Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3976,'Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3977,'Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3978,'Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,30000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3979,'Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,40000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3980,'Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3981,'Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3982,'Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3983,'Mercenary Posting Ticket (Teleporter1)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3984,'Mercenary Posting Ticket (Teleporter2)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3985,'Mercenary Posting Ticket (Teleporter3)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3986,'Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,30000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3987,'Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,40000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3988,'Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3989,'Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3990,'Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3991,'Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,30000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3992,'Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,40000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3993,'Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3994,'Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3995,'Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3996,'Mercenary Posting Ticket (Teleporter1)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3997,'Mercenary Posting Ticket (Teleporter2)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3998,'Mercenary Posting Ticket (Teleporter3)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(3999,'Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,30000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4000,'Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,40000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4001,'Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4002,'Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4003,'Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4004,'Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,30000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4005,'Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,40000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4006,'Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4007,'Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4008,'Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4009,'Mercenary Posting Ticket (Teleporter1)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4010,'Mercenary Posting Ticket (Teleporter2)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4011,'Mercenary Posting Ticket (Teleporter3)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4012,'Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,30000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4013,'Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,40000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4014,'Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4015,'Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4016,'Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4017,'Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,30000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4018,'Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,40000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4019,'Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4020,'Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4021,'Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4022,'Mercenary Posting Ticket (Teleporter1)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4023,'Mercenary Posting Ticket (Teleporter2)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4024,'Mercenary Posting Ticket (Teleporter3)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4025,'Mercenary Posting Ticket (Teleporter4)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4026,'Mercenary Posting Ticket (Teleporter5)','','false','castle_guard',0,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','MercTicket','0-0;'),
(4029,'Red Paper','','false','none',0,'stackable','paper','none',-1,-1,1,0,'true','true','true','true','true','none','0-0;'),
(4030,'Orange Paper','','false','none',0,'stackable','paper','none',-1,-1,1,0,'true','true','true','true','true','none','0-0;'),
(4031,'Yellow Paper','','false','none',0,'stackable','paper','none',-1,-1,1,0,'true','true','true','true','true','none','0-0;'),
(4032,'Green Paper','','false','none',0,'stackable','paper','none',-1,-1,1,0,'true','true','true','true','true','none','0-0;'),
(4033,'Blue Paper','','false','none',0,'stackable','paper','none',-1,-1,1,0,'true','true','true','true','true','none','0-0;'),
(4034,'Purple Paper','','false','none',0,'stackable','paper','none',-1,-1,1,0,'true','true','true','true','true','none','0-0;'),
(4035,'White Paper','','false','none',0,'stackable','paper','none',-1,-1,1,0,'true','true','true','true','true','none','0-0;'),
(4036,'Black Paper','','false','none',0,'stackable','paper','none',-1,-1,1,0,'true','true','true','true','true','none','0-0;'),
(4037,'Coin of Luck','','false','none',0,'stackable','paper','none',-1,-1,1,0,'false','false','true','false','false','none','0-0;'),
(4038,'Food For Hatchling','','false','none',10,'stackable','liquid','none',-1,-1,162,0,'true','true','true','true','true','PetFood','2063-1;'),
(4039,'Mold Glue','','false','material',2,'stackable','liquid','none',-1,-1,6000,0,'true','true','true','true','true','none','0-0;'),
(4040,'Mold Lubricant','','false','material',2,'stackable','liquid','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(4041,'Mold Hardener','','false','material',2,'stackable','liquid','none',-1,-1,23000,0,'true','true','true','true','true','none','0-0;'),
(4042,'Enria','','false','material',2,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4043,'Asofe','','false','material',2,'stackable','liquid','none',-1,-1,6000,0,'true','true','true','true','true','none','0-0;'),
(4044,'Thons','','false','material',2,'stackable','liquid','none',-1,-1,6000,0,'true','true','true','true','true','none','0-0;'),
(4045,'Maestro Holder','','false','material',2,'stackable','liquid','none',-1,-1,411000,0,'true','true','true','true','true','none','0-0;'),
(4046,'Maestro Anvil Lock','','false','material',2,'stackable','liquid','none',-1,-1,90400,0,'true','true','true','true','true','none','0-0;'),
(4047,'Craftsman Mold','','false','material',2,'stackable','liquid','none',-1,-1,710000,0,'true','true','true','true','true','none','0-0;'),
(4048,'Maestro Mold','','false','material',2,'stackable','liquid','none',-1,-1,154000,0,'true','true','true','true','true','none','0-0;'),
(4049,'Adamantite Earring Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,3813,0,'true','true','true','true','true','none','0-0;'),
(4050,'Adamantite Ring Wire','','false','material',60,'stackable','liquid','none',-1,-1,3228,0,'true','true','true','true','true','none','0-0;'),
(4051,'Adamantite Necklace Chain','','false','material',60,'stackable','liquid','none',-1,-1,5157,0,'true','true','true','true','true','none','0-0;'),
(4052,'Earring of Black Ore Piece','','false','material',60,'stackable','liquid','none',-1,-1,5649,0,'true','true','true','true','true','none','0-0;'),
(4053,'Ring of Black Ore Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,4666,0,'true','true','true','true','true','none','0-0;'),
(4054,'Necklace of Black Ore Beads','','false','material',60,'stackable','liquid','none',-1,-1,10154,0,'true','true','true','true','true','none','0-0;'),
(4055,'Composite Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,3120,0,'true','true','true','true','true','none','0-0;'),
(4056,'Zubei\'s Breastplate Part','','false','material',60,'stackable','liquid','none',-1,-1,11050,0,'true','true','true','true','true','none','0-0;'),
(4057,'Zubei\'s Gaiter Material','','false','material',60,'stackable','liquid','none',-1,-1,7150,0,'true','true','true','true','true','none','0-0;'),
(4058,'Implosion Boots Part','','false','material',60,'stackable','liquid','none',-1,-1,4455,0,'true','true','true','true','true','none','0-0;'),
(4059,'Boots of Silence Fabric','','false','material',60,'stackable','liquid','none',-1,-1,3843,0,'true','true','true','true','true','none','0-0;'),
(4060,'Guardian\'s Boots Fabric','','false','material',60,'stackable','liquid','none',-1,-1,3843,0,'true','true','true','true','true','none','0-0;'),
(4061,'Paradia Boots Pattern','','false','material',60,'stackable','liquid','none',-1,-1,4455,0,'true','true','true','true','true','none','0-0;'),
(4062,'Elemental Boots Lining','','false','material',60,'stackable','liquid','none',-1,-1,4455,0,'true','true','true','true','true','none','0-0;'),
(4063,'Boots of Grace Lining','','false','material',60,'stackable','liquid','none',-1,-1,4455,0,'true','true','true','true','true','none','0-0;'),
(4064,'Avadon Breastplate Part','','false','material',60,'stackable','liquid','none',-1,-1,11050,0,'true','true','true','true','true','none','0-0;'),
(4065,'Avadon Gaiters Material','','false','material',60,'stackable','liquid','none',-1,-1,7150,0,'true','true','true','true','true','none','0-0;'),
(4066,'Zubei\'s Leather Shirt Fabric','','false','material',60,'stackable','liquid','none',-1,-1,8483,0,'true','true','true','true','true','none','0-0;'),
(4067,'Zubei\'s Leather Gaiter Texture','','false','material',60,'stackable','liquid','none',-1,-1,5587,0,'true','true','true','true','true','none','0-0;'),
(4068,'Avadon Leather Armor Lining','','false','material',60,'stackable','liquid','none',-1,-1,11042,0,'true','true','true','true','true','none','0-0;'),
(4069,'Tunic of Zubei Fabric','','false','material',60,'stackable','liquid','none',-1,-1,8483,0,'true','true','true','true','true','none','0-0;'),
(4070,'Stockings of Zubei Fabric','','false','material',60,'stackable','liquid','none',-1,-1,5587,0,'true','true','true','true','true','none','0-0;'),
(4071,'Avadon Robe Fabric','','false','material',60,'stackable','liquid','none',-1,-1,11042,0,'true','true','true','true','true','none','0-0;'),
(4072,'Avadon Circlet Pattern','','false','material',60,'stackable','liquid','none',-1,-1,4453,0,'true','true','true','true','true','none','0-0;'),
(4073,'Avadon Gloves Part','','false','material',60,'stackable','liquid','none',-1,-1,3843,0,'true','true','true','true','true','none','0-0;'),
(4074,'Chain Gloves of Silence Design','','false','material',60,'stackable','liquid','none',-1,-1,3843,0,'true','true','true','true','true','none','0-0;'),
(4075,'Guardian\'s Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,3843,0,'true','true','true','true','true','none','0-0;'),
(4076,'Gloves of Blessing Pattern','','false','material',60,'stackable','liquid','none',-1,-1,3843,0,'true','true','true','true','true','none','0-0;'),
(4077,'Doom Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,4446,0,'true','true','true','true','true','none','0-0;'),
(4078,'Blue Wolf Breastplate Part','','false','material',60,'stackable','liquid','none',-1,-1,13692,0,'true','true','true','true','true','none','0-0;'),
(4079,'Boots of Blessing Design','','false','material',60,'stackable','liquid','none',-1,-1,3843,0,'true','true','true','true','true','none','0-0;'),
(4080,'Blue Wolf Gaiters Material','','false','material',60,'stackable','liquid','none',-1,-1,9723,0,'true','true','true','true','true','none','0-0;'),
(4081,'Doom Plate Armor Temper','','false','material',60,'stackable','liquid','none',-1,-1,20292,0,'true','true','true','true','true','none','0-0;'),
(4082,'Blue Wolf Leather Armor Texture','','false','material',60,'stackable','liquid','none',-1,-1,17700,0,'true','true','true','true','true','none','0-0;'),
(4083,'Leather Armor of Doom Design','','false','material',60,'stackable','liquid','none',-1,-1,17700,0,'true','true','true','true','true','none','0-0;'),
(4084,'Blue Wolf Tunic Fabric','','false','material',60,'stackable','liquid','none',-1,-1,11508,0,'true','true','true','true','true','none','0-0;'),
(4085,'Tunic of Doom Pattern','','false','material',60,'stackable','liquid','none',-1,-1,11508,0,'true','true','true','true','true','none','0-0;'),
(4086,'Blue Wolf Stockings Pattern','','false','material',60,'stackable','liquid','none',-1,-1,8523,0,'true','true','true','true','true','none','0-0;'),
(4087,'Stockings of Doom Pattern','','false','material',60,'stackable','liquid','none',-1,-1,8523,0,'true','true','true','true','true','none','0-0;'),
(4088,'Blue Wolf Helmet Design','','false','material',60,'stackable','liquid','none',-1,-1,5292,0,'true','true','true','true','true','none','0-0;'),
(4089,'Doom Helmet Pattern','','false','material',60,'stackable','liquid','none',-1,-1,5292,0,'true','true','true','true','true','none','0-0;'),
(4090,'Blue Wolf Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,4455,0,'true','true','true','true','true','none','0-0;'),
(4091,'Doom Gloves Part','','false','material',60,'stackable','liquid','none',-1,-1,4455,0,'true','true','true','true','true','none','0-0;'),
(4092,'Elemental Gloves Lining','','false','material',60,'stackable','liquid','none',-1,-1,4455,0,'true','true','true','true','true','none','0-0;'),
(4093,'Gloves of Grace Lining','','false','material',60,'stackable','liquid','none',-1,-1,4455,0,'true','true','true','true','true','none','0-0;'),
(4094,'Implosion Gauntlet Fabric','','false','material',60,'stackable','liquid','none',-1,-1,4455,0,'true','true','true','true','true','none','0-0;'),
(4095,'Paradia Gloves Pattern','','false','material',60,'stackable','liquid','none',-1,-1,4455,0,'true','true','true','true','true','none','0-0;'),
(4096,'Blue Wolf Gloves Fabric','','false','material',60,'stackable','liquid','none',-1,-1,4455,0,'true','true','true','true','true','none','0-0;'),
(4097,'Zubei\'s Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,3843,0,'true','true','true','true','true','none','0-0;'),
(4098,'Avadon Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,3843,0,'true','true','true','true','true','none','0-0;'),
(4099,'Doom Boots Part','','false','material',60,'stackable','liquid','none',-1,-1,4455,0,'true','true','true','true','true','none','0-0;'),
(4100,'Zubei\'s Gauntlets Part','','false','material',60,'stackable','liquid','none',-1,-1,3843,0,'true','true','true','true','true','none','0-0;'),
(4101,'Zubei\'s Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,3450,0,'true','true','true','true','true','none','0-0;'),
(4102,'Zubei\'s Helmet Design','','false','material',60,'stackable','liquid','none',-1,-1,4453,0,'true','true','true','true','true','none','0-0;'),
(4103,'Pata Blade','','false','material',60,'stackable','liquid','none',-1,-1,32950,0,'true','true','true','true','true','none','0-0;'),
(4104,'Great Sword Blade','','false','material',60,'stackable','liquid','none',-1,-1,34950,0,'true','true','true','true','true','none','0-0;'),
(4105,'Heavy War Axe Head','','false','material',60,'stackable','liquid','none',-1,-1,34950,0,'true','true','true','true','true','none','0-0;'),
(4106,'Sprite\'s Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,35533,0,'true','true','true','true','true','none','0-0;'),
(4107,'Keshanberk Blade','','false','material',60,'stackable','liquid','none',-1,-1,35500,0,'true','true','true','true','true','none','0-0;'),
(4108,'Sword of Valhalla Blade','','false','material',60,'stackable','liquid','none',-1,-1,35500,0,'true','true','true','true','true','none','0-0;'),
(4109,'Kris Edge','','false','material',60,'stackable','liquid','none',-1,-1,35500,0,'true','true','true','true','true','none','0-0;'),
(4110,'Hell Knife Edge','','false','material',60,'stackable','liquid','none',-1,-1,35500,0,'true','true','true','true','true','none','0-0;'),
(4111,'Arthro Nail Blade','','false','material',60,'stackable','liquid','none',-1,-1,34950,0,'true','true','true','true','true','none','0-0;'),
(4112,'Dark Elven Longbow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,35325,0,'true','true','true','true','true','none','0-0;'),
(4113,'Great Axe Head','','false','material',60,'stackable','liquid','none',-1,-1,38867,0,'true','true','true','true','true','none','0-0;'),
(4114,'Sword of Damascus Blade','','false','material',60,'stackable','liquid','none',-1,-1,45692,0,'true','true','true','true','true','none','0-0;'),
(4115,'Lance Blade','','false','material',60,'stackable','liquid','none',-1,-1,45846,0,'true','true','true','true','true','none','0-0;'),
(4116,'Deadman\'s Glory Stone','','false','material',60,'stackable','liquid','none',-1,-1,45769,0,'true','true','true','true','true','none','0-0;'),
(4117,'Art of Battle Axe Blade','','false','material',60,'stackable','liquid','none',-1,-1,45769,0,'true','true','true','true','true','none','0-0;'),
(4118,'Evil Spirit Head','','false','material',60,'stackable','liquid','none',-1,-1,48308,0,'true','true','true','true','true','none','0-0;'),
(4119,'Demon Dagger Edge','','false','material',60,'stackable','liquid','none',-1,-1,45692,0,'true','true','true','true','true','none','0-0;'),
(4120,'Bellion Cestus Edge','','false','material',60,'stackable','liquid','none',-1,-1,45769,0,'true','true','true','true','true','none','0-0;'),
(4121,'Bow of Peril Shaft','','false','material',60,'stackable','liquid','none',-1,-1,45923,0,'true','true','true','true','true','none','0-0;'),
(4122,'Recipe: Maestro Holder (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,4500,0,'true','true','true','true','true','Recipes','0-0;'),
(4123,'Recipe: Maestro Anvil Lock (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,4500,0,'true','true','true','true','true','Recipes','0-0;'),
(4124,'Recipe: Craftsman Mold (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,4500,0,'true','true','true','true','true','Recipes','0-0;'),
(4125,'Recipe: Maestro Mold (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,4500,0,'true','true','true','true','true','Recipes','0-0;'),
(4126,'Recipe: Adamantite Earrings (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,12120,0,'true','true','true','true','true','Recipes','0-0;'),
(4127,'Recipe: Adamantite Ring (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,8080,0,'true','true','true','true','true','Recipes','0-0;'),
(4128,'Recipe: Adamantite Necklace (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16160,0,'true','true','true','true','true','Recipes','0-0;'),
(4129,'Recipe: Earrings of Black Ore (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,18480,0,'true','true','true','true','true','Recipes','0-0;'),
(4130,'Recipe: Ring of Black Ore (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,12320,0,'true','true','true','true','true','Recipes','0-0;'),
(4131,'Recipe: Necklace of Black Ore (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','Recipes','0-0;'),
(4132,'Recipe: Composite Shield (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,5160,0,'true','true','true','true','true','Recipes','0-0;'),
(4133,'Recipe: Zubei\'s Breastplate (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,41600,0,'true','true','true','true','true','Recipes','0-0;'),
(4134,'Recipe: Zubei\'s Gaiters (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,26000,0,'true','true','true','true','true','Recipes','0-0;'),
(4135,'Recipe: Implosion Boots (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4136,'Recipe: Boots of Silence (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4137,'Recipe: Guardian\'s Boots (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4138,'Recipe: Paradia Boots (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4139,'Recipe: Elemental Boots (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4140,'Recipe: Boots of Grace (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4141,'Recipe: Avadon Breastplate (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,41600,0,'true','true','true','true','true','Recipes','0-0;'),
(4142,'Recipe: Avadon Gaiters (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,26000,0,'true','true','true','true','true','Recipes','0-0;'),
(4143,'Recipe: Zubei\'s Leather Shirt (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,31200,0,'true','true','true','true','true','Recipes','0-0;'),
(4144,'Recipe: Zubei\'s Leather Gaiters (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,19460,0,'true','true','true','true','true','Recipes','0-0;'),
(4145,'Recipe: Avadon Leather Armor (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,45600,0,'true','true','true','true','true','Recipes','0-0;'),
(4146,'Recipe: Tunic of Zubei (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,31200,0,'true','true','true','true','true','Recipes','0-0;'),
(4147,'Recipe: Stockings of Zubei (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,19460,0,'true','true','true','true','true','Recipes','0-0;'),
(4148,'Recipe: Avadon Robe (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,45600,0,'true','true','true','true','true','Recipes','0-0;'),
(4149,'Recipe: Avadon Circlet (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,15560,0,'true','true','true','true','true','Recipes','0-0;'),
(4150,'Recipe: Avadon Gloves (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4151,'Recipe: Chain Gloves of Silence (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4152,'Recipe: Guardian\'s Gloves (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4153,'Recipe: Gloves of Blessing (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4154,'Recipe: Doom Shield (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16900,0,'true','true','true','true','true','Recipes','0-0;'),
(4155,'Recipe: Blue Wolf Breastplate (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,64400,0,'true','true','true','true','true','Recipes','0-0;'),
(4156,'Recipe: Boots of Blessing (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4157,'Recipe: Blue Wolf Gaiters (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,40200,0,'true','true','true','true','true','Recipes','0-0;'),
(4158,'Recipe: Doom Plate Armor (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,94200,0,'true','true','true','true','true','Recipes','0-0;'),
(4159,'Recipe: Blue Wolf Leather Armor (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,70600,0,'true','true','true','true','true','Recipes','0-0;'),
(4160,'Recipe: Leather Armor of Doom (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,70600,0,'true','true','true','true','true','Recipes','0-0;'),
(4161,'Recipe: Blue Wolf Tunic (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,48200,0,'true','true','true','true','true','Recipes','0-0;'),
(4162,'Recipe: Tunic of Doom (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,48200,0,'true','true','true','true','true','Recipes','0-0;'),
(4163,'Recipe: Blue Wolf Stockings (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,30200,0,'true','true','true','true','true','Recipes','0-0;'),
(4164,'Recipe: Stockings of Doom (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,30200,0,'true','true','true','true','true','Recipes','0-0;'),
(4165,'Recipe: Blue Wolf Helmet (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,24200,0,'true','true','true','true','true','Recipes','0-0;'),
(4166,'Recipe: Doom Helmet (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,24200,0,'true','true','true','true','true','Recipes','0-0;'),
(4167,'Recipe: Blue Wolf Boots (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4168,'Recipe: Doom Gloves (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4169,'Recipe: Elemental Gloves (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4170,'Recipe: Gloves of Grace (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4171,'Recipe: Implosion Gauntlets (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4172,'Recipe: Paradia Gloves (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4173,'Recipe: Blue Wolf Gloves (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4174,'Recipe: Zubei\'s Boots (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4175,'Recipe: Avadon Boots (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4176,'Recipe: Doom Boots (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4177,'Recipe: Zubei\'s Gauntlets (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4178,'Recipe: Zubei\'s Shield (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10900,0,'true','true','true','true','true','Recipes','0-0;'),
(4179,'Recipe: Zubei\'s Helmet (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,15560,0,'true','true','true','true','true','Recipes','0-0;'),
(4180,'Recipe: Silver Arrow (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,1800,0,'true','true','true','true','true','Recipes','0-0;'),
(4181,'Recipe: Pata (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,156600,0,'true','true','true','true','true','Recipes','0-0;'),
(4182,'Recipe: Great Sword (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4183,'Recipe: Heavy War Axe (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4184,'Recipe: Sprite\'s Staff (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4185,'Recipe: Keshanberk (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4186,'Recipe: Sword of Valhalla (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4187,'Recipe: Kris (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4188,'Recipe: Hell Knife (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4189,'Recipe: Arthro Nail (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4190,'Recipe: Dark Elven Long Bow (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4191,'Recipe: Great Axe (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4192,'Recipe: Sword of Damascus (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(4193,'Recipe: Lance (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(4194,'Recipe: Deadman\'s Glory (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(4195,'Recipe: Art of Battle Axe (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(4196,'Recipe: Staff of Evil Spirits (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(4197,'Recipe: Demon Dagger (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(4198,'Recipe: Bellion Cestus (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(4199,'Recipe: Bow of Peril (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(4200,'Spellbook: Restore Life','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(4201,'Spellbook: Resist Shock','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(4203,'Spellbook: Life Leech','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(4204,'Amulet: Pa\'agrio\'s Tact','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(4205,'Amulet: Pa\'agrio\'s Rage','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(4206,'Spellbook: Transfer Pain','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(4207,'Spellbook: Mana Regeneration','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(4208,'Spellbook: Curse Gloom','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(4209,'Change of Heart - Piece 1','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4210,'Change of Heart - Piece 2','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4211,'Change of Heart - Piece 3','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4212,'Change of Heart - Piece 4','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4213,'Change of Heart - Piece 5','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4214,'Change of Heart - Piece 6','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4215,'Change of Heart - Piece 7','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4216,'Change of Heart - Piece 8','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4217,'Change of Heart - Piece 9','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4218,'L2 Day - Scroll of Mana Regeneration','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2064-1;'),
(4232,'Dice','','false','none',0,'normal','steel','none',-1,-1,0,0,'true','true','false','true','true','none','0-0;'),
(4239,'Blade Mold','','false','quest',0,'stackable','liquid','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4240,'Tyra\'s Bill','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4241,'Ranger\'s Report - Part 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4242,'Ranger\'s Report - Part 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4243,'Ranger\'s Report - Part 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4244,'Ranger\'s Report - Part 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4245,'Weapons Trade Contract','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4246,'Attack Directives','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4247,'Certificate of the Silver Scale Guild','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4248,'Rolento\'s Cargobox','','false','quest',0,'stackable','wood','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4249,'Ol Mahum Captain\'s Head','','false','quest',0,'stackable','leather','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4250,'Jade Crystal','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4251,'Ancient Statue of Goddess','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4252,'GalfRedo Romer\'s Bust','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4253,'Eye of the Shadow','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4254,'Certificate of Participation: Battle Royal','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4255,'Trade Cargo','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4256,'Agnes\'s Holy Symbol','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4257,'Agnes\'s Rosary','','false','quest',0,'stackable','wood','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4258,'Sinister Totem','','false','quest',0,'stackable','wood','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4259,'Bear Skin','','false','quest',0,'stackable','leather','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4260,'Enku Orc\'s Head','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4261,'Orc Heads Bouquet -1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4262,'Orc Heads Bouquet -2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4263,'Orc Heads Bouquet -3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4264,'Orc Heads Bouquet -4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4265,'Orc Heads Bouquet -5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4266,'Orc Heads Bouquet -6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4267,'Orc Heads Bouquet -7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4268,'Jennifer\'s Box','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4269,'Articles of Dead Heroes','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4270,'Old Key','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4271,'Old Hilt','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4272,'Totem Necklace','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4273,'Einhasad Crucifix','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4274,'Victim\'s Arm Bone','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4275,'Victim\'s Thigh Bone','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4276,'Victim\'s Skull','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4277,'Victim\'s Rib Bone','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4278,'Victim\'s Spine','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4279,'Jar of Bones','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4280,'Useless Bone Pieces','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4281,'Powder to Summon Dead Souls','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4282,'Sack of the Dead','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4283,'Frog Prince','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4284,'Fly Powder','','false','quest',0,'stackable','liquid','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4285,'Calculator','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4286,'Gemstone Beast\'s Crystal','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4287,'Titan\'s Powerstone','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4288,'Hanellin\'s 1st Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4289,'Hanellin\'s 2nd Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4290,'Hanellin\'s 3rd Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4291,'1st Key of Ark','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4292,'2nd Key of Ark','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4293,'3rd Key of Ark','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4294,'White Fabric','','false','quest',0,'stackable','cloth','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4295,'Blooded Fabric','','false','quest',0,'stackable','cloth','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4296,'Order of Gosta','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4297,'Lizard Fang','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4298,'Barrel of League','','false','quest',0,'stackable','wood','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4299,'Operation Document - 1/10','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4300,'Operation Document - 2/10','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4301,'Operation Document - 3/10','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4302,'Operation Document - 4/10','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4303,'Operation Document - 5/10','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4304,'Operation Document - 6/10','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4305,'Operation Document - 7/10','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4306,'Operation Document - 8/10','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4307,'Operation Document - 9/10','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4308,'Operation Document - 10/10','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4309,'Completed Operation Order','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4310,'Iason Heine\'s Bill','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4311,'Gillian\'s Diary','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4312,'Gillian\'s Notes','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4313,'Unfinished Music','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4314,'Gillian\'s Heart','','false','quest',0,'stackable','leather','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4315,'Gandi Tribe\'s Relic','','false','quest',0,'stackable','wood','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4316,'Swan\'s Flute','','false','quest',0,'stackable','wood','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4317,'Swan\'s Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4318,'Event Clothes','','false','quest',0,'stackable','cloth','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4319,'Nanarin\'s Flute','','false','quest',0,'stackable','wood','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4320,'Sabrin\'s Black Beer','','false','quest',0,'stackable','liquid','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4321,'Stolen Black Beer','','false','quest',0,'stackable','liquid','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4322,'Stolen Event Clothes','','false','quest',0,'stackable','cloth','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4323,'Clothes Chest Key','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4324,'Beer Chest Key','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4325,'Fairy Leaf','','false','quest',0,'stackable','wood','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4326,'Ratman Scavenger\'s Skull','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4327,'Turek War Hound\'s Tail','','false','quest',0,'stackable','bone','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4328,'Tyrant Kingpin\'s Heart','','false','quest',0,'stackable','leather','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4329,'Trisalim Tarantula\'s Venom Sac','','false','quest',0,'stackable','cloth','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4330,'Penitent\'s Manacles','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4331,'Manual of Manacles','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4332,'Tarlk Amulet','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4333,'Contest Certificate','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4334,'Ant\'s Ichor','','false','quest',0,'stackable','liquid','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4335,'Noble Ant\'s Nerve Tissue','','false','quest',0,'stackable','liquid','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4336,'Casian\'s Enzyme','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4337,'Alligator Leather','','false','quest',0,'stackable','leather','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4338,'Blue Back Alligator Leather','','false','quest',0,'stackable','leather','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4339,'Jewel Studded Alligator Leather','','false','quest',0,'stackable','leather','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4340,'Certificate of Approval to Create a Belt','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4341,'Certificate of Approval to Create a Purse','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4342,'Water Crystal','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4343,'Fire Crystal','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4344,'Wind Crystal','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4345,'Earth Crystal','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4346,'Dark Crystal','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4347,'Crystal of Light','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4348,'Jade Crystal','','false','none',1,'stackable','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4349,'Bust of Ancient Goddess','','false','none',5,'stackable','wood','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4350,'The Work of the ancient sculptor Berona','','false','none',5,'stackable','wood','none',-1,-1,3400,0,'true','true','true','true','true','none','0-0;'),
(4351,'Ancient Statue of Goddess - Prototype','','false','none',5,'stackable','wood','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(4352,'Ancient Statue of Goddess - Original','','false','none',5,'stackable','wood','none',-1,-1,6800,0,'true','true','true','true','true','none','0-0;'),
(4353,'Ancient Statue of Goddess - Replica','','false','none',5,'stackable','wood','none',-1,-1,850,0,'true','true','true','true','true','none','0-0;'),
(4354,'Ancient Statue of Goddess - Forgery','','false','none',5,'stackable','wood','none',-1,-1,850,0,'true','true','true','true','true','none','0-0;'),
(4355,'Blue Eva','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4356,'Gold Einhasad','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4357,'Silver Shilen','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4358,'Bloody Pa\'agrio','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4359,'Barrel of Liquor','','false','none',2000,'normal','wood','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4360,'Precious Scarab','','false','none',0,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4361,'Simbelmyne','','false','none',0,'normal','wood','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4362,'Odd (looking) Doll','','false','none',500,'normal','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4363,'Scarlet Dress','','false','none',20,'normal','cloth','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4364,'Nebulite Orb','','false','none',2,'stackable','crystal','none',-1,-1,10,0,'true','true','true','true','true','none','0-0;'),
(4365,'Ectoplasm Liqueur','','false','none',10,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4366,'Prince\'s Trophy','','false','none',20,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4367,'Prince\'s Autobiography','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4368,'Prince\'s Bust','','false','none',20,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4369,'Silk Handkerchief','','false','none',5,'stackable','cloth','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4370,'Luxurious Goblet','','false','none',10,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4371,'Scepter of Darkness','','false','none',10,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4372,'Succubus Perfume','','false','none',5,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4373,'Succubus Mirror','','false','none',10,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4374,'Heart of Darkness','','false','none',30,'stackable','wood','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4375,'Royal Orc Totem','','false','none',30,'stackable','wood','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4376,'Pearl Trodden/Trampled By A Wild Hog','','false','none',5,'stackable','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4377,'Boar\'s Tusk','','false','none',10,'stackable','bone','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4378,'Sweet Potato','','false','none',5,'stackable','bone','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4379,'Beast\'s Claws','','false','none',5,'stackable','bone','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4380,'Beast\'s Mane','','false','none',10,'stackable','leather','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4381,'Ginseng Root','','false','none',5,'stackable','wood','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4382,'Honey Jar','','false','none',10,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4383,'Bear\'s Gall','','false','none',5,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4384,'Fresh Samon','','false','none',5,'stackable','bone','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4385,'Sushi Riceball','','false','none',5,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4386,'Avellan Spice','','false','none',5,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4387,'Lucky Rabbit Weed','','false','none',5,'stackable','wood','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4388,'Malcom\'s Check','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4389,'Deposit Box Key','','false','none',10,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4390,'Dwarven Royal Seal','','false','none',20,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4391,'Dwarven Royal Crown','','false','none',20,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4392,'Dwarven Dance Manual','','false','none',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4393,'Calculator','','false','none',20,'normal','steel','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(4394,'Hanellin\'s White Flower','','false','none',0,'normal','wood','none',-1,-1,0,0,'true','false','false','true','false','none','0-0;'),
(4395,'Hanellin\'s Red Flower','','false','none',0,'normal','wood','none',-1,-1,0,0,'true','false','false','true','false','none','0-0;'),
(4396,'Hanellin\'s Yellow Flower','','false','none',0,'normal','wood','none',-1,-1,0,0,'true','false','false','true','false','none','0-0;'),
(4397,'Book of Saint','','false','none',20,'normal','paper','none',-1,-1,0,0,'true','false','false','true','false','none','0-0;'),
(4398,'Blood of Saint','','false','none',20,'normal','liquid','none',-1,-1,0,0,'true','false','false','true','false','none','0-0;'),
(4399,'Bough of Saint','','false','none',20,'normal','wood','none',-1,-1,0,0,'true','false','false','true','false','none','0-0;'),
(4400,'White Fabric','','false','none',0,'stackable','cloth','none',-1,-1,0,0,'true','false','false','true','false','none','0-0;'),
(4401,'Green Dimensional Stone','','false','none',10,'stackable','crystal','none',-1,-1,100000,0,'true','true','true','true','true','none','0-0;'),
(4402,'Blue Dimensional Stone','','false','none',10,'stackable','crystal','none',-1,-1,100000,0,'true','true','true','true','true','none','0-0;'),
(4403,'Red Dimensional Stone','','false','none',10,'stackable','crystal','none',-1,-1,100000,0,'true','true','true','true','true','none','0-0;'),
(4404,'Green Dimensional Stone - Shard','','false','none',10,'stackable','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4405,'Blue Dimensional Stone - Shard','','false','none',10,'stackable','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4406,'Red Dimensional Stone - Shard','','false','none',10,'stackable','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4407,'Bill of Iason Heine','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4408,'Musical Score - Theme of Love','','false','none',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4409,'Musical Score - Theme of Battle','','false','none',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4410,'Musical Score - Theme of Journey','','false','none',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4411,'Echo Crystal - Theme of Journey','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2069-1;'),
(4412,'Echo Crystal - Theme of Battle','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2068-1;'),
(4413,'Echo Crystal - Theme of Love','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2070-1;'),
(4414,'Echo Crystal - Theme of Solitude','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2072-1;'),
(4415,'Echo Crystal - Theme of the Feast','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2071-1;'),
(4416,'Echo Crystal - Theme of Celebration','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2073-1;'),
(4417,'Echo Crystal - Theme of Comedy','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2067-1;'),
(4418,'Musical Score - Theme of Celebration','','false','none',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4419,'Musical Score - Theme of Comedy','','false','none',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4420,'Musical Score - Theme of Solitude','','false','none',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4421,'Musical Score - Theme of the Feast','','false','none',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4422,'Dragon Bugle of Wind','','false','pet_collar',20,'normal','steel','none',-1,-1,0,0,'true','true','true','true','true','SummonItems','0-0;'),
(4423,'Dragon Bugle of Star','','false','pet_collar',20,'normal','steel','none',-1,-1,0,0,'true','true','true','true','true','SummonItems','0-0;'),
(4424,'Dragon Bugle of Dusk','','false','pet_collar',20,'normal','steel','none',-1,-1,0,0,'true','true','true','true','true','SummonItems','0-0;'),
(4425,'Penitent\'s Manacles','','false','pet_collar',800,'normal','steel','none',-1,-1,0,0,'false','false','false','false','false','SummonItems','0-0;'),
(4426,'Manacles of Penitent','','false','none',50,'normal','steel','none',-1,-1,22000,0,'true','false','true','true','false','none','0-0;'),
(4427,'Alligator Leather Belt','','false','none',20,'normal','leather','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4428,'Blue Alligator Leather Belt','','false','none',20,'normal','leather','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4429,'Bejeweled Leather Belt','','false','none',20,'normal','leather','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4430,'Alligator Leather Purse','','false','none',20,'normal','leather','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4431,'Blue Alligator Leather Purse','','false','none',20,'normal','leather','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4432,'Bejeweled Purse','','false','none',20,'normal','leather','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4433,'Elemental Stone Powder','','false','none',10,'stackable','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4434,'Elemental Stone Shards','','false','none',100,'stackable','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4435,'Elemental Stone Lump','','false','none',1000,'stackable','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4436,'Bentley\'s Request','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4437,'Carson\'s Request','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4438,'Knuckle Duster Edge','','false','material',60,'stackable','liquid','none',-1,-1,28044,0,'true','true','true','true','true','none','0-0;'),
(4439,'Avadon Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,2900,0,'true','true','true','true','true','none','0-0;'),
(4440,'Recipe: Knuckle Duster','','false','recipe',30,'stackable','liquid','none',-1,-1,57400,0,'true','true','true','true','true','Recipes','0-0;'),
(4441,'Recipe: Avadon Shield','','false','recipe',30,'stackable','liquid','none',-1,-1,10900,0,'true','true','true','true','true','Recipes','0-0;'),
(4442,'Lottery Ticket','','false','lotto',20,'normal','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4443,'Monster Race Ticket - Single','','false','race_ticket',20,'normal','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4444,'Monster Race Ticket - Double','','false','race_ticket',20,'normal','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4445,'Dye of STR <Str+1 Con-3>','','false','dye',150,'stackable','liquid','none',-1,-1,5100,0,'true','true','true','true','true','none','0-0;'),
(4446,'Dye of STR <Str+1 Dex-3>','','false','dye',150,'stackable','liquid','none',-1,-1,5100,0,'true','true','true','true','true','none','0-0;'),
(4447,'Dye of CON <Con+1 Str-3>','','false','dye',150,'stackable','liquid','none',-1,-1,5100,0,'true','true','true','true','true','none','0-0;'),
(4448,'Dye of CON <Con+1 Dex-3>','','false','dye',150,'stackable','liquid','none',-1,-1,5100,0,'true','true','true','true','true','none','0-0;'),
(4449,'Dye of DEX <Dex+1 Str-3>','','false','dye',150,'stackable','liquid','none',-1,-1,5100,0,'true','true','true','true','true','none','0-0;'),
(4450,'Dye of DEX <Dex+1 Con-3>','','false','dye',150,'stackable','liquid','none',-1,-1,5100,0,'true','true','true','true','true','none','0-0;'),
(4451,'Dye of INT <Int+1 Men-3>','','false','dye',150,'stackable','liquid','none',-1,-1,5100,0,'true','true','true','true','true','none','0-0;'),
(4452,'Dye of INT <Int+1 Wit-3>','','false','dye',150,'stackable','liquid','none',-1,-1,5100,0,'true','true','true','true','true','none','0-0;'),
(4453,'Dye of MEN <Men+1 Int-3>','','false','dye',150,'stackable','liquid','none',-1,-1,5100,0,'true','true','true','true','true','none','0-0;'),
(4454,'Dye of MEN <Men+1 Wit-3>','','false','dye',150,'stackable','liquid','none',-1,-1,5100,0,'true','true','true','true','true','none','0-0;'),
(4455,'Dye of WIT <Wit+1 Int-3>','','false','dye',150,'stackable','liquid','none',-1,-1,5100,0,'true','true','true','true','true','none','0-0;'),
(4456,'Dye of WIT <Wit+1 Men-3>','','false','dye',150,'stackable','liquid','none',-1,-1,5100,0,'true','true','true','true','true','none','0-0;'),
(4457,'Dye of STR <Str+1 Con-2>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4458,'Dye of STR <Str+1 Dex-2>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4459,'Dye of CON <Con+1 Str-2>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4460,'Dye of CON <Con+1 Dex-2>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4461,'Dye of DEX <Dex+1 Str-2>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4462,'Dye of DEX <Dex+1 Con-2>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4463,'Dye of INT <Int+1 Men-2>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4464,'Dye of INT <Int+1 Wit-2>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4465,'Dye of MEN <Men+1 Int-2>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4466,'Dye of MEN <Men+1 Wit-2>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4467,'Dye of WIT <Wit+1 Int-2>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4468,'Dye of WIT <Wit+1 Men-2>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4469,'Dye of STR <Str+1 Con-1>','','false','dye',150,'stackable','liquid','none',-1,-1,42000,0,'true','true','true','true','true','none','0-0;'),
(4470,'Dye of STR <Str+1 Dex-1>','','false','dye',150,'stackable','liquid','none',-1,-1,42000,0,'true','true','true','true','true','none','0-0;'),
(4471,'Dye of CON <Con+1 Str-1>','','false','dye',150,'stackable','liquid','none',-1,-1,42000,0,'true','true','true','true','true','none','0-0;'),
(4472,'Dye of CON <Con+1 Dex-1>','','false','dye',150,'stackable','liquid','none',-1,-1,42000,0,'true','true','true','true','true','none','0-0;'),
(4473,'Dye of DEX <Dex+1 Str-1>','','false','dye',150,'stackable','liquid','none',-1,-1,42000,0,'true','true','true','true','true','none','0-0;'),
(4474,'Dye of DEX <Dex+1 Con-1>','','false','dye',150,'stackable','liquid','none',-1,-1,42000,0,'true','true','true','true','true','none','0-0;'),
(4475,'Dye of INT <Int+1 Men-1>','','false','dye',150,'stackable','liquid','none',-1,-1,42000,0,'true','true','true','true','true','none','0-0;'),
(4476,'Dye of INT <Int+1 Wit-1>','','false','dye',150,'stackable','liquid','none',-1,-1,42000,0,'true','true','true','true','true','none','0-0;'),
(4477,'Dye of MEN <Men+1 Int-1>','','false','dye',150,'stackable','liquid','none',-1,-1,42000,0,'true','true','true','true','true','none','0-0;'),
(4478,'Dye of MEN <Men+1 Wit-1>','','false','dye',150,'stackable','liquid','none',-1,-1,42000,0,'true','true','true','true','true','none','0-0;'),
(4479,'Dye of WIT <Wit+1 Int-1>','','false','dye',150,'stackable','liquid','none',-1,-1,42000,0,'true','true','true','true','true','none','0-0;'),
(4480,'Dye of WIT <Wit+1 Men-1>','','false','dye',150,'stackable','liquid','none',-1,-1,42000,0,'true','true','true','true','true','none','0-0;'),
(4481,'Greater Dye of STR <Str+1 Con-3>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4482,'Greater Dye of STR <Str+1 Dex-3>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4483,'Greater Dye of CON<Con+1 Str-3>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4484,'Greater Dye of CON<Con+1 Dex-3>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4485,'Greater Dye of DEX <Dex+1 Str-3>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4486,'Greater Dye of DEX <Dex+1 Con-3>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4487,'Greater Dye of INT <Int+1 Men-3>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4488,'Greater Dye of INT <Int+1 Wit-3>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4489,'Greater Dye of MEN <Men+1 Int-3>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4490,'Greater Dye of MEN <Men+1 Wit-3>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4491,'Greater Dye of WIT <Wit+1 Int-3>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4492,'Greater Dye of WIT <Wit+1 Men-3>','','false','dye',150,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(4493,'Greater Dye of STR <Str+1 Con-2>','','false','dye',150,'stackable','liquid','none',-1,-1,21000,0,'true','true','true','true','true','none','0-0;'),
(4494,'Greater Dye of STR <Str+1 Dex-2>','','false','dye',150,'stackable','liquid','none',-1,-1,21000,0,'true','true','true','true','true','none','0-0;'),
(4495,'Greater Dye of CON <Con+1 Str-2>','','false','dye',150,'stackable','liquid','none',-1,-1,21000,0,'true','true','true','true','true','none','0-0;'),
(4496,'Greater Dye of CON <Con+1 Dex-2>','','false','dye',150,'stackable','liquid','none',-1,-1,21000,0,'true','true','true','true','true','none','0-0;'),
(4497,'Greater Dye of DEX <Dex+1 Str-2>','','false','dye',150,'stackable','liquid','none',-1,-1,21000,0,'true','true','true','true','true','none','0-0;'),
(4498,'Greater Dye of DEX <Dex+1 Con-2>','','false','dye',150,'stackable','liquid','none',-1,-1,21000,0,'true','true','true','true','true','none','0-0;'),
(4499,'Greater Dye of INT <Int+1 Men-2>','','false','dye',150,'stackable','liquid','none',-1,-1,21000,0,'true','true','true','true','true','none','0-0;'),
(4500,'Greater Dye of INT <Int+1 Wit-2>','','false','dye',150,'stackable','liquid','none',-1,-1,21000,0,'true','true','true','true','true','none','0-0;'),
(4501,'Greater Dye of MEN <Men+1 Int-2>','','false','dye',150,'stackable','liquid','none',-1,-1,21000,0,'true','true','true','true','true','none','0-0;'),
(4502,'Greater Dye of MEN <Men+1 Wit-2>','','false','dye',150,'stackable','liquid','none',-1,-1,21000,0,'true','true','true','true','true','none','0-0;'),
(4503,'Greater Dye of WIT <Wit+1 Int-2>','','false','dye',150,'stackable','liquid','none',-1,-1,21000,0,'true','true','true','true','true','none','0-0;'),
(4504,'Greater Dye of WIT <Wit+1 Men-2>','','false','dye',150,'stackable','liquid','none',-1,-1,21000,0,'true','true','true','true','true','none','0-0;'),
(4505,'Greater Dye of STR <Str+2 Con-4>','','false','dye',150,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','none','0-0;'),
(4506,'Greater Dye of STR <Str+2 Dex-4>','','false','dye',150,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','none','0-0;'),
(4507,'Greater Dye of CON <Con+2 Str-4>','','false','dye',150,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','none','0-0;'),
(4508,'Greater Dye of CON <Con+2 Dex-4>','','false','dye',150,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','none','0-0;'),
(4509,'Greater Dye of DEX <Dex+2 Str-4>','','false','dye',150,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','none','0-0;'),
(4510,'Greater Dye of DEX <Dex+2 Con-4>','','false','dye',150,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','none','0-0;'),
(4511,'Greater Dye of INT <Int+2 Men-4>','','false','dye',150,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','none','0-0;'),
(4512,'Greater Dye of INT <Int+2 Wit-4>','','false','dye',150,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','none','0-0;'),
(4513,'Greater Dye of MEN <Men+2 Int-4>','','false','dye',150,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','none','0-0;'),
(4514,'Greater Dye of MEN <Men+2 Wit-4>','','false','dye',150,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','none','0-0;'),
(4515,'Greater Dye of WIT <Wit+2 Int-4>','','false','dye',150,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','none','0-0;'),
(4516,'Greater Dye of WIT <Wit+2 Men-4>','','false','dye',150,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','none','0-0;'),
(4517,'Greater Dye of STR <Str+2 Con-3>','','false','dye',150,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(4518,'Greater Dye of STR <Str+2 Dex-3>','','false','dye',150,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(4519,'Greater Dye of CON <Con+2 Str-3>','','false','dye',150,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(4520,'Greater Dye of CON <Con+2 Dex-3>','','false','dye',150,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(4521,'Greater Dye of DEX <Dex+2 Str-3>','','false','dye',150,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(4522,'Greater Dye of DEX <Dex+2 Con-3>','','false','dye',150,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(4523,'Greater Dye of INT <Int+2 Men-3>','','false','dye',150,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(4524,'Greater Dye of INT <Int+2 Wit-3>','','false','dye',150,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(4525,'Greater Dye of MEN <Men+2 Int-3>','','false','dye',150,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(4526,'Greater Dye of MEN <Men+2 Wit-3>','','false','dye',150,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(4527,'Greater Dye of WIT <Wit+2 Int-3>','','false','dye',150,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(4528,'Greater Dye of WIT <Wit+2 Men-3>','','false','dye',150,'stackable','liquid','none',-1,-1,27000,0,'true','true','true','true','true','none','0-0;'),
(4529,'Greater Dye of STR <Str+3 Con-5>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4530,'Greater Dye of STR <Str+3 Dex-5>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4531,'Greater Dye of CON <Con+3 Str-5>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4532,'Greater Dye of CON <Con+3 Dex-5>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4533,'Greater Dye of DEX <Dex+3 Str-5>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4534,'Greater Dye of DEX <Dex+3 Con-5>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4535,'Greater Dye of INT <Int+3 Men-5>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4536,'Greater Dye of INT <Int+3 Wit-5>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4537,'Greater Dye of MEN <Men+3 Int-5>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4538,'Greater Dye of MEN <Men+3 Wit-5>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4539,'Greater Dye of WIT <Wit+3 Int-5>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4540,'Greater Dye of WIT <Wit+3 Men-5>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4541,'Greater Dye of STR <Str+3 Con-4>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4542,'Greater Dye of STR <Str+3 Dex-4>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4543,'Greater Dye of CON <Con+3 Str-4>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4544,'Greater Dye of CON <Con+3 Dex-4>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4545,'Greater Dye of DEX <Dex+3 Str-4>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4546,'Greater Dye of DEX <Dex+3 Con-4>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4547,'Greater Dye of INT <Int+3 Men-4>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4548,'Greater Dye of INT <Int+3 Wit-4>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4549,'Greater Dye of MEN <Men+3 Int-4>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4550,'Greater Dye of MEN <Men+3 Wit-4>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4551,'Greater Dye of WIT <Wit+3 Int-4>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4552,'Greater Dye of WIT <Wit+3 Men-4>','','false','dye',150,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','none','0-0;'),
(4553,'Greater Dye of STR <Str+1 Con-1>','','false','dye',150,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','none','0-0;'),
(4554,'Greater Dye of STR <Str+1 Dex-1>','','false','dye',150,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','none','0-0;'),
(4555,'Greater Dye of CON <Con+1 Str-1>','','false','dye',150,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','none','0-0;'),
(4556,'Greater Dye of CON <Con+1 Dex-1>','','false','dye',150,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','none','0-0;'),
(4557,'Greater Dye of DEX <Dex+1 Str-1>','','false','dye',150,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','none','0-0;'),
(4558,'Greater Dye of DEX <Dex+1 Con-1>','','false','dye',150,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','none','0-0;'),
(4559,'Greater Dye of INT <Int+1 Men-1>','','false','dye',150,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','none','0-0;'),
(4560,'Greater Dye of INT <Int+1 Wit-1>','','false','dye',150,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','none','0-0;'),
(4561,'Greater Dye of MEN <Men+1 Int-1>','','false','dye',150,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','none','0-0;'),
(4562,'Greater Dye of MEN <Men+1 Wit-1>','','false','dye',150,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','none','0-0;'),
(4563,'Greater Dye of WIT <Wit+1 Int-1>','','false','dye',150,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','none','0-0;'),
(4564,'Greater Dye of WIT <Wit+1 Men-1>','','false','dye',150,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','none','0-0;'),
(4565,'Greater Dye of STR <Str+4 Con-6>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4566,'Greater Dye of STR <Str+4 Dex-6>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4567,'Greater Dye of CON <Con+4 Str-6>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4568,'Greater Dye of CON <Con+4 Dex-6>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4569,'Greater Dye of DEX <Dex+4 Str-6>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4570,'Greater Dye of DEX <Dex+4 Con-6>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4571,'Greater Dye of INT <Int+4 Men-6>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4572,'Greater Dye of INT <Int+4 Wit-6>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4573,'Greater Dye of MEN <Men+4 Int-6>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4574,'Greater Dye of MEN <Men+4 Wit-6>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4575,'Greater Dye of WIT <Wit+4 Int-6>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4576,'Greater Dye of WIT <Wit+4 Men-6>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4577,'Greater Dye of STR <Str+4 Con-5>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4578,'Greater Dye of STR <Str+4 Dex-5>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4579,'Greater Dye of CON <Con+4 Str-5>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4580,'Greater Dye of CON <Con+4 Dex-5>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4581,'Greater Dye of DEX <Dex+4 Str-5>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4582,'Greater Dye of DEX <Dex+4 Con-5>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4583,'Greater Dye of INT <Int+4 Men-5>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4584,'Greater Dye of INT <Int+4 Wit-5>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4585,'Greater Dye of MEN <Men+4 Int-5>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4586,'Greater Dye of MEN <Men+4 Wit-5>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4587,'Greater Dye of WIT <Wit+4 Int-5>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4588,'Greater Dye of WIT <Wit+4 Men-5>','','false','dye',150,'stackable','liquid','none',-1,-1,36000,0,'true','true','true','true','true','none','0-0;'),
(4589,'Greater Dye of STR <Str+2 Con-2>','','false','dye',150,'stackable','liquid','none',-1,-1,72000,0,'true','true','true','true','true','none','0-0;'),
(4590,'Greater Dye of STR <Str+2 Dex-2>','','false','dye',150,'stackable','liquid','none',-1,-1,72000,0,'true','true','true','true','true','none','0-0;'),
(4591,'Greater Dye of CON <Con+2 Str-2>','','false','dye',150,'stackable','liquid','none',-1,-1,72000,0,'true','true','true','true','true','none','0-0;'),
(4592,'Greater Dye of CON <Con+2 Dex-2>','','false','dye',150,'stackable','liquid','none',-1,-1,72000,0,'true','true','true','true','true','none','0-0;'),
(4593,'Greater Dye of DEX <Dex+2 Str-2>','','false','dye',150,'stackable','liquid','none',-1,-1,72000,0,'true','true','true','true','true','none','0-0;'),
(4594,'Greater Dye of DEX <Dex+2 Con-2>','','false','dye',150,'stackable','liquid','none',-1,-1,72000,0,'true','true','true','true','true','none','0-0;'),
(4595,'Greater Dye of INT <Int+2 Men-2>','','false','dye',150,'stackable','liquid','none',-1,-1,72000,0,'true','true','true','true','true','none','0-0;'),
(4596,'Greater Dye of INT <Int+2 Wit-2>','','false','dye',150,'stackable','liquid','none',-1,-1,72000,0,'true','true','true','true','true','none','0-0;'),
(4597,'Greater Dye of MEN <Men+2 Int-2>','','false','dye',150,'stackable','liquid','none',-1,-1,72000,0,'true','true','true','true','true','none','0-0;'),
(4598,'Greater Dye of MEN <Men+2 Wit-2>','','false','dye',150,'stackable','liquid','none',-1,-1,72000,0,'true','true','true','true','true','none','0-0;'),
(4599,'Greater Dye of WIT <Wit+2 Int-2>','','false','dye',150,'stackable','liquid','none',-1,-1,72000,0,'true','true','true','true','true','none','0-0;'),
(4600,'Greater Dye of WIT <Wit+2 Men-2>','','false','dye',150,'stackable','liquid','none',-1,-1,72000,0,'true','true','true','true','true','none','0-0;'),
(4601,'Greater Dye of STR <Str+3 Con-3>','','false','dye',150,'stackable','liquid','none',-1,-1,108000,0,'true','true','true','true','true','none','0-0;'),
(4602,'Greater Dye of STR <Str+3 Dex-3>','','false','dye',150,'stackable','liquid','none',-1,-1,108000,0,'true','true','true','true','true','none','0-0;'),
(4603,'Greater Dye of CON <Con+3 Str-3>','','false','dye',150,'stackable','liquid','none',-1,-1,108000,0,'true','true','true','true','true','none','0-0;'),
(4604,'Greater Dye of CON <Con+3 Dex-3>','','false','dye',150,'stackable','liquid','none',-1,-1,108000,0,'true','true','true','true','true','none','0-0;'),
(4605,'Greater Dye of DEX <Dex+3 Str-3>','','false','dye',150,'stackable','liquid','none',-1,-1,108000,0,'true','true','true','true','true','none','0-0;'),
(4606,'Greater Dye of DEX <Dex+3 Con-3>','','false','dye',150,'stackable','liquid','none',-1,-1,108000,0,'true','true','true','true','true','none','0-0;'),
(4607,'Greater Dye of INT <Int+3 Men-3>','','false','dye',150,'stackable','liquid','none',-1,-1,108000,0,'true','true','true','true','true','none','0-0;'),
(4608,'Greater Dye of INT <Int+3 Wit-3>','','false','dye',150,'stackable','liquid','none',-1,-1,108000,0,'true','true','true','true','true','none','0-0;'),
(4609,'Greater Dye of MEN <Men+3 Int-3>','','false','dye',150,'stackable','liquid','none',-1,-1,108000,0,'true','true','true','true','true','none','0-0;'),
(4610,'Greater Dye of MEN <Men+3 Wit-3>','','false','dye',150,'stackable','liquid','none',-1,-1,108000,0,'true','true','true','true','true','none','0-0;'),
(4611,'Greater Dye of WIT <Wit+3 Int-3>','','false','dye',150,'stackable','liquid','none',-1,-1,108000,0,'true','true','true','true','true','none','0-0;'),
(4612,'Greater Dye of WIT <Wit+3 Men-3>','','false','dye',150,'stackable','liquid','none',-1,-1,108000,0,'true','true','true','true','true','none','0-0;'),
(4613,'Greater Dye of STR <Str+4 Con-4>','','false','dye',150,'stackable','liquid','none',-1,-1,174000,0,'true','true','true','true','true','none','0-0;'),
(4614,'Greater Dye of STR <Str+4 Dex-4>','','false','dye',150,'stackable','liquid','none',-1,-1,174000,0,'true','true','true','true','true','none','0-0;'),
(4615,'Greater Dye of CON <Con+4 Str-4>','','false','dye',150,'stackable','liquid','none',-1,-1,174000,0,'true','true','true','true','true','none','0-0;'),
(4616,'Greater Dye of CON <Con+4 Dex-4>','','false','dye',150,'stackable','liquid','none',-1,-1,174000,0,'true','true','true','true','true','none','0-0;'),
(4617,'Greater Dye of DEX <Dex+4 Str-4>','','false','dye',150,'stackable','liquid','none',-1,-1,174000,0,'true','true','true','true','true','none','0-0;'),
(4618,'Greater Dye of DEX <Dex+4 Con-4>','','false','dye',150,'stackable','liquid','none',-1,-1,174000,0,'true','true','true','true','true','none','0-0;'),
(4619,'Greater Dye of INT <Int+4 Men-4>','','false','dye',150,'stackable','liquid','none',-1,-1,174000,0,'true','true','true','true','true','none','0-0;'),
(4620,'Greater Dye of INT <Int+4 Wit-4>','','false','dye',150,'stackable','liquid','none',-1,-1,174000,0,'true','true','true','true','true','none','0-0;'),
(4621,'Greater Dye of MEN <Men+4 Int-4>','','false','dye',150,'stackable','liquid','none',-1,-1,174000,0,'true','true','true','true','true','none','0-0;'),
(4622,'Greater Dye of MEN <Men+4 Wit-4>','','false','dye',150,'stackable','liquid','none',-1,-1,174000,0,'true','true','true','true','true','none','0-0;'),
(4623,'Greater Dye of WIT <Wit+4 Int-4>','','false','dye',150,'stackable','liquid','none',-1,-1,174000,0,'true','true','true','true','true','none','0-0;'),
(4624,'Greater Dye of WIT <Wit+4 Men-4>','','false','dye',150,'stackable','liquid','none',-1,-1,174000,0,'true','true','true','true','true','none','0-0;'),
(4625,'Dice (Heart)','','false','none',0,'normal','steel','none',-1,-1,500,0,'true','false','true','true','true','RollingDice','0-0;'),
(4626,'Dice (Spade)','','false','none',0,'normal','steel','none',-1,-1,500,0,'true','false','true','true','true','RollingDice','0-0;'),
(4627,'Dice (Clover)','','false','none',0,'normal','steel','none',-1,-1,500,0,'true','false','true','true','true','RollingDice','0-0;'),
(4628,'Dice (Diamond)','','false','none',0,'normal','steel','none',-1,-1,500,0,'true','false','true','true','true','RollingDice','0-0;'),
(4629,'Red Soul Crystal','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4630,'Red Soul Crystal - Stage 1','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4631,'Red Soul Crystal - Stage 2','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4632,'Red Soul Crystal - Stage 3','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4633,'Red Soul Crystal - Stage 4','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4634,'Red Soul Crystal - Stage 5','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4635,'Red Soul Crystal - Stage 6','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4636,'Red Soul Crystal - Stage 7','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4637,'Red Soul Crystal - Stage 8','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4638,'Red Soul Crystal - Stage 9','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4639,'Red Soul Crystal - Stage 10','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4640,'Green Soul Crystal','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4641,'Green Soul Crystal - Stage 1','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4642,'Green Soul Crystal - Stage 2','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4643,'Green Soul Crystal - Stage 3','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4644,'Green Soul Crystal - Stage 4','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4645,'Green Soul Crystal - Stage 5','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4646,'Green Soul Crystal - Stage 6','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4647,'Green Soul Crystal - Stage 7','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4648,'Green Soul Crystal - Stage 8','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4649,'Green Soul Crystal - Stage 9','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4650,'Green Soul Crystal - Stage 10','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4651,'Blue Soul Crystal','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4652,'Blue Soul Crystal - Stage 1','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4653,'Blue Soul Crystal - Stage 2','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4654,'Blue Soul Crystal - Stage 3','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4655,'Blue Soul Crystal - Stage 4','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4656,'Blue Soul Crystal - Stage 5','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4657,'Blue Soul Crystal - Stage 6','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4658,'Blue Soul Crystal - Stage 7','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4659,'Blue Soul Crystal - Stage 8','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4660,'Blue Soul Crystal - Stage 9','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4661,'Blue Soul Crystal - Stage 10','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(4662,'Broken Red Soul Crystal','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4663,'Broken Green Soul Crystal','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4664,'Broken Blue Soul Crystal','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4666,'Reiria\'s Soul Orb','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4667,'Kernon\'s Infernium Scepter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4668,'Golkonda\'s Infernium Scepter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4669,'Hallate\'s Infernium Scepter','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4670,'Maestro Reorin\'s Hammer','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4671,'Maestro Reorin\'s Mold','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4672,'Infernium Varnish','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4673,'Red Pipette Knife','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4674,'Medal of Honor','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4675,'Medal of Friendship','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4676,'Medal of Victory','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(4677,'Potion of Critical Escape','','false','potion',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2074-1;'),
(4678,'Decrease Haste Potion','','false','potion',180,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2075-1;'),
(4679,'Bless of Eva','','false','potion',180,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','ItemSkills','2076-1;'),
(4680,'Potion of Revenge','','false','potion',180,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(4906,'Spellbook: Solar Spark','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(4907,'Spellbook: Solar Flare','','false','spellbook',120,'stackable','paper','none',-1,-1,900,0,'true','true','true','true','true','none','0-0;'),
(4908,'Spellbook: Shadow Spark','','false','spellbook',120,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(4909,'Spellbook: Shadow Flare','','false','spellbook',120,'stackable','paper','none',-1,-1,900,0,'true','true','true','true','true','none','0-0;'),
(4910,'Spellbook: Vampiric Rage','','false','spellbook',120,'stackable','paper','none',-1,-1,1800,0,'true','true','true','true','true','none','0-0;'),
(4911,'Spellbook: Curse Disease','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(4912,'Spellbook: Benediction','','false','spellbook',120,'stackable','paper','none',-1,-1,8200,0,'true','true','true','true','true','none','0-0;'),
(4913,'Spellbook: Word of Fear','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(4914,'Spellbook: Serenade of Eva','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(4915,'Blueprint: Summon Wild Hog Cannon','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(4916,'Spellbook: Energy Bolt','','false','spellbook',120,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(4917,'Spellbook: Aura Bolt','','false','spellbook',120,'stackable','paper','none',-1,-1,900,0,'true','true','true','true','true','none','0-0;'),
(4918,'Spellbook: Summon Kai the Cat','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(4919,'Spellbook: Summon Merrow the Unicorn','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(4920,'Spellbook: Summon Soulless','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(4921,'Blueprint: Summon Big Boom','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(4922,'Spellbook: Summon Binding Cubic','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(4923,'Spellbook: Summon Aqua Cubic','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(4924,'Spellbook: Summon Spark Cubic','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(4925,'Amulet: Pa\'agrio\'s Haste','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(4926,'Amulet: Soul Guard','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(4927,'Amulet: Chant of Revenge','','false','spellbook',120,'stackable','paper','none',-1,-1,7700,0,'true','true','true','true','true','none','0-0;'),
(4928,'Spellbook: Seed of Fire','','false','spellbook',120,'stackable','paper','none',-1,-1,7200,0,'true','true','true','true','true','none','0-0;'),
(4929,'Spellbook: Seed of Water','','false','spellbook',120,'stackable','paper','none',-1,-1,7200,0,'true','true','true','true','true','none','0-0;'),
(4930,'Spellbook: Seed of Wind','','false','spellbook',120,'stackable','paper','none',-1,-1,7200,0,'true','true','true','true','true','none','0-0;'),
(4931,'Spellbook: Aura Symphony','','false','spellbook',120,'stackable','paper','none',-1,-1,7200,0,'true','true','true','true','true','none','0-0;'),
(4932,'Spellbook: Inferno','','false','spellbook',120,'stackable','paper','none',-1,-1,7200,0,'true','true','true','true','true','none','0-0;'),
(4933,'Spellbook: Blizzard','','false','spellbook',120,'stackable','paper','none',-1,-1,7200,0,'true','true','true','true','true','none','0-0;'),
(4934,'Spellbook: Demon Wind','','false','spellbook',120,'stackable','paper','none',-1,-1,7200,0,'true','true','true','true','true','none','0-0;'),
(4935,'Spellbook: Elemental Symphony','','false','spellbook',120,'stackable','paper','none',-1,-1,7200,0,'true','true','true','true','true','none','0-0;'),
(4936,'Recipe: Avadon Shield (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10900,0,'true','true','true','true','true','Recipes','0-0;'),
(4937,'Recipe: Adamantite Earrings (70%)','','false','recipe',30,'stackable','liquid','none',-1,-1,12120,0,'true','true','true','true','true','Recipes','0-0;'),
(4938,'Recipe: Adamantite Ring (70%)','','false','recipe',30,'stackable','liquid','none',-1,-1,8080,0,'true','true','true','true','true','Recipes','0-0;'),
(4939,'Recipe: Adamantite Necklace (70%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16160,0,'true','true','true','true','true','Recipes','0-0;'),
(4940,'Recipe: Zubei\'s Breastplate (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,41600,0,'true','true','true','true','true','Recipes','0-0;'),
(4941,'Recipe: Zubei\'s Gaiters (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,26000,0,'true','true','true','true','true','Recipes','0-0;'),
(4942,'Recipe: Boots of Silence (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4943,'Recipe: Guardian\'s Boots (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4944,'Recipe: Avadon Breastplate (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,41600,0,'true','true','true','true','true','Recipes','0-0;'),
(4945,'Recipe: Avadon Gaiters (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,26000,0,'true','true','true','true','true','Recipes','0-0;'),
(4946,'Recipe: Zubei\'s Leather Shirt (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,31200,0,'true','true','true','true','true','Recipes','0-0;'),
(4947,'Recipe: Zubei\'s Leather Gaiters (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,19460,0,'true','true','true','true','true','Recipes','0-0;'),
(4948,'Recipe: Avadon Leather Armor (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,45600,0,'true','true','true','true','true','Recipes','0-0;'),
(4949,'Recipe: Tunic of Zubei (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,31200,0,'true','true','true','true','true','Recipes','0-0;'),
(4950,'Recipe: Stockings of Zubei (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,19460,0,'true','true','true','true','true','Recipes','0-0;'),
(4951,'Recipe: Avadon Robe (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,45600,0,'true','true','true','true','true','Recipes','0-0;'),
(4952,'Recipe: Avadon Circlet (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,15560,0,'true','true','true','true','true','Recipes','0-0;'),
(4953,'Recipe: Avadon Gloves (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4954,'Recipe: Chain Gloves of Silence (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4955,'Recipe: Guardian\'s Gloves (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4956,'Recipe: Gloves of Blessing (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4957,'Recipe: Boots of Blessing (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4958,'Recipe: Zubei\'s Boots (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4959,'Recipe: Avadon Boots (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4960,'Recipe: Zubei\'s Gauntlets (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10380,0,'true','true','true','true','true','Recipes','0-0;'),
(4961,'Recipe: Zubei\'s Shield (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10900,0,'true','true','true','true','true','Recipes','0-0;'),
(4962,'Recipe: Zubei\'s Helmet (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,15560,0,'true','true','true','true','true','Recipes','0-0;'),
(4963,'Recipe: Great Sword (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4964,'Recipe: Heavy War Axe (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4965,'Recipe: Sprite\'s Staff (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4966,'Recipe: Keshanberk (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4967,'Recipe: Sword of Valhalla (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4968,'Recipe: Kris (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4969,'Recipe: Hell Knife (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4970,'Recipe: Arthro Nail (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4971,'Recipe: Dark Elven Long Bow (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4972,'Recipe: Great Axe (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(4973,'Recipe: Earring of Black Ore (70%)','','false','recipe',30,'stackable','liquid','none',-1,-1,18480,0,'true','true','true','true','true','Recipes','0-0;'),
(4974,'Recipe: Ring of Black Ore (70%)','','false','recipe',30,'stackable','liquid','none',-1,-1,12320,0,'true','true','true','true','true','Recipes','0-0;'),
(4975,'Recipe: Necklace of Black Ore (70%)','','false','recipe',30,'stackable','liquid','none',-1,-1,24600,0,'true','true','true','true','true','Recipes','0-0;'),
(4976,'Recipe: Implosion Boots (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4977,'Recipe: Paradia Boots (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4978,'Recipe: Elemental Boots (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4979,'Recipe: Boots of Grace (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4980,'Recipe: Doom Shield (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16900,0,'true','true','true','true','true','Recipes','0-0;'),
(4981,'Recipe: Blue Wolf Breastplate (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,64400,0,'true','true','true','true','true','Recipes','0-0;'),
(4982,'Recipe: Blue Wolf Gaiters (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,40200,0,'true','true','true','true','true','Recipes','0-0;'),
(4983,'Recipe: Doom Plate Armor (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,94200,0,'true','true','true','true','true','Recipes','0-0;'),
(4984,'Recipe: Blue Wolf Leather Armor (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,70600,0,'true','true','true','true','true','Recipes','0-0;'),
(4985,'Recipe: Leather Armor of Doom (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,70600,0,'true','true','true','true','true','Recipes','0-0;'),
(4986,'Recipe: Blue Wolf Tunic (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,48200,0,'true','true','true','true','true','Recipes','0-0;'),
(4987,'Recipe: Tunic of Doom (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,48200,0,'true','true','true','true','true','Recipes','0-0;'),
(4988,'Recipe: Blue Wolf Stockings (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,30200,0,'true','true','true','true','true','Recipes','0-0;'),
(4989,'Recipe: Stockings of Doom (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,30200,0,'true','true','true','true','true','Recipes','0-0;'),
(4990,'Recipe: Blue Wolf Helmet (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,24200,0,'true','true','true','true','true','Recipes','0-0;'),
(4991,'Recipe: Doom Helmet (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,24200,0,'true','true','true','true','true','Recipes','0-0;'),
(4992,'Recipe: Blue Wolf Boots (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4993,'Recipe: Doom Gloves (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4994,'Recipe: Elemental Gloves (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4995,'Recipe: Gloves of Grace (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4996,'Recipe: Implosion Gauntlets (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4997,'Recipe: Paradia Gloves (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4998,'Recipe: Blue Wolf Gloves (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(4999,'Recipe: Doom Boots (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,16080,0,'true','true','true','true','true','Recipes','0-0;'),
(5000,'Recipe: Sword of Damascus (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(5001,'Recipe: Lance (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(5002,'Recipe: Deadman\'s Glory (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(5003,'Recipe: Art of Battle Axe (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(5004,'Recipe: Staff of Evil Spirits (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(5005,'Recipe: Demon Dagger (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(5006,'Recipe: Bellion Cestus (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(5007,'Recipe: Bow of Peril (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(5008,'Recipe: Pata (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,156600,0,'true','true','true','true','true','Recipes','0-0;'),
(5009,'Trophy of Alliance','','false','none',0,'normal','steel','none',-1,-1,50,0,'false','false','true','false','false','none','0-0;'),
(5010,'Echo Crystal - Theme of Victory','','false','none',10,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','ItemSkills','2066-1;'),
(5011,'Star of Destiny','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','false','false','false','none','0-0;'),
(5012,'Leikan\'s Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5013,'Spellbook: Elemental Assault','','false','spellbook',120,'stackable','paper','none',-1,-1,7200,0,'true','true','true','true','true','none','0-0;'),
(5014,'Spellbook: Elemental Symphony','','false','spellbook',120,'stackable','paper','none',-1,-1,7200,0,'true','true','true','true','true','none','0-0;'),
(5015,'Spellbook: Elemental Storm','','false','spellbook',120,'stackable','paper','none',-1,-1,7200,0,'true','true','true','true','true','none','0-0;'),
(5016,'Seed: Dark Coda','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(5017,'Seed: Red Coda','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(5018,'Seed: Chilly Coda','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(5019,'Seed: Blue Coda','','false','seed',1,'stackable','paper','none',-1,-1,10,0,'true','true','true','true','true','Seed','2097-1;'),
(5020,'Seed: Golden Coda','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(5021,'Seed: Lute Coda','','false','seed',1,'stackable','paper','none',-1,-1,30,0,'true','true','true','true','true','Seed','2097-1;'),
(5022,'Seed: Desert Coda','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(5023,'Seed: Blue Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5024,'Seed: Blue Coda','','false','seed',1,'stackable','paper','none',-1,-1,10,0,'true','true','true','true','true','Seed','2097-1;'),
(5025,'Seed: Golden Coda','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(5026,'Seed: Lute Coda','','false','seed',1,'stackable','paper','none',-1,-1,30,0,'true','true','true','true','true','Seed','2097-1;'),
(5027,'Seed: Desert Coda','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(5028,'Seed: Red Cobol','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-2;'),
(5029,'Seed: Chilly Cobol','','false','seed',1,'stackable','paper','none',-1,-1,25,0,'true','true','true','true','true','Seed','2097-2;'),
(5030,'Seed: Thorn Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5031,'Seed: Golden Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5032,'Seed: Great Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5033,'Seed: Red Cobol','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-2;'),
(5034,'Seed: Chilly Cobol','','false','seed',1,'stackable','paper','none',-1,-1,25,0,'true','true','true','true','true','Seed','2097-2;'),
(5035,'Seed: Blue Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5036,'Seed: Thorn Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5037,'Seed: Golden Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5038,'Seed: Great Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5039,'Seed: Red Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(5040,'Seed: Twin Codra','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5041,'Seed: Desert Codran','','false','seed',1,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','Seed','2097-3;'),
(5042,'Seed: Dark Coda','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(5043,'Seed: Red Coda','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(5044,'Seed: Blue Coda','','false','seed',1,'stackable','paper','none',-1,-1,10,0,'true','true','true','true','true','Seed','2097-1;'),
(5045,'Seed: Red Cobol','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-2;'),
(5046,'Seed: Chilly Cobol','','false','seed',1,'stackable','paper','none',-1,-1,25,0,'true','true','true','true','true','Seed','2097-2;'),
(5047,'Seed: Blue Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5048,'Seed: Thorn Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5049,'Seed: Sea Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5050,'Seed: Chilly Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(5051,'Seed: Blue Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5052,'Seed: Twin Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5053,'Seed: Thorn Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5054,'Seed: Golden Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5055,'Seed: Great Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5056,'Seed: Red Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(5057,'Seed: Chilly Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(5058,'Seed: Blue Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5059,'Seed: Twin Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5060,'Seed: Great Codran','','false','seed',1,'stackable','paper','none',-1,-1,75,0,'true','true','true','true','true','Seed','2097-3;'),
(5061,'Seed: Desert Codran','','false','seed',1,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','Seed','2097-3;'),
(5062,'Trash','','false','none',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5063,'Trash','','false','none',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5064,'Trash','','false','none',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5065,'Chilly Coda','','false','none',2,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','none','0-0;');

INSERT INTO `etcitem` VALUES
(5066,'Burning Coda','','false','none',2,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5067,'Blue Coda','','false','none',2,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5068,'Red Coda','','false','none',2,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','none','0-0;'),
(5069,'Golden Coda','','false','none',2,'stackable','paper','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(5070,'Desert Coda','','false','none',2,'stackable','paper','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(5071,'Lute Coda','','false','none',2,'stackable','paper','none',-1,-1,300,0,'true','true','true','true','true','none','0-0;'),
(5072,'Twin Coda','','false','none',2,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5073,'Dark Coda','','false','none',2,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','none','0-0;'),
(5074,'Shining Coda','','false','none',2,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5075,'Chilly Cobol','','false','none',2,'stackable','paper','none',-1,-1,250,0,'true','true','true','true','true','none','0-0;'),
(5076,'Burning Cobol','','false','none',2,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5077,'Blue Cobol','','false','none',2,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5078,'Red Cobol','','false','none',2,'stackable','paper','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(5079,'Golden Cobol','','false','none',2,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5080,'Desert Cobol','','false','none',2,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5081,'Sea Cobol','','false','none',2,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5082,'Thorn Cobol','','false','none',2,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5083,'Dapple Cobol','','false','none',2,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5084,'Great Cobol','','false','none',2,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5085,'Chilly Codran','','false','none',2,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5086,'Burning Codran','','false','none',2,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5087,'Blue Codran','','false','none',2,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5088,'Red Codran','','false','none',2,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5089,'Dapple Codran','','false','none',2,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5090,'Desert Codran','','false','none',2,'stackable','paper','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(5091,'Sea Codran','','false','none',2,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5092,'Twin Codran','','false','none',2,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5093,'Thorn Codran','','false','none',2,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5094,'Great Codran','','false','none',2,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','none','0-0;'),
(5095,'Mature Chilly Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5096,'Mature Burning Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5097,'Mature Blue Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5098,'Mature Red Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5099,'Mature Golden Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5100,'Mature Desert Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5101,'Mature Lute Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5102,'Mature Twin Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5103,'Mature Dark Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5104,'Mature Shining Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5105,'Mature Chilly Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5106,'Mature Burning Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5107,'Mature Blue Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5108,'Mature Red Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5109,'Mature Golden Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5110,'Mature Desert Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5111,'Mature Sea Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5112,'Mature Thorn Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5113,'Mature Dapple Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5114,'Mature Great Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5115,'Mature Chilly Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5116,'Mature Burning Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5117,'Mature Blue Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5118,'Mature Red Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5119,'Mature Dapple Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5120,'Mature Desert Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5121,'Mature Sea Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5122,'Mature Twin Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5123,'Mature Thorn Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5124,'Mature Great Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5125,'Harvester','','false','harvest',20,'normal','steel','none',-1,-1,500,0,'true','true','true','true','true','Harvester','2098-1;'),
(5126,'Dualsword Craft Stamp','','false','none',20,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(5134,'Compressed Package of Soulshots: No Grade','','false','shot',600,'normal','steel','none',-1,-1,2300,0,'true','true','true','true','true','ItemSkills','2078-1;'),
(5135,'Compressed Package of Soulshots: D-grade','','false','shot',450,'normal','steel','none',-1,-1,3300,0,'true','true','true','true','true','ItemSkills','2079-1;'),
(5136,'Compressed Package of Soulshots: C-grade','','false','shot',450,'normal','steel','none',-1,-1,4950,0,'true','true','true','true','true','ItemSkills','2080-1;'),
(5137,'Compressed Package of Soulshots: B-grade','','false','shot',300,'normal','steel','none',-1,-1,16500,0,'true','true','true','true','true','ItemSkills','2081-1;'),
(5138,'Compressed Package of Soulshots: A-grade','','false','shot',300,'normal','steel','none',-1,-1,26400,0,'true','true','true','true','true','ItemSkills','2082-1;'),
(5139,'Compressed Package of Soulshots: S-grade','','false','shot',300,'normal','steel','none',-1,-1,33000,0,'true','true','true','true','true','ItemSkills','2083-1;'),
(5140,'Compressed Package of Spiritshots: No Grade','','false','shot',750,'normal','steel','none',-1,-1,4950,0,'true','true','true','true','true','ItemSkills','2084-1;'),
(5141,'Compressed Package of Spiritshots: D-grade','','false','shot',750,'normal','steel','none',-1,-1,5940,0,'true','true','true','true','true','ItemSkills','2085-1;'),
(5142,'Compressed Package of Spiritshots: C-grade','','false','shot',450,'normal','steel','none',-1,-1,11550,0,'true','true','true','true','true','ItemSkills','2086-1;'),
(5143,'Compressed Package of Spiritshots: B-grade','','false','shot',450,'normal','steel','none',-1,-1,33000,0,'true','true','true','true','true','ItemSkills','2087-1;'),
(5144,'Compressed Package of Spiritshots: A-grade','','false','shot',300,'normal','steel','none',-1,-1,39600,0,'true','true','true','true','true','ItemSkills','2088-1;'),
(5145,'Compressed Package of Spiritshots: S-grade','','false','shot',300,'normal','steel','none',-1,-1,49500,0,'true','true','true','true','true','ItemSkills','2089-1;'),
(5146,'Compressed Package of Blessed Spiritshots: No Grade','','false','shot',750,'normal','steel','none',-1,-1,11550,0,'true','true','true','true','true','ItemSkills','2090-1;'),
(5147,'Compressed Package of Blessed Spiritshots: D-grade','','false','shot',750,'normal','steel','none',-1,-1,14850,0,'true','true','true','true','true','ItemSkills','2091-1;'),
(5148,'Compressed Package of Blessed Spiritshots: C-grade','','false','shot',450,'normal','steel','none',-1,-1,29700,0,'true','true','true','true','true','ItemSkills','2092-1;'),
(5149,'Compressed Package of Blessed Spiritshots: B-grade','','false','shot',450,'normal','steel','none',-1,-1,80850,0,'true','true','true','true','true','ItemSkills','2093-1;'),
(5150,'Compressed Package of Blessed Spiritshots: A-grade','','false','shot',300,'normal','steel','none',-1,-1,95700,0,'true','true','true','true','true','ItemSkills','2094-1;'),
(5151,'Compressed Package of Blessed Spiritshots: S-grade','','false','shot',300,'normal','steel','none',-1,-1,115500,0,'true','true','true','true','true','ItemSkills','2095-1;'),
(5152,'Magic Compressor','','false','none',10,'normal','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5153,'Recipe: Soulshot (D) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','Recipes','0-0;'),
(5154,'Recipe: Soulshot (C) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,25000,0,'true','true','true','true','true','Recipes','0-0;'),
(5155,'Recipe: Soulshot (B) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(5156,'Recipe: Soulshot (A) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,150000,0,'true','true','true','true','true','Recipes','0-0;'),
(5157,'Recipe: Soulshot (S) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,250000,0,'true','true','true','true','true','Recipes','0-0;'),
(5158,'Recipe: Spiritshot (D) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','Recipes','0-0;'),
(5159,'Recipe: Spiritshot (C) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,25000,0,'true','true','true','true','true','Recipes','0-0;'),
(5160,'Recipe: Spiritshot (B) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(5161,'Recipe: Spiritshot (A) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,150000,0,'true','true','true','true','true','Recipes','0-0;'),
(5162,'Recipe: Spiritshot (S) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,250000,0,'true','true','true','true','true','Recipes','0-0;'),
(5163,'Recipe: Blessed Spiritshot (D) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,30000,0,'true','true','true','true','true','Recipes','0-0;'),
(5164,'Recipe: Blessed Spiritshot (C) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','Recipes','0-0;'),
(5165,'Recipe: Blessed Spiritshot (B) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(5166,'Recipe: Blessed Spiritshot (A) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,180000,0,'true','true','true','true','true','Recipes','0-0;'),
(5167,'Recipe: Blessed Spiritshot (S) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,290000,0,'true','true','true','true','true','Recipes','0-0;'),
(5168,'Food for Strider','','false','none',10,'stackable','liquid','none',-1,-1,216,0,'true','true','true','true','true','PetFood','2101-1;'),
(5169,'Deluxe Food for Strider','','false','none',10,'stackable','liquid','none',-1,-1,300,0,'true','true','true','true','true','PetFood','2102-1;'),
(5192,'Rope of Magic: D-Grade','','false','none',2,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5193,'Rope of Magic: C-Grade','','false','none',2,'stackable','paper','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(5194,'Rope of Magic: B-Grade','','false','none',2,'stackable','paper','none',-1,-1,250,0,'true','true','true','true','true','none','0-0;'),
(5195,'Rope of Magic: A-Grade','','false','none',2,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5196,'Rope of Magic: S Grade','','false','none',2,'stackable','paper','none',-1,-1,1500,0,'true','true','true','true','true','none','0-0;'),
(5197,'Chest Key - Grade 8','','false','none',10,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','none','0-0;'),
(5198,'Chest Key - Grade 7','','false','none',10,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','none','0-0;'),
(5199,'Chest Key - Grade 6','','false','none',10,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','none','0-0;'),
(5200,'Chest Key - Grade 5','','false','none',10,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','none','0-0;'),
(5201,'Chest Key - Grade 4','','false','none',10,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','none','0-0;'),
(5202,'Chest Key - Grade 3','','false','none',10,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','none','0-0;'),
(5203,'Chest Key - Grade 2','','false','none',10,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','none','0-0;'),
(5204,'Chest Key - Grade 1','','false','none',10,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','none','0-0;'),
(5205,'Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(5206,'Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(5207,'Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(5208,'Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(5209,'Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(5210,'Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(5211,'Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(5212,'Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(5213,'Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(5214,'Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(5215,'Mercenary Posting Ticket (Teleporter1)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(5218,'Mercenary Posting Ticket (Teleporter2)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(5219,'Mercenary Posting Ticket (Teleporter3)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(5220,'Metal Hardener','','false','material',2,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(5221,'Seed: Chilly Cobol','','false','seed',1,'stackable','paper','none',-1,-1,25,0,'true','true','true','true','true','Seed','2097-2;'),
(5222,'Seed: Blue Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5223,'Seed: Thorn Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5224,'Seed: Golden Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5225,'Seed: Great Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5226,'Seed: Red Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(5227,'Seed: Sea Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5228,'Trash','','false','none',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5229,'Trash','','false','none',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5230,'Recipe: Mithril Arrow (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,80000,0,'true','true','true','true','true','Recipes','0-0;'),
(5231,'Recipe: Metal Hardener (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,2800,0,'true','true','true','true','true','Recipes','0-0;'),
(5232,'White Fabric','','false','quest',0,'stackable','cloth','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5234,'Mystery Potion','','false','potion',50,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','ItemSkills','2103-1;'),
(5235,'Facelifting Potion - A','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2122-1;'),
(5236,'Facelifting Potion - B','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2123-1;'),
(5237,'Facelifting Potion - C','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2124-1;'),
(5238,'Dye Potion - A','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2125-1;'),
(5239,'Dye Potion - B','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2126-1;'),
(5240,'Dye Potion - C','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2127-1;'),
(5241,'Dye Potion - D','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2128-1;'),
(5242,'Hair Style Change Potion - A','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2129-1;'),
(5243,'Hair Style Change Potion - B','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2130-1;'),
(5244,'Hair Style Change Potion - C','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2131-1;'),
(5245,'Hair Style Change Potion - D','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2132-1;'),
(5246,'Hair Style Change Potion - E','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2133-1;'),
(5247,'Hair Style Change Potion - F','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2134-1;'),
(5248,'Hair Style Change Potion - G','','false','potion',50,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2135-1;'),
(5249,'Commemorative Item: First Anniversary of Lineage II Service','','false','none',0,'normal','cloth','none',-1,-1,0,0,'false','false','false','false','false','none','0-0;'),
(5250,'Greater Compressed Package of Soulshots: No-grade','','false','shot',600,'normal','steel','none',-1,-1,7700,0,'true','true','true','true','true','ItemSkills','2104-1;'),
(5251,'Greater Compressed Package of Soulshots: D-grade','','false','shot',450,'normal','steel','none',-1,-1,11000,0,'true','true','true','true','true','ItemSkills','2105-1;'),
(5252,'Greater Compressed Package of Soulshots: C-grade','','false','shot',450,'normal','steel','none',-1,-1,16500,0,'true','true','true','true','true','ItemSkills','2106-1;'),
(5253,'Greater Compressed Package of Soulshots: B-grade','','false','shot',300,'normal','steel','none',-1,-1,55000,0,'true','true','true','true','true','ItemSkills','2107-1;'),
(5254,'Greater Compressed Package of Soulshots: A-grade','','false','shot',300,'normal','steel','none',-1,-1,88000,0,'true','true','true','true','true','ItemSkills','2108-1;'),
(5255,'Greater Compressed Package of Soulshots: S-grade','','false','shot',300,'normal','steel','none',-1,-1,120000,0,'true','true','true','true','true','ItemSkills','2109-1;'),
(5256,'Greater Compressed Package of Spiritshots: No-grade','','false','shot',750,'normal','steel','none',-1,-1,16500,0,'true','true','true','true','true','ItemSkills','2110-1;'),
(5257,'Greater Compressed Package of Spiritshots: D-grade','','false','shot',750,'normal','steel','none',-1,-1,19800,0,'true','true','true','true','true','ItemSkills','2111-1;'),
(5258,'Greater Compressed Package of Spiritshots: C-grade','','false','shot',450,'normal','steel','none',-1,-1,38500,0,'true','true','true','true','true','ItemSkills','2112-1;'),
(5259,'Greater Compressed Package of Spiritshots: B-grade','','false','shot',450,'normal','steel','none',-1,-1,110000,0,'true','true','true','true','true','ItemSkills','2113-1;'),
(5260,'Greater Compressed Package of Spiritshots: A-grade','','false','shot',300,'normal','steel','none',-1,-1,132000,0,'true','true','true','true','true','ItemSkills','2114-1;'),
(5261,'Greater Compressed Package of Spiritshots: S-grade','','false','shot',300,'normal','steel','none',-1,-1,180000,0,'true','true','true','true','true','ItemSkills','2115-1;'),
(5262,'Greater Compressed Package of Blessed Spiritshots: No-grade','','false','shot',750,'normal','steel','none',-1,-1,38500,0,'true','true','true','true','true','ItemSkills','2116-1;'),
(5263,'Greater Compressed Package of Blessed Spiritshots: D-grade','','false','shot',750,'normal','steel','none',-1,-1,49500,0,'true','true','true','true','true','ItemSkills','2117-1;'),
(5264,'Greater Compressed Package of Blessed Spiritshots: C-grade','','false','shot',450,'normal','steel','none',-1,-1,99000,0,'true','true','true','true','true','ItemSkills','2118-1;'),
(5265,'Greater Compressed Package of Blessed Spiritshots: B-grade','','false','shot',450,'normal','steel','none',-1,-1,269500,0,'true','true','true','true','true','ItemSkills','2119-1;'),
(5266,'Greater Compressed Package of Blessed Spiritshots: A-grade','','false','shot',300,'normal','steel','none',-1,-1,319000,0,'true','true','true','true','true','ItemSkills','2120-1;'),
(5267,'Greater Compressed Package of Blessed Spiritshots: S-grade','','false','shot',300,'normal','steel','none',-1,-1,419000,0,'true','true','true','true','true','ItemSkills','2121-1;'),
(5268,'Recipe: Greater Soulshot (D) Compressed Package (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','Recipes','0-0;'),
(5269,'Recipe: Greater Soulshot (C) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','Recipes','0-0;'),
(5270,'Recipe: Greater Soulshot (B) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(5271,'Recipe: Greater Soulshot (A) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,150000,0,'true','true','true','true','true','Recipes','0-0;'),
(5272,'Recipe: Greater Soulshot (S) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,250000,0,'true','true','true','true','true','Recipes','0-0;'),
(5273,'Recipe: Greater Spiritshot (D) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','Recipes','0-0;'),
(5274,'Recipe: Greater Spiritshot (C) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','Recipes','0-0;'),
(5275,'Recipe: Greater Spiritshot (B) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(5276,'Recipe: Greater Spiritshot (A) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,150000,0,'true','true','true','true','true','Recipes','0-0;'),
(5277,'Recipe: Greater Spiritshot (S) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,250000,0,'true','true','true','true','true','Recipes','0-0;'),
(5278,'Recipe: Greater Blessed Spiritshot (D) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,8000,0,'true','true','true','true','true','Recipes','0-0;'),
(5279,'Recipe: Greater Blessed Spiritshot (C) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,80000,0,'true','true','true','true','true','Recipes','0-0;'),
(5280,'Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,130000,0,'true','true','true','true','true','Recipes','0-0;'),
(5281,'Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,170000,0,'true','true','true','true','true','Recipes','0-0;'),
(5282,'Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,285000,0,'true','true','true','true','true','Recipes','0-0;'),
(5283,'Rice Cake','','false','potion',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5332,'Recipe: Sealed Dark Crystal Leather Armor(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,69400,0,'true','true','true','true','true','Recipes','0-0;'),
(5333,'Recipe: Sealed Dark Crystal Leather Armor(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,69400,0,'true','true','true','true','true','Recipes','0-0;'),
(5334,'Recipe: Sealed Tallum Leather Armor(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,101600,0,'true','true','true','true','true','Recipes','0-0;'),
(5335,'Recipe: Sealed Tallum Leather Armor(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,101600,0,'true','true','true','true','true','Recipes','0-0;'),
(5336,'Recipe: Sealed Leather Armor of Nightmare(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,154600,0,'true','true','true','true','true','Recipes','0-0;'),
(5337,'Recipe: Sealed Leather Armor of Nightmare(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,154600,0,'true','true','true','true','true','Recipes','0-0;'),
(5338,'Recipe: Sealed Majestic Leather Armor(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,154600,0,'true','true','true','true','true','Recipes','0-0;'),
(5339,'Recipe: Sealed Majestic Leather Armor(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,154600,0,'true','true','true','true','true','Recipes','0-0;'),
(5340,'Recipe: Sealed Dark Crystal Leggings(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,43400,0,'true','true','true','true','true','Recipes','0-0;'),
(5341,'Recipe: Sealed Dark Crystal Leggings(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,43400,0,'true','true','true','true','true','Recipes','0-0;'),
(5342,'Echo Crystal - Sad Song','','false','recipe',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5343,'Echo Crystal - Holy Song','','false','recipe',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5344,'Recipe: Inferno Earring(70%)','','false','recipe',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5345,'Recipe: Inferno Earring(70%)','','false','recipe',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5346,'Recipe: Sealed Tallum Tunic(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,69400,0,'true','true','true','true','true','Recipes','0-0;'),
(5347,'Recipe: Sealed Tallum Tunic(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,69400,0,'true','true','true','true','true','Recipes','0-0;'),
(5348,'Recipe: Sealed Dark Crystal Robe(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,101600,0,'true','true','true','true','true','Recipes','0-0;'),
(5349,'Recipe: Sealed Dark Crystal Robe(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,10160,0,'true','true','true','true','true','Recipes','0-0;'),
(5350,'Recipe: Sealed Nightmare Robe(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,154600,0,'true','true','true','true','true','Recipes','0-0;'),
(5351,'Recipe: Sealed Nightmare Robe(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,154600,0,'true','true','true','true','true','Recipes','0-0;'),
(5352,'Recipe: Sealed Majestic Robe(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,154600,0,'true','true','true','true','true','Recipes','0-0;'),
(5353,'Recipe: Sealed Majestic Robe(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,154600,0,'true','true','true','true','true','Recipes','0-0;'),
(5354,'Recipe: Sealed Tallum Stockings(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,43400,0,'true','true','true','true','true','Recipes','0-0;'),
(5355,'Recipe: Sealed Tallum Stockings(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,43400,0,'true','true','true','true','true','Recipes','0-0;'),
(5356,'Recipe: Phoenix Necklace(70%)','','false','recipe',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5357,'Recipe: Phoenix Necklace(100%)','','false','recipe',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5358,'Recipe: Inferno Necklace(70%)','','false','recipe',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5359,'Recipe: Inferno Necklace(100%)','','false','recipe',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5360,'Recipe: Phoenix Ring(70%)','','false','recipe',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5361,'Recipe: Phoenix Ring(100%)','','false','recipe',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5362,'Recipe: Inferno Ring(70%)','','false','recipe',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5363,'Recipe: Inferno Ring(100%)','','false','recipe',20,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5364,'Recipe: Sealed Dark Crystal Shield(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,24400,0,'true','true','true','true','true','Recipes','0-0;'),
(5365,'Recipe: Sealed Dark Crystal Shield(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,24400,0,'true','true','true','true','true','Recipes','0-0;'),
(5366,'Recipe: Sealed Shield of Nightmare(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,37000,0,'true','true','true','true','true','Recipes','0-0;'),
(5367,'Recipe: Sealed Shield of Nightmare(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,37000,0,'true','true','true','true','true','Recipes','0-0;'),
(5368,'Recipe: Sealed Dark Crystal Boots(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,23200,0,'true','true','true','true','true','Recipes','0-0;'),
(5369,'Recipe: Sealed Dark Crystal Boots(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,23200,0,'true','true','true','true','true','Recipes','0-0;'),
(5370,'Recipe: Sealed Tallum Boots(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,23200,0,'true','true','true','true','true','Recipes','0-0;'),
(5371,'Recipe: Sealed Tallum Boots(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,23200,0,'true','true','true','true','true','Recipes','0-0;'),
(5372,'Recipe: Sealed Boots of the Underworld(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,23200,0,'true','true','true','true','true','none','0-0;'),
(5373,'Recipe: Sealed Boots of the Underworld(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,23200,0,'true','true','true','true','true','none','0-0;'),
(5374,'Recipe: Sealed Gust Boots(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,23200,0,'true','true','true','true','true','none','0-0;'),
(5375,'Recipe: Sealed Gust Boots(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,23200,0,'true','true','true','true','true','none','0-0;'),
(5376,'Recipe: Sealed Red Flame Boots(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5377,'Recipe: Sealed Red Flame Boots(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5378,'Recipe: Sealed Phoenix Boots(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5379,'Recipe: Sealed Phoenix Boots(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5380,'Recipe: Sealed Boots of Nightmare(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,35200,0,'true','true','true','true','true','Recipes','0-0;'),
(5381,'Recipe: Sealed Boots of Nightmare(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5382,'Recipe: Sealed Majestic Boots(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,35200,0,'true','true','true','true','true','Recipes','0-0;'),
(5383,'Recipe: Sealed Majestic Boots(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5384,'Recipe: Sealed Dark Legion Boots(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5385,'Recipe: Sealed Dark Legion Boots(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5386,'Recipe: Sealed Boots of Phantom(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5387,'Recipe: Sealed Boots of Phantom(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5388,'Recipe: Sealed Cerberus Boots(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5389,'Recipe: Sealed Cerberus Boots(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5390,'Recipe: Sealed Dasparion\'s Boots Boots(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5391,'Recipe: Sealed Dasparion\'s Boots Boots(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5392,'Recipe: Sealed Dark Crystal Gloves(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,23200,0,'true','true','true','true','true','Recipes','0-0;'),
(5393,'Recipe: Sealed Dark Crystal Gloves(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5394,'Recipe: Sealed Tallum Gloves(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,23200,0,'true','true','true','true','true','Recipes','0-0;'),
(5395,'Recipe: Sealed Tallum Gloves(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5396,'Recipe: Sealed Gloves of the Underworld(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5397,'Recipe: Sealed Gloves of the Underworld(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5398,'Recipe: Sealed Gust Bracer(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5399,'Recipe: Sealed Gust Bracer(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5400,'Recipe: Sealed Gloves of Black Ore(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5401,'Recipe: Sealed Gloves of Black Ore(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5402,'Recipe: Sealed Phoenix Gloves(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5403,'Recipe: Sealed Phoenix Gloves(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5404,'Recipe: Sealed Gauntlets of Nightmare(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,35200,0,'true','true','true','true','true','Recipes','0-0;'),
(5405,'Recipe: Sealed Gauntlets of Nightmare(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5406,'Recipe: Sealed Majestic Gauntlets(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,35200,0,'true','true','true','true','true','Recipes','0-0;'),
(5407,'Recipe: Sealed Majestic Gauntlets(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5408,'Recipe: Sealed Dark Legion Gloves(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5409,'Recipe: Sealed Dark Legion Gloves(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5410,'Recipe: Sealed Gloves of Phantom(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5411,'Recipe: Sealed Gloves of Phantom(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5412,'Recipe: Sealed Cerberus Gloves(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5413,'Recipe: Sealed Cerberus Gloves(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5414,'Recipe: Sealed Dasparion\'s Gloves(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5415,'Recipe: Sealed Dasparion\'s Gloves(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5416,'Recipe: Sealed Dark Crystal Breastplate(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,92600,0,'true','true','true','true','true','Recipes','0-0;'),
(5417,'Recipe: Sealed Dark Crystal Breastplate(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5418,'Recipe: Sealed Tallum Plate Armor(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,135400,0,'true','true','true','true','true','Recipes','0-0;'),
(5419,'Recipe: Sealed Tallum Plate Armor(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5420,'Recipe: Sealed Armor of Nightmare(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,206000,0,'true','true','true','true','true','Recipes','0-0;'),
(5421,'Recipe: Sealed Armor of Nightmare(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5422,'Recipe: Sealed Majestic Plate Armor(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,206000,0,'true','true','true','true','true','Recipes','0-0;'),
(5423,'Recipe: Sealed Majestic Plate Armor(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5424,'Recipe: Sealed Dark Crystal Gaiters(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,57800,0,'true','true','true','true','true','Recipes','0-0;'),
(5425,'Recipe: Sealed Dark Crystal Gaiters(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5426,'Recipe: Sealed Dark Crystal Helmet(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,34800,0,'true','true','true','true','true','Recipes','0-0;'),
(5427,'Recipe: Sealed Dark Crystal Helmet(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5428,'Recipe: Sealed Tallum Helmet(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,34800,0,'true','true','true','true','true','Recipes','0-0;'),
(5429,'Recipe: Sealed Tallum Helmet(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5430,'Recipe: Sealed Helm of Nightmare(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,52800,0,'true','true','true','true','true','Recipes','0-0;'),
(5431,'Recipe: Sealed Helm of Nightmare(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5432,'Recipe: Sealed Majestic Circlet (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,52800,0,'true','true','true','true','true','Recipes','0-0;'),
(5433,'Recipe: Sealed Majestic Circlet (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5434,'Recipe: Dragon Slayer(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,540000,0,'true','true','true','true','true','Recipes','0-0;'),
(5435,'Recipe: Dragon Slayer(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5436,'Recipe: Berserker Blade(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(5437,'Recipe: Heavy Sword(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,8180,0,'true','true','true','true','true','Recipes','0-0;'),
(5438,'Recipe: Meteor Shower(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(5439,'Recipe: Meteor Shower(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5440,'Recipe: Elysian(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,540000,0,'true','true','true','true','true','Recipes','0-0;'),
(5441,'Recipe: Elysian(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5442,'Recipe: Soul Bow(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,540000,0,'true','true','true','true','true','Recipes','0-0;'),
(5443,'Recipe: Soul Bow(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5444,'Recipe: Carnage Bow(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(5445,'Recipe: Carnage Bow(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5446,'Recipe: Bloody Orchid(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(5447,'Recipe: Bloody Orchid(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5448,'Recipe: Soul Separator(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,540000,0,'true','true','true','true','true','Recipes','0-0;'),
(5449,'Recipe: Soul Separator(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5450,'Recipe: Dragon Grinder(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,540000,0,'true','true','true','true','true','Recipes','0-0;'),
(5451,'Recipe: Dragon Grinder(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5452,'Recipe: Blood Tornado(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(5453,'Recipe: Blood Tornado(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5454,'Recipe: Orcish Halberd(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5455,'Recipe: Orcish Halberd(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5456,'Recipe: Tallum Glaive(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,540000,0,'true','true','true','true','true','Recipes','0-0;'),
(5457,'Recipe: Tallum Glaive(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5458,'Recipe: Halberd(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(5459,'Recipe: Halberd(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5460,'Recipe: Dasparion\'s Staff(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(5461,'Recipe: Dasparion\'s Staff(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5462,'Recipe: Branch of the Mother Tree(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,540000,0,'true','true','true','true','true','Recipes','0-0;'),
(5463,'Recipe: Branch of the Mother Tree(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5464,'Recipe: Dark Legion\'s Edge(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,540000,0,'true','true','true','true','true','Recipes','0-0;'),
(5465,'Recipe: Dark Legion\'s Edge(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5466,'Recipe: Sword of Miracles(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,540000,0,'true','true','true','true','true','Recipes','0-0;'),
(5467,'Recipe: Sword of Miracles(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5468,'Recipe: Elemental Sword(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(5469,'Recipe: Elemental Sword(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5470,'Recipe: Tallum Blade(60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(5471,'Recipe: Tallum Blade(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5472,'Recipe: Metallic Thread(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','Recipes','0-0;'),
(5473,'Recipe: Durable Metal Plate(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,2800,0,'true','true','true','true','true','Recipes','0-0;'),
(5474,'Recipe: Reorin\'s Mold(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5475,'Recipe: Warsmith\'s Mold(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5476,'Recipe: Arcsmith\'s Anvil(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5477,'Recipe: Warsmith\'s Holder(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(5478,'Sealed Dark Crystal Leather Armor Pattern','','false','material',60,'stackable','liquid','none',-1,-1,23784,0,'true','true','true','true','true','none','0-0;'),
(5479,'Sealed Tallum Leather Armor Pattern','','false','material',60,'stackable','liquid','none',-1,-1,33800,0,'true','true','true','true','true','none','0-0;'),
(5480,'Sealed Leather Armor of Nightmare Fabric','','false','material',60,'stackable','liquid','none',-1,-1,44571,0,'true','true','true','true','true','none','0-0;'),
(5481,'Sealed Majestic Leather Armor Fabric','','false','material',60,'stackable','liquid','none',-1,-1,44571,0,'true','true','true','true','true','none','0-0;'),
(5482,'Sealed Dark Crystal Leggings Design','','false','material',60,'stackable','liquid','none',-1,-1,15153,0,'true','true','true','true','true','none','0-0;'),
(5483,'Phoenix Earring Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5484,'Inferno Earring Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5485,'Sealed Tallum Tunic Texture','','false','material',60,'stackable','liquid','none',-1,-1,23784,0,'true','true','true','true','true','none','0-0;'),
(5486,'Sealed Dark Crystal Robe Fabric','','false','material',60,'stackable','liquid','none',-1,-1,33800,0,'true','true','true','true','true','none','0-0;'),
(5487,'Sealed Nightmare Robe Fabric','','false','material',60,'stackable','liquid','none',-1,-1,44414,0,'true','true','true','true','true','none','0-0;'),
(5488,'Sealed Majestic Robe Fabric','','false','material',60,'stackable','liquid','none',-1,-1,44414,0,'true','true','true','true','true','none','0-0;'),
(5489,'Sealed Tallum Stockings Fabric','','false','material',60,'stackable','liquid','none',-1,-1,15153,0,'true','true','true','true','true','none','0-0;'),
(5490,'Phoenix Necklace Beads','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5491,'Inferno Necklace Beads','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5492,'Phoenix Ring Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5493,'Inferno Ring Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5494,'Sealed Dark Crystal Shield Fragment','','false','material',60,'stackable','liquid','none',-1,-1,9523,0,'true','true','true','true','true','none','0-0;'),
(5495,'Sealed Shield of Nightmare Fragment','','false','material',60,'stackable','liquid','none',-1,-1,13171,0,'true','true','true','true','true','none','0-0;'),
(5496,'Sealed Dark Crystal Boots Lining','','false','material',60,'stackable','liquid','none',-1,-1,8530,0,'true','true','true','true','true','none','0-0;'),
(5497,'Sealed Tallum Boots Lining','','false','material',60,'stackable','liquid','none',-1,-1,8530,0,'true','true','true','true','true','none','0-0;'),
(5498,'Sealed Boots of the Underworld Lining','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5499,'Sealed Gust Boots Lining','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5500,'Sealed Red Flame Boots Lining','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5501,'Sealed Phoenix Boots Lining','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5502,'Sealed Boots of Nightmare Lining','','false','material',60,'stackable','liquid','none',-1,-1,11842,0,'true','true','true','true','true','none','0-0;'),
(5503,'Sealed Majestic Boots Lining','','false','material',60,'stackable','liquid','none',-1,-1,11842,0,'true','true','true','true','true','none','0-0;'),
(5504,'Sealed Dark Legion Boots Lining','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5505,'Sealed Boots of Phantom Lining','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5506,'Sealed Cerberus Boots Lining','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5507,'Sealed Dasparion\'s Boots Lining','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5508,'Sealed Dark Crystal Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,8530,0,'true','true','true','true','true','none','0-0;'),
(5509,'Sealed Tallum Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,8530,0,'true','true','true','true','true','none','0-0;'),
(5510,'Sealed Gloves of the Underworld Design','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5511,'Sealed Gust Bracer design','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5512,'Sealed Gloves of Black Ore Design','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5513,'Sealed Phoenix Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5514,'Sealed Gauntlets of Nightmare Design','','false','material',60,'stackable','liquid','none',-1,-1,11842,0,'true','true','true','true','true','none','0-0;'),
(5515,'Sealed Majestic Gauntlets Design','','false','material',60,'stackable','liquid','none',-1,-1,11842,0,'true','true','true','true','true','none','0-0;'),
(5516,'Sealed Dark Legion Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5517,'Sealed Gloves of Phantom Design','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5518,'Sealed Cerberus Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5519,'Sealed Dasparion\'s Gloves Design','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5520,'Sealed Dark Crystal Breastplate Pattern','','false','material',60,'stackable','liquid','none',-1,-1,31015,0,'true','true','true','true','true','none','0-0;'),
(5521,'Sealed Tallum Plate Armor Pattern','','false','material',60,'stackable','liquid','none',-1,-1,43953,0,'true','true','true','true','true','none','0-0;'),
(5522,'Sealed Armor of Nightmare Pattern','','false','material',60,'stackable','liquid','none',-1,-1,58728,0,'true','true','true','true','true','none','0-0;'),
(5523,'Sealed Majestic Plate Armor Pattern','','false','material',60,'stackable','liquid','none',-1,-1,58728,0,'true','true','true','true','true','none','0-0;'),
(5524,'Sealed Dark Crystal Gaiters Pattern','','false','material',60,'stackable','liquid','none',-1,-1,20292,0,'true','true','true','true','true','none','0-0;'),
(5525,'Sealed Dark Crystal Helmet Design','','false','material',60,'stackable','liquid','none',-1,-1,12938,0,'true','true','true','true','true','none','0-0;'),
(5526,'Sealed Tallum Helm Design','','false','material',60,'stackable','liquid','none',-1,-1,12938,0,'true','true','true','true','true','none','0-0;'),
(5527,'Sealed Helm of Nightmare Design','','false','material',60,'stackable','liquid','none',-1,-1,16728,0,'true','true','true','true','true','none','0-0;'),
(5528,'Sealed Majestic Circlet Design','','false','material',60,'stackable','liquid','none',-1,-1,16728,0,'true','true','true','true','true','none','0-0;'),
(5529,'Dragon Slayer Edge','','false','material',60,'stackable','liquid','none',-1,-1,72900,0,'true','true','true','true','true','none','0-0;'),
(5530,'Berserker Blade Edge','','false','material',60,'stackable','liquid','none',-1,-1,43600,0,'true','true','true','true','true','none','0-0;'),
(5531,'Heavy Sword Edge','','false','material',60,'stackable','liquid','none',-1,-1,11912,0,'true','true','true','true','true','none','0-0;'),
(5532,'Meteor Shower Head','','false','material',60,'stackable','liquid','none',-1,-1,59308,0,'true','true','true','true','true','none','0-0;'),
(5533,'Elysian Head','','false','material',60,'stackable','liquid','none',-1,-1,72914,0,'true','true','true','true','true','none','0-0;'),
(5534,'Soul Bow Stave','','false','material',60,'stackable','liquid','none',-1,-1,72850,0,'true','true','true','true','true','none','0-0;'),
(5535,'Carnage Bow Stave','','false','material',60,'stackable','liquid','none',-1,-1,58615,0,'true','true','true','true','true','none','0-0;'),
(5536,'Bloody Orchid Head','','false','material',60,'stackable','liquid','none',-1,-1,58785,0,'true','true','true','true','true','none','0-0;'),
(5537,'Soul Separator Head','','false','material',60,'stackable','liquid','none',-1,-1,72900,0,'true','true','true','true','true','none','0-0;'),
(5538,'Dragon Grinder Edge','','false','material',60,'stackable','liquid','none',-1,-1,72914,0,'true','true','true','true','true','none','0-0;'),
(5539,'Blood Tornado Edge','','false','material',60,'stackable','liquid','none',-1,-1,59308,0,'true','true','true','true','true','none','0-0;'),
(5540,'Orcish Halberd Edge','','false','material',60,'stackable','liquid','none',-1,-1,62500,0,'true','true','true','true','true','none','0-0;'),
(5541,'Tallum Glaive Edge','','false','material',60,'stackable','liquid','none',-1,-1,72929,0,'true','true','true','true','true','none','0-0;'),
(5542,'Halberd Edge','','false','material',60,'stackable','liquid','none',-1,-1,59308,0,'true','true','true','true','true','none','0-0;'),
(5543,'Dasparion\'s Staff Edge','','false','material',60,'stackable','liquid','none',-1,-1,58754,0,'true','true','true','true','true','none','0-0;'),
(5544,'Branch of the Mother Tree Head','','false','material',60,'stackable','liquid','none',-1,-1,72986,0,'true','true','true','true','true','none','0-0;'),
(5545,'Dark Legion\'s Edge Blade','','false','material',60,'stackable','liquid','none',-1,-1,72900,0,'true','true','true','true','true','none','0-0;'),
(5546,'Sword of Miracles Edge','','false','material',60,'stackable','liquid','none',-1,-1,66369,0,'true','true','true','true','true','none','0-0;'),
(5547,'Elemental Sword Edge','','false','material',60,'stackable','liquid','none',-1,-1,58785,0,'true','true','true','true','true','none','0-0;'),
(5548,'Tallum Blade Edge','','false','material',60,'stackable','liquid','none',-1,-1,58785,0,'true','true','true','true','true','none','0-0;'),
(5549,'Metallic Thread','','false','material',2,'stackable','liquid','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(5550,'Durable Metal Plate','','false','material',2,'stackable','liquid','none',-1,-1,15000,0,'true','true','true','true','true','none','0-0;'),
(5551,'Leolin\'s Mold','','false','material',2,'stackable','liquid','none',-1,-1,238000,0,'true','true','true','true','true','none','0-0;'),
(5552,'Warsmith\'s Mold','','false','material',2,'stackable','liquid','none',-1,-1,385000,0,'true','true','true','true','true','none','0-0;'),
(5553,'Arcsmith\'s Anvil','','false','material',2,'stackable','liquid','none',-1,-1,531200,0,'true','true','true','true','true','none','0-0;'),
(5554,'Warsmith\'s Holder','','false','material',2,'stackable','liquid','none',-1,-1,884000,0,'true','true','true','true','true','none','0-0;'),
(5555,'Token of Love','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','SpecialXMas','0-0;'),
(5556,'Star Ornament','','false','material',0,'stackable','liquid','none',-1,-1,1,0,'true','true','true','true','true','none','0-0;'),
(5557,'Bead Ornament','','false','material',0,'stackable','liquid','none',-1,-1,1,0,'true','true','true','true','true','none','0-0;'),
(5558,'Fir Tree Branch','','false','material',0,'stackable','liquid','none',-1,-1,1,0,'true','true','true','true','true','none','0-0;'),
(5559,'Flower Pot','','false','material',0,'stackable','liquid','none',-1,-1,1,0,'true','true','true','true','true','none','0-0;'),
(5560,'Christmas Tree','','false','potion',0,'stackable','paper','none',-1,-1,1,0,'true','true','true','true','true','SummonItems','2137-1;'),
(5561,'Special Christmas Tree','','false','potion',0,'stackable','paper','none',-1,-1,1,0,'true','true','true','true','true','SummonItems','2138-1;'),
(5562,'Echo Crystal - 1st Carol','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2140-1;'),
(5563,'Echo Crystal - 2nd Carol','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2141-1;'),
(5564,'Echo Crystal - 3rd Carol','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2142-1;'),
(5565,'Echo Crystal - 4th Carol','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2143-1;'),
(5566,'Echo Crystal - 5th Carol','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2144-1;'),
(5567,'Letter of Greetings','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5568,'Letter of Greetings','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5569,'Water Rune','','false','none',0,'stackable','gold','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5570,'Water Mantra','','false','none',0,'stackable','gold','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5571,'Wind Rune','','false','none',0,'stackable','gold','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5572,'Wind Mantra','','false','none',0,'stackable','gold','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5573,'Fire Rune','','false','none',0,'stackable','gold','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5574,'Fire Mantra','','false','none',0,'stackable','gold','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5575,'Ancient Adena','','false','none',0,'asset','gold','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5577,'Red Soul Crystal - Stage 11','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(5578,'Green Soul Crystal - Stage 11','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(5579,'Blue Soul Crystal - Stage 11','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(5580,'Red Soul Crystal - Stage 12','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(5581,'Green Soul Crystal - Stage 12','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(5582,'Blue Soul Crystal - Stage 12','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(5583,'Echo Crystal - 6th Carol','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2145-1;'),
(5584,'Echo Crystal - 7th Carol','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2146-1;'),
(5585,'Echo Crystal - 8th Carol','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2147-1;'),
(5586,'Echo Crystal - 9th Carol','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2148-1;'),
(5587,'Echo Crystal - 10th Carol','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2149-1;'),
(5588,'Tutorial Guide','','false','none',10,'normal','liquid','none',-1,-1,1,0,'true','false','true','true','true','Book','0-0;'),
(5589,'Energy Stone','','false','potion',10,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','ItemSkills','2165-1;'),
(5591,'CP Potion','','false','potion',25,'stackable','liquid','none',-1,-1,240,0,'true','true','true','true','true','ItemSkills','2166-1;'),
(5592,'Greater CP Potion','','false','potion',100,'stackable','liquid','none',-1,-1,600,0,'true','true','true','true','true','ItemSkills','2166-2;'),
(5593,'SP Scroll: Low Grade','','false','scroll',30,'stackable','paper','none',-1,-1,2400,0,'true','true','true','true','true','ItemSkills','2167-1;'),
(5594,'SP Scroll: Medium Grade','','false','scroll',30,'stackable','paper','none',-1,-1,24000,0,'true','true','true','true','true','ItemSkills','2167-2;'),
(5595,'SP Scroll: High Grade','','false','scroll',30,'stackable','paper','none',-1,-1,480000,0,'true','true','true','true','true','ItemSkills','2167-3;'),
(5650,'Alternative Dark Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(5651,'Alternative Red Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(5652,'Alternative Chilly Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(5653,'Alternative Blue Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,10,0,'true','true','true','true','true','Seed','2097-1;'),
(5654,'Alternative Golden Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(5655,'Alternative Lute Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,30,0,'true','true','true','true','true','Seed','2097-1;'),
(5656,'Alternative Desert Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(5657,'Alternative Blue Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5658,'Alternative Blue Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,10,0,'true','true','true','true','true','Seed','2097-1;'),
(5659,'Alternative Golden Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(5660,'Alternative Lute Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,30,0,'true','true','true','true','true','Seed','2097-1;'),
(5661,'Alternative Desert Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(5662,'Alternative Red Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-2;'),
(5663,'Alternative Chilly Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,25,0,'true','true','true','true','true','Seed','2097-2;'),
(5664,'Alternative Thorn Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5665,'Alternative Golden Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5666,'Alternative Great Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-2;'),
(5667,'Alternative Red Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-2;'),
(5668,'Alternative Chilly Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,25,0,'true','true','true','true','true','Seed','2097-2;'),
(5669,'Alternative Blue Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5670,'Alternative Thorn Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5671,'Alternative Golden Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5672,'Alternative Great Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-2;'),
(5673,'Alternative Red Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(5674,'Alternative Twin Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5675,'Alternative Desert Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','Seed','2097-3;'),
(5676,'Alternative Dark Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(5677,'Alternative Red Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(5678,'Alternative Blue Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,10,0,'true','true','true','true','true','Seed','2097-1;'),
(5679,'Alternative Red Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-2;'),
(5680,'Alternative Chilly Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,25,0,'true','true','true','true','true','Seed','2097-2;'),
(5681,'Alternative Blue Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5682,'Alternative Thorn Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5683,'Alternative Sea Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5684,'Alternative Chilly Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(5685,'Alternative Blue Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5686,'Alternative Twin Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5687,'Alternative Thorn Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5688,'Alternative Golden Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5689,'Alternative Great Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-2;'),
(5690,'Alternative Red Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(5691,'Alternative Chilly Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(5692,'Alternative Blue Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5693,'Alternative Twin Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5694,'Alternative Great Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,75,0,'true','true','true','true','true','Seed','2097-3;'),
(5695,'Alternative Desert Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','Seed','2097-3;'),
(5696,'Alternative Chilly Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,25,0,'true','true','true','true','true','Seed','2097-2;'),
(5697,'Alternative Blue Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5698,'Alternative Thorn Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5699,'Alternative Golden Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(5700,'Alternative Great Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-2;'),
(5701,'Alternative Red Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(5702,'Alternative Sea Codran Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(5703,'Lucky Charm','','false','scroll',10,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','ItemSkills','2168-1;'),
(5707,'Record of Seven Signs','','false','none',0,'normal','liquid','none',-1,-1,600,0,'true','true','true','true','true','SevenSignsRecord','0-0;'),
(5708,'Lord of the Manor\'s Certificate of Approval','','false','ticket_of_lord',0,'normal','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5741,'Recipe: Sealed Zubei\'s Gauntlets (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5742,'Recipe: Zubei\'s Gauntlets (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5743,'Recipe: Sealed Avadon Gloves (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5744,'Recipe: Sealed Avadon Gloves (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5745,'Recipe: Sealed Blue Wolf Gloves (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5746,'Recipe: Sealed Blue Wolf Gloves (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5747,'Recipe: Sealed Doom Gloves (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5748,'Recipe: Sealed Doom Gloves (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5749,'Recipe: Sealed Zubei\'s Boots (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5750,'Recipe: Sealed Zubei\'s Boots (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5751,'Recipe: Sealed Avadon Boots (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5752,'Recipe: Sealed Avadon Boots (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5753,'Recipe: Sealed Blue Wolf Boots (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5754,'Recipe: Sealed Blue Wolf Boots (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5755,'Recipe: Sealed Boots of Doom (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5756,'Recipe: Sealed Boots of Doom (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5757,'Sealed Zubei\'s Gauntlet Part','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5758,'Sealed Avadon Gloves Part','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5759,'Sealed Blue Wolf Gloves Fabric','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5760,'Sealed Doom Gloves Part','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5761,'Sealed Zubei\'s Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5762,'Sealed Avadon Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5763,'Sealed Blue Wolf Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5764,'Sealed Doom Boots Part','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5789,'Soulshot: No Grade for Beginners','','false','none',1,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','true','SoulShots','2039-1;'),
(5790,'Spiritshot: No Grade for Beginners','','false','none',1,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','true','SpiritShot','2061-1;'),
(5803,'Lucky Charm: D-Grade','','false','scroll',10,'stackable','paper','none',-1,-1,300,0,'true','true','true','true','true','ItemSkills','2168-2;'),
(5804,'Lucky Charm: C-Grade','','false','scroll',10,'stackable','paper','none',-1,-1,660,0,'true','true','true','true','true','ItemSkills','2168-3;'),
(5805,'Lucky Charm: B-Grade','','false','scroll',10,'stackable','paper','none',-1,-1,1300,0,'true','true','true','true','true','ItemSkills','2168-4;'),
(5806,'Lucky Charm: A-Grade','','false','scroll',10,'stackable','paper','none',-1,-1,2700,0,'true','true','true','true','true','ItemSkills','2168-5;'),
(5807,'Lucky Charm: S Grade','','false','scroll',10,'stackable','paper','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2168-6;'),
(5809,'Spellbook: Aqua Splash','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(5810,'Spellbook: Rain of Fire','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(5811,'Spellbook: Mass Slow','','false','spellbook',120,'stackable','paper','none',-1,-1,7700,0,'true','true','true','true','true','none','0-0;'),
(5812,'Spellbook: Servitor Empowerment','','false','spellbook',120,'stackable','paper','none',-1,-1,5400,0,'true','true','true','true','true','none','0-0;'),
(5813,'Spellbook: Servitor Cure','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(5814,'Spellbook: Servitor Blessing','','false','spellbook',120,'stackable','paper','none',-1,-1,7700,0,'true','true','true','true','true','none','0-0;'),
(5815,'Spellbook: Wild Magic','','false','spellbook',120,'stackable','paper','none',-1,-1,7700,0,'true','true','true','true','true','none','0-0;'),
(5816,'Spellbook: Advanced Block','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(5818,'Alternative Dark Coda','','false','none',2,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','none','0-0;'),
(5819,'Alternative Red Coda','','false','none',2,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','none','0-0;'),
(5820,'Alternative Chilly Coda','','false','none',2,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','none','0-0;'),
(5821,'Alternative Blue Coda','','false','none',2,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5822,'Alternative Golden Coda','','false','none',2,'stackable','paper','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(5823,'Alternative Lute Coda','','false','none',2,'stackable','paper','none',-1,-1,300,0,'true','true','true','true','true','none','0-0;'),
(5824,'Alternative Desert Coda','','false','none',2,'stackable','paper','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(5825,'Alternative Red Cobol','','false','none',2,'stackable','paper','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(5826,'Alternative Chilly Cobol','','false','none',2,'stackable','paper','none',-1,-1,250,0,'true','true','true','true','true','none','0-0;'),
(5827,'Alternative Blue Cobol','','false','none',2,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5828,'Alternative Thorn Cobol','','false','none',2,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5829,'Alternative Golden Cobol','','false','none',2,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5830,'Alternative Great Cobol','','false','none',2,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5831,'Alternative Red Codran','','false','none',2,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5832,'Alternative Sea Codran','','false','none',2,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5833,'Alternative Chilly Codran','','false','none',2,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5834,'Alternative Blue Codran','','false','none',2,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5835,'Alternative Twin Codran','','false','none',2,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5836,'Alternative Great Codran','','false','none',2,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','none','0-0;'),
(5837,'Alternative Desert Codran','','false','none',2,'stackable','paper','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(5838,'Mature Alternative Dark Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5839,'Mature Alternative Red Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5840,'Mature Alternative Chilly Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5841,'Mature Alternative Blue Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5842,'Mature Alternative Golden Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5843,'Mature Alternative Lute Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5844,'Mature Alternative Desert Coda','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5845,'Mature Alternative Red Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5846,'Mature Alternative Chilly Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5847,'Mature Alternative Blue Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5848,'Mature Alternative Thorn Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5849,'Mature Alternative Golden Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5850,'Mature Alternative Great Cobol','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5851,'Mature Alternative Red Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5852,'Mature Alternative Sea Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5853,'Mature Alternative Chilly Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5854,'Mature Alternative Blue Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5855,'Mature Alternative Twin Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5856,'Mature Alternative Great Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5857,'Mature Alternative Desert Codran','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5858,'Blessed Scroll of Escape: Clan Hall','','false','scroll',120,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','ItemSkills','2177-1;'),
(5859,'Blessed Scroll of Escape: Castle','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2178-1;'),
(5860,'Lienrik Egg','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5861,'Lienrik Egg','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5862,'Stone of Contract','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5863,'Alligator Tooth','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5864,'Mysterious Map Piece','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5865,'Carnivore Spore','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5866,'Herbivorous Spore','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5867,'Jade Crystal','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5868,'Snake Scale','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5869,'Remains of Aden Residents','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5870,'Receipt of Supply','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5871,'Suspicious Document Piece','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5872,'Supply Items','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5873,'Pirate\'s Treasure Chest','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5874,'Sairon\'s Silver Hair','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5875,'Titan Lamp','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5876,'Titan Lamp','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5877,'Titan Lamp','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5878,'Titan Lamp','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5879,'Titan Lamp','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5880,'Broken Titan Lamp','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5881,'Blade Stakato Fang','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5882,'Flare Shard','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5883,'Freezing Shard','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5884,'Cave Beast Tooth','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5885,'Death Wave Light','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5886,'Sealed Mysterious Stone','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5887,'Mysterious Stone','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5888,'Karik Horn','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5889,'Cave Howler Skull','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5890,'Mysterious Book','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5891,'Ancient Language Dictionary: Basic Level','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5892,'Ancient Language Dictionary: Intermediate Level','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5893,'Leaf of Eucalyptus','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5894,'Stone of Chill','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5895,'Ritron\'s Fruit','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5896,'Moon Face Flower','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5897,'Leech Fluids','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5898,'Royal Membership','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5899,'Kail\'s Coin','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5900,'Coin Collecting Album','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5901,'Blood Offering','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5902,'Scroll of Ancient Magic','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5903,'Ancient Ash Urn','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5904,'Wesley\'s Mixing Stone','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5905,'Magister\'s Mixing Stone','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(5906,'Five-Year Anniversary Gift Box (10 Honey Rice Cake Set)','','false','scroll',100,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5907,'Five-Year Anniversary Gift Box (9 Honey Rice Cake Set)','','false','scroll',100,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5908,'Red Soul Crystal: Stage 13','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(5909,'Five-Year Anniversary Gift Box (8 Honey Rice Cake Set)','','false','scroll',100,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5910,'Five-Year Anniversary Gift Box (7 Honey Rice Cake Set)','','false','scroll',100,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5911,'Green Soul Crystal: Stage 13','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(5912,'Five-Year Anniversary Gift Box (6 Honey Rice Cake Set)','','false','scroll',100,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5913,'Five-Year Anniversary Gift Box (3 Honey Wheat Cake Set)','','false','scroll',100,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5914,'Blue Soul Crystal: Stage 13','','false','scroll',20,'normal','crystal','none',-1,-1,0,0,'true','true','true','true','true','SoulCrystals','0-0;'),
(5915,'Pirate\'s Treasure Map','','false','none',0,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(5916,'Spellbook Page','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2171-1;'),
(5917,'Kranvel\'s Spellbook: Chapter of Fire','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5918,'Kranvel\'s Spellbook: Chapter of Water','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5919,'Kranvel\'s Spellbook: Chapter of Wind','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5920,'Kranvel\'s Spellbook: Chapter of Earth','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5921,'Worthless Piece of Paper','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(5922,'Blueprint: Giants Golem 1','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5923,'Blueprint: Giants Golem 2','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5924,'Blueprint: Giants Golem 3','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5925,'Blueprint: Giants Golem 4','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5926,'Blueprint: Giants Golem 5','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5927,'Book: Basics of Giants Magic,Chapter 1','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5928,'Book: Basics of Giants Magic,Chapter 2','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5929,'Book: Basics of Giants Magic,Chapter 3','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5930,'Book: Basics of Giants Magic,Chapter 4','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5931,'Book: Basics of Giants Magic,Chapter 5','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5932,'Handbook: Giants Architecture,Chapter 1','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5933,'Handbook: Giants Architecture,Chapter 2','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5934,'Handbook: Giants Architecture,Chapter 3','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5935,'Handbook: Giants Architecture,Chapter 4','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5936,'Handbook: Giants Architecture,Chapter 5','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5937,'Book: Giants Medical Science,Chapter 1','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5938,'Book: Giants Medical Science,Chapter 2','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5939,'Book: Giants Medical Science,Chapter 3','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5940,'Book: Giants Medical Science,Chapter 4','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5941,'Book: Giants Medical Science,Chapter 5','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5942,'Giant\'s Love Letter','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5943,'Giants\' Doodle','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5944,'Ancient Parchment','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5945,'Book: Giants Science & Technology,Chapter 1','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5946,'Book: Giants Science & Technology,Chapter 2','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5947,'Book: Giants Science & Technology,Chapter 3','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5948,'Book: Giants Science & Technology,Chapter 4','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5949,'Book: Giants Science & Technology,Chapter 5','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5950,'Almanac: Titan Culture,Chapter 1','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5951,'Almanac: Titan Culture,Chapter 2','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5952,'Almanac: Titan Culture,Chapter 3','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5953,'Almanac: Titan Culture,Chapter 4','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5954,'Almanac: Titan Culture,Chapter 5','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5955,'Ancient Titan Book','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','ItemSkills','2173-1;'),
(5956,'15 Year Old Wine','','false','none',20,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(5957,'30 Year Old Wine','','false','none',20,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(5958,'60 Year Old Wine','','false','none',20,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(5959,'Ritron\'s Dessert Recipe','','false','none',10,'normal','liquid','none',-1,-1,40000,0,'true','true','true','true','true','none','0-0;'),
(5960,'Ritron Jelly','','false','none',10,'normal','liquid','none',-1,-1,1920,0,'true','true','true','true','true','none','0-0;'),
(5961,'Kail\'s Silver Basilisk','','false','none',0,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(5962,'Kail\'s Gold Golem','','false','none',0,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(5963,'Kail\'s Blood Dragon','','false','none',0,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(5964,'Warehouse Keeper\'s Medal','','false','quest',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(5965,'Blank Scroll','','false','none',0,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(5966,'Ancient Red Papyrus','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','ItemSkills','2176-1;'),
(5967,'Ancient Blue Papyrus','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','ItemSkills','2176-2;'),
(5968,'Ancient Black Papyrus','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','ItemSkills','2176-3;'),
(5969,'Ancient White Papyrus','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','ItemSkills','2176-4;'),
(5970,'Ancient Chain Letter','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5971,'Ancient Joke Book','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5972,'Revelation of the Seals: Chapter of Avarice','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5973,'Revelation of the Seals: Chapter of Gnosis','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5974,'Revelation of the Seals: Chapter of Strife','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5975,'Revelation of the Seals: Chapter of Vengeance','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5976,'Revelation of the Seals: Chapter of Awakening','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5977,'Revelation of the Seals: Chapter of Calamity','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5978,'Revelation of the Seals: Chapter of Descent','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5979,'Ancient Epic,Chapter 1','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5980,'Ancient Epic,Chapter 2','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5981,'Ancient Epic,Chapter 3','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5982,'Ancient Epic,Chapter 4','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5983,'Ancient Epic,Chapter 5','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5984,'Imperial Genealogy 1','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5985,'Imperial Genealogy 2','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5986,'Imperial Genealogy 3','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5987,'Imperial Genealogy 4','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5988,'Imperial Genealogy 5','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5989,'Blueprint: Tower of Insolence,1st Floor','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5990,'Blueprint: Tower of Insolence,2nd Floor','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5991,'Blueprint: Tower of Insolence,3rd Floor','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5992,'Blueprint: Tower of Insolence,4th Floor','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5993,'Blueprint: Tower of Insolence,5th Floor','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5994,'Blueprint: Tower of Insolence,6th Floor','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5995,'Blueprint: Tower of Insolence,7th Floor','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5996,'Blueprint: Tower of Insolence,8th Floor','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5997,'Blueprint: Tower of Insolence,9th Floor','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5998,'Blueprint: Tower of Insolence,10th Floor','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(5999,'Blueprint: Tower of Insolence,11th Floor','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(6000,'Blueprint: Tower of Insolence,12th Floor','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(6001,'Blueprint: Tower of Insolence,13th Floor','','false','none',0,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(6002,'Ancient Porcelain','','false','none',10,'stackable','liquid','none',-1,-1,8000,0,'true','true','true','true','true','none','0-0;'),
(6003,'Ancient Porcelain: Excellent','','false','none',10,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(6004,'Ancient Porcelain: High Quality','','false','none',10,'stackable','liquid','none',-1,-1,8000,0,'true','true','true','true','true','none','0-0;'),
(6005,'Ancient Porcelain: Low Quality','','false','none',10,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(6006,'Ancient Porcelain: Lowest Quality','','false','none',10,'stackable','liquid','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(6007,'Reagent Pouch','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2174-1;'),
(6008,'Reagent Pouch','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2174-2;'),
(6009,'Reagent Pouch','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2174-3;'),
(6010,'Reagent Box','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2175-1;'),
(6011,'Wyrm\'s Blood','','false','none',0,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(6012,'Lava Stone','','false','none',0,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(6013,'Moonstone Shard','','false','none',0,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(6014,'Rotten Bone Piece','','false','none',0,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(6015,'Demon\'s Blood','','false','none',0,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(6016,'Infernium Ore','','false','none',0,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(6017,'Blood Root','','false','none',0,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(6018,'Volcanic Ash','','false','none',0,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(6019,'Quicksilver','','false','none',0,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(6020,'Sulfur','','false','none',0,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(6021,'Dracoplasm','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6022,'Magma Dust','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6023,'Moon Dust','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6024,'Necroplasm','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6025,'Demonplasm','','false','none',0,'stackable','liquid','none',-1,-1,2500,0,'true','true','true','true','true','none','0-0;'),
(6026,'Inferno Dust','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6027,'Draconic Essence','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6028,'Fire Essence','','false','none',0,'stackable','liquid','none',-1,-1,2500,0,'true','true','true','true','true','none','0-0;'),
(6029,'Lunargent','','false','none',0,'stackable','liquid','none',-1,-1,2500,0,'true','true','true','true','true','none','0-0;'),
(6030,'Midnight Oil','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6031,'Demonic Essence','','false','none',0,'stackable','liquid','none',-1,-1,2500,0,'true','true','true','true','true','none','0-0;'),
(6032,'Abyss Oil','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6033,'Hellfire Oil','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6034,'Nightmare Oil','','false','none',0,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(6035,'Magic Haste Potion','','false','potion',20,'stackable','liquid','none',-1,-1,2400,0,'true','true','true','true','true','ItemSkills','2169-1;'),
(6036,'Greater Magic Haste Potion','','false','potion',20,'stackable','liquid','none',-1,-1,7200,0,'true','true','true','true','true','ItemSkills','2169-2;'),
(6037,'Waking Scroll','','false','scroll',5,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','ItemSkills','2170-1;'),
(6038,'Greater Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6039,'Greater Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6040,'Greater Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6041,'Greater Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6042,'Greater Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6043,'Greater Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6044,'Greater Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6045,'Greater Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6046,'Greater Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6047,'Greater Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6048,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6049,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6050,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6051,'Greater Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6052,'Greater Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6053,'Greater Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6054,'Greater Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6055,'Greater Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6056,'Greater Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6057,'Greater Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6058,'Greater Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6059,'Greater Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6060,'Greater Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6061,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6062,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6063,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6064,'Greater Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6065,'Greater Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6066,'Greater Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6067,'Greater Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6068,'Greater Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6069,'Greater Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6070,'Greater Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6071,'Greater Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6072,'Greater Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6073,'Greater Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6074,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6075,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6076,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6077,'Greater Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6078,'Greater Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6079,'Greater Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6080,'Greater Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6081,'Greater Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6082,'Greater Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6083,'Greater Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6084,'Greater Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6085,'Greater Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6086,'Greater Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6087,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6088,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6089,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6090,'Greater Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6091,'Greater Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6092,'Greater Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6093,'Greater Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6094,'Greater Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6095,'Greater Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6096,'Greater Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6097,'Greater Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6098,'Greater Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6099,'Greater Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6100,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6101,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6102,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6103,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6104,'Trash','Trash','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6105,'Greater Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6106,'Greater Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6107,'Greater Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6108,'Greater Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6109,'Greater Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6110,'Greater Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6111,'Greater Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6112,'Greater Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6113,'Greater Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6114,'Greater Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6115,'Dawn Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6116,'Dawn Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6117,'Dawn Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6118,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6119,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6120,'Dawn Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6121,'Dawn Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6122,'Dawn Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6123,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6124,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6125,'Dawn Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6126,'Dawn Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6127,'Dawn Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6128,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6129,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6130,'Dawn Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6131,'Dawn Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6132,'Dawn Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6133,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6134,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6135,'Dawn Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6136,'Dawn Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6137,'Dawn Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6138,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6139,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6140,'Dawn Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6141,'Dawn Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6142,'Dawn Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6143,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6144,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6145,'Dawn Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6146,'Dawn Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6147,'Dawn Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6148,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6149,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6150,'Dawn Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6151,'Dawn Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6152,'Dawn Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6153,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6154,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6155,'Dawn Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6156,'Dawn Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6157,'Dawn Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6158,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6159,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6160,'Dawn Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6161,'Dawn Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6162,'Dawn Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6163,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6164,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6165,'Dawn Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6166,'Dawn Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6167,'Dawn Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6168,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6169,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6170,'Dawn Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6171,'Dawn Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6172,'Dawn Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6173,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6174,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6175,'Greater Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6176,'Greater Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6177,'Greater Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6178,'Greater Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6179,'Greater Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6180,'Greater Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6181,'Greater Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6182,'Greater Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6183,'Greater Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6184,'Greater Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6185,'Greater Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6186,'Greater Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6187,'Greater Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6188,'Greater Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6189,'Greater Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6190,'Greater Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6191,'Greater Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6192,'Greater Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6193,'Greater Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6194,'Greater Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6195,'Greater Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6196,'Greater Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6197,'Greater Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6198,'Greater Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6199,'Greater Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6200,'Greater Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6201,'Greater Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6202,'Greater Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6203,'Greater Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6204,'Greater Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6205,'Greater Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6206,'Greater Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6207,'Greater Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6208,'Greater Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6209,'Greater Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6210,'Greater Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6211,'Greater Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6212,'Greater Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6213,'Greater Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6214,'Greater Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6215,'Greater Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6216,'Greater Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6217,'Greater Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6218,'Greater Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6219,'Greater Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6220,'Greater Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6221,'Greater Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6222,'Greater Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6223,'Greater Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6224,'Greater Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6225,'Greater Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6226,'Greater Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6227,'Greater Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6228,'Greater Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6229,'Greater Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6230,'Greater Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6231,'Greater Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6232,'Greater Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6233,'Greater Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6234,'Greater Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6235,'Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6236,'Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6237,'Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6238,'Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6239,'Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6240,'Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6241,'Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6242,'Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6243,'Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6244,'Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6245,'Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6246,'Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6247,'Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6248,'Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6249,'Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6250,'Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6251,'Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6252,'Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6253,'Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6254,'Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6255,'Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6256,'Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6257,'Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6258,'Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6259,'Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6260,'Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6261,'Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6262,'Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6263,'Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6264,'Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6265,'Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6266,'Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6267,'Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6268,'Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6269,'Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6270,'Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6271,'Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6272,'Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6273,'Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6274,'Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6275,'Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6276,'Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6277,'Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6278,'Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6279,'Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6280,'Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6281,'Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6282,'Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6283,'Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6284,'Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6285,'Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6286,'Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6287,'Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6288,'Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6289,'Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6290,'Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6291,'Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6292,'Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6293,'Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6294,'Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6295,'Nephilim Warrior Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;');

INSERT INTO `etcitem` VALUES
(6296,'Nephilim Shaman Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6297,'Nephilim Warrior Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6298,'Nephilim Shaman Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6299,'Nephilim Warrior Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6300,'Nephilim Shaman Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6301,'Nephilim Warrior Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6302,'Nephilim Shaman Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6303,'Nephilim Warrior Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6304,'Nephilim Shaman Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6305,'Nephilim Warrior Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6306,'Nephilim Shaman Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6316,'Food for Wyvern','','false','none',10,'stackable','liquid','none',-1,-1,300,0,'true','true','true','true','true','PetFood','2180-1;'),
(6317,'Mixing Manual','','false','none',20,'normal','liquid','none',-1,-1,0,0,'true','false','true','true','true','Book','0-0;'),
(6318,'Blood Fire','','false','quest',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6319,'Mimir\'s Elixir','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6320,'Pure Silver','','false','quest',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6321,'True Gold','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6322,'Sage\'s Stone','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6329,'Recipe: Sealed Phoenix Necklace(70%)','','false','recipe',30,'stackable','liquid','none',-1,-1,34800,0,'true','true','true','true','true','Recipes','0-0;'),
(6330,'Recipe: Sealed Phoenix Necklace(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,69600,0,'true','true','true','true','true','Recipes','0-0;'),
(6331,'Recipe: Sealed Phoenix Earring(70%)','','false','recipe',30,'stackable','liquid','none',-1,-1,26200,0,'true','true','true','true','true','Recipes','0-0;'),
(6332,'Recipe: Sealed Phoenix Earring(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,52400,0,'true','true','true','true','true','Recipes','0-0;'),
(6333,'Recipe: Sealed Phoenix Ring(70%)','','false','recipe',30,'stackable','liquid','none',-1,-1,17420,0,'true','true','true','true','true','Recipes','0-0;'),
(6334,'Recipe: Sealed Phoenix Ring(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,34840,0,'true','true','true','true','true','Recipes','0-0;'),
(6335,'Recipe: Sealed Majestic Necklace(70%)','','false','recipe',30,'stackable','liquid','none',-1,-1,52000,0,'true','true','true','true','true','Recipes','0-0;'),
(6336,'Recipe: Sealed Majestic Necklace(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,104000,0,'true','true','true','true','true','Recipes','0-0;'),
(6337,'Recipe: Sealed Majestic Earring(70%)','','false','recipe',30,'stackable','liquid','none',-1,-1,39000,0,'true','true','true','true','true','Recipes','0-0;'),
(6338,'Recipe: Sealed Majestic Earring(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,78000,0,'true','true','true','true','true','Recipes','0-0;'),
(6339,'Recipe: Sealed Majestic Ring(70%)','','false','recipe',30,'stackable','liquid','none',-1,-1,26000,0,'true','true','true','true','true','Recipes','0-0;'),
(6340,'Recipe: Sealed Majestic Ring(100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,52000,0,'true','true','true','true','true','Recipes','0-0;'),
(6341,'Sealed Phoenix Earring Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,7231,0,'true','true','true','true','true','none','0-0;'),
(6342,'Sealed Majestic Earring Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,8829,0,'true','true','true','true','true','none','0-0;'),
(6343,'Sealed Phoenix Necklace Beads','','false','material',60,'stackable','liquid','none',-1,-1,9354,0,'true','true','true','true','true','none','0-0;'),
(6344,'Sealed Majestic Necklace Beads','','false','material',60,'stackable','liquid','none',-1,-1,13643,0,'true','true','true','true','true','none','0-0;'),
(6345,'Sealed Phoenix Ring Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,5228,0,'true','true','true','true','true','none','0-0;'),
(6346,'Sealed Majestic Ring Gemstone','','false','material',60,'stackable','liquid','none',-1,-1,6143,0,'true','true','true','true','true','none','0-0;'),
(6350,'Amulet: Pa\'agrio\'s Honor','','false','spellbook',120,'stackable','paper','none',-1,-1,8700,0,'true','true','true','true','true','none','0-0;'),
(6351,'Amulet: Ritual of Life','','false','spellbook',120,'stackable','paper','none',-1,-1,8200,0,'true','true','true','true','true','none','0-0;'),
(6352,'Spellbook: Prayer','','false','spellbook',120,'stackable','paper','none',-1,-1,8700,0,'true','true','true','true','true','none','0-0;'),
(6353,'Blue Gemstone','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6360,'Blue Seal Stone','','false','none',0,'asset','gold','none',-1,-1,3,0,'true','true','true','true','true','none','0-0;'),
(6361,'Green Seal Stone','','false','none',0,'asset','gold','none',-1,-1,5,0,'true','true','true','true','true','none','0-0;'),
(6362,'Red Seal Stone','','false','none',0,'asset','gold','none',-1,-1,10,0,'true','true','true','true','true','none','0-0;'),
(6363,'Stolen Infernium Ore','','false','none',0,'stackable','steel','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(6387,'Blessed Scroll of Resurrection for Pets','','false','scroll',120,'stackable','paper','none',-1,-1,6000,0,'true','true','true','true','true','ScrollOfResurrection','2179-1;'),
(6388,'Lord of the Manor\'s Certificate of Approval','','false','none',0,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6389,'Squash Seed','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','false','true','true','true','ItemSkills','2003-1;'),
(6390,'Large Squash Seed','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','false','true','true','true','ItemSkills','2004-1;'),
(6391,'Nectar','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2005-1;'),
(6392,'Event - Medal','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6393,'Event - Glittering Medal','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6395,'Amulet: Chant of Predator','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(6396,'Amulet: Chant of Eagle','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(6397,'Amulet: Chant of Vampire','','false','spellbook',120,'stackable','paper','none',-1,-1,3850,0,'true','true','true','true','true','none','0-0;'),
(6398,'Spellbook: Body of Avatar','','false','spellbook',120,'stackable','paper','none',-1,-1,4600,0,'true','true','true','true','true','none','0-0;'),
(6399,'Badge of Rabbit','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6400,'Badge of Hyena','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6401,'Badge of Fox','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6402,'Badge of Wolf','','false','quest',0,'stackable','crystal','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6403,'Star Shard','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2023-1;'),
(6404,'Gunpowder','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6405,'Magnesium','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6406,'Firework','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2024-1;'),
(6407,'Large Firework','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2025-1;'),
(6409,'2006 Battle Tournament - CP Potion','','false','potion',500,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6410,'2006 Battle Tournament - Quick Healing Potion','','false','potion',180,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6411,'Small Nimble Green Fish','','false','none',100,'stackable','paper','none',-1,-1,138,0,'true','true','true','true','true','ItemSkills','2190-1;'),
(6412,'Small Ugly Green Fish','','false','none',100,'stackable','paper','none',-1,-1,141,0,'true','true','true','true','true','ItemSkills','2190-2;'),
(6413,'Small Pudgy Green Fish','','false','none',100,'stackable','paper','none',-1,-1,153,0,'true','true','true','true','true','ItemSkills','2190-3;'),
(6414,'Nimble Green Fish','','false','none',100,'stackable','paper','none',-1,-1,167,0,'true','true','true','true','true','ItemSkills','2190-4;'),
(6415,'Ugly Green Fish','','false','none',100,'stackable','paper','none',-1,-1,187,0,'true','true','true','true','true','ItemSkills','2190-5;'),
(6416,'Pudgy Green Fish','','false','none',100,'stackable','paper','none',-1,-1,208,0,'true','true','true','true','true','ItemSkills','2190-6;'),
(6417,'Large Nimble Green Fish','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2190-7;'),
(6418,'Large Ugly Green Fish','','false','none',100,'stackable','paper','none',-1,-1,248,0,'true','true','true','true','true','ItemSkills','2190-8;'),
(6419,'Large Pudgy Green Fish','','false','none',100,'stackable','paper','none',-1,-1,265,0,'true','true','true','true','true','ItemSkills','2190-9;'),
(6420,'Small Jade Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,285,0,'true','true','true','true','true','ItemSkills','2191-1;'),
(6421,'Small Jade Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,295,0,'true','true','true','true','true','ItemSkills','2191-2;'),
(6422,'Small Jade Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,310,0,'true','true','true','true','true','ItemSkills','2191-3;'),
(6423,'Jade Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,325,0,'true','true','true','true','true','ItemSkills','2191-4;'),
(6424,'Jade Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,340,0,'true','true','true','true','true','ItemSkills','2191-5;'),
(6425,'Jade Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,355,0,'true','true','true','true','true','ItemSkills','2191-6;'),
(6426,'Big Jade Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,365,0,'true','true','true','true','true','ItemSkills','2191-7;'),
(6427,'Big Jade Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,375,0,'true','true','true','true','true','ItemSkills','2191-8;'),
(6428,'Big Jade Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,385,0,'true','true','true','true','true','ItemSkills','2191-9;'),
(6429,'Small Blue Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,395,0,'true','true','true','true','true','ItemSkills','2192-1;'),
(6430,'Small Blue Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','ItemSkills','2192-2;'),
(6431,'Small Blue Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,410,0,'true','true','true','true','true','ItemSkills','2192-3;'),
(6432,'Blue Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,415,0,'true','true','true','true','true','ItemSkills','2192-4;'),
(6433,'Blue Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,418,0,'true','true','true','true','true','ItemSkills','2192-5;'),
(6434,'Blue Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,420,0,'true','true','true','true','true','ItemSkills','2192-6;'),
(6435,'Big Blue Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,425,0,'true','true','true','true','true','ItemSkills','2192-7;'),
(6436,'Big Blue Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,431,0,'true','true','true','true','true','ItemSkills','2192-8;'),
(6437,'Big Blue Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,435,0,'true','true','true','true','true','ItemSkills','2192-9;'),
(6438,'Small Yellow Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,442,0,'true','true','true','true','true','ItemSkills','2193-1;'),
(6439,'Small Yellow Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,447,0,'true','true','true','true','true','ItemSkills','2193-2;'),
(6440,'Small Yellow Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,452,0,'true','true','true','true','true','ItemSkills','2193-3;'),
(6441,'Yellow Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,540,0,'true','true','true','true','true','ItemSkills','2193-4;'),
(6442,'Yellow Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,553,0,'true','true','true','true','true','ItemSkills','2193-5;'),
(6443,'Yellow Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,568,0,'true','true','true','true','true','ItemSkills','2193-6;'),
(6444,'Big Yellow Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,580,0,'true','true','true','true','true','ItemSkills','2193-7;'),
(6445,'Big Yellow Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,594,0,'true','true','true','true','true','ItemSkills','2193-8;'),
(6446,'Big Yellow Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,608,0,'true','true','true','true','true','ItemSkills','2193-9;'),
(6447,'Small Orange Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,622,0,'true','true','true','true','true','ItemSkills','2194-1;'),
(6448,'Small Orange Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,635,0,'true','true','true','true','true','ItemSkills','2194-2;'),
(6449,'Small Orange Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,649,0,'true','true','true','true','true','ItemSkills','2194-3;'),
(6450,'Orange Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,663,0,'true','true','true','true','true','ItemSkills','2194-4;'),
(6451,'Orange Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,776,0,'true','true','true','true','true','ItemSkills','2194-5;'),
(6452,'Orange Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2194-6;'),
(6453,'Big Orange Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,816,0,'true','true','true','true','true','ItemSkills','2194-7;'),
(6454,'Big Orange Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,840,0,'true','true','true','true','true','ItemSkills','2194-8;'),
(6455,'Big Orange Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,858,0,'true','true','true','true','true','ItemSkills','2194-9;'),
(6456,'Small Purple Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,875,0,'true','true','true','true','true','ItemSkills','2195-1;'),
(6457,'Small Purple Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,893,0,'true','true','true','true','true','ItemSkills','2195-2;'),
(6458,'Small Purple Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,910,0,'true','true','true','true','true','ItemSkills','2195-3;'),
(6459,'Purple Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,930,0,'true','true','true','true','true','ItemSkills','2195-4;'),
(6460,'Purple Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,948,0,'true','true','true','true','true','ItemSkills','2195-5;'),
(6461,'Purple Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,1090,0,'true','true','true','true','true','ItemSkills','2195-6;'),
(6462,'Big Purple Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,1111,0,'true','true','true','true','true','ItemSkills','2195-7;'),
(6463,'Big Purple Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,1133,0,'true','true','true','true','true','ItemSkills','2195-8;'),
(6464,'Big Purple Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,1157,0,'true','true','true','true','true','ItemSkills','2195-9;'),
(6465,'Small Red Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,1277,0,'true','true','true','true','true','ItemSkills','2196-1;'),
(6466,'Small Red Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,1301,0,'true','true','true','true','true','ItemSkills','2196-2;'),
(6467,'Small Red Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,1326,0,'true','true','true','true','true','ItemSkills','2196-3;'),
(6468,'Red Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,1351,0,'true','true','true','true','true','ItemSkills','2196-4;'),
(6469,'Red Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,1376,0,'true','true','true','true','true','ItemSkills','2196-5;'),
(6470,'Red Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,1402,0,'true','true','true','true','true','ItemSkills','2196-6;'),
(6471,'Big Red Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,1577,0,'true','true','true','true','true','ItemSkills','2196-7;'),
(6472,'Big Red Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,1608,0,'true','true','true','true','true','ItemSkills','2196-8;'),
(6473,'Big Red Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,1715,0,'true','true','true','true','true','ItemSkills','2196-9;'),
(6474,'Small White Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,1747,0,'true','true','true','true','true','ItemSkills','2197-1;'),
(6475,'Small White Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,1781,0,'true','true','true','true','true','ItemSkills','2197-2;'),
(6476,'Small White Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,1814,0,'true','true','true','true','true','ItemSkills','2197-3;'),
(6477,'White Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,1849,0,'true','true','true','true','true','ItemSkills','2197-4;'),
(6478,'White Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,1887,0,'true','true','true','true','true','ItemSkills','2197-5;'),
(6479,'White Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,1923,0,'true','true','true','true','true','ItemSkills','2197-6;'),
(6480,'Big White Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,1961,0,'true','true','true','true','true','ItemSkills','2197-7;'),
(6481,'Big White Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,2000,0,'true','true','true','true','true','ItemSkills','2197-8;'),
(6482,'Big White Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,2039,0,'true','true','true','true','true','ItemSkills','2197-9;'),
(6483,'Small Black Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2198-1;'),
(6484,'Small Black Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2198-2;'),
(6485,'Small Black Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2198-3;'),
(6486,'Black Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,2309,0,'true','true','true','true','true','ItemSkills','2198-4;'),
(6487,'Black Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,2357,0,'true','true','true','true','true','ItemSkills','2198-5;'),
(6488,'Black Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2198-6;'),
(6489,'Big Black Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2198-7;'),
(6490,'Big Black Ugly Fish','','false','none',100,'stackable','paper','none',-1,-1,2502,0,'true','true','true','true','true','ItemSkills','2198-8;'),
(6491,'Big Black Fat Fish','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2198-9;'),
(6492,'Small Green Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,153,0,'true','true','true','true','true','ItemSkills','2199-1;'),
(6493,'Green Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,208,0,'true','true','true','true','true','ItemSkills','2199-2;'),
(6494,'Big Green Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,265,0,'true','true','true','true','true','ItemSkills','2199-3;'),
(6495,'Small Jade Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,285,0,'true','true','true','true','true','ItemSkills','2200-1;'),
(6496,'Jade Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,315,0,'true','true','true','true','true','ItemSkills','2200-2;'),
(6497,'Big Jade Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,345,0,'true','true','true','true','true','ItemSkills','2200-3;'),
(6498,'Small Blue Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,395,0,'true','true','true','true','true','ItemSkills','2201-1;'),
(6499,'Blue Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,419,0,'true','true','true','true','true','ItemSkills','2201-2;'),
(6500,'Big Blue Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,435,0,'true','true','true','true','true','ItemSkills','2201-3;'),
(6501,'Small Yellow Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,452,0,'true','true','true','true','true','ItemSkills','2202-1;'),
(6502,'Yellow Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,568,0,'true','true','true','true','true','ItemSkills','2202-2;'),
(6503,'Big Yellow Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,608,0,'true','true','true','true','true','ItemSkills','2202-3;'),
(6504,'Small Orange Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,649,0,'true','true','true','true','true','ItemSkills','2203-1;'),
(6505,'Orange Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,792,0,'true','true','true','true','true','ItemSkills','2203-2;'),
(6506,'Big Orange Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,858,0,'true','true','true','true','true','ItemSkills','2203-3;'),
(6507,'Small Purple Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,910,0,'true','true','true','true','true','ItemSkills','2204-1;'),
(6508,'Purple Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,1090,0,'true','true','true','true','true','ItemSkills','2204-2;'),
(6509,'Big Purple Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,1157,0,'true','true','true','true','true','ItemSkills','2204-3;'),
(6510,'Small Red Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,1326,0,'true','true','true','true','true','ItemSkills','2205-1;'),
(6511,'Red Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,1402,0,'true','true','true','true','true','ItemSkills','2205-2;'),
(6512,'Big Red Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,1715,0,'true','true','true','true','true','ItemSkills','2205-3;'),
(6513,'Small White Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,1814,0,'true','true','true','true','true','ItemSkills','2206-1;'),
(6514,'White Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,1923,0,'true','true','true','true','true','ItemSkills','2206-2;'),
(6515,'Big White Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,2039,0,'true','true','true','true','true','ItemSkills','2206-3;'),
(6516,'Small Black Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,2166,0,'true','true','true','true','true','ItemSkills','2207-1;'),
(6517,'Black Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,2403,0,'true','true','true','true','true','ItemSkills','2207-2;'),
(6518,'Big Black Treasure Chest','','false','none',100,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2207-3;'),
(6519,'Green Colored Lure - Low Grade','','false','lure',5,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(6520,'Green Colored Lure','','false','lure',4,'stackable','liquid','none',-1,-1,120,0,'true','true','true','true','true','none','0-0;'),
(6521,'Green Colored Lure - High Grade','','false','lure',3,'stackable','liquid','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(6522,'Purple Colored Lure - Low Grade','','false','lure',5,'stackable','liquid','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(6523,'Purple Colored Lure','','false','lure',4,'stackable','liquid','none',-1,-1,180,0,'true','true','true','true','true','none','0-0;'),
(6524,'Purple Colored Lure - High Grade','','false','lure',3,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(6525,'Yellow Colored Lure - Low Grade','','false','lure',5,'stackable','liquid','none',-1,-1,120,0,'true','true','true','true','true','none','0-0;'),
(6526,'Yellow Colored Lure','','false','lure',4,'stackable','liquid','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(6527,'Yellow Colored Lure - High Grade','','false','lure',3,'stackable','liquid','none',-1,-1,180,0,'true','true','true','true','true','none','0-0;'),
(6528,'Event bait','','false','lure',3,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6535,'Fishing Shot: non-grade','','false','shot',3,'stackable','paper','none',-1,-1,3,0,'true','true','true','true','true','FishShots','2181-1;'),
(6536,'Fishing Shot: D-grade','','false','shot',3,'stackable','paper','d',-1,-1,5,0,'true','true','true','true','true','FishShots','2182-1;'),
(6537,'Fishing Shot: C-grade','','false','shot',3,'stackable','paper','c',-1,-1,7,0,'true','true','true','true','true','FishShots','2183-1;'),
(6538,'Fishing Shot: B-grade','','false','shot',3,'stackable','paper','b',-1,-1,25,0,'true','true','true','true','true','FishShots','2184-1;'),
(6539,'Fishing Shot: A-grade','','false','shot',3,'stackable','paper','a',-1,-1,40,0,'true','true','true','true','true','FishShots','2185-1;'),
(6540,'Fishing Shot: S-grade','','false','shot',3,'stackable','paper','s',-1,-1,50,0,'true','true','true','true','true','FishShots','2186-1;'),
(6541,'Blue Coba','','false','none',2,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(6542,'Red Coba','','false','none',2,'stackable','paper','none',-1,-1,1500,0,'true','true','true','true','true','none','0-0;'),
(6543,'Gold Coba','','false','none',2,'stackable','paper','none',-1,-1,1750,0,'true','true','true','true','true','none','0-0;'),
(6544,'Desert Coba','','false','none',2,'stackable','paper','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(6545,'Sea Coba','','false','none',2,'stackable','paper','none',-1,-1,2250,0,'true','true','true','true','true','none','0-0;'),
(6546,'Twin Coba','','false','none',2,'stackable','paper','none',-1,-1,2500,0,'true','true','true','true','true','none','0-0;'),
(6547,'King Coba','','false','none',2,'stackable','paper','none',-1,-1,2750,0,'true','true','true','true','true','none','0-0;'),
(6548,'Alternative Blue Coba','','false','none',2,'stackable','paper','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(6549,'Alternative Red Coba','','false','none',2,'stackable','paper','none',-1,-1,1500,0,'true','true','true','true','true','none','0-0;'),
(6550,'Alternative Gold Coba','','false','none',2,'stackable','paper','none',-1,-1,1750,0,'true','true','true','true','true','none','0-0;'),
(6551,'Alternative Desert Coba','','false','none',2,'stackable','paper','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(6552,'Alternative Sea Coba','','false','none',2,'stackable','paper','none',-1,-1,2250,0,'true','true','true','true','true','none','0-0;'),
(6553,'Alternative Twin Coba','','false','none',2,'stackable','paper','none',-1,-1,2500,0,'true','true','true','true','true','none','0-0;'),
(6554,'Alternative King Coba','','false','none',2,'stackable','paper','none',-1,-1,2750,0,'true','true','true','true','true','none','0-0;'),
(6555,'Ripe Blue Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6556,'Ripe Red Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6557,'Ripe Gold Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6558,'Ripe Desert Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6559,'Ripe Sea Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6560,'Ripe Twin Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6561,'Ripe King Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6562,'Ripe Alternative Blue Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6563,'Ripe Alternative Red Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6564,'Ripe Alternative Gold Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6565,'Ripe Alternative Desert Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6566,'Ripe Alternative Sea Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6567,'Ripe Alternative Twin Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6568,'Ripe Alternative King Coba','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6569,'Blessed Scroll: Enchant Weapon (A)','','false','scroll',120,'stackable','paper','none',-1,-1,1750000,0,'true','true','true','true','true','EnchantScrolls','2027-1;'),
(6570,'Blessed Scroll: Enchant Armor (A)','','false','scroll',120,'stackable','paper','none',-1,-1,750000,0,'true','true','true','true','true','EnchantScrolls','2209-1;'),
(6571,'Blessed Scroll: Enchant Weapon (B)','','false','scroll',120,'stackable','paper','none',-1,-1,1250000,0,'true','true','true','true','true','EnchantScrolls','2028-1;'),
(6572,'Blessed Scroll: Enchant Armor (B)','','false','scroll',120,'stackable','paper','none',-1,-1,250000,0,'true','true','true','true','true','EnchantScrolls','2210-1;'),
(6573,'Blessed Scroll: Enchant Weapon (C)','','false','scroll',120,'stackable','paper','none',-1,-1,250000,0,'true','true','true','true','true','EnchantScrolls','2029-1;'),
(6574,'Blessed Scroll: Enchant Armor (C)','','false','scroll',120,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','EnchantScrolls','2211-1;'),
(6575,'Blessed Scroll: Enchant Weapon (D)','','false','scroll',120,'stackable','paper','none',-1,-1,150000,0,'true','true','true','true','true','EnchantScrolls','2030-1;'),
(6576,'Blessed Scroll: Enchant Armor (D)','','false','scroll',120,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','EnchantScrolls','2212-1;'),
(6577,'Blessed Scroll: Enchant Weapon (S)','','false','scroll',120,'stackable','paper','none',-1,-1,2250000,0,'true','true','true','true','true','EnchantScrolls','2026-1;'),
(6578,'Blessed Scroll: Enchant Armor (S)','','false','scroll',120,'stackable','paper','none',-1,-1,1250000,0,'true','true','true','true','true','EnchantScrolls','2208-1;'),
(6622,'Giant\'s Codex','','false','none',10,'stackable','paper','none',-1,-1,250000,0,'true','true','true','true','true','none','0-0;'),
(6623,'Dummy - Quest Item 1','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6624,'Dummy - Quest Item 2','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6625,'Dummy - Quest Item 3','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6626,'Dummy - Quest Item 4','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6627,'Dummy - Quest Item 5','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6628,'Dummy - Quest Item 6','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6629,'Dummy - Quest Item 7','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6630,'Dummy - Quest Item 8','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6631,'Dummy - Quest Item 9','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6632,'Dummy - Quest Item 10','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6633,'Dummy - General Item 1','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6634,'Dummy - General Item 2','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6635,'Dummy - General Item 3','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6636,'Dummy - General Item 4','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6637,'Dummy - General Item 5','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6638,'Dummy - General Item 6','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6639,'Dummy - General Item 7','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6640,'Dummy - General Item 8','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6641,'Dummy - General Item 9','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6642,'Dummy - General Item 10','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6643,'Golden Spice','','false','none',40,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','BeastSpice','2188-1;'),
(6644,'Crystal Spice','','false','none',40,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','BeastSpice','2189-1;'),
(6645,'Beast Soulshot','','false','shot',1,'stackable','paper','none',-1,-1,21,0,'true','true','true','true','true','BeastSoulShot','2033-1;'),
(6646,'Beast Spiritshot','','false','shot',2,'stackable','paper','none',-1,-1,43,0,'true','true','true','true','true','BeastSpiritShot','2008-1;'),
(6647,'Blessed Beast Spiritshot','','false','shot',2,'stackable','paper','none',-1,-1,108,0,'true','true','true','true','true','BeastSpiritShot','2009-1;'),
(6648,'Baby Buffalo Panpipe','','false','pet_collar',20,'normal','leather','none',-1,-1,0,0,'true','true','true','true','true','SummonItems','0-0;'),
(6649,'Baby Cougar Chime','','false','pet_collar',20,'normal','leather','none',-1,-1,0,0,'true','true','true','true','true','SummonItems','0-0;'),
(6650,'Baby Kookaburra Ocarina','','false','pet_collar',20,'normal','leather','none',-1,-1,0,0,'true','true','true','true','true','SummonItems','0-0;'),
(6651,'Noblesse Gate Pass','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6652,'Scroll: Protection of Valakas','','false','scroll',10,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','ItemSkills','2231-1;'),
(6653,'Scroll: Flames of Valakas','','false','scroll',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(6654,'Scroll: Flames of Valakas','','false','scroll',10,'stackable','paper','none',-1,-1,40000,0,'true','true','true','true','true','ItemSkills','2233-1;'),
(6655,'Scroll: Slay Valakas','','false','scroll',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2232-1;'),
(6663,'Scroll of Escape: Orc Village','','false','scroll',120,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(6664,'Scroll of Escape: Silenos Village','','false','scroll',120,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(6665,'Deluxe Chest Key - Grade 1','','false','none',10,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2229-1;'),
(6666,'Deluxe Chest Key - Grade 2','','false','none',10,'stackable','steel','none',-1,-1,200,0,'true','true','true','true','true','ItemSkills','2229-2;'),
(6667,'Deluxe Chest Key - Grade 3','','false','none',10,'stackable','steel','none',-1,-1,320,0,'true','true','true','true','true','ItemSkills','2229-3;'),
(6668,'Deluxe Chest Key - Grade 4','','false','none',10,'stackable','steel','none',-1,-1,560,0,'true','true','true','true','true','ItemSkills','2229-4;'),
(6669,'Deluxe Chest Key - Grade 5','','false','none',10,'stackable','steel','none',-1,-1,860,0,'true','true','true','true','true','ItemSkills','2229-5;'),
(6670,'Deluxe Chest Key - Grade 6','','false','none',10,'stackable','steel','none',-1,-1,1200,0,'true','true','true','true','true','ItemSkills','2229-6;'),
(6671,'Deluxe Chest Key - Grade 7','','false','none',10,'stackable','steel','none',-1,-1,1800,0,'true','true','true','true','true','ItemSkills','2229-7;'),
(6672,'Deluxe Chest Key - Grade 8','','false','none',10,'stackable','steel','none',-1,-1,2400,0,'true','true','true','true','true','ItemSkills','2229-8;'),
(6673,'Festival Adena','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(6688,'Forgotten Blade Edge','','false','material',60,'stackable','liquid','none',-1,-1,92529,0,'true','true','true','true','true','none','0-0;'),
(6689,'Basalt Battlehammer Head','','false','material',60,'stackable','liquid','none',-1,-1,94306,0,'true','true','true','true','true','none','0-0;'),
(6690,'Imperial Staff Head','','false','material',60,'stackable','liquid','none',-1,-1,92353,0,'true','true','true','true','true','none','0-0;'),
(6691,'Angel Slayer Blade','','false','material',60,'stackable','liquid','none',-1,-1,92529,0,'true','true','true','true','true','none','0-0;'),
(6692,'Shining Bow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,90882,0,'true','true','true','true','true','none','0-0;'),
(6693,'Dragon Hunter Axe Blade','','false','material',60,'stackable','liquid','none',-1,-1,90882,0,'true','true','true','true','true','none','0-0;'),
(6694,'Saint Spear Blade','','false','material',60,'stackable','liquid','none',-1,-1,90882,0,'true','true','true','true','true','none','0-0;'),
(6695,'Demon Splinter Blade','','false','material',60,'stackable','liquid','none',-1,-1,94306,0,'true','true','true','true','true','none','0-0;'),
(6696,'Heavens Divider Edge','','false','material',60,'stackable','liquid','none',-1,-1,91082,0,'true','true','true','true','true','none','0-0;'),
(6697,'Arcana Mace Head','','false','material',60,'stackable','liquid','none',-1,-1,94306,0,'true','true','true','true','true','none','0-0;'),
(6698,'Sealed Tateossian Earring Part','','false','material',60,'stackable','liquid','none',-1,-1,10182,0,'true','true','true','true','true','none','0-0;'),
(6699,'Sealed Tateossian Ring Gem','','false','material',60,'stackable','liquid','none',-1,-1,9176,0,'true','true','true','true','true','none','0-0;'),
(6700,'Sealed Tateossian Necklace Chain','','false','material',60,'stackable','liquid','none',-1,-1,16706,0,'true','true','true','true','true','none','0-0;'),
(6701,'Sealed Imperial Crusader Breastplate Part','','false','material',60,'stackable','liquid','none',-1,-1,37565,0,'true','true','true','true','true','none','0-0;'),
(6702,'Sealed Imperial Crusader Gaiters Pattern','','false','material',60,'stackable','liquid','none',-1,-1,29182,0,'true','true','true','true','true','none','0-0;'),
(6703,'Sealed Imperial Crusader Gauntlets Design','','false','material',60,'stackable','liquid','none',-1,-1,14047,0,'true','true','true','true','true','none','0-0;'),
(6704,'Sealed Imperial Crusader Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,14047,0,'true','true','true','true','true','none','0-0;'),
(6705,'Sealed Imperial Crusader Shield Part','','false','material',60,'stackable','liquid','none',-1,-1,14341,0,'true','true','true','true','true','none','0-0;'),
(6706,'Sealed Imperial Crusader Helmet Pattern','','false','material',60,'stackable','liquid','none',-1,-1,12329,0,'true','true','true','true','true','none','0-0;'),
(6707,'Sealed Draconic Leather Armor Part','','false','material',60,'stackable','liquid','none',-1,-1,40365,0,'true','true','true','true','true','none','0-0;'),
(6708,'Sealed Draconic Leather Gloves Fabric','','false','material',60,'stackable','liquid','none',-1,-1,14047,0,'true','true','true','true','true','none','0-0;'),
(6709,'Sealed Draconic Leather Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,14047,0,'true','true','true','true','true','none','0-0;'),
(6710,'Sealed Draconic Leather Helmet Pattern','','false','material',60,'stackable','liquid','none',-1,-1,12329,0,'true','true','true','true','true','none','0-0;'),
(6711,'Sealed Major Arcana Robe Part','','false','material',60,'stackable','liquid','none',-1,-1,40365,0,'true','true','true','true','true','none','0-0;'),
(6712,'Sealed Major Arcana Gloves fabric','','false','material',60,'stackable','liquid','none',-1,-1,14047,0,'true','true','true','true','true','none','0-0;'),
(6713,'Sealed Major Arcana Boots Design','','false','material',60,'stackable','liquid','none',-1,-1,14047,0,'true','true','true','true','true','none','0-0;'),
(6714,'Sealed Major Arcana Circlet Pattern','','false','material',60,'stackable','liquid','none',-1,-1,12329,0,'true','true','true','true','true','none','0-0;'),
(6727,'Seed: Alternative Great Coba','','false','seed',1,'stackable','paper','none',-1,-1,1200,0,'true','true','true','true','true','Seed','2097-3;'),
(6728,'Seed: Alternative Sea Coba','','false','seed',1,'stackable','paper','none',-1,-1,900,0,'true','true','true','true','true','Seed','2097-3;'),
(6729,'Seed: Alternative Sea Coba','','false','seed',1,'stackable','paper','none',-1,-1,900,0,'true','true','true','true','true','Seed','2097-3;'),
(6730,'Seed: Alternative Sea Coba','','false','seed',1,'stackable','paper','none',-1,-1,900,0,'true','true','true','true','true','Seed','2097-3;'),
(6731,'Seed: Alternative Red Coba','','false','seed',1,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','Seed','2097-3;'),
(6732,'Seed: Alternative Red Coba','','false','seed',1,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','Seed','2097-3;'),
(6733,'Seed: Alternative Red Coba','','false','seed',1,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','Seed','2097-3;'),
(6734,'Seed: Alternative Red Coba','','false','seed',1,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','Seed','2097-3;'),
(6735,'Seed: Alternative Red Coba','','false','seed',1,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','Seed','2097-3;'),
(6736,'Seed: Alternative Desert Coba','','false','seed',1,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','Seed','2097-3;'),
(6737,'Seed: Alternative Desert Coba','','false','seed',1,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','Seed','2097-3;'),
(6738,'Seed: Alternative Desert Coba','','false','seed',1,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','Seed','2097-3;'),
(6739,'Seed: Alternative Desert Coba','','false','seed',1,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','Seed','2097-3;'),
(6740,'Seed: Alternative Desert Coba','','false','seed',1,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','Seed','2097-3;'),
(6741,'Seed: Alternative Twin Coba','','false','seed',1,'stackable','paper','none',-1,-1,1000,0,'true','true','true','true','true','Seed','2097-3;'),
(6742,'Seed: Alternative Blue Coba','','false','seed',1,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','Seed','2097-3;'),
(6743,'Seed: Alternative Blue Coba','','false','seed',1,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','Seed','2097-3;'),
(6744,'Seed: Alternative Blue Coba','','false','seed',1,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','Seed','2097-3;'),
(6745,'Seed: Alternative Blue Coba','','false','seed',1,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','Seed','2097-3;'),
(6746,'Seed: Alternative Blue Coba','','false','seed',1,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','Seed','2097-3;'),
(6747,'Seed: Alternative Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(6748,'Seed: Alternative Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(6749,'Seed: Alternative Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(6750,'Seed: Alternative Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(6751,'Seed: Alternative Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(6752,'Seed: Alternative Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(6753,'Seed: Great Coba','','false','seed',1,'stackable','paper','none',-1,-1,1200,0,'true','true','true','true','true','Seed','2097-3;'),
(6754,'Seed: Sea Coba','','false','seed',1,'stackable','paper','none',-1,-1,900,0,'true','true','true','true','true','Seed','2097-3;'),
(6755,'Seed: Sea Coba','','false','seed',1,'stackable','paper','none',-1,-1,900,0,'true','true','true','true','true','Seed','2097-3;'),
(6756,'Seed: Sea Coba','','false','seed',1,'stackable','paper','none',-1,-1,900,0,'true','true','true','true','true','Seed','2097-3;'),
(6757,'Seed: Red Coba','','false','seed',1,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','Seed','2097-3;'),
(6758,'Seed: Red Coba','','false','seed',1,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','Seed','2097-3;'),
(6759,'Seed: Red Coba','','false','seed',1,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','Seed','2097-3;'),
(6760,'Seed: Red Coba','','false','seed',1,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','Seed','2097-3;'),
(6761,'Seed: Red Coba','','false','seed',1,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','Seed','2097-3;'),
(6762,'Seed: Desert Coba','','false','seed',1,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','Seed','2097-3;'),
(6763,'Seed: Desert Coba','','false','seed',1,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','Seed','2097-3;'),
(6764,'Seed: Desert Coba','','false','seed',1,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','Seed','2097-3;'),
(6765,'Seed: Desert Coba','','false','seed',1,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','Seed','2097-3;'),
(6766,'Seed: Desert Coba','','false','seed',1,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','Seed','2097-3;'),
(6767,'Seed: Twin Coba','','false','seed',1,'stackable','paper','none',-1,-1,1000,0,'true','true','true','true','true','Seed','2097-3;'),
(6768,'Seed: Blue Coba','','false','seed',1,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','Seed','2097-3;'),
(6769,'Seed: Blue Coba','','false','seed',1,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','Seed','2097-3;'),
(6770,'Seed: Blue Coba','','false','seed',1,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','Seed','2097-3;'),
(6771,'Seed: Blue Coba','','false','seed',1,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','Seed','2097-3;'),
(6772,'Seed: Blue Coba','','false','seed',1,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','Seed','2097-3;'),
(6773,'Seed: Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(6774,'Seed: Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(6775,'Seed: Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(6776,'Seed: Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(6777,'Seed: Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(6778,'Seed: Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(6779,'Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6780,'Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6781,'Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6782,'Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6783,'Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6784,'Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6785,'Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6786,'Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6787,'Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6788,'Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6789,'Mercenary Posting Ticket (Teleporter1)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6790,'Mercenary Posting Ticket (Teleporter2)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6791,'Mercenary Posting Ticket (Teleporter3)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6792,'Greater Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6793,'Greater Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6794,'Greater Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6795,'Greater Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6796,'Greater Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6797,'Greater Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6798,'Greater Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6799,'Greater Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6800,'Greater Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6801,'Greater Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6802,'Dawn Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6803,'Dawn Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6804,'Dawn Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6805,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6806,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6807,'Dawn Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6808,'Dawn Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6809,'Dawn Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6810,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6811,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6812,'Greater Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6813,'Greater Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6814,'Greater Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6815,'Greater Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6816,'Greater Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6817,'Greater Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6818,'Greater Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6819,'Greater Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6820,'Greater Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6821,'Greater Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6822,'Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6823,'Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6824,'Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6825,'Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6826,'Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6827,'Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6828,'Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6829,'Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6830,'Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6831,'Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6832,'Nephilim Warrior Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6833,'Nephilim Shaman Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(6847,'Recipe: Sealed Tateossian Earring (70%)','','false','recipe',30,'stackable','paper','none',-1,-1,74000,0,'true','true','true','true','true','Recipes','0-0;'),
(6848,'Recipe: Sealed Tateossian Earring (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,74000,0,'true','true','true','true','true','Recipes','0-0;'),
(6849,'Recipe: Sealed Tateossian Ring(70%)','','false','recipe',30,'stackable','paper','none',-1,-1,49400,0,'true','true','true','true','true','Recipes','0-0;'),
(6850,'Recipe: Sealed Tateossian Ring(100%)','','false','recipe',30,'stackable','paper','none',-1,-1,49400,0,'true','true','true','true','true','Recipes','0-0;'),
(6851,'Recipe: Sealed Tateossian Necklace(70%)','','false','recipe',30,'stackable','paper','none',-1,-1,98800,0,'true','true','true','true','true','Recipes','0-0;'),
(6852,'Recipe: Sealed Tateossian Necklace(100%)','','false','recipe',30,'stackable','paper','none',-1,-1,98800,0,'true','true','true','true','true','Recipes','0-0;'),
(6853,'Recipe: Sealed Imperial Crusader Breastplate (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,286000,0,'true','true','true','true','true','Recipes','0-0;'),
(6854,'Recipe: Sealed Imperial Crusader Breastplate (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,286000,0,'true','true','true','true','true','Recipes','0-0;'),
(6855,'Recipe: Sealed Imperial Crusader Gaiters (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,179200,0,'true','true','true','true','true','Recipes','0-0;'),
(6856,'Recipe: Sealed Imperial Crusader Gaiters (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,179200,0,'true','true','true','true','true','Recipes','0-0;'),
(6857,'Recipe: Sealed Imperial Crusader Gauntlets (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,71600,0,'true','true','true','true','true','Recipes','0-0;'),
(6858,'Recipe: Sealed Imperial Crusader Gauntlets (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,71600,0,'true','true','true','true','true','Recipes','0-0;'),
(6859,'Recipe: Sealed Imperial Crusader Boots (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,71600,0,'true','true','true','true','true','Recipes','0-0;'),
(6860,'Recipe: Sealed Imperial Crusader Boots (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,71600,0,'true','true','true','true','true','Recipes','0-0;'),
(6861,'Recipe: Sealed Imperial Crusader Shield (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,75200,0,'true','true','true','true','true','Recipes','0-0;'),
(6862,'Recipe: Sealed Imperial Crusader Shield (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,75200,0,'true','true','true','true','true','Recipes','0-0;'),
(6863,'Recipe: Sealed Imperial Crusader Helmet (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,107400,0,'true','true','true','true','true','Recipes','0-0;'),
(6864,'Recipe: Sealed Imperial Crusader Helmet (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,107400,0,'true','true','true','true','true','Recipes','0-0;'),
(6865,'Recipe: Sealed Draconic Leather Armor (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,348000,0,'true','true','true','true','true','Recipes','0-0;'),
(6866,'Recipe: Sealed Draconic Leather Armor (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,348000,0,'true','true','true','true','true','Recipes','0-0;'),
(6867,'Recipe: Sealed Draconic Leather Gloves (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,71600,0,'true','true','true','true','true','Recipes','0-0;'),
(6868,'Recipe: Sealed Draconic Leather Gloves (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,71600,0,'true','true','true','true','true','Recipes','0-0;'),
(6869,'Recipe: Sealed Draconic Leather Boots (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,71600,0,'true','true','true','true','true','Recipes','0-0;'),
(6870,'Recipe: Sealed Draconic Leather Boots (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,71600,0,'true','true','true','true','true','Recipes','0-0;'),
(6871,'Recipe: Sealed Draconic Leather Helmet (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,107400,0,'true','true','true','true','true','Recipes','0-0;'),
(6872,'Recipe: Sealed Draconic Leather Helmet (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,107400,0,'true','true','true','true','true','Recipes','0-0;'),
(6873,'Recipe: Sealed Major Arcana Robe (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,348000,0,'true','true','true','true','true','Recipes','0-0;'),
(6874,'Recipe: Sealed Major Arcana Robe (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,348000,0,'true','true','true','true','true','Recipes','0-0;'),
(6875,'Recipe: Sealed Major Arcana Gloves (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,71600,0,'true','true','true','true','true','Recipes','0-0;'),
(6876,'Recipe: Sealed Major Arcana Gloves (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,71600,0,'true','true','true','true','true','Recipes','0-0;'),
(6877,'Recipe: Sealed Major Arcana Boots (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,71600,0,'true','true','true','true','true','Recipes','0-0;'),
(6878,'Recipe: Sealed Major Arcana Boots (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,71600,0,'true','true','true','true','true','Recipes','0-0;'),
(6879,'Recipe: Sealed Major Arcana Circlet (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,107400,0,'true','true','true','true','true','Recipes','0-0;'),
(6880,'Recipe: Sealed Major Arcana Circlet (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,107400,0,'true','true','true','true','true','Recipes','0-0;'),
(6881,'Recipe: Forgotten Blade (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6882,'Recipe: Forgotten Blade (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6883,'Recipe: Basalt Battlehammer (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6884,'Recipe: Basalt Battlehammer (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6885,'Recipe: Imperial Staff (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6886,'Recipe: Imperial Staff(100%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6887,'Recipe: Angel Slayer (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6888,'Recipe: Angel Slayer (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6889,'Recipe: Shining Bow (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6890,'Recipe: Shining Bow (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6891,'Recipe: Dragon Hunter Axe (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6892,'Recipe: Dragon Hunter Axe (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6893,'Recipe: Saint Spear (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6894,'Recipe: Saint Spear (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6895,'Recipe: Demon Splinter (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6896,'Recipe: Demon Splinter (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6897,'Recipe: Heavens Divider (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6898,'Recipe: Heavens Divider (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6899,'Recipe: Arcana Mace (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6900,'Recipe: Arcana Mace (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(6901,'Recipe: Shining Arrow (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,200000,0,'true','true','true','true','true','Recipes','0-0;'),
(6903,'Music Box M','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2187-1;'),
(6904,'Party Mask Fabric','','false','material',60,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(6905,'Hair Pin Piece','','false','material',60,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(6906,'Pirate\'s Eye Patch Material','','false','material',60,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(6907,'Monocle Piece','','false','material',60,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(6908,'Fish Oil','','false','material',30,'stackable','liquid','none',-1,-1,50,0,'true','true','true','true','true','none','0-0;'),
(6909,'Greater Fish Oil','','false','material',30,'stackable','liquid','none',-1,-1,250,0,'true','true','true','true','true','none','0-0;'),
(6910,'Premium Fish Oil','','false','material',30,'stackable','liquid','none',-1,-1,1250,0,'true','true','true','true','true','none','0-0;'),
(6911,'Fish Scale','','false','material',30,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(6912,'Shiny Fish Scale','','false','material',30,'stackable','liquid','none',-1,-1,300,0,'true','true','true','true','true','none','0-0;'),
(6913,'Fish Gem','','false','material',30,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(6914,'Shiny Fish Gem','','false','material',30,'stackable','liquid','none',-1,-1,1000,0,'true','true','true','true','true','none','0-0;'),
(6915,'Thin Fish Bone','','false','material',30,'stackable','liquid','none',-1,-1,300,0,'true','true','true','true','true','none','0-0;'),
(6916,'Thick Fish Bone','','false','material',30,'stackable','liquid','none',-1,-1,450,0,'true','true','true','true','true','none','0-0;'),
(6920,'Recipe: Greater Fish Oil (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Recipes','0-0;'),
(6921,'Recipe: Premium Fish Oil(100%)','','false','recipe',30,'stackable','paper','none',-1,-1,250,0,'true','true','true','true','true','Recipes','0-0;'),
(6922,'Recipe: Party Mask (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(6923,'Recipe: Lady\'s Hair Pin (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(6924,'Recipe: Pirate\'s Eye Patch (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(6925,'Recipe: Monocle (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(6926,'Recipe: Lesser Healing Potion (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,18,0,'true','true','true','true','true','Recipes','0-0;'),
(6927,'Recipe: Healing Potion (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,66,0,'true','true','true','true','true','Recipes','0-0;'),
(6928,'Recipe: Greater Healing Potion (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,180,0,'true','true','true','true','true','Recipes','0-0;'),
(6929,'Recipe: Antidote (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,15,0,'true','true','true','true','true','Recipes','0-0;'),
(6930,'Recipe: Greater Antidote (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,36,0,'true','true','true','true','true','Recipes','0-0;'),
(6931,'Recipe: Bandage (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,15,0,'true','true','true','true','true','Recipes','0-0;'),
(6932,'Recipe: Emergency Dressing (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,36,0,'true','true','true','true','true','Recipes','0-0;'),
(6933,'Recipe: Haste Potion (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,240,0,'true','true','true','true','true','Recipes','0-0;'),
(6934,'Recipe: Potion of Alacrity (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,480,0,'true','true','true','true','true','Recipes','0-0;'),
(6935,'Recipe: Greater Haste Potion (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,600,0,'true','true','true','true','true','Recipes','0-0;'),
(6936,'Recipe: Greater Swift Attack Potion (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,1200,0,'true','true','true','true','true','Recipes','0-0;'),
(6937,'Recipe: Magic Haste Potion (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,480,0,'true','true','true','true','true','Recipes','0-0;'),
(6938,'Recipe: Greater Magic Haste Potion (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,1200,0,'true','true','true','true','true','Recipes','0-0;'),
(6939,'Recipe: Mystery Potion (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,2000,0,'true','true','true','true','true','Recipes','0-0;'),
(6940,'Recipe: Facelifting Potion - A (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6941,'Recipe: Facelifting Potion - B (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6942,'Recipe: Facelifting Potion - C (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6943,'Recipe: Dye Potion - A (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6944,'Recipe: Dye Potion - B (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6945,'Recipe: Dye Potion - C (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6946,'Recipe: Dye Potion - D (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6947,'Recipe: Hair Style Change Potion - A (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6948,'Recipe: Hair Style Change Potion - B (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6949,'Recipe: Hair Style Change Potion - C (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6950,'Recipe: Hair Style Change Potion - D (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6951,'Recipe: Hair Style Change Potion - E (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6952,'Recipe: Hair Style Change Potion - F (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6953,'Recipe: Hair Style Change Potion - G (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,4000,0,'true','true','true','true','true','Recipes','0-0;'),
(6954,'Recipe: Dye of STR <Str+1 Con-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,7000,0,'true','true','true','true','true','Recipes','0-0;'),
(6955,'Recipe: Dye of STR <Str+1 Dex-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,7000,0,'true','true','true','true','true','Recipes','0-0;'),
(6956,'Recipe: Dye of CON <Con+1 Str-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,7000,0,'true','true','true','true','true','Recipes','0-0;'),
(6957,'Recipe: Dye of CON <Con+1 Dex-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,7000,0,'true','true','true','true','true','Recipes','0-0;'),
(6958,'Recipe: Dye of DEX <Dex+1 Str-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,7000,0,'true','true','true','true','true','Recipes','0-0;'),
(6959,'Recipe: Dye of DEX <Dex+1 Con-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,7000,0,'true','true','true','true','true','Recipes','0-0;'),
(6960,'Recipe: Dye of INT <Int+1 Men-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,7000,0,'true','true','true','true','true','Recipes','0-0;'),
(6961,'Recipe: Dye of INT <Int+1 Wit-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,7000,0,'true','true','true','true','true','Recipes','0-0;'),
(6962,'Recipe: Dye of MEN <Men+1 Int-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,7000,0,'true','true','true','true','true','Recipes','0-0;'),
(6963,'Recipe: Dye of MEN <Men+1 Wit-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,7000,0,'true','true','true','true','true','Recipes','0-0;'),
(6964,'Recipe: Dye of WIT<Wit+1 Int-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,7000,0,'true','true','true','true','true','Recipes','0-0;'),
(6965,'Recipe: Dye of WIT<Wit+1 Men-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,7000,0,'true','true','true','true','true','Recipes','0-0;'),
(6966,'Recipe: Greater Dye of STR <Str+1 Con-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','Recipes','0-0;'),
(6967,'Recipe: Greater Dye of STR <Str+1 Dex-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','Recipes','0-0;'),
(6968,'Recipe: Greater Dye of CON <Con+1 Str-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','Recipes','0-0;'),
(6969,'Recipe: Greater Dye of CON <Con+1 Dex-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','Recipes','0-0;'),
(6970,'Recipe: Greater Dye of DEX <Dex+1 Str-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','Recipes','0-0;'),
(6971,'Recipe: Greater Dye of DEX <Dex+1 Con-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','Recipes','0-0;'),
(6972,'Recipe: Greater Dye of INT <Int+1 Men-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','Recipes','0-0;'),
(6973,'Recipe: Greater Dye of INT <Int+1 Wit-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','Recipes','0-0;'),
(6974,'Recipe: Greater Dye of MEN <Men+1 Int-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','Recipes','0-0;'),
(6975,'Recipe: Greater Dye of MEN <Men+1 Wit-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','Recipes','0-0;'),
(6976,'Recipe: Greater Dye of WIT<Wit+1 Int-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','Recipes','0-0;'),
(6977,'Recipe: Greater Dye of WIT<Wit+1 Men-1> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','Recipes','0-0;'),
(6978,'Recipe: Greater Dye of STR <Str+2 Con-2> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,12000,0,'true','true','true','true','true','Recipes','0-0;'),
(6979,'Recipe: Greater Dye of STR <Str+2 Dex-2> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,12000,0,'true','true','true','true','true','Recipes','0-0;'),
(6980,'Recipe: Greater Dye of CON <Con+2 Str-2> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,12000,0,'true','true','true','true','true','Recipes','0-0;'),
(6981,'Recipe: Greater Dye of CON <Con+2 Dex-2> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,12000,0,'true','true','true','true','true','Recipes','0-0;'),
(6982,'Recipe: Greater Dye of DEX <Dex+2 Str-2> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,12000,0,'true','true','true','true','true','Recipes','0-0;'),
(6983,'Recipe: Greater Dye of DEX <Dex+2 Con-2> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,12000,0,'true','true','true','true','true','Recipes','0-0;'),
(6984,'Recipe: Greater Dye of INT <Int+2 Men-2> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,12000,0,'true','true','true','true','true','Recipes','0-0;'),
(6985,'Recipe: Greater Dye of INT <Int+2 Wit-2> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,12000,0,'true','true','true','true','true','Recipes','0-0;'),
(6986,'Recipe: Greater Dye of MEN <Men+2 Int-2> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,12000,0,'true','true','true','true','true','Recipes','0-0;'),
(6987,'Recipe: Greater Dye of MEN <Men+2 Wit-2> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,12000,0,'true','true','true','true','true','Recipes','0-0;'),
(6988,'Recipe: Greater Dye of WIT<Wit+2 Int-2> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,12000,0,'true','true','true','true','true','Recipes','0-0;'),
(6989,'Recipe: Greater Dye of WIT<Wit+2 Men-2> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,12000,0,'true','true','true','true','true','Recipes','0-0;'),
(6990,'Recipe: Greater Dye of STR <Str+3 Con-3> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,18000,0,'true','true','true','true','true','Recipes','0-0;'),
(6991,'Recipe: Greater Dye of STR <Str+3 Dex-3> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,18000,0,'true','true','true','true','true','Recipes','0-0;'),
(6992,'Recipe: Greater Dye of CON <Con+3 Str-3> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,18000,0,'true','true','true','true','true','Recipes','0-0;'),
(6993,'Recipe: Greater Dye of CON <Con+3 Dex-3> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,18000,0,'true','true','true','true','true','Recipes','0-0;'),
(6994,'Recipe: Greater Dye of DEX <Dex+3 Str-3> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,18000,0,'true','true','true','true','true','Recipes','0-0;'),
(6995,'Recipe: Greater Dye of DEX <Dex+3 Con-3> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,18000,0,'true','true','true','true','true','Recipes','0-0;'),
(6996,'Recipe: Greater Dye of INT <Int+3 Men-3> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,18000,0,'true','true','true','true','true','Recipes','0-0;'),
(6997,'Recipe: Greater Dye of INT <Int+3 Wit-3> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,18000,0,'true','true','true','true','true','Recipes','0-0;'),
(6998,'Recipe: Greater Dye of MEN <Men+3 Int-3> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,18000,0,'true','true','true','true','true','Recipes','0-0;'),
(6999,'Recipe: Greater Dye of MEN <Men+3 Wit-3> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,18000,0,'true','true','true','true','true','Recipes','0-0;'),
(7000,'Recipe: Greater Dye of WIT<Wit+3 Int-3> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,18000,0,'true','true','true','true','true','Recipes','0-0;'),
(7001,'Recipe: Greater Dye of WIT<Wit+3 Men-3> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,18000,0,'true','true','true','true','true','Recipes','0-0;'),
(7002,'Recipe: Greater Dye of STR <Str+4 Con-4> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,29000,0,'true','true','true','true','true','Recipes','0-0;'),
(7003,'Recipe: Greater Dye of STR <Str+4 Dex-4> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,29000,0,'true','true','true','true','true','Recipes','0-0;'),
(7004,'Recipe: Greater Dye of CON <Con+4 Str-4> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,29000,0,'true','true','true','true','true','Recipes','0-0;'),
(7005,'Recipe: Greater Dye of CON <Con+4 Dex-4> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,29000,0,'true','true','true','true','true','Recipes','0-0;'),
(7006,'Recipe: Greater Dye of DEX <Dex+4 Str-4> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,29000,0,'true','true','true','true','true','Recipes','0-0;'),
(7007,'Recipe: Greater Dye of DEX <Dex+4 Con-4> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,29000,0,'true','true','true','true','true','Recipes','0-0;'),
(7008,'Recipe: Greater Dye of INT <Int+4 Men-4> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,29000,0,'true','true','true','true','true','Recipes','0-0;'),
(7009,'Recipe: Greater Dye of INT <Int+4 Wit-4> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,29000,0,'true','true','true','true','true','Recipes','0-0;'),
(7010,'Recipe: Greater Dye of MEN <Men+4 Int-4> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,29000,0,'true','true','true','true','true','Recipes','0-0;'),
(7011,'Recipe: Greater Dye of MEN <Men+4 Wit-4> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,29000,0,'true','true','true','true','true','Recipes','0-0;'),
(7012,'Recipe: Greater Dye of WIT<Wit+4 Int-4> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,29000,0,'true','true','true','true','true','Recipes','0-0;'),
(7013,'Recipe: Greater Dye of WIT<Wit+4 Men-4> (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,29000,0,'true','true','true','true','true','Recipes','0-0;'),
(7016,'Seed: Blue Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(7017,'Seed: Blue Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(7018,'Seed: Blue Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(7019,'Seed: Chilly Cobol','','false','seed',1,'stackable','paper','none',-1,-1,25,0,'true','true','true','true','true','Seed','2097-2;'),
(7020,'Seed: Chilly Coda','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(7021,'Seed: Chilly Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(7022,'Seed: Chilly Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(7023,'Seed: Desert Codran','','false','seed',1,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','Seed','2097-3;'),
(7024,'Seed: Desert Codran','','false','seed',1,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','Seed','2097-3;'),
(7025,'Seed: Golden Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(7026,'Seed: Golden Coda','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(7027,'Seed: Great Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(7028,'Seed: Great Codran','','false','seed',1,'stackable','paper','none',-1,-1,75,0,'true','true','true','true','true','Seed','2097-3;'),
(7029,'Seed: Great Codran','','false','seed',1,'stackable','paper','none',-1,-1,75,0,'true','true','true','true','true','Seed','2097-3;'),
(7030,'Seed: Alternative Blue Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(7031,'Seed: Alternative Blue Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(7032,'Seed: Alternative Blue Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(7033,'Seed: Alternative Chilly Cobol','','false','seed',1,'stackable','paper','none',-1,-1,25,0,'true','true','true','true','true','Seed','2097-2;'),
(7034,'Seed: Alternative Chilly Coda','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(7035,'Seed: Alternative Chilly Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(7036,'Seed: Alternative Chilly Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(7037,'Seed: Alternative Desert Codran','','false','seed',1,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','Seed','2097-3;'),
(7038,'Seed: Alternative Desert Codran','','false','seed',1,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','Seed','2097-3;'),
(7039,'Seed: Alternative Golden Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(7040,'Seed: Alternative Golden Coda','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(7041,'Seed: Alternative Great Cobol','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-2;'),
(7042,'Seed: Alternative Great Codran','','false','seed',1,'stackable','paper','none',-1,-1,75,0,'true','true','true','true','true','Seed','2097-3;'),
(7043,'Seed: Alternative Great Codran','','false','seed',1,'stackable','paper','none',-1,-1,75,0,'true','true','true','true','true','Seed','2097-3;'),
(7044,'Seed: Alternative Red Cobol','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-2;'),
(7045,'Seed: Alternative Red Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(7046,'Seed: Alternative Red Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(7047,'Seed: Alternative Sea Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(7048,'Seed: Alternative Sea Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(7049,'Seed: Alternative Sea Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(7050,'Seed: Alternative Twin Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(7051,'Seed: Red Cobol','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-2;'),
(7052,'Seed: Red Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(7053,'Seed: Red Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(7054,'Seed: Sea Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(7055,'Seed: Sea Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(7056,'Seed: Sea Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(7057,'Seed: Twin Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(7061,'Echo Crystal - Theme of Birthday','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2073-1;'),
(7062,'Echo Crystal - Theme of Wedding','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2230-1;'),
(7063,'Map - Forest of the Dead','','false','none',1,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7064,'Lidia\'s Diary','','false','none',1,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7065,'Lidia\'s Letter','','false','none',1,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7066,'Contract','','false','none',1,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7067,'Special Bait 1','','false','lure',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7068,'Special Bait 2','','false','lure',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7069,'Special Bait 3','','false','lure',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7070,'Special Bait 4','','false','lure',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7071,'Special Fish 1','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7072,'Special Fish 2','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7073,'Special Fish 3','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7074,'Special Fish 4','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7075,'Entrance Pass to the Sepulcher','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7076,'Mysterious Cloth','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7077,'Jewel Box','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7078,'Sewing Kit','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7079,'Dimensional Fragment','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7080,'Ice Crystal','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7081,'Divine Stone of Wisdom','','false','none',10,'normal','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7082,'Guild Report','','false','none',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7083,'Guild Report','','false','none',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7084,'Guild Report','','false','none',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7085,'Guild Report','','false','none',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7086,'Guild Report','','false','none',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7087,'Tattered Book','','false','none',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7088,'Tattered Book','','false','none',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7089,'Tattered Book','','false','none',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7090,'Tattered Book','','false','none',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7091,'Guild Report','','false','none',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7092,'Guild Report','','false','none',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7093,'Sculpture of the Fallen Knight','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7094,'Record of Mother Tree Guardian','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7095,'Criticism of Biel\'s Song','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7096,'The Last Days of Swordsman Iron','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7097,'Contemplation of White Wing Army','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7098,'Record of Traitor Muhark','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7099,'Secret Book of Khavatari','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7100,'Importance of Strain','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7101,'Danger of Ice Spirit','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7102,'Guardian Angel of the Tablet - Vol. 1','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7103,'Guardian Angel of the Tablet - Vol. 1','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7104,'Guardian Angel of the Tablet - Vol. 1','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7105,'Guardian Angel of the Tablet - Vol. 2','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7106,'Guardian Angel of the Tablet - Vol. 2','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7107,'Guardian Angel of the Tablet - Vol. 2','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7108,'Guild\'s Secret Report','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7109,'Guild\'s Secret Report','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7110,'Research Report','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7111,'Research Report','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7112,'Research Report','','false','none',0,'normal','paper','none',-1,-1,0,0,'false','false','false','false','false','Book','0-0;'),
(7113,'Dress Shoe Box','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7114,'Voucher - Buffalo','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7115,'Voucher - Cougar','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7116,'Voucher - Kookaburra','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7117,'Scroll of Escape: Talking Island','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-1;'),
(7118,'Scroll of Escape: Elven Village','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-2;'),
(7119,'Scroll of Escape: Dark Elf Village','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-3;'),
(7120,'Scroll of Escape: Orc Village','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-4;'),
(7121,'Scroll of Escape: Dwarven Village','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-5;'),
(7122,'Scroll of Escape: Gludin Village','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-6;'),
(7123,'Scroll of Escape: Town of Gludio','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-7;'),
(7124,'Scroll of Escape: Town of Dion','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-8;'),
(7125,'Scroll of Escape: Floran','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-9;'),
(7126,'Scroll of Escape: Giran Castle Town','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-10;'),
(7127,'Scroll of Escape: Hardin\'s Private Academy','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-11;'),
(7128,'Scroll of Escape: Heine','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-12;'),
(7129,'Scroll of Escape: Town of Oren','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-13;'),
(7130,'Scroll of Escape: Ivory Tower','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-14;'),
(7131,'Scroll of Escape: Hunters Village','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-15;'),
(7132,'Scroll of Escape: Aden Castle Town','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-16;'),
(7133,'Scroll of Escape: Town of Goddard','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-17;'),
(7134,'Scroll of Escape: Rune Township','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-18;'),
(7135,'Scroll of Escape: Town of Schuttgart','','false','none',30,'stackable','paper','none',-1,-1,35000,0,'true','true','true','true','true','ItemSkills','2213-19;'),
(7136,'Fruit Basket','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7137,'Avellan Spice','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7138,'Honey Pouch','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7139,'Bracelet of Lizardman','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7140,'Cross of Einhasad','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7141,'Cross of Einhasad','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7142,'Lost Skull of Elf','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7143,'Letter of Innocentin','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7144,'Jewel of Adventurer','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7145,'Jewel of Adventurer','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7146,'Sealed Report Box','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7147,'Report Box','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7148,'Lidia\'s Hairpin','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7149,'Silver Key','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7150,'Silver Spear','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7151,'Suspicious Totem Doll','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7152,'Flower Bouquet','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7153,'Silver Cross of Einhasad','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7154,'Broken Silver Cross of Einhasad','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7155,'Lidia\'s Dress','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7156,'Suspicious Totem Doll','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7157,'Gemstone Key','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7158,'Suspicious Totem Doll','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7159,'Box of Cookies','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7160,'Luxury Wine','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7161,'SCain of Yarn','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7162,'Rough Jewel','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7163,'Enchanted Iron','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7164,'Signet Ring','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7165,'Map','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7166,'Medicinal Herb','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7167,'Crystal of Seal','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7168,'Blood of Saint','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7169,'Blood of Saint','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7170,'Seal of Light','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7171,'Bead of Obedience','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7172,'Gem of Saints','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7173,'Feather Ornament','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7174,'Tooth of Totem','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7175,'Tooth of Dragon','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7176,'Letter of Iris','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7177,'Letter of Rohmer','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7178,'Black Bone Necklace','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7179,'Red Bone Necklace','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7180,'Incense Pouch','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7181,'Gem of Maille Lizardman','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7182,'Patrol\'s Report','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7183,'Shining Gem','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7184,'Shining Red Gem','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7185,'Jewel of Innocence','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7186,'Horn of Buffalo','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7187,'Nepenthes Seed','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7188,'Proof of Avenger','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7189,'Eye of Darkness','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7190,'Evil Spirit of Darkness','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7191,'Broken Crystal','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7192,'Unfinished Summon Crystal','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7193,'Summon Crystal','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7194,'Essence of Daimon','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7195,'Boiled Eggs','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7196,'Fee of Boiled Egg','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7197,'Special Drink','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7198,'Fee of Special Drink','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7199,'Leaf of Flava','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7200,'Buffalo Meat','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7201,'Antelope Horn','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7202,'Trunk of Nepenthes','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7203,'Foot of Bandersnatchling','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7204,'Secret Spice','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7205,'Soy Sauce Jar','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7206,'Boiled Eggs for Delivery','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7207,'Special Drink for Delivery','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7208,'Hot Food Box','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7209,'Food for Bumbalump','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7210,'Special Yeti Meat','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7211,'Mark of Ketra\'s Alliance - Level 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7212,'Mark of Ketra\'s Alliance - Level 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7213,'Mark of Ketra\'s Alliance - Level 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7214,'Mark of Ketra\'s Alliance - Level 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7215,'Mark of Ketra\'s Alliance - Level 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7216,'Varka\'s Badge - Soldier','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7217,'Varka\'s Badge - Captain','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7218,'Varka\'s Badge - General','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7219,'Totem of Valor','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7220,'Totem of Wisdom','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7221,'Mark of Varka\'s Alliance - Level 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7222,'Mark of Varka\'s Alliance - Level 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7223,'Mark of Varka\'s Alliance - Level 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7224,'Mark of Varka\'s Alliance - Level 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7225,'Mark of Varka\'s Alliance - Level 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7226,'Ketra\'s Badge - Soldier','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7227,'Ketra\'s Badge - Captain','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7228,'Ketra\'s Badge - General','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7229,'Feather of Valor','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7230,'Feather of Wisdom','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7231,'Munitions Box','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7232,'Munitions Box','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7233,'Varka\'s Mane','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7234,'Molar of Ketra Orc','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7235,'Head of Shadith','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7236,'Head of Mos','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7237,'Stolen Green Totem','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7238,'Green Totem','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7239,'Ice Heart of Ashutar','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7240,'Head of Hekaton','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7241,'Head of Tayr','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7242,'Stolen Red Totem','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7243,'Red Totem','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7244,'Fire Heart of Nastron','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7245,'Supply Box','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7246,'Golden Ram Badge - Recruit','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7247,'Golden Ram Badge - Soldier','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7248,'Splinter Stakato Chitin','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7249,'Needle Stakato Chitin','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7250,'Talon of Stakato','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7251,'Golden Ram Coin','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7252,'Krorin\'s Journal','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7253,'Letter to Archaeologist','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7254,'Broken Relic Part','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7255,'Sealed Box','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7256,'Goblet of Alectia','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7257,'Goblet of Tishas','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7258,'Goblet of Mekara','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7259,'Goblet of Morigul','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7260,'Chapel Key','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7261,'Used Grave Pass','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7262,'Antique Brooch','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7263,'Package to Vulcan','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7264,'Torch','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7265,'Vacualite Ore','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7266,'Vacualite','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7267,'Floating Stone','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7268,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7269,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7270,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7271,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7272,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7273,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7274,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7275,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7276,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7277,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7278,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7279,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7280,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7281,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7282,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7283,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7284,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7285,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7286,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7287,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7288,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7289,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7290,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7291,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7292,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7293,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7294,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7295,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7296,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7297,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7298,'Resonance Amulet - 1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7299,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7300,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7301,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7302,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7303,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7304,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7305,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7306,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7307,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7308,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7309,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7310,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7311,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7312,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7313,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7314,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7315,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7316,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7317,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7318,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7319,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7320,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7321,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7322,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7323,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7324,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7325,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7326,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7327,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7328,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7329,'Resonance Amulet - 2','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7330,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7331,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7332,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7333,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7334,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7335,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7336,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7337,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7338,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7339,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7340,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7341,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7342,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7343,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7344,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7345,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7346,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7347,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7348,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7349,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7350,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7351,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7352,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7353,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7354,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7355,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7356,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7357,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7358,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7359,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7360,'Resonance Amulet - 3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7361,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7362,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7363,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7364,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7365,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7366,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7367,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7368,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7369,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7370,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7371,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7372,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7373,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7374,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7375,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7376,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7377,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7378,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7379,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7380,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7381,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7382,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7383,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7384,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7385,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7386,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7387,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7388,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7389,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7390,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7391,'Resonance Amulet - 4','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7392,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7393,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7394,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7395,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7396,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7397,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7398,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7399,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7400,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7401,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7402,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7403,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7404,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7405,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7406,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7407,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7408,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7409,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7410,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7411,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7412,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7413,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7414,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7415,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7416,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7417,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7418,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7419,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7420,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7421,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7422,'Resonance Amulet - 5','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7423,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7424,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7425,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7426,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7427,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7428,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7429,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7430,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7431,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7432,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7433,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7434,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7435,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7436,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7437,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7438,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7439,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7440,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7441,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7442,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7443,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7444,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7445,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7446,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7447,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7448,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7449,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7450,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7451,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7452,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7453,'Resonance Amulet - 6','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7454,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7455,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7456,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7457,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7458,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7459,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7460,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7461,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7462,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7463,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7464,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7465,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7466,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7467,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7468,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7469,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7470,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7471,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7472,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7473,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7474,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7475,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7476,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7477,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7478,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7479,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7480,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7481,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7482,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7483,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7484,'Resonance Amulet - 7','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;');

INSERT INTO `etcitem` VALUES
(7485,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7486,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7487,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7488,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7489,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7490,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7491,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7492,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7493,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7494,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7495,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7496,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7497,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7498,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7499,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7500,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7501,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7502,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7503,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7504,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7505,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7506,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7507,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7508,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7509,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7510,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7511,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7512,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7513,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7514,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7515,'Halisha\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7516,'Ice Wine','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7517,'Donath\'s\' Dish','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7518,'Donath\'s\' Note - Vol.1','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7519,'Shaved Ice','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7520,'Ice Cream','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7521,'Ice Crystal Gemstone','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7522,'Offering','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7523,'Offering','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7524,'Offering','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7525,'Offering','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7526,'Ancient Language Dictionary','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7527,'Ancient Language Dictionary','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7528,'Spinneret','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7529,'Investigative Report','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7530,'Investigative Report','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7531,'Investigative Report','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7532,'Investigative Report','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7533,'Investigative Report','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7534,'Ice Cold Flower','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7535,'Pure Ice','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7536,'Bitter Cold Beer','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7537,'Multiple Course Meal','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7538,'Dead Souls Fish Soup','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7539,'Bitter Cold Vodka','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7540,'Silver Crystal','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7541,'Red Crystal','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7542,'Vampire\'s Heart','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7543,'Zombie\'s Brain','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7544,'Rib Bone of a Black Magus','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7545,'Zombie\'s Liver','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7546,'Top Quality Meat','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7547,'Young Wild Beast Meat','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7548,'Map Piece','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7549,'Yellow Map','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7550,'Map Piece','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7551,'Ivory Colored Map','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7552,'Broken Gemstone Fragment','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7553,'Gold Colored Gemstone','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7554,'Scroll of Escape: Talking Island','','false','none',0,'normal','paper','none',-1,-1,400,0,'false','false','true','false','true','ItemSkills','2214-1;'),
(7555,'Scroll of Escape: Elven Village','','false','none',0,'normal','paper','none',-1,-1,400,0,'false','false','true','false','true','ItemSkills','2214-2;'),
(7556,'Scroll of Escape: Dark Elf Village','','false','none',0,'normal','paper','none',-1,-1,400,0,'false','false','true','false','true','ItemSkills','2214-3;'),
(7557,'Scroll of Escape: Orc Village','','false','none',0,'normal','paper','none',-1,-1,400,0,'false','false','true','false','true','ItemSkills','2214-4;'),
(7558,'Scroll of Escape: Dwarven Village','','false','none',0,'normal','paper','none',-1,-1,400,0,'false','false','true','false','true','ItemSkills','2214-5;'),
(7559,'Scroll of Escape: Giran Castle Town','','false','none',0,'normal','paper','none',-1,-1,400,0,'false','false','true','false','true','ItemSkills','2214-10;'),
(7561,'Fishing Manual','','false','none',0,'normal','paper','none',-1,-1,100,0,'false','false','true','false','true','Book','0-0;'),
(7562,'Dimensional Diamond','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7563,'Galladucci\'s Order (Document)','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7564,'Galladucci\'s Order (Document)','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7565,'Galladucci\'s Order (Document)','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7566,'Purified Magic Necklace','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7567,'Gemstone Powder','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7568,'Magic Sword Hilt','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7569,'Four-leaf Golden Clover Coin','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7570,'Mark of Traveler','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7571,'Baulro\'s Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7572,'Ariel\'s Recommendation','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7573,'Roselyn\'s Note','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7574,'Very Expensive Necklace','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7579,'Draconic Bow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,91471,0,'true','true','true','true','true','none','0-0;'),
(7580,'Recipe: Draconic Bow (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(7581,'Recipe: Draconic Bow (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,976000,0,'true','true','true','true','true','Recipes','0-0;'),
(7582,'Baby Spice','','false','none',10,'stackable','liquid','none',-1,-1,108,0,'true','true','true','true','true','PetFood','0-0;'),
(7583,'Pet Exchange Ticket: Buffalo','','false','none',20,'stackable','paper','none',-1,-1,500000,0,'true','true','true','true','true','none','0-0;'),
(7584,'Pet Exchange Ticket: Cougar','','false','none',20,'stackable','paper','none',-1,-1,500000,0,'true','true','true','true','true','none','0-0;'),
(7585,'Pet Exchange Ticket: Kookaburra','','false','none',20,'stackable','paper','none',-1,-1,500000,0,'true','true','true','true','true','none','0-0;'),
(7586,'Sweet Fluid','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7587,'Legend of Seventeen','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7588,'Faded Poetry Book','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7589,'Echo Crystal - Forgotten Song','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7590,'Strand of Golden Hair','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7591,'Ring of Goddess: Waterbinder','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7592,'Necklace of Goddess: EverGreen','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7593,'Staff of Goddess: Rain Song','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7594,'Relic Box','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7595,'Orb of Binding','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7596,'Sorcery Ingredient','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7597,'Malruk Succubus Claw','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7598,'Crimson Moss','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7599,'Rahorakti\'s Miraculous Medicine','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7600,'Worn Tarot Card - Wealth','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7601,'Worn Tarot Card - Power','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7602,'Worn Tarot Card - Love','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7603,'Worn Tarot Card - Knowledge','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7604,'Summoner Keats\' Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7605,'Miracle Potion of Transferred Life','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7606,'Kamilen\'s Antidote','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7607,'Coolant of the Repaired Wilma #3','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7608,'Sealed Envelope','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7609,'Proof of Catching a Fish','','false','none',0,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(7610,'Wind Fishing Lure','','false','lure',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7611,'Icy Air Fishing Lure','','false','lure',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7612,'Earth Fishing Lure','','false','lure',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7613,'Flaming Fishing Lure','','false','lure',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7614,'Chest Caught by Wind Fishing Lure','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7615,'Chest Caught by Icy Air Fishing Lure','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7616,'Chest Caught by Earth Fishing Lure','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7617,'Chest Caught by using a Flaming Fishing Lure','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(7618,'Scroll of Escape: Ketra Orc Village','','false','none',30,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','ItemSkills','2213-20;'),
(7619,'Scroll of Escape: Varka Silenos Village','','false','none',30,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','ItemSkills','2213-21;'),
(7620,'Trash','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7621,'Essence of Wind','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7622,'Lost Bait Ingredient','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7623,'Eye of Tarlk Basilisk','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7624,'Crimson Drake Heart','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7625,'Strange Golem Blueprint','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7626,'Kiki\'s Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7627,'Small Glass Box','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7628,'Rukal\'s Musical Score','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(7629,'Looted Goods - White Cargo box','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2217-1;'),
(7630,'Looted Goods - Blue Cargo box','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2217-2;'),
(7631,'Looted Goods - Yellow Cargo box','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2217-3;'),
(7632,'Looted Goods - Red Cargo Box','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2217-4;'),
(7633,'Looted Goods - Purple Cargo Box','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2217-5;'),
(7634,'Looted Goods - Brown Pouch','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2219-1;'),
(7635,'Looted Goods - Gray Pouch','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2219-2;'),
(7636,'Booty - Yellow Pouch','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2218-1;'),
(7637,'Booty - Brown Pouch','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2218-2;'),
(7638,'Spellbook - Mass Summon Storm Cubic','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(7639,'Spellbook - Mass Summon Aqua Cubic','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(7640,'Spellbook - Mass Summon Phantom Cubic','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(7641,'Spellbook - Summon Feline Queen','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(7642,'Spellbook - Summon Unicorn Seraphim','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(7643,'Spellbook - Summon Nightshade','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(7644,'Spellbook - Summon Cursed Man','','false','spellbook',120,'stackable','paper','none',-1,-1,3200,0,'true','true','true','true','true','none','0-0;'),
(7645,'Spellbook - Balance Life','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7646,'Spellbook - Curse of Doom','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7647,'Spellbook - Curse of Abyss','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7648,'Spellbook - Arcane Chaos','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7649,'Spellbook - Fire Vortex','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7650,'Spellbook - Ice Vortex','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7651,'Spellbook - Wind Vortex','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7652,'Spellbook - Light Vortex','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7653,'Spellbook - Dark Vortex','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7654,'Spellbook - Mass Warrior Bane','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7655,'Spellbook - Mass Mage Bane','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7656,'Spellbook - Warrior Servitor','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7657,'Spellbook - Wizard Servitor','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7658,'Spellbook - Assassin Servitor','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7659,'Spellbook - Final Servitor','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7660,'Spellbook - Warrior Bane','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7661,'Spellbook - Mage Bane','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7662,'Spellbook - Elemental Protection','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7663,'Spellbook - Divine Protection','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7664,'Spellbook - Arcane Protection','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7665,'Spellbook - Prophecy of Water','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7666,'Spellbook - Prophecy of Fire','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7667,'Spellbook - Prophecy of Wind','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7668,'Spellbook - Block Shield','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7669,'Spellbook - Block Wind Walk','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7670,'Spellbook - Mass Block Shield','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7671,'Spellbook - Mass Block Wind Walk','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7672,'Amulet - Chant of Spirit','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7673,'Amulet - Chant of Victory','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7674,'Amulet - Pa\'agrio\'s Eye','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7675,'Amulet - Pa\'agrio\'s Soul','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7676,'Amulet - Seal of Despair','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7677,'Virgil\'s Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','none','0-0;'),
(7678,'Caradine\'s Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','none','0-0;'),
(7679,'Caradine\'s Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','none','0-0;'),
(7684,'Raccoon Ears Fabric','','false','material',60,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(7685,'Outlaw\'s Eyepatch Strap','','false','material',60,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(7686,'Maiden\'s Hairpin Piece','','false','material',60,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(7687,'Rabbit Ears Fabric','','false','material',60,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(7688,'Cat Ears Fabric','','false','material',60,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(7689,'Recipe - Raccoon Ears (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','Recipes','0-0;'),
(7690,'Recipe - Outlaw\'s Eyepatch (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(7691,'Recipe - Maiden\'s Hairpin (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(7692,'Recipe - Rabbit Ears (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','Recipes','0-0;'),
(7693,'Recipe - Cat Ears (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','Recipes','0-0;'),
(7697,'Piece of Forget-me-not Hairpin','','false','material',60,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(7698,'Piece of Daisy Hairpin','','false','material',60,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(7699,'Recipe: Forget-me-not Hairpin (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(7700,'Recipe: Daisy Hairpin (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(7725,'Loot - Gray Pouch','','false','none',1,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2218-3;'),
(7726,'Small Nimble Green Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,69,0,'true','true','true','true','true','ItemSkills','2220-1;'),
(7727,'Small Ugly Green Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,71,0,'true','true','true','true','true','ItemSkills','2220-2;'),
(7728,'Small Pudgy Green Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,77,0,'true','true','true','true','true','ItemSkills','2220-3;'),
(7729,'Nimble Green Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,84,0,'true','true','true','true','true','ItemSkills','2220-4;'),
(7730,'Ugly Green Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,94,0,'true','true','true','true','true','ItemSkills','2220-5;'),
(7731,'Pudgy Green Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,104,0,'true','true','true','true','true','ItemSkills','2220-6;'),
(7732,'Large Nimble Green Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,113,0,'true','true','true','true','true','ItemSkills','2220-7;'),
(7733,'Large Ugly Green Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,124,0,'true','true','true','true','true','ItemSkills','2220-8;'),
(7734,'Large Pudgy Green Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,133,0,'true','true','true','true','true','ItemSkills','2220-9;'),
(7735,'Small Jade Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,143,0,'true','true','true','true','true','ItemSkills','2221-1;'),
(7736,'Small Jade Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,167,0,'true','true','true','true','true','ItemSkills','2221-2;'),
(7737,'Small Jade Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,167,0,'true','true','true','true','true','ItemSkills','2221-3;'),
(7738,'Jade Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,166,0,'true','true','true','true','true','ItemSkills','2221-4;'),
(7739,'Jade Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,165,0,'true','true','true','true','true','ItemSkills','2221-5;'),
(7740,'Jade Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,165,0,'true','true','true','true','true','ItemSkills','2221-6;'),
(7741,'Large Jade Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,164,0,'true','true','true','true','true','ItemSkills','2221-7;'),
(7742,'Large Jade Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,164,0,'true','true','true','true','true','ItemSkills','2221-8;'),
(7743,'Large Jade Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,163,0,'true','true','true','true','true','ItemSkills','2221-9;'),
(7744,'Small Blue Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,163,0,'true','true','true','true','true','ItemSkills','2222-1;'),
(7745,'Small Blue Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,163,0,'true','true','true','true','true','ItemSkills','2222-2;'),
(7746,'Small Blue Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,198,0,'true','true','true','true','true','ItemSkills','2222-3;'),
(7747,'Blue Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,202,0,'true','true','true','true','true','ItemSkills','2222-4;'),
(7748,'Blue Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,197,0,'true','true','true','true','true','ItemSkills','2222-5;'),
(7749,'Blue Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,210,0,'true','true','true','true','true','ItemSkills','2222-6;'),
(7750,'Large Blue Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,213,0,'true','true','true','true','true','ItemSkills','2222-7;'),
(7751,'Large Blue Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,216,0,'true','true','true','true','true','ItemSkills','2222-8;'),
(7752,'Large Blue Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,218,0,'true','true','true','true','true','ItemSkills','2222-9;'),
(7753,'Small Yellow Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,221,0,'true','true','true','true','true','ItemSkills','2223-1;'),
(7754,'Small Yellow Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,224,0,'true','true','true','true','true','ItemSkills','2223-2;'),
(7755,'Small Yellow Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,226,0,'true','true','true','true','true','ItemSkills','2223-3;'),
(7756,'Yellow Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,270,0,'true','true','true','true','true','ItemSkills','2223-4;'),
(7757,'Yellow Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,277,0,'true','true','true','true','true','ItemSkills','2223-5;'),
(7758,'Yellow Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,284,0,'true','true','true','true','true','ItemSkills','2223-6;'),
(7759,'Large Yellow Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,290,0,'true','true','true','true','true','ItemSkills','2223-7;'),
(7760,'Large Yellow Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,297,0,'true','true','true','true','true','ItemSkills','2223-8;'),
(7761,'Large Yellow Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,304,0,'true','true','true','true','true','ItemSkills','2223-9;'),
(7762,'Small Orange Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,311,0,'true','true','true','true','true','ItemSkills','2224-1;'),
(7763,'Small Orange Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,318,0,'true','true','true','true','true','ItemSkills','2224-2;'),
(7764,'Small Orange Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,325,0,'true','true','true','true','true','ItemSkills','2224-3;'),
(7765,'Orange Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,332,0,'true','true','true','true','true','ItemSkills','2224-4;'),
(7766,'Orange Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,388,0,'true','true','true','true','true','ItemSkills','2224-5;'),
(7767,'Orange Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,396,0,'true','true','true','true','true','ItemSkills','2224-6;'),
(7768,'Large Orange Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,408,0,'true','true','true','true','true','ItemSkills','2224-7;'),
(7769,'Large Orange Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,420,0,'true','true','true','true','true','ItemSkills','2224-8;'),
(7770,'Large Orange Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,429,0,'true','true','true','true','true','ItemSkills','2224-9;'),
(7771,'Small Purple Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,438,0,'true','true','true','true','true','ItemSkills','2225-1;'),
(7772,'Small Purple Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,447,0,'true','true','true','true','true','ItemSkills','2225-2;'),
(7773,'Small Purple Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,455,0,'true','true','true','true','true','ItemSkills','2225-3;'),
(7774,'Purple Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,465,0,'true','true','true','true','true','ItemSkills','2225-4;'),
(7775,'Purple Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,474,0,'true','true','true','true','true','ItemSkills','2225-5;'),
(7776,'Purple Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,545,0,'true','true','true','true','true','ItemSkills','2225-6;'),
(7777,'Large Purple Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,556,0,'true','true','true','true','true','ItemSkills','2225-7;'),
(7778,'Large Purple Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,567,0,'true','true','true','true','true','ItemSkills','2225-8;'),
(7779,'Large Purple Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,579,0,'true','true','true','true','true','ItemSkills','2225-9;'),
(7780,'Small Red Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,639,0,'true','true','true','true','true','ItemSkills','2226-1;'),
(7781,'Small Red Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,651,0,'true','true','true','true','true','ItemSkills','2226-2;'),
(7782,'Small Red Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,663,0,'true','true','true','true','true','ItemSkills','2226-3;'),
(7783,'Red Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,676,0,'true','true','true','true','true','ItemSkills','2226-4;'),
(7784,'Red Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,688,0,'true','true','true','true','true','ItemSkills','2226-5;'),
(7785,'Red Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,701,0,'true','true','true','true','true','ItemSkills','2226-6;'),
(7786,'Large Red Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,789,0,'true','true','true','true','true','ItemSkills','2226-7;'),
(7787,'Large Red Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,804,0,'true','true','true','true','true','ItemSkills','2226-8;'),
(7788,'Large Red Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,858,0,'true','true','true','true','true','ItemSkills','2226-9;'),
(7789,'Small White Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,874,0,'true','true','true','true','true','ItemSkills','2227-1;'),
(7790,'Small White Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,891,0,'true','true','true','true','true','ItemSkills','2227-2;'),
(7791,'Small White Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,907,0,'true','true','true','true','true','ItemSkills','2227-3;'),
(7792,'White Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,925,0,'true','true','true','true','true','ItemSkills','2227-4;'),
(7793,'White Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,944,0,'true','true','true','true','true','ItemSkills','2227-5;'),
(7794,'White Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,962,0,'true','true','true','true','true','ItemSkills','2227-6;'),
(7795,'Large White Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,981,0,'true','true','true','true','true','ItemSkills','2227-7;'),
(7796,'Large White Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,1000,0,'true','true','true','true','true','ItemSkills','2227-8;'),
(7797,'Large White Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,1020,0,'true','true','true','true','true','ItemSkills','2227-9;'),
(7798,'Small Black Nimble Fish: For Beginners','','false','none',100,'stackable','paper','none',-1,-1,1041,0,'true','true','true','true','true','ItemSkills','2228-1;'),
(7799,'Small Black Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,1062,0,'true','true','true','true','true','ItemSkills','2228-2;'),
(7800,'Small Black Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,1083,0,'true','true','true','true','true','ItemSkills','2228-3;'),
(7801,'Black Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,1155,0,'true','true','true','true','true','ItemSkills','2228-4;'),
(7802,'Black Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,1179,0,'true','true','true','true','true','ItemSkills','2228-5;'),
(7803,'Black Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,1202,0,'true','true','true','true','true','ItemSkills','2228-6;'),
(7804,'Large Black Nimble Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,1226,0,'true','true','true','true','true','ItemSkills','2228-7;'),
(7805,'Large Black Ugly Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,1251,0,'true','true','true','true','true','ItemSkills','2228-8;'),
(7806,'Large Black Fat Fish - For Beginners','','false','none',100,'stackable','paper','none',-1,-1,1276,0,'true','true','true','true','true','ItemSkills','2228-9;'),
(7807,'Green Colored Lure - For Beginners','','false','lure',5,'stackable','liquid','none',-1,-1,50,0,'true','true','true','true','true','none','0-0;'),
(7808,'Purple Colored Lure - For Beginners','','false','lure',5,'stackable','liquid','none',-1,-1,70,0,'true','true','true','true','true','none','0-0;'),
(7809,'Yellow Colored Lure - For Beginners','','false','lure',5,'stackable','liquid','none',-1,-1,60,0,'true','true','true','true','true','none','0-0;'),
(7832,'Apprentice Adventurer\'s Weapon Exchange Coupon','','false','none',1,'normal','paper','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(7833,'Adventurer\'s Magic Accessory Exchange Coupon','','false','none',1,'normal','paper','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(7835,'Amulet: Seal of Disease','','false','spellbook',120,'stackable','paper','none',-1,-1,11600,0,'true','true','true','true','true','none','0-0;'),
(7838,'Santa\'s Hat','','false','none',10,'normal','paper','none',-1,-1,0,0,'true','false','true','true','true','none','0-0;'),
(7904,'Boat Ticket: Rune to Gludin','','false','none',20,'stackable','paper','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(7905,'Boat Ticket: Gludin to Rune','','false','none',20,'stackable','paper','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(7906,'Blessing of Fire','','false','none',20,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2248-1;'),
(7907,'Blessing of Water','','false','none',20,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2249-1;'),
(7908,'Blessing of Wind','','false','none',20,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2250-1;'),
(7909,'Blessing of Earth','','false','none',20,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2251-1;'),
(7910,'Blessing of Darkness','','false','none',20,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2252-1;'),
(7911,'Blessing of Sanctity','','false','none',20,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2253-1;'),
(7912,'Fire Crystal','','false','none',20,'stackable','liquid','none',-1,-1,3000,0,'true','true','true','true','true','ItemSkills','0-0;'),
(7913,'Water Crystal','','false','none',20,'stackable','liquid','none',-1,-1,3000,0,'true','true','true','true','true','ItemSkills','0-0;'),
(7914,'Wind Crystal','','false','none',20,'stackable','liquid','none',-1,-1,3000,0,'true','true','true','true','true','ItemSkills','0-0;'),
(7915,'Earth Crystal','','false','none',20,'stackable','liquid','none',-1,-1,3000,0,'true','true','true','true','true','ItemSkills','0-0;'),
(7916,'Dark Shard','','false','none',20,'stackable','liquid','none',-1,-1,3000,0,'true','true','true','true','true','ItemSkills','0-0;'),
(7917,'Sanctity Crystal','','false','none',20,'stackable','liquid','none',-1,-1,3000,0,'true','true','true','true','true','ItemSkills','0-0;'),
(7918,'Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7919,'Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7920,'Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7921,'Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7922,'Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7923,'Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7924,'Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7925,'Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7926,'Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7927,'Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7928,'Mercenary Posting Ticket (Teleporter1)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7929,'Mercenary Posting Ticket (Teleporter2)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7930,'Mercenary Posting Ticket (Teleporter3)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7931,'Greater Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7932,'Greater Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7933,'Greater Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7934,'Greater Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7935,'Greater Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7936,'Greater Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7937,'Greater Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7938,'Greater Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7939,'Greater Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7940,'Greater Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7941,'Dawn Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7942,'Dawn Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7943,'Dawn Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7944,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7945,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7946,'Dawn Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7947,'Dawn Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7948,'Dawn Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7949,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7950,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7951,'Greater Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7952,'Greater Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7953,'Greater Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7954,'Greater Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7955,'Greater Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7956,'Greater Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7957,'Greater Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7958,'Greater Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7959,'Greater Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7960,'Greater Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7961,'Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7962,'Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7963,'Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7964,'Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7965,'Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7966,'Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7967,'Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7968,'Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7969,'Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7970,'Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7971,'Nephilim Warrior Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7972,'Nephilim Shaman Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7973,'Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7974,'Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7975,'Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7976,'Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7977,'Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7978,'Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7979,'Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7980,'Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7981,'Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7982,'Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7983,'Mercenary Posting Ticket (Teleporter1)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7984,'Mercenary Posting Ticket (Teleporter2)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7985,'Mercenary Posting Ticket (Teleporter3)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7986,'Mercenary Posting Ticket (Teleporter4)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7987,'Mercenary Posting Ticket (Teleporter5)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7988,'Greater Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7989,'Greater Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7990,'Greater Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7991,'Greater Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7992,'Greater Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7993,'Greater Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7994,'Greater Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7995,'Greater Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7996,'Greater Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7997,'Greater Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7998,'Dawn Mercenary Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(7999,'Dawn Mercenary Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8000,'Dawn Mercenary Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8001,'Dawn Mercenary Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8002,'Dawn Mercenary Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8003,'Dawn Mercenary Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8004,'Dawn Mercenary Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8005,'Dawn Mercenary Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8006,'Dawn Mercenary Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8007,'Dawn Mercenary Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8008,'Greater Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8009,'Greater Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8010,'Greater Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8011,'Greater Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8012,'Greater Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8013,'Greater Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8014,'Greater Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8015,'Greater Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8016,'Greater Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8017,'Greater Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8018,'Recruit Posting Ticket (Sword/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8019,'Recruit Posting Ticket (Spear/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8020,'Recruit Posting Ticket (Bow/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8021,'Recruit Posting Ticket (Cleric/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8022,'Recruit Posting Ticket (Wizard/Stationary)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8023,'Recruit Posting Ticket (Sword/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8024,'Recruit Posting Ticket (Spear/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8025,'Recruit Posting Ticket (Bow/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8026,'Recruit Posting Ticket (Cleric/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8027,'Recruit Posting Ticket (Wizard/Mobile)','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8028,'Nephilim Warrior Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8029,'Nephilim Shaman Posting Ticket','','false','castle_guard',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','MercTicket','0-0;'),
(8030,'Hot Spring Nectar','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8031,'Hot Spring Mineral Water','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8032,'Hot Spring Water','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8033,'Hot Spring Sulfur','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8034,'Rainbow Springs Clan Hall War Decree','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8035,'Hot Spring Letter A','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8036,'Hot Spring Letter B','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8037,'Hot Spring Letter C','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8038,'Hot Spring Letter D','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8039,'Hot Spring Letter E','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8040,'Hot Spring Letter F','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8041,'Hot Spring Letter G','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8042,'Hot Spring Letter H','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8043,'Hot Spring Letter I','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8044,'Hot Spring Letter J','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8045,'Hot Spring Letter K','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8046,'Hot Spring Letter L','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8047,'Hot Spring Letter N','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8048,'Hot Spring Letter O','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8049,'Hot Spring Letter P','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8050,'Hot Spring Letter R','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8051,'Hot Spring Letter S','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8052,'Hot Spring letter T','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8053,'Hot Spring Letter U','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8054,'Hot Spring Letter W','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8055,'Hot Spring Letter Y','','false','none',0,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8056,'Key of Splendor Room','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','PaganKeys','2238-1;'),
(8057,'Silver Hemocyte','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8058,'Lockup Research Report','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8059,'Research Report','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','Book','0-0;'),
(8060,'Key of Enigma','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2260-1;'),
(8061,'Scribbled Memo','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8062,'Blood of Maille Lizardman','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8063,'Leg of King Araneid','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8064,'Visitor\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8065,'Faded Visitor\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8066,'Necromancer\'s Heart','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8067,'Pagan\'s Mark','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8068,'Pagan Totem','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','false','false','false','none','0-0;'),
(8069,'Monk\'s Scripture','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8070,'Water Bottle','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8071,'Bottle of water from the Holy Grail','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8072,'Antelope Skin','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8073,'Frintezza\'s Magic Force Field Removal Scroll','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8074,'Watching Eyes','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8075,'Roughly Hewn Rock Golem Shard','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8076,'Delu Lizardman\'s Scale','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8077,'Silver Ice Crystal','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8078,'Black Ice Crystal','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8079,'Misa\'s Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8080,'Rafforty\'s Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8081,'Piece of Tablet','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8082,'Report Piece','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8083,'Scout\'s Memo','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8084,'Crystal of Purity','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8085,'Fang of Stakato','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8086,'Box Containing the Fire of Holy Spirit','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8087,'Cursed Doll','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8088,'Orc Grave Goods','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8089,'Cursed Grave Goods','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8090,'Electric Wave Detector','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8091,'Electric Wave Detector','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8092,'Telescope Golem\'s Corpse','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8093,'Golem\'s Dispatcher','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8094,'Storage Medium','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8095,'Storage Medium','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8096,'Ginzu Golem\'s Black Box','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8097,'X-688','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8098,'Supplying Goods for Railroad Worker','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8099,'Thief Guild\'s Mark','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8100,'Destroyed Golem Shards','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','false','none','0-0;'),
(8101,'Dwarf\'s Favor','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8153,'Adventurer\'s Guide Book','','false','none',0,'normal','paper','none',-1,-1,2000,0,'true','true','true','true','true','none','0-0;'),
(8154,'Herb of Life','','false','herb',0,'normal','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2244-1;'),
(8155,'Herb of Mana','','false','herb',0,'normal','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2245-1;'),
(8156,'Herb of Power','','false','herb',0,'normal','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2246-1;'),
(8157,'Herb of Magic','','false','herb',0,'normal','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2247-1;'),
(8158,'Memento Mori: C-Grade','','false','none',0,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(8159,'Memento Mori: B-Grade','','false','none',0,'stackable','paper','none',-1,-1,20000,0,'true','true','true','true','true','none','0-0;'),
(8160,'Memento Mori: A-Grade','','false','none',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','none','0-0;'),
(8161,'Dragon Heart: C-Grade','','false','none',0,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(8162,'Dragon Heart: B-Grade','','false','none',0,'stackable','paper','none',-1,-1,20000,0,'true','true','true','true','true','none','0-0;'),
(8163,'Dragon Heart: A-Grade','','false','none',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','none','0-0;'),
(8164,'Earth Egg: C-Grade','','false','none',0,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(8165,'Earth Egg: B-Grade','','false','none',0,'stackable','paper','none',-1,-1,20000,0,'true','true','true','true','true','none','0-0;'),
(8166,'Earth Egg: A-Grade','','false','none',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','none','0-0;'),
(8167,'Nonliving Nucleus: C-Grade','','false','none',0,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(8168,'Nonliving Nucleus: B-Grade','','false','none',0,'stackable','paper','none',-1,-1,20000,0,'true','true','true','true','true','none','0-0;'),
(8169,'Nonliving Nucleus: A-Grade','','false','none',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','none','0-0;'),
(8170,'Angelic Essence: C-Grade','','false','none',0,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(8171,'Angelic Essence: B-Grade','','false','none',0,'stackable','paper','none',-1,-1,20000,0,'true','true','true','true','true','none','0-0;'),
(8172,'Angelic Essence: A-Grade','','false','none',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','none','0-0;'),
(8173,'Cradle of Creation: C-Grade (Not used)','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8174,'Cradle of Creation: B-Grade (Not used)','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8175,'Cradle of Creation','','false','none',0,'stackable','paper','none',-1,-1,50000,0,'true','true','true','true','true','none','0-0;'),
(8176,'Destruction Tombstone','','false','none',0,'stackable','paper','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(8192,'Soul Breaking Arrow','','false','none',3,'stackable','gold','none',-1,-1,0,0,'true','true','true','true','true','none','2234-1;'),
(8193,'Fisherman\'s Potion - Green','','false','none',100,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2274-1;'),
(8194,'Fisherman\'s Potion - Jade','','false','none',100,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2274-2;'),
(8195,'Fisherman\'s Potion - Blue','','false','none',100,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2274-3;'),
(8196,'Fisherman\'s Potion - Yellow','','false','none',100,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2274-4;'),
(8197,'Fisherman\'s Potion - Orange','','false','none',100,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2274-5;'),
(8198,'Fisherman\'s Potion - Purple','','false','none',100,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2274-6;'),
(8199,'Fisherman\'s Potion - Red','','false','none',100,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2274-7;'),
(8200,'Fisherman\'s Potion - White','','false','none',100,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2274-8;'),
(8201,'Fisherman\'s Potion - Black','','false','none',100,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2274-9;'),
(8202,'Fishing Potion','','false','seed',100,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','ItemSkills','2275-1;'),
(8223,'Seed: Twin Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(8224,'Seed: Great Codran','','false','seed',1,'stackable','paper','none',-1,-1,75,0,'true','true','true','true','true','Seed','2097-3;'),
(8225,'Seed: Desert Codran','','false','seed',1,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','Seed','2097-3;'),
(8226,'Seed: Blue Coba','','false','seed',1,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','Seed','2097-3;'),
(8227,'Seed: Red Coba','','false','seed',1,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','Seed','2097-3;'),
(8228,'Seed: Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(8229,'Seed: Desert Coba','','false','seed',1,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','Seed','2097-3;'),
(8230,'Seed: Alternative Twin Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(8231,'Seed: Alternative Great Codran','','false','seed',1,'stackable','paper','none',-1,-1,75,0,'true','true','true','true','true','Seed','2097-3;'),
(8232,'Seed: Alternative Desert Codran','','false','seed',1,'stackable','paper','none',-1,-1,100,0,'true','true','true','true','true','Seed','2097-3;'),
(8233,'Seed: Alternative Blue Coba','','false','seed',1,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','Seed','2097-3;'),
(8234,'Seed: Alternative Red Coba','','false','seed',1,'stackable','paper','none',-1,-1,500,0,'true','true','true','true','true','Seed','2097-3;'),
(8235,'Seed: Alternative Golden Coba','','false','seed',1,'stackable','paper','none',-1,-1,650,0,'true','true','true','true','true','Seed','2097-3;'),
(8236,'Seed: Alternative Desert Coba','','false','seed',1,'stackable','paper','none',-1,-1,750,0,'true','true','true','true','true','Seed','2097-3;'),
(8237,'Seed: Dark Coda','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(8238,'Seed: Red Coda','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(8239,'Seed: Chilly Coda','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(8240,'Seed: Blue Coda','','false','seed',1,'stackable','paper','none',-1,-1,10,0,'true','true','true','true','true','Seed','2097-1;'),
(8241,'Seed: Golden Coda','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(8242,'Seed: Lute Coda','','false','seed',1,'stackable','paper','none',-1,-1,30,0,'true','true','true','true','true','Seed','2097-1;'),
(8243,'Seed: Desert Coda','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(8244,'Seed: Red Cobol','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-2;'),
(8245,'Seed: Chilly Cobol','','false','seed',1,'stackable','paper','none',-1,-1,25,0,'true','true','true','true','true','Seed','2097-2;'),
(8246,'Seed: Blue Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(8247,'Seed: Thorn Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(8248,'Seed: Golden Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(8249,'Seed: Great Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(8250,'Seed: Red Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(8251,'Seed: Sea Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(8252,'Seed: Chilly Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(8253,'Seed: Blue Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(8254,'Seed: Twin Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(8255,'Alternative Dark Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(8256,'Alternative Red Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(8257,'Seed: Alternative Chilly Coda','','false','seed',1,'stackable','paper','none',-1,-1,5,0,'true','true','true','true','true','Seed','2097-1;'),
(8258,'Alternative Blue Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,10,0,'true','true','true','true','true','Seed','2097-1;'),
(8259,'Seed: Alternative Golden Coda','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(8260,'Alternative Lute Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,30,0,'true','true','true','true','true','Seed','2097-1;'),
(8261,'Alternative Desert Coda Seed','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-1;'),
(8262,'Seed: Alternative Red Cobol','','false','seed',1,'stackable','paper','none',-1,-1,20,0,'true','true','true','true','true','Seed','2097-2;'),
(8263,'Seed: Alternative Chilly Cobol','','false','seed',1,'stackable','paper','none',-1,-1,25,0,'true','true','true','true','true','Seed','2097-2;'),
(8264,'Seed: Alternative Blue Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(8265,'Alternative Thorn Cobol Seed','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(8266,'Seed: Alternative Golden Cobol','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-2;'),
(8267,'Seed: Alternative Great Cobol','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-2;'),
(8268,'Seed: Alternative Red Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(8269,'Seed: Alternative Sea Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(8270,'Seed: Alternative Chilly Codran','','false','seed',1,'stackable','paper','none',-1,-1,40,0,'true','true','true','true','true','Seed','2097-3;'),
(8271,'Seed: Alternative Blue Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(8272,'Seed: Alternative Twin Codran','','false','seed',1,'stackable','paper','none',-1,-1,50,0,'true','true','true','true','true','Seed','2097-3;'),
(8273,'Anteroom Key','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2235-1;'),
(8274,'Chapel Key','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2236-1;'),
(8275,'Key of Darkness','','false','none',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2237-1;'),
(8276,'Sekina\'s Scale','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8277,'Themis\' Scale','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8278,'Vermilion Shard','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8279,'Nucleus of Hekaton Prime','','false','none',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8280,'Tiphon Shard','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8281,'Glaki\'s Necleus','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8282,'Rahha\'s Fang','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8283,'Sting of Giant Poison Bee','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8284,'Cloudy Gem','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8285,'Talon of Young Araneid','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8286,'Fairy Breath','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8287,'Starstone','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8288,'Yumi\'s Letter','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8289,'Starstone','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8290,'Flower of Pavel','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8291,'Heart of Atlanta','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8292,'Wendy\'s Necklace','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8293,'Trainer License','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8294,'Recipe: Steel Sword (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,8180,0,'true','true','true','true','true','Recipes','0-0;'),
(8295,'Recipe: Titan Sword (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(8296,'Recipe: Pa\'agrian Sword (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,86000,0,'true','true','true','true','true','Recipes','0-0;'),
(8297,'Recipe: Guardian\'s Sword (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(8298,'Recipe: Guardian\'s Sword (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(8299,'Recipe: Infernal Master (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(8300,'Recipe: Infernal Master (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(8301,'Recipe: Priest Sword (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(8302,'Recipe: Sword of Magic Fog (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(8303,'Recipe: Mysterious Sword (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(8304,'Recipe: Ecliptic Sword (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(8305,'Recipe: Wizard\'s Tear (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(8306,'Recipe: Wizard\'s Tear (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(8307,'Recipe: Priest Mace (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(8308,'Recipe: Ecliptic Axe (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(8309,'Recipe: Spell Breaker (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(8310,'Recipe: Spell Breaker (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(8311,'Recipe: Kaim Vanul\'s Bones (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(8312,'Recipe: Kaim Vanul\'s Bones (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,262000,0,'true','true','true','true','true','Recipes','0-0;'),
(8313,'Recipe: Spiritual Eye (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(8314,'Recipe: Spiritual Eye (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(8315,'Recipe: Flaming Dragon Skull (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,540000,0,'true','true','true','true','true','Recipes','0-0;'),
(8316,'Recipe: Flaming Dragon Skull (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,540000,0,'true','true','true','true','true','Recipes','0-0;'),
(8317,'Recipe: Titan Hammer (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,28000,0,'true','true','true','true','true','Recipes','0-0;'),
(8318,'Recipe: Dwarven Hammer (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,122600,0,'true','true','true','true','true','Recipes','0-0;'),
(8319,'Recipe: Karik Horn (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(8320,'Recipe: Destroyer Hammer (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(8321,'Recipe: Ice Storm Hammer (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(8322,'Recipe: Ice Storm Hammer (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,173600,0,'true','true','true','true','true','Recipes','0-0;'),
(8323,'Recipe: Star Buster (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(8324,'Recipe: Star Buster (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(8325,'Recipe: Doom Crusher (100%)','','false','recipe',30,'stackable','liquid','none',-1,-1,540000,0,'true','true','true','true','true','Recipes','0-0;'),
(8326,'Recipe: Doom Crusher (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,540000,0,'true','true','true','true','true','Recipes','0-0;'),
(8327,'Steel Sword Blade','','false','material',60,'stackable','liquid','none',-1,-1,11912,0,'true','true','true','true','true','none','0-0;'),
(8328,'Titan Sword Blade','','false','material',60,'stackable','liquid','none',-1,-1,20950,0,'true','true','true','true','true','none','0-0;'),
(8329,'Pa\'agrian Sword Blade','','false','material',60,'stackable','liquid','none',-1,-1,38420,0,'true','true','true','true','true','none','0-0;'),
(8330,'Guardian Sword Blade','','false','material',60,'stackable','liquid','none',-1,-1,45769,0,'true','true','true','true','true','none','0-0;'),
(8331,'Infernal Master Blade','','false','material',60,'stackable','liquid','none',-1,-1,58615,0,'true','true','true','true','true','none','0-0;'),
(8332,'Priest Sword Blade','','false','material',60,'stackable','liquid','none',-1,-1,12037,0,'true','true','true','true','true','none','0-0;'),
(8333,'Sword of Magic Fog Blade','','false','material',60,'stackable','liquid','none',-1,-1,20300,0,'true','true','true','true','true','none','0-0;'),
(8334,'Mysterious Sword Blade','','false','material',60,'stackable','liquid','none',-1,-1,25187,0,'true','true','true','true','true','none','0-0;'),
(8335,'Ecliptic Sword Blade','','false','material',60,'stackable','liquid','none',-1,-1,43890,0,'true','true','true','true','true','none','0-0;'),
(8336,'Blade of the Wizard\'s Tear','','false','material',60,'stackable','liquid','none',-1,-1,45692,0,'true','true','true','true','true','none','0-0;'),
(8337,'Priest Mace Head','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8338,'Axe of Eclipse Head','','false','material',60,'stackable','liquid','none',-1,-1,41636,0,'true','true','true','true','true','none','0-0;'),
(8339,'Spell Breaker Head','','false','material',60,'stackable','liquid','none',-1,-1,34950,0,'true','true','true','true','true','none','0-0;'),
(8340,'Bones Head of Kaim Vanul','','false','material',60,'stackable','liquid','none',-1,-1,45769,0,'true','true','true','true','true','none','0-0;'),
(8341,'Spiritual Eye Piece','','false','material',60,'stackable','liquid','none',-1,-1,59384,0,'true','true','true','true','true','none','0-0;'),
(8342,'Flaming Dragon Skull Piece','','false','material',60,'stackable','liquid','none',-1,-1,72914,0,'true','true','true','true','true','none','0-0;'),
(8343,'Titan Hammer Piece','','false','material',60,'stackable','liquid','none',-1,-1,19757,0,'true','true','true','true','true','none','0-0;'),
(8344,'Dwarven Hammer Piece','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8345,'Karik Horn Piece','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8346,'Hammer Piece of Destroyer','','false','material',60,'stackable','liquid','none',-1,-1,59308,0,'true','true','true','true','true','none','0-0;'),
(8347,'Ice Storm Hammer Head','','false','material',60,'stackable','liquid','none',-1,-1,38867,0,'true','true','true','true','true','none','0-0;'),
(8348,'Star Buster Head','','false','material',60,'stackable','liquid','none',-1,-1,45846,0,'true','true','true','true','true','none','0-0;'),
(8349,'Doom Crusher Head','','false','material',60,'stackable','liquid','none',-1,-1,72929,0,'true','true','true','true','true','none','0-0;'),
(8351,'Black Colored Fish Scale','','false','material',10,'stackable','liquid','none',-1,-1,900,0,'true','true','true','true','true','none','0-0;'),
(8352,'Red Colored Fish Scale','','false','material',10,'stackable','liquid','none',-1,-1,700,0,'true','true','true','true','true','none','0-0;'),
(8353,'Green Colored Fish Scale','','false','material',10,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(8354,'Yellow Colored Fish Scale','','false','material',10,'stackable','liquid','none',-1,-1,400,0,'true','true','true','true','true','none','0-0;'),
(8355,'Blue Colored Fish Scale','','false','material',10,'stackable','liquid','none',-1,-1,300,0,'true','true','true','true','true','none','0-0;'),
(8356,'White Colored Fish Scale','','false','material',10,'stackable','liquid','none',-1,-1,800,0,'true','true','true','true','true','none','0-0;'),
(8357,'Orange Colored Fish Scale','','false','material',10,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(8358,'Purple Colored Fish Scale','','false','material',10,'stackable','liquid','none',-1,-1,600,0,'true','true','true','true','true','none','0-0;'),
(8359,'Jade Colored Fish Scale','','false','material',10,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(8360,'Adventurer\'s Box - C Accessory','','false','none',20,'stackable','steel','none',-1,-1,200000,0,'true','true','true','true','true','none','0-0;'),
(8361,'Adventurer\'s Box - B Accessory','','false','none',20,'stackable','steel','none',-1,-1,500000,0,'true','true','true','true','true','none','0-0;'),
(8362,'Adventurer\'s Box - Hair Accessory','','false','none',20,'stackable','steel','none',-1,-1,100000,0,'true','true','true','true','true','none','0-0;'),
(8363,'Adventurer\'s Box - Cradle of Creation','','false','recipe',20,'stackable','steel','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(8364,'Recipe: Party Hat (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,400000,0,'true','true','true','true','true','Recipes','0-0;'),
(8365,'Recipe: Party Hat (70%)','','false','recipe',30,'stackable','paper','none',-1,-1,400000,0,'true','true','true','true','true','Recipes','0-0;'),
(8366,'Recipe: Feathered Hat (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,400000,0,'true','true','true','true','true','Recipes','0-0;'),
(8367,'Recipe: Feathered Hat (70%)','','false','recipe',30,'stackable','paper','none',-1,-1,400000,0,'true','true','true','true','true','Recipes','0-0;'),
(8368,'Recipe: Artisan\'s Goggles (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,400000,0,'true','true','true','true','true','Recipes','0-0;'),
(8369,'Recipe: Artisan\'s Goggles (70%)','','false','recipe',30,'stackable','paper','none',-1,-1,400000,0,'true','true','true','true','true','Recipes','0-0;'),
(8370,'Recipe: Red Horn of Victory (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','Recipes','0-0;'),
(8371,'Recipe: Little Angel Wings (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(8372,'Recipe: Fairy Antennae (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,100000,0,'true','true','true','true','true','Recipes','0-0;'),
(8373,'Party Hat Fabric','','false','material',60,'stackable','liquid','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(8374,'Feathered Hat Fabric','','false','material',60,'stackable','liquid','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(8375,'Artisan\'s Goggles Fabric','','false','material',60,'stackable','liquid','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(8376,'Red Horn of Victory Fragment','','false','material',60,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8377,'Little Angel Wings Piece','','false','material',60,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(8378,'Fairy Antennae Piece','','false','material',60,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(8379,'Petrification Scroll','','false','scroll',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','2239-1;'),
(8380,'Spellbook: Betray','','false','spellbook',120,'stackable','paper','none',-1,-1,6250,0,'true','true','true','true','true','none','0-0;'),
(8381,'Spellbook: Mass Curse Fear','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8382,'Spellbook: Mass Curse Gloom','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8383,'Spellbook: Mass Surrender to Fire','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8384,'Spellbook: Mass Surrender to Water','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8385,'Spellbook: Mass Surrender to Wind','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8386,'Spellbook - Arcane Disruption','','false','spellbook',120,'stackable','paper','none',-1,-1,6250,0,'true','true','true','true','true','none','0-0;'),
(8387,'Spellbook - Summon Cursed Bones','','false','spellbook',120,'stackable','paper','none',-1,-1,7200,0,'true','true','true','true','true','none','0-0;'),
(8388,'Spellbook: Greater Might','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8389,'Spellbook: Greater Shield','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8390,'Amulet: War Chant','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8391,'Amulet: Earth Chant','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8392,'Spellbook: Holy Resistance','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8393,'Spellbook: Unholy Resistance','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8394,'Spellbook: Trance','','false','spellbook',120,'stackable','paper','none',-1,-1,6250,0,'true','true','true','true','true','none','0-0;'),
(8395,'Spellbook: Erase','','false','spellbook',120,'stackable','paper','none',-1,-1,6250,0,'true','true','true','true','true','none','0-0;'),
(8396,'Spellbook: Magical Backfire','','false','spellbook',120,'stackable','paper','none',-1,-1,6250,0,'true','true','true','true','true','none','0-0;'),
(8397,'Spellbook: Clarity','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8398,'Spellbook: Mana Burn','','false','spellbook',120,'stackable','paper','none',-1,-1,6250,0,'true','true','true','true','true','none','0-0;'),
(8399,'Spellbook: Mana Storm','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8400,'Spellbook: Turn Undead','','false','spellbook',120,'stackable','paper','none',-1,-1,6250,0,'true','true','true','true','true','none','0-0;'),
(8401,'Spellbook: Major Heal','','false','spellbook',120,'stackable','paper','none',-1,-1,6250,0,'true','true','true','true','true','none','0-0;'),
(8402,'Spellbook: Major Group Heal','','false','spellbook',120,'stackable','paper','none',-1,-1,6750,0,'true','true','true','true','true','none','0-0;'),
(8403,'Small Nimble Green Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,138,0,'true','true','true','true','true','ItemSkills','2261-1;'),
(8404,'Small Ugly Green Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,141,0,'true','true','true','true','true','ItemSkills','2261-2;'),
(8405,'Small Pudgy Green Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,153,0,'true','true','true','true','true','ItemSkills','2261-3;'),
(8406,'Nimble Green Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,167,0,'true','true','true','true','true','ItemSkills','2261-4;'),
(8407,'Ugly Green Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,187,0,'true','true','true','true','true','ItemSkills','2261-5;'),
(8408,'Pudgy Green Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,208,0,'true','true','true','true','true','ItemSkills','2261-6;'),
(8409,'Large Nimble Green Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,225,0,'true','true','true','true','true','ItemSkills','2261-7;'),
(8410,'Large Ugly Green Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,248,0,'true','true','true','true','true','ItemSkills','2261-8;'),
(8411,'Large Pudgy Green Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,265,0,'true','true','true','true','true','ItemSkills','2261-9;'),
(8412,'Small Jade Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,285,0,'true','true','true','true','true','ItemSkills','2262-1;'),
(8413,'Small Jade Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,295,0,'true','true','true','true','true','ItemSkills','2262-2;'),
(8414,'Small Jade Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,310,0,'true','true','true','true','true','ItemSkills','2262-3;'),
(8415,'Jade Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,325,0,'true','true','true','true','true','ItemSkills','2262-4;'),
(8416,'Jade Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,340,0,'true','true','true','true','true','ItemSkills','2262-5;'),
(8417,'Jade Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,355,0,'true','true','true','true','true','ItemSkills','2262-6;'),
(8418,'Large Jade Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,365,0,'true','true','true','true','true','ItemSkills','2262-7;'),
(8419,'Large Jade Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,375,0,'true','true','true','true','true','ItemSkills','2262-8;'),
(8420,'Large Jade Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,385,0,'true','true','true','true','true','ItemSkills','2262-9;'),
(8421,'Small Blue Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,395,0,'true','true','true','true','true','ItemSkills','2263-1;'),
(8422,'Small Blue Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,400,0,'true','true','true','true','true','ItemSkills','2263-2;'),
(8423,'Small Blue Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,410,0,'true','true','true','true','true','ItemSkills','2263-3;'),
(8424,'Blue Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,415,0,'true','true','true','true','true','ItemSkills','2263-4;'),
(8425,'Blue Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,418,0,'true','true','true','true','true','ItemSkills','2263-5;'),
(8426,'Blue Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,420,0,'true','true','true','true','true','ItemSkills','2263-6;'),
(8427,'Large Blue Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,425,0,'true','true','true','true','true','ItemSkills','2263-7;'),
(8428,'Large Blue Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,431,0,'true','true','true','true','true','ItemSkills','2263-8;'),
(8429,'Large Blue Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,435,0,'true','true','true','true','true','ItemSkills','2263-9;'),
(8430,'Small Yellow Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,442,0,'true','true','true','true','true','ItemSkills','2264-1;'),
(8431,'Small Yellow Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,447,0,'true','true','true','true','true','ItemSkills','2264-2;'),
(8432,'Small Yellow Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,452,0,'true','true','true','true','true','ItemSkills','2264-3;'),
(8433,'Yellow Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,540,0,'true','true','true','true','true','ItemSkills','2264-4;'),
(8434,'Yellow Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,553,0,'true','true','true','true','true','ItemSkills','2264-5;'),
(8435,'Yellow Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,568,0,'true','true','true','true','true','ItemSkills','2264-6;'),
(8436,'Large Yellow Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,580,0,'true','true','true','true','true','ItemSkills','2264-7;'),
(8437,'Large Yellow Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,594,0,'true','true','true','true','true','ItemSkills','2264-8;'),
(8438,'Large Yellow Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,608,0,'true','true','true','true','true','ItemSkills','2264-9;'),
(8439,'Small Orange Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,622,0,'true','true','true','true','true','ItemSkills','2265-1;'),
(8440,'Small Orange Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,635,0,'true','true','true','true','true','ItemSkills','2265-2;'),
(8441,'Small Orange Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,649,0,'true','true','true','true','true','ItemSkills','2265-3;'),
(8442,'Orange Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,663,0,'true','true','true','true','true','ItemSkills','2265-4;'),
(8443,'Orange Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,776,0,'true','true','true','true','true','ItemSkills','2265-5;'),
(8444,'Orange Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,792,0,'true','true','true','true','true','ItemSkills','2265-6;'),
(8445,'Large Orange Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,816,0,'true','true','true','true','true','ItemSkills','2265-7;'),
(8446,'Large Orange Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,840,0,'true','true','true','true','true','ItemSkills','2265-8;'),
(8447,'Large Orange Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,858,0,'true','true','true','true','true','ItemSkills','2265-9;'),
(8448,'Small Purple Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,875,0,'true','true','true','true','true','ItemSkills','2266-1;'),
(8449,'Small Purple Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,893,0,'true','true','true','true','true','ItemSkills','2266-2;'),
(8450,'Small Purple Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,910,0,'true','true','true','true','true','ItemSkills','2266-3;'),
(8451,'Purple Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,930,0,'true','true','true','true','true','ItemSkills','2266-4;'),
(8452,'Purple Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,948,0,'true','true','true','true','true','ItemSkills','2266-5;'),
(8453,'Purple Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1090,0,'true','true','true','true','true','ItemSkills','2266-6;'),
(8454,'Large Purple Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1111,0,'true','true','true','true','true','ItemSkills','2266-7;'),
(8455,'Large Purple Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1133,0,'true','true','true','true','true','ItemSkills','2266-8;'),
(8456,'Large Purple Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1157,0,'true','true','true','true','true','ItemSkills','2266-9;'),
(8457,'Small Red Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1277,0,'true','true','true','true','true','ItemSkills','2267-1;'),
(8458,'Small Red Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1301,0,'true','true','true','true','true','ItemSkills','2267-2;'),
(8459,'Small Red Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1326,0,'true','true','true','true','true','ItemSkills','2267-3;'),
(8460,'Red Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1351,0,'true','true','true','true','true','ItemSkills','2267-4;'),
(8461,'Red Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1376,0,'true','true','true','true','true','ItemSkills','2267-5;'),
(8462,'Red Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1402,0,'true','true','true','true','true','ItemSkills','2267-6;'),
(8463,'Large Red Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1577,0,'true','true','true','true','true','ItemSkills','2267-7;'),
(8464,'Large Red Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1608,0,'true','true','true','true','true','ItemSkills','2267-8;'),
(8465,'Large Red Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1715,0,'true','true','true','true','true','ItemSkills','2267-9;'),
(8466,'Small White Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1747,0,'true','true','true','true','true','ItemSkills','2268-1;'),
(8467,'Small White Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1781,0,'true','true','true','true','true','ItemSkills','2268-2;'),
(8468,'Small White Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1814,0,'true','true','true','true','true','ItemSkills','2268-3;'),
(8469,'White Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1849,0,'true','true','true','true','true','ItemSkills','2268-4;'),
(8470,'White Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1887,0,'true','true','true','true','true','ItemSkills','2268-5;'),
(8471,'White Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,1923,0,'true','true','true','true','true','ItemSkills','2268-6;'),
(8472,'High Grade - Large White Nimble Fish','','false','none',100,'stackable','paper','none',-1,-1,1961,0,'true','true','true','true','true','ItemSkills','2268-7;'),
(8473,'Large White Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,2000,0,'true','true','true','true','true','ItemSkills','2268-8;'),
(8474,'Large White Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,2039,0,'true','true','true','true','true','ItemSkills','2268-9;'),
(8475,'Small Black Nimble Fish: Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,2081,0,'true','true','true','true','true','ItemSkills','2269-1;'),
(8476,'Small Black Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,2123,0,'true','true','true','true','true','ItemSkills','2269-2;'),
(8477,'Small Black Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,2166,0,'true','true','true','true','true','ItemSkills','2269-3;'),
(8478,'Black Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,2309,0,'true','true','true','true','true','ItemSkills','2269-4;'),
(8479,'Black Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,2357,0,'true','true','true','true','true','ItemSkills','2269-5;'),
(8480,'Black Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,2403,0,'true','true','true','true','true','ItemSkills','2269-6;'),
(8481,'Large Black Nimble Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,2452,0,'true','true','true','true','true','ItemSkills','2269-7;'),
(8482,'Large Black Ugly Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,2502,0,'true','true','true','true','true','ItemSkills','2269-8;'),
(8483,'Large Black Fat Fish - Upper Grade','','false','none',100,'stackable','paper','none',-1,-1,2552,0,'true','true','true','true','true','ItemSkills','2269-9;'),
(8484,'Prize-Winning Fishing Lure','','false','lure',4,'stackable','liquid','none',-1,-1,240,0,'true','true','true','true','true','none','0-0;'),
(8485,'Prize-Winning Night Fishing Lure','','false','lure',4,'stackable','liquid','none',-1,-1,240,0,'true','true','true','true','true','none','0-0;'),
(8486,'Prize-Winning Novice Fishing Lure','','false','lure',5,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(8487,'Recipe: Destroyer Hammer (60%)','','false','recipe',30,'stackable','liquid','none',-1,-1,366000,0,'true','true','true','true','true','Recipes','0-0;'),
(8488,'Engraved Hammer','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8489,'Daimon\'s Eyes','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8490,'Hestia\'s Fairy Stone','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8491,'Nucleus of Lesser Golem','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8492,'Falston\'s Fang','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8493,'Shaid\'s Talon','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8494,'Nucleus of Flamestone Giant','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8495,'Book of Grey Star','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8496,'Gludio\'s Luminous Lure','','false','lure',5,'stackable','liquid','none',-1,-1,120,0,'true','true','true','true','true','none','0-0;'),
(8497,'Dion\'s Luminous Lure','','false','lure',4,'stackable','liquid','none',-1,-1,120,0,'true','true','true','true','true','none','0-0;'),
(8498,'Giran\'s Luminous Lure','','false','lure',3,'stackable','liquid','none',-1,-1,120,0,'true','true','true','true','true','none','0-0;'),
(8499,'Oren\'s Luminous Lure','','false','lure',5,'stackable','liquid','none',-1,-1,120,0,'true','true','true','true','true','none','0-0;'),
(8500,'Aden\'s Luminous Lure','','false','lure',4,'stackable','liquid','none',-1,-1,120,0,'true','true','true','true','true','none','0-0;'),
(8501,'Innadril\'s Luminous Lure','','false','lure',3,'stackable','liquid','none',-1,-1,120,0,'true','true','true','true','true','none','0-0;'),
(8502,'Goddard\'s Luminous Lure','','false','lure',5,'stackable','liquid','none',-1,-1,120,0,'true','true','true','true','true','none','0-0;'),
(8503,'Rune\'s Luminous Lure','','false','lure',4,'stackable','liquid','none',-1,-1,120,0,'true','true','true','true','true','none','0-0;'),
(8504,'Schuttgart\'s Luminous Lure','','false','lure',3,'stackable','liquid','none',-1,-1,120,0,'true','true','true','true','true','none','0-0;'),
(8505,'Green Luminous Lure - Low Grade','','false','lure',5,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(8506,'Green Luminous Lure','','false','lure',4,'stackable','liquid','none',-1,-1,120,0,'true','true','true','true','true','none','0-0;'),
(8507,'Green Colored Lure - High Grade','','false','lure',3,'stackable','liquid','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(8508,'Purple Luminous Lure - Low Grade','','false','lure',5,'stackable','liquid','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(8509,'Purple Luminous Lure','','false','lure',4,'stackable','liquid','none',-1,-1,180,0,'true','true','true','true','true','none','0-0;'),
(8510,'Purple Luminous Lure - High Grade','','false','lure',3,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(8511,'Yellow Luminous Lure - Low Grade','','false','lure',5,'stackable','liquid','none',-1,-1,120,0,'true','true','true','true','true','none','0-0;'),
(8512,'Yellow Luminous Lure','','false','lure',4,'stackable','liquid','none',-1,-1,150,0,'true','true','true','true','true','none','0-0;'),
(8513,'Yellow Luminous Lure - High Grade','','false','lure',3,'stackable','liquid','none',-1,-1,180,0,'true','true','true','true','true','none','0-0;'),
(8514,'Remnants of Old Dwarves\' Dreams','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8515,'Charm of Courage: No Grade','','false','scroll',10,'stackable','paper','none',-1,-1,2000,0,'true','true','true','true','true','ItemSkills','5041-1;'),
(8516,'Charm of Courage: D-Grade','','false','scroll',10,'stackable','paper','d',-1,-1,6600,0,'true','true','true','true','true','ItemSkills','5041-1;'),
(8517,'Charm of Courage: C-Grade','','false','scroll',10,'stackable','paper','c',-1,-1,13200,0,'true','true','true','true','true','ItemSkills','5041-1;'),
(8518,'Charm of Courage: B-Grade','','false','scroll',10,'stackable','paper','b',-1,-1,26000,0,'true','true','true','true','true','ItemSkills','5041-1;'),
(8519,'Charm of Courage: A-Grade','','false','scroll',10,'stackable','paper','a',-1,-1,54000,0,'true','true','true','true','true','ItemSkills','5041-1;'),
(8520,'Charm of Courage: S-Grade','','false','scroll',10,'stackable','paper','s',-1,-1,100000,0,'true','true','true','true','true','ItemSkills','5041-1;'),
(8521,'Seed: Sea Coba','','false','seed',1,'stackable','paper','none',-1,-1,900,0,'true','true','true','true','true','Seed','2097-3;'),
(8522,'Seed: Alternative Sea Coba','','false','seed',1,'stackable','paper','none',-1,-1,900,0,'true','true','true','true','true','Seed','2097-3;'),
(8523,'Seed: Twin Coba','','false','seed',1,'stackable','paper','none',-1,-1,1000,0,'true','true','true','true','true','Seed','2097-3;'),
(8524,'Seed: Alternative Twin Coba','','false','seed',1,'stackable','paper','none',-1,-1,1000,0,'true','true','true','true','true','Seed','2097-3;'),
(8525,'Seed: Great Coba','','false','seed',1,'stackable','paper','none',-1,-1,1200,0,'true','true','true','true','true','Seed','2097-3;'),
(8526,'Seed: Alternative Great Coba','','false','seed',1,'stackable','paper','none',-1,-1,1200,0,'true','true','true','true','true','Seed','2097-3;'),
(8534,'Adventurer\'s Box: C-Grade Accessory (Low Grade)','','false','none',20,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2270-1;'),
(8535,'Adventurer\'s Box: C-Grade Accessory (Medium Grade)','','false','none',20,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2270-2;'),
(8536,'Adventurer\'s Box: C-Grade Accessory (High Grade)','','false','none',20,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2270-3;'),
(8537,'Adventurer\'s Box: B-Grade Accessory (Low Grade)','','false','none',20,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2270-4;'),
(8538,'Adventurer\'s Box: B-Grade Accessory (High Grade)','','false','none',20,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2270-5;'),
(8539,'Adventurer\'s Box: Hair Accessory','','false','none',20,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2270-6;'),
(8540,'Adventurer\'s Box: Cradle of Creation','','false','none',20,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2270-7;'),
(8542,'Newbie Travel Token','','false','none',10,'stackable','liquid','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(8543,'Bead Parcel','','false','quest',0,'stackable','steel','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8544,'Timora Orc\'s Head','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8545,'Kasha Spider\'s Tooth','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8546,'Horn of Baar Dre Vanul','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8547,'Old Box','','false','quest',100,'stackable','paper','none',-1,-1,1500,0,'true','true','true','true','true','none','0-0;'),
(8548,'Hot Springs Lure','','false','lure',3,'stackable','liquid','none',-1,-1,200,0,'true','true','true','true','true','none','0-0;'),
(8549,'Bruin Lizardman Blood','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8550,'Picot Araneid\'s Leg','','false','quest',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8551,'Box of Cheerleading Gear Used to encourage victory.','','false','material',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8553,'Red Mask of Victory,Fabric','','false','material',60,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8554,'Recipe: Red Mask of Victory (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8555,'Echo Crystal - Viva Victory Korea','','false','none',10,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2272-1;'),
(8556,'Dewdrop of Destruction','','false','none',3,'stackable','gold','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8570,'Event Gift Box','','false','none',20,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(8571,'Event Gift Box','','false','none',20,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(8572,'Event Gift Box','','false','none',20,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(8573,'Event Gift Box','','false','none',20,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(8574,'Event Gift Box','','false','none',20,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(8575,'Event Gift Box','','false','none',20,'stackable','steel','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(8592,'Weapon Exchange Coupon - No Grade','','false','none',1,'normal','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8593,'Weapon Exchange Coupon - D Grade','','false','scroll',1,'normal','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8594,'Scroll: Recovery (No Grade)','','false','scroll',10,'stackable','paper','none',-1,-1,2000,0,'true','true','true','true','true','ItemSkills','2286-1;'),
(8595,'Scroll: Recovery (Grade D)','','false','scroll',10,'stackable','paper','d',-1,-1,4800,0,'true','true','true','true','true','ItemSkills','2286-2;'),
(8596,'Scroll: Recovery (Grade C)','','false','scroll',10,'stackable','paper','c',-1,-1,14000,0,'true','true','true','true','true','ItemSkills','2286-3;'),
(8597,'Scroll: Recovery (Grade B)','','false','scroll',10,'stackable','paper','b',-1,-1,28000,0,'true','true','true','true','true','ItemSkills','2286-4;'),
(8598,'Scroll: Recovery (Grade A)','','false','scroll',10,'stackable','paper','a',-1,-1,48000,0,'true','true','true','true','true','ItemSkills','2286-5;'),
(8599,'Scroll: Recovery (Grade S)','','false','scroll',10,'stackable','paper','s',-1,-1,80000,0,'true','true','true','true','true','ItemSkills','2286-6;'),
(8600,'Herb of Life','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2278-1;'),
(8601,'Greater Herb of Life','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2278-2;'),
(8602,'Superior Herb of Life','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2278-3;'),
(8603,'Herb of Mana','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2279-1;'),
(8604,'Greater Herb of Mana','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2279-2;'),
(8605,'Superior Herb of Mana','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2279-3;'),
(8606,'Herb of Power','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2280-1;'),
(8607,'Herb of Magic','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2281-1;'),
(8608,'Herb of Atk. Spd.','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2282-1;'),
(8609,'Herb of Casting Spd.','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2283-1;'),
(8610,'Herb of Critical Attack - Probability','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2284-1;'),
(8611,'Herb of Speed','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2285-1;'),
(8612,'Herb of the Warrior','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2280-1;2282-1;2284-1;'),
(8613,'Herb of the Mystic','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2281-1;2283-1;'),
(8614,'Herb of Recovery','','false','herb',0,'normal','paper','none',-1,-1,0,0,'false','true','true','true','false','ItemSkills','2278-3;2279-3;'),
(8615,'Summoning Crystal','','false','material',10,'stackable','crystal','none',-1,-1,35000,0,'true','true','true','true','true','none','0-0;'),
(8616,'Spellbook: Summon Friend','','false','spellbook',120,'stackable','paper','none',-1,-1,6250,0,'true','true','true','true','true','none','0-0;'),
(8617,'Spellbook: Word of Invitation','','false','spellbook',120,'stackable','paper','none',-1,-1,8700,0,'true','true','true','true','true','none','0-0;'),
(8618,'Ancient Book - Divine Inspiration (Modern Language Version)','','false','none',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8619,'Ancient Book - Divine Inspiration (Original Language Version)','','false','none',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8620,'Ancient Book - Divine Inspiration (Manuscript)','','false','none',120,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8621,'Ancient Book - Divine Inspiration (Original Version)','','false','none',120,'stackable','paper','none',-1,-1,0,0,'false','false','true','false','true','none','0-0;'),
(8622,'Elixir of Life (No Grade)','','false','potion',5,'stackable','liquid','none',-1,-1,1300,0,'true','true','true','true','true','Elixir','2287-1;'),
(8623,'Elixir of Life (D-Grade)','','false','potion',5,'stackable','liquid','d',-1,-1,3450,0,'true','true','true','true','true','Elixir','2287-2;'),
(8624,'Elixir of Life (C-Grade)','','false','potion',5,'stackable','liquid','c',-1,-1,7200,0,'true','true','true','true','true','Elixir','2287-3;'),
(8625,'Elixir of Life (B-Grade)','','false','potion',5,'stackable','liquid','b',-1,-1,10000,0,'true','true','true','true','true','Elixir','2287-4;'),
(8626,'Elixir of Life (A-Grade)','','false','potion',5,'stackable','liquid','a',-1,-1,12500,0,'true','true','true','true','true','Elixir','2287-5;'),
(8627,'Elixir of Life (S-Grade)','','false','potion',5,'stackable','liquid','s',-1,-1,15000,0,'true','true','true','true','true','Elixir','2287-6;'),
(8628,'Elixir of Mental Strength (No Grade)','','false','potion',5,'stackable','liquid','none',-1,-1,1200,0,'true','true','true','true','true','Elixir','2288-1;'),
(8629,'Elixir of Mental Strength (D-Grade)','','false','potion',5,'stackable','liquid','d',-1,-1,3400,0,'true','true','true','true','true','Elixir','2288-2;'),
(8630,'Elixir of Mental Strength (C-Grade)','','false','potion',5,'stackable','liquid','c',-1,-1,8700,0,'true','true','true','true','true','Elixir','2288-3;'),
(8631,'Elixir of Mental Strength (B-Grade)','','false','potion',5,'stackable','liquid','b',-1,-1,11600,0,'true','true','true','true','true','Elixir','2288-4;'),
(8632,'Elixir of Mental Strength (A-Grade)','','false','potion',5,'stackable','liquid','a',-1,-1,14400,0,'true','true','true','true','true','Elixir','2288-5;'),
(8633,'Elixir of Mental Strength (S-Grade)','','false','potion',5,'stackable','liquid','s',-1,-1,16800,0,'true','true','true','true','true','Elixir','2288-6;'),
(8634,'Elixir of CP (No Grade)','','false','potion',5,'stackable','liquid','none',-1,-1,600,0,'true','true','true','true','true','Elixir','2289-1;'),
(8635,'Elixir of CP (D-Grade)','','false','potion',5,'stackable','liquid','d',-1,-1,1400,0,'true','true','true','true','true','Elixir','2289-2;'),
(8636,'Elixir of CP (C-Grade)','','false','potion',5,'stackable','liquid','c',-1,-1,3000,0,'true','true','true','true','true','Elixir','2289-3;'),
(8637,'Elixir of CP (B-Grade)','','false','potion',5,'stackable','liquid','b',-1,-1,4000,0,'true','true','true','true','true','Elixir','2289-4;'),
(8638,'Elixir of CP (A-Grade)','','false','potion',5,'stackable','liquid','a',-1,-1,5000,0,'true','true','true','true','true','Elixir','2289-5;'),
(8639,'Elixir of CP (S-Grade)','','false','potion',5,'stackable','liquid','s',-1,-1,6000,0,'true','true','true','true','true','Elixir','2289-6;'),
(8640,'Recipe: Elixir of Life (No Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,260,0,'true','true','true','true','true','Recipes','0-0;'),
(8641,'Recipe: Elixir of Life (D-Grade)','','false','recipe',30,'stackable','paper','none',-1,-1,700,0,'true','true','true','true','true','Recipes','0-0;'),
(8642,'Recipe: Elixir of Life (C-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,1440,0,'true','true','true','true','true','Recipes','0-0;'),
(8643,'Recipe: Elixir of Life (B-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,2000,0,'true','true','true','true','true','Recipes','0-0;'),
(8644,'Recipe: Elixir of Life (A-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,2500,0,'true','true','true','true','true','Recipes','0-0;'),
(8645,'Recipe: Elixir of Life (S-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,3000,0,'true','true','true','true','true','Recipes','0-0;'),
(8646,'Recipe: Elixir of Mental Strength (No Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,280,0,'true','true','true','true','true','Recipes','0-0;'),
(8647,'Recipe: Elixir of Mental Strength (D-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,640,0,'true','true','true','true','true','Recipes','0-0;'),
(8648,'Recipe: Elixir of Mental Strength (C-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,1760,0,'true','true','true','true','true','Recipes','0-0;'),
(8649,'Recipe: Elixir of Mental Strength (B-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,2320,0,'true','true','true','true','true','Recipes','0-0;'),
(8650,'Recipe: Elixir of Mental Strength (A-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,2880,0,'true','true','true','true','true','Recipes','0-0;'),
(8651,'Recipe: Elixir of Mental Strength (S-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,3360,0,'true','true','true','true','true','Recipes','0-0;'),
(8652,'Recipe: Elixir of CP (No Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,120,0,'true','true','true','true','true','Recipes','0-0;'),
(8653,'Recipe: Elixir of CP (D-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,280,0,'true','true','true','true','true','Recipes','0-0;'),
(8654,'Recipe: Elixir of CP (C-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,600,0,'true','true','true','true','true','Recipes','0-0;'),
(8655,'Recipe: Elixir of CP (B-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,800,0,'true','true','true','true','true','Recipes','0-0;'),
(8656,'Recipe: Elixir of CP (A-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,1000,0,'true','true','true','true','true','Recipes','0-0;'),
(8657,'Recipe: Elixir of CP (S-Grade) (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,1200,0,'true','true','true','true','true','Recipes','0-0;'),
(8658,'Mysterious Solvent','','false','material',2,'stackable','liquid','none',-1,-1,100,0,'true','true','true','true','true','none','0-0;'),
(8659,'Coffer of Shadows','','false','potion',0,'stackable','paper','none',-1,-1,0,0,'true','true','true','true','true','none','0-0;'),
(8663,'Mystery Potion (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','SummonItems','0-0;'),
(8664,'Facelifting Potion - A (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2291-1;'),
(8665,'Facelifting Potion - B (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2292-1;'),
(8666,'Facelifting Potion - C (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2293-1;'),
(8667,'Dye Potion - A (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2294-1;'),
(8668,'Dye Potion - B (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2295-1;'),
(8669,'Dye Potion - C (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2296-1;'),
(8670,'Dye Potion - D (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2297-1;'),
(8671,'Hair Style Change Potion - A (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2298-1;'),
(8672,'Hair Style Change Potion - B (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2299-1;'),
(8673,'Hair Style Change Potion - C (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2300-1;'),
(8674,'Hair Style Change Potion - D (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2301-1;'),
(8675,'Hair Style Change Potion - E (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2302-1;'),
(8676,'Hair Style Change Potion - F (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2303-1;'),
(8677,'Hair Style Change Potion - G (Event)','','false','potion',50,'stackable','liquid','none',-1,-1,0,0,'true','true','true','true','true','ItemSkills','2304-1;'),
(8690,'Recipe: Sirra\'s Blade (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8691,'Recipe: Sirra\'s Blade (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8692,'Recipe: Sword of Ipos (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8693,'Recipe: Sword of Ipos (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8694,'Recipe: Barakiel\'s Axe (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8695,'Recipe: Barakiel\'s Axe (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8696,'Recipe: Behemoth\'s Tuning Fork (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8697,'Recipe: Behemoth\'s Tuning Fork (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8698,'Recipe: Naga Storm (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8699,'Recipe: Naga Storm (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8700,'Recipe: Tiphon\'s Spear (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8701,'Recipe: Tiphon\'s Spear (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8702,'Recipe: Shyeed\'s Bow (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8703,'Recipe: Shyeed\'s Bow (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8704,'Recipe: Sobekk\'s Hurricane (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8705,'Recipe: Sobekk\'s Hurricane (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8706,'Recipe: Themis\' Tongue (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8707,'Recipe: Themis\' Tongue (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8708,'Recipe: Cabrio\'s Hand (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8709,'Recipe: Cabrio\'s Hand (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8710,'Recipe: Daimon Crystal (60%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8711,'Recipe: Daimon Crystal (100%)','','false','recipe',30,'stackable','paper','none',-1,-1,706000,0,'true','true','true','true','true','Recipes','0-0;'),
(8712,'Sirra\'s Blade Edge','','false','material',60,'stackable','liquid','none',-1,-1,82400,0,'true','true','true','true','true','none','0-0;'),
(8713,'Sword of Ipos Blade','','false','material',60,'stackable','liquid','none',-1,-1,82400,0,'true','true','true','true','true','none','0-0;'),
(8714,'Barakiel\'s Axe Piece','','false','material',60,'stackable','liquid','none',-1,-1,82400,0,'true','true','true','true','true','none','0-0;'),
(8715,'Behemoth\'s Tuning Fork Piece','','false','material',60,'stackable','liquid','none',-1,-1,82400,0,'true','true','true','true','true','none','0-0;'),
(8716,'Naga Storm Piece','','false','material',60,'stackable','liquid','none',-1,-1,82400,0,'true','true','true','true','true','none','0-0;'),
(8717,'Tiphon\'s Spear Edge','','false','material',60,'stackable','liquid','none',-1,-1,82400,0,'true','true','true','true','true','none','0-0;'),
(8718,'Shyeed\'s Bow Shaft','','false','material',60,'stackable','liquid','none',-1,-1,82400,0,'true','true','true','true','true','none','0-0;'),
(8719,'Sobekk\'s Hurricane Edge','','false','material',60,'stackable','liquid','none',-1,-1,82400,0,'true','true','true','true','true','none','0-0;'),
(8720,'Themis\' Tongue Piece','','false','material',60,'stackable','liquid','none',-1,-1,82400,0,'true','true','true','true','true','none','0-0;'),
(8721,'Cabrio\'s Hand Head','','false','material',60,'stackable','liquid','none',-1,-1,82400,0,'true','true','true','true','true','none','0-0;'),
(8722,'Daimon Crystal Fragment','','false','material',60,'stackable','liquid','none',-1,-1,82400,0,'true','true','true','true','true','none','0-0;'),
(8723,'Life Stone: level 46','','false','none',2,'stackable','liquid','none',-1,-1,5000,0,'true','true','true','true','true','none','0-0;'),
(8724,'Life Stone: level 49','','false','none',2,'stackable','liquid','none',-1,-1,6000,0,'true','true','true','true','true','none','0-0;'),
(8725,'Life Stone: level 52','','false','none',2,'stackable','liquid','none',-1,-1,7200,0,'true','true','true','true','true','none','0-0;'),
(8726,'Life Stone: level 55','','false','none',2,'stackable','liquid','none',-1,-1,8640,0,'true','true','true','true','true','none','0-0;'),
(8727,'Life Stone: level 58','','false','none',2,'stackable','liquid','none',-1,-1,10000,0,'true','true','true','true','true','none','0-0;'),
(8728,'Life Stone: level 61','','false','none',2,'stackable','liquid','none',-1,-1,12000,0,'true','true','true','true','true','none','0-0;'),
(8729,'Life Stone: level 64','','false','none',2,'stackable','liquid','none',-1,-1,15000,0,'true','true','true','true','true','none','0-0;'),
(8730,'Life Stone: level 67','','false','none',2,'stackable','liquid','none',-1,-1,18000,0,'true','true','true','true','true','none','0-0;'),
(8731,'Life Stone: level 70','','false','none',2,'stackable','liquid','none',-1,-1,21600,0,'true','true','true','true','true','none','0-0;'),
(8732,'Life Stone: level 76','','false','none',2,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','none','0-0;');

INSERT INTO `etcitem` VALUES
(8733,'Mid-Grade Life Stone: level 46','','false','none',2,'stackable','liquid','none',-1,-1,20000,0,'true','true','true','true','true','none','0-0;'),
(8734,'Mid-Grade Life Stone: level 49','','false','none',2,'stackable','liquid','none',-1,-1,24000,0,'true','true','true','true','true','none','0-0;'),
(8735,'Mid-Grade Life Stone: level 52','','false','none',2,'stackable','liquid','none',-1,-1,28800,0,'true','true','true','true','true','none','0-0;'),
(8736,'Mid-Grade Life Stone: level 55','','false','none',2,'stackable','liquid','none',-1,-1,34560,0,'true','true','true','true','true','none','0-0;'),
(8737,'Mid-Grade Life Stone: level 58','','false','none',2,'stackable','liquid','none',-1,-1,40000,0,'true','true','true','true','true','none','0-0;'),
(8738,'Mid-Grade Life Stone: level 61','','false','none',2,'stackable','liquid','none',-1,-1,48000,0,'true','true','true','true','true','none','0-0;'),
(8739,'Mid-Grade Life Stone: level 64','','false','none',2,'stackable','liquid','none',-1,-1,60000,0,'true','true','true','true','true','none','0-0;'),
(8740,'Mid-Grade Life Stone: level 67','','false','none',2,'stackable','liquid','none',-1,-1,72000,0,'true','true','true','true','true','none','0-0;'),
(8741,'Mid-Grade Life Stone: level 70','','false','none',2,'stackable','liquid','none',-1,-1,86400,0,'true','true','true','true','true','none','0-0;'),
(8742,'Mid-Grade Life Stone: level 76','','false','none',2,'stackable','liquid','none',-1,-1,96000,0,'true','true','true','true','true','none','0-0;'),
(8743,'High-Grade Life Stone: level 46','','false','none',2,'stackable','liquid','none',-1,-1,200000,0,'true','true','true','true','true','none','0-0;'),
(8744,'High-Grade Life Stone: level 49','','false','none',2,'stackable','liquid','none',-1,-1,240000,0,'true','true','true','true','true','none','0-0;'),
(8745,'High-Grade Life Stone: level 52','','false','none',2,'stackable','liquid','none',-1,-1,288000,0,'true','true','true','true','true','none','0-0;'),
(8746,'High-Grade Life Stone: level 55','','false','none',2,'stackable','liquid','none',-1,-1,345600,0,'true','true','true','true','true','none','0-0;'),
(8747,'High-Grade Life Stone: level 58','','false','none',2,'stackable','liquid','none',-1,-1,400000,0,'true','true','true','true','true','none','0-0;'),
(8748,'High-Grade Life Stone: level 61','','false','none',2,'stackable','liquid','none',-1,-1,480000,0,'true','true','true','true','true','none','0-0;'),
(8749,'High-Grade Life Stone: level 64','','false','none',2,'stackable','liquid','none',-1,-1,600000,0,'true','true','true','true','true','none','0-0;'),
(8750,'High-Grade Life Stone: level 67','','false','none',2,'stackable','liquid','none',-1,-1,720000,0,'true','true','true','true','true','none','0-0;'),
(8751,'High-Grade Life Stone: level 70','','false','none',2,'stackable','liquid','none',-1,-1,864000,0,'true','true','true','true','true','none','0-0;'),
(8752,'High-Grade Life Stone: level 76','','false','none',2,'stackable','liquid','none',-1,-1,960000,0,'true','true','true','true','true','none','0-0;'),
(8753,'Top-Grade Life Stone: level 46','','false','none',2,'stackable','liquid','none',-1,-1,1000000,0,'true','true','true','true','true','none','0-0;'),
(8754,'Top-Grade Life Stone: level 49','','false','none',2,'stackable','liquid','none',-1,-1,1200000,0,'true','true','true','true','true','none','0-0;'),
(8755,'Top-Grade Life Stone: level 52','','false','none',2,'stackable','liquid','none',-1,-1,1440000,0,'true','true','true','true','true','none','0-0;'),
(8756,'Top-Grade Life Stone: level 55','','false','none',2,'stackable','liquid','none',-1,-1,1728000,0,'true','true','true','true','true','none','0-0;'),
(8757,'Top-Grade Life Stone: level 58','','false','none',2,'stackable','liquid','none',-1,-1,2000000,0,'true','true','true','true','true','none','0-0;'),
(8758,'Top-Grade Life Stone: level 61','','false','none',2,'stackable','liquid','none',-1,-1,2400000,0,'true','true','true','true','true','none','0-0;'),
(8759,'Top-Grade Life Stone: level 64','','false','none',2,'stackable','liquid','none',-1,-1,3000000,0,'true','true','true','true','true','none','0-0;'),
(8760,'Top-Grade Life Stone: level 67','','false','none',2,'stackable','liquid','none',-1,-1,3600000,0,'true','true','true','true','true','none','0-0;'),
(8761,'Top-Grade Life Stone: level 70','','false','none',2,'stackable','liquid','none',-1,-1,4320000,0,'true','true','true','true','true','none','0-0;'),
(8762,'Top-Grade Life Stone: level 76','','false','none',2,'stackable','liquid','none',-1,-1,4800000,0,'true','true','true','true','true','none','0-0;'),
(8764,'Trap Stone','','false','quest',2,'stackable','liquid','none',-1,-1,500,0,'true','true','true','true','true','none','0-0;'),
(8765,'Red Gem','','false','none',0,'stackable','cry