/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Properties;
import javolution.context.LogContext;
import javolution.context.SecurityContext;
import javolution.lang.Reflection;
import javolution.text.TextFormat;
import javolution.util.FastTable;
import javolution.xml.XMLBinding;
import javolution.xml.XMLFormat;
import javolution.xml.XMLObjectReader;
import javolution.xml.stream.XMLStreamException;

public abstract class Configurable<T> {
    private volatile T _value;
    private final T _default;
    static final XMLFormat CONFIGURABLE_XML = new XMLFormat(Configurable.class){

        public Object newInstance(Class cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return Configurable.getInstance(xml.getAttribute("name", ""));
        }

        public void write(Object c, XMLFormat.OutputElement xml) throws XMLStreamException {
            Configurable cfg = (Configurable)c;
            xml.setAttribute("name", cfg.getName());
            xml.add(cfg.get(), "Value");
        }

        public void read(XMLFormat.InputElement xml, Object c) throws XMLStreamException {
            Object value = xml.get("Value");
            if (value == null) {
                return;
            }
            Configurable.configure((Configurable)c, value);
        }
    };

    public Configurable(T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Default value cannot be null");
        }
        this._default = defaultValue;
        this._value = defaultValue;
    }

    public T get() {
        return this._value;
    }

    public T getDefault() {
        return this._default;
    }

    protected void notifyChange(T oldValue, T newValue) throws UnsupportedOperationException {
    }

    public String toString() {
        return String.valueOf(this._value);
    }

    public String getName() {
        Class<?> cfgClass = this.getClass();
        Class<?> cls = cfgClass.getEnclosingClass();
        Field[] fields = cls.getDeclaredFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (field.get(null) != this) continue;
                return cls.getName() + '#' + field.getName();
            }
        }
        catch (IllegalAccessException ex) {
            LogContext.error(ex);
        }
        return null;
    }

    public static Configurable getInstance(String name) {
        int sep = name.lastIndexOf(35);
        if (sep < 0) {
            return null;
        }
        String className = name.substring(0, sep);
        String fieldName = name.substring(sep + 1);
        Class cls = Reflection.getInstance().getClass(className);
        if (cls == null) {
            return null;
        }
        try {
            Configurable cfg = (Configurable)cls.getDeclaredField(fieldName).get(null);
            return cfg;
        }
        catch (Exception ex) {
            LogContext.error(ex);
            return null;
        }
    }

    public static <T> void configure(Configurable<T> cfg, T newValue) throws SecurityException {
        if (newValue == null) {
            throw new IllegalArgumentException("Default value cannot be null");
        }
        SecurityContext policy = SecurityContext.getCurrentSecurityContext();
        if (!policy.isConfigurable(cfg)) {
            throw new SecurityException("Configuration disallowed by SecurityContext");
        }
        T oldValue = cfg._value;
        if (!newValue.equals(oldValue)) {
            LogContext.info("Configurable " + cfg.getName() + " set to " + newValue);
            cfg._value = newValue;
            cfg.notifyChange(oldValue, newValue);
        }
    }

    public static void read(Properties properties) {
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String textValue = properties.getProperty(name);
            Configurable cfg = Configurable.getInstance(name);
            if (cfg == null) continue;
            Class<?> type = cfg.getDefault().getClass();
            TextFormat<?> format = TextFormat.getInstance(type);
            if (!format.isParsingSupported()) {
                LogContext.error("Cannot find suitable TextFormat to parse instances of " + type);
                continue;
            }
            Object newValue = format.parse(textValue);
            Configurable.configure(cfg, newValue);
        }
    }

    public static void read(InputStream inputStream) {
        try {
            XMLObjectReader reader = XMLObjectReader.newInstance(inputStream);
            XMLBinding binding = new XMLBinding();
            binding.setAlias(Configurable.class, "Configurable");
            reader.setBinding(binding);
            reader.read("Configuration", FastTable.class);
        }
        catch (Exception ex) {
            LogContext.error(ex);
        }
    }
}

