/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import java.lang.reflect.InvocationTargetException;
import javolution.context.LogContext;
import javolution.lang.Configurable;
import javolution.text.TextBuilder;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.util.FastSet;

public abstract class Reflection {
    private static volatile Reflection INSTANCE = new Default();
    public static final Configurable<Class<? extends Reflection>> CLASS = new Configurable(Default.class){

        protected void notifyChange(Object oldValue, Object newValue) {
            try {
                INSTANCE = (Reflection)((Class)newValue).newInstance();
            }
            catch (Throwable error) {
                LogContext.error(error);
            }
        }
    };
    private static final Object[] EMPTY_ARRAY = new Object[0];

    protected Reflection() {
    }

    public static final Reflection getInstance() {
        return INSTANCE;
    }

    public abstract void add(Object var1);

    public abstract void remove(Object var1);

    public abstract Class getClass(CharSequence var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getClass(String name) {
        String obj = name;
        if (obj instanceof CharSequence) {
            return this.getClass((CharSequence)obj);
        }
        TextBuilder tmp = TextBuilder.newInstance();
        try {
            tmp.append(name);
            Class clazz = this.getClass(tmp);
            return clazz;
        }
        finally {
            TextBuilder.recycle(tmp);
        }
    }

    public abstract Class getSuperclass(Class var1);

    public abstract Class[] getInterfaces(Class var1);

    public abstract Constructor getConstructor(String var1);

    public abstract Method getMethod(String var1);

    public static Constructor getConstructor(Object signature) {
        return Reflection.getInstance().getConstructor((String)signature);
    }

    public static Method getMethod(Object signature) {
        return Reflection.getInstance().getMethod((String)signature);
    }

    private static final class Default
    extends Reflection {
        private final FastSet _classLoaders = new FastSet();
        private final FastMap _nameToClass = new FastMap().shared().setKeyComparator(FastComparator.LEXICAL);

        private Default() {
        }

        @Override
        public void add(Object classLoader) {
            this._classLoaders.add(classLoader);
        }

        @Override
        public void remove(Object classLoader) {
            this._classLoaders.remove(classLoader);
            this._nameToClass.clear();
        }

        @Override
        public Class getClass(CharSequence name) {
            Class cls = (Class)this._nameToClass.get(name);
            return cls != null ? cls : this.searchClass(((Object)name).toString());
        }

        private Class searchClass(String name) {
            Class<?> cls = null;
            try {
                cls = Class.forName(name);
            }
            catch (ClassNotFoundException e1) {
                for (ClassLoader classLoader : this._classLoaders) {
                    try {
                        cls = Class.forName(name, true, classLoader);
                    }
                    catch (ClassNotFoundException e2) {}
                }
            }
            if (cls != null) {
                this._nameToClass.put(name, cls);
            }
            return cls;
        }

        @Override
        public Constructor getConstructor(String signature) {
            int argStart = signature.indexOf(40) + 1;
            if (argStart < 0) {
                throw new IllegalArgumentException("Parenthesis '(' not found");
            }
            int argEnd = signature.indexOf(41);
            if (argEnd < 0) {
                throw new IllegalArgumentException("Parenthesis ')' not found");
            }
            String className = signature.substring(0, argStart - 1);
            Class theClass = this.getClass(className);
            if (theClass == null) {
                return null;
            }
            String args = signature.substring(argStart, argEnd);
            if (args.length() == 0) {
                return new DefaultConstructor(theClass);
            }
            Class[] argsTypes = this.classesFor(args);
            if (argsTypes == null) {
                return null;
            }
            try {
                return new ReflectConstructor(theClass.getConstructor(argsTypes), signature);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        @Override
        public Class[] getInterfaces(Class cls) {
            return cls.getInterfaces();
        }

        @Override
        public Class getSuperclass(Class cls) {
            return cls.getSuperclass();
        }

        @Override
        public Method getMethod(String signature) {
            int argStart = signature.indexOf(40) + 1;
            if (argStart < 0) {
                throw new IllegalArgumentException("Parenthesis '(' not found");
            }
            int argEnd = signature.indexOf(41);
            if (argEnd < 0) {
                throw new IllegalArgumentException("Parenthesis ')' not found");
            }
            int nameStart = signature.substring(0, argStart).lastIndexOf(46) + 1;
            try {
                String className = signature.substring(0, nameStart - 1);
                Class theClass = this.getClass(className);
                if (theClass == null) {
                    return null;
                }
                String methodName = signature.substring(nameStart, argStart - 1);
                String args = signature.substring(argStart, argEnd);
                Class[] argsTypes = this.classesFor(args);
                if (argsTypes == null) {
                    return null;
                }
                return new ReflectMethod(theClass.getMethod(methodName, argsTypes), signature);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Class[] classesFor(String args) {
            if ((args = args.trim()).length() == 0) {
                return new Class[0];
            }
            int commas = 0;
            int i = 0;
            while (true) {
                i = args.indexOf(44, i);
                if (i++ < 0) break;
                ++commas;
            }
            Class[] classes = new Class[commas + 1];
            int index = 0;
            for (int i2 = 0; i2 < commas; ++i2) {
                int sep = args.indexOf(44, index);
                classes[i2] = this.classFor(args.substring(index, sep).trim());
                if (classes[i2] == null) {
                    return null;
                }
                index = sep + 1;
            }
            classes[commas] = this.classFor(args.substring(index).trim());
            if (classes[commas] == null) {
                return null;
            }
            return classes;
        }

        private Class classFor(String className) {
            int arrayIndex = className.indexOf("[]");
            if (arrayIndex >= 0) {
                if (className.indexOf("[][]") >= 0) {
                    if (className.indexOf("[][][]") >= 0) {
                        if (className.indexOf("[][][][]") >= 0) {
                            throw new UnsupportedOperationException("The maximum array dimension is 3");
                        }
                        return this.getClass("[[[" + Default.descriptorFor(className.substring(0, arrayIndex)));
                    }
                    return this.getClass("[[" + Default.descriptorFor(className.substring(0, arrayIndex)));
                }
                return this.getClass("[" + Default.descriptorFor(className.substring(0, arrayIndex)));
            }
            if (className.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (className.equals("byte")) {
                return Byte.TYPE;
            }
            if (className.equals("char")) {
                return Character.TYPE;
            }
            if (className.equals("short")) {
                return Short.TYPE;
            }
            if (className.equals("int")) {
                return Integer.TYPE;
            }
            if (className.equals("long")) {
                return Long.TYPE;
            }
            if (className.equals("float")) {
                return Float.TYPE;
            }
            if (className.equals("double")) {
                return Double.TYPE;
            }
            return this.getClass(className);
        }

        private static String descriptorFor(String className) {
            if (className.equals("boolean")) {
                return "Z";
            }
            if (className.equals("byte")) {
                return "B";
            }
            if (className.equals("char")) {
                return "C";
            }
            if (className.equals("short")) {
                return "S";
            }
            if (className.equals("int")) {
                return "I";
            }
            if (className.equals("long")) {
                return "J";
            }
            if (className.equals("float")) {
                return "F";
            }
            if (className.equals("double")) {
                return "D";
            }
            return "L" + className + ";";
        }

        private final class ReflectMethod
        extends Method {
            private final java.lang.reflect.Method _value;
            private final String _signature;

            public ReflectMethod(java.lang.reflect.Method value, String signature) {
                super(value.getParameterTypes());
                this._value = value;
                this._signature = signature;
            }

            @Override
            public Object execute(Object that, Object[] args) {
                try {
                    return this._value.invoke(that, args);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError("Illegal access error for " + this._signature + " method");
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new RuntimeException("Invocation exception for " + this._signature + " method", (InvocationTargetException)e.getCause());
                }
            }

            public String toString() {
                return this._signature + " method";
            }
        }

        private final class ReflectConstructor
        extends Constructor {
            private final java.lang.reflect.Constructor _value;
            private final String _signature;

            public ReflectConstructor(java.lang.reflect.Constructor value, String signature) {
                super(value.getParameterTypes());
                this._value = value;
                this._signature = signature;
            }

            @Override
            public Object allocate(Object[] args) {
                try {
                    return this._value.newInstance(args);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Instantiation error for " + this._signature + " constructor", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Illegal access error for " + this._signature + " constructor", e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new RuntimeException("Invocation exception  for " + this._signature + " constructor", (InvocationTargetException)e.getCause());
                }
            }

            public String toString() {
                return this._signature + " constructor";
            }
        }

        private class DefaultConstructor
        extends Constructor {
            final Class _class;

            DefaultConstructor(Class cl) {
                super(new Class[0]);
                this._class = cl;
            }

            @Override
            public Object allocate(Object[] args) {
                try {
                    return this._class.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Default constructor instantiation error for " + this._class.getName() + " (" + e.getMessage() + ")");
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Default constructor illegal access error for " + this._class.getName() + " (" + e.getMessage() + ")");
                }
            }

            public String toString() {
                return this._class + " default constructor";
            }
        }
    }

    public abstract class Method {
        private final Class[] _parameterTypes;

        protected Method(Class[] parameterTypes) {
            this._parameterTypes = parameterTypes;
        }

        public Class[] getParameterTypes() {
            return this._parameterTypes;
        }

        protected abstract Object execute(Object var1, Object[] var2);

        public final Object invoke(Object thisObject) {
            if (this._parameterTypes.length != 0) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            return this.execute(thisObject, EMPTY_ARRAY);
        }

        public final Object invoke(Object thisObject, Object arg0) {
            if (this._parameterTypes.length != 1) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = new Object[]{arg0};
            return this.execute(thisObject, args);
        }

        public final Object invoke(Object thisObject, Object arg0, Object arg1) {
            if (this._parameterTypes.length != 2) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = new Object[]{arg0, arg1};
            return this.execute(thisObject, args);
        }

        public final Object invoke(Object thisObject, Object arg0, Object arg1, Object arg2) {
            if (this._parameterTypes.length != 3) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = new Object[]{arg0, arg1, arg2};
            return this.execute(thisObject, args);
        }

        public final Object invoke(Object thisObject, Object arg0, Object arg1, Object arg2, Object arg3) {
            if (this._parameterTypes.length != 4) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = new Object[]{arg0, arg1, arg2, arg3};
            return this.execute(thisObject, args);
        }

        public final Object invoke(Object thisObject, Object ... args) {
            if (this._parameterTypes.length != args.length) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            return this.execute(thisObject, args);
        }
    }

    public abstract class Constructor {
        private final Class[] _parameterTypes;

        protected Constructor(Class[] parameterTypes) {
            this._parameterTypes = parameterTypes;
        }

        public Class[] getParameterTypes() {
            return this._parameterTypes;
        }

        protected abstract Object allocate(Object[] var1);

        public final Object newInstance() {
            if (this._parameterTypes.length != 0) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            return this.allocate(EMPTY_ARRAY);
        }

        public final Object newInstance(Object arg0) {
            if (this._parameterTypes.length != 1) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = new Object[]{arg0};
            return this.allocate(args);
        }

        public final Object newInstance(Object arg0, Object arg1) {
            if (this._parameterTypes.length != 2) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = new Object[]{arg0, arg1};
            return this.allocate(args);
        }

        public final Object newInstance(Object arg0, Object arg1, Object arg2) {
            if (this._parameterTypes.length != 3) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = new Object[]{arg0, arg1, arg2};
            return this.allocate(args);
        }

        public final Object newInstance(Object arg0, Object arg1, Object arg2, Object arg3) {
            if (this._parameterTypes.length != 4) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            Object[] args = new Object[]{arg0, arg1, arg2, arg3};
            return this.allocate(args);
        }

        public final Object newInstance(Object ... args) {
            if (this._parameterTypes.length != args.length) {
                throw new IllegalArgumentException("Expected number of parameters is " + this._parameterTypes.length);
            }
            return this.allocate(args);
        }
    }
}

