/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Set;
import javolution.context.ObjectFactory;
import javolution.lang.Reusable;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastMap;

public class FastSet<E>
extends FastCollection<E>
implements Set<E>,
Reusable {
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        public Object create() {
            return new FastSet();
        }
    };
    private transient FastMap _map;
    private static final long serialVersionUID = 1L;

    public FastSet() {
        this(new FastMap());
    }

    public FastSet(String id) {
        this(new FastMap(id));
    }

    public FastSet(int capacity) {
        this(new FastMap(capacity));
    }

    public FastSet(Set<? extends E> elements) {
        this(new FastMap(elements.size()));
        this.addAll(elements);
    }

    private FastSet(FastMap map) {
        this._map = map;
    }

    public static <E> FastSet<E> newInstance() {
        return (FastSet)FACTORY.object();
    }

    public static void recycle(FastSet instance) {
        FACTORY.recycle(instance);
    }

    @Override
    public final int size() {
        return this._map.size();
    }

    @Override
    public final boolean add(E value) {
        return this._map.put(value, value) == null;
    }

    @Override
    public Iterator<E> iterator() {
        return this._map.keySet().iterator();
    }

    @Override
    public Set<E> unmodifiable() {
        return (Set)super.unmodifiable();
    }

    @Override
    public final void clear() {
        this._map.clear();
    }

    @Override
    public final boolean contains(Object o) {
        return this._map.containsKey(o);
    }

    @Override
    public final boolean remove(Object o) {
        return this._map.remove(o) != null;
    }

    public FastSet<E> setValueComparator(FastComparator<? super E> comparator) {
        this._map.setKeyComparator(comparator);
        return this;
    }

    @Override
    public FastComparator<? super E> getValueComparator() {
        return this._map.getKeyComparator();
    }

    @Override
    public void reset() {
        this._map.reset();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        FastComparator cmp = (FastComparator)stream.readObject();
        int size = stream.readInt();
        this._map = new FastMap(size);
        this.setValueComparator(cmp);
        int i = size;
        while (i-- != 0) {
            Object key = stream.readObject();
            this._map.put(key, key);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.getValueComparator());
        stream.writeInt(this.size());
        FastCollection.Record e = this._map.head();
        FastMap.Entry end = this._map.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            stream.writeObject(((FastMap.Entry)e).getKey());
        }
    }

    @Override
    public final FastCollection.Record head() {
        return this._map.head();
    }

    @Override
    public final FastCollection.Record tail() {
        return this._map.tail();
    }

    @Override
    public final E valueOf(FastCollection.Record record) {
        return (E)((FastMap.Entry)record).getKey();
    }

    @Override
    public final void delete(FastCollection.Record record) {
        this._map.remove(((FastMap.Entry)record).getKey());
    }
}

