/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ai.AbstractAI;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2PlayerAI;
import com.l2jserver.gameserver.ai.L2SummonAI;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.AutoAttackStop;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.util.Point3D;
import com.l2jserver.util.Rnd;
import java.util.List;
import javolution.util.FastList;

public class L2CharacterAI
extends AbstractAI {
    public L2CharacterAI(L2Character.AIAccessor accessor) {
        super(accessor);
    }

    public IntentionCommand getNextIntention() {
        return null;
    }

    @Override
    protected void onEvtAttacked(L2Character attacker) {
        if (attacker instanceof L2Attackable && !((L2Attackable)attacker).isCoreAIDisabled()) {
            this.clientStartAutoAttack();
        }
    }

    @Override
    protected void onIntentionIdle() {
        this.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
        this.setCastTarget(null);
        this.setAttackTarget(null);
        this.clientStopMoving(null);
        this.clientStopAutoAttack();
    }

    @Override
    protected void onIntentionActive() {
        if (this.getIntention() != CtrlIntention.AI_INTENTION_ACTIVE) {
            this.changeIntention(CtrlIntention.AI_INTENTION_ACTIVE, null, null);
            this.setCastTarget(null);
            this.setAttackTarget(null);
            this.clientStopMoving(null);
            this.clientStopAutoAttack();
            if (this._actor instanceof L2Attackable) {
                ((L2Npc)this._actor).startRandomAnimationTimer();
            }
            this.onEvtThink();
        }
    }

    @Override
    protected void onIntentionRest() {
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
    }

    @Override
    protected void onIntentionAttack(L2Character target) {
        if (target == null) {
            this.clientActionFailed();
            return;
        }
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow() || this._actor.isAfraid()) {
            this.clientActionFailed();
            return;
        }
        if (this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
            if (this.getAttackTarget() != target) {
                this.setAttackTarget(target);
                this.stopFollow();
                this.notifyEvent(CtrlEvent.EVT_THINK, null);
            } else {
                this.clientActionFailed();
            }
        } else {
            this.changeIntention(CtrlIntention.AI_INTENTION_ATTACK, target, null);
            this.setAttackTarget(target);
            this.stopFollow();
            this.notifyEvent(CtrlEvent.EVT_THINK, null);
        }
    }

    @Override
    protected void onIntentionCast(L2Skill skill, L2Object target) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST && skill.isMagic()) {
            this.clientActionFailed();
            this._actor.setIsCastingNow(false);
            return;
        }
        this.setCastTarget((L2Character)target);
        if (skill.getHitTime() > 50) {
            this._actor.abortAttack();
        }
        this._skill = skill;
        this.changeIntention(CtrlIntention.AI_INTENTION_CAST, skill, target);
        this.notifyEvent(CtrlEvent.EVT_THINK, null);
    }

    @Override
    protected void onIntentionMoveTo(L2CharPosition pos) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow()) {
            this.clientActionFailed();
            return;
        }
        this.changeIntention(CtrlIntention.AI_INTENTION_MOVE_TO, pos, null);
        this.clientStopAutoAttack();
        this._actor.abortAttack();
        this.moveTo(pos.x, pos.y, pos.z);
    }

    @Override
    protected void onIntentionMoveToInABoat(L2CharPosition destination, L2CharPosition origin) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow()) {
            this.clientActionFailed();
            return;
        }
        this.clientStopAutoAttack();
        this._actor.abortAttack();
        this.moveToInABoat(destination, origin);
    }

    @Override
    protected void onIntentionMoveToInAirShip(L2CharPosition destination, L2CharPosition origin) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow()) {
            this.clientActionFailed();
            return;
        }
        this.clientStopAutoAttack();
        this._actor.abortAttack();
        this.moveToInAirShip(destination, origin);
    }

    @Override
    protected void onIntentionFollow(L2Character target) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow()) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isMovementDisabled()) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isDead()) {
            this.clientActionFailed();
            return;
        }
        if (this._actor == target) {
            this.clientActionFailed();
            return;
        }
        this.clientStopAutoAttack();
        this.changeIntention(CtrlIntention.AI_INTENTION_FOLLOW, target, null);
        this.startFollow(target);
    }

    @Override
    protected void onIntentionPickUp(L2Object object) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow()) {
            this.clientActionFailed();
            return;
        }
        this.clientStopAutoAttack();
        if (object instanceof L2ItemInstance && ((L2ItemInstance)object).getLocation() != L2ItemInstance.ItemLocation.VOID) {
            return;
        }
        this.changeIntention(CtrlIntention.AI_INTENTION_PICK_UP, object, null);
        this.setTarget(object);
        if (object.getX() == 0 && object.getY() == 0) {
            _log.warning("Object in coords 0,0 - using a temporary fix");
            object.setXYZ(this.getActor().getX(), this.getActor().getY(), this.getActor().getZ() + 5);
        }
        this.moveToPawn(object, 20);
    }

    @Override
    protected void onIntentionInteract(L2Object object) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow()) {
            this.clientActionFailed();
            return;
        }
        this.clientStopAutoAttack();
        if (this.getIntention() != CtrlIntention.AI_INTENTION_INTERACT) {
            this.changeIntention(CtrlIntention.AI_INTENTION_INTERACT, object, null);
            this.setTarget(object);
            this.moveToPawn(object, 60);
        }
    }

    @Override
    protected void onEvtThink() {
    }

    @Override
    protected void onEvtAggression(L2Character target, int aggro) {
    }

    @Override
    protected void onEvtStunned(L2Character attacker) {
        this._actor.broadcastPacket(new AutoAttackStop(this._actor.getObjectId()));
        if (AttackStanceTaskManager.getInstance().getAttackStanceTask(this._actor)) {
            AttackStanceTaskManager.getInstance().removeAttackStanceTask(this._actor);
        }
        this.setAutoAttacking(false);
        this.clientStopMoving(null);
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtParalyzed(L2Character attacker) {
        this._actor.broadcastPacket(new AutoAttackStop(this._actor.getObjectId()));
        if (AttackStanceTaskManager.getInstance().getAttackStanceTask(this._actor)) {
            AttackStanceTaskManager.getInstance().removeAttackStanceTask(this._actor);
        }
        this.setAutoAttacking(false);
        this.clientStopMoving(null);
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtSleeping(L2Character attacker) {
        this._actor.broadcastPacket(new AutoAttackStop(this._actor.getObjectId()));
        if (AttackStanceTaskManager.getInstance().getAttackStanceTask(this._actor)) {
            AttackStanceTaskManager.getInstance().removeAttackStanceTask(this._actor);
        }
        this.setAutoAttacking(false);
        this.clientStopMoving(null);
    }

    @Override
    protected void onEvtRooted(L2Character attacker) {
        this.clientStopMoving(null);
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtConfused(L2Character attacker) {
        this.clientStopMoving(null);
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtMuted(L2Character attacker) {
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtReadyToAct() {
        this.onEvtThink();
    }

    @Override
    protected void onEvtUserCmd(Object arg0, Object arg1) {
    }

    @Override
    protected void onEvtArrived() {
        if (Config.ACTIVATE_POSITION_RECORDER && this._accessor.getActor() instanceof L2PcInstance) {
            ((L2PcInstance)this._accessor.getActor()).explore();
        }
        this._accessor.getActor().revalidateZone(true);
        if (this._accessor.getActor().moveToNextRoutePoint()) {
            return;
        }
        if (this._accessor.getActor() instanceof L2Attackable) {
            ((L2Attackable)this._accessor.getActor()).setisReturningToSpawnPoint(false);
        }
        this.clientStoppedMoving();
        if (this.getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        this.onEvtThink();
        if (this._actor instanceof L2BoatInstance) {
            ((L2BoatInstance)this._actor).evtArrived();
        } else if (this._actor instanceof L2AirShipInstance) {
            ((L2AirShipInstance)this._actor).evtArrived();
        } else if (this._actor instanceof L2GrandBossInstance) {
            ((L2GrandBossInstance)this._actor).evtArrived();
        }
    }

    @Override
    protected void onEvtArrivedRevalidate() {
        this.onEvtThink();
    }

    @Override
    protected void onEvtArrivedBlocked(L2CharPosition blocked_at_pos) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO || this.getIntention() == CtrlIntention.AI_INTENTION_CAST) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        this.clientStopMoving(blocked_at_pos);
        this.onEvtThink();
    }

    @Override
    protected void onEvtForgetObject(L2Object object) {
        if (this.getTarget() == object) {
            this.setTarget(null);
            if (this.getIntention() == CtrlIntention.AI_INTENTION_INTERACT) {
                this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_PICK_UP) {
                this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            }
        }
        if (this.getAttackTarget() == object) {
            this.setAttackTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (this.getCastTarget() == object) {
            this.setCastTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (this.getFollowTarget() == object) {
            this.clientStopMoving(null);
            this.stopFollow();
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (this._actor == object) {
            this.setTarget(null);
            this.setAttackTarget(null);
            this.setCastTarget(null);
            this.stopFollow();
            this.clientStopMoving(null);
            this.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
        }
    }

    @Override
    protected void onEvtCancel() {
        this._actor.abortCast();
        this.stopFollow();
        if (!AttackStanceTaskManager.getInstance().getAttackStanceTask(this._actor)) {
            this._actor.broadcastPacket(new AutoAttackStop(this._actor.getObjectId()));
        }
        this.onEvtThink();
    }

    @Override
    protected void onEvtDead() {
        this.stopFollow();
        this.clientNotifyDead();
        if (!(this._actor instanceof L2PcInstance)) {
            this._actor.setWalking();
        }
    }

    @Override
    protected void onEvtFakeDeath() {
        this.stopFollow();
        this.clientStopMoving(null);
        this._intention = CtrlIntention.AI_INTENTION_IDLE;
        this.setTarget(null);
        this.setCastTarget(null);
        this.setAttackTarget(null);
    }

    @Override
    protected void onEvtFinishCasting() {
    }

    protected boolean maybeMoveToPosition(Point3D worldPosition, int offset) {
        if (worldPosition == null) {
            _log.warning("maybeMoveToPosition: worldPosition == NULL!");
            return false;
        }
        if (offset < 0) {
            return false;
        }
        if (!this._actor.isInsideRadius(worldPosition.getX(), worldPosition.getY(), offset + this._actor.getTemplate().collisionRadius, false)) {
            if (this._actor.isMovementDisabled()) {
                return true;
            }
            if (!(this._actor.isRunning() || this instanceof L2PlayerAI || this instanceof L2SummonAI)) {
                this._actor.setRunning();
            }
            this.stopFollow();
            int x = this._actor.getX();
            int y = this._actor.getY();
            double dx = worldPosition.getX() - x;
            double dy = worldPosition.getY() - y;
            double dist = Math.sqrt(dx * dx + dy * dy);
            double sin = dy / dist;
            double cos = dx / dist;
            this.moveTo(x += (int)((dist -= (double)(offset - 5)) * cos), y += (int)(dist * sin), worldPosition.getZ());
            return true;
        }
        if (this.getFollowTarget() != null) {
            this.stopFollow();
        }
        return false;
    }

    protected boolean maybeMoveToPawn(L2Object target, int offset) {
        if (target == null) {
            _log.warning("maybeMoveToPawn: target == NULL!");
            return false;
        }
        if (offset < 0) {
            return false;
        }
        offset += this._actor.getTemplate().collisionRadius;
        if (target instanceof L2Character) {
            offset += ((L2Character)target).getTemplate().collisionRadius;
        }
        if (!this._actor.isInsideRadius(target, offset, false, false)) {
            if (this.getFollowTarget() != null) {
                if (!this._actor.isInsideRadius(target, offset + 100, false, false)) {
                    return true;
                }
                this.stopFollow();
                return false;
            }
            if (this._actor.isMovementDisabled()) {
                return true;
            }
            if (this._actor.getAI().getIntention() == CtrlIntention.AI_INTENTION_CAST && this._actor instanceof L2PcInstance && ((L2PcInstance)this._actor).isTransformed() && !((L2PcInstance)this._actor).getTransformation().canStartFollowToCast()) {
                ((L2PcInstance)this._actor).sendPacket(new SystemMessage(SystemMessageId.DIST_TOO_FAR_CASTING_STOPPED));
                ((L2PcInstance)this._actor).sendPacket(ActionFailed.STATIC_PACKET);
                return true;
            }
            if (!(this._actor.isRunning() || this instanceof L2PlayerAI || this instanceof L2SummonAI)) {
                this._actor.setRunning();
            }
            this.stopFollow();
            if (target instanceof L2Character && !(target instanceof L2DoorInstance)) {
                if (((L2Character)target).isMoving()) {
                    offset -= 100;
                }
                if (offset < 5) {
                    offset = 5;
                }
                this.startFollow((L2Character)target, offset);
            } else {
                this.moveToPawn(target, offset);
            }
            return true;
        }
        if (this.getFollowTarget() != null) {
            this.stopFollow();
        }
        return false;
    }

    protected boolean checkTargetLostOrDead(L2Character target) {
        if (target == null || target.isAlikeDead()) {
            if (target instanceof L2PcInstance && ((L2PcInstance)target).isFakeDeath()) {
                target.stopFakeDeath(null);
                return false;
            }
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return true;
        }
        return false;
    }

    protected boolean checkTargetLost(L2Object target) {
        L2PcInstance target2;
        if (target instanceof L2PcInstance && (target2 = (L2PcInstance)target).isFakeDeath()) {
            target2.stopFakeDeath(null);
            return false;
        }
        if (target == null) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return true;
        }
        return false;
    }

    public boolean canAura(L2Skill sk) {
        if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AURA) {
            for (L2Character target : this._actor.getKnownList().getKnownCharactersInRadius(sk.getSkillRadius())) {
                if (target != this.getAttackTarget()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canAOE(L2Skill sk) {
        if (sk.getSkillType() != L2SkillType.NEGATE || sk.getSkillType() != L2SkillType.CANCEL) {
            if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_MULTIFACE) {
                boolean cancast = true;
                block0: for (L2Character target : this._actor.getKnownList().getKnownCharactersInRadius(sk.getSkillRadius())) {
                    if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, target)) continue;
                    if (target instanceof L2Attackable) {
                        L2Npc targets = (L2Npc)target;
                        L2Npc actors = (L2Npc)this._actor;
                        if (targets.getEnemyClan() == null || actors.getClan() == null || !targets.getEnemyClan().equals(actors.getClan()) || actors.getClan() == null && actors.getIsChaos() == 0) continue;
                    }
                    L2Effect[] effects = target.getAllEffects();
                    for (int i = 0; effects != null && i < effects.length; ++i) {
                        L2Effect effect = effects[i];
                        if (effect.getSkill() != sk) continue;
                        cancast = false;
                        continue block0;
                    }
                }
                if (cancast) {
                    return true;
                }
            } else if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AREA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AREA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AREA) {
                boolean cancast = true;
                for (L2Character target : this.getAttackTarget().getKnownList().getKnownCharactersInRadius(sk.getSkillRadius())) {
                    L2Effect[] effects;
                    if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, target) || target == null) continue;
                    if (target instanceof L2Attackable) {
                        L2Npc targets = (L2Npc)target;
                        L2Npc actors = (L2Npc)this._actor;
                        if (targets.getEnemyClan() == null || actors.getClan() == null || !targets.getEnemyClan().equals(actors.getClan()) || actors.getClan() == null && actors.getIsChaos() == 0) continue;
                    }
                    if ((effects = target.getAllEffects()).length <= 0) continue;
                    cancast = true;
                }
                if (cancast) {
                    return true;
                }
            }
        } else if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AURA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_MULTIFACE) {
            boolean cancast = false;
            for (L2Character target : this._actor.getKnownList().getKnownCharactersInRadius(sk.getSkillRadius())) {
                L2Effect[] effects;
                if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, target)) continue;
                if (target instanceof L2Attackable) {
                    L2Npc targets = (L2Npc)target;
                    L2Npc actors = (L2Npc)this._actor;
                    if (targets.getEnemyClan() == null || actors.getClan() == null || !targets.getEnemyClan().equals(actors.getClan()) || actors.getClan() == null && actors.getIsChaos() == 0) continue;
                }
                if ((effects = target.getAllEffects()).length <= 0) continue;
                cancast = true;
            }
            if (cancast) {
                return true;
            }
        } else if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_AREA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_BEHIND_AREA || sk.getTargetType() == L2Skill.SkillTargetType.TARGET_FRONT_AREA) {
            boolean cancast = true;
            block4: for (L2Character target : this.getAttackTarget().getKnownList().getKnownCharactersInRadius(sk.getSkillRadius())) {
                if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, target)) continue;
                if (target instanceof L2Attackable) {
                    L2Npc targets = (L2Npc)target;
                    L2Npc actors = (L2Npc)this._actor;
                    if (targets.getEnemyClan() == null || actors.getClan() == null || !targets.getEnemyClan().equals(actors.getClan()) || actors.getClan() == null && actors.getIsChaos() == 0) continue;
                }
                L2Effect[] effects = target.getAllEffects();
                for (int i = 0; effects != null && i < effects.length; ++i) {
                    L2Effect effect = effects[i];
                    if (effect.getSkill() != sk) continue;
                    cancast = false;
                    continue block4;
                }
            }
            if (cancast) {
                return true;
            }
        }
        return false;
    }

    public boolean canParty(L2Skill sk) {
        if (sk.getTargetType() == L2Skill.SkillTargetType.TARGET_PARTY) {
            int count = 0;
            int ccount = 0;
            block0: for (L2Character target : this._actor.getKnownList().getKnownCharactersInRadius(sk.getSkillRadius())) {
                if (!(target instanceof L2Attackable) || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, target)) continue;
                L2Npc targets = (L2Npc)target;
                L2Npc actors = (L2Npc)this._actor;
                if (actors.getFactionId() == null || !targets.getFactionId().equals(actors.getFactionId())) continue;
                ++count;
                L2Effect[] effects = target.getAllEffects();
                for (int i = 0; effects != null && i < effects.length; ++i) {
                    L2Effect effect = effects[i];
                    if (effect.getSkill() != sk) continue;
                    ++ccount;
                    continue block0;
                }
            }
            if (ccount < count) {
                return true;
            }
        }
        return false;
    }

    public boolean isParty(L2Skill sk) {
        return sk.getTargetType() == L2Skill.SkillTargetType.TARGET_PARTY;
    }

    protected class TargetAnalysis {
        public L2Character character;
        public boolean isMage;
        public boolean isBalanced;
        public boolean isArcher;
        public boolean isFighter;
        public boolean isCanceled;
        public boolean isSlower;
        public boolean isMagicResistant;

        public void update(L2Character target) {
            if (target == this.character && Rnd.nextInt(100) > 25) {
                return;
            }
            this.character = target;
            if (target == null) {
                return;
            }
            this.isMage = false;
            this.isBalanced = false;
            this.isArcher = false;
            this.isFighter = false;
            this.isCanceled = false;
            if ((double)target.getMAtk(null, null) > 1.5 * (double)target.getPAtk(null)) {
                this.isMage = true;
            } else if ((double)target.getPAtk(null) * 0.8 < (double)target.getMAtk(null, null) || (double)target.getMAtk(null, null) * 0.8 > (double)target.getPAtk(null)) {
                this.isBalanced = true;
            } else {
                L2Weapon weapon = target.getActiveWeaponItem();
                if (weapon != null && (weapon.getItemType() == L2WeaponType.BOW || weapon.getItemType() == L2WeaponType.CROSSBOW)) {
                    this.isArcher = true;
                } else {
                    this.isFighter = true;
                }
            }
            this.isSlower = target.getRunSpeed() < L2CharacterAI.this._actor.getRunSpeed() - 3;
            this.isMagicResistant = (double)target.getMDef(null, null) * 1.2 > (double)L2CharacterAI.this._actor.getMAtk(null, null);
            if (target.getBuffCount() < 4) {
                this.isCanceled = true;
            }
        }
    }

    protected class SelfAnalysis {
        public boolean isMage = false;
        public boolean isBalanced;
        public boolean isArcher = false;
        public boolean isHealer = false;
        public boolean isFighter = false;
        public boolean cannotMoveOnLand = false;
        public List<L2Skill> generalSkills = new FastList();
        public List<L2Skill> buffSkills = new FastList();
        public int lastBuffTick = 0;
        public List<L2Skill> debuffSkills = new FastList();
        public int lastDebuffTick = 0;
        public List<L2Skill> cancelSkills = new FastList();
        public List<L2Skill> healSkills = new FastList();
        public List<L2Skill> generalDisablers = new FastList();
        public List<L2Skill> sleepSkills = new FastList();
        public List<L2Skill> rootSkills = new FastList();
        public List<L2Skill> muteSkills = new FastList();
        public List<L2Skill> resurrectSkills = new FastList();
        public boolean hasHealOrResurrect = false;
        public boolean hasLongRangeSkills = false;
        public boolean hasLongRangeDamageSkills = false;
        public int maxCastRange = 0;

        public void init() {
            switch (((L2NpcTemplate)L2CharacterAI.this._actor.getTemplate()).getAIDataStatic().getAiType()) {
                case FIGHTER: {
                    this.isFighter = true;
                    break;
                }
                case MAGE: {
                    this.isMage = true;
                    break;
                }
                case CORPSE: 
                case BALANCED: {
                    this.isBalanced = true;
                    break;
                }
                case ARCHER: {
                    this.isArcher = true;
                    break;
                }
                case HEALER: {
                    this.isHealer = true;
                    break;
                }
                default: {
                    this.isFighter = true;
                }
            }
            if (L2CharacterAI.this._actor instanceof L2Npc) {
                int npcId = ((L2Npc)L2CharacterAI.this._actor).getNpcId();
                switch (npcId) {
                    case 20314: 
                    case 20849: {
                        this.cannotMoveOnLand = true;
                        break;
                    }
                    default: {
                        this.cannotMoveOnLand = false;
                    }
                }
            }
            block25: for (L2Skill sk : L2CharacterAI.this._actor.getAllSkills()) {
                if (sk.isPassive()) continue;
                int castRange = sk.getCastRange();
                boolean hasLongRangeDamageSkill = false;
                block10 : switch (sk.getSkillType()) {
                    case HEAL: 
                    case HEAL_PERCENT: 
                    case HEAL_STATIC: 
                    case BALANCE_LIFE: 
                    case HOT: {
                        this.healSkills.add(sk);
                        this.hasHealOrResurrect = true;
                        continue block25;
                    }
                    case BUFF: {
                        this.buffSkills.add(sk);
                        continue block25;
                    }
                    case PARALYZE: 
                    case STUN: {
                        switch (sk.getId()) {
                            case 367: 
                            case 4111: 
                            case 4383: 
                            case 4578: 
                            case 4616: {
                                this.sleepSkills.add(sk);
                                break block10;
                            }
                        }
                        this.generalDisablers.add(sk);
                        break;
                    }
                    case MUTE: {
                        this.muteSkills.add(sk);
                        break;
                    }
                    case SLEEP: {
                        this.sleepSkills.add(sk);
                        break;
                    }
                    case ROOT: {
                        this.rootSkills.add(sk);
                        break;
                    }
                    case FEAR: 
                    case CONFUSION: 
                    case DEBUFF: {
                        this.debuffSkills.add(sk);
                        break;
                    }
                    case CANCEL: 
                    case MAGE_BANE: 
                    case WARRIOR_BANE: 
                    case NEGATE: {
                        this.cancelSkills.add(sk);
                        break;
                    }
                    case RESURRECT: {
                        this.resurrectSkills.add(sk);
                        this.hasHealOrResurrect = true;
                        break;
                    }
                    case NOTDONE: 
                    case COREDONE: {
                        continue block25;
                    }
                    default: {
                        this.generalSkills.add(sk);
                        hasLongRangeDamageSkill = true;
                    }
                }
                if (castRange > 70) {
                    this.hasLongRangeSkills = true;
                    if (hasLongRangeDamageSkill) {
                        this.hasLongRangeDamageSkills = true;
                    }
                }
                if (castRange <= this.maxCastRange) continue;
                this.maxCastRange = castRange;
            }
            if (!this.hasLongRangeDamageSkills && this.isMage) {
                this.isBalanced = true;
                this.isMage = false;
                this.isFighter = false;
            }
            if (!this.hasLongRangeSkills && (this.isMage || this.isBalanced)) {
                this.isBalanced = false;
                this.isMage = false;
                this.isFighter = true;
            }
            if (this.generalSkills.isEmpty() && this.isMage) {
                this.isBalanced = true;
                this.isMage = false;
            }
        }
    }

    public class IntentionCommand {
        protected final CtrlIntention _crtlIntention;
        protected final Object _arg0;
        protected final Object _arg1;

        protected IntentionCommand(CtrlIntention pIntention, Object pArg0, Object pArg1) {
            this._crtlIntention = pIntention;
            this._arg0 = pArg0;
            this._arg1 = pArg1;
        }

        public CtrlIntention getCtrlIntention() {
            return this._crtlIntention;
        }
    }
}

