/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ArmorSetsTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Skill;
import gnu.trove.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Logger;
import javolution.util.FastList;

public class ResidentialSkillTable {
    private static Logger _log = Logger.getLogger(ArmorSetsTable.class.getName());
    private static ResidentialSkillTable _instance = null;
    private static TIntObjectHashMap<FastList<L2Skill>> _list;

    ResidentialSkillTable() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        _list = new TIntObjectHashMap();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * FROM skill_residential ORDER BY entityId");
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                int entityId = rs.getInt("entityId");
                int skillId = rs.getInt("skillId");
                int skillLvl = rs.getInt("skillLevel");
                L2Skill sk = SkillTable.getInstance().getInfo(skillId, skillLvl);
                if (sk == null) {
                    _log.warning("ResidentialSkillTable: SkillTable has returned null for ID/level: " + skillId + "/" + skillLvl);
                    continue;
                }
                if (!_list.containsKey(entityId)) {
                    FastList aux = new FastList();
                    aux.add((Object)sk);
                    _list.put(entityId, (Object)aux);
                    continue;
                }
                ((FastList)_list.get(entityId)).add((Object)sk);
            }
            statement.close();
            rs.close();
        }
        catch (Exception e) {
            _log.warning("ResidentialSkillTable: a problem occured while loading skills!");
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
            _log.info("ResidentialSkillTable: Loaded " + _list.size() + " entities with associated skills.");
        }
    }

    public FastList<L2Skill> getSkills(int entityId) {
        if (_list.containsKey(entityId)) {
            return (FastList)_list.get(entityId);
        }
        return null;
    }

    public static ResidentialSkillTable getInstance() {
        if (_instance == null) {
            _instance = new ResidentialSkillTable();
        }
        return _instance;
    }
}

