/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2TeleportLocation;
import gnu.trove.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TeleportLocationTable {
    private static Logger _log = Logger.getLogger(TeleportLocationTable.class.getName());
    private TIntObjectHashMap<L2TeleportLocation> _teleports;

    public static TeleportLocationTable getInstance() {
        return SingletonHolder._instance;
    }

    private TeleportLocationTable() {
        this.reloadAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAll() {
        L2TeleportLocation teleport;
        ResultSet rset;
        PreparedStatement statement;
        this._teleports = new TIntObjectHashMap();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT id, loc_x, loc_y, loc_z, price, fornoble FROM teleport");
            rset = statement.executeQuery();
            while (rset.next()) {
                teleport = new L2TeleportLocation();
                teleport.setTeleId(rset.getInt("id"));
                teleport.setLocX(rset.getInt("loc_x"));
                teleport.setLocY(rset.getInt("loc_y"));
                teleport.setLocZ(rset.getInt("loc_z"));
                teleport.setPrice(rset.getInt("price"));
                teleport.setIsForNoble(rset.getInt("fornoble") == 1);
                this._teleports.put(teleport.getTeleId(), (Object)teleport);
            }
            rset.close();
            statement.close();
            _log.config("TeleportLocationTable: Loaded " + this._teleports.size() + " Teleport Location Templates.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error loading Teleport Table.", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        if (Config.CUSTOM_TELEPORT_TABLE) {
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement("SELECT id, loc_x, loc_y, loc_z, price, fornoble FROM custom_teleport");
                rset = statement.executeQuery();
                int _cTeleCount = this._teleports.size();
                while (rset.next()) {
                    teleport = new L2TeleportLocation();
                    teleport.setTeleId(rset.getInt("id"));
                    teleport.setLocX(rset.getInt("loc_x"));
                    teleport.setLocY(rset.getInt("loc_y"));
                    teleport.setLocZ(rset.getInt("loc_z"));
                    teleport.setPrice(rset.getInt("price"));
                    teleport.setIsForNoble(rset.getInt("fornoble") == 1);
                    this._teleports.put(teleport.getTeleId(), (Object)teleport);
                }
                rset.close();
                statement.close();
                _cTeleCount = this._teleports.size() - _cTeleCount;
                if (_cTeleCount > 0) {
                    _log.config("TeleportLocationTable: Loaded " + _cTeleCount + " Custom Teleport Location Templates.");
                }
            }
            catch (Exception e) {
                _log.warning("error while creating custom teleport table " + e);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public L2TeleportLocation getTemplate(int id) {
        return (L2TeleportLocation)this._teleports.get(id);
    }

    private static class SingletonHolder {
        protected static final TeleportLocationTable _instance = new TeleportLocationTable();

        private SingletonHolder() {
        }
    }
}

