/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.L2Object;
import java.util.Map;
import javolution.util.FastMap;

public class DesireTable {
    public static final DesireType[] DEFAULT_DESIRES = new DesireType[]{DesireType.FEAR, DesireType.DISLIKE, DesireType.HATE, DesireType.DAMAGE};
    private Map<L2Object, Desires> _objectDesireTable;
    private Desires _generalDesires;
    private DesireType[] _desireTypes;

    public DesireTable(DesireType ... desireList) {
        this._desireTypes = desireList;
        this._objectDesireTable = new FastMap();
        this._generalDesires = new Desires(this._desireTypes);
    }

    public float getDesireValue(DesireType type) {
        return this._generalDesires.getDesireValue(type).getValue();
    }

    public float getDesireValue(L2Object object, DesireType type) {
        Desires desireList = this._objectDesireTable.get(object);
        if (desireList == null) {
            return 0.0f;
        }
        return desireList.getDesireValue(type).getValue();
    }

    public void addDesireValue(DesireType type, float value) {
        this._generalDesires.addValue(type, value);
    }

    public void addDesireValue(L2Object object, DesireType type, float value) {
        Desires desireList = this._objectDesireTable.get(object);
        if (desireList != null) {
            desireList.addValue(type, value);
        }
    }

    public void createDesire(DesireType type) {
        this._generalDesires.createDesire(type);
    }

    public void deleteDesire(DesireType type) {
        this._generalDesires.deleteDesire(type);
    }

    public void createDesire(L2Object object, DesireType type) {
        Desires desireList = this._objectDesireTable.get(object);
        if (desireList != null) {
            desireList.createDesire(type);
        }
    }

    public void deleteDesire(L2Object object, DesireType type) {
        Desires desireList = this._objectDesireTable.get(object);
        if (desireList != null) {
            desireList.deleteDesire(type);
        }
    }

    public void addKnownObject(L2Object object) {
        if (object != null) {
            this.addKnownObject(object, DesireType.DISLIKE, DesireType.FEAR, DesireType.DAMAGE, DesireType.HATE);
        }
    }

    public void addKnownObject(L2Object object, DesireType ... desireList) {
        if (object != null) {
            this._objectDesireTable.put(object, new Desires(desireList));
        }
    }

    class Desires {
        private Map<DesireType, DesireValue> _desireTable = new FastMap();

        public Desires(DesireType ... desireList) {
            for (DesireType desire : desireList) {
                this._desireTable.put(desire, new DesireValue());
            }
        }

        public DesireValue getDesireValue(DesireType type) {
            return this._desireTable.get((Object)type);
        }

        public void addValue(DesireType type, float value) {
            DesireValue temp = this.getDesireValue(type);
            if (temp != null) {
                temp.addValue(value);
            }
        }

        public void createDesire(DesireType type) {
            this._desireTable.put(type, new DesireValue());
        }

        public void deleteDesire(DesireType type) {
            this._desireTable.remove((Object)type);
        }
    }

    class DesireValue {
        private float _value;

        DesireValue() {
            this(Float.valueOf(0.0f));
        }

        DesireValue(Float pValue) {
            this._value = pValue.floatValue();
        }

        public void addValue(float pValue) {
            this._value += pValue;
        }

        public float getValue() {
            return this._value;
        }
    }

    public static enum DesireType {
        FEAR,
        DISLIKE,
        HATE,
        DAMAGE;

    }
}

