/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Auction;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Util;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javolution.util.FastMap;

public final class L2AuctioneerInstance
extends L2Npc {
    private static final int COND_ALL_FALSE = 0;
    private static final int COND_BUSY_BECAUSE_OF_SIEGE = 1;
    private static final int COND_REGULAR = 3;
    private Map<Integer, Auction> _pendingAuctions = new FastMap();

    public L2AuctioneerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2AuctioneerInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        int condition = this.validateCondition(player);
        if (condition <= 0) {
            player.sendMessage("Wrong conditions.");
            return;
        }
        if (condition == 1) {
            String filename = "data/html/auction/auction-busy.htm";
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(player.getHtmlPrefix(), filename);
            html.replace((CharSequence)"%objectId%", this.getObjectId());
            player.sendPacket(html);
            return;
        }
        if (condition == 3) {
            StringTokenizer st = new StringTokenizer(command, " ");
            String actualCommand = st.nextToken();
            String val = "";
            if (st.countTokens() >= 1) {
                val = st.nextToken();
            }
            if (actualCommand.equalsIgnoreCase("auction")) {
                if (val.isEmpty()) {
                    return;
                }
                try {
                    int days = Integer.parseInt(val);
                    try {
                        Auction a;
                        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                        long bid = 0L;
                        if (st.countTokens() >= 1) {
                            bid = Math.min(Long.parseLong(st.nextToken()), 99900000000L);
                        }
                        if (this._pendingAuctions.get((a = new Auction(player.getClan().getHasHideout(), player.getClan(), (long)days * 86400000L, bid, ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getName())).getId()) != null) {
                            this._pendingAuctions.remove(a.getId());
                        }
                        this._pendingAuctions.put(a.getId(), a);
                        String filename = "data/html/auction/AgitSale3.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace((CharSequence)"%x%", val);
                        html.replace((CharSequence)"%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                        html.replace((CharSequence)"%AGIT_AUCTION_MINBID%", Util.formatAdena(a.getStartingBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_MIN%", Util.formatAdena(a.getStartingBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_DESC%", ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getDesc());
                        html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_sale2");
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                        player.sendPacket(html);
                    }
                    catch (Exception e) {
                        player.sendMessage("Invalid bid!");
                    }
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction duration!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("confirmAuction")) {
                try {
                    Auction a = this._pendingAuctions.get(player.getClan().getHasHideout());
                    a.confirmAuction();
                    this._pendingAuctions.remove(player.getClan().getHasHideout());
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("bidding")) {
                if (val.isEmpty()) {
                    return;
                }
                if (Config.DEBUG) {
                    _log.warning("bidding show successful");
                }
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                    int auctionId = Integer.parseInt(val);
                    if (Config.DEBUG) {
                        _log.warning("auction test started");
                    }
                    String filename = "data/html/auction/AgitAuctionInfo.htm";
                    Auction a = AuctionManager.getInstance().getAuction(auctionId);
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), filename);
                    if (a != null) {
                        html.replace((CharSequence)"%AGIT_NAME%", a.getItemName());
                        html.replace((CharSequence)"%OWNER_PLEDGE_NAME%", a.getSellerClanName());
                        html.replace((CharSequence)"%OWNER_PLEDGE_MASTER%", a.getSellerName());
                        html.replace((CharSequence)"%AGIT_SIZE%", ClanHallManager.getInstance().getClanHallById(a.getItemId()).getGrade() * 10);
                        html.replace((CharSequence)"%AGIT_LEASE%", Util.formatAdena(ClanHallManager.getInstance().getClanHallById(a.getItemId()).getLease()));
                        html.replace((CharSequence)"%AGIT_LOCATION%", ClanHallManager.getInstance().getClanHallById(a.getItemId()).getLocName());
                        html.replace((CharSequence)"%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                        html.replace((CharSequence)"%AGIT_AUCTION_REMAIN%", (a.getEndDate() - System.currentTimeMillis()) / 3600000L + " \u6642\u9593 " + (a.getEndDate() - System.currentTimeMillis()) / 60000L % 60L + " \u5206");
                        html.replace((CharSequence)"%AGIT_AUCTION_MINBID%", Util.formatAdena(a.getStartingBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_COUNT%", a.getBidders().size());
                        html.replace((CharSequence)"%AGIT_AUCTION_DESC%", ClanHallManager.getInstance().getClanHallById(a.getItemId()).getDesc());
                        html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_list");
                        html.replace((CharSequence)"%AGIT_LINK_BIDLIST%", "bypass -h npc_" + this.getObjectId() + "_bidlist " + a.getId());
                        html.replace((CharSequence)"%AGIT_LINK_RE%", "bypass -h npc_" + this.getObjectId() + "_bid1 " + a.getId());
                    } else {
                        _log.warning("Auctioneer Auction null for AuctionId : " + auctionId);
                    }
                    player.sendPacket(html);
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("bid")) {
                if (val.isEmpty()) {
                    return;
                }
                try {
                    int auctionId = Integer.parseInt(val);
                    try {
                        long bid = 0L;
                        if (st.countTokens() >= 1) {
                            bid = Math.min(Long.parseLong(st.nextToken()), 99900000000L);
                        }
                        AuctionManager.getInstance().getAuction(auctionId).setBid(player, bid);
                    }
                    catch (Exception e) {
                        player.sendMessage("Invalid bid!");
                    }
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("bid1")) {
                if (player.getClan() == null || player.getClan().getLevel() < 2) {
                    player.sendPacket(new SystemMessage(SystemMessageId.AUCTION_ONLY_CLAN_LEVEL_2_HIGHER));
                    return;
                }
                if (val.isEmpty()) {
                    return;
                }
                if (player.getClan().getAuctionBiddedAt() > 0 && player.getClan().getAuctionBiddedAt() != Integer.parseInt(val) || player.getClan().getHasHideout() > 0) {
                    player.sendPacket(new SystemMessage(SystemMessageId.ALREADY_SUBMITTED_BID));
                    return;
                }
                try {
                    String filename = "data/html/auction/AgitBid1.htm";
                    long minimumBid = AuctionManager.getInstance().getAuction(Integer.parseInt(val)).getHighestBidderMaxBid();
                    if (minimumBid == 0L) {
                        minimumBid = AuctionManager.getInstance().getAuction(Integer.parseInt(val)).getStartingBid();
                    }
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_bidding " + val);
                    html.replace((CharSequence)"%PLEDGE_ADENA%", Util.formatAdena(player.getClan().getWarehouse().getAdena()));
                    html.replace((CharSequence)"%AGIT_AUCTION_MINBID%", Util.formatAdena(minimumBid));
                    html.replace((CharSequence)"npc_%objectId%_bid", "npc_" + this.getObjectId() + "_bid " + val);
                    player.sendPacket(html);
                    return;
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction!");
                    return;
                }
            }
            if (actualCommand.equalsIgnoreCase("list")) {
                int start;
                List<Auction> auctions = AuctionManager.getInstance().getAuctions();
                SimpleDateFormat format = new SimpleDateFormat("yy/MM/dd");
                int limit = 15;
                int i = 1;
                double npage = Math.ceil((float)auctions.size() / (float)limit);
                if (val.isEmpty()) {
                    start = 1;
                } else {
                    start = limit * (Integer.parseInt(val) - 1) + 1;
                    limit *= Integer.parseInt(val);
                }
                if (Config.DEBUG) {
                    _log.warning("cmd list: auction test started");
                }
                StringBuilder items = new StringBuilder();
                items.append("<table width=280 border=0><tr>");
                int j = 1;
                while ((double)j <= npage) {
                    items.append("<td><center><a action=\"bypass -h npc_").append(this.getObjectId()).append("_list ").append(j).append("\"> Page ").append(j).append(" </a></center></td>");
                    ++j;
                }
                items.append("</tr></table><table width=280 border=0>");
                for (Auction a : auctions) {
                    if (a == null) continue;
                    if (i > limit) break;
                    if (i < start) {
                        ++i;
                        continue;
                    }
                    ++i;
                    items.append("<tr><td>").append(ClanHallManager.getInstance().getClanHallById(a.getItemId()).getLocName()).append("</td><td><a action=\"bypass -h npc_").append(this.getObjectId()).append("_bidding ").append(a.getId()).append("\">").append(a.getItemName()).append("</a></td><td>").append(format.format(a.getEndDate())).append("</td><td>").append(Util.formatAdena(a.getStartingBid())).append("</td></tr>");
                }
                items.append("</table>");
                String filename = "data/html/auction/AgitAuctionList.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(1);
                html.setFile(player.getHtmlPrefix(), filename);
                html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                html.replace((CharSequence)"%itemsField%", items);
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("bidlist")) {
                int auctionId = 0;
                if (val.isEmpty()) {
                    if (player.getClan().getAuctionBiddedAt() <= 0) {
                        return;
                    }
                    auctionId = player.getClan().getAuctionBiddedAt();
                } else {
                    auctionId = Integer.parseInt(val);
                }
                if (Config.DEBUG) {
                    _log.warning("cmd bidlist: auction test started");
                }
                StringBuilder biders = new StringBuilder();
                Map<Integer, Auction.Bidder> bidders = AuctionManager.getInstance().getAuction(auctionId).getBidders();
                for (Auction.Bidder b : bidders.values()) {
                    biders.append("<tr><td>").append(b.getClanName()).append("</td><td>").append(b.getName()).append("</td><td>").append(b.getTimeBid().get(1)).append('/').append(b.getTimeBid().get(2) + 1).append('/').append(b.getTimeBid().get(5)).append("</td><td>").append(Util.formatAdena(b.getBid())).append("</td></tr>");
                }
                String filename = "data/html/auction/AgitBidderList.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(1);
                html.setFile(player.getHtmlPrefix(), filename);
                html.replace((CharSequence)"%AGIT_LIST%", biders);
                html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                html.replace((CharSequence)"%x%", val);
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("selectedItems")) {
                if (player.getClan() != null && player.getClan().getHasHideout() == 0 && player.getClan().getAuctionBiddedAt() > 0) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                    String filename = "data/html/auction/AgitBidInfo.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), filename);
                    Auction a = AuctionManager.getInstance().getAuction(player.getClan().getAuctionBiddedAt());
                    if (a != null) {
                        html.replace((CharSequence)"%AGIT_NAME%", a.getItemName());
                        html.replace((CharSequence)"%OWNER_PLEDGE_NAME%", a.getSellerClanName());
                        html.replace((CharSequence)"%OWNER_PLEDGE_MASTER%", a.getSellerName());
                        html.replace((CharSequence)"%AGIT_SIZE%", ClanHallManager.getInstance().getClanHallById(a.getItemId()).getGrade() * 10);
                        html.replace((CharSequence)"%AGIT_LEASE%", Util.formatAdena(ClanHallManager.getInstance().getClanHallById(a.getItemId()).getLease()));
                        html.replace((CharSequence)"%AGIT_LOCATION%", ClanHallManager.getInstance().getClanHallById(a.getItemId()).getLocName());
                        html.replace((CharSequence)"%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                        html.replace((CharSequence)"%AGIT_AUCTION_REMAIN%", (a.getEndDate() - System.currentTimeMillis()) / 3600000L + " \u6642\u9593 " + (a.getEndDate() - System.currentTimeMillis()) / 60000L % 60L + " \u5206");
                        html.replace((CharSequence)"%AGIT_AUCTION_MINBID%", Util.formatAdena(a.getStartingBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_MYBID%", Util.formatAdena(a.getBidders().get(player.getClanId()).getBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_DESC%", ClanHallManager.getInstance().getClanHallById(a.getItemId()).getDesc());
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                        html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                    } else {
                        _log.warning("Auctioneer Auction null for AuctionBiddedAt : " + player.getClan().getAuctionBiddedAt());
                    }
                    player.sendPacket(html);
                    return;
                }
                if (player.getClan() != null && AuctionManager.getInstance().getAuction(player.getClan().getHasHideout()) != null) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                    String filename = "data/html/auction/AgitSaleInfo.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), filename);
                    Auction a = AuctionManager.getInstance().getAuction(player.getClan().getHasHideout());
                    if (a != null) {
                        html.replace((CharSequence)"%AGIT_NAME%", a.getItemName());
                        html.replace((CharSequence)"%AGIT_OWNER_PLEDGE_NAME%", a.getSellerClanName());
                        html.replace((CharSequence)"%OWNER_PLEDGE_MASTER%", a.getSellerName());
                        html.replace((CharSequence)"%AGIT_SIZE%", ClanHallManager.getInstance().getClanHallById(a.getItemId()).getGrade() * 10);
                        html.replace((CharSequence)"%AGIT_LEASE%", Util.formatAdena(ClanHallManager.getInstance().getClanHallById(a.getItemId()).getLease()));
                        html.replace((CharSequence)"%AGIT_LOCATION%", ClanHallManager.getInstance().getClanHallById(a.getItemId()).getLocName());
                        html.replace((CharSequence)"%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                        html.replace((CharSequence)"%AGIT_AUCTION_REMAIN%", (a.getEndDate() - System.currentTimeMillis()) / 3600000L + " \u6642\u9593 " + (a.getEndDate() - System.currentTimeMillis()) / 60000L % 60L + " \u5206");
                        html.replace((CharSequence)"%AGIT_AUCTION_MINBID%", Util.formatAdena(a.getStartingBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_BIDCOUNT%", a.getBidders().size());
                        html.replace((CharSequence)"%AGIT_AUCTION_DESC%", ClanHallManager.getInstance().getClanHallById(a.getItemId()).getDesc());
                        html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                        html.replace((CharSequence)"%id%", a.getId());
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                    } else {
                        _log.warning("Auctioneer Auction null for getHasHideout : " + player.getClan().getHasHideout());
                    }
                    player.sendPacket(html);
                    return;
                }
                if (player.getClan() != null && player.getClan().getHasHideout() != 0) {
                    int ItemId = player.getClan().getHasHideout();
                    String filename = "data/html/auction/AgitInfo.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), filename);
                    if (ClanHallManager.getInstance().getClanHallById(ItemId) != null) {
                        html.replace((CharSequence)"%AGIT_NAME%", ClanHallManager.getInstance().getClanHallById(ItemId).getName());
                        html.replace((CharSequence)"%AGIT_OWNER_PLEDGE_NAME%", player.getClan().getName());
                        html.replace((CharSequence)"%OWNER_PLEDGE_MASTER%", player.getClan().getLeaderName());
                        html.replace((CharSequence)"%AGIT_SIZE%", ClanHallManager.getInstance().getClanHallById(ItemId).getGrade() * 10);
                        html.replace((CharSequence)"%AGIT_LEASE%", Util.formatAdena(ClanHallManager.getInstance().getClanHallById(ItemId).getLease()));
                        html.replace((CharSequence)"%AGIT_LOCATION%", ClanHallManager.getInstance().getClanHallById(ItemId).getLocName());
                        html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                    } else {
                        _log.warning("Clan Hall ID NULL : " + ItemId + " Can be caused by concurent write in ClanHallManager");
                    }
                    player.sendPacket(html);
                    return;
                }
                if (player.getClan() != null && player.getClan().getHasHideout() == 0) {
                    player.sendPacket(new SystemMessage(SystemMessageId.NO_OFFERINGS_OWN_OR_MADE_BID_FOR));
                    return;
                }
                if (player.getClan() == null) {
                    player.sendPacket(new SystemMessage(SystemMessageId.CANNOT_PARTICIPATE_IN_AN_AUCTION));
                    return;
                }
            } else {
                if (actualCommand.equalsIgnoreCase("cancelBid")) {
                    long bid = AuctionManager.getInstance().getAuction(player.getClan().getAuctionBiddedAt()).getBidders().get(player.getClanId()).getBid();
                    String filename = "data/html/auction/AgitBidCancel.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace((CharSequence)"%AGIT_BID%", Util.formatAdena(bid));
                    html.replace((CharSequence)"%AGIT_BID_REMAIN%", Util.formatAdena((long)((double)bid * 0.9)));
                    html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    player.sendPacket(html);
                    return;
                }
                if (actualCommand.equalsIgnoreCase("doCancelBid")) {
                    if (AuctionManager.getInstance().getAuction(player.getClan().getAuctionBiddedAt()) != null) {
                        AuctionManager.getInstance().getAuction(player.getClan().getAuctionBiddedAt()).cancelBid(player.getClanId());
                        player.sendPacket(new SystemMessage(SystemMessageId.CANCELED_BID));
                    }
                    return;
                }
                if (actualCommand.equalsIgnoreCase("cancelAuction")) {
                    if ((player.getClanPrivileges() & 0x2000) != 8192) {
                        String filename = "data/html/auction/not_authorized.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                        player.sendPacket(html);
                        return;
                    }
                    String filename = "data/html/auction/AgitSaleCancel.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace((CharSequence)"%AGIT_DEPOSIT%", Util.formatAdena(ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getLease()));
                    html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    player.sendPacket(html);
                    return;
                }
                if (actualCommand.equalsIgnoreCase("doCancelAuction")) {
                    if (AuctionManager.getInstance().getAuction(player.getClan().getHasHideout()) != null) {
                        AuctionManager.getInstance().getAuction(player.getClan().getHasHideout()).cancelAuction();
                        player.sendMessage("Your auction has been canceled");
                    }
                    return;
                }
                if (actualCommand.equalsIgnoreCase("sale2")) {
                    String filename = "data/html/auction/AgitSale2.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace((CharSequence)"%AGIT_LAST_PRICE%", Util.formatAdena(ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getLease()));
                    html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_sale");
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    player.sendPacket(html);
                    return;
                }
                if (actualCommand.equalsIgnoreCase("sale")) {
                    if ((player.getClanPrivileges() & 0x2000) != 8192) {
                        String filename = "data/html/auction/not_authorized.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                        player.sendPacket(html);
                        return;
                    }
                    String filename = "data/html/auction/AgitSale1.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace((CharSequence)"%AGIT_DEPOSIT%", Util.formatAdena(ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getLease()));
                    html.replace((CharSequence)"%AGIT_PLEDGE_ADENA%", Util.formatAdena(player.getClan().getWarehouse().getAdena()));
                    html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    player.sendPacket(html);
                    return;
                }
                if (actualCommand.equalsIgnoreCase("rebid")) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                    if ((player.getClanPrivileges() & 0x2000) != 8192) {
                        String filename = "data/html/auction/not_authorized.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                        player.sendPacket(html);
                        return;
                    }
                    try {
                        String filename = "data/html/auction/AgitBid2.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), filename);
                        Auction a = AuctionManager.getInstance().getAuction(player.getClan().getAuctionBiddedAt());
                        if (a != null) {
                            html.replace((CharSequence)"%AGIT_AUCTION_BID%", Util.formatAdena(a.getBidders().get(player.getClanId()).getBid()));
                            html.replace((CharSequence)"%AGIT_AUCTION_MINBID%", Util.formatAdena(a.getStartingBid()));
                            html.replace((CharSequence)"%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                            html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                            html.replace((CharSequence)"npc_%objectId%_bid1", "npc_" + this.getObjectId() + "_bid1 " + a.getId());
                        } else {
                            _log.warning("Auctioneer Auction null for AuctionBiddedAt : " + player.getClan().getAuctionBiddedAt());
                        }
                        player.sendPacket(html);
                    }
                    catch (Exception e) {
                        player.sendMessage("Invalid auction!");
                    }
                    return;
                }
                if (actualCommand.equalsIgnoreCase("location")) {
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), "data/html/auction/location.htm");
                    html.replace((CharSequence)"%location%", MapRegionTable.getInstance().getClosestTownName(player));
                    html.replace((CharSequence)"%LOCATION%", this.getPictureName(player));
                    html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                    player.sendPacket(html);
                    return;
                }
                if (actualCommand.equalsIgnoreCase("start")) {
                    this.showChatWindow(player);
                    return;
                }
            }
        }
        super.onBypassFeedback(player, command);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        String filename = "data/html/auction/auction-no.htm";
        int condition = this.validateCondition(player);
        filename = condition == 1 ? "data/html/auction/auction-busy.htm" : "data/html/auction/auction.htm";
        NpcHtmlMessage html = new NpcHtmlMessage(1);
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcId%", this.getNpcId());
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    private int validateCondition(L2PcInstance player) {
        if (this.getCastle() != null && this.getCastle().getCastleId() > 0) {
            if (this.getCastle().getSiege().getIsInProgress()) {
                return 1;
            }
            return 3;
        }
        return 0;
    }

    private String getPictureName(L2PcInstance plyr) {
        String nearestTown;
        int nearestTownId = MapRegionTable.getInstance().getMapRegion(plyr.getX(), plyr.getY());
        switch (nearestTownId) {
            case 5: {
                nearestTown = "GLUDIO";
                break;
            }
            case 6: {
                nearestTown = "GLUDIN";
                break;
            }
            case 7: {
                nearestTown = "DION";
                break;
            }
            case 8: {
                nearestTown = "GIRAN";
                break;
            }
            case 14: {
                nearestTown = "RUNE";
                break;
            }
            case 15: {
                nearestTown = "GODARD";
                break;
            }
            case 16: {
                nearestTown = "SCHUTTGART";
                break;
            }
            default: {
                nearestTown = "ADEN";
            }
        }
        return nearestTown;
    }
}

