/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Trap;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2TrapInstance
extends L2Trap {
    private L2PcInstance _owner;
    private int _level;
    private boolean _isInArena = false;

    public L2TrapInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, int lifeTime, L2Skill skill) {
        super(objectId, template, lifeTime, skill);
        this.setInstanceType(L2Object.InstanceType.L2TrapInstance);
        this.setInstanceId(owner.getInstanceId());
        this._owner = owner;
        this._level = owner.getLevel();
    }

    @Override
    public int getLevel() {
        return this._level;
    }

    @Override
    public L2PcInstance getOwner() {
        return this._owner;
    }

    @Override
    public L2PcInstance getActingPlayer() {
        return this._owner;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this._isInArena = this.isInsideZone((byte)0) && !this.isInsideZone((byte)2);
    }

    @Override
    public void deleteMe() {
        if (this._owner != null) {
            this._owner.setTrap(null);
            this._owner = null;
        }
        super.deleteMe();
    }

    @Override
    public void unSummon() {
        if (this._owner != null) {
            this._owner.setTrap(null);
            this._owner = null;
        }
        super.unSummon();
    }

    @Override
    public int getKarma() {
        return this._owner != null ? this._owner.getKarma() : 0;
    }

    @Override
    public byte getPvpFlag() {
        return this._owner != null ? this._owner.getPvpFlag() : (byte)0;
    }

    @Override
    public void sendDamageMessage(L2Character target, int damage, boolean mcrit, boolean pcrit, boolean miss) {
        SystemMessage sm;
        if (miss || this._owner == null) {
            return;
        }
        if (this._owner.isInOlympiadMode() && target instanceof L2PcInstance && ((L2PcInstance)target).isInOlympiadMode() && ((L2PcInstance)target).getOlympiadGameId() == this._owner.getOlympiadGameId()) {
            Olympiad.getInstance().notifyCompetitorDamage(this.getOwner(), damage, this.getOwner().getOlympiadGameId());
        }
        if (target.isInvul() && !(target instanceof L2NpcInstance)) {
            sm = new SystemMessage(SystemMessageId.ATTACK_WAS_BLOCKED);
        } else {
            sm = new SystemMessage(SystemMessageId.C1_GAVE_C2_DAMAGE_OF_S3);
            sm.addCharName(this);
            sm.addCharName(target);
            sm.addNumber(damage);
        }
        this._owner.sendPacket(sm);
    }

    @Override
    public boolean canSee(L2Character cha) {
        if (this._owner == null || cha == null) {
            return false;
        }
        if (cha == this._owner) {
            return true;
        }
        return this._owner.isInParty() && cha.isInParty() && this._owner.getParty().getPartyLeaderOID() == cha.getParty().getPartyLeaderOID();
    }

    @Override
    public void setDetected(L2Character detector) {
        if (this._isInArena) {
            super.setDetected(detector);
            return;
        }
        if (this._owner == null || this._owner.getPvpFlag() == 0 && this._owner.getKarma() == 0) {
            return;
        }
        super.setDetected(detector);
    }

    @Override
    protected boolean checkTarget(L2Character target) {
        L2PcInstance player;
        if (!L2Skill.checkForAreaOffensiveSkills(this, target, this.getSkill(), this._isInArena)) {
            return false;
        }
        if (this._isInArena) {
            return true;
        }
        return !(target instanceof L2Playable) || (player = target.getActingPlayer()) != null && (player.getPvpFlag() != 0 || player.getKarma() != 0);
    }
}

