/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.ObjectKnownList;
import com.l2jserver.gameserver.util.Util;
import java.util.Collection;
import java.util.Map;
import javolution.util.FastList;
import javolution.util.FastMap;

public class CharKnownList
extends ObjectKnownList {
    private Map<Integer, L2PcInstance> _knownPlayers;
    private Map<Integer, L2Summon> _knownSummons;
    private Map<Integer, Integer> _knownRelations;

    public CharKnownList(L2Character activeChar) {
        super(activeChar);
    }

    @Override
    public boolean addKnownObject(L2Object object) {
        if (!super.addKnownObject(object)) {
            return false;
        }
        if (object instanceof L2PcInstance) {
            this.getKnownPlayers().put(object.getObjectId(), (L2PcInstance)object);
            this.getKnownRelations().put(object.getObjectId(), -1);
        } else if (object instanceof L2Summon) {
            this.getKnownSummons().put(object.getObjectId(), (L2Summon)object);
        }
        return true;
    }

    public final boolean knowsThePlayer(L2PcInstance player) {
        return this.getActiveChar() == player || this.getKnownPlayers().containsKey(player.getObjectId());
    }

    @Override
    public final void removeAllKnownObjects() {
        super.removeAllKnownObjects();
        this.getKnownPlayers().clear();
        this.getKnownRelations().clear();
        this.getKnownSummons().clear();
        this.getActiveChar().setTarget(null);
        if (this.getActiveChar().hasAI()) {
            this.getActiveChar().setAI(null);
        }
    }

    @Override
    public boolean removeKnownObject(L2Object object) {
        if (!super.removeKnownObject(object)) {
            return false;
        }
        if (object instanceof L2PcInstance) {
            this.getKnownPlayers().remove(object.getObjectId());
            this.getKnownRelations().remove(object.getObjectId());
        } else if (object instanceof L2Summon) {
            this.getKnownSummons().remove(object.getObjectId());
        }
        if (object == this.getActiveChar().getTarget()) {
            this.getActiveChar().setTarget(null);
        }
        return true;
    }

    @Override
    public void forgetObjects(boolean fullCheck) {
        if (!fullCheck) {
            Collection<L2PcInstance> plrs = this.getKnownPlayers().values();
            for (L2PcInstance player : plrs) {
                if (player.isVisible() && Util.checkIfInShortRadius(this.getDistanceToForgetObject(player), this.getActiveObject(), player, true)) continue;
                this.removeKnownObject(player);
            }
            Collection<L2Summon> sums = this.getKnownSummons().values();
            for (L2Summon summon : sums) {
                if (summon.isVisible() && Util.checkIfInShortRadius(this.getDistanceToForgetObject(summon), this.getActiveObject(), summon, true)) continue;
                this.removeKnownObject(summon);
            }
            return;
        }
        Collection<L2Object> objs = this.getKnownObjects().values();
        for (L2Object object : objs) {
            if (object.isVisible() && Util.checkIfInShortRadius(this.getDistanceToForgetObject(object), this.getActiveObject(), object, true)) continue;
            if (object instanceof L2BoatInstance && this.getActiveObject() instanceof L2PcInstance) {
                if (((L2BoatInstance)object).getVehicleDeparture() == null) continue;
                if (((L2PcInstance)this.getActiveObject()).isInBoat()) {
                    if (((L2PcInstance)this.getActiveObject()).getBoat() == object) continue;
                    this.removeKnownObject(object);
                    continue;
                }
                this.removeKnownObject(object);
                continue;
            }
            if (object instanceof L2AirShipInstance && this.getActiveObject() instanceof L2PcInstance) {
                if (((L2AirShipInstance)object).getAirShipInfo() == null) continue;
                if (((L2PcInstance)this.getActiveObject()).isInAirShip()) {
                    if (((L2PcInstance)this.getActiveObject()).getAirShip() == object) continue;
                    this.removeKnownObject(object);
                    continue;
                }
                this.removeKnownObject(object);
                continue;
            }
            this.removeKnownObject(object);
        }
    }

    public L2Character getActiveChar() {
        return (L2Character)super.getActiveObject();
    }

    @Override
    public int getDistanceToForgetObject(L2Object object) {
        return 0;
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        return 0;
    }

    public Collection<L2Character> getKnownCharacters() {
        FastList result = new FastList();
        Collection<L2Object> objs = this.getKnownObjects().values();
        for (L2Object obj : objs) {
            if (!(obj instanceof L2Character)) continue;
            result.add((Object)((L2Character)obj));
        }
        return result;
    }

    public Collection<L2Character> getKnownCharactersInRadius(long radius) {
        FastList result = new FastList();
        Collection<L2Object> objs = this.getKnownObjects().values();
        if (objs != null && !objs.isEmpty()) {
            for (L2Object obj : objs) {
                if (!(obj instanceof L2Character) || !Util.checkIfInRange((int)radius, this.getActiveChar(), obj, true)) continue;
                result.add((Object)((L2Character)obj));
            }
        }
        return result;
    }

    public final Map<Integer, L2PcInstance> getKnownPlayers() {
        if (this._knownPlayers == null) {
            this._knownPlayers = new FastMap().shared();
        }
        return this._knownPlayers;
    }

    public final Map<Integer, Integer> getKnownRelations() {
        if (this._knownRelations == null) {
            this._knownRelations = new FastMap().shared();
        }
        return this._knownRelations;
    }

    public final Map<Integer, L2Summon> getKnownSummons() {
        if (this._knownSummons == null) {
            this._knownSummons = new FastMap().shared();
        }
        return this._knownSummons;
    }

    public final Collection<L2PcInstance> getKnownPlayersInRadius(long radius) {
        FastList result = new FastList();
        Collection<L2PcInstance> plrs = this.getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (!Util.checkIfInRange((int)radius, this.getActiveChar(), player, true)) continue;
            result.add((Object)player);
        }
        return result;
    }
}

