/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.util.Util;
import java.util.Collection;
import java.util.Map;
import javolution.util.FastMap;

public class ObjectKnownList {
    private L2Object _activeObject;
    private Map<Integer, L2Object> _knownObjects;

    public ObjectKnownList(L2Object activeObject) {
        this._activeObject = activeObject;
    }

    public boolean addKnownObject(L2Object object) {
        if (object == null) {
            return false;
        }
        if (this.getActiveObject().getInstanceId() != -1 && object.getInstanceId() != this.getActiveObject().getInstanceId()) {
            return false;
        }
        if (object instanceof L2PcInstance && ((L2PcInstance)object).getAppearance().isGhost()) {
            return false;
        }
        if (this.knowsObject(object)) {
            return false;
        }
        if (!Util.checkIfInShortRadius(this.getDistanceToWatchObject(object), this.getActiveObject(), object, true)) {
            return false;
        }
        return this.getKnownObjects().put(object.getObjectId(), object) == null;
    }

    public final boolean knowsObject(L2Object object) {
        if (object == null) {
            return false;
        }
        return this.getActiveObject() == object || this.getKnownObjects().containsKey(object.getObjectId());
    }

    public void removeAllKnownObjects() {
        this.getKnownObjects().clear();
    }

    public boolean removeKnownObject(L2Object object) {
        if (object == null) {
            return false;
        }
        return this.getKnownObjects().remove(object.getObjectId()) != null;
    }

    public final void findObjects() {
        block6: {
            L2WorldRegion region;
            block5: {
                region = this.getActiveObject().getWorldRegion();
                if (region == null) {
                    return;
                }
                if (!(this.getActiveObject() instanceof L2Playable)) break block5;
                for (L2WorldRegion regi : region.getSurroundingRegions()) {
                    Collection<L2Object> vObj = regi.getVisibleObjects().values();
                    for (L2Object _object : vObj) {
                        if (_object == this.getActiveObject()) continue;
                        this.addKnownObject(_object);
                        if (!(_object instanceof L2Character)) continue;
                        _object.getKnownList().addKnownObject(this.getActiveObject());
                    }
                }
                break block6;
            }
            if (!(this.getActiveObject() instanceof L2Character)) break block6;
            for (L2WorldRegion regi : region.getSurroundingRegions()) {
                if (!regi.isActive().booleanValue()) continue;
                Collection<L2Playable> vPls = regi.getVisiblePlayable().values();
                for (L2Playable _object : vPls) {
                    if (_object == this.getActiveObject()) continue;
                    this.addKnownObject(_object);
                }
            }
        }
    }

    public void forgetObjects(boolean fullCheck) {
        Collection<L2Object> objs = this.getKnownObjects().values();
        for (L2Object object : objs) {
            if (!fullCheck && !(object instanceof L2Playable) || object.isVisible() && Util.checkIfInShortRadius(this.getDistanceToForgetObject(object), this.getActiveObject(), object, true)) continue;
            if (object instanceof L2BoatInstance && this.getActiveObject() instanceof L2PcInstance) {
                if (((L2BoatInstance)object).getVehicleDeparture() == null) continue;
                if (((L2PcInstance)this.getActiveObject()).isInBoat()) {
                    if (((L2PcInstance)this.getActiveObject()).getBoat() == object) continue;
                    this.removeKnownObject(object);
                    continue;
                }
                this.removeKnownObject(object);
                continue;
            }
            this.removeKnownObject(object);
        }
    }

    public L2Object getActiveObject() {
        return this._activeObject;
    }

    public int getDistanceToForgetObject(L2Object object) {
        return 0;
    }

    public int getDistanceToWatchObject(L2Object object) {
        return 0;
    }

    public final Map<Integer, L2Object> getKnownObjects() {
        if (this._knownObjects == null) {
            this._knownObjects = new FastMap().shared();
        }
        return this._knownObjects;
    }
}

