/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.templates.StatsSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class Hero {
    private static Logger _log = Logger.getLogger(Hero.class.getName());
    private static final String GET_HEROES = "SELECT heroes.charId, characters.char_name, heroes.class_id, heroes.count, heroes.played FROM heroes, characters WHERE characters.charId = heroes.charId AND heroes.played = 1";
    private static final String GET_ALL_HEROES = "SELECT heroes.charId, characters.char_name, heroes.class_id, heroes.count, heroes.played FROM heroes, characters WHERE characters.charId = heroes.charId";
    private static final String UPDATE_ALL = "UPDATE heroes SET played = 0";
    private static final String INSERT_HERO = "INSERT INTO heroes VALUES (?,?,?,?)";
    private static final String UPDATE_HERO = "UPDATE heroes SET count = ?, played = ? WHERE charId = ?";
    private static final String GET_CLAN_ALLY = "SELECT characters.clanid AS clanid, coalesce(clan_data.ally_Id, 0) AS allyId FROM characters LEFT JOIN clan_data ON clan_data.clan_id = characters.clanid WHERE characters.charId = ?";
    private static final String GET_CLAN_NAME = "SELECT clan_name FROM clan_data WHERE clan_id = (SELECT clanid FROM characters WHERE char_name = ?)";
    private static final String DELETE_ITEMS = "DELETE FROM items WHERE item_id IN (6842, 6611, 6612, 6613, 6614, 6615, 6616, 6617, 6618, 6619, 6620, 6621, 9388, 9389, 9390) AND owner_id NOT IN (SELECT charId FROM characters WHERE accesslevel > 0)";
    private static Map<Integer, StatsSet> _heroes;
    private static Map<Integer, StatsSet> _completeHeroes;
    public static final String COUNT = "count";
    public static final String PLAYED = "played";
    public static final String CLAN_NAME = "clan_name";
    public static final String CLAN_CREST = "clan_crest";
    public static final String ALLY_NAME = "ally_name";
    public static final String ALLY_CREST = "ally_crest";

    public static Hero getInstance() {
        return SingletonHolder._instance;
    }

    private Hero() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        _heroes = new FastMap();
        _completeHeroes = new FastMap();
        Connection con = null;
        Connection con2 = null;
        try {
            int allyCrest;
            int clanCrest;
            String allyName;
            String clanName;
            int allyId;
            int clanId;
            ResultSet rset2;
            PreparedStatement statement2;
            int charId;
            StatsSet hero;
            con = L2DatabaseFactory.getInstance().getConnection();
            con2 = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(GET_HEROES);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                hero = new StatsSet();
                charId = rset.getInt("charId");
                hero.set("char_name", rset.getString("char_name"));
                hero.set("class_id", rset.getInt("class_id"));
                hero.set(COUNT, rset.getInt(COUNT));
                hero.set(PLAYED, rset.getInt(PLAYED));
                statement2 = con2.prepareStatement(GET_CLAN_ALLY);
                statement2.setInt(1, charId);
                rset2 = statement2.executeQuery();
                if (rset2.next()) {
                    clanId = rset2.getInt("clanid");
                    allyId = rset2.getInt("allyId");
                    clanName = "";
                    allyName = "";
                    clanCrest = 0;
                    allyCrest = 0;
                    if (clanId > 0) {
                        clanName = ClanTable.getInstance().getClan(clanId).getName();
                        clanCrest = ClanTable.getInstance().getClan(clanId).getCrestId();
                        if (allyId > 0) {
                            allyName = ClanTable.getInstance().getClan(clanId).getAllyName();
                            allyCrest = ClanTable.getInstance().getClan(clanId).getAllyCrestId();
                        }
                    }
                    hero.set(CLAN_CREST, clanCrest);
                    hero.set(CLAN_NAME, clanName);
                    hero.set(ALLY_CREST, allyCrest);
                    hero.set(ALLY_NAME, allyName);
                }
                rset2.close();
                statement2.close();
                _heroes.put(charId, hero);
            }
            rset.close();
            statement.close();
            statement = con.prepareStatement(GET_ALL_HEROES);
            rset = statement.executeQuery();
            while (rset.next()) {
                hero = new StatsSet();
                charId = rset.getInt("charId");
                hero.set("char_name", rset.getString("char_name"));
                hero.set("class_id", rset.getInt("class_id"));
                hero.set(COUNT, rset.getInt(COUNT));
                hero.set(PLAYED, rset.getInt(PLAYED));
                statement2 = con2.prepareStatement(GET_CLAN_ALLY);
                statement2.setInt(1, charId);
                rset2 = statement2.executeQuery();
                if (rset2.next()) {
                    clanId = rset2.getInt("clanid");
                    allyId = rset2.getInt("allyId");
                    clanName = "";
                    allyName = "";
                    clanCrest = 0;
                    allyCrest = 0;
                    if (clanId > 0) {
                        clanName = ClanTable.getInstance().getClan(clanId).getName();
                        clanCrest = ClanTable.getInstance().getClan(clanId).getCrestId();
                        if (allyId > 0) {
                            allyName = ClanTable.getInstance().getClan(clanId).getAllyName();
                            allyCrest = ClanTable.getInstance().getClan(clanId).getAllyCrestId();
                        }
                    }
                    hero.set(CLAN_CREST, clanCrest);
                    hero.set(CLAN_NAME, clanName);
                    hero.set(ALLY_CREST, allyCrest);
                    hero.set(ALLY_NAME, allyName);
                }
                rset2.close();
                statement2.close();
                _completeHeroes.put(charId, hero);
            }
            rset.close();
            statement.close();
        }
        catch (SQLException e) {
            _log.warning("Hero System: Couldnt load Heroes");
            if (Config.DEBUG) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                con.close();
                con2.close();
            }
            catch (Exception e) {}
        }
        _log.info("Hero System: Loaded " + _heroes.size() + " Heroes.");
        _log.info("Hero System: Loaded " + _completeHeroes.size() + " all time Heroes.");
    }

    public Map<Integer, StatsSet> getHeroes() {
        return _heroes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void computeNewHeroes(List<StatsSet> newHeroes) {
        this.updateHeroes(true);
        if (!_heroes.isEmpty()) {
            for (StatsSet hero : _heroes.values()) {
                String name = hero.getString("char_name");
                L2PcInstance player = L2World.getInstance().getPlayer(name);
                if (player == null) continue;
                try {
                    player.setHero(false);
                    for (int i = 0; i < 31; ++i) {
                        L2ItemInstance equippedItem = player.getInventory().getPaperdollItem(i);
                        if (equippedItem == null || !equippedItem.isHeroItem()) continue;
                        player.getInventory().unEquipItemInSlotAndRecord(i);
                    }
                    for (L2ItemInstance item : player.getInventory().getAvailableItems(false, false)) {
                        if (item == null || !item.isHeroItem()) continue;
                        player.destroyItem("Hero", item, null, true);
                        InventoryUpdate iu = new InventoryUpdate();
                        iu.addRemovedItem(item);
                        player.sendPacket(iu);
                    }
                    player.broadcastUserInfo();
                }
                catch (NullPointerException e) {}
            }
        }
        if (newHeroes.isEmpty()) {
            _heroes.clear();
            return;
        }
        FastMap heroes = new FastMap();
        for (StatsSet hero : newHeroes) {
            int charId = hero.getInteger("charId");
            if (_completeHeroes != null && _completeHeroes.containsKey(charId)) {
                StatsSet oldHero = _completeHeroes.get(charId);
                int count = oldHero.getInteger(COUNT);
                oldHero.set(COUNT, count + 1);
                oldHero.set(PLAYED, 1);
                heroes.put(charId, oldHero);
                continue;
            }
            StatsSet newHero = new StatsSet();
            newHero.set("char_name", hero.getString("char_name"));
            newHero.set("class_id", hero.getInteger("class_id"));
            newHero.set(COUNT, 1);
            newHero.set(PLAYED, 1);
            heroes.put(charId, newHero);
        }
        this.deleteItemsInDb();
        _heroes.clear();
        _heroes.putAll((Map<Integer, StatsSet>)heroes);
        heroes.clear();
        this.updateHeroes(false);
        for (StatsSet hero : _heroes.values()) {
            String name = hero.getString("char_name");
            L2PcInstance player = L2World.getInstance().getPlayer(name);
            if (player != null) {
                player.setHero(true);
                L2Clan clan = player.getClan();
                if (clan != null) {
                    clan.addReputationScore(Config.HERO_POINTS, true);
                    SystemMessage sm = new SystemMessage(SystemMessageId.CLAN_MEMBER_C1_BECAME_HERO_AND_GAINED_S2_REPUTATION_POINTS);
                    sm.addString(name);
                    sm.addNumber(Config.HERO_POINTS);
                    clan.broadcastToOnlineMembers(sm);
                }
                player.sendPacket(new UserInfo(player));
                player.sendPacket(new ExBrExtraUserInfo(player));
                player.broadcastUserInfo();
                continue;
            }
            Connection con = null;
            try {
                L2Clan clan;
                String clanName;
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement(GET_CLAN_NAME);
                statement.setString(1, name);
                ResultSet rset = statement.executeQuery();
                if (rset.next() && (clanName = rset.getString(CLAN_NAME)) != null && (clan = ClanTable.getInstance().getClanByName(clanName)) != null) {
                    clan.addReputationScore(Config.HERO_POINTS, true);
                    SystemMessage sm = new SystemMessage(SystemMessageId.CLAN_MEMBER_C1_BECAME_HERO_AND_GAINED_S2_REPUTATION_POINTS);
                    sm.addString(name);
                    sm.addNumber(Config.HERO_POINTS);
                    clan.broadcastToOnlineMembers(sm);
                }
                rset.close();
                statement.close();
            }
            catch (Exception e) {
                _log.warning("could not get clan name of " + name + ": " + e);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHeroes(boolean setDefault) {
        Connection con = null;
        try {
            PreparedStatement statement;
            con = L2DatabaseFactory.getInstance().getConnection();
            if (setDefault) {
                statement = con.prepareStatement(UPDATE_ALL);
                statement.execute();
                statement.close();
            } else {
                for (Integer heroId : _heroes.keySet()) {
                    StatsSet hero = _heroes.get(heroId);
                    if (_completeHeroes == null || !_completeHeroes.containsKey(heroId)) {
                        statement = con.prepareStatement(INSERT_HERO);
                        statement.setInt(1, heroId);
                        statement.setInt(2, hero.getInteger("class_id"));
                        statement.setInt(3, hero.getInteger(COUNT));
                        statement.setInt(4, hero.getInteger(PLAYED));
                        statement.execute();
                        Connection con2 = L2DatabaseFactory.getInstance().getConnection();
                        PreparedStatement statement2 = con2.prepareStatement(GET_CLAN_ALLY);
                        statement2.setInt(1, heroId);
                        ResultSet rset2 = statement2.executeQuery();
                        if (rset2.next()) {
                            int clanId = rset2.getInt("clanid");
                            int allyId = rset2.getInt("allyId");
                            String clanName = "";
                            String allyName = "";
                            int clanCrest = 0;
                            int allyCrest = 0;
                            if (clanId > 0) {
                                clanName = ClanTable.getInstance().getClan(clanId).getName();
                                clanCrest = ClanTable.getInstance().getClan(clanId).getCrestId();
                                if (allyId > 0) {
                                    allyName = ClanTable.getInstance().getClan(clanId).getAllyName();
                                    allyCrest = ClanTable.getInstance().getClan(clanId).getAllyCrestId();
                                }
                            }
                            hero.set(CLAN_CREST, clanCrest);
                            hero.set(CLAN_NAME, clanName);
                            hero.set(ALLY_CREST, allyCrest);
                            hero.set(ALLY_NAME, allyName);
                        }
                        rset2.close();
                        statement2.close();
                        con2.close();
                        _heroes.remove(heroId);
                        _heroes.put(heroId, hero);
                        _completeHeroes.put(heroId, hero);
                    } else {
                        statement = con.prepareStatement(UPDATE_HERO);
                        statement.setInt(1, hero.getInteger(COUNT));
                        statement.setInt(2, hero.getInteger(PLAYED));
                        statement.setInt(3, heroId);
                        statement.execute();
                    }
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            _log.warning("Hero System: Couldnt update Heroes");
            if (Config.DEBUG) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteItemsInDb() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(DELETE_ITEMS);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static class SingletonHolder {
        protected static final Hero _instance = new Hero();

        private SingletonHolder() {
        }
    }
}

