/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.util.EventData;
import com.l2jserver.util.StringUtil;
import com.l2jserver.util.Util;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;

public class L2Event {
    protected static final Logger _log = Logger.getLogger(L2Event.class.getName());
    public static String eventName = "";
    public static int teamsNumber = 0;
    public static final HashMap<Integer, String> names = new HashMap();
    public static final LinkedList<String> participatingPlayers = new LinkedList();
    public static final HashMap<Integer, LinkedList<String>> players = new HashMap();
    public static int id = 12760;
    public static final LinkedList<String> npcs = new LinkedList();
    public static boolean active = false;
    public static final HashMap<String, EventData> connectionLossData = new HashMap();

    public static int getTeamOfPlayer(String name) {
        for (int i = 1; i <= players.size(); ++i) {
            LinkedList<String> temp = players.get(i);
            Iterator it = temp.iterator();
            while (it.hasNext()) {
                if (!((String)it.next()).equals(name)) continue;
                return i;
            }
        }
        return 0;
    }

    public static String[] getTopNKillers(int N) {
        String[] killers = new String[N];
        String playerTemp = "";
        int kills = 0;
        LinkedList<String> killersTemp = new LinkedList<String>();
        for (int k = 0; k < N; ++k) {
            kills = 0;
            for (int i = 1; i <= teamsNumber; ++i) {
                LinkedList<String> temp = players.get(i);
                Iterator it = temp.iterator();
                while (it.hasNext()) {
                    try {
                        L2PcInstance player = L2World.getInstance().getPlayer((String)it.next());
                        if (killersTemp.contains(player.getName()) || player.kills.size() <= kills) continue;
                        kills = player.kills.size();
                        playerTemp = player.getName();
                    }
                    catch (Exception e) {}
                }
            }
            killersTemp.add(playerTemp);
        }
        for (int i = 0; i < N; ++i) {
            kills = 0;
            Iterator it = killersTemp.iterator();
            while (it.hasNext()) {
                try {
                    L2PcInstance player = L2World.getInstance().getPlayer((String)it.next());
                    if (player.kills.size() <= kills) continue;
                    kills = player.kills.size();
                    playerTemp = player.getName();
                }
                catch (Exception e) {}
            }
            killers[i] = playerTemp;
            killersTemp.remove(playerTemp);
        }
        return killers;
    }

    public static void showEventHtml(L2PcInstance player, String objectid) {
        try {
            NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
            BufferedReader inbr = Util.utf8BufferedReader("data/events/" + eventName);
            StringBuilder replyMSG = new StringBuilder();
            StringUtil.append(replyMSG, "<html><body><center><font color=\"LEVEL\">", eventName, "</font><font color=\"FF0000\"> bY ", inbr.readLine(), "</font></center><br><br>", inbr.readLine());
            if (participatingPlayers.contains(player.getName())) {
                replyMSG.append("<br><center>You are already in the event players list !!</center></body></html>");
            } else {
                StringUtil.append(replyMSG, "<br><center><button value=\"Participate !! \" action=\"bypass -h npc_", String.valueOf(objectid), "_event_participate\" width=90 height=15 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></center></body></html>");
            }
            adminReply.setHtml(replyMSG.toString());
            player.sendPacket(adminReply);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void spawn(L2PcInstance target, int npcid) {
        L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(npcid);
        try {
            L2Spawn spawn = new L2Spawn(template1);
            spawn.setLocx(target.getX() + 50);
            spawn.setLocy(target.getY() + 50);
            spawn.setLocz(target.getZ());
            spawn.setAmount(1);
            spawn.setHeading(target.getHeading());
            spawn.setRespawnDelay(1);
            SpawnTable.getInstance().addNewSpawn(spawn, false);
            spawn.init();
            spawn.getLastSpawn().setCurrentHp(9.99999999E8);
            spawn.getLastSpawn().setName("event inscriptor");
            spawn.getLastSpawn().setTitle(eventName);
            spawn.getLastSpawn().isEventMob = true;
            spawn.getLastSpawn().isAggressive();
            spawn.getLastSpawn().decayMe();
            spawn.getLastSpawn().spawnMe(spawn.getLastSpawn().getX(), spawn.getLastSpawn().getY(), spawn.getLastSpawn().getZ());
            spawn.getLastSpawn().broadcastPacket(new MagicSkillUse(spawn.getLastSpawn(), spawn.getLastSpawn(), 1034, 1, 1, 1));
            npcs.add(String.valueOf(spawn.getLastSpawn().getObjectId()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void announceAllPlayers(String text) {
        Broadcast.announceToOnlinePlayers(text);
    }

    public static boolean isOnEvent(L2PcInstance player) {
        for (int k = 0; k < teamsNumber; ++k) {
            Iterator it = players.get(k + 1).iterator();
            boolean temp = false;
            while (it.hasNext()) {
                temp = player.getName().equalsIgnoreCase((String)it.next());
                if (!temp) continue;
                return true;
            }
        }
        return false;
    }

    public static void inscribePlayer(L2PcInstance player) {
        try {
            participatingPlayers.add(player.getName());
            player.eventkarma = player.getKarma();
            player.eventX = player.getX();
            player.eventY = player.getY();
            player.eventZ = player.getZ();
            player.eventpkkills = player.getPkKills();
            player.eventpvpkills = player.getPvpKills();
            player.eventTitle = player.getTitle();
            player.kills.clear();
            player.atEvent = true;
        }
        catch (Exception e) {
            _log.warning("error when signing in the event:" + e);
        }
    }

    public static void restoreChar(L2PcInstance player) {
        try {
            player.eventX = L2Event.connectionLossData.get((Object)player.getName()).eventX;
            player.eventY = L2Event.connectionLossData.get((Object)player.getName()).eventY;
            player.eventZ = L2Event.connectionLossData.get((Object)player.getName()).eventZ;
            player.eventkarma = L2Event.connectionLossData.get((Object)player.getName()).eventKarma;
            player.eventpvpkills = L2Event.connectionLossData.get((Object)player.getName()).eventPvpKills;
            player.eventpkkills = L2Event.connectionLossData.get((Object)player.getName()).eventPkKills;
            player.eventTitle = L2Event.connectionLossData.get((Object)player.getName()).eventTitle;
            player.kills = L2Event.connectionLossData.get((Object)player.getName()).kills;
            player.eventSitForced = L2Event.connectionLossData.get((Object)player.getName()).eventSitForced;
            player.atEvent = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void restoreAndTeleChar(L2PcInstance target) {
        try {
            L2Event.restoreChar(target);
            target.setTitle(target.eventTitle);
            target.setKarma(target.eventkarma);
            target.setPvpKills(target.eventpvpkills);
            target.setPkKills(target.eventpkkills);
            target.teleToLocation(target.eventX, target.eventY, target.eventZ, true);
            target.kills.clear();
            target.eventSitForced = false;
            target.atEvent = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

