/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestFriendList
extends L2GameClientPacket {
    private static final String _C__60_REQUESTFRIENDLIST = "[C] 60 RequestFriendList";

    @Override
    protected void readImpl() {
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        activeChar.sendPacket(SystemMessageId.FRIEND_LIST_HEADER);
        L2PcInstance friend = null;
        for (int id : activeChar.getFriendList()) {
            SystemMessage sm;
            String friendName = CharNameTable.getInstance().getNameById(id);
            if (friendName == null) continue;
            friend = L2World.getInstance().getPlayer(friendName);
            if (friend == null || friend.isOnline() == 0) {
                sm = new SystemMessage(SystemMessageId.S1_OFFLINE);
                sm.addString(friendName);
            } else {
                sm = new SystemMessage(SystemMessageId.S1_ONLINE);
                sm.addString(friendName);
            }
            activeChar.sendPacket(sm);
        }
        activeChar.sendPacket(SystemMessageId.FRIEND_LIST_FOOTER);
    }

    @Override
    public String getType() {
        return _C__60_REQUESTFRIENDLIST;
    }
}

