/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExPrivateStoreSetWholeMsg;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreManageListSell;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreMsgSell;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.util.Util;

public class SetPrivateStoreListSell
extends L2GameClientPacket {
    private static final String _C__74_SETPRIVATESTORELISTSELL = "[C] 74 SetPrivateStoreListSell";
    private static final int BATCH_LENGTH = 20;
    private boolean _packageSale;
    private Item[] _items = null;

    @Override
    protected void readImpl() {
        this._packageSale = this.readD() == 1;
        int count = this.readD();
        if (count < 1 || count > Config.MAX_ITEM_IN_PACKET || count * 20 != this._buf.remaining()) {
            return;
        }
        this._items = new Item[count];
        for (int i = 0; i < count; ++i) {
            int itemId = this.readD();
            long cnt = this.readQ();
            long price = this.readQ();
            if (itemId < 1 || cnt < 1L || price < 0L) {
                this._items = null;
                return;
            }
            this._items[i] = new Item(itemId, cnt, price);
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (this._items == null) {
            player.sendPacket(new SystemMessage(SystemMessageId.INCORRECT_ITEM_COUNT));
            player.setPrivateStoreType(0);
            player.broadcastUserInfo();
            return;
        }
        if (!player.getAccessLevel().allowTransaction()) {
            player.sendPacket(new SystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
            return;
        }
        if (AttackStanceTaskManager.getInstance().getAttackStanceTask(player) || player.isInDuel()) {
            player.sendPacket(new SystemMessage(SystemMessageId.CANT_OPERATE_PRIVATE_STORE_DURING_COMBAT));
            player.sendPacket(new PrivateStoreManageListSell(player, this._packageSale));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isInsideZone((byte)14)) {
            player.sendPacket(new PrivateStoreManageListSell(player, this._packageSale));
            player.sendPacket(new SystemMessage(SystemMessageId.NO_PRIVATE_STORE_HERE));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (this._items.length > player.getPrivateSellStoreLimit()) {
            player.sendPacket(new PrivateStoreManageListSell(player, this._packageSale));
            player.sendPacket(new SystemMessage(SystemMessageId.YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED));
            return;
        }
        TradeList tradeList = player.getSellList();
        tradeList.clear();
        tradeList.setPackaged(this._packageSale);
        long totalCost = player.getAdena();
        for (Item i : this._items) {
            if (!i.addToTradeList(tradeList)) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to set price more than " + 99900000000L + " adena in Private Store - Sell.", Config.DEFAULT_PUNISH);
                return;
            }
            if ((totalCost += i.getPrice()) <= 99900000000L) continue;
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to set total price more than " + 99900000000L + " adena in Private Store - Sell.", Config.DEFAULT_PUNISH);
            return;
        }
        player.sitDown();
        if (this._packageSale) {
            player.setPrivateStoreType(8);
        } else {
            player.setPrivateStoreType(1);
        }
        player.broadcastUserInfo();
        if (this._packageSale) {
            player.broadcastPacket(new ExPrivateStoreSetWholeMsg(player));
        } else {
            player.broadcastPacket(new PrivateStoreMsgSell(player));
        }
    }

    @Override
    public String getType() {
        return _C__74_SETPRIVATESTORELISTSELL;
    }

    private class Item {
        private final int _itemId;
        private final long _count;
        private final long _price;

        public Item(int id, long num, long pri) {
            this._itemId = id;
            this._count = num;
            this._price = pri;
        }

        public boolean addToTradeList(TradeList list) {
            if (99900000000L / this._count < this._price) {
                return false;
            }
            list.addItem(this._itemId, this._count, this._price);
            return true;
        }

        public long getPrice() {
            return this._count * this._price;
        }
    }
}

