## Active Perl 5.8.8

# L2J properties setup tool

#- use utf8;
use strict;
use warnings;
use Encoding;

					#- binmode STDOUT,':encoding(cp932)';
sub   FS {shift}	#- sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {shift}	#- sub UTF8 {Encode::decode('cp932',shift)}

my $WIN32 = 1;
my $FCcmd = $WIN32 ? "fc /L /W"
                   : "diff -w";

my $iniFileName = UTF8(__FILE__);
   $iniFileName =~ s!\.[^.\/\\]*$!.ini!;
  #$iniFileName =~ s/\..*?$/.ini/;

my $logFileName = UTF8(__FILE__);
   $logFileName =~ s!\.[^.\/\\]*$!.log!;
  #$logFileName =~ s/\..*?$/_LOG.TXT/;

my $lastPath = '';
my $currentPath = undef;
my $lineNumber = 0;
my @properties;

&main;
<STDIN> unless $ENV{'PROMPT'};
exit 0;

sub main
{
	unlink FS($logFileName);

	&propertiesRead('login/config/');
	&propertiesRead('gameserver/config/');

	print 'load: ',$iniFileName,"\n";
	open FILE, '<', FS($iniFileName)  or die "'$iniFileName' $!";
	my @setting = <FILE>;
	$setting[0] =~ s/\xEF\xBB\xBF//;
	close FILE;

	foreach my $gyo (@setting) { ++$lineNumber;
		$gyo =~ s/#.*$//;
		$gyo =~ s/\s*$//;
		next if $gyo =~ m/^$/;

		if ($gyo =~ m/^>/) {
			$currentPath = substr($gyo, 1);
		} else {
			&propertiesSet($gyo);
		}
	}

	&propertiesWrite();
}

sub propertiesRead
{
	foreach my $subDir (@_) {
		next unless -d $subDir;
		opendir DIR, FS($subDir);
		my @files = readdir DIR; foreach (@files) {$_ = UTF8($_)}
		closedir DIR;

		foreach my $fileName (@files) {
			next if $fileName =~ m/^\./;
			next if $fileName =~ m/ /;
			my $filePath = $subDir.$fileName;
			if (-d FS($filePath)) {
				next;
			} elsif ($fileName =~ m/\.properties$/) {
				print "read: ",$filePath,"\n";
				open FILE, '<', FS($filePath)  or die "'$filePath' $!";
				read FILE, my $body, -s FILE;
				close FILE;
				push @properties, {path=>$filePath, body=>$body, back=>$body};
			}
		}
	}
}

sub propertiesWrite
{
	foreach my $p (@properties) {
		next if $p->{body} eq $p->{back};
		print "\tupdate: ",$p->{path},"\n";
		my $bakFileName = $p->{path}.'.BAK';
		unlink FS($bakFileName);
		rename FS($p->{path}), FS($bakFileName);
		open FILE, '>', FS($p->{path})
				or die __FILE__,':',__LINE__," : Cannot write '",$p->{path},"'\a\n";
		print FILE $p->{body};
		close FILE;

		my $cmdPropertiesFileName = $p->{path};   $cmdPropertiesFileName =~ s!\/!\\!g if $WIN32;
		my $cmdBakFileName        = $bakFileName; $cmdBakFileName        =~ s!\/!\\!g if $WIN32;
		my $cmdLogFileName        = $logFileName; $cmdLogFileName        =~ s!\/!\\!g if $WIN32;

		print     $FCcmd." \"$cmdBakFileName\" \"$cmdPropertiesFileName\" >> $cmdLogFileName","\n";
		system FS($FCcmd." \"$cmdBakFileName\" \"$cmdPropertiesFileName\" >> $cmdLogFileName");
	}
}

sub propertiesSet($)
{
	my ($gyo) = @_;
	$gyo =~ m/^(.*?)\s*=/
		or die $iniFileName,':',$lineNumber," : Syntax error '",$gyo,"'\a\n";
	my $pattern = $1;
#	my $pattern = '^#?' . $1 . '[ \t]*=.*?$';

	my $found = 0;
	foreach my $p (@properties) {
		next if $currentPath && ($p->{path} ne $currentPath);
		my $bak = $p->{body};
		my $b = $p->{body} =~ s/^\Q$pattern\E[ \t]*=.*?$/$gyo/m
		     || $p->{body} =~ s/^#\Q$pattern\E[ \t]*=.*?$/$gyo/m;
		$found |= $b;
		next if $p->{body} eq $bak;
		if ($lastPath ne $p->{path}) { $lastPath = $p->{path}; print '>',$lastPath,"\n" }
		print "\t",$gyo,"\n";
	}
	die $iniFileName,':',$lineNumber," : Unknown propertie '",$gyo,"'\a\n"
		unless $found;
}
