DROP TABLE IF EXISTS `teleport`;
CREATE TABLE `teleport` (
  `Description` varchar(75) default NULL,
  `id` decimal(11,0) NOT NULL default '0',
  `loc_x` decimal(9,0) default NULL,
  `loc_y` decimal(9,0) default NULL,
  `loc_z` decimal(9,0) default NULL,
  `price` decimal(6,0) default NULL,
  `fornoble` int(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
);

INSERT INTO `teleport` VALUES
('Dark Elven Town -> Town of Gludio',1,-12672,122776,-3116,10000,0),
('Elven Town  -> Town of Gludio',2,-12672,122776,-3116,9200,0),
('Elven Village -> Elven Forest',468,21362,51122,-3688,710,0),
('Elven Village -> Neutral Zone',469,-10674,75550,-3597,740,0),
('Elven Village -> Elven Fortress',470,29294,74968,-3776,820,0),
('Town of Gludio -> Elven village',3,46934,51467,-2977,9200,0),
('Town of Gludio -> Dark Elven village',4,9745,15606,-4574,10000,0),
('Town of Gludio -> Village of Gludin',5,-80826,149775,-3043,7300,0),
('Town of Gludio -> Dion',6,15670,142983,-2705,3400,0),
('Village of Gludin -> Orc village',7,-44836,-112524,-235,26000,0),
('Village of Gludin -> Dwarven village',8,115113,-178212,-901,38000,0),
('Village of Gludin -> TI',9,-84318,244579,-3730,9400,0),
('Village of Gludin -> Elven Village',10,46934,51467,-2977,16000,0),
('Village of Gludin -> Dark Elven Village',11,9745,15606,-4574,16000,0),
('Village of Gludin -> Town of Gludio',12,-12672,122776,-3116,7300,0),
('Village of Gludin -> Southern entrance of wastelands',13,-16730,209417,-3664,3400,0),
('Dark Elven Town -> Southern part of dark elven forest',14,-61095,75104,-3356,1100,0),
('DE Village -> Dark Forest',464,-22224,14168,-3232,890,0),
('DE Village -> Spider Nest',465,-56532,78321,-2960,3600,0),
('DE Village -> Swampland',466,-30777,49750,-3552,1100,0),
('DE Village -> Neutral Zone',467,-23520,68688,-3640,1700,0),
('TI -> Village of Gludin',15,-80826,149775,-3043,18000,0),
('TI -> Obelisk of Victory',1001,-99678,237562,-3567,470,0),
('TI -> Western Territory',1002,-101294,212553,-3093,1000,0),
('TI -> Elven Ruins',1003,-113329,235327,-3653,830,0),
('TI -> Singing Waterfall',1004,-107456,242669,-3493,770,0),
('Dwarf Town  -> Town of Gludio',16,-12672,122776,-3116,32000,0),
('Dwarf Town -> The Northeast Coast',17,169008,-208272,-3504,2400,0),
('Dwarven Town -> Abandoned Coal Mines',418,139714,-177456,-1536,690,0),
('Dwarven Town -> Mithril Mines',419,171946,-173352,3448,2200,0),
('Dion Town -> Town of Gludio',18,-12672,122776,-3116,3400,0),
('Dion Town -> Town of Giran',19,83400,147943,-3404,6800,0),
('Dion Town -> Giran Harbor',20,47942,186764,-3485,6500,0),
('Cruma Tower 1st floor -> Cruma Tower Entrance',22,17192,114178,-3439,0,0),
('Cruma Tower 1st floor -> Cruma Tower 2nd floor',23,17776,108288,-9056,0,0),
('Cruma Tower 2nd floor -> Cruma Tower 1st floor',24,17781,113999,-11672,0,0),
('Town of Giran -> Dion Town',25,15670,142983,-2705,6800,0),
('Town of Giran -> Oren Town',26,82956,53162,-1495,9400,0),
('Town of Giran -> Hunter Village',27,116819,76994,-2714,4100,0),
('Town of Giran -> Hardin\'s Private Academy',28,105918,109759,-3207,4400,0),
('Talking Island -> Obelisk of Victory',460,-99843,237583,-3568,200,0),
('Talking Island -> Western Territory of Talking Island (Northern Area)',461,-102850,215932,-3424,3000,0),
('Talking Island -> Elven Ruins',462,49315,248452,-5960,2500,0),
('Talking Island -> Singing Waterfall',463,-113686,235723,-3640,2300,0),
('TI Dungeon inside -> outside',29,-113329,235327,-3653,0,0),
('TI Dungeon outside -> inside',30,48736,248463,-6162,0,0),
('Ivory Tower Basement',31,84915,15969,-4294,0,0),
('Ivory Tower Ground Floor',32,85399,16197,-3679,0,0),
('Ivory Tower 1st Floor',33,85399,16197,-2809,0,0),
('Ivory Tower 2nd Floor',34,85399,16197,-2293,0,0),
('Ivory Tower 3th Floor',35,85399,16197,-1776,0,0),
('Ivory Tower Ground Floor -> Oren Castle Town',36,82956,53162,-1495,3700,0),
('Ivory Tower Ground Floor -> Hunter\'s Village',37,116819,76994,-2714,6800,0),
('Ivory Tower Ground Floor -> Aden Castle Town',38,146331,25762,-2018,6200,0),
('Aden Town -> Ivory Tower',39,85348,16142,-3699,12000,0),
('Aden Town -> Oren Town',40,82956,53162,-1495,6900,0),
('Aden Town -> Hunter\'s Village',41,116819,76994,-2714,5900,0),
('Hunter\'s Village -> Giran Town',42,83400,147943,-3404,9400,0),
('Hunter\'s Village -> Oren Town',43,82956,53162,-1495,4100,0),
('Hunter\'s Village -> Ivory Tower',44,85348,16142,-3699,8200,0),
('Hunter\'s Village -> Hardin\'s Private Academy',45,105918,109759,-3207,3400,0),
('Hunter\'s Village -> Aden Town',46,146331,25762,-2018,5900,0),
('Oren Town -> Giran Town',47,83400,147943,-3404,9400,0),
('Oren Town -> Ivory Tower',48,85348,16142,-3699,3700,0),
('Oren Town -> Hunter\'s Village',49,116819,76994,-2714,4100,0),
('Oren Town -> Hardin\'s Private Academy',50,105918,109759,-3207,6100,0),
('Oren Town -> Aden Town',51,146331,25762,-2018,6900,0),
('Hardin\'s Private Academy -> Giran Town',52,83400,147943,-3404,4400,0),
('Hardin\'s Private Academy -> Oren Town',53,82956,53162,-1495,6100,0),
('Hardin\'s Private Academy -> Hunter\'s Village',54,116819,76994,-2714,3400,0),
('Cruma level 2 -> Cruma level 3',55,17719,115590,-6584,0,0),
('Cruma level 3 -> Cruma Core',56,17691,111726,-6583,0,0),
('Cruma core -> Cruma level 3',57,17719,115590,-6584,0,0),
('Cruma Tower 3rd floor -> Cruma Tower 2nd Floor',58,17731,119465,-9067,0,0),
('Heine -> The Town of Giran',59,83400,147943,-3404,7600,0),
('Heine -> Giran Harbor',60,47942,186764,-3485,7100,0),
('Lair end -> Antharas Nest',61,173826,115333,-7708,0,0),
('Antharas Nest - > Giran castle town',62,83400,147943,-3404,0,0),
('Giran Harbor -> Giran Town',63,83400,147943,-3404,6300,0),
('Giran Harbor -> Dion Town',64,15670,142983,-2705,6500,0),
('Giran Harbor -> Heine',107,111409,219364,-3545,8500,0),
('Heine -> The Town of Dion',65,15670,142983,-2705,12000,0),
('Heine -> Field of Silence',66,87691,162835,-3520,2500,0),
('Heine -> Field of Whispers',67,82192,226128,-3656,2300,0),
('Heine -> Entrance to Alligator Islands',68,115583,192261,-3488,2100,0),
('Giran -> Dragon Valley',69,73024,118485,-3688,1800,0),
('Giran -> Heine',70,111409,219364,-3545,7600,0),
('Monster Derby Track',75,12661,181687,-3560,0,0),
('Aden -> Coliseum',76,146440,46723,-3432,2000,0),
('Aden -> Blazing Swamp',81,155310,-16339,-3320,6800,0),
('Aden -> The Forbidden Gateway',82,185319,20218,-3264,1400,0),
('Aden -> The Front of Anghell Waterfall',83,163341,91374,-3320,2400,0),
('Aden -> Forsaken Plains',84,168217,37990,-4072,1900,0),
('Dion -> Heine',85,111409,219364,-3545,12000,0),
('Dion -> Partisan Hideaway',86,46467,126885,-3720,1700,0),
('Dion -> Bee Hive',87,20505,189036,-3344,2900,0),
('Gludio -> Windawood Manor',88,-23789,169683,-3424,1400,0),
('Gludio -> Southern Pathway to the Wasteland',89,-16730,209417,-3664,2400,0),
('Gludin -> Abandoned Camp',90,-46932,140883,-2936,1200,0),
('Gludin -> Fellmere Harvest Grounds',91,-70387,115501,-3472,1400,0),
('Gludin -> Langk Lizardman Dwelling',92,-45210,202654,-3592,1800,0),
('Orc Village -> Immortal Plateau,Northern Region',93,-8804,-114748,-3088,960,0),
('Orc Village -> Immortal Plateau,Southern Region',94,-17870,-90980,-2528,2000,0),
('Orc Village -> Immortal Plateau,Southeast Region',95,8209,-93524,-2312,750,0),
('Orc Village -> Frozen Waterfall',96,7603,-138871,-920,1600,0),
('Orc Village -> Entrance to the Cave of Trials',471,9340,-112509,-2536,1500,0),
('Oren -> Plains of Lizardmen',97,87252,85514,-3056,1900,0),
('Oren -> Sea of Spores',98,64328,26803,-3768,2500,0),
('Hunters -> Northern Pathway of Enchanted Valley',99,104426,33746,-3800,3600,0),
('Hunters -> Southern Pathway of Enchanted Valley',100,124904,61992,-3920,1300,0),
('Hunters -> Entrance to the Forest of Mirrors',101,142065,81300,-3000,2000,0),
('Hunters -> The Front of Anghel Waterfall',102,163341,91374,-3320,4000,0),
('Goddard -> Aden Castle Town',132,146331,25762,-2018,8100,0),
('Goddard -> Rune Castle Village',108,43799,-47727,-798,10000,0),
('Goddard -> Varka Silenos Stronghold',109,125543,-40953,-3724,4200,0),
('Goddard -> Ketra Orc Outpost',110,146954,-67390,-3660,1800,0),
('Goddard -> Entrance to the Forge of the Gods',111,169178,-116244,-2421,2300,0),
('Rune -> Goddard Castle Village',119,147928,-55273,-2734,10000,0),
('Rune -> The Town of Giran',120,83400,147943,-3404,59000,0),
('Rune -> Aden Castle Town',121,146331,25762,-2018,37000,0),
('Rune -> Rune Castle Town Guild',122,38320,-48092,-1153,150,0),
('Rune -> Rune Castle Town Temple',123,38275,-48065,896,150,0),
('Rune -> Entrance to the Forest of the Dead',124,52112,-53939,-3159,1200,0),
('Rune -> Western Entrance to the Swamp of Screams',125,70006,-49902,-3251,3000,0),
('Rune -> Rune Castle Town Store',131,43799,-47727,-798,150,0),
('Aden -> Rune',134,43799,-47727,-798,37000,0),
('Aden -> Goddard',135,147928,-55273,-2734,8100,0),
('Giran Town -> Giran Harbor',136,47942,186764,-3485,5200,0),

('TOI - 1st Floor',201,115168,16022,-5100,100000,0),
('TOI - 2nd Floor',202,114649,18587,-3609,150000,0),
('TOI - 3rd Floor',203,117918,16039,-2127,200000,0),
('TOI - 4th Floor',204,114622,12946,-645,250000,0),
('TOI - 5th Floor',205,112209,16078,928,300000,0),
('TOI - 6th Floor',206,112376,16099,1947,350000,0),
('TOI - 7th Floor',207,114448,16175,2994,400000,0),
('TOI - 8th Floor',208,111063,16118,3967,450000,0),
('TOI - 9th Floor',209,117147,18415,4977,500000,0),
('TOI - 10th Floor',210,118374,15973,5987,550000,0),
('TOI - 11th Floor',211,112209,16078,7028,600000,0),
('TOI - 12th Floor',212,114809,18711,7996,650000,0),
('TOI - 13th Floor',213,115178,16989,9007,700000,0),
('TOI - 14th Floor Outside Door',214,112714,14111,10077,800000,0),
('TOI - 14th Floor Inside On Roof',215,113098,14532,10077,900000,0),

('Cat Heretics Entrance',250,-53174,-250275,-7911,0,0),-- Interlude (undersea)
('Cat Heretics Exit',251,42514,143917,-5385,0,0),
('Cat Branded Entrance',252,46217,170290,-4983,0,0),
('Cat Branded Exit',253,45770,170299,-4985,0,0),
('Cat Apostate Entrance',254,-20230,-250780,-8168,0,0),-- Interlude (undersea)
('Cat Apostate Exit',255,77225,78362,-5119,0,0),
('Cat Witch Entrance',256,140404,79678,-5431,0,0),
('Cat Witch Exit',257,139965,79678,-5433,0,0),
('Cat DarkOmen Entrance',258,-19500,13508,-4905,0,0),
('Cat DarkOmen Exit',259,-19931,13502,-4905,0,0),
('Cat ForbiddenPath Entrance',260,12521,-248481,-9585,0,0),-- Interlude (undersea)
('Cat ForbiddenPath Exit',261,113429,84540,-6545,0,0),
('Necro Sacrifice Entrance',262,-41570,209785,-5089,0,0),
('Necro Sacrifice Exit',263,-41567,209292,-5091,0,0),
('Necro Pilgrims Entrance',264,45251,123890,-5415,0,0),
('Necro Pilgrims Exit',265,45250,124366,-5417,0,0),
('Necro Worshippers Entrance',266,111273,174015,-5417,0,0),
('Necro Worshippers Exit',267,110818,174010,-5443,0,0),
('Necro Patriots Entrance',268,-21726,77385,-5177,0,0),
('Necro Patriots Exit',269,-22197,77369,-5177,0,0),
('Necro Ascetics Entrance',270,-52254,79103,-4743,0,0),
('Necro Ascetics Exit',271,-52716,79106,-4745,0,0),
('Necro Martyrs Entrance',272,118308,132800,-4833,0,0),
('Necro Martyrs Exit',273,117793,132810,-4835,0,0),
('Necro Saints Entrance',274,83000,209213,-5443,0,0),
('Necro Saints Exit',275,82608,209225,-5443,0,0),
('Necro Disciples Entrance',276,172251,-17605,-4903,0,0),
('Necro Disciples Exit',277,171902,-17595,-4905,0,0),

('Dion(artifact -> out)',350,22967,157715,-2954,0,0),
('Dion(artifact -> hall)',351,22090,159871,-2711,0,0),
('Dion(artifact -> outofcastle)',352,22448,155798,-2958,0,0),
('Dion(in -> artifact)',353,22592,161530,-2775,0,0),
('Dion(in -> out)',354,22967,157715,-2954,0,0),
('Dion(in -> outofcastle)',355,22448,155798,-2958,0,0),
('Dion(out -> artifact)',356,22592,161530,-2775,0,0),
('Dion(out -> hall)',357,22090,159871,-2711,0,0),
('Dion(out -> outofcastle)',358,22448,155798,-2958,0,0),
('Dion(outofcastle -> artifact)',359,22592,161530,-2775,0,0),
('Dion(outofcastle -> out)',360,22967,157715,-2954,0,0),
('Dion(outofcastle -> hall)',361,22090,159871,-2711,0,0),
('Giran(artifact -> out)',362,113892,144175,-2714,0,0),
('Giran(artifact -> hall)',363,115984,145073,-2584,0,0),
('Giran(artifact -> outofcastle)',364,112016,144682,-2833,0,0),
('Giran(in -> artifact)',365,117619,144564,-2648,0,0),
('Giran(in -> out)',366,113892,144175,-2714,0,0),
('Giran(in -> outofcastle)',367,112016,144682,-2833,0,0),
('Giran(out -> artifact)',368,117619,144564,-2648,0,0),
('Giran(out -> hall)',369,115984,145073,-2584,0,0),
('Giran(out -> outofcastle)',370,112016,144682,-2833,0,0),
('Giran(outofcastle -> artifact)',371,117619,144564,-2648,0,0),
('Giran(outofcastle -> out)',372,113892,144175,-2714,0,0),
('Giran(outofcastle -> hall)',373,115984,145073,-2584,0,0),
('Oren(artifact -> out)',374,79956,36351,-2532,0,0),
('Oren(artifact -> hall)',375,82113,37217,-2311,0,0),
('Oren(artifact -> outofcastle)',376,78079,36809,-2566,0,0),
('Oren(in -> artifact)',377,83710,36713,-2375,0,0),
('Oren(in -> out)',378,79956,36351,-2532,0,0),
('Oren(in -> outofcastle)',379,78079,36809,-2566,0,0),
('Oren(out -> artifact)',380,83710,36713,-2375,0,0),
('Oren(out -> hall)',381,82113,37217,-2311,0,0),
('Oren(out -> outofcastle)',382,78079,36809,-2566,0,0),
('Oren(outofcastle -> artifact)',383,83710,36713,-2375,0,0),
('Oren(outofcastle -> out)',384,79956,36351,-2532,0,0),
('Oren(outofcastle -> hall)',385,82113,37217,-2311,0,0),
('Gludio(artifact -> out)',386,-18941,112085,-2762,0,0),
('Gludio(artifact -> hall)',387,-18129,109898,-2517,0,0),
('Gludio(artifact -> outofcastle)',388,-18484,113897,-2772,0,0),
('Gludio(in -> artifact)',389,-18592,108271,-2581,0,0),
('Gludio(in -> out)',390,-18941,112085,-2762,0,0),
('Gludio(in -> outofcastle)',391,-18484,113897,-2772,0,0),
('Gludio(out -> artifact)',392,-18592,108271,-2581,0,0),
('Gludio(out -> hall)',393,-18129,109898,-2517,0,0),
('Gludio(out -> outofcastle)',394,-18484,113897,-2772,0,0),
('Gludio(outofcastle -> artifact)',395,-18592,108271,-2581,0,0),
('Gludio(outofcastle -> out)',396,-18941,112085,-2762,0,0),
('Gludio(outofcastle -> hall)',397,-18129,109898,-2517,0,0),
('Aden(artifact -> out)',398,147723,7916,-475,0,0),
('Aden(artifact -> in)',399,148580,4578,-408,0,0),
('Aden(artifact -> outofcastle)',400,147582,8753,-496,0,0),
('Aden(artifact -> hall)',401,147520,6107,-409,0,0),
('Aden(in -> artifact)',402,1147499,2544,-473,0,0),
('Aden(in -> out)',403,147723,7916,-475,0,0),
('Aden(in -> outofcastle)',404,147582,8753,-496,0,0),
('Aden(in -> hall)',405,147520,6107,-409,0,0),
('Aden(out -> artifact)',406,147499,2544,-473,0,0),
('Aden(out -> in)',407,148580,4578,-408,0,0),
('Aden(out -> outofcastle)',408,147582,8753,-496,0,0),
('Aden(out -> hall)',409,147520,6107,-409,0,0),
('Aden(outofcastle -> artifact)',410,147499,2544,-473,0,0),
('Aden(outofcastle -> out)',411,147723,7916,-475,0,0),
('Aden(outofcastle -> in)',412,148580,4578,-408,0,0),
('Aden(outofcastle -> hall)',413,147520,6107,-409,0,0),
('Aden(hall) -> artifact)',414,147499,2544,-473,0,0),
('Aden(hall) -> out)',415,147723,7916,-475,0,0),
('Aden(hall) -> in)',416,148580,4578,-408,0,0),
('Aden(hall) -> outofcastle)',417,147582,8753,-496,0,0),
('Lair Of Valakas',420,208884,-113705,-256,0,0),
('Disciples Necropolis -> Anakim/Lilith',450,185061,-9612,-5492,0,0),
('Anakim/Lilith -> Disciples Necropolis',451,183225,-11911,-4897,0,0),
('TI -> Dark Elven Village',1005,9745,15606,-4574,24000,0),
('TI -> Dwarven Village',1006,115113,-178212,-901,46000,0),
('TI -> Elven Village',1007,46934,51467,-2977,23000,0),
('TI -> Orc Village',1008,-44836,-112524,-235,35000,0),
('DE Village -> Dwarven Village',1009,115113,-178212,-901,22000,0),
('DE Village -> TI Village',1010,-84318,244579,-3730,24000,0),
('Gludin -> Windy Hill',1121,-88525,83379,-2864,2600,0),
('DE Village -> Orc Village',1012,-44836,-112524,-235,13000,0),
('Elven Village -> Neutral Zone',1013,-10674,75550,-3597,1700,0),
('Elven Village -> Dwarven Village',1014,115113,-178212,-901,23000,0),
('Elven Village -> TI Village',1015,-84318,244579,-3730,23000,0),
('Elven Village -> Orc Village',1016,-44836,-112524,-235,18000,0),
('Dwarven Village -> DE Village',1017,9745,15606,-4574,22000,0),
('Dwarven Village -> Elven Village',1018,46934,51467,-2977,23000,0),
('Dwarven Village -> TI Village',1019,-84318,244579,-3730,46000,0),
('Dwarven Village -> Schuttgart',1020,87386,-143246,-1293,4400,0),
('Dwarven Village -> Orc Village',1021,-44836,-112524,-235,17000,0),
('Dwarven Village -> Central Shore',1022,136910,-205082,-3664,970,0),
('Orc Village -> Town of Gludio',1023,-12672,122776,-3116,23000,0),
('Orc Village -> Schuttgart',1024,87386,-143246,-1293,13000,0),
('Orc Village -> DE Village',1025,9745,15606,-4574,13000,0),
('Orc Village -> Dwarven Village',1026,115113,-178212,-901,17000,0),
('Orc Village -> TI Village',1027,-84318,244579,-3730,35000,0),
('Orc Village -> Elven Village',1028,46934,51467,-2977,18000,0),
('Gludio -> Orc Village',1033,-44836,-112524,-235,23000,0),
('Gludin Village -> Windmill Hill',1029,-68628,162336,-3592,550,0),
('Gludin Village -> Forgotten Temple',1030,-52841,190730,-3518,2000,0),
('Gludio -> Ant Cave',1031,-9993,176457,-4182,2100,0),
('Gludin Village -> Crimson Boulder Ridge',1032,-42256,198333,-2800,3700,0),
('Gludio -> Dwarven Village',1034,115113,-178212,-901,32000,0),
('Gludio -> Schuttgart',1035,87386,-143246,-1293,85000,0),
('Gludio -> Heine',1036,111409,219364,-3545,47000,0),
('Gludio -> Aden Castle Town',1037,146331,25762,-2018,56000,0),
('Gludio -> Oren Castle Town',1038,82956,53162,-1495,35000,0),
('Gludio -> Goddard Castle Town',1039,147928,-55273,-2734,71000,0),
('Gludio -> Giran Castle Town',1040,83400,147943,-3404,29000,0),
('Gludio -> Rune Castle Town',1041,43799,-47727,-798,53000,0),
('Gludio -> Ruins of Agony',1042,-42504,120046,-3519,790,0),
('Gludio -> Ruins of Despair',1043,-20057,137618,-3897,610,0),
('Gludin -> Turek Orc',1044,-89839,105362,-3580,1800,0),
('Gludio -> Windmill Hill',1045,-68628,162336,-3592,2600,0),
('Dion -> Goddard',1046,147928,-55273,-2734,71000,0),
('Dion -> Rune Castle Town',1047,43799,-47727,-798,57000,0),
('Dion -> Schuttgart',1048,87386,-143246,-1293,88000,0),
('Dion -> Aden',1049,146331,25762,-2018,52000,0),
('Dion -> Oren',1050,82956,53162,-1495,33000,0),
('Dion -> Cruma Marshlands',1051,5106,126916,-3664,760,0),
('Dion -> Cruma Tower',1052,17192,114178,-3439,2300,0),
('Dion -> Dion Pasture',1053,630,179184,-3720,1500,0),
('Dion -> Tanor Canyon',1054,58316,163851,-2816,3800,0),
('Giran -> Gludio',1055,-12672,122776,-3116,29000,0),
('Giran -> Goddard',1056,147928,-55273,-2734,63000,0),
('Giran -> Rune',1057,43799,-47727,-798,59000,0),
('Giran -> Schuttgart',1058,87386,-143246,-1293,87000,0),
('Giran -> Aden',1059,146331,25762,-2018,13000,0),
('Giran -> Antharas Lair',1060,132828,114421,-3725,7000,0),
('Giran -> Devil Isle',1061,43408,206881,-3752,5700,0),
('Giran -> Brekas Stronghold',1062,79798,130624,-3677,1000,0),
('Heine -> Oren',1063,82956,53162,-1495,50000,0),
('Heine -> Aden',1064,146331,25762,-2018,59000,0),
('Heine -> Goddard',1065,147928,-55273,-2734,83000,0),
('Heine -> Rune',1066,43799,-47727,-798,82000,0),
('Heine -> Schuttgart',1067,87386,-143246,-1293,100000,0),
('Heine -> Gludio',1068,-12672,122776,-3116,47000,0),
('Heine -> Garden of Eva',1069,86006,231069,-3600,2400,0),
('Oren -> Rune',1070,43799,-47727,-798,10000,0),
('Oren -> Goddard',1071,147928,-55273,-2734,37000,0),
('Oren -> Heine',1072,111409,219364,-3545,50000,0),
('Oren -> Dion',1073,15670,142983,-2705,33000,0),
('Oren -> Schuttgart',1074,87386,-143246,-1293,59000,0),
('Oren -> Gludio',1075,-12672,122776,-3116,35000,0),
('Oren -> Skyshadow Meadow',1076,82764,61145,-3502,780,0),
('Oren -> Forest Outlaw',1077,85995,-2433,-3528,5200,0),
('Aden -> Giran',1078,83400,147943,-3404,13000,0),
('Aden -> Heine',1079,111409,219364,-3545,59000,0),
('Aden -> Schuttgart',1080,87386,-143246,-1293,53000,0),
('Aden -> Dion',1081,15670,142983,-2705,52000,0),
('Aden -> Gludio',1082,-12672,122776,-3116,56000,0),
('Aden -> Seal of Shilen',1083,184742,19745,-3168,3300,0),
('Aden -> Forest of Mirrors',1084,142065,81300,-3000,4400,0),
('Aden -> Fields of Massacre',1085,183543,-14974,-2776,6500,0),
('Aden -> Ancient Battleground',1086,106517,-2871,-3416,5900,0),
('Aden -> Silent Valley',1087,170838,55776,-5280,6100,0),
('Aden -> ToI',1088,114649,11115,-5120,4200,0),
('Goddard -> Gludio',1089,-12672,122776,-3116,71000,0),
('Goddard -> Giran',1090,83400,147943,-3404,63000,0),
('Goddard -> Dion',1091,15670,142983,-2705,71000,0),
('Goddard -> Heine',1092,111409,219364,-3545,83000,0),
('Goddard -> Schuttgart',1093,87386,-143246,-1293,10000,0),
('Goddard -> Oren',1094,82956,53162,-1495,37000,0),
('Goddard -> Hot Springs',1095,149594,-112698,-2065,9300,0),
('Goddard -> Wall of Argos',1096,165054,-47861,-3560,2200,0),
('Goddard -> Monastery of silence',1097,106414,-87799,-2920,10000,0),
('Rune -> Dion',1098,15670,142983,-2705,57000,0),
('Rune -> Gludio',1099,-12672,122776,-3116,53000,0),
('Rune -> Heine',1100,111409,219364,-3545,82000,0),
('Rune -> Schuttgart',1101,87386,-143246,-1293,10000,0),
('Rune -> Oren',1102,82956,53162,-1495,10000,0),
('Rune -> Beast Farm',1103,57059,-82976,-2847,4800,0),
('Rune -> Valley of Saints',1104,67992,-72012,-3748,3800,0),
('Rune -> Monastery of Silence',1105,123743,-75032,-2902,14000,0),
('Schuttgart -> Rune',1106,43799,-47727,-798,10000,0),
('Schuttgart -> Goddard',1107,147928,-55273,-2734,10000,0),
('Schuttgart -> Aden',1108,146331,25762,-2018,53000,0),
('Schuttgart -> Oren',1109,82956,53162,-1495,59000,0),
('Schuttgart -> Heine',1110,111409,219364,-3545,100000,0),
('Schuttgart -> Giran',1111,83400,147943,-3404,87000,0),
('Schuttgart -> Dion',1112,15670,142983,-2705,88000,0),
('Schuttgart -> Gludio',1113,-12672,122776,-3116,85000,0),
('Schuttgart -> Orc Village',1114,-44836,-112524,-235,13000,0),
('Schuttgart -> Dwarven Village',1115,115113,-178212,-901,4400,0),
('Schuttgart -> Den of Evil',1116,68693,-110438,-1904,3000,0),
('Schuttgart -> Plunderous Plains',1117,111965,-154172,-1528,1600,0),
('Schuttgart -> Frozen Labyrinth',1118,113903,-108752,-848,3500,0),
('Schuttgart -> Crypt of Disgrace',1119,47692,-115745,-3744,1900,0),
('Schuttgart -> Pavel Ruins',1120,91280,-117152,-3928,2100,0),
('Kamael Vilage -> The Town of Gludio',1139,-12672,122776,-3116,12000,0),
('Kamael Vilage -> Town of Aden',1122,146331,25762,-2018,26000,0),
('Kamael Vilage -> Talking Island Village',1123,-84318,244579,-3730,20000,0),
('Kamael Vilage -> Dark Elf Village',1124,9745,15606,-4574,13000,0),
('Kamael Vilage -> Elven Village',1125,46934,51467,-2977,16000,0),
('Kamael Vilage -> Dwarven Village',1126,115113,-178212,-901,32000,0),
('Kamael Vilage -> Orc Village',1127,-44836,-112524,-235,17000,0),
('Kamael Vilage -> Stronghold I',1128,-122410,73205,-2872,2600,0),
('Kamael Vilage -> Stronghold II',1129,-95540,52150,-2024,2200,0),
('Kamael Vilage -> Stronghold III',1130,-85928,37095,-2048,3200,0),
('Kamael Vilage -> Isle of Souls Harbor',1131,-74016,51932,-3680,4300,0),
('Kamael Vilage -> Stronghold I free',1132,-122410,73205,-2872,0,0),
('Kamael Vilage -> Stronghold II free',1133,-95540,52150,-2024,0,0),
('Kamael Vilage -> Stronghold III free',1134,-85928,37095,-2048,0,0),
('Strongolds -> Kamael Village free',1135,-117251,46771,360,0,0),
('Soul Isle Harbor -> The Town of Gludio',1136,-12672,122776,-3116,9300,0),
('Soul Isle Harbor -> Town of Aden',1137,146331,25762,-2018,22000,0),
('Soul Isle Harbor -> The Town of Gludio',1138,-117251,46771,360,4300,0),

('Pagan Temple - > exit',11999,-16307,-36591,-10725,0,0),
('Pagan Chapel - > exit',11998,-16359,-43803,-10725,0,0);

INSERT INTO `teleport` VALUES
('Clan Hall -> Execution Grounds',502,51055,141959,-2869,500,0),
('Clan Hall -> Fortress of Resistance',503,47382,111278,-104,500,0),
('Clan Hall -> Cruma Marshlands',504,5106,126916,-3664,500,0),
('Clan Hall -> Cruma Tower Entrance',505,17192,114178,-3439,500,0),
 -- ('Clan Hall -> Mandragora Farm',506,17192,114178,-3439,500,0),-- dunno coords !
('Clan Hall -> Town of Dion',507,15670,142983,-2705,500,0),
('Clan Hall -> Floran Village',508,17430,170103,-3496,500,0),
 -- 509
('Clan Hall -> Tanor Canyon',510,60374,164301,-2856,500,0),
('Clan Hall -> Bee Hive',511,20505,189036,-3344,500,0),
 -- ('Clan Hall -> Dion Hills',512,20505,189036,-3344,500,0),-- dunno coords !
('Clan Hall -> Floran Agricultural Area',513,26810,172787,-3376,500,0),-- needs confirming
('Clan Hall -> Plains of Dion',514,630,179184,-3720,500,0),-- needs confirming
 -- 515
 -- 516
('Clan Hall -> Hardin\'s Academy',517,105918,109759,-3207,500,0),
('Clan Hall -> Dragon Valley',518,122824,110836,-3720,500,0),
 -- 519
 -- 520
('Clan Hall -> Death Pass',521,70000,126636,-3804,500,0),
('Clan Hall -> Pirate Tunnel',522,41298,200350,-4583,500,0),
 -- 523
('Clan Hall -> Giran Harbor',524,47942,186764,-3485,500,0),
('Clan Hall -> Giran Castle Town',525,83400,147943,-3404,500,0),
('Clan Hall -> Giran Arena',526,73890,142656,-3778,500,0),
 -- 527
('Clan Hall -> Breka\'s Stronghold',528,79798,130624,-3677,500,0),
('Clan Hall -> Gorgon Flower Garden',529,113553,134813,-3640,500,0), -- needs confirming
 -- -----------------
('Clan Hall -> Ivory Tower',581,85348,16142,-3699,500,0),
('Clan Hall -> Town of Oren',582,82956,53162,-1495,500,0),
 -- 583
('Clan Hall -> Plains of Lizardmen',584,87252,85514,-3056,500,0),
('Clan Hall -> Skyshadow Meadow',585,82764,61145,-3502,500,0),
 -- ('Clan Hall -> Shilen\'s Garden',586,82764,61145,-3502,500,0), -- dunno coords !
 -- ('Clan Hall -> Black Rock Hill',587,82764,61145,-3502,500,0), -- dunno coords !
('Clan Hall -> Spider Nest',588,-56532,78321,-2960,500,0),
('Clan Hall -> Timak Outpost',589,67097,68815,-3648,500,0),-- needs confirming
 -- ('Clan Hall -> Ivory Tower Crater',590,-56532,78321,-2960,500,0),-- dunno coords !
('Clan Hall -> Forest of Evil',591,93218,16969,-3904,500,0),-- needs confirming
('Clan Hall -> Outlaw Forest',592,85995,-2433,-3528,500,0),
 -- ('Clan Hall -> Misty Mountains',593,85995,-2433,-3528,500,0),-- dunno coords !
 -- ('Clan Hall -> Starlight Waterfall',594,85995,-2433,-3528,500,0),-- dunno coords !
 -- ('Clan Hall -> Undine Waterfall',595,85995,-2433,-3528,500,0),-- dunno coords !
 -- ('Clan Hall -> The Gods\' Falls',596,85995,-2433,-3528,500,0), -- dunno coords !
 -- 597
('Clan Hall -> Tower of Insolence',598,114649,11115,-5120,500,0),
('Clan Hall -> The Blazing Swamp',599,146828,-12859,-4455,500,0),
 -- 600
('Clan Hall -> The Forbidden Gateway',601,185395,20359,-3270,500,0),
('Clan Hall -> The Giants Cave',602,174528,52683,-4369,500,0),
('Clan Hall -> Northern Pathway of Enchanted Valley',603,104426,33746,-3800,500,0),
('Clan Hall -> The Cemetery',604,172136,20325,-3326,500,0),
('Clan Hall -> The Forest of Mirrors',605,150477,85907,-2753,500,0),
('Clan Hall -> Anghel Waterfall',606,165584,85997,-2338,500,0),
('Clan Hall -> Aden Castle Town',607,146331,25762,-2018,500,0),
('Clan Hall -> Hunters Village',608,117110,76883,-2695,500,0),
('Clan Hall -> Border Outpost(Aden Side)',609,109699,-7908,-2902,500,0),
('Clan Hall -> Coliseum',610,150086,46733,-3412,500,0),
-- ('Clan Hall -> Narsell Lake',611,150086,46733,-3412,500,0),-- dunno coords !
 -- 612 
('Clan Hall -> Ancient Battleground',613,106517,-2871,-3416,500,0),
('Clan Hall -> Forsaken Plains',614,168217,37990,-4072,500,0),
('Clan Hall -> Silent Valley',615,177318,48447,-3835,500,0),
('Clan Hall -> Hunters Valley',616,114306,86573,-3112,500,0),-- needs confirming
('Clan Hall -> Plains of Glory',617,135756,19557,-3424,500,0),-- needs confirming
('Clan Hall -> Fields of Massacre',618,181726,-7524,-3464,500,0),
('Clan Hall -> War-Torn Plains',619,156898,11217,-4032,500,0),-- needs confirming
('Clan Hall -> Border Outpost(Unknown Side)',620,114172,-18034,-1875,500,0),
('Clan Hall -> Rune Castle Town - Shopping Area',621,43835,-47749,-796,0,0),
('Clan Hall -> Rune Castle Town - Temple',622,38303,-48044,897,0,0),
('Clan Hall -> Rune Castle Town - North Gate',623,38956,-53648,-1343,0,0),
('Clan Hall -> Rune Castle Town - Harbor',624,38025,-38359,-3608,0,0),
('Clan Hall -> Beast Farm',625,42598,-88832,-3124,500,0),
('Clan Hall -> Forest of the Dead - East Entrance',626,61868,-48890,-3128,500,0),
('Clan Hall -> Forest of the Dead - West Entrance',627,45555,-56081,-3667,500,0),
('Clan Hall -> Swamp of Screams - East Entrance',628,94152,-58694,-2832,500,0),
('Clan Hall -> Swamp of Screams - West Entrance',629,69999,-49929,-3253,500,0),
('Clan Hall -> Valley of the Saints',630,65800,-71526,-3747,500,0),
('Clan Hall -> Village Square',631,147728,-56331,-2776,0,0),
('Clan Hall -> North Gate Entrance',632,147731,-58930,-2976,0,0),
('Clan Hall -> East Gate Entrance',633,150561,-57489,-2976,0,0),
('Clan Hall -> West Gate Entrance',634,144866,-57464,-2976,0,0),
('Clan Hall -> Forge of the Gods',635,168902,-116703,-2417,0,0),
('Clan Hall -> Garden of Beasts',636,129138,-60864,-3576,500,0),
('Clan Hall -> Swamp of Screams',637,70006,-49902,-3251,500,0),
('Clan Hall -> Valley of Saints',638,67992,-72012,-3748,500,0),
('Clan Hall -> Monastery of Silence',639,123743,-75032,-2902,500,0),
('Clan Hall -> Wall of Argos',640,164564,-48145,-3536,500,0),
('Clan Hall -> Hot Springs',641,144880,-113468,-2560,500,0),
('Clan Hall -> Ketra Orc Outpost',642,146990,-67128,-3640,500,0),
('Clan Hall -> Goddard Border Checkpoint',643,157560,-33269,-3320,500,0),
('Clan Hall -> Aden Border Checkpoint',644,125381,-33536,-3848,500,0),
('Clan Hall -> Garden of Beasts',645,129138,-60864,-3576,500,0),
('Clan Hall -> Devil\'s Pass',646,106849,-62061,-2968,500,0),
('Clan Hall -> Varka Silenos Outpost',647,125740,-40864,-3736,500,0),
('Clan Hall -> Village Square',648,-82445,150788,-3129,0,0),
('Clan Hall -> North Gate Entrance',649,-83331,148563,-3148,0,0),
('Clan Hall -> East Gate Entrance',650,-78405,152723,-3181,0,0),
('Clan Hall -> Nanmen Entrance',651,-77460,155995,-3194,0,0),
('Clan Hall -> West Gate Entrance',652,-85138,152749,-3160,0,0),
('Clan Hall -> Neutral Zone',653,-10612,75881,-3592,500,0),
('Clan Hall -> Langk Lizardmen Dwellings',654,-36961,201895,-2760,500,0),
('Clan Hall -> Windy Hill',655,-88539,83389,-2864,500,0),
('Clan Hall -> Orc Barracks',656,-85329,106369,-3603,500,0),
('Clan Hall -> Fellmere Harvesting Ground',657,-63736,101522,-3552,500,0),
('Clan Hall -> Ruins of Agony',658,-41055,122647,-2889,500,0),
('Clan Hall -> Abandoned Camp',659,-49853,147089,-2784,500,0),
('Clan Hall -> Forgotten Temple',660,-52369,191259,-3610,500,0),
('Clan Hall -> The Ant Nest',661,-14913,170017,-2893,500,0),
('Clan Hall -> Wasteland',662,-47506,179572,-3669,500,0),
('Clan Hall -> Ol Mahum Checkpoint',663,-17279,208954,-3664,500,0),
('Clan Hall -> Ant Cave South Entrance',664,-16019,193365,-4488,500,0),
('Clan Hall -> Ant Cave East Entrance',665,-10875,175962,-4152,500,0),
('Clan Hall -> Ant Cave West Entrance',666,-25899,172857,-4186,500,0),
('Clan Hall -> Altar of Rites',667,-44311,78617,-3744,500,0),
('Clan Hall -> Windmill Hill',668,-75347,168800,-3632,500,0);

-- Noblesse Teleport
INSERT INTO `teleport` VALUES
-- 1000 adena
('Gludin Arena - 1000 adena',9000,-87328,142266,-3640,1000,0),
('Coliseum - 1000 adena',9001,146440,46723,-3432,1000,0),
('Giran Arena - 1000 adena',9002,73579,142709,-3768,1000,0),
('Forgotten Temple - 1000 adena',9010,-54026,179504,-4640,1000,0),
('Wasteland  - 1000 adena',9011,-47506,179572,-3632,1000,0),
('Silent Valley - 1000 adena',9020,181737,46469,-4352,1000,0),
('Plains of Glory - 1000 adena',9021,135756,19557,-3424,1000,0),
('War-Torn Plains - 1000 adena',9022,156898,11217,-4032,1000,0),
('Tower of Insolence,3rd Floor - 1000 adena',9023,110848,16154,-2120,1000,0),
('Tower of Insolence,5th Floor - 1000 adena',9024,118404,15988,832,1000,0),
('Tower of Insolence,7th Floor - 1000 adena',9025,115064,12181,2960,1000,0),
('Tower of Insolence,10th Floor - 1000 adena',9026,118525,16455,5984,1000,0),
('Tower of Insolence,13th Floor - 1000 adena',9027,115384,16820,9000,1000,0),
('Hunters Valley - 1000 adena',9028,114306,86573,-3112,1000,0),
('Angel Waterfall - 1000 adena',9029,166182,91560,-3168,1000,0),
('Forest of Mirrors - 1000 adena',9030,166080,75574,-2992,1000,0),
('Enchanted Valley - 1000 adena',9031,114674,44150,-3376,1000,0),
('Hunters Valley - 1000 adena',9032,114306,86573,-3112,1000,0),
('Gorgon Flower Garden - 1000 adena',9040,113553,134813,-3640,1000,0),
('Antharas Lair 1 - 1000 adena',9041,147071,120156,-4520,1000,0),
('Antharas Lair 2 - 1000 adena',9042,151689,112615,-5520,1000,0),
('Dragon Valley - 1000 adena',9043,116425,109898,-3424,1000,0),
('Antharas Lair,Heart of Warding - 1000 adena',9044,154396,121235,-3808,1000,0),
('Dragon Valley,Traders Post - 1000 adena',9045,122824,110836,-3720,1000,0),
('Private Hardin\'s Academy - 1000 adena',9046,105918,109759,-3192,1000,0),
('Forest of the Dead - 1000 adena',9050,54425,-41692,-3072,1000,0),
('Valley of Saints - 1000 adena',9051,84092,-80084,-3504,1000,0),
('Cursed Village - 1000 adena',9052,57670,-41672,-3144,1000,0),
('Stakato Nest - 1000 adena',9053,88969,-45307,-2104,1000,0),
('Monastery of Silence - 1000 adena',9054,106414,-87799,-2920,1000,0),
('Varka Silenos Village - 1000 adena',9060,107929,-52248,-2408,1000,0),
('Ketra Orc Village - 1000 adena',9061,149817,-80053,-5576,1000,0),
('Devil\'s Pass - 1000 adena',9062,106349,-61870,-2904,1000,0),
('Garden of Beasts - 1000 adena',9063,132997,-60608,-2960,1000,0),
('Hot Springs - 1000 adena',9064,144625,-101291,-3384,1000,0),
('Wall of Argos - 1000 adena',9065,183140,-53307,-1896,1000,0),
('Wall of Argos - 1000 adena',9066,183140,-53307,-1896,1000,0),
('Four Sepulchers - 1000 adena',9067,178127,-84435,-7216,1000,0),
('Imperial Tomb - 1000 adena',9068,186699,-75915,-2824,1000,0),
('Forge of the Gods,entrance - 1000 adena',9069,169018,-116303,-2432,1000,0),
('Forge of the Gods,entrance - 1000 adena',9070,169018,-116303,-2432,1000,0),
('Forge of the Gods,lower level - 1000 adena',9071,179887,-111241,-5824,1000,0),
('Execution Grounds - 1000 adena',9080,50568,152408,-2656,1000,0),
('Floran Agricultural Area - 1000 adena',9081,26810,172787,-3376,1000,0),
('Cruma Marshlands - 1000 adena',9082,5941,125455,-3640,1000,0),
('Cruma Tower,1st Floor - 1000 adena',9083,17718,117315,-12064,1000,0),
('Cruma Tower,2nd Floor - 1000 adena',9084,17728,110325,-9312,1000,0),
('Frost Lake - 1000 adena',9090,107577,-122392,-3632,1000,0),
('Crypts of Disgrace - 1000 adena',9091,44221,-114232,-2784,1000,0),
('Sky Wagon Relic - 1000 adena',9092,121618,-141554,-1496,1000,0),
('Evil Hunting Grounds - 1000 adena',9100,-6989,109503,-3040,1000,0),
('Neutral Zone - 1000 adena',9101,-18415,85624,-3680,1000,0),
('Dark Forest - 1000 adena',9102,-14129,27094,-3680,1000,0),
('School of Dark Arts - 1000 adena',9103,-49185,49441,-5912,1000,0),
('Elven Ruins - 1000 adena',9104,49315,248452,-5960,1000,0),
('Immortal Plateau - 1000 adena',9105,-25309,-131569,-680,1000,0),
('Mithril Mines - 1000 adena',9106,175499,-181586,-904,1000,0),
('Abandoned Coal Mines - 1000 adena',9107,144706,-173223,-1520,1000,0),
('Forest of Evil - 1000 adena',9110,93218,16969,-3904,1000,0),
('Timak Outpost - 1000 adena',9111,67097,68815,-3648,1000,0),
('Altar of Rites - 1000 adena',9112,-44566,77508,-3736,1000,0),
('Fields of Silence - 1000 adena',9120,69748,186111,-2872,1000,0),
('Field of Whispers - 1000 adena',9121,97786,209303,-3040,1000,0),
('Alligator Island - 1000 adena',9122,113708,178387,-3232,1000,0),
('Garden of Eva,entrance - 1000 adena',9123,82693,242220,-6712,1000,0),
('Garden of Eva,2nd level - 1000 adena',9124,79248,247390,-8816,1000,0),
('Garden of Eva,3rd level - 1000 adena',9125,77868,250400,-9328,1000,0),
('Garden of Eva,4th level - 1000 adena',9126,78721,253309,-9840,1000,0),
('Garden of Eva,5th level - 1000 adena',9127,82951,252354,-10592,1000,0),
-- Olympiad Token
('Gludin Arena - 1 Noble Gate Pass',9900,-87328,142266,-3640,1,1),
('Coliseum - 1 Noble Gate Pass',9901,146440,46723,-3432,1,1),
('Giran Arena - 1 Noble Gate Pass',9902,73579,142709,-3768,1,1),
('Forgotten Temple - 1 Noble Gate Pass',9910,-54026,179504,-4640,1,1),
('Wasteland  - 1 Noble Gate Pass',9911,-47506,179572,-3632,1,1),
('Silent Valley - 1 Noble Gate Pass',9920,181737,46469,-4352,1,1),
('Plains of Glory - 1 Noble Gate Pass',9921,135756,19557,-3424,1,1),
('War-Torn Plains - 1 Noble Gate Pass',9922,156898,11217,-4032,1,1),
('Tower of Insolence,3rd Floor - 1 Noble Gate Pass',9923,110848,16154,-2120,1,1),
('Tower of Insolence,5th Floor - 1 Noble Gate Pass',9924,118404,15988,832,1,1),
('Tower of Insolence,7th Floor - 1 Noble Gate Pass',9925,115064,12181,2960,1,1),
('Tower of Insolence,10th Floor - 1 Noble Gate Pass',9926,118525,16455,5984,1,1),
('Tower of Insolence,13th Floor - 1 Noble Gate Pass',9927,115384,16820,9000,1,1),
('Hunters Valley - 1 Noble Gate Pass',9928,114306,86573,-3112,1,1),
('Angel Waterfall - 1 Noble Gate Pass',9929,166182,91560,-3168,1,1),
('Forest of Mirrors - 1 Noble Gate Pass',9930,166080,75574,-2992,1,1),
('Enchanted Valley - 1 Noble Gate Pass',9931,114674,44150,-3376,1,1),
('Hunters Valley - 1 Noble Gate Pass',9932,114306,86573,-3112,1,1),
('Gorgon Flower Garden - 1 Noble Gate Pass',9940,113553,134813,-3640,1,1),
('Antharas Lair 1 - 1 Noble Gate Pass',9941,147071,120156,-4520,1,1),
('Antharas Lair 2 - 1 Noble Gate Pass',9942,151689,112615,-5520,1,1),
('Dragon Valley - 1 Noble Gate Pass',9943,116425,109898,-3424,1,1),
('Antharas Lair,Heart of Warding - 1 Noble Gate Pass',9944,154396,121235,-3808,1,1),
('Dragon Valley,Traders Post - 1 Noble Gate Pass',9945,122824,110836,-3720,1,1),
('Private Hardin\'s Academy - 1 Noble Gate Pass',9946,105918,109759,-3192,1,1),
('Forest of the Dead - 1 Noble Gate Pass',9950,54425,-41692,-3072,1,1),
('Valley of Saints - 1 Noble Gate Pass',9951,84092,-80084,-3504,1,1),
('Cursed Village - 1 Noble Gate Pass',9952,57670,-41672,-3144,1,1),
('Stakato Nest - 1 Noble Gate Pass',9953,88969,-45307,-2104,1,1),
('Monastery of Silence - 1 Noble Gate Pass',9954,106414,-87799,-2920,1,1),
('Varka Silenos Village - 1 Noble Gate Pass',9960,107929,-52248,-2408,1,1),
('Ketra Orc Village - 1 Noble Gate Pass',9961,149817,-80053,-5576,1,1),
('Devil\'s Pass - 1 Noble Gate Pass',9962,106349,-61870,-2904,1,1),
('Garden of Beasts - 1 Noble Gate Pass',9963,132997,-60608,-2960,1,1),
('Hot Springs - 1 Noble Gate Pass',9964,144625,-101291,-3384,1,1),
('Wall of Argos - 1 Noble Gate Pass',9965,183140,-53307,-1896,1,1),
('Four Sepulchers - 1 Noble Gate Pass',9967,178127,-84435,-7216,1,1),
('Imperial Tomb - 1 Noble Gate Pass',9968,186699,-75915,-2824,1,1),
('Forge of the Gods,entrance - 1 Noble Gate Pass',9970,169018,-116303,-2432,1,1),
('Forge of the Gods,lower level - 1 Noble Gate Pass',9971,179887,-111241,-5824,1,1),
('Execution Grounds - 1 Noble Gate Pass',9980,50568,152408,-2656,1,1),
('Floran Agricultural Area - 1 Noble Gate Pass',9981,26810,172787,-3376,1,1),
('Cruma Marshlands - 1 Noble Gate Pass',9982,5941,125455,-3640,1,1),
('Cruma Tower,1st Floor - 1 Noble Gate Pass',9983,17718,117315,-12064,1,1),
('Cruma Tower,2nd Floor - 1 Noble Gate Pass',9984,17728,110325,-9312,1,1),
('Frost Lake - 1 Noble Gate Pass',9990,107577,-122392,-3632,1,1),
('Crypts of Disgrace - 1 Noble Gate Pass',9991,44221,-114232,-2784,1,1),
('Sky Wagon Relic - 1 Noble Gate Pass',9992,121618,-141554,-1496,1,1),
('Evil Hunting Grounds - 1 Noble Gate Pass',10000,-6989,109503,-3040,1,1),
('Neutral Zone - 1 Noble Gate Pass',10001,-18415,85624,-3680,1,1),
('Dark Forest - 1 Noble Gate Pass',10002,-14129,27094,-3680,1,1),
('School of Dark Arts - 1 Noble Gate Pass',10003,-49185,49441,-5912,1,1),
('Elven Ruins - 1 Noble Gate Pass',10004,49315,248452,-5960,1,1),
('Immortal Plateau - 1 Noble Gate Pass',10005,-25309,-131569,-680,1,1),
('Mithril Mines - 1 Noble Gate Pass',10006,175499,-181586,-904,1,1),
('Abandoned Coal Mines - 1 Noble Gate Pass',10007,144706,-173223,-1520,1,1),
('Forest of Evil - 1 Noble Gate Pass',10010,93218,16969,-3904,1,1),
('Timak Outpost - 1 Noble Gate Pass',10011,67097,68815,-3648,1,1),
('Altar of Rites - 1 Noble Gate Pass',10012,-44566,77508,-3736,1,1),
('Field of Silence - 1 Noble Gate Pass',10020,69748,186111,-2872,1,1),
('Field of Whispers - 1 Noble Gate Pass',10021,97786,209303,-3040,1,1),
('Alligator Island - 1 Noble Gate Pass',10022,113708,178387,-3232,1,1),
('Garden of Eva,entrance - 1 Noble Gate Pass',10023,82693,242220,-6712,1,1),
('Garden of Eva,2nd ring - 1 Noble Gate Pass',10024,79248,247390,-8816,1,1),
('Garden of Eva,3rd ring - 1 Noble Gate Pass',10025,77868,250400,-9328,1,1),
('Garden of Eva,4th ring - 1 Noble Gate Pass',10026,78721,253309,-9840,1,1),
('Garden of Eva,5th level - 1 Noble Gate Pass',10027,82951,252354,-10592,1,1),
('Ketra teleport - Goddard Castle Town',10028,147978,-55408,-2728,4900,0),
('Ketra teleport - Rune Castle Town',10029,43849,-47877,-792,22000,0),
('Ketra teleport - Aden Castle Town',10030,146705,25840,-2000,21000,0),
('Ketra teleport - Wall of Argos',10031,164564,-48145,-3536,7000,0),
('Ketra teleport - Hot Springs',10032,144880,-113468,-2560,6700,0),
('Varka teleport - Goddard Castle Town',10033,147978,-55408,-2728,8000,0),
('Varka teleport - Rune Castle Town',10034,43849,-47877,-792,12000,0),
('Varka teleport - Aden Castle Town',10035,146705,25840,-2000,17000,0),
('Varka teleport - Wall of Argos',10036,164564,-48145,-3536,11000,0),
('Varka teleport - Hot Springs',10037,144880,-113468,-2560,14000,0);

INSERT INTO `teleport` VALUES
('Clan Hall -> Center Town of Aden',12000,147450,28081,-2294,0,0),
('Clan Hall -> North Town of Aden',12001,151950,25094,-2172,0,0),
('Clan Hall -> East Town of Aden',12002,142593,26344,-2425,0,0),
('Clan Hall -> South Town of Aden',12003,147503,32299,-2501,0,0),
('Clan Hall -> West Town of Aden',12004,147465,20737,-2130,0,0),
('Clan Hall -> Southern Pathway of Enchanted Valley',12005,124904,61992,-3920,500,0),
('Clan Hall -> Blazing Swamp',12006,155310,-16339,-3320,500,0),
('Clan Hall -> Plains of Glory',12007,133164,14036,-3888,500,0),
('Clan Hall -> Plains of Fierce Battle',12008,153757,8905,-4024,500,0),
('Clan Hall -> Path to Forest of Wirrors',12009,142065,81300,-3000,500,0),
('Clan Hall -> Anghel Waterfall',12010,166182,91560,-3168,500,0),
('Clan Hall -> West Area of Devastated Castle',12011,168779,-18790,-3184,500,0),
('Clan Hall -> North Path to The Cementery',12012,175191,4082,-2863,500,0),
('Clan Hall -> South Path to The Cementery',12013,175432,30299,-3773,500,0),
('Clan Hall -> Seal of Shilen',12014,184742,19745,-3168,500,0),
('Clan Hall -> Center of Giran Castle Town',12015,81749,149171,-3464,0,0),
('Clan Hall -> North of Giran Castle Town',12016,81525,143821,-3528,0,0),
('Clan Hall -> East of Giran Castle Town',12017,88342,147329,-3400,0,0),
('Clan Hall -> South of Giran Castle Town',12018,81548,152633,-3528,0,0),
('Clan Hall -> West of Giran Castle Town',12019,77305,148636,-3592,0,0),
('Clan Hall -> Devils Isle',12020,43408,206881,-3752,500,0),
('Clan Hall -> Center of Gludin Village',12021,-82445,150788,-3120,0,0),
('Clan Hall -> North of Gludin Village',12022,-83331,148563,-3144,0,0),
('Clan Hall -> East of Gludin Village',12023,-78405,152723,-3168,0,0),
('Clan Hall -> South of Gludin Village',12024,-77460,155995,-3194,0,0),
('Clan Hall -> West of Gludin Village',12025,-85138,152749,-3160,0,0),
('Clan Hall -> Necropolis of Sacrifice',12026,-36961,201895,-2760,500,0),
('Clan Hall -> Oracle Dusk',12027,-93453,89814,-3240,500,0),
('Clan Hall -> Oracle of Dawn',12028,-85329,106369,-3603,500,0),
('Clan Hall -> South Pathway to the Wasterland',12029,-17279,208954,-3664,500,0),
('Clan Hall -> Wasterland',12030,-16526,208032,-3664,500,0),
('Clan Hall -> North of Dion Castle Town',12041,21511,145866,-3153,0,0),
('Clan Hall -> Center of Dion Castle Town',12040,19025,145245,-3107,0,0),
('Clan Hall -> Center of Gludio Castle Town',12033,-14393,123671,-3144,0,0),
('Clan Hall -> North of Gludio Castle Town',12035,-11817,123652,-3079,0,0),
('Clan Hall -> East of Gludio Castle Town',12034,-16796,124108,-3127,0,0),
('Clan Hall -> West of Gludio Castle Town',13037,-14591,121024,-2990,0,0),
('Clan Hall -> Ruins of Despair',12038,-20767,136437,-3923,500,0),
('Clan Hall -> The Ruins Bend',12039,-32664,148626,-3956,500,0),
('Clan Hall -> East of Dion Castle Town',12042,18891,142365,-3051,0,0),
('Clan Hall -> South of Dion Castle Town',12043,17394,147593,-3129,0,0),
('Clan Hall -> West of Dion Castle Town',12044,16582,144130,-2960,0,0),
('Clan Hall -> Plains of Dion',12031,9980,173167,-3734,500,0),
('Clan Hall -> Piligrims Necropolis',12032,46428,127157,-3745,500,0),
('Clan Hall -> Giran Territory',12045,69373,155208,-3746,500,0),
('Clan Hall -> Center of Goddard Castle Town',12046,147728,-56331,-2776,0,0),
('Clan Hall -> North of Goddard Castle Town',12047,147731,-58930,-2976,0,0),
('Clan Hall -> East of Goddard Castle Town',12048,150561,-57489,-2976,0,0),
('Clan Hall -> West of Goddard Castle Town',12049,144866,-57464,-2976,0,0),
('Gludio -> Kamael Village',12050,-117251,46771,360,12000,0),
('Dark Elf Village -> Kamael Village',12051,-117251,46771,360,13000,0),
('Orc Village -> Kamael Village',12052,-117251,46771,360,17000,0),
('Elven Village -> Kamael Village',12053,-117251,46771,360,16000,0),
('Town of Aden -> Kamael Village',12054,-117251,46771,360,26000,0),
('Talking Village -> Kamael Village',12055,-117251,46771,360,20000,0),
('Dwarven Village -> Kamael Village',12056,-117251,46771,360,32000,0),
('Soul Harbor -> Nornil\'s Garden',12057,-119534,87176,-12593,0,0),
('Nornil\'s Garden -> Soul Harbor',12058,-73494,53507,-3680,0,0),
('Underground Coliseum -> Fantasy Isle',12059,-59224,-56837,-2032,0,0),
('Fantasy Isle -> Underground Coliseum',12060,-81490,-49167,-10352,0,0),
('Clan Hall Schuttgart -> Village Square',12061,87379,-142322,-1336,0,0),
('Clan Hall Schuttgart -> West Gate Entrance',12062,84753,-141051,-1536,0,0),
('Clan Hall Schuttgart -> South Gate Entrance',12063,87343,-139802,-1536,0,0),
('Clan Hall Schuttgart -> East Gate Entrance',12064,89959,-141034,-1536,0,0),
('Clan Hall Schuttgart -> Crypt of Disgrace',12065,47692,-115745,-3744,500,0),
('Clan Hall Schuttgart -> Plunderous Plains',12066,111965,-154172,-1528,500,0),
('Clan Hall Schuttgart -> Den of Evil',12067,68693,-110438,-1904,500,0),
('Clan Hall Schuttgart -> Frozen Labyrinth',12068,113903,-108752,-848,500,0),
('Gludio Castle -> Front of the Gludio Castle',13000,-15043,116596,-3208,0,0),
('Gludio Castle -> Gludio Town Square',13001,-14393,123671,-3112,0,0),
('Gludio Castle -> Front of the Shanty Fortress',13002,-58761,154663,-2664,0,0),
('Gludio Castle -> Front of the Southern Fortress',13003,-29856,214275,-3680,0,0),
('Gludio Castle -> Ruins of Agony',13004,-41248,122848,-2904,500,0),
('Gludio Castle -> Ruins of Despair',13005,-19120,136816,-3752,500,0),
('Gludio Castle -> The Ant Nest',13006,-9959,176184,-4160,500,0),
('Gludio Castle -> Windawood Manor',13007,-28327,155125,-3496,500,0),
('Dragonspine Fort -> Fort North Gate', 12100, 12497, 93855, -3425, 0, 0),
('Dragonspine Fort -> Fort South Gate', 12101, 10486, 96307, -3425, 0, 0),
('Dragonspine Fort -> Dion Town Square', 12102, 18748, 145437, -3127, 0, 0),
('Dragonspine Fort -> Oren Town Square', 12103, 82321, 55139, -1524, 0, 0),
('Dragonspine Fort -> The Ant Nest', 12104, -25832, 173118, -4154, 500, 0),
('Dragonspine Fort -> Windawood Manor', 12105, -25791, 162013, -2528, 500, 0),
('Dragonspine Fort -> Sea of Spores', 12106, 62425, 30856, -3774, 500, 0),
('Dragonspine Fort -> Ancient Battleground', 12107, 108264, -2846, -3428, 500, 0),
('Fantasy Isle -> Krateis Cube', 12108, -70293, -71029, -1416, 0, 0),
('Krateis Cube -> Fantasy Isle', 12109, -59224, -56837, -2032, 0, 0),
('Demon Fort -> Fortress West Gate', 12110, 98920, -56423, -624, 0, 0),
('Demon Fort -> Fortress East Gate', 12111, 102390, -54320, -632, 0, 0),
('Demon Fort -> Rune Town Square', 12112, 43889, -49101, -792, 0, 0),
('Demon Fort -> Goddard Town Square', 12113, 147728, -56331, -2776, 0, 0),
('Demon Fort -> Swamp of Screams', 12114, 69340, -50203, -3288, 500, 0),
('Demon Fort -> Valley of Saints', 12115, 65307, -71445, -3688, 500, 0),
('Demon Fort -> Entrance to the Forge of the Gods', 12116, 169018, -116303, -2432, 500, 0),
('Demon Fort -> Wall of Argos', 12117, 165054, -47861, -3560, 500, 0),
('Gludio -> Airship dock', 12118, -149406, 255247, -80, 0, 0),
('Airship dock -> Talking Island', 12119, -84752, 243122, -3728, 0, 0),
('Talking Island -> Airship dock', 12120, -149406, 255247, -80, 0, 0),
('Fantasy Isle -> Handys Block', 12121, -57328, -60566, -2360, 0, 0),
('Keucereus -> Heart of Infinity', 12122, -204288, 242026, 1744, 0, 0),
('Guide of Immortality -> Seed of Infinity', 14000, -183292, 206063, -12888, 0, 0),
('Gatekeeper of the Abyss -> Seed of Infinity', 14001, -212836, 209824, 4288, 0, 0),
('Valley Fort -> Fortress North Gate', 12123, 126066, 120350, -2584, 0, 0),
('Valley Fort -> Fortress South Gate', 12124, 126023, 125853, -2584, 0, 0),
('Valley Fort -> Giran Town Square', 12125, 81749, 149171, -3464, 0, 0),
('Valley Fort -> Front of the Giran Castle Gate', 12126, 107954, 145841, -3224, 0, 0),
('Valley Fort -> Brekas Stronghold', 12127, 85546, 131328, -3672, 500, 0),
('Valley Fort -> Devils Isle', 12128, 43408, 206811, -3752, 500, 0),
('Valley Fort -> Dragon Valley', 12129, 73024, 118485, -3688, 500, 0),
('Valley Fort -> Tanor Canyon', 12130, 60374, 164301, -2856, 500, 0),
('Tanor Fort -> Fortress North Gate', 12131, 58923, 137789, -1752, 0, 0),
('Tanor Fort -> Fortress South Gate', 12132, 61551, 141036, -1752, 0, 0),
('Tanor Fort -> Dion Town Square', 12133, 19025, 145245, -3120, 0, 0),
('Tanor Fort -> Giran Town Square', 12134, 81749, 149171, -3464, 0, 0),
('Tanor Fort -> The Ant Nest', 12135, -9959, 176184, -4160, 500, 0),
('Tanor Fort -> Windawood Manor', 12136, -28327, 155125, -3496, 500, 0),
('Tanor Fort -> Dragon Valley', 12137, 73024, 118485, -3688, 500, 0),
('Tanor Fort -> Tanor Canyon', 12138, 60374, 164301, -2856, 500, 0),
('Handys Block -> Fantasy Isle', 12139, -59157, -56906, -2032, 0, 0),
('Monastic Fort -> Fortress North Gate', 12140, 72388, -96770, -1424, 0, 0),
('Monastic Fort -> Fortress South Gate', 12141, 71937, -92600, -1416, 0, 0),
('Monastic Fort -> Rune Town Square', 12142, 43889, -49101, -792, 0, 0),
('Monastic Fort -> Schuttgart Town Square', 12143, 87379, -142322, -1336, 0, 0),
('Monastic Fort -> Swamp of Screams', 12144, 69340, -50203, -3288, 500, 0),
('Monastic Fort -> Valley of Saints', 12145, 65307, -71445, -3688, 500, 0),
('Monastic Fort -> Den of Evil', 12146, 68693, -110438, -1904, 500, 0),
('Monastic Fort -> Frozen Labyrinth', 12147, 113910, -108732, -848, 500, 0),
('Narsell Fortress -> Fortress West Gate', 12148, 153112, 56872, -3256, 0, 0),
('Narsell Fortress -> Fortress East Gate', 12149, 156730, 53921, -3256, 0, 0),
('Narsell Fortress -> Aden Town Square', 12150, 147450, 28081, -2264, 0, 0),
('Narsell Fortress -> Front of the Aden Castle Gate', 12151, 147428, 20161, -2008, 0, 0),
('Narsell Fortress -> Ancient Battleground', 12152, 118509, -4779, -4000, 500, 0),
('Narsell Fortress -> Enchanted Valley, Southern Region', 12153, 124904, 61992, -3920, 500, 0),
('Narsell Fortress -> Enchanted Valley, Northern Region', 12154, 104426, 33746, -3800, 500, 0),
('Narsell Fortress -> Blazing Swamp', 12155, 155310, -16339, -3320, 500, 0),
('Hive Fortress -> Fortress North Gate', 12156, 15383, 186025, -2920, 0, 0),
('Hive Fortress -> Fortress South Gate', 12157, 18046, 190017, -2920, 0, 0),
('Hive Fortress -> Dion Town Square', 12158, 19025, 145245, -3120, 0, 0),
('Hive Fortress -> Front of the Dion Castle Gate', 12159, 19888, 153395, -3144, 0, 0),
('Hive Fortress -> Cruma Marshlands', 12160, 5106, 126916, -3664, 500, 0),
('Hive Fortress -> Fortress of Resistance', 12161, 47382, 111278, -2104, 500, 0),
('Hive Fortress -> Plains of Dion', 12162, 630, 179184, -3720, 500, 0),
('Hive Fortress -> Tanor Canyon', 12163, 60374, 164301, -2856, 500, 0),
('White Sands Fortress -> Fortress West Gate', 12164, 116336, 203775, -3336, 0, 0),
('White Sands Fortress -> Fortress East Gate', 12165, 120487, 206093, -3336, 0, 0),
('White Sands Fortress -> Heine Town Square', 12166, 111455, 219400, -3544, 0, 0),
('White Sands Fortress -> Front of the Innadril Castle Gate', 12167, 117608, 241660, -1408, 0, 0),
('White Sands Fortress -> Field of Silence (Western Section)', 12168, 75387, 195263, -3000, 500, 0),
('White Sands Fortress -> Field of Whispers (Eastern Section)', 12169, 47382, 111278, -2104, 500, 0),
('White Sands Fortress -> The Center of Alligator Island', 12170, 113708, 178387, -3232, 500, 0),
('White Sands Fortress -> Inside the Garden of Eva', 12171, 82693, 242220, -6712, 500, 0),
('Archaic Fortress -> Fortress West Gate', 12172, 107248, -140450, -2960, 0, 0),
('Archaic Fortress -> Fortress East Gate', 12173, 111769, -141775, -2920, 0, 0),
('Archaic Fortress -> Schuttgart Town Square', 12174, 87379, -142322, -1336, 0, 0),
('Archaic Fortress -> Front of the Schuttgart Castle Gate', 12175, 76358, -145548, -1176, 0, 0),
('Archaic Fortress -> Crypts of Disgrace', 12176, 47692, -115745, -3744, 500, 0),
('Archaic Fortress -> Plunderous Plains', 12177, 111965, -154172, -1528, 500, 0),
('Archaic Fortress -> Den of Evil', 12178, 68693, -110438, -1904, 500, 0),
('Archaic Fortress -> Frozen Labyrinth', 12179, 113903, -108752, -848, 500, 0);

-- Castle teleports
INSERT INTO `teleport` VALUES
('Gludio Outer -> Out',2001,-18372,113315,-2760,0,0),
('Gludio Outer -> In',2002,-18395,112831,-2768,0,0),
('Gludio Inner -> Out',2003,-18115,110679,-2528,0,0),
('Gludio Inner -> In',2004,-18123,110210,-2512,0,0),
('Dion Outer -> Out',2005,22315,156447,-2962,0,0),
('Dion Outer -> In',2006,22315,156909,-2962,0,0),
('Dion Inner -> Out',2007,22073,159057,-2725,0,0),
('Dion Inner -> In',2008,22073,159516,-2706,0,0),
('Giran Outer -> Out',2009,112568,144869,-2835,0,0),
('Giran Outer -> In',2010,113123,144869,-2835,0,0),
('Giran Inner -> Out',2011,115209,145089,-2604,0,0),
('Giran Inner -> In',2012,115727,145096,-2579,0,0),
('Oren Outer -> Out',2013,78618,36955,-2562,0,0),
('Oren Outer -> In',2014,79211,36955,-2562,0,0),
('Oren Inner -> Out',2015,81285,37190,-2337,0,0),
('Oren Inner -> In',2016,81789,37190,-2306,0,0),
('Aden Outer -> Out',2017,147455,8808,-495,0,0),
('Aden Outer -> In',2018,147455,7966,-470,0,0),
('Aden Inner -> Out',2019,145616,4614,-436,0,0),
('Aden Inner -> In',2020,146374,4599,-403,0,0),
('Aden Inner -> Out',2021,149283,4610,-432,0,0),
('Aden Inner -> In',2022,148575,4607,-403,0,0),
('Aden Hall -> Out',2023,147456,6357,-407,0,0),
('Aden Hall -> In',2024,147456,6058,-407,0,0),
('Aden Terrace -> Out',2025,147458,2010,217,0,0),
('Aden Terrace -> In',2026,147458,2408,219,0,0),
('Innadril Outer -> Out',2027,116263,245174,-1058,0,0),
('Innadril Outer -> In',2028,116263,245750,-1058,0,0),
('Innadril Inner -> Out',2029,116021,247821,-826,0,0),
('Innadril Inner -> In',2030,116021,248272,-805,0,0),
('Goddard Outer -> Out',2031,147459,-45221,-2084,0,0),
('Goddard Outer -> In',2032,147459,-45789,-2084,0,0),
('Goddard Inner -> Out',2033,145514,-48241,-2383,0,0),
('Goddard Inner -> In',2034,146026,-48241,-2383,0,0),
('Goddard Inner -> Out',2035,149430,-48245,-2383,0,0),
('Goddard Inner -> In',2036,148928,-48245,-2383,0,0),
('Goddard Terrace -> Out',2037,148748,-48951,-687,0,0),
('Goddard Terrace -> In',2038,148736,-49201,-688,0,0),
('Goddard Terrace -> Out',2039,146177,-48942,-687,0,0),
('Goddard Terrace -> In',2040,146181,-49209,-686,0,0),
('Rune Outer -> Out',2041,18788,-49149,-1240,0,0),
('Rune Outer -> In',2042,17716,-49149,-1190,0,0),
('Rune Inner -> Out',2043,16037,-49149,-1060,0,0),
('Rune Inner -> In',2044,15573,-49162,-1058,0,0),
('Rune Inner -> Out',2045,12858,-51332,-1089,0,0),
('Rune Inner -> In',2046,12858,-50860,-1089,0,0),
('Schuttgart Outer -> Out',2047,77544,-149250,-355,0,0),
('Schuttgart Outer -> In',2048,77544,-149869,-355,0,0),
('Schuttgart Inner -> Out',2049,75577,-152303,-651,0,0),
('Schuttgart Inner -> In',2050,76091,-152303,-651,0,0),
('Schuttgart Inner -> Out',2051,79519,-152303,-651,0,0),
('Schuttgart Inner -> In',2052,79009,-152303,-651,0,0),
('Schuttgart Terrace -> Out',2053,76260,-152991,1044,0,0),
('Schuttgart Terrace -> In',2054,76267,-153275,1044,0,0),
('Schuttgart Terrace -> Out',2055,78843,-153008,1044,0,0),
('Schuttgart Terrace -> In',2056,78832,-153271,1044,0,0);

-- Gracia Epilogue
INSERT INTO `teleport` VALUES
('News Informer -> Forge of the Gods',200901,169018,-116303,-2432,10000,0),
('News Informer -> Primeval Isle Wharf',200902,11235,-24026,-3640,10000,0),
('News Informer -> The Giant\'s Cave',200903,174491,50942,-4360,10000,0),
('News Informer -> Den of Evil',200904,68693,-110438,-1904,10000,0),
('News Informer -> Mithril Mines Western Entrance',200905,171946,-173352,3440,10000,0),
('News Informer -> Mithril Mines Eastern Entrance',200906,178591,-184615,360,10000,0),
('News Informer -> Field of Silence',200907,87691,162835,-3520,10000,0),
('News Informer -> Field of Whispers',200908,82192,226128,-3656,10000,0),
('News Informer -> Crypts of Disgrace',200909,47692,-115745,-3744,10000,0),
('News Informer -> Stakato Nest',200910,89513,-44800,-2136,10000,0),
('News Informer -> Town of Giran',200911,83551,147945,-3400,100000,0),
('News Informer -> Town of Aden',200912,146783,25808,-2008,100000,0),
('News Informer -> Town of Oren',200913,82971,53207,-1488,100000,0),
('News Informer -> Rune Township',200914,43835,-47749,-792,100000,0),
('News Informer -> Town of Goddard',200915,148024,-55281,-2728,100000,0),
('Primeval Isle -> Rune Township',200916,43835,-47749,-792,50000,0),
('Rune Township -> Primeval Isle',200917,11235,-24026,-3640,6400,0),
('Heine -> Isle of Prayer',200918,149518,195280,-3736,7200,0),
('Giant\'s Cave -> Lower',200919,191754,56760,-7624,0,0),
('Giant\'s Cave -> Upper',200920,183985,61424,-3992,0,0),
('Giran Harbor -> Pirate\'s Palace',200921,52241,218775,-3224,0,0),
('Aden GK -> The Giant\'s Cave',200922,174491,50942,-4360,7400,0),
('FoG Entrance -> FoG Upper Level',200923,173492,-112272,-5192,0,0),
('Krun -> Enter Mines ',200924,173462,-174011,3480,0,0),
('Tarum -> Enter Mines ',200925,179299,-182831,-224,0,0),
('Goddard -> Forge of the Gods',200926,169018,-116303,-2432,10000,0);
