/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.Server;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.GmListTable;
import com.l2jserver.gameserver.ItemsAutoDestroy;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.MonsterRace;
import com.l2jserver.gameserver.RecipeController;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.Shutdown;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.TradeController;
import com.l2jserver.gameserver.cache.CrestCache;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.AccessLevels;
import com.l2jserver.gameserver.datatables.AdminCommandAccessRights;
import com.l2jserver.gameserver.datatables.ArmorSetsTable;
import com.l2jserver.gameserver.datatables.AugmentationData;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.datatables.CharTemplateTable;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.EnchantGroupsTable;
import com.l2jserver.gameserver.datatables.EnchantHPBonusData;
import com.l2jserver.gameserver.datatables.EventDroplist;
import com.l2jserver.gameserver.datatables.ExtractableItemsData;
import com.l2jserver.gameserver.datatables.ExtractableSkillsData;
import com.l2jserver.gameserver.datatables.FishTable;
import com.l2jserver.gameserver.datatables.GMSkillTable;
import com.l2jserver.gameserver.datatables.HelperBuffTable;
import com.l2jserver.gameserver.datatables.HennaTable;
import com.l2jserver.gameserver.datatables.HennaTreeTable;
import com.l2jserver.gameserver.datatables.HeroSkillTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.LevelUpData;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.MerchantPriceConfigTable;
import com.l2jserver.gameserver.datatables.NobleSkillTable;
import com.l2jserver.gameserver.datatables.NpcBufferTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.NpcWalkerRoutesTable;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.datatables.PetSkillsTable;
import com.l2jserver.gameserver.datatables.ResidentialSkillTable;
import com.l2jserver.gameserver.datatables.SkillSpellbookTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreeTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.datatables.StaticObjects;
import com.l2jserver.gameserver.datatables.SummonItemsData;
import com.l2jserver.gameserver.datatables.TeleportLocationTable;
import com.l2jserver.gameserver.datatables.UITable;
import com.l2jserver.gameserver.geoeditorcon.GeoEditorListener;
import com.l2jserver.gameserver.handler.AdminCommandHandler;
import com.l2jserver.gameserver.handler.ChatHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.handler.SkillHandler;
import com.l2jserver.gameserver.handler.UserCommandHandler;
import com.l2jserver.gameserver.handler.VoicedCommandHandler;
import com.l2jserver.gameserver.handlers.admincommandhandlers.AdminShutdown;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.AirShipManager;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.BoatManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.CleanUpManager;
import com.l2jserver.gameserver.instancemanager.CoupleManager;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.DayNightSpawnManager;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.FourSepulchersManager;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.HellboundManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.instancemanager.PetitionManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.RaidBossPointsManager;
import com.l2jserver.gameserver.instancemanager.RaidBossSpawnManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.instancemanager.TransformationManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.instancemanager.grandbosses.FrintezzaManager;
import com.l2jserver.gameserver.instancemanager.grandbosses.SailrenManager;
import com.l2jserver.gameserver.instancemanager.grandbosses.VanHalterManager;
import com.l2jserver.gameserver.instancemanager.lastimperialtomb.LastImperialTombManager;
import com.l2jserver.gameserver.model.AutoChatHandler;
import com.l2jserver.gameserver.model.AutoSpawnHandler;
import com.l2jserver.gameserver.model.L2Manor;
import com.l2jserver.gameserver.model.L2Multisell;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.PartyMatchWaitingList;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.model.entity.TvTManager;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.L2GamePacketHandler;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.pathfinding.PathFinding;
import com.l2jserver.gameserver.script.faenor.FaenorScriptEngine;
import com.l2jserver.gameserver.scripting.CompiledScriptCache;
import com.l2jserver.gameserver.scripting.L2ScriptEngineManager;
import com.l2jserver.gameserver.taskmanager.AutoAnnounceTaskManager;
import com.l2jserver.gameserver.taskmanager.KnownListUpdateTaskManager;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.util.DynamicExtension;
import com.l2jserver.status.Status;
import com.l2jserver.util.DeadLockDetector;
import com.l2jserver.util.IPv4Filter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.mmocore.network.IAcceptFilter;
import org.mmocore.network.IClientFactory;
import org.mmocore.network.IMMOExecutor;
import org.mmocore.network.IPacketHandler;
import org.mmocore.network.SelectorConfig;
import org.mmocore.network.SelectorThread;

public class GameServer {
    private static final Logger _log = Logger.getLogger(GameServer.class.getName());
    private final SelectorThread<L2GameClient> _selectorThread;
    private final DeadLockDetector _deadDetectThread;
    private final IdFactory _idFactory;
    public static GameServer gameServer;
    private LoginServerThread _loginThread;
    private static Status _statusServer;
    public final long serverLoadEnd;
    @Deprecated
    public static final Calendar dateTimeServerStarted;

    public long getUsedMemoryMB() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
    }

    public SelectorThread<L2GameClient> getSelectorThread() {
        return this._selectorThread;
    }

    public DeadLockDetector getDeadLockDetectorThread() {
        return this._deadDetectThread;
    }

    public GameServer() throws Exception {
        long serverLoadStart = System.currentTimeMillis();
        gameServer = this;
        _log.finest("used mem:" + this.getUsedMemoryMB() + "MB");
        if (Config.SERVER_VERSION != null) {
            _log.info("L2J Server Version:    " + Config.SERVER_VERSION);
        }
        if (Config.DATAPACK_VERSION != null) {
            _log.info("L2J Datapack Version:  " + Config.DATAPACK_VERSION);
        }
        this._idFactory = IdFactory.getInstance();
        if (!this._idFactory.isInitialized()) {
            _log.severe("Could not read object IDs from DB. Please Check Your Data.");
            throw new Exception("Could not initialize the ID factory");
        }
        ThreadPoolManager.getInstance();
        new File(Config.DATAPACK_ROOT, "data/crests").mkdirs();
        new File("log/game").mkdirs();
        GameServer.printSection("Engines");
        L2ScriptEngineManager.getInstance();
        GameServer.printSection("World");
        GameTimeController.getInstance();
        InstanceManager.getInstance();
        L2World.getInstance();
        MapRegionTable.getInstance();
        Announcements.getInstance();
        GameServer.printSection("Skills");
        EnchantGroupsTable.getInstance();
        SkillTable.getInstance();
        SkillTreeTable.getInstance();
        PetSkillsTable.getInstance();
        NobleSkillTable.getInstance();
        GMSkillTable.getInstance();
        HeroSkillTable.getInstance();
        ResidentialSkillTable.getInstance();
        SkillSpellbookTable.getInstance();
        GameServer.printSection("Items");
        ItemTable.getInstance();
        ExtractableItemsData.getInstance();
        ExtractableSkillsData.getInstance();
        SummonItemsData.getInstance();
        EnchantHPBonusData.getInstance();
        MerchantPriceConfigTable.getInstance().loadInstances();
        TradeController.getInstance();
        L2Multisell.getInstance();
        RecipeController.getInstance();
        ArmorSetsTable.getInstance();
        FishTable.getInstance();
        SkillSpellbookTable.getInstance();
        GameServer.printSection("Characters");
        CharTemplateTable.getInstance();
        CharNameTable.getInstance();
        LevelUpData.getInstance();
        AccessLevels.getInstance();
        AdminCommandAccessRights.getInstance();
        GmListTable.getInstance();
        PetDataTable.getInstance().loadPetsData();
        GameServer.printSection("Clans");
        ClanTable.getInstance();
        ClanHallManager.getInstance();
        AuctionManager.getInstance();
        GameServer.printSection("Geodata");
        GeoData.getInstance();
        if (Config.GEODATA == 2) {
            PathFinding.getInstance();
        }
        GameServer.printSection("NPCs");
        NpcTable.getInstance();
        NpcWalkerRoutesTable.getInstance();
        ZoneManager.getInstance();
        DoorTable.getInstance();
        StaticObjects.getInstance();
        CastleManager.getInstance().loadInstances();
        FortManager.getInstance().loadInstances();
        NpcBufferTable.getInstance();
        SpawnTable.getInstance();
        RaidBossSpawnManager.getInstance();
        DayNightSpawnManager.getInstance().notifyChangeMode();
        GrandBossManager.getInstance().initZones();
        RaidBossPointsManager.init();
        FourSepulchersManager.getInstance().init();
        DimensionalRiftManager.getInstance();
        EventDroplist.getInstance();
        GameServer.printSection("Siege");
        SiegeManager.getInstance().getSieges();
        FortSiegeManager.getInstance();
        TerritoryWarManager.getInstance();
        CastleManorManager.getInstance();
        MercTicketManager.getInstance();
        L2Manor.getInstance();
        GameServer.printSection("Olympiad");
        Olympiad.getInstance();
        Hero.getInstance();
        GameServer.printSection("Cache");
        HtmCache.getInstance();
        CrestCache.getInstance();
        TeleportLocationTable.getInstance();
        UITable.getInstance();
        PartyMatchWaitingList.getInstance();
        PartyMatchRoomList.getInstance();
        PetitionManager.getInstance();
        HennaTable.getInstance();
        HennaTreeTable.getInstance();
        HelperBuffTable.getInstance();
        AugmentationData.getInstance();
        CursedWeaponsManager.getInstance();
        GameServer.printSection("Scripts");
        QuestManager.getInstance();
        TransformationManager.getInstance();
        BoatManager.getInstance();
        AirShipManager.getInstance();
        try {
            _log.info("Loading Server Scripts");
            File scripts = new File(Config.DATAPACK_ROOT + "/data/scripts.cfg");
            if (!Config.ALT_DEV_NO_HANDLERS || !Config.ALT_DEV_NO_QUESTS) {
                L2ScriptEngineManager.getInstance().executeScriptList(scripts);
            }
        }
        catch (IOException ioe) {
            _log.severe("Failed loading scripts.cfg, no script going to be loaded");
        }
        if (AdminCommandHandler.getInstance().getAdminCommandHandler("admin_server_shutdown") == null) {
            AdminCommandHandler.getInstance().registerAdminCommandHandler(new AdminShutdown());
        }
        try {
            CompiledScriptCache compiledScriptCache = L2ScriptEngineManager.getInstance().getCompiledScriptCache();
            if (compiledScriptCache == null) {
                _log.info("Compiled Scripts Cache is disabled.");
            } else {
                compiledScriptCache.purge();
                if (compiledScriptCache.isModified()) {
                    compiledScriptCache.save();
                    _log.info("Compiled Scripts Cache was saved.");
                } else {
                    _log.info("Compiled Scripts Cache is up-to-date.");
                }
            }
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, "Failed to store Compiled Scripts Cache.", e);
        }
        QuestManager.getInstance().report();
        TransformationManager.getInstance().report();
        if (Config.SAVE_DROPPED_ITEM) {
            ItemsOnGroundManager.getInstance();
        }
        if (Config.AUTODESTROY_ITEM_AFTER > 0 || Config.HERB_AUTO_DESTROY_TIME > 0) {
            ItemsAutoDestroy.getInstance();
        }
        MonsterRace.getInstance();
        SevenSigns.getInstance().spawnSevenSignsNPC();
        SevenSignsFestival.getInstance();
        AutoSpawnHandler.getInstance();
        AutoChatHandler.getInstance();
        FaenorScriptEngine.getInstance();
        SailrenManager.getInstance().init();
        VanHalterManager.getInstance().init();
        LastImperialTombManager.getInstance().init();
        FrintezzaManager.getInstance().init();
        _log.info("AutoChatHandler: Loaded " + AutoChatHandler.getInstance().size() + " handlers in total.");
        _log.info("AutoSpawnHandler: Loaded " + AutoSpawnHandler.getInstance().size() + " handlers in total.");
        AdminCommandHandler.getInstance();
        ChatHandler.getInstance();
        ItemHandler.getInstance();
        SkillHandler.getInstance();
        UserCommandHandler.getInstance();
        VoicedCommandHandler.getInstance();
        if (Config.L2JMOD_ALLOW_WEDDING) {
            CoupleManager.getInstance();
        }
        TaskManager.getInstance();
        MerchantPriceConfigTable.getInstance().updateReferences();
        CastleManager.getInstance().activateInstances();
        FortManager.getInstance().activateInstances();
        HellboundManager.getInstance();
        if (Config.ALLOW_MAIL) {
            MailManager.getInstance();
        }
        if (Config.ACCEPT_GEOEDITOR_CONN) {
            GeoEditorListener.getInstance();
        }
        Runtime.getRuntime().addShutdownHook(Shutdown.getInstance());
        CleanUpManager.getInstance().execute();
        _log.info("IdFactory: Free ObjectID's remaining: " + IdFactory.getInstance().size());
        try {
            DynamicExtension.getInstance();
        }
        catch (Exception ex) {
            _log.log(Level.WARNING, "DynamicExtension could not be loaded and initialized", ex);
        }
        TvTManager.getInstance();
        KnownListUpdateTaskManager.getInstance();
        if (Config.DEADLOCK_DETECTOR) {
            this._deadDetectThread = new DeadLockDetector();
            this._deadDetectThread.setDaemon(true);
            this._deadDetectThread.start();
        } else {
            this._deadDetectThread = null;
        }
        System.gc();
        long freeMem = (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory()) / 0x100000L;
        long totalMem = Runtime.getRuntime().maxMemory() / 0x100000L;
        _log.info("GameServer Started, free memory " + freeMem + " Mb of " + totalMem + " Mb");
        this._loginThread = LoginServerThread.getInstance();
        this._loginThread.start();
        CommunityServerThread.initialize();
        SelectorConfig sc = new SelectorConfig();
        sc.MAX_READ_PER_PASS = Config.MMO_MAX_READ_PER_PASS;
        sc.MAX_SEND_PER_PASS = Config.MMO_MAX_SEND_PER_PASS;
        sc.SLEEP_TIME = Config.MMO_SELECTOR_SLEEP_TIME;
        sc.HELPER_BUFFER_COUNT = Config.MMO_HELPER_BUFFER_COUNT;
        L2GamePacketHandler gph = new L2GamePacketHandler();
        this._selectorThread = new SelectorThread(sc, (IMMOExecutor)gph, (IPacketHandler)gph, (IClientFactory)gph, (IAcceptFilter)new IPv4Filter());
        InetAddress bindAddress = null;
        if (!Config.GAMESERVER_HOSTNAME.equals("*")) {
            try {
                bindAddress = InetAddress.getByName(Config.GAMESERVER_HOSTNAME);
            }
            catch (UnknownHostException e1) {
                _log.log(Level.SEVERE, "WARNING: The GameServer bind address is invalid, using all avaliable IPs. Reason: " + e1.getMessage(), e1);
            }
        }
        try {
            this._selectorThread.openServerSocket(bindAddress, Config.PORT_GAME);
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, "FATAL: Failed to open server socket. Reason: " + e.getMessage(), e);
            System.exit(1);
        }
        this._selectorThread.start();
        _log.info("Maximum Numbers of Connected Players: " + Config.MAXIMUM_ONLINE_USERS);
        this.serverLoadEnd = System.currentTimeMillis();
        _log.info("Server Loaded in " + (this.serverLoadEnd - serverLoadStart) / 1000L + " seconds");
        AutoAnnounceTaskManager.getInstance();
    }

    public static void main(String[] args) throws Exception {
        Server.serverMode = 1;
        String LOG_FOLDER = "log";
        String LOG_NAME = "./log.cfg";
        File logFolder = new File(Config.DATAPACK_ROOT, "log");
        logFolder.mkdir();
        FileInputStream is = new FileInputStream(new File("./log.cfg"));
        LogManager.getLogManager().readConfiguration(is);
        ((InputStream)is).close();
        is = null;
        Config.load();
        GameServer.printSection("Database");
        L2DatabaseFactory.getInstance();
        if (Config.IS_TELNET_ENABLED) {
            _statusServer = new Status(Server.serverMode);
            _statusServer.start();
        } else {
            _log.info("Telnet server is currently disabled.");
        }
        gameServer = new GameServer();
    }

    public static void printSection(String s) {
        s = "=[ " + s + " ]";
        while (s.length() < 78) {
            s = "-" + s;
        }
        _log.info(s);
    }

    static {
        dateTimeServerStarted = Calendar.getInstance();
    }
}

