/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2ManufactureItem;
import com.l2jserver.gameserver.model.L2RecipeInstance;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.L2RecipeStatInstance;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.RecipeBookItemList;
import com.l2jserver.gameserver.network.serverpackets.RecipeItemMakeInfo;
import com.l2jserver.gameserver.network.serverpackets.RecipeShopItemInfo;
import com.l2jserver.gameserver.network.serverpackets.SetupGauge;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RecipeController {
    protected static final Logger _log = Logger.getLogger(RecipeController.class.getName());
    private Map<Integer, L2RecipeList> _lists = new FastMap();
    protected static final Map<Integer, RecipeItemMaker> _activeMakers = Collections.synchronizedMap(new WeakHashMap());
    private static final String RECIPES_FILE = "recipes.xml";

    public static RecipeController getInstance() {
        return SingletonHolder._instance;
    }

    private RecipeController() {
        try {
            this.loadFromXML();
            _log.info("RecipeController: Loaded " + this._lists.size() + " recipes.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed loading recipe list", e);
        }
    }

    public int getRecipesCount() {
        return this._lists.size();
    }

    public L2RecipeList getRecipeList(int listId) {
        return this._lists.get(listId);
    }

    public L2RecipeList getRecipeByItemId(int itemId) {
        for (L2RecipeList find : this._lists.values()) {
            if (find.getRecipeId() != itemId) continue;
            return find;
        }
        return null;
    }

    public int[] getAllItemIds() {
        int[] idList = new int[this._lists.size()];
        int i = 0;
        for (L2RecipeList rec : this._lists.values()) {
            idList[i++] = rec.getRecipeId();
        }
        return idList;
    }

    public synchronized void requestBookOpen(L2PcInstance player, boolean isDwarvenCraft) {
        RecipeItemMaker maker = null;
        if (Config.ALT_GAME_CREATION) {
            maker = _activeMakers.get(player.getObjectId());
        }
        if (maker == null) {
            RecipeBookItemList response = new RecipeBookItemList(isDwarvenCraft, player.getMaxMp());
            response.addRecipes(isDwarvenCraft ? player.getDwarvenRecipeBook() : player.getCommonRecipeBook());
            player.sendPacket(response);
            return;
        }
        player.sendPacket(new SystemMessage(SystemMessageId.CANT_ALTER_RECIPEBOOK_WHILE_CRAFTING));
    }

    public synchronized void requestMakeItemAbort(L2PcInstance player) {
        _activeMakers.remove(player.getObjectId());
    }

    public synchronized void requestManufactureItem(L2PcInstance manufacturer, int recipeListId, L2PcInstance player) {
        RecipeItemMaker maker;
        L2RecipeList recipeList = this.getValidRecipeList(player, recipeListId);
        if (recipeList == null) {
            return;
        }
        List<L2RecipeList> dwarfRecipes = Arrays.asList(manufacturer.getDwarvenRecipeBook());
        List<L2RecipeList> commonRecipes = Arrays.asList(manufacturer.getCommonRecipeBook());
        if (!dwarfRecipes.contains(recipeList) && !commonRecipes.contains(recipeList)) {
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false recipe id.", Config.DEFAULT_PUNISH);
            return;
        }
        if (Config.ALT_GAME_CREATION && (maker = _activeMakers.get(manufacturer.getObjectId())) != null) {
            manufacturer.sendPacket(new SystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER).addString(manufacturer.getName()));
            return;
        }
        maker = new RecipeItemMaker(manufacturer, recipeList, player);
        if (maker._isValid) {
            if (Config.ALT_GAME_CREATION) {
                _activeMakers.put(manufacturer.getObjectId(), maker);
                ThreadPoolManager.getInstance().scheduleGeneral(maker, 100L);
            } else {
                maker.run();
            }
        }
    }

    public synchronized void requestMakeItem(L2PcInstance player, int recipeListId) {
        RecipeItemMaker maker;
        if (AttackStanceTaskManager.getInstance().getAttackStanceTask(player) || player.isInDuel()) {
            player.sendPacket(new SystemMessage(SystemMessageId.CANT_OPERATE_PRIVATE_STORE_DURING_COMBAT));
            return;
        }
        L2RecipeList recipeList = this.getValidRecipeList(player, recipeListId);
        if (recipeList == null) {
            return;
        }
        List<L2RecipeList> dwarfRecipes = Arrays.asList(player.getDwarvenRecipeBook());
        List<L2RecipeList> commonRecipes = Arrays.asList(player.getCommonRecipeBook());
        if (!dwarfRecipes.contains(recipeList) && !commonRecipes.contains(recipeList)) {
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false recipe id.", Config.DEFAULT_PUNISH);
            return;
        }
        if (Config.ALT_GAME_CREATION && (maker = _activeMakers.get(player.getObjectId())) != null) {
            SystemMessage sm = new SystemMessage(SystemMessageId.S2_S1);
            sm.addItemName(recipeList.getItemId());
            sm.addString("You are busy creating");
            player.sendPacket(sm);
            return;
        }
        maker = new RecipeItemMaker(player, recipeList, player);
        if (maker._isValid) {
            if (Config.ALT_GAME_CREATION) {
                _activeMakers.put(player.getObjectId(), maker);
                ThreadPoolManager.getInstance().scheduleGeneral(maker, 100L);
            } else {
                maker.run();
            }
        }
    }

    private void loadFromXML() throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        File file = new File(Config.DATAPACK_ROOT + "/data/" + RECIPES_FILE);
        if (file.exists()) {
            Document doc = factory.newDocumentBuilder().parse(file);
            FastList recipePartList = new FastList();
            FastList recipeStatUseList = new FastList();
            FastList recipeAltStatChangeList = new FastList();
            for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
                block5: for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"item".equalsIgnoreCase(d.getNodeName())) continue;
                    recipePartList.clear();
                    recipeStatUseList.clear();
                    recipeAltStatChangeList.clear();
                    NamedNodeMap attrs = d.getAttributes();
                    int id = -1;
                    boolean haveRare = false;
                    StatsSet set = new StatsSet();
                    Node att = attrs.getNamedItem("id");
                    if (att == null) {
                        _log.severe("Missing id for recipe item, skipping");
                        continue;
                    }
                    id = Integer.parseInt(att.getNodeValue());
                    set.set("id", id);
                    att = attrs.getNamedItem("recipeId");
                    if (att == null) {
                        _log.severe("Missing recipeId for recipe item id: " + id + ", skipping");
                        continue;
                    }
                    set.set("recipeId", Integer.parseInt(att.getNodeValue()));
                    att = attrs.getNamedItem("name");
                    if (att == null) {
                        _log.severe("Missing name for recipe item id: " + id + ", skipping");
                        continue;
                    }
                    set.set("recipeName", att.getNodeValue());
                    att = attrs.getNamedItem("craftLevel");
                    if (att == null) {
                        _log.severe("Missing level for recipe item id: " + id + ", skipping");
                        continue;
                    }
                    set.set("craftLevel", Integer.parseInt(att.getNodeValue()));
                    att = attrs.getNamedItem("type");
                    if (att == null) {
                        _log.severe("Missing type for recipe item id: " + id + ", skipping");
                        continue;
                    }
                    set.set("isDwarvenRecipe", att.getNodeValue().equalsIgnoreCase("dwarven"));
                    att = attrs.getNamedItem("successRate");
                    if (att == null) {
                        _log.severe("Missing successRate for recipe item id: " + id + ", skipping");
                        continue;
                    }
                    set.set("successRate", Integer.parseInt(att.getNodeValue()));
                    for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                        int value;
                        String statName;
                        if ("statUse".equalsIgnoreCase(c.getNodeName())) {
                            statName = c.getAttributes().getNamedItem("name").getNodeValue();
                            value = Integer.parseInt(c.getAttributes().getNamedItem("value").getNodeValue());
                            try {
                                recipeStatUseList.add(new L2RecipeStatInstance(statName, value));
                                continue;
                            }
                            catch (Exception e) {
                                _log.severe("Error in StatUse parameter for recipe item id: " + id + ", skipping");
                                continue block5;
                            }
                        }
                        if ("altStatChange".equalsIgnoreCase(c.getNodeName())) {
                            statName = c.getAttributes().getNamedItem("name").getNodeValue();
                            value = Integer.parseInt(c.getAttributes().getNamedItem("value").getNodeValue());
                            try {
                                recipeAltStatChangeList.add(new L2RecipeStatInstance(statName, value));
                                continue;
                            }
                            catch (Exception e) {
                                _log.severe("Error in AltStatChange parameter for recipe item id: " + id + ", skipping");
                                continue block5;
                            }
                        }
                        if ("ingredient".equalsIgnoreCase(c.getNodeName())) {
                            int ingId = Integer.parseInt(c.getAttributes().getNamedItem("id").getNodeValue());
                            int ingCount = Integer.parseInt(c.getAttributes().getNamedItem("count").getNodeValue());
                            recipePartList.add(new L2RecipeInstance(ingId, ingCount));
                            continue;
                        }
                        if ("production".equalsIgnoreCase(c.getNodeName())) {
                            set.set("itemId", Integer.parseInt(c.getAttributes().getNamedItem("id").getNodeValue()));
                            set.set("count", Integer.parseInt(c.getAttributes().getNamedItem("count").getNodeValue()));
                            continue;
                        }
                        if (!"productionRare".equalsIgnoreCase(c.getNodeName())) continue;
                        set.set("rareItemId", Integer.parseInt(c.getAttributes().getNamedItem("id").getNodeValue()));
                        set.set("rareCount", Integer.parseInt(c.getAttributes().getNamedItem("count").getNodeValue()));
                        set.set("rarity", Integer.parseInt(c.getAttributes().getNamedItem("rarity").getNodeValue()));
                        haveRare = true;
                    }
                    L2RecipeList recipeList = new L2RecipeList(set, haveRare);
                    for (L2RecipeInstance recipePart : recipePartList) {
                        recipeList.addRecipe(recipePart);
                    }
                    for (L2RecipeStatInstance recipeStatUse : recipeStatUseList) {
                        recipeList.addStatUse(recipeStatUse);
                    }
                    for (L2RecipeStatInstance recipeAltStatChange : recipeAltStatChangeList) {
                        recipeList.addAltStatChange(recipeAltStatChange);
                    }
                    this._lists.put(id, recipeList);
                }
            }
        } else {
            _log.severe("Recipes file (" + file.getAbsolutePath() + ") doesnt exists.");
        }
    }

    private L2RecipeList getValidRecipeList(L2PcInstance player, int id) {
        L2RecipeList recipeList = this.getRecipeList(id);
        if (recipeList == null || recipeList.getRecipes().length == 0) {
            player.sendMessage("No recipe for: " + id);
            player.isInCraftMode(false);
            return null;
        }
        return recipeList;
    }

    private static class SingletonHolder {
        protected static final RecipeController _instance = new RecipeController();

        private SingletonHolder() {
        }
    }

    private class RecipeItemMaker
    implements Runnable {
        protected boolean _isValid;
        protected List<TempItem> _items = null;
        protected final L2RecipeList _recipeList;
        protected final L2PcInstance _player;
        protected final L2PcInstance _target;
        protected final L2Skill _skill;
        protected final int _skillId;
        protected final int _skillLevel;
        protected int _creationPasses = 1;
        protected int _itemGrab;
        protected int _exp = -1;
        protected int _sp = -1;
        protected long _price;
        protected int _totalItems;
        protected int _materialsRefPrice;
        protected int _delay;

        public RecipeItemMaker(L2PcInstance pPlayer, L2RecipeList pRecipeList, L2PcInstance pTarget) {
            this._player = pPlayer;
            this._target = pTarget;
            this._recipeList = pRecipeList;
            this._isValid = false;
            this._skillId = this._recipeList.isDwarvenRecipe() ? 172 : 1320;
            this._skillLevel = this._player.getSkillLevel(this._skillId);
            this._skill = this._player.getKnownSkill(this._skillId);
            this._player.isInCraftMode(true);
            if (this._player.isAlikeDead()) {
                this._player.sendPacket(ActionFailed.STATIC_PACKET);
                this.abort();
                return;
            }
            if (this._target.isAlikeDead()) {
                this._target.sendPacket(ActionFailed.STATIC_PACKET);
                this.abort();
                return;
            }
            if (this._target.isProcessingTransaction()) {
                this._target.sendPacket(ActionFailed.STATIC_PACKET);
                this.abort();
                return;
            }
            if (this._player.isProcessingTransaction()) {
                this._player.sendPacket(ActionFailed.STATIC_PACKET);
                this.abort();
                return;
            }
            if (this._recipeList.getRecipes().length == 0) {
                this._player.sendPacket(ActionFailed.STATIC_PACKET);
                this.abort();
                return;
            }
            if (this._recipeList.getLevel() > this._skillLevel) {
                this._player.sendPacket(ActionFailed.STATIC_PACKET);
                this.abort();
                return;
            }
            if (this._player != this._target) {
                for (L2ManufactureItem temp : this._player.getCreateList().getList()) {
                    if (temp.getRecipeId() != this._recipeList.getId()) continue;
                    this._price = temp.getCost();
                    if (this._target.getAdena() >= this._price) break;
                    this._target.sendPacket(new SystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA));
                    this.abort();
                    return;
                }
            }
            if ((this._items = this.listItems(false)) == null) {
                this.abort();
                return;
            }
            for (TempItem i : this._items) {
                this._materialsRefPrice += i.getReferencePrice() * i.getQuantity();
                this._totalItems += i.getQuantity();
            }
            if (!this.calculateStatUse(false, false)) {
                this.abort();
                return;
            }
            if (Config.ALT_GAME_CREATION) {
                this.calculateAltStatChange();
            }
            this.updateMakeInfo(true);
            this.updateCurMp();
            this.updateCurLoad();
            this._player.isInCraftMode(false);
            this._isValid = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!Config.IS_CRAFTING_ENABLED) {
                this._target.sendMessage("Item creation is currently disabled.");
                this.abort();
                return;
            }
            if (this._player == null || this._target == null) {
                _log.warning("player or target == null (disconnected?), aborting" + this._target + this._player);
                this.abort();
                return;
            }
            if (this._player.isOnline() == 0 || this._target.isOnline() == 0) {
                _log.warning("player or target is not online, aborting " + this._target + this._player);
                this.abort();
                return;
            }
            if (Config.ALT_GAME_CREATION && _activeMakers.get(this._player.getObjectId()) == null) {
                if (this._target != this._player) {
                    this._target.sendMessage("Manufacture aborted");
                    this._player.sendMessage("Manufacture aborted");
                } else {
                    this._player.sendMessage("Item creation aborted");
                }
                this.abort();
                return;
            }
            if (Config.ALT_GAME_CREATION && !this._items.isEmpty()) {
                if (!this.calculateStatUse(true, true)) {
                    return;
                }
                this.updateCurMp();
                this.grabSomeItems();
                if (!this._items.isEmpty()) {
                    this._delay = (int)(Config.ALT_GAME_CREATION_SPEED * this._player.getMReuseRate(this._skill) * 10.0 / (double)Config.RATE_CONSUMABLE_COST) * 100;
                    MagicSkillUse msk = new MagicSkillUse(this._player, this._skillId, this._skillLevel, this._delay, 0);
                    this._player.broadcastPacket(msk);
                    this._player.sendPacket(new SetupGauge(0, this._delay));
                    ThreadPoolManager.getInstance().scheduleGeneral(this, 100 + this._delay);
                } else {
                    this._player.sendPacket(new SetupGauge(0, this._delay));
                    try {
                        Thread.sleep(this._delay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        this.finishCrafting();
                    }
                }
            } else {
                this.finishCrafting();
            }
        }

        private void finishCrafting() {
            L2ItemInstance adenatransfer;
            if (!Config.ALT_GAME_CREATION) {
                this.calculateStatUse(false, true);
            }
            if (this._target != this._player && this._price > 0L && (adenatransfer = this._target.transferItem("PayManufacture", this._target.getInventory().getAdenaInstance().getObjectId(), this._price, this._player.getInventory(), this._player)) == null) {
                this._target.sendPacket(new SystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA));
                this.abort();
                return;
            }
            this._items = this.listItems(true);
            if (this._items != null) {
                if (Rnd.get(100) < this._recipeList.getSuccessRate()) {
                    this.rewardPlayer();
                    this.updateMakeInfo(true);
                } else {
                    if (this._target != this._player) {
                        SystemMessage msg = new SystemMessage(SystemMessageId.CREATION_OF_S2_FOR_C1_AT_S3_ADENA_FAILED);
                        msg.addString(this._target.getName());
                        msg.addItemName(this._recipeList.getItemId());
                        msg.addItemNumber(this._price);
                        this._player.sendPacket(msg);
                        msg = new SystemMessage(SystemMessageId.C1_FAILED_TO_CREATE_S2_FOR_S3_ADENA);
                        msg.addString(this._player.getName());
                        msg.addItemName(this._recipeList.getItemId());
                        msg.addItemNumber(this._price);
                        this._target.sendPacket(msg);
                    } else {
                        this._player.sendPacket(new SystemMessage(SystemMessageId.S1_MANUFACTURE_FAILURE).addItemName(this._recipeList.getItemId()));
                    }
                    this.updateMakeInfo(false);
                }
            }
            this.updateCurMp();
            this.updateCurLoad();
            _activeMakers.remove(this._player.getObjectId());
            this._player.isInCraftMode(false);
            this._target.sendPacket(new ItemList(this._target, false));
        }

        private void updateMakeInfo(boolean success) {
            if (this._target == this._player) {
                this._target.sendPacket(new RecipeItemMakeInfo(this._recipeList.getId(), this._target, success));
            } else {
                this._target.sendPacket(new RecipeShopItemInfo(this._player.getObjectId(), this._recipeList.getId()));
            }
        }

        private void updateCurLoad() {
            StatusUpdate su = new StatusUpdate(this._target.getObjectId());
            su.addAttribute(14, this._target.getCurrentLoad());
            this._target.sendPacket(su);
        }

        private void updateCurMp() {
            StatusUpdate su = new StatusUpdate(this._target.getObjectId());
            su.addAttribute(11, (int)this._target.getCurrentMp());
            this._target.sendPacket(su);
        }

        private void grabSomeItems() {
            int count;
            for (int grabItems = this._itemGrab; grabItems > 0 && !this._items.isEmpty(); grabItems -= count) {
                TempItem item = this._items.get(0);
                count = item.getQuantity();
                if (count >= grabItems) {
                    count = grabItems;
                }
                item.setQuantity(item.getQuantity() - count);
                if (item.getQuantity() <= 0) {
                    this._items.remove(0);
                } else {
                    this._items.set(0, item);
                }
                if (this._target == this._player) {
                    SystemMessage sm = new SystemMessage(SystemMessageId.S1_S2_EQUIPPED);
                    sm.addItemNumber(count);
                    sm.addItemName(item.getItemId());
                    this._player.sendPacket(sm);
                    continue;
                }
                this._target.sendMessage("Manufacturer " + this._player.getName() + " used " + count + " " + item.getItemName());
            }
        }

        private void calculateAltStatChange() {
            this._itemGrab = this._skillLevel;
            for (L2RecipeStatInstance altStatChange : this._recipeList.getAltStatChange()) {
                if (altStatChange.getType() == L2RecipeStatInstance.StatType.XP) {
                    this._exp = altStatChange.getValue();
                    continue;
                }
                if (altStatChange.getType() == L2RecipeStatInstance.StatType.SP) {
                    this._sp = altStatChange.getValue();
                    continue;
                }
                if (altStatChange.getType() != L2RecipeStatInstance.StatType.GIM) continue;
                this._itemGrab *= altStatChange.getValue();
            }
            this._creationPasses = this._totalItems / this._itemGrab + (this._totalItems % this._itemGrab != 0 ? 1 : 0);
            if (this._creationPasses < 1) {
                this._creationPasses = 1;
            }
        }

        private boolean calculateStatUse(boolean isWait, boolean isReduce) {
            boolean ret = true;
            for (L2RecipeStatInstance statUse : this._recipeList.getStatUse()) {
                double modifiedValue = statUse.getValue() / this._creationPasses;
                if (statUse.getType() == L2RecipeStatInstance.StatType.HP) {
                    if (this._player.getCurrentHp() <= modifiedValue) {
                        if (Config.ALT_GAME_CREATION && isWait) {
                            this._player.sendPacket(new SetupGauge(0, this._delay));
                            ThreadPoolManager.getInstance().scheduleGeneral(this, 100 + this._delay);
                        } else {
                            this._target.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_HP));
                            this.abort();
                        }
                        ret = false;
                        continue;
                    }
                    if (!isReduce) continue;
                    this._player.reduceCurrentHp(modifiedValue, this._player, this._skill);
                    continue;
                }
                if (statUse.getType() == L2RecipeStatInstance.StatType.MP) {
                    if (this._player.getCurrentMp() < modifiedValue) {
                        if (Config.ALT_GAME_CREATION && isWait) {
                            this._player.sendPacket(new SetupGauge(0, this._delay));
                            ThreadPoolManager.getInstance().scheduleGeneral(this, 100 + this._delay);
                        } else {
                            this._target.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_MP));
                            this.abort();
                        }
                        ret = false;
                        continue;
                    }
                    if (!isReduce) continue;
                    this._player.reduceCurrentMp(modifiedValue);
                    continue;
                }
                this._target.sendMessage("Recipe error!!!, please tell this to your GM.");
                ret = false;
                this.abort();
            }
            return ret;
        }

        private List<TempItem> listItems(boolean remove) {
            L2RecipeInstance[] recipes = this._recipeList.getRecipes();
            PcInventory inv = this._target.getInventory();
            FastList materials = new FastList();
            for (L2RecipeInstance recipe : recipes) {
                long itemQuantityAmount;
                int quantity;
                int n = quantity = this._recipeList.isConsumable() ? (int)((float)recipe.getQuantity() * Config.RATE_CONSUMABLE_COST) : recipe.getQuantity();
                if (quantity <= 0) continue;
                L2ItemInstance item = inv.getItemByItemId(recipe.getItemId());
                long l = itemQuantityAmount = item == null ? 0L : item.getCount();
                if (itemQuantityAmount < (long)quantity) {
                    SystemMessage sm = new SystemMessage(SystemMessageId.MISSING_S2_S1_TO_CREATE);
                    sm.addItemName(recipe.getItemId());
                    sm.addItemNumber((long)quantity - itemQuantityAmount);
                    this._target.sendPacket(sm);
                    this.abort();
                    return null;
                }
                TempItem temp = new TempItem(item, quantity);
                materials.add(temp);
            }
            if (remove) {
                for (TempItem tmp : materials) {
                    ((ItemContainer)inv).destroyItemByItemId("Manufacture", tmp.getItemId(), tmp.getQuantity(), this._target, this._player);
                    SystemMessage sm = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                    sm.addItemName(tmp.getItemId());
                    sm.addItemNumber(tmp.getQuantity());
                    this._target.sendPacket(sm);
                }
            }
            return materials;
        }

        private void abort() {
            this.updateMakeInfo(false);
            this._player.isInCraftMode(false);
            _activeMakers.remove(this._player.getObjectId());
        }

        private void rewardPlayer() {
            int rareProdId = this._recipeList.getRareItemId();
            int itemId = this._recipeList.getItemId();
            int itemCount = this._recipeList.getCount();
            L2Item template = ItemTable.getInstance().getTemplate(itemId);
            if (rareProdId != -1 && (rareProdId == itemId || Config.CRAFT_MASTERWORK) && Rnd.get(100) < this._recipeList.getRarity()) {
                itemId = rareProdId;
                itemCount = this._recipeList.getRareCount();
            }
            this._target.getInventory().addItem("Manufacture", itemId, itemCount, this._target, this._player);
            SystemMessage sm = null;
            if (this._target != this._player) {
                if (itemCount == 1) {
                    sm = new SystemMessage(SystemMessageId.S2_CREATED_FOR_C1_FOR_S3_ADENA);
                    sm.addString(this._target.getName());
                    sm.addItemName(itemId);
                    sm.addItemNumber(this._price);
                    this._player.sendPacket(sm);
                    sm = new SystemMessage(SystemMessageId.C1_CREATED_S2_FOR_S3_ADENA);
                    sm.addString(this._player.getName());
                    sm.addItemName(itemId);
                    sm.addItemNumber(this._price);
                    this._target.sendPacket(sm);
                } else {
                    sm = new SystemMessage(SystemMessageId.S2_S3_S_CREATED_FOR_C1_FOR_S4_ADENA);
                    sm.addString(this._target.getName());
                    sm.addNumber(itemCount);
                    sm.addItemName(itemId);
                    sm.addItemNumber(this._price);
                    this._player.sendPacket(sm);
                    sm = new SystemMessage(SystemMessageId.C1_CREATED_S2_S3_S_FOR_S4_ADENA);
                    sm.addString(this._player.getName());
                    sm.addNumber(itemCount);
                    sm.addItemName(itemId);
                    sm.addItemNumber(this._price);
                    this._target.sendPacket(sm);
                }
            }
            if (itemCount > 1) {
                sm = new SystemMessage(SystemMessageId.EARNED_S2_S1_S);
                sm.addItemName(itemId);
                sm.addItemNumber(itemCount);
                this._target.sendPacket(sm);
            } else {
                sm = new SystemMessage(SystemMessageId.EARNED_ITEM);
                sm.addItemName(itemId);
                this._target.sendPacket(sm);
            }
            if (Config.ALT_GAME_CREATION) {
                int recipeLevel = this._recipeList.getLevel();
                if (this._exp < 0) {
                    this._exp = template.getReferencePrice() * itemCount;
                    this._exp /= recipeLevel;
                }
                if (this._sp < 0) {
                    this._sp = this._exp / 10;
                }
                if (itemId == rareProdId) {
                    this._exp = (int)((double)this._exp * Config.ALT_GAME_CREATION_RARE_XPSP_RATE);
                    this._sp = (int)((double)this._sp * Config.ALT_GAME_CREATION_RARE_XPSP_RATE);
                }
                if (this._exp < 0) {
                    this._exp = 0;
                }
                if (this._sp < 0) {
                    this._sp = 0;
                }
                for (int i = this._skillLevel; i > recipeLevel; --i) {
                    this._exp /= 4;
                    this._sp /= 4;
                }
                this._player.addExpAndSp((int)this._player.calcStat(Stats.EXPSP_RATE, (double)this._exp * Config.ALT_GAME_CREATION_XP_RATE * Config.ALT_GAME_CREATION_SPEED, null, null), (int)this._player.calcStat(Stats.EXPSP_RATE, (double)this._sp * Config.ALT_GAME_CREATION_SP_RATE * Config.ALT_GAME_CREATION_SPEED, null, null));
            }
            this.updateMakeInfo(true);
        }

        private class TempItem {
            private int _itemId;
            private int _quantity;
            private int _ownerId;
            private int _referencePrice;
            private String _itemName;

            public TempItem(L2ItemInstance item, int quantity) {
                this._itemId = item.getItemId();
                this._quantity = quantity;
                this._ownerId = item.getOwnerId();
                this._itemName = item.getItem().getName();
                this._referencePrice = item.getReferencePrice();
            }

            public int getQuantity() {
                return this._quantity;
            }

            public void setQuantity(int quantity) {
                this._quantity = quantity;
            }

            public int getReferencePrice() {
                return this._referencePrice;
            }

            public int getItemId() {
                return this._itemId;
            }

            public int getOwnerId() {
                return this._ownerId;
            }

            public String getItemName() {
                return this._itemName;
            }
        }
    }
}

